'$DYNAMIC
'$INCLUDE: 'MGPLib.bi'
DECLARE SUB Help ()
DECLARE SUB GameEnding ()
DECLARE SUB LoadGeneralData ()
DECLARE SUB SetMainPalette ()
DECLARE SUB DrawField ()
DECLARE SUB LoadField ()
DECLARE SUB InitMove (Creature AS ANY, dx AS INTEGER, dy AS INTEGER)
DECLARE SUB ControlEnemies ()
DECLARE SUB Quit ()
DECLARE SUB PlayGame ()
DECLARE SUB Intro ()
DECLARE SUB Menu ()
DECLARE SUB MakeMoves ()
DECLARE SUB Options ()
DECLARE SUB Flash (n AS INTEGER)

'subs en functies uit Scrolllie.bas
DECLARE SUB FadeOut2 ()
DECLARE SUB GetFontData ()
DECLARE SUB ScrollText (ScrollMessage$, y0 AS INTEGER)
DECLARE SUB ScreenEffect (n AS INTEGER)

'subs en functies uit Text13.bas
DECLARE SUB TextBox (t$, x%, y%, kl%)
DECLARE SUB ExchangeFont (FONTtoLOAD$)
DECLARE SUB WriteText (Text$, x%, y%, Col%)
DECLARE SUB PsetText (Text$, x%, y%, ColFor%, ColBack%)
DECLARE FUNCTION TextSize% (Text$)
DECLARE SUB DrawButton (x%, y%, Breedte%, Hoogte%, Status%)
DECLARE SUB TextButton (x%, y%, t$, Status%)
DECLARE FUNCTION Choise% (x%, y%, PickList$)

CONST TRUE = -1
CONST FALSE = 0

'scancodes of most used keys
CONST Down = 80, Up = 72, PgDwn = 81, PgUp = 73, Home = 71, EndLn = 79
CONST Left = 75, Right = 77, Enter = 28, Esc = 1, Sp = 57, Tb = 15, Ctrl = 29
CONST Alt = 56, LeftShift = 42, RightShift = 54, Insert = 82, Delete = 83
CONST BackSpace = 14, F1 = 59, F2 = 60, F3 = 61, F4 = 62, F5 = 63, F6 = 64
CONST F7 = 65, F8 = 66, F9 = 67, F10 = 68, F11 = 87, F12 = 88

CONST XBlockSize = 10
CONST YBlockSize = 10
CONST XMinBlockScreen = 2
CONST YMinBlockScreen = 2
CONST XMaxBlockScreen = 30
CONST YMaxBlockScreen = 18
CONST DataBytesBlk = XBlockSize * YBlockSize
CONST RealBytesBlk = XBlockSize * YBlockSize + 4
CONST RealWordsBlk = RealBytesBlk \ 2

CONST TotalBlkSorts = 21
CONST MaxMovEnemies = 20
CONST BeginLives = 5
CONST StndPsychoTime = 900

TYPE BlockType
   PacSolid AS INTEGER     'Boolean :  TRUE | rigid block | Pacman can't go trough
                           '           FALSE | open block | Pacman can go trough this
   EnSolid AS INTEGER   ' can enemies go through ?
   GrabIt AS INTEGER    'Boolean :  TRUE | block is an item that has to be picked up
END TYPE

TYPE MovingCreature
   Active AS INTEGER  'Boolean :  TRUE | MovingCreature is actief
                      '           FALSE | MovingCreature is "dood"
   Player AS INTEGER  'Boolean :  TRUE | MovingCreature bestuurd door speler
                      '           FALSE | computer bestuurt MovingCreature
   Species AS INTEGER 'sort of Creature
   xBlk AS INTEGER
   yBlk AS INTEGER
   CurDir AS INTEGER    'huidige richting waarin Creature zich beweegt
   PrevDir AS INTEGER   'vorige richting waarin Creature zich bewoog
   Moving AS INTEGER    'Boolean :  TRUE | MovingCreature is in beweging
                        '           FALSE | MovingCreature staat stil
   MovCnt AS INTEGER    ' "pixel"afstandcounter vanaf vorige blokpositie
END TYPE

TYPE Level
  file AS STRING * 11
  TotGrabIts AS INTEGER
  GrabbedItems AS INTEGER
END TYPE

DIM ControlMode AS INTEGER  '= 0 : move pacman yourself
                            '= 1 : pacman walks in a direction as long as possible
DIM BlkProps(0 TO TotalBlkSorts) AS BlockType
DIM BlkSpr(0 TO RealWordsBlk - 1, 0 TO TotalBlkSorts) AS INTEGER
DIM PacField(XMinBlockScreen TO XMaxBlockScreen, YMinBlockScreen TO YMaxBlockScreen) AS INTEGER
DIM MovCreatureSpr(0 TO RealWordsBlk - 1, 1 TO 4, 1 TO 40) AS INTEGER
'   \ d1:data/d2:richtingen/d3:soort
'    \soort 1: pacman met open bek| soort 11: pacman met gesloten bek

DIM PacMan AS MovingCreature
DIM MovEnemies(1 TO MaxMovEnemies) AS MovingCreature
DIM Levels(1 TO 10) AS Level
DIM TotalMovEnemies AS INTEGER
DIM TotalLevels AS INTEGER
DIM CurrentLevel AS INTEGER
DIM PsychoTime AS INTEGER   'Boolean :  TRUE | pacman kan enemies aan
                            '           FALSE| pacman dood als enemy hem raakt
DIM FlashCnt AS INTEGER
DIM LevelDone AS INTEGER
DIM GameDone AS INTEGER
DIM Lifes AS INTEGER
DIM Score AS INTEGER
DIM GameSpeed AS INTEGER
    GameSpeed = 3    'gemiddelde snelheid
DIM BackGround(0 TO 32001) AS INTEGER

DIM DxDir(1 TO 4) AS INTEGER, DyDir(1 TO 4) AS INTEGER
    DxDir(1) = 0: DyDir(1) = -1
    DxDir(2) = 1: DyDir(2) = 0
    DxDir(3) = 0: DyDir(3) = 1
    DxDir(4) = -1: DyDir(4) = 0
DIM OppositeOfDir(0 TO 4) AS INTEGER
    OppositeOfDir(1) = 3
    OppositeOfDir(2) = 4
    OppositeOfDir(3) = 1
    OppositeOfDir(4) = 2


SCREEN 13
RANDOMIZE TIMER

 LoadGeneralData
 Intro

 DO
   Menu
 LOOP

REM $STATIC
SUB ControlEnemies
 SHARED PacField() AS INTEGER
 SHARED MovEnemies() AS MovingCreature
 SHARED BlkProps() AS BlockType
 SHARED DxDir() AS INTEGER, DyDir() AS INTEGER
 SHARED OppositeOfDir() AS INTEGER
 SHARED TotalMovEnemies AS INTEGER
        
  DIM n AS INTEGER
  DIM OpenSide(0 TO 4) AS INTEGER
  DIM DirChosen AS INTEGER
  DIM TotalOpenSides AS INTEGER
 

  FOR n = 1 TO TotalMovEnemies
                     
   IF MovEnemies(n).Active AND (NOT MovEnemies(n).Player) THEN  'MovEnemies van computer
      TotalOpenSides = 0

      IF MovEnemies(n).yBlk > YMinBlockScreen THEN
        IF NOT BlkProps(PacField(MovEnemies(n).xBlk, MovEnemies(n).yBlk - 1)).EnSolid THEN
            OpenSide(1) = TRUE
            TotalOpenSides = TotalOpenSides + 1
        END IF
      END IF
      IF MovEnemies(n).xBlk < XMaxBlockScreen THEN
        IF NOT BlkProps(PacField(MovEnemies(n).xBlk + 1, MovEnemies(n).yBlk)).EnSolid THEN
            OpenSide(2) = TRUE
            TotalOpenSides = TotalOpenSides + 1
        END IF
      END IF
      IF MovEnemies(n).yBlk < YMaxBlockScreen THEN
        IF NOT BlkProps(PacField(MovEnemies(n).xBlk, MovEnemies(n).yBlk + 1)).EnSolid THEN
            OpenSide(3) = TRUE
            TotalOpenSides = TotalOpenSides + 1
        END IF
      END IF
      IF MovEnemies(n).xBlk > XMinBlockScreen THEN
        IF NOT BlkProps(PacField(MovEnemies(n).xBlk - 1, MovEnemies(n).yBlk)).EnSolid THEN
            OpenSide(4) = TRUE
            TotalOpenSides = TotalOpenSides + 1
        END IF
      END IF
   
      'prevent random behaviour of pacman's enemies
      DO
        DirChosen = INT(1 + RND * 4)
        IF OpenSide(DirChosen) THEN
          IF (DirChosen = OppositeOfDir(MovEnemies(n).PrevDir)) THEN
              IF TotalOpenSides = 1 THEN EXIT DO
            ELSE
              EXIT DO
          END IF
        END IF
      LOOP
     
     
      InitMove MovEnemies(n), DxDir(DirChosen), DyDir(DirChosen)
     
      OpenSide(1) = FALSE: OpenSide(2) = FALSE: OpenSide(3) = FALSE: OpenSide(4) = FALSE
   
   END IF
  NEXT n


END SUB

SUB DrawField
 SHARED PacField() AS INTEGER
 SHARED BlkSpr() AS INTEGER
 SHARED PacMan AS MovingCreature
 SHARED MovEnemies() AS MovingCreature
 SHARED MovCreatureSpr() AS INTEGER
 SHARED Lifes AS INTEGER
 SHARED Score AS INTEGER
 SHARED Levels() AS Level
 SHARED CurrentLevel AS INTEGER
 SHARED TotalMovEnemies AS INTEGER

 DIM xb AS INTEGER
 DIM yb AS INTEGER
 DIM x AS INTEGER
 DIM y AS INTEGER
 DIM n AS INTEGER


  y = (YMinBlockScreen - 2) * YBlockSize
  FOR yb = YMinBlockScreen TO YMaxBlockScreen
    y = y + YBlockSize
    x = (XMinBlockScreen - 2) * XBlockSize
    FOR xb = XMinBlockScreen TO XMaxBlockScreen
        x = x + XBlockSize
        PsetSprite x, y, BlkSpr(0, PacField(xb, yb))
    NEXT xb
  NEXT yb
 
  PutSprite ((PacMan.xBlk - 1) * XBlockSize), (PacMan.yBlk - 1) * YBlockSize, MovCreatureSpr(0, 1, PacMan.Species)
  
  FOR n = 1 TO TotalMovEnemies
     IF MovEnemies(n).Active THEN
        PutSprite ((MovEnemies(n).xBlk - 1) * XBlockSize), (MovEnemies(n).yBlk - 1) * YBlockSize, MovCreatureSpr(0, 1, MovEnemies(n).Species)
     END IF
  NEXT n

  PutSprite 10, 190, MovCreatureSpr(0, 2, 1)
  WriteText "X" + STR$(Lifes), 25, 190, 14
  DrawButton 145, 190, 30, 10, 0
  WriteText STR$(Score), 145, 190, 0
  'WriteText STR$(Levels(CurrentLevel).GrabbedItems) + "/" + STR$(Levels(CurrentLevel).TotGrabIts), 0, 0, 14
 
END SUB

SUB Flash (n AS INTEGER)
 SHARED PacField() AS INTEGER
 SHARED BlkSpr() AS INTEGER
 SHARED PacMan AS MovingCreature
 SHARED LevelFailed AS INTEGER

 DIM xb AS INTEGER
 DIM yb AS INTEGER
 DIM x AS INTEGER
 DIM y AS INTEGER

 IF n = 1 THEN   'flash on
  y = (YMinBlockScreen - 2) * YBlockSize
  FOR yb = YMinBlockScreen TO YMaxBlockScreen
    y = y + YBlockSize
    x = (XMinBlockScreen - 2) * XBlockSize
    FOR xb = XMinBlockScreen TO XMaxBlockScreen
        x = x + XBlockSize
        IF PacField(xb, yb) = 21 THEN
            PacField(xb, yb) = 18
            PsetSprite x, y, BlkSpr(0, PacField(xb, yb))
            IF PacMan.xBlk = xb AND PacMan.yBlk = yb THEN LevelFailed = TRUE
        END IF
    NEXT xb
  NEXT yb

 ELSEIF n = 0 THEN  'flash out
 
  y = (YMinBlockScreen - 2) * YBlockSize
  FOR yb = YMinBlockScreen TO YMaxBlockScreen
    y = y + YBlockSize
    x = (XMinBlockScreen - 2) * XBlockSize
    FOR xb = XMinBlockScreen TO XMaxBlockScreen
        x = x + XBlockSize
        IF PacField(xb, yb) = 18 THEN
            PacField(xb, yb) = 21
            PsetSprite x, y, BlkSpr(0, PacField(xb, yb))
        END IF
    NEXT xb
  NEXT yb

 END IF

END SUB

SUB GameEnding   'lousy end

 DIM VirScr(32001), t$, n AS INTEGER, m AS INTEGER


 DO: LOOP UNTIL INKEY$ = ""

 ExchangeFont "dragon"
 t$ = "THIS IS EARTHSHOCKING !"
 WriteText t$, 59, 69, 0
 WriteText t$, 60, 70, 15
 WriteText t$, 61, 71, 15
 GetSprite 0, 0, 319, 199, VirScr(0)
 DO
    PsetSprite -1, -1, VirScr(0)
    PsetSprite 1, -1, VirScr(0)
    PsetSprite 1, 1, VirScr(0)
    PsetSprite -1, 1, VirScr(0)
 LOOP UNTIL INKEY$ <> ""
 PsetSprite 0, 0, VirScr(0)
 ERASE VirScr
 ExchangeFont "scr13"
 t$ = "YOU ACTUALLY TOOK THE TIME TO PLAY THIS GAME !"
 WriteText t$, 24, 84, 0
 WriteText t$, 25, 85, 15
 WriteText t$, 26, 86, 15
 FOR n = 1 TO 150
    RetraceWait
    IF INKEY$ <> "" THEN EXIT FOR
 NEXT n
 ScreenEffect 4
 ExchangeFont "dragon"
 t$ = "From now on you'll be addressed to as"
 WriteText t$, 10, 60, 4
 WriteText t$, 11, 61, 15
 t$ = "MASTER OF THE PACMAN LEGENDS"
 WriteText t$, 50, 85, 4
 WriteText t$, 51, 86, 15
 t$ = ""
 WriteText t$, 50, 96, 4
 WriteText t$, 51, 97, 15

 FOR n = 1 TO 250: RetraceWait: NEXT n
 FadeOut2
 CLS
 t$ = "YOU HAVE FOUGHT HARD FOR THIS TITLE.`WEAR IT WITH THE PROUD AND BRAVENESS"
 t$ = t$ + "`   YOU HAVE PROVEN TO POSESS.``    YOU HAVE A LONG WAY AHEAD.`IN THE STARS IS WRITTEN THAT YOU ARE`PREDESTINED TO REACH THINGS THOUGHT`      IMPOSSIBLE FOR A MAN```     BUT THAT IS ANOTHER STORY`         FOR ANOTHER TIME .."
 TextBox t$, 10, 2, 15
 FOR n = 1 TO 25: RetraceWait: NEXT
 FOR n = 0 TO 63: SetPal 15, n, n, n: RetraceWait: RetraceWait: RetraceWait: NEXT
 DO: LOOP UNTIL INKEY$ = ""
 DO: LOOP UNTIL INKEY$ <> ""
 FOR n = 63 TO 0 STEP -1: SetPal 15, n, n, n: RetraceWait: RetraceWait: RetraceWait: NEXT
 SCREEN 0
 WIDTH 80, 25
 END


END SUB

SUB Help
 SHARED BlkSpr() AS INTEGER
 DIM t$, n AS INTEGER
 
  ExchangeFont "scr13"
  FillBar 0, 0, 320, 200, 0
  SetPal 0, 0, 10, 0
  t$ = "THE OBJECT OF THE GAME IS TO PICK UP": n = TextSize%(t$)
  WriteText t$, 160 - n \ 2, 30, 15
  t$ = "ALL ITEMS THAT LOOK LIKE THIS :": n = TextSize%(t$)
  WriteText t$, 160 - n \ 2, 38, 15
  PutSprite 128, 50, BlkSpr(0, 12)
  PutSprite 155, 50, BlkSpr(0, 13)
  PutSprite 182, 50, BlkSpr(0, 16)
  t$ = "OR"
  WriteText t$, 142, 50, 15
  WriteText t$, 168, 50, 15
  t$ = "YOU CAN DO THIS BY MOVING PACMAN WITH THE CURSORKEYS": n = TextSize%(t$)
  WriteText t$, 160 - n \ 2, 62, 15
  t$ = "PACMAN WILL SHORTLY GO BERSERK IF YOU PICK UP  ": n = TextSize%(t$)
  WriteText t$, 160 - n \ 2, 71, 15
  PutSprite 150 + n \ 2, 71, BlkSpr(0, 13)
  t$ = "WHICH MEANS THAT YOU CAN EAT MONSTERS": n = TextSize%(t$)
  WriteText t$, 160 - n \ 2, 81, 15
  t$ = "WHICH IS INDICATED BY GLOWING MONSTERS": n = TextSize%(t$)
  WriteText t$, 160 - n \ 2, 91, 15
  t$ = "PACMAN WILL BE TELEPORTED IF HE STEPS ON  ": n = TextSize%(t$)
  WriteText t$, 160 - n \ 2, 104, 15
  PutSprite 150 + n \ 2, 103, BlkSpr(0, 17)
  t$ = "TELEPORTATION BRINGS PACMAN TO A (OTHER) TELEPORTER": n = TextSize%(t$)
  WriteText t$, 160 - n \ 2, 114, 15
  t$ = "STEPPING ON A CROSS   THAT LIGHTS UP WILL KILL PACMAN": n = TextSize%(t$)
  WriteText t$, 160 - n \ 2, 128, 15
  PutSprite 118, 127, BlkSpr(0, 18)
  t$ = "UNLESS HE'S GOING BERSERK": n = TextSize%(t$)
  WriteText t$, 160 - n \ 2, 138, 15

  t$ = "<PRESS ANY KEY TO FOR NEXT PAGE>": n = TextSize%(t$)
  WriteText t$, 160 - n \ 2, 188, 7
  DO: LOOP UNTIL INKEY$ = ""
  DO: LOOP UNTIL INKEY$ <> ""

  FillBar 0, 0, 320, 200, 0
  t$ = "DURING THE GAME YOU CAN CHANGE THE WAY YOU": n = TextSize%(t$)
  WriteText t$, 160 - n \ 2, 30, 15
  t$ = "CONTROL PACMAN BY PRESSING ENTER": n = TextSize%(t$)
  WriteText t$, 160 - n \ 2, 40, 15
  t$ = "THE FIRST MODE : YOU HAVE TO KEEP PRESSING THE": n = TextSize%(t$)
  WriteText t$, 160 - n \ 2, 50, 15
  t$ = "DIRECTIONAL KEYS CONTINUALLY": n = TextSize%(t$)
  WriteText t$, 160 - n \ 2, 60, 15
  t$ = "THE SECOND MODE : YOU ONLY HAVE TO PRESS A KEY ONCE,": n = TextSize%(t$)
  WriteText t$, 160 - n \ 2, 70, 15
  t$ = "PACMAN WILL WALK ON AS LONG AS POSSIBLE OR UNTIL YOU": n = TextSize%(t$)
  WriteText t$, 160 - n \ 2, 80, 15
  t$ = "PRESS SPACE TO STOP HIM OR CHANGE HIS DIRECTION BY": n = TextSize%(t$)
  WriteText t$, 160 - n \ 2, 90, 15
  t$ = "PRESSING A DIRECTIONAL KEY": n = TextSize%(t$)
  WriteText t$, 160 - n \ 2, 100, 15
  
  t$ = "<PRESS ANY KEY TO RETURN TO MAIN MENU>": n = TextSize%(t$)
  WriteText t$, 160 - n \ 2, 188, 7
  DO: LOOP UNTIL INKEY$ = ""
  DO: LOOP UNTIL INKEY$ <> ""

END SUB

SUB InitMove (Creature AS MovingCreature, dx AS INTEGER, dy AS INTEGER)
 
 SHARED BlkProps() AS BlockType
 SHARED MovCreatureSpr() AS INTEGER
 SHARED PacField() AS INTEGER
 SHARED BlkSpr() AS INTEGER
 SHARED PacMan AS MovingCreature
 SHARED MovEnemies() AS MovingCreature
 SHARED DxDir() AS INTEGER, DyDir() AS INTEGER
 SHARED LevelFailed AS INTEGER
 SHARED TotalMovEnemies AS INTEGER
 SHARED PsychoTime AS INTEGER

 DIM direction AS INTEGER 'richting pacman
 DIM m AS INTEGER, n AS INTEGER
   
    'controle of creature wel de gekozen richting in kan of mag
    IF Creature.Moving THEN EXIT SUB
    IF Creature.Active = FALSE THEN EXIT SUB
    IF (dx < 0 AND Creature.xBlk = XMinBlockScreen) THEN EXIT SUB
    IF (dx > 0 AND Creature.xBlk = XMaxBlockScreen) THEN EXIT SUB
    IF (dy < 0 AND Creature.yBlk = YMinBlockScreen) THEN EXIT SUB
    IF (dy > 0 AND Creature.yBlk = YMaxBlockScreen) THEN EXIT SUB
    IF Creature.Species = 1 THEN 'it is a pacman
        IF BlkProps(PacField(Creature.xBlk + dx, Creature.yBlk + dy)).PacSolid THEN EXIT SUB
     ELSE
        IF BlkProps(PacField(Creature.xBlk + dx, Creature.yBlk + dy)).EnSolid THEN EXIT SUB
    END IF
  
   Creature.Moving = TRUE
   IF dy = -1 THEN Creature.CurDir = 1
   IF dx = 1 THEN Creature.CurDir = 2
   IF dy = 1 THEN Creature.CurDir = 3
   IF dx = -1 THEN Creature.CurDir = 4
  
    IF Creature.Player THEN
        'controleren op botsing van PacMan tegen Mov(ing)Enemy
        FOR m = 1 TO TotalMovEnemies
          IF MovEnemies(m).Active THEN
            IF (MovEnemies(m).xBlk = Creature.xBlk + DxDir(Creature.CurDir) AND MovEnemies(m).yBlk = Creature.yBlk + DyDir(Creature.CurDir)) OR (MovEnemies(m).xBlk = Creature.xBlk AND MovEnemies(m).yBlk = Creature.yBlk) THEN
              IF PsychoTime > 0 THEN MovEnemies(m).Active = FALSE ELSE LevelFailed = TRUE
            END IF
          END IF
        NEXT m
     ELSE
        'controleren op botsing van Mov(ing)Enemy tegen PacMan
        IF PacMan.xBlk = Creature.xBlk + DxDir(Creature.CurDir) AND PacMan.yBlk = Creature.yBlk + DyDir(Creature.CurDir) OR (PacMan.xBlk = Creature.xBlk AND PacMan.yBlk = Creature.yBlk) THEN
            IF PsychoTime > 0 THEN Creature.Active = FALSE ELSE LevelFailed = TRUE
        END IF
   END IF


END SUB

SUB Intro

DIM ScrollMessage$
DIM x%, y%, t%

SHELL "MapView pactitel.map"

ScrollMessage$ = "M.G.P. PROUDLY PRESENTS  THE FINAL PACMAN RIPOFF !      SPECIAL THANKS GO TO ROLAND GERAERTS,IVO VAN EE AND MY BIG BROTHER ERWIN...      "
ScrollMessage$ = ScrollMessage$ + "IF YOU'VE GOT QUESTIONS OR REMARKS, YOU CAN CONTACT ME BY E-MAIL AT SMOLENAA@SCI.KUN.NL                       "
ScrollMessage$ = ScrollMessage$ + "THE MARCEL GOES PROGRAMMING (YES DICKHEAD,WHAT ELSE COULD M.G.P EVER MEAN) SOFTWARE CORPORATION GREETS YA' ALL !"
ScrollMessage$ = ScrollMessage$ + SPACE$(20)
ScrollMessage$ = ScrollMessage$ + "PRODUCER : --MARCEL SMOLENAARS--" + SPACE$(20) + "PROGAMMER : --MARCEL SMOLENAARS--" + SPACE$(20) + "DESIGN : --MARCEL SMOLENAARS--"
ScrollMessage$ = ScrollMessage$ + SPACE$(30)
SetPal 128, 63, 0, 0
ScrollText ScrollMessage$, 183

END SUB

SUB LoadField
 SHARED PacField() AS INTEGER
 SHARED BlkSpr() AS INTEGER
 SHARED Levels() AS Level
 SHARED CurrentLevel AS INTEGER
 SHARED PacMan AS MovingCreature
 SHARED MovEnemies() AS MovingCreature
 SHARED BlkProps() AS BlockType
 SHARED TotalMovEnemies AS INTEGER
 SHARED PsychoTime AS INTEGER
    
 DIM Char AS STRING * 1, t$
 DIM xb AS INTEGER
 DIM yb AS INTEGER
 DIM n AS INTEGER
   
    PacMan.Active = TRUE
    PacMan.Moving = FALSE
    PacMan.Player = TRUE
    PsychoTime = FALSE

    Levels(CurrentLevel).GrabbedItems = 0
    Levels(CurrentLevel).TotGrabIts = 0
    t$ = RTRIM$(Levels(CurrentLevel).file) + ".lvl"
    OPEN t$ FOR BINARY AS #1
      FOR yb = YMinBlockScreen TO YMaxBlockScreen
       FOR xb = XMinBlockScreen TO XMaxBlockScreen
          GET #1, , Char
          PacField(xb, yb) = ASC(Char)
          IF BlkProps(ASC(Char)).GrabIt THEN
            Levels(CurrentLevel).TotGrabIts = Levels(CurrentLevel).TotGrabIts + 1
          END IF
       NEXT xb
      NEXT yb
    CLOSE #1

    t$ = RTRIM$(Levels(CurrentLevel).file) + ".cre"
    OPEN t$ FOR BINARY AS #1
      GET #1, , TotalMovEnemies
       TotalMovEnemies = TotalMovEnemies - 1   'PacMan zit immers ook in file
       PacMan.Active = TRUE
       GET #1, , PacMan.xBlk
       GET #1, , PacMan.yBlk
       GET #1, , PacMan.Species
       FOR n = 1 TO TotalMovEnemies
        MovEnemies(n).Active = TRUE
        MovEnemies(n).Moving = FALSE
        GET #1, , MovEnemies(n).xBlk
        GET #1, , MovEnemies(n).yBlk
        GET #1, , MovEnemies(n).Species
      NEXT n
    CLOSE #1
   
    FOR n = TotalMovEnemies + 1 TO MaxMovEnemies
      MovEnemies(n).Active = FALSE
    NEXT n
   
   
END SUB

SUB LoadGeneralData
  SHARED BlkSpr()  AS INTEGER
  SHARED BlkProps() AS BlockType
  SHARED MovCreatureSpr() AS INTEGER
  SHARED Levels() AS Level
  SHARED TotalLevels AS INTEGER
  SHARED PacMan AS MovingCreature
  SHARED MovEnemies() AS MovingCreature
  SHARED BackGround() AS INTEGER
  
  DIM k AS INTEGER, m AS INTEGER, n AS INTEGER, l AS LONG
  DIM FHandle AS INTEGER
 
    'algemeen
    SCREEN 13
    RANDOMIZE TIMER
    ExchangeFont "dragon"
    WriteText "ONE MOMENT PLEASE ..", 79, 79, 4
    WriteText "ONE MOMENT PLEASE ..", 80, 80, 15
    'SHELL "MapView pactitel.map"
    'SetMainPalette
    GetFontData

    DIM tmp(0 TO 4) AS INTEGER
    tmp(0) = 21: tmp(1) = 22: tmp(2) = 22: tmp(3) = 24: tmp(4) = 25
    BackGround(0) = 320: BackGround(1) = 200
    DEF SEG = VARSEG(BackGround(0))
     FOR l = VARPTR(BackGround(2)) TO VARPTR(BackGround(2)) + 63999
      POKE l, tmp(CINT(RND * 4))
     NEXT l
    DEF SEG
  
    BlkProps(1).PacSolid = TRUE: BlkProps(1).EnSolid = TRUE
    FOR n = 2 TO 11: BlkProps(n) = BlkProps(1): NEXT n
    BlkProps(12).GrabIt = TRUE
    BlkProps(13) = BlkProps(12)
    BlkProps(14) = BlkProps(1)
    BlkProps(15) = BlkProps(12)
    BlkProps(16) = BlkProps(12)
    BlkProps(17) = BlkProps(0)
    BlkProps(18) = BlkProps(17)
    BlkProps(19) = BlkProps(1): BlkProps(19).PacSolid = FALSE
    BlkProps(20) = BlkProps(19)

    FOpen "blocks10.blk" + CHR$(0), FHandle, n
     FRead FHandle, RealBytesBlk * (TotalBlkSorts + 1), VARSEG(BlkSpr(0, 0)), VARPTR(BlkSpr(0, 0))
    FClose FHandle
  
   
    'memory for 4 directions of creatures already used :
    ' 1, 2, 3, 4, 5, 6, 7, 10, 11, 12, 13, 14, 17, 21, 23, 29
    FOpen "pacman1A.blk" + CHR$(0), FHandle, n
     FRead FHandle, RealBytesBlk * 4, VARSEG(MovCreatureSpr(0, 1, 1)), VARPTR(MovCreatureSpr(0, 1, 1))
    FClose FHandle
    FOpen "pacman1B.blk" + CHR$(0), FHandle, n
     FRead FHandle, RealBytesBlk * 4, VARSEG(MovCreatureSpr(0, 1, 17)), VARPTR(MovCreatureSpr(0, 1, 17))
    FClose FHandle
    FOpen "en2.blk" + CHR$(0), FHandle, n
     FRead FHandle, RealBytesBlk * 4, VARSEG(MovCreatureSpr(0, 1, 2)), VARPTR(MovCreatureSpr(0, 1, 2))
    FClose FHandle
    FOpen "en2x.blk" + CHR$(0), FHandle, n
     FRead FHandle, RealBytesBlk * 4, VARSEG(MovCreatureSpr(0, 1, 2 + 8)), VARPTR(MovCreatureSpr(0, 1, 2 + 8))
    FClose FHandle
    FOpen "en3.blk" + CHR$(0), FHandle, n
     FRead FHandle, RealBytesBlk * 4, VARSEG(MovCreatureSpr(0, 1, 3)), VARPTR(MovCreatureSpr(0, 1, 3))
    FClose FHandle
    FOpen "en3x.blk" + CHR$(0), FHandle, n
     FRead FHandle, RealBytesBlk * 4, VARSEG(MovCreatureSpr(0, 1, 3 + 8)), VARPTR(MovCreatureSpr(0, 1, 3 + 8))
    FClose FHandle
    FOpen "en4.blk" + CHR$(0), FHandle, n
     FRead FHandle, RealBytesBlk * 4, VARSEG(MovCreatureSpr(0, 1, 4)), VARPTR(MovCreatureSpr(0, 1, 4))
    FClose FHandle
    FOpen "en4x.blk" + CHR$(0), FHandle, n
     FRead FHandle, RealBytesBlk * 4, VARSEG(MovCreatureSpr(0, 1, 4 + 8)), VARPTR(MovCreatureSpr(0, 1, 4 + 8))
    FClose FHandle
    FOpen "en5a.blk" + CHR$(0), FHandle, n
     FRead FHandle, RealBytesBlk * 4, VARSEG(MovCreatureSpr(0, 1, 5)), VARPTR(MovCreatureSpr(0, 1, 5))
    FClose FHandle
    FOpen "en5ax.blk" + CHR$(0), FHandle, n
     FRead FHandle, RealBytesBlk * 4, VARSEG(MovCreatureSpr(0, 1, 5 + 8)), VARPTR(MovCreatureSpr(0, 1, 5 + 8))
    FClose FHandle
    FOpen "en5b.blk" + CHR$(0), FHandle, n
     FRead FHandle, RealBytesBlk * 4, VARSEG(MovCreatureSpr(0, 1, 5 + 16)), VARPTR(MovCreatureSpr(0, 1, 5 + 16))
    FClose FHandle
    FOpen "en5bx.blk" + CHR$(0), FHandle, n
     FRead FHandle, RealBytesBlk * 4, VARSEG(MovCreatureSpr(0, 1, 5 + 8 + 16)), VARPTR(MovCreatureSpr(0, 1, 5 + 8 + 16))
    FClose FHandle
    FOpen "en6.blk" + CHR$(0), FHandle, n
     FRead FHandle, RealBytesBlk * 4, VARSEG(MovCreatureSpr(0, 1, 6)), VARPTR(MovCreatureSpr(0, 1, 6))
    FClose FHandle
    FOpen "en6x.blk" + CHR$(0), FHandle, n
     FRead FHandle, RealBytesBlk * 4, VARSEG(MovCreatureSpr(0, 1, 6 + 8)), VARPTR(MovCreatureSpr(0, 1, 6 + 8))
    FClose FHandle
    FOpen "en7.blk" + CHR$(0), FHandle, n
     FRead FHandle, RealBytesBlk * 4, VARSEG(MovCreatureSpr(0, 1, 7)), VARPTR(MovCreatureSpr(0, 1, 7))
     FRead FHandle, RealBytesBlk * 4, VARSEG(MovCreatureSpr(0, 1, 7 + 16)), VARPTR(MovCreatureSpr(0, 1, 7 + 16))
    FClose FHandle
 
    OPEN "paclvls.dat" FOR INPUT AS #1
       INPUT #1, TotalLevels    'aantal levels
       REDIM Levels(1 TO TotalLevels) AS Level
       FOR n = 1 TO TotalLevels
          INPUT #1, Levels(n).file
       NEXT n
    CLOSE #1
 

END SUB

SUB MakeMoves
 SHARED PacField() AS INTEGER
 SHARED BlkSpr() AS INTEGER
 SHARED PacMan AS MovingCreature
 SHARED MovEnemies() AS MovingCreature
 SHARED MovCreatureSpr() AS INTEGER
 SHARED DxDir() AS INTEGER, DyDir() AS INTEGER
 SHARED PsychoTime AS INTEGER
 SHARED TotalMovEnemies AS INTEGER
 SHARED BlkProps() AS BlockType
 SHARED Levels() AS Level
 SHARED LevelDone AS INTEGER
 SHARED LevelFailed AS INTEGER
 SHARED Score AS INTEGER
 SHARED CurrentLevel AS INTEGER
 
  DIM xb AS INTEGER
  DIM yb AS INTEGER
  DIM xp AS INTEGER
  DIM yp AS INTEGER
  DIM m AS INTEGER, n AS INTEGER

  IF PacMan.Moving AND PacMan.Active THEN
     PacMan.MovCnt = PacMan.MovCnt + 1
     xp = (PacMan.xBlk - 1) * XBlockSize
     yp = (PacMan.yBlk - 1) * YBlockSize
     m = PacMan.Species
     PsetSprite xp, yp, BlkSpr(0, PacField(PacMan.xBlk, PacMan.yBlk))
     PsetSprite xp + DxDir(PacMan.CurDir) * XBlockSize, yp + DyDir(PacMan.CurDir) * YBlockSize, BlkSpr(0, PacField(PacMan.xBlk + DxDir(PacMan.CurDir), PacMan.yBlk + DyDir(PacMan.CurDir)))
     IF (PacMan.MovCnt AND 4) THEN m = m + 16  'zorgt voor pacman afwisselend open en dichte bek
     PutSprite xp + DxDir(PacMan.CurDir) * PacMan.MovCnt, yp + DyDir(PacMan.CurDir) * PacMan.MovCnt, MovCreatureSpr(0, PacMan.CurDir, m)
     IF PacMan.MovCnt = XBlockSize THEN
        PacMan.xBlk = PacMan.xBlk + DxDir(PacMan.CurDir)
        PacMan.yBlk = PacMan.yBlk + DyDir(PacMan.CurDir)
        PacMan.Moving = FALSE
        PacMan.MovCnt = 0
        PacMan.PrevDir = PacMan.CurDir
        SELECT CASE PacField(PacMan.xBlk, PacMan.yBlk)
            CASE 13:  'psycho time !
                  PsychoTime = StndPsychoTime
            CASE 17:  'teleport
                  DO
                    n = YMinBlockScreen + RND * (YMaxBlockScreen - YMinBlockScreen)
                    FOR m = XMinBlockScreen TO XMaxBlockScreen
                      IF PacField(m, n) = 17 AND RND < .5 AND (m <> PacMan.xBlk AND n <> PacMan.yBlk) THEN EXIT DO
                    NEXT m
                  LOOP
                  PsetSprite ((PacMan.xBlk - 1) * XBlockSize), (PacMan.yBlk - 1) * YBlockSize, BlkSpr(0, PacField(PacMan.xBlk, PacMan.yBlk))
                  PacMan.xBlk = m: PacMan.yBlk = n
                  PutSprite ((PacMan.xBlk - 1) * XBlockSize), (PacMan.yBlk - 1) * YBlockSize, MovCreatureSpr(0, PacMan.CurDir, PacMan.Species)
            CASE 18: 'pacman is on the flashing lightning -> deadly cross
                  IF PsychoTime = 0 THEN LevelFailed = TRUE
            CASE ELSE
        END SELECT
        'speler heeft iets gepakt dat de score verhoogt
        IF BlkProps(PacField(PacMan.xBlk, PacMan.yBlk)).GrabIt THEN
            Levels(CurrentLevel).GrabbedItems = Levels(CurrentLevel).GrabbedItems + 1
            IF Levels(CurrentLevel).GrabbedItems = Levels(CurrentLevel).TotGrabIts THEN
                LevelDone = TRUE
            END IF
            PacField(PacMan.xBlk, PacMan.yBlk) = 0
            FillBar 146, 191, 25, 7, 7             ' /picked up a jewel ?
            IF PacField(PacMan.xBlk, PacMan.yBlk) = 16 THEN n = 20 ELSE n = 10
            Score = Score + n
            WriteText STR$(Score), 145, 190, 0
        END IF
     END IF
  END IF
 
  FOR n = 1 TO TotalMovEnemies
   IF MovEnemies(n).Moving AND MovEnemies(n).Active THEN
     MovEnemies(n).MovCnt = MovEnemies(n).MovCnt + 1
     xp = (MovEnemies(n).xBlk - 1) * XBlockSize
     yp = (MovEnemies(n).yBlk - 1) * YBlockSize
     m = MovEnemies(n).Species
     PsetSprite xp, yp, BlkSpr(0, PacField(MovEnemies(n).xBlk, MovEnemies(n).yBlk))
     PsetSprite xp + DxDir(MovEnemies(n).CurDir) * XBlockSize, yp + DyDir(MovEnemies(n).CurDir) * YBlockSize, BlkSpr(0, PacField(MovEnemies(n).xBlk + DxDir(MovEnemies(n).CurDir), MovEnemies(n).yBlk + DyDir(MovEnemies(n).CurDir)))
     IF (m = 5 OR m = 7) AND (MovEnemies(n).MovCnt AND 4) THEN  'zorgt voor enemy met open dan dichte bek
         m = m + 16
     END IF
     IF PsychoTime AND (MovEnemies(n).MovCnt AND 4) THEN 'zorgt voor enemy met open dan dichte bek
         m = m + 8
     END IF
     PutSprite xp + DxDir(MovEnemies(n).CurDir) * MovEnemies(n).MovCnt, yp + DyDir(MovEnemies(n).CurDir) * MovEnemies(n).MovCnt, MovCreatureSpr(0, MovEnemies(n).CurDir, m)
     IF MovEnemies(n).MovCnt = XBlockSize THEN
        MovEnemies(n).Moving = FALSE
        MovEnemies(n).MovCnt = 0
        MovEnemies(n).xBlk = MovEnemies(n).xBlk + DxDir(MovEnemies(n).CurDir)
        MovEnemies(n).yBlk = MovEnemies(n).yBlk + DyDir(MovEnemies(n).CurDir)
        MovEnemies(n).PrevDir = MovEnemies(n).CurDir
        SELECT CASE PacField(MovEnemies(n).xBlk, MovEnemies(n).yBlk)
            CASE 17:  'teleporteren
                  DO
                    yp = YMinBlockScreen + RND * (YMaxBlockScreen - YMinBlockScreen)
                    FOR xp = XMinBlockScreen TO XMaxBlockScreen
                      IF PacField(xp, yp) = 17 AND RND < .5 THEN EXIT DO
                    NEXT xp
                  LOOP
                  PsetSprite ((MovEnemies(n).xBlk - 1) * XBlockSize), (MovEnemies(n).yBlk - 1) * YBlockSize, BlkSpr(0, PacField(MovEnemies(n).xBlk, MovEnemies(n).yBlk))
                  MovEnemies(n).xBlk = xp: MovEnemies(n).yBlk = yp
                  PutSprite ((MovEnemies(n).xBlk - 1) * XBlockSize), (MovEnemies(n).yBlk - 1) * YBlockSize, MovCreatureSpr(0, MovEnemies(n).CurDir, MovEnemies(n).Species)
            CASE ELSE
        END SELECT
     END IF
   END IF
  NEXT n
 

END SUB

SUB MapView (t AS STRING)
' this one isn't used, but i leave it in. it might be useful another time

DIM Col AS INTEGER, r AS INTEGER, g AS INTEGER, b AS INTEGER, Handle  AS INTEGER

  t = t + CHR$(0)
  FOpen t, Handle, r
      FGotoPos Handle, 768
      FRead Handle, &HFA00, &HA000, 0    'read 64000 bytes to vga
      FGotoPos Handle, 0
      FOR Col = 0 TO 255
        FReadByte Handle, VARSEG(r), VARPTR(r)
        FReadByte Handle, VARSEG(g), VARPTR(g)
        FReadByte Handle, VARSEG(b), VARPTR(b)
        SetPal Col, r, g, b
      NEXT Col
  FClose Handle

END SUB

SUB Menu
 SHARED BackGround() AS INTEGER
 DIM n AS INTEGER
  
  ExchangeFont "dragon"
  
  PsetSprite 0, 0, BackGround(0)
  SetMainPalette

  DO
   n = Choise%(105, 55, " PLAY` OPTIONS ` HELP` QUIT")
  LOOP WHILE n = 0

  SELECT CASE n
     CASE 1:
             ExchangeFont "scr13"
             PlayGame
     CASE 2:
             Options
     CASE 3:
             Help
     CASE 4:
             Quit
  END SELECT
  
 
END SUB

SUB Options
 SHARED GameSpeed AS INTEGER
 SHARED BackGround() AS INTEGER
 SHARED ControlMode AS INTEGER

 DO
 
  ExchangeFont "dragon"
  PsetSprite 0, 0, BackGround(0)
  SetMainPalette
 
  SELECT CASE Choise%(85, 70, "SET SPEED`SET CONTROL MODE `BACK")
   CASE 1
        PsetSprite 0, 0, BackGround(0)
        TextButton -1, 0, " SELECT THE CHARACTER THAT SUITS YOU .. ", 0
        ExchangeFont "scr13"
        DO
            GameSpeed = Choise%(100, 70, "SNAILS ARE MY PASSION `MODERATE`I LIKE 'M FAST`I HATE BRAKES")
        LOOP UNTIL GameSpeed > 0 AND GameSpeed < 5
  
   CASE 2
        PsetSprite 0, 0, BackGround(0)
        DO
          ControlMode = Choise%(70, 70, "KEEP PRESSING THE KEYS `PACMAN WALKS ON")
        LOOP UNTIL ControlMode > 0 AND ControlMode < 3
        ControlMode = ControlMode - 1

    CASE 3: EXIT DO

  END SELECT
 LOOP

END SUB

SUB PlayGame
 SHARED TotalLevels AS INTEGER
 SHARED PacMan AS MovingCreature
 SHARED Lifes AS INTEGER
 SHARED CurrentLevel AS INTEGER
 SHARED Levels() AS Level
 SHARED GameDone AS INTEGER
 SHARED LevelDone AS INTEGER
 SHARED LevelFailed AS INTEGER
 SHARED Score AS INTEGER
 SHARED GameSpeed AS INTEGER
 SHARED PsychoTime AS INTEGER   'Boolean: True-> Pacman can eat ghosts
 SHARED BackGround() AS INTEGER
 SHARED ControlMode AS INTEGER
 SHARED DxDir() AS INTEGER, DyDir() AS INTEGER
 SHARED FlashCnt AS INTEGER  '-10 < FlashCnt <= 0 : blocksort 18 changes in
                             'into blocksort 19.
 
 DIM BackToMenu AS INTEGER
 DIM n AS INTEGER, a$
 DIM StopPacman AS INTEGER  'counts only if ControlMode = 1

 CurrentLevel = 1
 Lifes = BeginLives
 Score = 0
 BackToMenu = FALSE
 FlashCnt = 100

 DO
 
   PsetSprite 0, 0, BackGround(0)
   SetMainPalette
   LoadField
   LevelDone = FALSE

   a$ = "` LEVEL" + STR$(CurrentLevel) + "`"
   TextButton 130, 80, a$, 0
   DO: LOOP UNTIL INKEY$ = ""
   DO: LOOP UNTIL INKEY$ <> ""
   DrawField
   DO: LOOP UNTIL Scancode% > 127    'loop until all keys are released
   ControlMode = 1

   DO
     FOR n = 1 TO 4 - GameSpeed
        RetraceWait
     NEXT n
    
     IF PsychoTime THEN PsychoTime = PsychoTime - 1
     FlashCnt = FlashCnt - 1
     IF FlashCnt = 0 THEN Flash 1
     IF FlashCnt = -20 THEN Flash 0: FlashCnt = 60

     ControlEnemies
     MakeMoves
     a$ = INKEY$
        SELECT CASE Scancode%
            CASE Esc: BackToMenu = TRUE
            'CASE Tb: LevelDone = TRUE
            CASE Up: InitMove PacMan, 0, -1: StopPacman = FALSE
            CASE Down: InitMove PacMan, 0, 1: StopPacman = FALSE
            CASE Left: InitMove PacMan, -1, 0: StopPacman = FALSE
            CASE Right: InitMove PacMan, 1, 0: StopPacman = FALSE
            CASE Sp: IF ControlMode = 1 THEN StopPacman = TRUE
            CASE Enter: IF ControlMode = 1 THEN ControlMode = 0 ELSE ControlMode = 1
                        DO: LOOP UNTIL INP(&H60) <> Enter
        END SELECT
        IF ControlMode = 1 THEN
           IF PacMan.Moving = FALSE AND PacMan.PrevDir <> 0 THEN
              IF StopPacman THEN
                PacMan.PrevDir = 0
                StopPacman = FALSE
              ELSE
                InitMove PacMan, DxDir(PacMan.PrevDir), DyDir(PacMan.PrevDir)
              END IF
           END IF
        END IF
   LOOP UNTIL LevelDone OR LevelFailed OR BackToMenu
  
   IF LevelFailed THEN
      BEEP
      Lifes = Lifes - 1
      LevelFailed = FALSE
      SELECT CASE INT(100 * Levels(CurrentLevel).GrabbedItems / Levels(CurrentLevel).TotGrabIts)
       CASE 0 TO 10:  a$ = "`GO EAT SOME SHIT, LOSER`"
       CASE 11 TO 20: a$ = "`THIS GAME ISN'T MADE FOR PEOPLE WITH TWO BRAIN CELLS`"
       CASE 21 TO 30: a$ = "`YOU WEAK PATHETIC FOOL !`"
       CASE 31 TO 40: a$ = "` YOU STINK `"
       CASE 41 TO 50: a$ = "`YOU'VE DONE QUITE A LOUSY JOB`"
       CASE 51 TO 70: a$ = "`YOU STILL NEED SOME PRACTICE`"
       CASE 71 TO 80: a$ = "`YOU'RE GETTING CLOSE, MAN`"
       CASE 81 TO 94: a$ = "`NEXT TIME BETTER LUCK`"
       CASE 95 TO 99: a$ = "`WOW, THAT MUST BE IRRITATING. YOU WERE SO CLOSE.`"
       CASE ELSE: a$ = "`HEH !! THIS WASN'T SUPPOSED TO HAPPEN !`"
      END SELECT
      n = 160 - TextSize%(a$) \ 2
      TextButton n, 70, a$, 0
      DO: LOOP UNTIL INKEY$ = ""
      DO: LOOP UNTIL INKEY$ <> ""
      IF Lifes > 0 THEN
        ScreenEffect 4
      END IF
   END IF

   IF LevelDone THEN
    IF CurrentLevel < TotalLevels THEN
        CurrentLevel = CurrentLevel + 1
      ELSE
        GameDone = TRUE
      END IF
   END IF

  LOOP UNTIL GameDone OR Lifes = 0 OR BackToMenu
  
 
  IF Lifes = 0 THEN
    ScreenEffect 1
    DO: LOOP UNTIL INKEY$ = ""
    SetPal 128, 63, 0, 0
    ScrollText "GAME OVER" + SPACE$(9), 91
    FadeOut2
  ELSEIF GameDone THEN
    GameEnding
  END IF


END SUB

SUB Quit

 ScreenEffect 5

 SCREEN 0
 WIDTH 80, 25
 END

END SUB

SUB SetMainPalette
DIM Col AS INTEGER, r AS INTEGER, g AS INTEGER, b AS INTEGER, Handle  AS INTEGER

  FOpen "main.pal" + CHR$(0), Handle, r
      FOR Col = 0 TO 255
        FReadByte Handle, VARSEG(r), VARPTR(r)
        FReadByte Handle, VARSEG(g), VARPTR(g)
        FReadByte Handle, VARSEG(b), VARPTR(b)
        SetPal Col, r, g, b
      NEXT Col
  FClose Handle

END SUB

