'
'    Level Designer for Pacman ,    by Marcel Smolenaars
'           
'                     MMM MMM  GGGGG  PPP
'                     M  M  M  G      P  P
'                     M  M  M  G  GG  PPP
'                     M     M  G   G  P
'                     M     M  GGGGG  P
'
'Press <H> to get some help !    (this won't work under qb because of little
'memory - edit is invoked,that's the reason - )
'
'
'$INCLUDE: 'mgplib.bi'
DECLARE SUB BlockHelp (BlkType AS INTEGER)
DECLARE SUB Help ()
DECLARE SUB Change ()
DECLARE SUB FillBlock (xCursor AS INTEGER, yCursor AS INTEGER, num AS INTEGER)
DECLARE SUB Quit ()
DECLARE SUB DrawField ()
DECLARE SUB LoadField ()
DECLARE SUB SaveField ()
DECLARE SUB NewField ()
DECLARE SUB LoadData ()
DECLARE SUB SetMainPalet ()
DECLARE SUB MakeCorrectBorders (xBlk AS INTEGER, yBlk AS INTEGER)
DECLARE SUB Test ()
DECLARE SUB CheckInput ()

'subs en functies uit text13.bas
DECLARE FUNCTION Choise% (X%, y%, PickList$)
DECLARE SUB DrawButton (X%, y%, B%, H%, Status%)
DECLARE SUB TextButton (X%, y%, t$, Status%)
DECLARE SUB ExchangeFont (FONTtoLOAD$)
DECLARE SUB WriteText (Text$, X%, y%, Col%)
DECLARE FUNCTION KBflags% ()

CONST TRUE = -1
CONST FALSE = 0

REM Meest gebruikte toetsen
CONST Down = 80, Up = 72
CONST PgDwn = 81, PgUp = 73
CONST Home = 71, EndLn = 79
CONST Left = 75, Right = 77
CONST Enter = 13, Esc = 27
CONST Sp = 32, F1 = 60

CONST XBlockSize = 10
CONST YBlockSize = 10
CONST XMinBlockScreen = 2
CONST YMinBlockScreen = 2
CONST XMaxBlockScreen = 30
CONST YMaxBlockScreen = 18
CONST DataBytesBlk = XBlockSize * YBlockSize
CONST RealBytesBlk = DataBytesBlk + 4
CONST DataWordsBlk = DataBytesBlk \ 2
CONST RealWordsBlk = RealBytesBlk \ 2
CONST TotalBlkSorts = 20
CONST TotalCreatureSorts = 7
CONST MaxCreatures = 15
TYPE BlockType
   PacSolid AS INTEGER   'Boolean :  TRUE | vast blok | laat Pacman niet door
                         '           FALSE | open blok | laat Pacman wel door
   EnSolid AS INTEGER
   GrabIt AS INTEGER  'Boolean :  TRUE | puntje dat gepakt moet worden
                      '           FALSE | geen puntje
END TYPE

TYPE CreatureType
   Active AS INTEGER  'Boolean :  TRUE | MovingCreature is actief
                      '           FALSE | MovingCreature is "dood"
   Player AS INTEGER  'Boolean :  TRUE | MovingCreature bestuurd door speler
                      '           FALSE | computer bestuurt MovingCreature
   Species AS INTEGER 'soort Creature
   xBlk AS INTEGER
   yBlk AS INTEGER
END TYPE

DIM BlkProps(0 TO TotalBlkSorts) AS BlockType
DIM BlkSpr(RealWordsBlk - 1, 0 TO 20) AS INTEGER
DIM PacField(XMinBlockScreen TO XMaxBlockScreen, YMinBlockScreen TO YMaxBlockScreen) AS INTEGER
DIM MovCreatureSpr(RealWordsBlk - 1, 1 TO 4, 1 TO 40) AS INTEGER
DIM Creatures(1 TO MaxCreatures) AS CreatureType
DIM TotCreaturesPlaced AS INTEGER
DIM PlacingCreatures AS INTEGER: PlacingCreatures = FALSE


DIM X AS INTEGER, y AS INTEGER
DIM xB AS INTEGER, yB AS INTEGER
DIM n AS INTEGER, m AS INTEGER
DIM xCursor AS INTEGER, yCursor AS INTEGER
DIM CurBlkType AS INTEGER
DIM CurCreatureType AS INTEGER
DIM PalTel AS INTEGER

xCursor = XMinBlockScreen
yCursor = YMinBlockScreen
CurBlkType = 1
CurCreatureType = 1

LoadData
ExchangeFont "scr13"


SCREEN 13

SetMainPalet

MouseInit
MouseShow

NewField


DO
  CheckInput
LOOP


END

SUB BlockHelp (BlkType AS INTEGER)
 SHARED BlkSpr() AS INTEGER
 DIM t$, dummy%, But%

 'DrawButton 154, 63, 12, 12, 0

 SELECT CASE BlkType
   CASE 0: t$ = "  THIS BLOCK IS EMPTY. IF YOU DRAW WITH`  THIS ONE, THE BACKGROUND OF THE GAME`  CAN BE SEEN."
   CASE 1 TO 11: t$ = "  THIS IS A BORDER LINE. CREATURES CAN'T GO` THROUGH IT."
   CASE 12: t$ = "  THIS IS A THINGY YOU'VE GOT TO PICK UP."
   CASE 13: t$ = "  THIS ONE MAKES PACMAN GO BERSERK FOR A`  SHORT TIME. ENEMIES CAN BE EATEN."
   CASE 14, 15: t$ = "  THIS HASN'T GOT A FUNCTION YET"
   CASE 16: t$ = "  JEWEL; THINGY YOU'VE GOT TO PICK UP.`  EXTRA POINTS FOR THIS ONE."
   CASE 17: t$ = "  TELEPORTER .TELEPORTS EVERY CREATURE TO`  ANOTHER TELEPORTER."
   CASE 18: t$ = "  DEADLY CROSS. SLOWLY FLICKERS. DON'T STEP`  ON THIS ONE IF IT LIGHTS UP."
   CASE 19, 20: t$ = "  PACMAN CAN GO THROUGH THIS FILTER, BUT`  ENEMIES CAN'T"
 END SELECT

 t$ = t$ + "``<PRESS LEFT MOUSE BUTTON OR KEY TO CONTINUE>"
 TextButton 30, 60, t$, 0
 PsetSprite 32, 62, BlkSpr(0, BlkType)
 DO
 MouseStatus dummy%, dummy%, But%
 LOOP UNTIL INKEY$ <> "" OR But% = 1
 DrawField

END SUB

SUB Change
 SHARED PacField() AS INTEGER

 DIM SearchFor AS INTEGER
 DIM ChangeIn AS INTEGER
 DIM xB AS INTEGER
 DIM yB AS INTEGER


  SCREEN 0: WIDTH 80, 25
 
  INPUT "What's the number of the block that has to be changed"; SearchFor
  INPUT "What's the number of the block to convert it in"; ChangeIn
 
  FOR yB = YMinBlockScreen TO YMaxBlockScreen
   FOR xB = XMinBlockScreen TO XMaxBlockScreen
     IF PacField(xB, yB) = SearchFor THEN PacField(xB, yB) = ChangeIn
   NEXT xB
  NEXT yB

  SCREEN 13
  SetMainPalet
  MouseInit
  MouseShow
  DrawField


END SUB

SUB CheckInput

 SHARED PlacingCreatures AS INTEGER
 SHARED xCursor AS INTEGER, yCursor AS INTEGER
 SHARED CurBlkType AS INTEGER
 SHARED CurCreatureType AS INTEGER
 SHARED PacField() AS INTEGER
 SHARED Creatures() AS CreatureType
 SHARED TotCreaturesPlaced AS INTEGER

 DIM xm AS INTEGER, ym AS INTEGER, Button AS INTEGER
 DIM xBlk AS INTEGER, yBlk AS INTEGER
 DIM Code AS INTEGER, n AS INTEGER
 DIM ScreenPart(4000) AS INTEGER

  MouseStatus xm, ym, Button
  xBlk = (xm \ XBlockSize) + 1
  yBlk = (ym \ YBlockSize) + 1
 
  IF NOT PlacingCreatures THEN
   
    'clicked on field ?
    IF xBlk >= XMinBlockScreen AND xBlk <= XMaxBlockScreen AND yBlk >= YMinBlockScreen AND yBlk <= YMaxBlockScreen THEN
        xCursor = xBlk
        yCursor = yBlk
        IF Button = 1 THEN  'met linkermuisknop geklikt op een vakje => vakje vullen
            FillBlock xCursor, yCursor, CurBlkType
        END IF
        IF Button = 2 THEN  'met rechtermuisknop geklikt op een vakje => bloktype overnemen van vakje
            LINE (CurBlkType * XBlockSize, 199 - YBlockSize)-STEP(XBlockSize, YBlockSize), 7, B
            CurBlkType = PacField(xCursor, yCursor)
            LINE (CurBlkType * XBlockSize, 199 - YBlockSize)-STEP(XBlockSize, YBlockSize), 15, B
        END IF
    END IF
 
    IF ym >= 199 - YBlockSize THEN
      'selected an other block sort ?
      IF xBlk <= TotalBlkSorts + 1 AND Button = 1 THEN
        mousehide
        LINE (CurBlkType * XBlockSize, 199 - YBlockSize)-STEP(XBlockSize, YBlockSize), 7, B
        CurBlkType = xm \ XBlockSize
        LINE (CurBlkType * XBlockSize, 199 - YBlockSize)-STEP(XBlockSize, YBlockSize), 15, B
        MouseShow
      ELSEIF xBlk <= TotalBlkSorts + 1 AND Button = 2 THEN
        BlockHelp xm \ XBlockSize
      END IF
    END IF


 ELSE    'placing creatures on field
   

    'clicked on field ?
    IF xBlk >= XMinBlockScreen AND xBlk <= XMaxBlockScreen AND yBlk >= YMinBlockScreen AND yBlk <= YMaxBlockScreen THEN
        xCursor = xBlk
        yCursor = yBlk
        IF Button = 1 THEN  'pressed left mouse button on a field => fill field with creature
            FillBlock xCursor, yCursor, CurCreatureType
        ELSEIF Button = 2 THEN
            'delete possible creature on block
            FOR n = 1 TO TotCreaturesPlaced
              IF Creatures(n).xBlk = xBlk AND Creatures(n).yBlk = yBlk THEN
                 Creatures(n).Active = FALSE
                 EXIT FOR
              END IF
            NEXT n
           
            IF n = TotCreaturesPlaced + 1 THEN EXIT SUB 'no creature deleted
           
            IF n = TotCreaturesPlaced THEN
                TotCreaturesPlaced = TotCreaturesPlaced - 1
                DrawField
                DO: MouseStatus xm, ym, Button
                LOOP UNTIL Button = 0
                EXIT SUB
            END IF

            'sort creatures array because of deleted creature
            FOR n = 1 TO TotCreaturesPlaced
              IF NOT Creatures(n).Active THEN
                 IF n < TotCreaturesPlaced THEN
                    SWAP Creatures(n), Creatures(TotCreaturesPlaced)
                    TotCreaturesPlaced = TotCreaturesPlaced - 1
                    DrawField
                    EXIT FOR
                 END IF
              END IF
            NEXT n
        END IF
        DO
         MouseStatus xm, ym, Button
        LOOP UNTIL Button = 0
       
    END IF

    IF ym >= 199 - YBlockSize AND Button = 1 THEN
      'other creature selected ?
      IF xBlk <= TotalCreatureSorts THEN
        mousehide
        LINE ((CurCreatureType - 1) * XBlockSize, 199 - YBlockSize)-STEP(XBlockSize, YBlockSize), 7, B
        CurCreatureType = (xm \ XBlockSize) + 1
        LINE ((CurCreatureType - 1) * XBlockSize, 199 - YBlockSize)-STEP(XBlockSize, YBlockSize), 15, B
        MouseShow
      END IF
    END IF
  
  END IF
   
    
    IF ym < 10 AND Button = 1 THEN
      IF xm <= 65 THEN   'file menu selected   ?
        mousehide
        GetSprite 0, 10, 100, 80, ScreenPart(0)
        MouseShow
        n = Choise%(0, 10, "NEW     <N>`LOAD    <L>`SAVE    <S>`TEST    <T>`CHANGE  <X>`QUIT    <Q>`HELP    <H>")
        SELECT CASE n
            CASE 1: mousehide
                    PsetSprite 0, 10, ScreenPart(0)
                    MouseShow
                    CALL NewField
            CASE 2: CALL LoadField
            CASE 3: CALL SaveField
            CASE 4: CALL Test
            CASE 5: mousehide
                    PsetSprite 0, 10, ScreenPart(0)
                    MouseShow
                    CALL Change
            CASE 6: CALL Quit
            CASE 7: CALL Help
            CASE ELSE:
                    mousehide
                    PsetSprite 0, 10, ScreenPart(0)
                    MouseShow
        END SELECT
      ELSEIF xm >= 67 AND xm < 193 THEN  'other mode selected   ?
       
        DO: MouseStatus xm, ym, Button
        LOOP UNTIL Button = 0
        PlacingCreatures = NOT PlacingCreatures
        DrawField
     
      END IF
    END IF

    a$ = INKEY$
    IF a$ <> "" THEN
        SELECT CASE UCASE$(a$)
            'CASE Sp: CALL FillBlock(xCursor, yCursor, CurBlkType)
            CASE "C": CALL Change
            CASE "L": CALL LoadField
            CASE "S": CALL SaveField
            CASE "N": CALL NewField
            CASE "Q": CALL Quit
            CASE "H": CALL Help
            CASE "T": CALL Test
            CASE "M": PlacingCreatures = PlacingCreatures XOR &HFFFF
                      DrawField
            CASE "B":
                LOCATE 1, 1: INPUT "Enter new type of block :", CurBlkType
                DrawField
            CASE ELSE
        END SELECT
    END IF

END SUB

SUB DrawField

 SHARED PlacingCreatures AS INTEGER
 SHARED PacField() AS INTEGER
 SHARED BlkSpr() AS INTEGER
 SHARED xCursor AS INTEGER, yCursor AS INTEGER
 SHARED CurCreatureType AS INTEGER
 SHARED CurBlkType AS INTEGER
 SHARED MovCreatureSpr() AS INTEGER
 SHARED Creatures() AS CreatureType
 SHARED TotCreaturesPlaced AS INTEGER

 DIM xB AS INTEGER, yB AS INTEGER
 DIM X AS INTEGER, y AS INTEGER
 DIM n AS INTEGER, t$
 
  mousehide
  RetraceWait
  FillBar 0, 0, 320, 200, 0

  y = (YMinBlockScreen - 2) * YBlockSize
  FOR yB = YMinBlockScreen TO YMaxBlockScreen
    y = y + YBlockSize
    X = (XMinBlockScreen - 2) * XBlockSize
    FOR xB = XMinBlockScreen TO XMaxBlockScreen
        X = X + XBlockSize
        PsetSprite X, y, BlkSpr(0, PacField(xB, yB))
        LINE (X, y)-STEP(XBlockSize, YBlockSize), 7, B
    NEXT xB
  NEXT yB

 
  IF PlacingCreatures THEN
     FOR X = 1 TO TotalCreatureSorts
        PsetSprite ((X - 1) * XBlockSize), 199 - YBlockSize, MovCreatureSpr(0, 1, X)
        LINE ((X - 1) * XBlockSize, 199 - YBlockSize)-STEP(XBlockSize, YBlockSize), 7, B
     NEXT X
     WriteText "PLACING CREATURES", 210, 0, 14
     FOR n = 1 TO TotCreaturesPlaced
       PutSprite ((Creatures(n).xBlk - 1) * XBlockSize), (Creatures(n).yBlk - 1) * YBlockSize, MovCreatureSpr(0, 1, Creatures(n).Species)
     NEXT n
     LINE ((CurCreatureType - 1) * XBlockSize, 199 - YBlockSize)-STEP(XBlockSize, YBlockSize), 15, B
 
  ELSE
     FOR X = 0 TO TotalBlkSorts
        PsetSprite X * XBlockSize, 199 - YBlockSize, BlkSpr(0, X)
        LINE (X * XBlockSize, 199 - YBlockSize)-STEP(XBlockSize, YBlockSize), 7, B
     NEXT X
     LINE (CurBlkType * XBlockSize, 199 - YBlockSize)-STEP(XBlockSize, YBlockSize), 15, B
     WriteText "PLACING BLOCKS", 210, 0, 14
  END IF

  TextButton 0, 0, "   MENU   ", 0
  IF PlacingCreatures THEN t$ = " GO PLACING BLOCKS  " ELSE t$ = "GO PLACING CREATURES"
  TextButton 67, 0, t$, 0
  MouseShow

END SUB

SUB FillBlock (xCursor AS INTEGER, yCursor AS INTEGER, Species AS INTEGER)
 SHARED PlacingCreatures AS INTEGER
 SHARED PacField() AS INTEGER
 SHARED BlkSpr() AS INTEGER
 SHARED MovCreatureSpr() AS INTEGER
 SHARED Creatures() AS CreatureType
 SHARED TotCreaturesPlaced AS INTEGER

 mousehide
 
 IF NOT PlacingCreatures THEN 'Blokken plaatsen
   
    PacField(xCursor, yCursor) = Species
    IF (KBflags% AND 3) = 0 THEN 'Shift was not pressed !
        MakeCorrectBorders xCursor, yCursor   ' > logisch aangezien MakeCor..
        Species = PacField(xCursor, yCursor)  '/   de boel in orde maakt
    END IF

    FillBar ((xCursor - 1) * XBlockSize), (yCursor - 1) * YBlockSize, XBlockSize, YBlockSize, 0
    IF Species > 0 THEN
       PsetSprite ((xCursor - 1) * XBlockSize), (yCursor - 1) * YBlockSize, BlkSpr(0, Species)
    END IF
    LINE ((xCursor - 1) * XBlockSize, (yCursor - 1) * YBlockSize)-STEP(XBlockSize, YBlockSize), 7, B

 ELSE  'Creatures plaatsen
   
    IF TotCreaturesPlaced + 1 > MaxCreatures THEN
        BEEP
        TextButton 15, 80, "NO MORE CREATURES THEN" + STR$(MaxCreatures) + " ARE ALOWED IN 1 LEVEL``   PRESS ANY KEY TO CONTINUE", 0
        DO: LOOP UNTIL INKEY$ <> ""
        MouseShow
        DrawField
        EXIT SUB
    END IF
    IF Species = 1 THEN
        IF Creatures(1).Active AND Creatures(1).Species = 1 THEN
          BEEP
          TextButton 35, 70, "THERE CAN ONLY BE 1 PACMAN IN THE GAME`(ERASING IS DONE BY PRESSING RIGHT`MOUSE BUTTON, WHILE POINTING AT PACMAN)``       PRESS ANY KEY TO CONTINUE", 0
          DO: LOOP UNTIL INKEY$ <> ""
          MouseShow
          DrawField
          EXIT SUB
        END IF
    END IF
    TotCreaturesPlaced = TotCreaturesPlaced + 1
    PutSprite ((xCursor - 1) * XBlockSize), (yCursor - 1) * YBlockSize, MovCreatureSpr(0, 1, Species)
    Creatures(TotCreaturesPlaced).xBlk = xCursor
    Creatures(TotCreaturesPlaced).yBlk = yCursor
    Creatures(TotCreaturesPlaced).Species = Species
    Creatures(TotCreaturesPlaced).Active = TRUE
    IF Species = 1 THEN
        Creatures(TotCreaturesPlaced).Player = TRUE
        IF Creatures(1).Species <> 1 THEN
           SWAP Creatures(1), Creatures(TotCreaturesPlaced)
        END IF
    END IF
   
 END IF

 MouseShow

END SUB

SUB Help
 
  SCREEN 0: WIDTH 80
  SHELL "edit paclvls.doc"
  SCREEN 13
  SetMainPalet
  DrawField
  MouseInit
  MouseShow

END SUB

SUB LoadData
  SHARED BlkSpr()  AS INTEGER
  SHARED BlkProps() AS BlockType
  SHARED MovCreatureSpr() AS INTEGER
 
  DIM FHandle AS INTEGER, n AS INTEGER
   
    BlkProps(1).PacSolid = TRUE: BlkProps(0).EnSolid = TRUE
    FOR n = 2 TO 11: BlkProps(n) = BlkProps(1): NEXT n
    BlkProps(12).GrabIt = TRUE
    BlkProps(13) = BlkProps(12)
    BlkProps(14) = BlkProps(1)
    BlkProps(15) = BlkProps(12)
    BlkProps(16) = BlkProps(12)
    BlkProps(17) = BlkProps(0)
    BlkProps(18) = BlkProps(17)
    BlkProps(19) = BlkProps(1): BlkProps(0).PacSolid = FALSE
    BlkProps(20) = BlkProps(19)
   
   
    FOpen "blocks10.blk" + CHR$(0), FHandle, n
     FRead FHandle, RealBytesBlk * (TotalBlkSorts + 1), VARSEG(BlkSpr(0, 0)), VARPTR(BlkSpr(0, 0))
    FClose FHandle
 
    'memory for 4 directions of creatures already used :
    ' 1, 2, 3, 4, 5, 6, 7, 10, 11, 12, 13, 14, 17, 21, 23, 29
    FOpen "pacman1A.blk" + CHR$(0), FHandle, n
     FRead FHandle, RealBytesBlk * 4, VARSEG(MovCreatureSpr(0, 1, 1)), VARPTR(MovCreatureSpr(0, 1, 1))
    FClose FHandle
    FOpen "pacman1B.blk" + CHR$(0), FHandle, n
     FRead FHandle, RealBytesBlk * 4, VARSEG(MovCreatureSpr(0, 1, 17)), VARPTR(MovCreatureSpr(0, 1, 17))
    FClose FHandle
    FOpen "en2.blk" + CHR$(0), FHandle, n
     FRead FHandle, RealBytesBlk * 4, VARSEG(MovCreatureSpr(0, 1, 2)), VARPTR(MovCreatureSpr(0, 1, 2))
    FClose FHandle
    FOpen "en2x.blk" + CHR$(0), FHandle, n
     FRead FHandle, RealBytesBlk * 4, VARSEG(MovCreatureSpr(0, 1, 2 + 8)), VARPTR(MovCreatureSpr(0, 1, 2 + 8))
    FClose FHandle
    FOpen "en3.blk" + CHR$(0), FHandle, n
     FRead FHandle, RealBytesBlk * 4, VARSEG(MovCreatureSpr(0, 1, 3)), VARPTR(MovCreatureSpr(0, 1, 3))
    FClose FHandle
    FOpen "en3x.blk" + CHR$(0), FHandle, n
     FRead FHandle, RealBytesBlk * 4, VARSEG(MovCreatureSpr(0, 1, 3 + 8)), VARPTR(MovCreatureSpr(0, 1, 3 + 8))
    FClose FHandle
    FOpen "en4.blk" + CHR$(0), FHandle, n
     FRead FHandle, RealBytesBlk * 4, VARSEG(MovCreatureSpr(0, 1, 4)), VARPTR(MovCreatureSpr(0, 1, 4))
    FClose FHandle
    FOpen "en4x.blk" + CHR$(0), FHandle, n
     FRead FHandle, RealBytesBlk * 4, VARSEG(MovCreatureSpr(0, 1, 4 + 8)), VARPTR(MovCreatureSpr(0, 1, 4 + 8))
    FClose FHandle
    FOpen "en5a.blk" + CHR$(0), FHandle, n
     FRead FHandle, RealBytesBlk * 4, VARSEG(MovCreatureSpr(0, 1, 5)), VARPTR(MovCreatureSpr(0, 1, 5))
    FClose FHandle
    FOpen "en5ax.blk" + CHR$(0), FHandle, n
     FRead FHandle, RealBytesBlk * 4, VARSEG(MovCreatureSpr(0, 1, 5 + 8)), VARPTR(MovCreatureSpr(0, 1, 5 + 8))
    FClose FHandle
    FOpen "en5b.blk" + CHR$(0), FHandle, n
     FRead FHandle, RealBytesBlk * 4, VARSEG(MovCreatureSpr(0, 1, 5 + 16)), VARPTR(MovCreatureSpr(0, 1, 5 + 16))
    FClose FHandle
    FOpen "en5bx.blk" + CHR$(0), FHandle, n
     FRead FHandle, RealBytesBlk * 4, VARSEG(MovCreatureSpr(0, 1, 5 + 8 + 16)), VARPTR(MovCreatureSpr(0, 1, 5 + 8 + 16))
    FClose FHandle
    FOpen "en6.blk" + CHR$(0), FHandle, n
     FRead FHandle, RealBytesBlk * 4, VARSEG(MovCreatureSpr(0, 1, 6)), VARPTR(MovCreatureSpr(0, 1, 6))
    FClose FHandle
    FOpen "en6x.blk" + CHR$(0), FHandle, n
     FRead FHandle, RealBytesBlk * 4, VARSEG(MovCreatureSpr(0, 1, 6 + 8)), VARPTR(MovCreatureSpr(0, 1, 6 + 8))
    FClose FHandle
    FOpen "en7.blk" + CHR$(0), FHandle, n
     FRead FHandle, RealBytesBlk * 4, VARSEG(MovCreatureSpr(0, 1, 7)), VARPTR(MovCreatureSpr(0, 1, 7))
     FRead FHandle, RealBytesBlk * 4, VARSEG(MovCreatureSpr(0, 1, 7 + 16)), VARPTR(MovCreatureSpr(0, 1, 7 + 16))
    FClose FHandle

END SUB

SUB LoadField
 SHARED PacField() AS INTEGER
 SHARED Creatures() AS CreatureType
 SHARED TotCreaturesPlaced AS INTEGER

 DIM File2Load$
 DIM Char AS STRING * 1
 DIM xB AS INTEGER, yB AS INTEGER
 DIM n AS INTEGER

 SCREEN 0: WIDTH 80, 25

 SHELL "dir *.lvl /b/w"
 INPUT "Enter level to load (no extension!)"; File2Load$

 IF File2Load$ = "" OR INSTR(File2Load$, ".") > 0 THEN
    IF INSTR(File2Load$, ".") > 0 THEN
       PRINT : PRINT "Extensions are not allowed !"
    END IF
    PRINT
    BEEP
    PRINT "Loading field canceled. Press any key.."
    SLEEP
    SCREEN 13
    SetMainPalet
    MouseInit
    MouseShow
    DrawField
  ELSE
    OPEN File2Load$ + ".lvl" FOR BINARY AS #1
      FOR yB = YMinBlockScreen TO YMaxBlockScreen
       FOR xB = XMinBlockScreen TO XMaxBlockScreen
          GET #1, , Char
          PacField(xB, yB) = ASC(Char)
       NEXT xB
      NEXT yB
    CLOSE #1
    PRINT "Do you wish to load the creature datafile of this level too (y/n)";
    DO
      Char = LCASE$(INPUT$(1))
    LOOP UNTIL Char = "y" OR Char = "n"
    IF Char = "y" THEN
      OPEN File2Load$ + ".cre" FOR BINARY AS #1
        GET #1, , TotCreaturesPlaced
        FOR n = 1 TO TotCreaturesPlaced
          GET #1, , Creatures(n).xBlk
          GET #1, , Creatures(n).yBlk
          GET #1, , Creatures(n).Species
        NEXT n
      CLOSE #1
    END IF
    PRINT
    PRINT "Loading field completed. Press any key .."
    SLEEP
    SCREEN 13
    SetMainPalet
    MouseInit
    MouseShow
    DrawField
 END IF

END SUB

SUB MakeCorrectBorders (xBlk AS INTEGER, yBlk AS INTEGER)
   'verandert de blokken die randen zijn in het passende type
 
 SHARED PacField() AS INTEGER
 SHARED BlkSpr() AS INTEGER

 DIM BlockBordersStat AS INTEGER
 DIM xB AS INTEGER, yB AS INTEGER
 DIM xMin AS INTEGER, yMin AS INTEGER
 DIM xMax AS INTEGER, yMax AS INTEGER
 
 IF yBlk > YMinBlockScreen THEN yMin = yBlk - 1 ELSE yMin = yBlk
 IF xBlk < XMaxBlockScreen THEN xMax = xBlk + 1 ELSE xMax = xBlk
 IF xBlk > XMinBlockScreen THEN xMin = xBlk - 1 ELSE xMin = xBlk
 IF yBlk < YMaxBlockScreen THEN yMax = yBlk + 1 ELSE yMax = yBlk


 'alle blokken om het nu grensblok die ook grensblok zijn moeten veranderen
 FOR yB = yMin TO yMax
 FOR xB = xMin TO xMax
  IF (ABS((xBlk - xB) + (yBlk - yB)) = 1 OR (xB = xBlk AND yB = yBlk)) AND (PacField(xB, yB) >= 1 AND PacField(xB, yB) <= 11) THEN

   BlockBordersStat = 0
   IF yB > YMinBlockScreen THEN
     IF PacField(xB, yB - 1) >= 1 AND PacField(xB, yB - 1) <= 11 THEN BlockBordersStat = BlockBordersStat + 1
   END IF
   IF xB < XMaxBlockScreen THEN
     IF PacField(xB + 1, yB) >= 1 AND PacField(xB + 1, yB) <= 11 THEN BlockBordersStat = BlockBordersStat + 2
   END IF
   IF yB < YMaxBlockScreen THEN
     IF PacField(xB, yB + 1) >= 1 AND PacField(xB, yB + 1) <= 11 THEN BlockBordersStat = BlockBordersStat + 4
   END IF
   IF xB > XMinBlockScreen THEN
     IF PacField(xB - 1, yB) >= 1 AND PacField(xB - 1, yB) <= 11 THEN BlockBordersStat = BlockBordersStat + 8
   END IF

   SELECT CASE BlockBordersStat
      CASE 0: PacField(xB, yB) = 2   ' geen grensblokken naast blok (0)
      CASE 1: PacField(xB, yB) = 2   '  alleen een grensblok boven  (1)
      CASE 2: PacField(xB, yB) = 1   '  alleen een grensblok rechts (2)
      CASE 3: PacField(xB, yB) = 11  '  grensblok rechts en boven (2+1)
      CASE 4: PacField(xB, yB) = 2   '  alleen een grensblok onder (4)
      CASE 5: PacField(xB, yB) = 2   '  grensblok onder en boven (4+1)
      CASE 6: PacField(xB, yB) = 9   '  grensblok onder en rechts (4+2)
      CASE 7: PacField(xB, yB) = 7   '  grensblok onder en rechts en boven (4+2+1)
      CASE 8: PacField(xB, yB) = 1   '  alleen grensblok links  (8)
      CASE 9: PacField(xB, yB) = 10  '  grensblok links en boven (8+1)
      CASE 10: PacField(xB, yB) = 1  '  grensblok links en rechts (8+2)
      CASE 11: PacField(xB, yB) = 4  '  grensblok links,rechts en boven (8+2+1)
      CASE 12: PacField(xB, yB) = 8  '  grensblok links en onder (8+4)
      CASE 13: PacField(xB, yB) = 6  '  grensblok links,onder en boven (8+4+1)
      CASE 14: PacField(xB, yB) = 5  '  grensblok links,onder en rechts (8+4+2)
      CASE 15: PacField(xB, yB) = 3  '  grensblok links,onder,rechts en boven (8+4+2+1)
   END SELECT
 

   PsetSprite ((xB - 1) * XBlockSize), (yB - 1) * YBlockSize, BlkSpr(0, PacField(xB, yB))
   LINE ((xB - 1) * XBlockSize, (yB - 1) * YBlockSize)-STEP(XBlockSize, YBlockSize), 7, B
 
  'IF xB = xBlk AND yB = yBlk THEN
    'LOCATE 1, 1: PRINT BlockBordersStat
    'LINE ((xB - 1) * XBlockSize, (yB - 1) * YBlockSize)-STEP(XBlockSize, YBlockSize), 7, B
    'SLEEP
  'END IF
 
  END IF
 NEXT xB
 NEXT yB


END SUB

SUB NewField
 SHARED PacField() AS INTEGER

 DIM xB AS INTEGER
 DIM yB AS INTEGER
 
  mousehide
  
  FOR yB = YMinBlockScreen TO YMaxBlockScreen
    FOR xB = XMinBlockScreen TO XMaxBlockScreen
      PacField(xB, yB) = 0
    NEXT xB
  NEXT yB
  DrawField

  MouseShow

END SUB

SUB Quit

  SCREEN 0: WIDTH 80, 25
  END

END SUB

SUB SaveField
 SHARED PacField() AS INTEGER
 SHARED Creatures() AS CreatureType
 SHARED TotCreaturesPlaced AS INTEGER

 DIM Save2File$
 DIM Char AS STRING * 1
 DIM xB AS INTEGER
 DIM yB AS INTEGER


 IF Creatures(1).Species <> 1 THEN
    TextButton 50, 90, "THERE'S NO PACMAN IN YOUR FIELD !", 0
    BEEP: SLEEP
    DrawField
    EXIT SUB
 END IF


 SCREEN 0: WIDTH 80, 25

 INPUT "Save field to file (no extension !) ", Save2File$

 IF Save2File$ = "" OR Creatures(1).Species <> 1 THEN
    PRINT
    PRINT "Saving field interrupted. Press any key."
    BEEP: SLEEP
    SCREEN 13
    SetMainPalet
    MouseInit
    MouseShow
    DrawField
  ELSE
    OPEN Save2File$ + ".lvl" FOR BINARY AS #1
      FOR yB = YMinBlockScreen TO YMaxBlockScreen
       FOR xB = XMinBlockScreen TO XMaxBlockScreen
          Char = CHR$(PacField(xB, yB))
          PUT #1, , Char
       NEXT xB
      NEXT yB
    CLOSE #1
    OPEN Save2File$ + ".cre" FOR BINARY AS #1
      PUT #1, , TotCreaturesPlaced
      FOR n = 1 TO TotCreaturesPlaced
        PUT #1, , Creatures(n).xBlk
        PUT #1, , Creatures(n).yBlk
        PUT #1, , Creatures(n).Species
      NEXT n
    CLOSE #1
   
    PRINT
    PRINT "Saving field completed. Press any key."
    SLEEP
    SCREEN 13
    SetMainPalet
    MouseInit
    MouseShow
    DrawField
 END IF

END SUB

SUB SetMainPalet
DIM Col AS INTEGER, R AS INTEGER, G AS INTEGER, B AS INTEGER, Char AS STRING * 1
  OPEN "MAIN.PAL" FOR BINARY AS #1
      FOR Col = 0 TO 255
        GET #1, , Char: R = ASC(Char)
        GET #1, , Char: G = ASC(Char)
        GET #1, , Char: B = ASC(Char)
        SetPal Col, R, G, B
      NEXT Col
  CLOSE #1
END SUB

SUB Test
 SHARED PacField() AS INTEGER
 SHARED BlkSpr() AS INTEGER
 SHARED xCursor AS INTEGER, yCursor AS INTEGER
 SHARED MovCreatureSpr() AS INTEGER
 SHARED Creatures() AS CreatureType
 SHARED TotCreaturesPlaced AS INTEGER
   

 DIM xB AS INTEGER, yB AS INTEGER
 DIM X AS INTEGER, y AS INTEGER

  mousehide

  'SHELL "mapview pic001.map"
  FillBar 0, 0, 320, 200, 24

  y = (YMinBlockScreen - 2) * YBlockSize
  FOR yB = YMinBlockScreen TO YMaxBlockScreen
    y = y + YBlockSize
    X = (XMinBlockScreen - 2) * XBlockSize
    FOR xB = XMinBlockScreen TO XMaxBlockScreen
        X = X + XBlockSize
        IF PacField(xB, yB) > 0 THEN
            PsetSprite X, y, BlkSpr(0, PacField(xB, yB))
        END IF
    NEXT xB
  NEXT yB
 
  FOR n = 1 TO TotCreaturesPlaced
    PutSprite ((Creatures(n).xBlk - 1) * XBlockSize), (Creatures(n).yBlk - 1) * YBlockSize, MovCreatureSpr(0, 1, Creatures(n).Species)
  NEXT n
 
  DO
   MouseStatus X, y, But%
  LOOP UNTIL INKEY$ <> "" OR But% <> 0
 
  MouseShow
  DrawField

END SUB

