Unit ConfUnit;

interface

Procedure LoadWinner;
Procedure SaveWinner;
Procedure SaveConfig;
Procedure LoadConfig;
Procedure SaveStatus;
Procedure LoadStatus;
Procedure SaveRec(Num:Byte);
Procedure LoadRec(Num:Byte);
Procedure SaveRace;
Procedure LoadRace;
Procedure SaveSlot;
Procedure LoadSlot;

implementation

Uses Crt,Dos,Sound,Road,Joys,Graphics,General,NetUnit;

Const Ncurs = 70;
Var   Auxi :Integer;

Procedure LoadConfig;
var f:file;
allca,Auto1,Auto2:byte;
begin
assign(f,'Heats.CFG');
reset(f,1);

Blockread(f,DemoRel,1);
Blockread(f,MySlot,1);
Blockread(f,MaxNetPl,1);
Blockread(f,Difficulty,1);

Blockread(f,AllCa ,1);
AllCars:=Allca=1;

Blockread(f,GameMode,1);
Blockread(f,Detail,1);
Blockread(f,Maxdistance,1);

Blockread(f,Mirror,1);

Blockread(f,CdVol,1);
Blockread(f,DgVol,1);
Blockread(f,TypeCon1,1);
Blockread(f,TypeCon2,1);
Blockread(f,CarPl1,1);
Blockread(f,CarPl2,1);

Blockread(f,Auto1,1);

Blockread(f,Auto2,1);
 Car[2].AutoMatic:=Auto2=1;
 Car[Myslot].AutoMatic:=Auto1=1;

Blockread(f,Numpla,1);

Blockread(f,IRQ,1);
Blockread(f,BASEPORT,2);
Blockread(f,DMA,2);
Blockread(f,Xcenter1,2);
Blockread(f,Ycenter1,2);

Blockread(f,MinX1,2);
Blockread(f,MaxX1,2);
Blockread(f,MinY1,2);
Blockread(f,MaxY1,2);
Blockread(f,Up1,2);
Blockread(f,Dw1,2);
Blockread(f,Lf1,2);
Blockread(f,Rg1,2);
Blockread(f,Ba1,2);
Blockread(f,Bb1,2);
Blockread(f,Up2,2);
Blockread(f,Dw2,2);
Blockread(f,Lf2,2);
Blockread(f,Rg2,2);
Blockread(f,Ba2,2);
Blockread(f,Bb2,2);
Blockread(f,RouAva,1);
close(f);

 XPosTol1:=MaxX1 *2;
 XNegTol1:=MinX1 *2;
 YPosTol1:=MaxY1 *3;
 YNegTol1:=MinY1 *3;

end;

Procedure SaveConfig;
var f:file;
    AllCa,Auto1,Auto2:byte;
begin
assign(f,'Heats.CFG');
rewrite(f,1);
Blockwrite(f,DemoRel,1);
BlockWrite(f,MySlot,1);
BlockWrite(f,MaxNetPl,1);
Blockwrite(f,Difficulty,1);

 AllCa:=ord(AllCars);
Blockwrite(f,AllCa,1);

Blockwrite(f,GameMode,1);
Blockwrite(f,Detail,1);
Blockwrite(f,Maxdistance,1);

Blockwrite(f,Mirror,1);

Blockwrite(f,CdVol,1);
Blockwrite(f,DgVol,1);
Blockwrite(f,TypeCon1,1);
Blockwrite(f,Typecon2,1);
Blockwrite(f,CarPl1,1);

Blockwrite(f,CarPl2,1);

 Auto1:=Ord(Car[Myslot].AutoMatic);
Blockwrite(f,Auto1,1);

 Auto2:=Ord(Car[2].AutoMatic);

Blockwrite(f,Auto2,1);

Blockwrite(f,Numpla,1);
Blockwrite(f,IRQ,1);
Blockwrite(f,BASEPORT,2);
Blockwrite(f,DMA,2);
Blockwrite(f,Xcenter1,2);
Blockwrite(f,Ycenter1,2);

Blockwrite(f,MinX1,2);
Blockwrite(f,MaxX1,2);
Blockwrite(f,MinY1,2);
Blockwrite(f,MaxY1,2);

Blockwrite(f,Up1,2);
Blockwrite(f,Dw1,2);
Blockwrite(f,Lf1,2);
Blockwrite(f,Rg1,2);
Blockwrite(f,Ba1,2);
Blockwrite(f,Bb1,2);
Blockwrite(f,Up2,2);
Blockwrite(f,Dw2,2);
Blockwrite(f,Lf2,2);
Blockwrite(f,Rg2,2);
Blockwrite(f,Ba2,2);
Blockwrite(f,Bb2,2);
Blockwrite(f,RouAva,1);
Close(F);
end;

Procedure LoadStatus;
var f:file;
begin
assign(f,'Heats.Sta');
reset(f,1);
Blockread(f,Cround,1);
close(f);
end;

Procedure SaveStatus;
var f:file;
begin
assign(f,'Heats.Sta');
rewrite(f,1);
Blockwrite(f,Cround,1);
Close(F);
end;

Procedure LoadRace;
Var f:File;
begin
assign(f,'Race.Sta');
reset(f,1);
Blockread(f,Car[1].Points,1);
Blockread(f,Car[2].Points,1);
Blockread(f,Car[3].Points,1);
Blockread(f,Car[4].Points,1);
Blockread(f,Car[5].Points,1);
Blockread(f,Car[6].Points,1);
Blockread(f,Car[7].Points,1);
Blockread(f,Car[8].Points,1);
Blockread(f,Car[1].Chassis,1);
Blockread(f,Car[2].Chassis,1);
Blockread(f,Car[3].Chassis,1);
Blockread(f,Car[4].Chassis,1);
Blockread(f,Car[5].Chassis,1);
Blockread(f,Car[6].Chassis,1);
Blockread(f,Car[7].Chassis,1);
Blockread(f,Car[8].Chassis,1);
Blockread(f,Safe,1);
close(f);
end;

Procedure SaveRace;
var f:file;
begin
assign(f,'Race.Sta');
rewrite(f,1);
Blockwrite(f,Car[1].Points,1);
Blockwrite(f,Car[2].Points,1);
Blockwrite(f,Car[3].Points,1);
Blockwrite(f,Car[4].Points,1);
Blockwrite(f,Car[5].Points,1);
Blockwrite(f,Car[6].Points,1);
Blockwrite(f,Car[7].Points,1);
Blockwrite(f,Car[8].Points,1);
Blockwrite(f,Car[1].Chassis,1);
Blockwrite(f,Car[2].Chassis,1);
Blockwrite(f,Car[3].Chassis,1);
Blockwrite(f,Car[4].Chassis,1);
Blockwrite(f,Car[5].Chassis,1);
Blockwrite(f,Car[6].Chassis,1);
Blockwrite(f,Car[7].Chassis,1);
Blockwrite(f,Car[8].Chassis,1);
Blockwrite(f,Safe,1);
Close(F);
end;

Procedure SaveRec(Num:Byte);
var f:file;
begin
assign(f,'Tracks\Tr'+ToStr(Num,0)+'Rec.Sta');
rewrite(f,1);
Blockwrite(f,Byte(RecTime.m),1);
Blockwrite(f,Byte(RecTime.s),1);
Blockwrite(f,Byte(RecTime.c),1);
Blockwrite(f,RecId,4);
Close(F);
end;

Procedure LoadRec(Num:Byte);
var f:file;
Aux:byte;
begin
assign(f,'Tracks\Tr'+ToStr(Num,0)+'Rec.Sta');
reset(f,1);
BlockRead(f,Aux,1);
RecTime.m:=Aux;
BlockRead(f,Aux,1);
RecTime.s:=Aux;
BlockRead(f,Aux,1);
RecTime.c:=Aux;
BlockRead(f,RecId,4);
Close(F);
end;

Procedure LoadSlot;
var f:file;
Aux:byte;
begin
assign(f,'NetSlot.Sta');
reset(f,1);
For Aux:=1 to 8 do BlockRead(f,Ids[Aux],4);
Close(F);
end;

Procedure SaveSlot;
var f:file;
Aux:byte;
begin
assign(f,'NetSlot.Sta');
rewrite(f,1);
For Aux:=1 to 8 do BlockWrite(f,Ids[Aux],4);
Close(F);
end;

Procedure LoadWinner;
var f:file;
cnt,Aux:byte;
begin
assign(f,'Winners.Sta');
reset(f,1);
for cnt:=1 to 9 do Blockread(f,Winners[cnt],4);
for cnt:=1 to 9 do Blockread(f,WinCars[cnt],1);
Blockread(f,LastWinner,1);
Close(F);
end;

Procedure SaveWinner;
var f:file;
Aux,cnt:byte;
begin
assign(f,'Winners.Sta');
rewrite(f,1);
for cnt:=1 to 9 do Blockwrite(f,Winners[cnt],4);
for cnt:=1 to 9 do Blockwrite(f,WinCars[cnt],1);
Blockwrite(f,LastWinner,1);
Close(F);
end;

begin
end.