Unit CamUnit;

interface
Uses ROAD,PERSPECT,GRAPHICS,KEYB,SOUND,GENERAL;
Function ProxCam(NumCar:byte):byte;
Procedure TraceRoadCam(NumCam:byte; AziX,AziY:integer; Rap:Byte);
Procedure TraceRoadMir(NumCam:byte; AziX,AziY:integer; Rap:Byte);
Procedure TraceCarsCam(Num,X,Y,Z,Angle,Brise,Cdim,Offset,Azimuth: integer; N:byte);
Procedure TraceSPCCam (Num,X,Y,Z,Angle,Brise,Cdim,Offset,Azimuth: integer; N:byte; Hide:Boolean);
Procedure ControlCam(Num,Fun,Opt:byte);
Procedure PilotCam  (Num:byte);
Procedure PlaceCam  (Num:byte;iSec: PuntSec;iX,iZ,iY: extended; iAngle: Integer);
Procedure CamNextSec(Num: byte);
Procedure CamLastSec(Num: byte);


implementation

Var
Rotangle:integer;

(*************************** START CAMING ******************************)
(*************************** START CAMING ******************************)
(*************************** START CAMING ******************************)

Function ProxCam(NumCar:byte):byte;
var
Dist      :integer;
NumSecCar :integer;
Examine   :integer;
cnt       :byte;

begin
NumSecCar:=Car[NumCar].Sec^.NumSec;
Proxcam:=1;Dist:=300;
for cnt:=1 to 20 do begin
 Examine:=abs(CamSetting[cnt].NumSec-NumSecCar);
 if Examine>Groad.Maxsec div 2 then Examine:=Groad.Maxsec-Examine;
 if (Examine<Dist) then begin Dist:=Examine; ProxCam:=Cnt; end
end
end;

Procedure TraceRoadCam(NumCam:byte; AziX,AziY: integer; Rap:Byte);
var Pcos,Psen,Xfond,Yfond: integer;

begin
 ChgRap(Rap);
 Fillchar(chk,SizeOf(Chk),0);
 Azimuth :=AziY+20;
 Ymy     :=trunc(Cam[NumCam].Y);

 Yfond:=(-Cam[NumCam].Grise div 50*Cs[Cam[NumCam].Angle+180] div 128) shl SVGA;
 if Yfond> 20 shl SVGA then Yfond:= 20 shl SVGA else
 if Yfond<-20 shl SVGA then Yfond:=-20 shl SVGA;

 inc(Yfond,AziY-80);

 Xfond:=(Cam[NumCam].GAngle shl 2) mod 160;
 if Xfond<0 then inc(Xfond,160);

 Bar(0,0,319 Shl SVGA,Yfond,Skycol);

 Bar(0,Yfond+BackDy,319 Shl SVGA,199 Shl SVGA,BackCol);

 Back(MaxBobs,Xfond-160,Yfond);
 CurrSecdist:=0;

 if Not Cam[NumCam].Reverse then begin
  aux1 :=Cam[NumCam].Sec;
  drawed:=0;
  totalpoints:=0;
  cnt2:=2;

  baserise:=-Cam[NumCam].CurrRise;
  rise:=0;

  BaseAngle:=Cam[NumCam].Angle;
  AdjOffset:=AziX shl SVGA+(Cam[NumCam].Angle*10 div 2 mod 5 div 2) shl 1;
  Angle:=BaseAngle mod 360; if Angle<0 then inc(Angle,360);
  Angle:=360-Angle;

  x:=integer( longint(trunc(Cam[NumCam].Z))*sn[Angle] div 128+longint(trunc(Cam[NumCam].X))*cs[Angle] div 128);
  z:=integer(-longint(trunc(Cam[NumCam].Z))*cs[Angle] div 128+longint(trunc(Cam[NumCam].X))*sn[Angle] div 128)-80;

  for cnt1:=1 to 3 do begin
   if (aux1^.turn<>0) then begin
    dec(BaseAngle,aux1^.turn);
    Angle:=BaseAngle mod 360; if Angle<0 then inc(Angle,360);
    Angle:=360-Angle;
    inc(x,longint(aux1^.taxis)*sn[Angle] div 128);
    dec(z,longint(aux1^.taxis)*cs[Angle] div 128);
   end else begin
    inc(x,longint(SecDistance)*sn[Angle] div 128);
    dec(z,longint(SecDistance)*cs[Angle] div 128);
   end;
   aux1:=Aux1^.last;
  end;

  while (cnt2<maxdistance) do begin

   (*************************** CAMING ******************************)

   if (Aux1^.NumCar>0) or (Aux1^.NumSmk>0) or (Aux1^.NumSpc>0) then begin
    Xsec[cnt2]:=x;
    Ysec[cnt2]:=Ymy-rise div 15;
    Zsec[cnt2]:=z+128;
    Bsec[cnt2]:=BaseRise;
    Asec[cnt2]:=Angle;
    Cdim[cnt2]:=CurrSecDist;
   end;

   currpoint:=totalpoints;
   Pcos:=cs[Angle];
   Psen:=sn[Angle];
   for cnt1:=1 to aux1^.maxpn do begin
    inc(currpoint);
    efx :=    aux1^.x[cnt1] div 4;
    auxx:=integer(efx*Pcos div 32)+x;
    auxz:=integer(efx*Psen div 32)+z+128;
    if (abs(auxx)<700+auxz shr 2) and (auxz>0) then begin
     auxy:=ymy-aux1^.y[cnt1]-rise div 15;
     auxz:=auxz shr 4+1;
     px[currpoint]:=(auxx shl PRAP2 div auxz)shl SVGA+AdjOffset;
     py[currpoint]:=(auxy shl PRAP2 div auxz)shl SVGA+azimuth;
     if px[currpoint]> 840 then px[currpoint]:= 840 else
     if px[currpoint]<-200 then px[currpoint]:=-200;
     chk[currpoint]:=true;
    end else chk[currpoint]:=false;
   end;
   aux1:=aux1^.Next;
   inc(totalpoints,30);
   inc(cnt2);
   if (aux1^.turn<>0) then begin
    dec(x,longint(aux1^.taxis+CurrSecDist)*Psen div 128);
    inc(z,longint(aux1^.taxis+CurrSecDist)*Pcos div 128);
    inc(BaseAngle,aux1^.turn);
    Angle:=BaseAngle mod 360; if Angle<0 then inc(Angle,360);
    Angle:=360-Angle;
   end else begin
    dec(x,longint(SecDistance+CurrSecDist)*sn[Angle] div 128);
    inc(z,longint(SecDistance+CurrSecDist)*cs[Angle] div 128);
   end;

   if cnt2>4 then begin
    inc(baserise ,aux1^.rise); inc(rise,baserise);
    if cnt2>10 then inc(CurrSecDist,10);
   end;
   inc(drawed);
  end;

  while drawed>0 do begin
   (*************************** CAMING ******************************)

   dec(drawed);
   aux1:=aux1^.last;
   edgebase:=drawed*30;
   curpol:=aux1^.ppolys;

    if Aux1^.Last^.NumSPC>0 then
    TraceSPCCam (NumCam,Xsec[Drawed+1],
                        Ysec[Drawed+1],
                        Zsec[Drawed+1],
                        Asec[Drawed+1],
                        Bsec[Drawed+1],
                        Cdim[Drawed+1],AdjOffset,Azimuth,Aux1^.Last^.NumSPC,True);


   while curpol<>nil do begin
    edge[1]:=edgebase+curpol^.edge[1];
    edge[2]:=edgebase+curpol^.edge[2];
    edge[3]:=edgebase+curpol^.edge[3];if curpol^.edge[3]=0 then chk[edge[3]]:=true;
    edge[4]:=edgebase+curpol^.edge[4];if curpol^.edge[4]=0 then chk[edge[4]]:=true;

    if chk[edge[1]] and chk[edge[2]] and chk[edge[3]] and chk[edge[4]] and
        (edge[1]<750) and (edge[2]<750)
    and (edge[3]<750) and (edge[4]<750) then begin

     pv1:=(py[edge[2]]-py[edge[1]]);
     pv2:=(px[edge[3]]-px[edge[1]]);
     pv3:=(px[edge[2]]-px[edge[1]]);
     pv4:=(py[edge[3]]-py[edge[1]]);

     if (pv1*pv2<pv3*pv4+150) then begin

      (*************************** CAMING ******************************)

      tipo:=curpol^.tipo;
      colr:=curpol^.color;

      if (tipo=0) and (edge[1]>0) and (edge[2]>0) then
      line      (px[edge[1]],py[edge[1]],px[edge[2]],py[edge[2]],colr  ) else
      if (tipo=1) and (edge[1]>0) and (edge[2]>0) and (edge[3]>0) and (edge[4]>0) then
      polygon   (px[edge[1]],py[edge[1]],px[edge[2]],py[edge[2]],
                 px[edge[3]],py[edge[3]],px[edge[4]],py[edge[4]],colr) else
      if (tipo=2) and (edge[1]>0) and (edge[2]>0) and (edge[3]>0) and (edge[4]>0) and (drawed>15) then
      polygon   (px[edge[1]],py[edge[1]],px[edge[2]],py[edge[2]],
                px[edge[3]],py[edge[3]],px[edge[4]],py[edge[4]],colr) else
      if (tipo=4) and (edge[1]>0) and (edge[2]>0) and(tipo=4)  and (Px[edge[1]]>-200) and (Px[Edge[1]]<840) then
      frbob    (colr,px[edge[1]],py[edge[1]],px[edge[2]],py[edge[2]],3);
      if (tipo=5) and (edge[1]>0) and (edge[2]>0) and (edge[3]>0) and (edge[4]>0) then
      vmapbob   (px[edge[1]],px[edge[2]],py[edge[1]],py[edge[2]],py[edge[3]],py[edge[4]],colr) else
      if (tipo=6) and (edge[1]>0) and (edge[2]>0) and (edge[3]>0) and (edge[4]>0) then
      mapbob    (px[edge[1]],py[edge[1]],px[edge[2]],py[edge[2]],
                 px[edge[3]],py[edge[3]],px[edge[4]],py[edge[4]],colr) else
      if (tipo=7) and (edge[1]>0) and (edge[2]>0) and (edge[3]>0) and (edge[4]>0) then
      tvmapbob  (px[edge[1]],px[edge[2]],py[edge[1]],py[edge[2]],py[edge[3]],py[edge[4]],colr) else
      if (tipo=8) and (edge[1]>0) and (edge[2]>0) and (edge[3]>0) and (edge[4]>0) then
      tmapbob   (px[edge[1]],py[edge[1]],px[edge[2]],py[edge[2]],
                px[edge[3]],py[edge[3]],px[edge[4]],py[edge[4]],colr);
     end
    end;
    curpol:=curpol^.Next;
   end;
   if (Drawed<Maxdistance-6) then begin
    if Aux1^.Next^.NumSPC>0 then
    TraceSPCCam (NumCam,Xsec[Drawed+3],
                        Ysec[Drawed+3],
                        Zsec[Drawed+3],
                        Asec[Drawed+3],
                        Bsec[Drawed+3],
                        Cdim[Drawed+3],AdjOffset,Azimuth,Aux1^.Next^.NumSPC,False);

    if Aux1^.Next^.NumCar>0 then
    TraceCarsCam(NumCam,Xsec[Drawed+3],
                        Ysec[Drawed+3],
                        Zsec[Drawed+3],
                        Asec[Drawed+3],
                        Bsec[Drawed+3],
                        Cdim[Drawed+3],AdjOffset,Azimuth,Aux1^.Next^.NumCar);

    if Aux1^.Next^.NumSmk>0 then
    TraceSmk    (NumCam,Xsec[Drawed+3],
                        Ysec[Drawed+3],
                        Zsec[Drawed+3],
                        Asec[Drawed+3],
                        Cdim[Drawed+3],AdjOffset,Azimuth,Aux1^.Next^.NumSmk);

   end
  end
 end else begin

(*******************************************************************)
(********************* CAM IN REVERSE ******************************)
(*******************************************************************)

  aux1 :=Cam[NumCam].Sec;
  drawed:=0;
  totalpoints:=720;
  cnt2:=2;

  baserise:=-Cam[NumCam].CurrRise;
  rise:=0;

  BaseAngle:=Cam[NumCam].Angle;
  AdjOffset:=AziX shl SVGA+(Cam[NumCam].Angle*10 div 2 mod 5 div 2) shl 1;
  Angle:=BaseAngle mod 360; if Angle<0 then inc(Angle,360);
  Angle:=360-Angle;

  x:= integer( longint(trunc(-Cam[NumCam].Z))*sn[Angle] div 128+longint(trunc(-Cam[NumCam].X))*cs[Angle] div 128);
  z:= integer(-longint(trunc(-Cam[NumCam].Z))*cs[Angle] div 128+longint(trunc(-Cam[NumCam].X))*sn[Angle] div 128)-80;
  for cnt1:=1 to 4 do begin
   Aux1:=Aux1^.Next;
   if aux1^.turn<>0 then begin
    inc(x,longint(aux1^.taxis)*sn[Angle] div 128);
    dec(z,longint(aux1^.taxis)*cs[Angle] div 128);
    dec(BaseAngle,-aux1^.turn);
    Angle:=BaseAngle mod 360; if Angle<0 then inc(Angle,360);
    Angle:=360-Angle;
   end else begin
    inc(x,longint(SecDistance)*sn[Angle] div 128);
    dec(z,longint(SecDistance)*cs[Angle] div 128);
   end;
  end;

  Pcos:=cs[Angle];
  Psen:=sn[Angle];

  while (cnt2<maxdistance) do begin

   (*************************** CAMING ******************************)

   if (Aux1^.NumCar>0) or (Aux1^.NumSmk>0) or (Aux1^.NumSpc>0) then begin
    Xsec[cnt2]:=x;
    Ysec[cnt2]:=Ymy-rise div 15;
    Zsec[cnt2]:=z+128;
    Bsec[cnt2]:=BaseRise;
    Asec[cnt2]:=Angle;
    Cdim[cnt2]:=CurrSecDist;
   end;

   currpoint:=totalpoints;
   for cnt1:=1 to aux1^.maxpn do begin
    inc(currpoint);
    efx :=   -aux1^.x[cnt1] div 4;
    auxx:=  integer(efx*Pcos div 32)+x;
    auxz:=  integer(efx*Psen div 32)+z+128;
    if (abs(auxx)<700+auxz shr 2) and (auxz>0) then begin
     auxy:=ymy-aux1^.y[cnt1]-rise div 15;
     auxz:=auxz shr 4+1;
     px[currpoint]:=auxx shl PRAP2 div auxz shl SVGA+AdjOffset;
     py[currpoint]:=auxy shl PRAP2 div auxz shl SVGA+azimuth;
     if px[currpoint]> 840 then px[currpoint]:= 840 else
     if px[currpoint]<-200 then px[currpoint]:=-200;
     chk[currpoint]:=true;
    end else chk[currpoint]:=false;
   end;
   dec(totalpoints,30);
   inc(cnt2);
   if (aux1^.turn<>0) then begin
    inc(BaseAngle,-aux1^.turn);
    Angle:=BaseAngle mod 360; if Angle<0 then inc(Angle,360);
    Angle:=360-Angle;
    Pcos:=cs[Angle];
    Psen:=sn[Angle];
    dec(x,longint(aux1^.taxis+CurrSecDist)*Psen div 128);
    inc(z,longint(aux1^.taxis+CurrSecDist)*Pcos div 128);
   end else begin
    dec(x,longint(SecDistance+CurrSecDist)*Psen div 128);
    inc(z,longint(SecDistance+CurrSecDist)*Pcos div 128);
   end;
   if cnt2>6 then begin
    inc(baserise ,aux1^.rise); inc(rise,baserise);
    if cnt2>10 then inc(CurrSecDist,10);
   end;
   inc(drawed);
   aux1:=aux1^.last;
  end;

  while drawed>0 do begin

   (*************************** CAMING ******************************)

   dec(drawed);
   aux1:=aux1^.Next;
   edgebase:=720-drawed*30;
   curpol:=aux1^.ppolys;

    if Aux1^.Next^.NumSPC>0 then
    TraceSPCCam (NumCam,Xsec[Drawed+1],
                        Ysec[Drawed+1],
                        Zsec[Drawed+1],
                        Asec[Drawed+1]+180,
                        Bsec[Drawed+1],
                        Cdim[Drawed+1],AdjOffset,Azimuth,Aux1^.Next^.NumSPC,True);

   while curpol<>nil do begin
    edge[1]:=edgebase+curpol^.edge[1];
    edge[2]:=edgebase+curpol^.edge[2];
    edge[3]:=edgebase+curpol^.edge[3];if curpol^.edge[3]=0 then chk[edge[3]]:=true;
    edge[4]:=edgebase+curpol^.edge[4];if curpol^.edge[4]=0 then chk[edge[4]]:=true;

    if chk[edge[1]] and chk[edge[2]] and chk[edge[3]] and chk[edge[4]] and
        (edge[1]<750) and (edge[2]<750)
    and (edge[3]<750) and (edge[4]<750) then begin

     pv1:=py[edge[2]]-py[edge[1]];
     pv2:=px[edge[3]]-px[edge[1]];
     pv3:=px[edge[2]]-px[edge[1]];
     pv4:=py[edge[3]]-py[edge[1]];

     if (pv1*pv2<pv3*pv4+150) then begin

      (*************************** CAMING ******************************)

      tipo:=curpol^.tipo;
      colr:=curpol^.color;

      if(tipo=0) and (edge[1]>0) and (edge[2]>0) then
      line      (px[edge[1]],py[edge[1]],px[edge[2]],py[edge[2]],colr  ) else
      if(tipo=1) and (edge[1]>0) and (edge[2]>0) and (edge[3]>0) and (edge[4]>0) then
      polygon   (px[edge[1]],py[edge[1]],px[edge[2]],py[edge[2]],
                 px[edge[3]],py[edge[3]],px[edge[4]],py[edge[4]],colr  ) else
      if (tipo=2) and (edge[1]>0) and (edge[2]>0) and (edge[3]>0) and (edge[4]>0) and (drawed>15) then
      polygon   (px[edge[1]],py[edge[1]],px[edge[2]],py[edge[2]],
                 px[edge[3]],py[edge[3]],px[edge[4]],py[edge[4]],colr  ) else
      if(tipo=4) and (edge[1]>0) and (edge[2]>0)  and (Px[edge[1]]>-200) and (Px[Edge[1]]<840) then
      frbob    (colr,px[edge[1]],py[edge[1]],px[edge[2]],py[edge[2]],3) else
      if(tipo=5) and (edge[1]>0) and (edge[2]>0) and (edge[3]>0) and (edge[4]>0) then
      vmapbob   (px[edge[1]],px[edge[2]],py[edge[1]],py[edge[2]],py[edge[3]],py[edge[4]],colr) else
      if(tipo=6) and (edge[1]>0) and (edge[2]>0) and (edge[3]>0) and (edge[4]>0) then
      mapbob    (px[edge[1]],py[edge[1]],px[edge[2]],py[edge[2]],
                px[edge[3]],py[edge[3]],px[edge[4]],py[edge[4]],colr) else
      if(tipo=7) and (edge[1]>0) and (edge[2]>0) and (edge[3]>0) and (edge[4]>0) then
      tvmapbob  (px[edge[1]],px[edge[2]],py[edge[1]],py[edge[2]],py[edge[3]],py[edge[4]],colr) else
      if(tipo=8) and (edge[1]>0) and (edge[2]>0) and (edge[3]>0) and (edge[4]>0) then
      tmapbob   (px[edge[1]],py[edge[1]],px[edge[2]],py[edge[2]],
                 px[edge[3]],py[edge[3]],px[edge[4]],py[edge[4]],colr);
     end
    end;
    curpol:=curpol^.Next;
   end;
   if (Drawed<Maxdistance-6) then begin
    if Aux1^.Last^.NumSPC>0 then
    TraceSPCCam (NumCam,Xsec[Drawed+3],
                        Ysec[Drawed+3],
                        Zsec[Drawed+3],
                        Asec[Drawed+3]+180,
                        Bsec[Drawed+3],
                        Cdim[Drawed+3],AdjOffset,Azimuth,Aux1^.Last^.NumSPC,False);

    if Aux1^.Last^.NumCar>0 then
    TraceCarsCam(NumCam,Xsec[Drawed+3],
                        Ysec[Drawed+3],
                        Zsec[Drawed+3],
                        Asec[Drawed+3]+180,
                        Bsec[Drawed+3],
                        Cdim[Drawed+3],AdjOffset,Azimuth,Aux1^.Last^.NumCar);

    if Aux1^.Last^.NumSmk>0 then
    TraceSmk    (NumCam,Xsec[Drawed+3],
                        Ysec[Drawed+3],
                        Zsec[Drawed+3],
                        Asec[Drawed+3]+180,
                        Cdim[Drawed+3],AdjOffset,Azimuth,Aux1^.Last^.NumSmk);

    end
  end;
  Fillchar(chk,SizeOf(Chk),0);
 end;
ChgRap(5);
end;

(*************************** END CAMING ******************************)
(*************************** END CAMING ******************************)
(*************************** END CAMING ******************************)
Procedure ControlCam (Num,Fun,Opt: byte);
var AuxAngle: integer;
    IncAngle: integer;
    AuxSec  : puntSec;
    cnt     : integer;
begin
if fun=10 then begin Cam[Num].Enable:=True;
 if keystate(77) then dec(Cam[num].Angle,5);
 if keystate(75) then inc(Cam[num].Angle,5);
 if keystate(72) then Cam[num].speed:= 100  else
 if keystate(80) then Cam[num].speed:=-100  else Cam[num].Speed:=0;
 if keystate(78) then begin
                      inc(NumCamPos);if NumCamPos>20 then NumCamPos:=1;
                      AuxSec:=Groad.Primo;
                      for cnt:=1 to CamSetting[NumCamPos].NumSec-1 do AuxSec:=AuxSec^.Next;
                      Cam[num].Sec    :=AuxSec;
                      Cam[num].X      :=CamSetting[NumCamPos].X;
                      Cam[num].Y      :=CamSetting[NumCamPos].Y;
                      Cam[num].Z      :=CamSetting[NumCamPos].Z;
                      Cam[num].Angle  :=CamSetting[NumCamPos].Angle;
                      Cam[num].Orizont:=CamSetting[NumCamPos].Orizont;
                      Cam[num].Reverse:=CamSetting[NumCamPos].Reverse;
                      end;
 if keystate(74) then begin
                      dec(NumCamPos);if NumCamPos<1 then NumCamPos:=20;
                      AuxSec:=Groad.Primo;
                      for cnt:=1 to CamSetting[NumCamPos].NumSec-1 do AuxSec:=AuxSec^.Next;
                      Cam[num].Sec    :=AuxSec;
                      Cam[num].X      :=CamSetting[NumCamPos].X;
                      Cam[num].Y      :=CamSetting[NumCamPos].Y;
                      Cam[num].Z      :=CamSetting[NumCamPos].Z;
                      Cam[num].Angle  :=CamSetting[NumCamPos].Angle;
                      Cam[num].Orizont:=CamSetting[NumCamPos].Orizont;
                      Cam[num].Reverse:=CamSetting[NumCamPos].Reverse;
                      end;
 repeat until not keystate(74) and not keystate(78);
 if keystate(81) then Cam[num].Y:=Cam[num].y-1;
 if keystate(73) then Cam[num].Y:=Cam[num].y+1;
 if keystate(82) then inc(Cam[num].Orizont);
 if keystate(83) then dec(Cam[num].Orizont);

 if Cam[num].Y<30 then Cam[num].Y:=30;
 CamSetting[NumCamPos].NumSec :=Cam[Num].Sec^.NumSec;
 CamSetting[NumCamPos].X      :=trunc(Cam[Num].X);
 CamSetting[NumCamPos].Y      :=trunc(Cam[Num].Y);
 CamSetting[NumCamPos].Z      :=trunc(Cam[Num].Z);
 CamSetting[NumCamPos].Angle  :=Cam[Num].Angle;
 CamSetting[NumCamPos].Orizont:=Cam[Num].Orizont;
 CamSetting[NumCamPos].Reverse:=Cam[Num].Reverse;

end else
if fun=1 then begin Cam[Num].Enable:=True;
 Cam[num].Orizont:=-20;
 Cam[num].Sec:=Car[Opt].Sec;
 Cam[num].Y:=67;
 Cam[num].Angle:=(Car[Opt].Angle2+Car[Opt].Angle1) div 20;
 AuxAngle:=Cam[num].Angle; if AuxAngle<0 then inc(Auxangle,360);

 if Car[Opt].Reverse then begin
  Cam[num].X:=Car[Opt].X+sn[AuxAngle] shl 1;
  Cam[num].Z:=Car[Opt].Z+cs[AuxAngle] shl 1;
 end else begin
  Cam[num].X:=Car[Opt].X-sn[AuxAngle] shl 1;
  Cam[num].Z:=Car[Opt].Z-cs[AuxAngle] shl 1;
 end;
 Cam[num].Reverse:=Car[Opt].Reverse;
 Cam[num].DisPerc:=Car[Opt].DisPerc;
 Cam[num].CurrRise:=Car[Opt].CurrRise;
 Cam[num].GRise:=Car[Opt].GRise;
end else
if fun=2 then begin Cam[Num].Enable:=True;
 Cam[num].Orizont:=-10;
 Cam[num].Sec:=Car[Opt].Sec;
 Cam[num].Y:=45;
 AuxAngle:=(Car[Opt].Angle1 div 10+160) mod 360;if AuxAngle<0 then inc(AuxAngle,360);
 if Car[Opt].Reverse then begin
  Cam[num].X:=Car[Opt].X-sn[AuxAngle] *10 div 12;
  Cam[num].Z:=Car[Opt].Z-cs[AuxAngle] *10 div 12;
 end else begin
  Cam[num].X:=Car[Opt].X+sn[AuxAngle] *10 div 12;
  Cam[num].Z:=Car[Opt].Z+cs[AuxAngle] *10 div 12;
 end;
 Cam[num].Reverse:=Car[Opt].Reverse;
 Cam[num].Angle:=Car[Opt].Angle1 div 10-10;
 Cam[num].DisPerc:=Car[Opt].DisPerc;
 Cam[num].CurrRise:=Car[Opt].CurrRise;
 Cam[num].GRise:=Car[Opt].GRise;
 Cam[num].Gangle:=Car[Opt].Gangle;
end else
if fun=3 then begin Cam[Num].Enable:=True;
 Cam[num].Orizont:=-20;
 Cam[num].Sec:=Car[Opt].Sec;
 Cam[num].Y:=70;
 Cam[num].Angle:=(Car[Opt].Angle2+Car[Opt].Angle1) div 20;
 AuxAngle:=Cam[num].Angle+180; if AuxAngle<0 then inc(Auxangle,360);

 if Car[Opt].Reverse then begin
  Cam[num].X:=Car[Opt].X+sn[AuxAngle]*5 div 2;
  Cam[num].Z:=Car[Opt].Z+cs[AuxAngle]*5 div 2;
 end else begin
  Cam[num].X:=Car[Opt].X-sn[AuxAngle]*5 div 2;
  Cam[num].Z:=Car[Opt].Z-cs[AuxAngle]*5 div 2;
 end;
 Cam[num].Reverse:=Not Car[Opt].Reverse;
 Cam[num].DisPerc:=Car[Opt].DisPerc;
 Cam[num].CurrRise:=Car[Opt].CurrRise;
 Cam[num].GRise:=Car[Opt].GRise;
end else
if fun=4 then begin Cam[Num].Enable:=True;
 NumCamPos:=ProxCam(Opt);
   AuxSec:=Groad.Primo;
   for cnt:=1 to CamSetting[NumCamPos].NumSec-1 do AuxSec:=AuxSec^.Next;
   Cam[num].Sec    :=AuxSec;
   Cam[num].X      :=CamSetting[NumCamPos].X;
   Cam[num].Y      :=CamSetting[NumCamPos].Y;
   Cam[num].Z      :=CamSetting[NumCamPos].Z;
   Cam[num].Angle  :=CamSetting[NumCamPos].Angle;
   Cam[num].Orizont:=CamSetting[NumCamPos].Orizont;
   Cam[num].Reverse:=CamSetting[NumCamPos].Reverse;
end else
if fun=5 then begin Cam[Num].Enable:=True;
 Cam[num].Orizont:=20;
 Cam[num].Sec:=Car[Opt].Sec;
 Cam[num].Y:=40;
 Cam[num].Angle:=(Car[Opt].Angle2+Car[Opt].Angle1) div 20;
 AuxAngle:=Cam[num].Angle+180; if AuxAngle<0 then inc(Auxangle,360);

 if Car[Opt].Reverse then begin
  Cam[num].X:=Car[Opt].X-sn[AuxAngle] div 2;
  Cam[num].Z:=Car[Opt].Z-cs[AuxAngle] div 2;
 end else begin
  Cam[num].X:=Car[Opt].X+sn[AuxAngle] div 2;
  Cam[num].Z:=Car[Opt].Z+cs[AuxAngle] div 2;
 end;
 Cam[num].Reverse:=Not Car[Opt].Reverse;
 Cam[num].DisPerc:=Car[Opt].DisPerc;
 Cam[num].CurrRise:=Car[Opt].CurrRise;
 Cam[num].GRise:=Car[Opt].GRise
end else
 if fun=6 then begin
 Cam[num].Orizont:=-20;
 Cam[num].Sec:=Car[Opt].Sec;
 Cam[num].Y:=67;
 Cam[num].Angle:=((Car[Opt].Angle2+Car[Opt].Angle1) div 20+Rotangle+180*ord(not Car[num].Reverse)) mod 360;
 if Cam[num].angle<0 then inc(Cam[num].Angle,360);
 Auxangle:=Cam[num].angle;

(* if Car[Opt].Reverse then begin
  Cam[num].X:=Car[Opt].X+sn[AuxAngle] shl 1;
  Cam[num].Z:=Car[Opt].Z+cs[AuxAngle] shl 1;
 end else begin
  Cam[num].X:=Car[Opt].X-sn[AuxAngle] shl 1;
  Cam[num].Z:=Car[Opt].Z-cs[AuxAngle] shl 1;
 end;*)
     if (Cam[num].angle>  0) and (Cam[num].angle< 90) then Cam[num].Reverse:=False
else if (Cam[num].angle> 90) and (Cam[num].angle<270) then Begin Cam[num].Reverse:=True; dec(Cam[num].angle,180); end
else if (Cam[num].angle>270) and (Cam[num].angle<360) then Begin Cam[num].Reverse:=False; dec(Cam[num].angle,360); end;

 if Cam[num].Reverse then begin
  Cam[num].X:=Car[Opt].X-sn[AuxAngle] shl 1;
  Cam[num].Z:=Car[Opt].Z-cs[AuxAngle] shl 1;
 end else begin
  Cam[num].X:=Car[Opt].X-sn[AuxAngle] shl 1;
  Cam[num].Z:=Car[Opt].Z-cs[AuxAngle] shl 1;
 end;

 Cam[num].Reverse:=cs[Auxangle]<0;
 Cam[num].DisPerc:=Car[Opt].DisPerc;
 Cam[num].CurrRise:=Car[Opt].CurrRise;
 Cam[num].GRise:=Car[Opt].GRise;
       (*

 Cam[num].DisPerc:=Car[Opt].DisPerc;
 Cam[num].CurrRise:=Car[Opt].CurrRise;
 Cam[num].GRise:=Car[Opt].GRise;
 Cam[num].Sec:=Car[Opt].Sec;*)
 inc(Rotangle,2); if rotangle>360 then dec(rotangle,360);
end
end;

Procedure PilotCam(Num:byte);
Var
AuxAngle,PreSn:integer;
Alfa,AuxX,AuxZ:integer;
SPX,SPZ       :integer;
CurSect       :puntSec;
CurSectDim    :integer;

begin
CurSect:=Cam[num].Sec;

if Cam[num].mode<>6 then begin
 if Cam[Num].Angle> 90 then begin
 dec(Cam[Num].Angle,180); Cam[Num].Reverse:=not Cam[Num].Reverse;
 end else
 if Cam[Num].Angle<-90 then begin
 inc(Cam[Num].Angle,180); Cam[Num].Reverse:=not Cam[Num].Reverse;
 end;
end;

AuxAngle:=Cam[num].Angle mod 360; if AuxAngle<0 then inc(AuxAngle,360);

(*if Cam[Num].Angle>0 then PreSn:=sn[ Cam[Num].Angle] *70 div 128
                    else PreSn:=sn[-Cam[Num].Angle] *70 div 128;
if  Cam[Num].x+PreSn>CurSect^.Maxspc  then Cam[Num].x:=CurSect^.Maxspc-PreSn else
if  Cam[Num].x-PreSn<CurSect^.Minspc  then Cam[Num].x:=CurSect^.Minspc+PreSn;*)

(******************************************************************************)
(************************** CAMERA NORMAL RIDING *****************************)
(******************************************************************************)

if not Cam[Num].Reverse then begin

Cam[num].Gangle:=(Gangle(Cam[num].Sec)+Cam[num].Angle) mod 360;

if Cam[Num].GAngle<0 then inc(Cam[Num].gAngle,360);

 Cam[Num].X:=Cam[Num].X+Cam[num].Speed*sn[AuxAngle] / 500;
 Cam[Num].Z:=Cam[Num].Z+Cam[Num].Speed*cs[AuxAngle] / 500;
 SPX:=trunc(Cam[num].X);
 SPZ:=trunc(Cam[num].Z);

if Cam[Num].Enable then begin
 if Cam[Num].Speed>0 then begin
  if CurSect^.Next^.turn>0 then begin
   Cam[Num].CurrDist:=CurSect^.Next^.Taxis+longint(trunc(SpX))*Sn[CurSect^.Next^.Turn] div 128;
   if SpZ>Cam[Num].CurrDist then begin
    inc(Cam[Num].Angle,CurSect^.Next^.turn);
    dec(SpZ,CurSect^.Next^.Taxis);
    Alfa:=CurSect^.Next^.Turn;
    AuxX:=(longint(SpZ)*sn[alfa]+longint(SpX)*cs[alfa]) div 128;
    AuxZ:=(longint(SpZ)*cs[alfa]-longint(SpX)*sn[alfa]) div 128;
    SpZ:=AuxZ;
    SpX:=AuxX;
    CamNextSec(Num);
    CurSect:=Cam[Num].Sec;
    Cam[num].X:=SPX;
    Cam[num].Z:=SPZ;
   end;
  end else
  if CurSect^.Next^.turn<0 then begin
   Cam[Num].CurrDist:=CurSect^.Next^.Taxis-longint(SpX)*Sn[-CurSect^.Next^.Turn] div 128;
   if SpZ>Cam[Num].CurrDist then begin
    inc(Cam[Num].Angle,CurSect^.Next^.turn);
    dec(SpZ,CurSect^.Next^.Taxis);
    Alfa:=360+CurSect^.Next^.Turn;
    AuxX:=(longint(SpZ)*sn[alfa]+longint(SpX)*cs[alfa]) div 128;
    AuxZ:=(longint(SpZ)*cs[alfa]-longint(SpX)*sn[alfa]) div 128;
    SpZ:=AuxZ;
    SpX:=AuxX;
    CamNextSec(Num);
    CurSect:=Cam[Num].Sec;
    Cam[num].X:=SPX;
    Cam[num].Z:=SPZ;
   end;
  end else begin
   Cam[Num].CurrDist:=SecDistance;
   if SpZ>Cam[Num].CurrDist then begin
    dec(SpZ,Cam[Num].CurrDist);
    CamNextSec(Num);
    CurSect:=Cam[Num].Sec;
    Cam[num].X:=SPX;
    Cam[num].Z:=SPZ;
   end;
  end;
  if Cam[num].CurrDist>0 then Cam[Num].DisPerc:=10*(Cam[Num].CurrDist-SpZ) div Cam[Num].CurrDist;
  Cam[Num].CurrRise:=CurSect^.Rise-CurSect^.Rise*Cam[Num].DisPerc div 10;
 end else begin
  if SpZ<0 then begin
   if CurSect^.turn>0 then begin
    Cam[Num].CurrDist:=CurSect^.taxis+SpX*sn[CurSect^.turn] div 128;
    inc(Cam[Num].Angle,-CurSect^.turn);
    Alfa:=360-CurSect^.Turn;
    AuxX:=(longint(SpZ)*sn[alfa]+longint(SpX)*cs[alfa]) div 128;
    AuxZ:=(longint(SpZ)*cs[alfa]-longint(SpX)*sn[alfa]) div 128;
    SpZ:=AuxZ+CurSect^.Taxis;
    SpX:=AuxX;
    CamLastSec(Num);
    CurSect:=Cam[Num].Sec;
    Cam[num].X:=SPX;
    Cam[num].Z:=SPZ;
   end else
   if CurSect^.turn<0 then begin
    Cam[Num].CurrDist:=CurSect^.taxis+SpX*sn[-CurSect^.turn] div 128;
    inc(Cam[Num].Angle,-CurSect^.turn);
    Alfa:=-CurSect^.Turn;
    AuxX:=(longint(SpZ)*sn[alfa]+longint(SpX)*cs[alfa]) div 128;
    AuxZ:=(longint(SpZ)*cs[alfa]-longint(SpX)*sn[alfa]) div 128;
    SpZ:=AuxZ+CurSect^.Taxis;
    SpX:=AuxX;
    CamLastSec(Num);
    CurSect:=Cam[Num].Sec;
    Cam[num].X:=SPX;
    Cam[num].Z:=SPZ;
   end else begin
    Cam[Num].CurrDist:=SecDistance;
    inc(SpZ,Cam[Num].CurrDist);
    CamLastSec(Num);
    CurSect:=Cam[Num].Sec;
    Cam[num].X:=SPX;
    Cam[num].Z:=SPZ;
   end
  end
 end;
  if Cam[num].Currdist>0 then Cam[Num].DisPerc:=10*(Cam[Num].CurrDist-SpZ) div Cam[Num].CurrDist;
  Cam[Num].CurrRise:=CurSect^.Rise-CurSect^.Rise*Cam[Num].DisPerc div 10;
 end;
end else begin

(*********************************************************************)
(****************** CAMERA GO IN REVERSE *****************************)
(*********************************************************************)

Cam[num].Gangle:=(Gangle(Cam[num].Sec)+Cam[num].Angle+180) mod 360;

if Car[Num].GAngle<0 then inc(Car[Num].gAngle,360);

 Cam[Num].x:=Cam[Num].x-Cam[Num].Speed*sn[AuxAngle]/ 500;
 Cam[Num].z:=Cam[Num].z-Cam[Num].Speed*cs[AuxAngle]/ 500;
 SPX:=trunc(Cam[num].X);
 SPZ:=trunc(Cam[num].Z);

if Cam[Num].Enable then begin
 if Cam[Num].Speed>0 then begin
  if CurSect^.turn>0 then begin
   if SpZ<0 then begin
    Cam[Num].CurrDist:=CurSect^.taxis+SpX*sn[CurSect^.turn] div 128;
    inc(Cam[Num].Angle,-CurSect^.turn);
    Alfa:=360-CurSect^.Turn;
    AuxX:=(longint(SpZ)*sn[alfa]+longint(SpX)*cs[alfa]) div 128;
    AuxZ:=(longint(SpZ)*cs[alfa]-longint(SpX)*sn[alfa]) div 128;
    SpZ:=AuxZ+CurSect^.Taxis;;
    SpX:=AuxX;
    CamLastSec(Num);
    CurSect:=Cam[Num].Sec;
    Cam[num].X:=SPX;
    Cam[num].Z:=SPZ;
   end;
  end else
  if CurSect^.turn<0 then begin
   if SpZ<0 then begin
    Cam[Num].CurrDist:=CurSect^.taxis+SpX*sn[-CurSect^.turn] div 128;
    inc(Cam[Num].Angle,-CurSect^.turn);
    Alfa:=-CurSect^.Turn;
    AuxX:=(longint(SpZ)*sn[alfa]+longint(SpX)*cs[alfa]) div 128;
    AuxZ:=(longint(SpZ)*cs[alfa]-longint(SpX)*sn[alfa]) div 128;
    SpZ:=AuxZ+CurSect^.Taxis;
    SpX:=AuxX;
    CamLastSec(Num);
    CurSect:=Cam[Num].Sec;
    Cam[num].X:=SPX;
    Cam[num].Z:=SPZ;
   end;
  end else begin
   if SpZ<=0 then begin
    Cam[Num].CurrDist:=SecDistance;
    inc(SpZ,Cam[Num].CurrDist);
    CamLastSec(Num);
    CurSect:=Cam[Num].Sec;
    Cam[num].X:=SPX;
    Cam[num].Z:=SPZ;
   end;
  end;
 end else begin
 if CurSect^.Next^.turn>0 then begin
   Cam[Num].CurrDist:=CurSect^.Next^.Taxis+longint(SpX)*Sn[CurSect^.Next^.Turn] div 128;
   if SpZ>Cam[Num].CurrDist then begin
    inc(Cam[Num].Angle,CurSect^.Next^.turn);
    dec(SpZ,CurSect^.Next^.Taxis);
    Alfa:=CurSect^.Next^.Turn;
    AuxX:=(longint(SpZ)*sn[alfa]+longint(SpX)*cs[alfa]) div 128;
    AuxZ:=(longint(SpZ)*cs[alfa]-longint(SpX)*sn[alfa]) div 128;
    SpZ:=AuxZ;
    SpX:=AuxX;
    CamNextSec(Num);
    CurSect:=Cam[Num].Sec;
    Cam[num].X:=SPX;
    Cam[num].Z:=SPZ;
   end;
  end else
  if CurSect^.Next^.turn<0 then begin

   Cam[Num].CurrDist:=CurSect^.Next^.Taxis-longint(SpX)*Sn[-CurSect^.Next^.Turn] div 128;
   if SpZ>Cam[Num].CurrDist then begin
    inc(Cam[Num].Angle,CurSect^.Next^.turn);
    dec(SpZ,CurSect^.Next^.Taxis);
    Alfa:=360+CurSect^.Next^.Turn;
    AuxX:=(longint(SpZ)*sn[alfa]+longint(SpX)*cs[alfa]) div 128;
    AuxZ:=(longint(SpZ)*cs[alfa]-longint(SpX)*sn[alfa]) div 128;
    SpZ:=AuxZ;
    SpX:=AuxX;
    CamNextSec(Num);
    CurSect:=Cam[Num].Sec;
    Cam[num].X:=SPX;
    Cam[num].Z:=SPZ;
   end;
  end else begin
   Cam[Num].CurrDist:=SecDistance;
   if SpZ>Cam[Num].CurrDist then begin
    dec(SpZ,Cam[Num].CurrDist);
    CamNextSec(Num);
    CurSect:=Cam[Num].Sec;
    Cam[num].X:=SPX;
    Cam[num].Z:=SPZ;
   end
  end
 end
end;
 if CurSect^.Next^.turn>0 then
 CurSectDim:=CurSect^.Next^.taxis+longint(SpX)*sn[CurSect^.Next^.turn] div 128
 else if CurSect^.Next^.turn<0 then
 CurSectDim:=CurSect^.Next^.taxis-longint(SpX)*sn[-CurSect^.Next^.turn] div 128
 else CurSectDim:=SecDistance;

 if CurSectDim>0 then Cam[Num].DisPerc:=10*(CurSectDim-SpZ) div CurSectDim;
 Cam[Num].CurrRise:=CurSect^.rise*Cam[Num].DisPerc div 10;
end;

end;

Procedure TraceSPCCam(Num,X,Y,Z,Angle,Brise,Cdim,Offset,Azimuth: integer; N:byte; Hide:Boolean);
var AuxX,AuxZ,ExAngle :integer;
    k,k1              :byte;
    Volume            :integer;

begin
ExAngle:=Angle;
 for K:=1 to 8 do if bit(N,K) and ((SpecialObj[K+20].Class=2)=Hide) then begin
  K1:=K+20;
  if NumPla=1 then begin
   if Z>0 then Volume:=42-(abs(x)+z) div 200 else Volume:=42+z div 10;
   if Volume<0 then Volume:=0;
   if (Ch[4].StAlert=0) and SpecialObj[K1].Sam then PlaySample(4,K1-10,Volume,120,0) else Ch[4].Vl:=Volume;
  end;
  Angle:=ExAngle mod 360; if Angle<0 then inc(Angle,360);
  AuxZ:=integer((longint(trunc(SpecialObj[K1].Z)-Cdim*SpecialObj[K1].DisPerc div 10)*cs[360-Angle]+
                 longint(trunc(SpecialObj[K1].X))                                   *sn[360-Angle])div 128)+Z;

  AuxX:=integer((longint(trunc(SpecialObj[K1].Z)-Cdim*SpecialObj[K1].DisPerc div 10)*sn[360-Angle]-
                 longint(trunc(SpecialObj[K1].X))                                   *cs[360-Angle])div 128)+X;

  if SpecialObj[K1].Reverse then begin
   Angle:=(Angle+SpecialObj[K1].Angle+180) mod 360;
   if Angle<0 then inc(Angle,360);
  end else begin
   Angle:=(Angle+SpecialObj[K1].Angle) mod 360;
   if Angle<0 then inc(Angle,360);
  end;

 if Cam[Num].Reverse then begin
  if SpecialObj[k1].Reverse then
    putobj(K1,AuxX,Y+(10-SpecialObj[K1].DisPerc)*Brise div 150-trunc(SpecialObj[K1].Y),
              AuxZ,Angle, Brise div 20,0,Offset,Azimuth)
  else
    putobj(K1,AuxX,Y+(10-SpecialObj[K1].DisPerc)*Brise div 150-trunc(SpecialObj[K1].Y),
              AuxZ,Angle,-Brise div 20,0,Offset,Azimuth);
 end else begin
  if SpecialObj[k1].Reverse then
    putobj(K1,AuxX,Y-(10-SpecialObj[K1].DisPerc)*Brise div 150-trunc(SpecialObj[K1].Y),
              AuxZ,Angle,-Brise div 20,0,Offset,Azimuth)
  else
    putobj(K1,AuxX,Y-(10-SpecialObj[K1].DisPerc)*Brise div 150-trunc(SpecialObj[K1].Y),
              AuxZ,Angle, Brise div 20,0,Offset,Azimuth);  end;
 end
end;

Procedure TraceCarsCam(Num,X,Y,Z,Angle,Brise,Cdim,Offset,Azimuth: integer; N:byte);
var AuxX,AuxZ,ExAngle: integer;
    k,SmkFree        : shortint;
    K1               : integer;
    Volume           : integer;
    Channel          : byte;
    AuxAngle         : integer;


begin
ExAngle:=Angle;Channel:=1;
 for K:=1 to 8 do if bit(N,K) then begin
    Angle:=ExAngle mod 360; if Angle<0 then inc(Angle,360);
    if (Car[K].Sgom>0) or (Car[k].Energy<20) or (Car[k].EnergyDec>Car[k].Energy) then begin
     SmkFree:=SmokeFree;
     if Smoke[SmkFree].img=0 then begin
     if (Car[k].Energy<20) or (Car[k].EnergyDec>Car[k].Energy) then Smoke[SmkFree].Tipo:=1 else Smoke[SmkFree].Tipo:=0;
     Smoke[SmkFree].Sec:=Car[K].Sec;
     K1:=sgn(Car[k].Speed);
     if Car[k].reverse then begin
     Smoke[SmkFree].x:=Car[K].intX+cs[Car[k].Angle2 div 10+270]*K1 div 2;
     Smoke[SmkFree].z:=Car[K].intZ-sn[Car[k].Angle2 div 10+270]*K1 div 2;
     end else begin
     Smoke[SmkFree].x:=Car[K].intX+cs[Car[k].Angle2 div 10+ 90]*K1 div 2;
     Smoke[SmkFree].z:=Car[K].intZ-sn[Car[k].Angle2 div 10+ 90]*K1 div 2;
     end;
     Smoke[SmkFree].y:=Car[K].intY;
     Smoke[SmkFree].DisPerc:=Car[K].Disperc;
     Smoke[SmkFree].img:=1;
     inc(Smoke[SmkFree].Sec^.NumSmk,Smoke[SmkFree].id);
     end;
    end;

  AuxZ:=integer((longint(Car[K].IntZ-Cdim*Car[K].DisPerc div 10)*cs[360-Angle]+
                 longint(Car[K].IntX)                           *sn[360-Angle])div 128)+Z;

  if AuxZ<1000 then begin K1:=K;AnimCar(K1) end else K1:=K+10;

  AuxX:=integer((longint(Car[K].IntZ-Cdim*Car[K].DisPerc div 10)*sn[360-Angle]-
                 longint(Car[K].IntX)                           *cs[360-Angle])div 128)+X;

  if Car[K].Reverse then begin
   Angle:=(Angle+Car[K].Angle1 div 10+180) mod 360;
   if Angle<0 then inc(Angle,360);
  end else begin
   Angle:=(Angle+Car[K].Angle1 div 10) mod 360;
   if Angle<0 then inc(Angle,360);
  end;

  if Cam[Num].Reverse then begin

  If Car[K].Team>0 then
   TraceSign(557+Car[K].Team,AuxX,Y+(10-Car[K].DisPerc)*brise div 150+(Car[Num].Zrot*AuxX) div 150-60,AuxZ,OffSet,Azimuth);
  if GameMode=3 then
   TraceSign(K,AuxX,Y+(10-Car[K].DisPerc)*brise div 150+(Car[Num].Zrot*AuxX) div 150-60,AuxZ,OffSet,Azimuth);
   if Car[K].Reverse then begin
    putobj(20,AuxX,Y+(10-Car[K].DisPerc)*brise div 150,
              AuxZ,Angle, Brise div 20            ,0,Offset,Azimuth);
    putobj(K1,AuxX,Y+(10-Car[K].DisPerc)*Brise div 150-(Car[K].intY-39),
              AuxZ,Angle, Brise div 20+Car[K].Xrot,Car[K].Zrot,Offset,Azimuth);

   end else begin
    putobj(20,AuxX,Y+(10-Car[K].DisPerc)*Brise div 150,
              AuxZ,Angle,-Brise div 20            ,0,Offset,Azimuth);
    putobj(K1,AuxX,Y+(10-Car[K].DisPerc)*Brise div 150-(Car[K].intY-39),
              AuxZ,Angle,-Brise div 20+Car[K].Xrot,Car[K].Zrot,Offset,Azimuth);
   end
  end else begin
   If Car[K].Team>0 then
   TraceSign(557+Car[K].Team,AuxX,Y+(10-Car[K].DisPerc)*brise div 150+(Car[Num].Zrot*AuxX) div 150-60,AuxZ,OffSet,Azimuth);
   if GameMode=3 then
    TraceSign(K,AuxX,Y+(10-Car[K].DisPerc)*brise div 150+(Car[Num].Zrot*AuxX) div 150-60,AuxZ,OffSet,Azimuth);
   if Car[K].Reverse then begin
    putobj(20,AuxX,Y-(10-Car[K].DisPerc)*Brise div 150,
              AuxZ,Angle,-Brise div 20            ,0,Offset,Azimuth);
    putobj(K1,AuxX,Y-(10-Car[K].DisPerc)*Brise div 150-(Car[K].intY-39),
              AuxZ,Angle,-Brise div 20+Car[K].Xrot,Car[K].Zrot,Offset,Azimuth);
   end else begin
    putobj(20,AuxX,Y-(10-Car[K].DisPerc)*Brise div 150,
              AuxZ,Angle, Brise div 20            ,0,Offset,Azimuth);
    putobj(K1,AuxX,Y-(10-Car[K].DisPerc)*Brise div 150-(Car[K].intY-39),
              AuxZ,Angle, Brise div 20+Car[K].Xrot,Car[K].Zrot,Offset,Azimuth);
   end
  end
 end
end;

Procedure TraceSPCMIR(Num,X,Y,Z,Angle,Brise,Cdim,Offset,Azimuth: integer; N:byte; Hide:Boolean);
var AuxX,AuxZ,ExAngle :integer;
    k,k1              :byte;
    Volume            :integer;

begin
ExAngle:=Angle;
 for K:=1 to 8 do if bit(N,K) and ((SpecialObj[K+20].Class=2)=Hide) then begin
  K1:=K+20;
  if NumPla=1 then begin
   if Z>0 then Volume:=42-(abs(x)+z) div 200 else Volume:=42+z div 10;
   if Volume<0 then Volume:=0;
   if (Ch[4].StAlert=0) And SpecialObj[K1].Sam then PlaySample(4,K1-10,Volume,120,0) else Ch[4].Vl:=Volume;
  end;
  Angle:=ExAngle mod 360; if Angle<0 then inc(Angle,360);
  AuxZ:=integer((longint(trunc(SpecialObj[K1].Z)-Cdim*SpecialObj[K1].DisPerc div 10)*cs[360-Angle]+
                 longint(trunc(SpecialObj[K1].X))                                   *sn[360-Angle])div 128)+Z;

  AuxX:=integer((longint(trunc(SpecialObj[K1].Z)-Cdim*SpecialObj[K1].DisPerc div 10)*sn[360-Angle]-
                 longint(trunc(SpecialObj[K1].X))                                   *cs[360-Angle])div 128)+X;

  if SpecialObj[K1].Reverse then begin
   Angle:=(Angle+SpecialObj[K1].Angle+180) mod 360;
   if Angle<0 then inc(Angle,360);
  end else begin
   Angle:=(Angle+SpecialObj[K1].Angle) mod 360;
   if Angle<0 then inc(Angle,360);
  end;

 if Not Car[Num].Reverse then begin
  if SpecialObj[k1].Reverse then
    putobjM(K1,AuxX,Y+(10-SpecialObj[K1].DisPerc)*Brise div 150-trunc(SpecialObj[K1].Y)+(Car[Num].Zrot*AuxX) div 150,
               AuxZ,Angle, Brise div 20,0,Offset,Azimuth)
  else
    putobjM(K1,AuxX,Y+(10-SpecialObj[K1].DisPerc)*Brise div 150-trunc(SpecialObj[K1].Y)+(Car[Num].Zrot*AuxX) div 150,
               AuxZ,Angle,-Brise div 20,0,Offset,Azimuth);
 end else begin
  if SpecialObj[k1].Reverse then
    putobjM(K1,AuxX,Y-(10-SpecialObj[K1].DisPerc)*Brise div 150-trunc(SpecialObj[K1].Y)+(Car[Num].Zrot*AuxX) div 150,
               AuxZ,Angle,-Brise div 20,0,Offset,Azimuth)
  else
    putobjM(K1,AuxX,Y-(10-SpecialObj[K1].DisPerc)*Brise div 150-trunc(SpecialObj[K1].Y)+(Car[Num].Zrot*AuxX) div 150,
               AuxZ,Angle, Brise div 20,0,Offset,Azimuth);
  end;
 end
end;


Procedure TraceSmkMIR (Num,X,Y,Z,Angle,Cdim,Offset,Azimuth: integer; N:byte);
var AuxX,AuxZ        : integer;
    k                : byte;
begin
 Angle:=Angle mod 360; if Angle<0 then inc(Angle,360);
 for K:=1 to 8 do if bit(N,K) then begin
  AuxZ:=integer((longint(Smoke[K].Z-Cdim*Smoke[K].DisPerc div 10)*cs[360-Angle]+
                 longint(Smoke[K].X)                             *sn[360-Angle])div 128)+Z;
  AuxX:=integer((longint(Smoke[K].Z-Cdim*Smoke[K].DisPerc div 10)*sn[360-Angle]-
                 longint(Smoke[K].X)                             *cs[360-Angle])div 128)+X;
  chgface(19,0,Smoke[K].img shr 2+1);
  if Smoke[k].Tipo=0 then PutobjM(19,AuxX,Y,AuxZ,0,0,0,Offset,Azimuth)
                     else PutobjM(29,AuxX,Y-Smoke[k].img*5,AuxZ,0,0,0,Offset,Azimuth);
 end
end;

Procedure TraceCarsMIR(Num,X,Y,Z,Angle,Brise,Cdim,Offset,Azimuth: integer; N:byte);
var AuxX,AuxZ,ExAngle: integer;
    AuxAngle         : integer;
    k,k1,SmkFree     : byte;

begin
 ExAngle:=Angle;
 for K:=1 to MaxCars do if bit(N,K) and (Num<>K) then begin
    if (Car[K].Sgom>0) or (Car[k].Energy<20) or (Car[k].EnergyDec>Car[k].Energy) then begin
   SmkFree:=SmokeFree;
    if Smoke[SmkFree].img=0 then begin
    if (Car[k].Energy<20) or (Car[k].EnergyDec>Car[k].Energy) then Smoke[SmkFree].Tipo:=1 else Smoke[SmkFree].Tipo:=0;
    Smoke[SmkFree].Sec:=Car[K].Sec;
    K1:=sgn(Car[k].Speed);
    if Car[k].reverse then begin
     Smoke[SmkFree].x:=Car[K].intX+cs[Car[k].Angle2 div 10+270]*K1 div 2;
     Smoke[SmkFree].z:=Car[K].intZ-sn[Car[k].Angle2 div 10+270]*K1 div 2;
    end else begin
     Smoke[SmkFree].x:=Car[K].intX+cs[Car[k].Angle2 div 10+ 90]*K1 div 2;
     Smoke[SmkFree].z:=Car[K].intZ-sn[Car[k].Angle2 div 10+ 90]*K1 div 2;
    end;
    Smoke[SmkFree].y:=Car[K].intY;
    Smoke[SmkFree].DisPerc:=Car[K].Disperc;
    Smoke[SmkFree].img:=1;
    inc(Smoke[SmkFree].Sec^.NumSmk,Smoke[SmkFree].id);
   end
  end;

  Angle:=ExAngle mod 360; if Angle<0 then inc(Angle,360);
  AuxZ:=integer((longint(Car[K].IntZ-Cdim*Car[K].DisPerc div 10)*cs[360-Angle]+
                 longint(Car[K].IntX)                           *sn[360-Angle])div 128)+Z;

  if AuxZ<1000 then begin K1:=K;AnimCar(K1) end else K1:=K+10;

  AuxX:=integer((longint(Car[K].IntZ-Cdim*Car[K].DisPerc div 10)*sn[360-Angle]-
                 longint(Car[K].IntX)                           *cs[360-Angle])div 128)+X;

  if Car[K].Reverse then begin
   Angle:=(Angle+Car[K].Angle1 div 10+180) mod 360;
   if Angle<0 then inc(Angle,360);
  end else begin
   Angle:=(Angle+Car[K].Angle1 div 10) mod 360;
   if Angle<0 then inc(Angle,360);
  end;

  if Not Car[Num].Reverse then begin

   if Car[K].Reverse then begin
    putobjM(20,AuxX,Y+(10-Car[K].DisPerc)*brise div 150+(Car[Num].Zrot*AuxX) div 150,
               AuxZ,Angle, Brise div 20            ,0,Offset,Azimuth);
    putobjM(K1,AuxX,Y+(10-Car[K].DisPerc)*Brise div 150-(Car[K].intY-39)+(Car[Num].Zrot*AuxX) div 150,
               AuxZ,Angle, Brise div 20+Car[K].Xrot,Car[K].Zrot,Offset,Azimuth);
   end else begin
    putobjM(20,AuxX,Y+(10-Car[K].DisPerc)*Brise div 150+(Car[Num].Zrot*AuxX) div 150,
               AuxZ,Angle,-Brise div 20            ,0,Offset,Azimuth);
    putobjM(K1,AuxX,Y+(10-Car[K].DisPerc)*Brise div 150-(Car[K].intY-39)+(Car[Num].Zrot*AuxX) div 150,
               AuxZ,Angle,-Brise div 20+Car[K].Xrot,Car[K].Zrot,Offset,Azimuth);
   end
  end else begin

   if Car[K].Reverse then begin
    putobjM(20,AuxX,Y-(10-Car[K].DisPerc)*Brise div 150+(Car[Num].Zrot*AuxX) div 150,
               AuxZ,Angle,-Brise div 20            ,0,Offset,Azimuth);
    putobjM(K1,AuxX,Y-(10-Car[K].DisPerc)*Brise div 150-(Car[K].intY-39)+(Car[Num].Zrot*AuxX) div 150,
               AuxZ,Angle,-Brise div 20+Car[K].Xrot,Car[K].Zrot,Offset,Azimuth);
   end else begin
    putobjM(20,AuxX,Y-(10-Car[K].DisPerc)*Brise div 150+(Car[Num].Zrot*AuxX) div 150,
               AuxZ,Angle, Brise div 20            ,0,Offset,Azimuth);
    putobjM(K1,AuxX,Y-(10-Car[K].DisPerc)*Brise div 150-(Car[K].intY-39)+(Car[Num].Zrot*AuxX) div 150,
               AuxZ,Angle, Brise div 20+Car[K].Xrot,Car[K].Zrot,Offset,Azimuth);
   end
  end
 end
end;


Procedure TraceRoadMir(NumCam:byte; AziX,AziY: integer; Rap:Byte);
var Pcos,Psen,Xfond,Yfond: integer;

begin
 ChgRAP(Rap);
 Fillchar(chk,SizeOf(Chk),0);
 Azimuth :=AziY+20;
 Ymy     :=trunc(Cam[NumCam].Y);

 Yfond:=(-Cam[NumCam].Grise div 50*Cs[Cam[NumCam].Angle+180] div 128) shl SVGA;
 if Yfond> 20 shl SVGA then Yfond:= 20 shl SVGA else
 if Yfond<-20 shl SVGA then Yfond:=-20 shl SVGA;

 inc(Yfond,AziY-80);

 Xfond:=(Cam[NumCam].GAngle shl 2) mod 160;
 if Xfond<0 then inc(Xfond,160);
 Bar(0,0,319 Shl SVGA,Yfond,Skycol);
 Bar(0,Yfond+BackDy,319 Shl SVGA,199 Shl SVGA,BackCol);
 Back(MaxBobs,Xfond-160,Yfond);
 CurrSecdist:=0;

 if Not Cam[NumCam].Reverse then begin
  aux1 :=Cam[NumCam].Sec;
  drawed:=0;
  totalpoints:=0;
  cnt2:=2;

  baserise:=-Cam[NumCam].CurrRise;
  rise:=0;

  BaseAngle:=Cam[NumCam].Angle;
  AdjOffset:=AziX shl SVGA+(Cam[NumCam].Angle*10 div 2 mod 5 div 2) shl 1;
  Angle:=BaseAngle mod 360; if Angle<0 then inc(Angle,360);
  Angle:=360-Angle;

  x:=integer( longint(trunc(Cam[NumCam].Z))*sn[Angle] div 128+longint(trunc(Cam[NumCam].X))*cs[Angle] div 128);
  z:=integer(-longint(trunc(Cam[NumCam].Z))*cs[Angle] div 128+longint(trunc(Cam[NumCam].X))*sn[Angle] div 128)-80;

  for cnt1:=1 to 3 do begin
   if (aux1^.turn<>0) then begin
    dec(BaseAngle,aux1^.turn);
    Angle:=BaseAngle mod 360; if Angle<0 then inc(Angle,360);
    Angle:=360-Angle;
    inc(x,longint(aux1^.taxis)*sn[Angle] div 128);
    dec(z,longint(aux1^.taxis)*cs[Angle] div 128);
   end else begin
    inc(x,longint(SecDistance)*sn[Angle] div 128);
    dec(z,longint(SecDistance)*cs[Angle] div 128);
   end;
   aux1:=Aux1^.last;
  end;

  while (cnt2<20) do begin

   (*************************** CAMING MIR ******************************)

   if (Aux1^.NumCar>0) or (Aux1^.NumSmk>0) or (Aux1^.NumSpc>0) then begin
    Xsec[cnt2]:=x;
    Ysec[cnt2]:=Ymy-rise div 15;
    Zsec[cnt2]:=z+128;
    Bsec[cnt2]:=BaseRise;
    Asec[cnt2]:=Angle;
    Cdim[cnt2]:=CurrSecDist;
   end;

   currpoint:=totalpoints;
   Pcos:=cs[Angle];
   Psen:=sn[Angle];
   for cnt1:=1 to aux1^.maxpn do begin
    inc(currpoint);
    efx :=    aux1^.x[cnt1] div 4;
    auxx:=integer(efx*Pcos div 32)+x;
    auxz:=integer(efx*Psen div 32)+z+128;
    if (abs(auxx)<700+auxz shr 2) and (auxz>0) then begin
     auxy:=ymy-aux1^.y[cnt1]-rise div 15;
     auxz:=auxz shr 4+1;
     px[currpoint]:=-(auxx shl PRAP2 div auxz)shl SVGA+AdjOffset;
     py[currpoint]:= (auxy shl PRAP2 div auxz)shl SVGA+azimuth;
     if px[currpoint]> 840 then px[currpoint]:= 840 else
     if px[currpoint]<-200 then px[currpoint]:=-200;
     chk[currpoint]:=true;
    end else chk[currpoint]:=false;
   end;
   aux1:=aux1^.Next;
   inc(totalpoints,30);
   inc(cnt2);
   if (aux1^.turn<>0) then begin
    dec(x,longint(aux1^.taxis+CurrSecDist)*Psen div 128);
    inc(z,longint(aux1^.taxis+CurrSecDist)*Pcos div 128);
    inc(BaseAngle,aux1^.turn);
    Angle:=BaseAngle mod 360; if Angle<0 then inc(Angle,360);
    Angle:=360-Angle;
   end else begin
    dec(x,longint(SecDistance+CurrSecDist)*sn[Angle] div 128);
    inc(z,longint(SecDistance+CurrSecDist)*cs[Angle] div 128);
   end;

   if cnt2>4 then begin
    inc(baserise ,aux1^.rise); inc(rise,baserise);
    if cnt2>10 then inc(CurrSecDist,10);
   end;
   inc(drawed);
  end;

  while drawed>0 do begin
   (*************************** CAMING MIR ******************************)

   dec(drawed);
   aux1:=aux1^.last;
   edgebase:=drawed*30;
   curpol:=aux1^.ppolys;

    if Aux1^.Last^.NumSPC>0 then
    TraceSPCMir (NumCam,Xsec[Drawed+1],
                        Ysec[Drawed+1],
                        Zsec[Drawed+1],
                        Asec[Drawed+1],
                        Bsec[Drawed+1],
                        Cdim[Drawed+1],AdjOffset,Azimuth,Aux1^.Last^.NumSPC,True);


   while curpol<>nil do begin
    edge[1]:=edgebase+curpol^.edge[1];
    edge[2]:=edgebase+curpol^.edge[2];
    edge[3]:=edgebase+curpol^.edge[3];if curpol^.edge[3]=0 then chk[edge[3]]:=true;
    edge[4]:=edgebase+curpol^.edge[4];if curpol^.edge[4]=0 then chk[edge[4]]:=true;

    if chk[edge[1]] and chk[edge[2]] and chk[edge[3]] and chk[edge[4]] and
        (edge[1]<750) and (edge[2]<750)
    and (edge[3]<750) and (edge[4]<750) then begin

     pv1:= py[edge[2]]-py[edge[1]];
     pv2:=-px[edge[3]]+px[edge[1]];
     pv3:=-px[edge[2]]+px[edge[1]];
     pv4:= py[edge[3]]-py[edge[1]];

     if (pv1*pv2<pv3*pv4+10) then begin

      (*************************** CAMING MIR******************************)

      tipo:=curpol^.tipo;
      colr:=curpol^.color;

      if (tipo=0) and (edge[1]>0) and (edge[2]>0) then
      line      (px[edge[1]],py[edge[1]],px[edge[2]],py[edge[2]],colr  ) else
      if (tipo=1) and (edge[1]>0) and (edge[2]>0) and (edge[3]>0) and (edge[4]>0) then
      polygon   (px[edge[1]],py[edge[1]],px[edge[2]],py[edge[2]],
                 px[edge[3]],py[edge[3]],px[edge[4]],py[edge[4]],colr) else
      if (tipo=2) and (edge[1]>0) and (edge[2]>0) and (edge[3]>0) and (edge[4]>0) and (drawed>15) then
      polygon   (px[edge[1]],py[edge[1]],px[edge[2]],py[edge[2]],
                px[edge[3]],py[edge[3]],px[edge[4]],py[edge[4]],colr) else
      if (tipo=4) and (edge[1]>0) and (edge[2]>0) and(tipo=4)  and (Px[edge[1]]>-200) and (Px[Edge[1]]<840) then
      frbob    (colr,px[edge[1]],py[edge[1]],px[edge[2]],py[edge[2]],3);
      if (tipo=5) and (edge[1]>0) and (edge[2]>0) and (edge[3]>0) and (edge[4]>0) then
      vmapbob   (px[edge[2]],px[edge[1]],py[edge[2]],py[edge[1]],py[edge[4]],py[edge[3]],colr) else
      if (tipo=6) and (edge[1]>0) and (edge[2]>0) and (edge[3]>0) and (edge[4]>0) then
      mapbob    (px[edge[1]],py[edge[1]],px[edge[2]],py[edge[2]],
                 px[edge[3]],py[edge[3]],px[edge[4]],py[edge[4]],colr) else
      if (tipo=7) and (edge[1]>0) and (edge[2]>0) and (edge[3]>0) and (edge[4]>0) then
      tvmapbob  (px[edge[2]],px[edge[1]],py[edge[2]],py[edge[1]],py[edge[4]],py[edge[3]],colr) else
      if (tipo=8) and (edge[1]>0) and (edge[2]>0) and (edge[3]>0) and (edge[4]>0) then
      tmapbob   (px[edge[1]],py[edge[1]],px[edge[2]],py[edge[2]],
                px[edge[3]],py[edge[3]],px[edge[4]],py[edge[4]],colr);
    end
    end;
    curpol:=curpol^.Next;
   end;
   if (Drawed<20-6) then begin
    if Aux1^.Next^.NumSPC>0 then
    TraceSPCMIR (NumCam,Xsec[Drawed+3],
                        Ysec[Drawed+3],
                        Zsec[Drawed+3],
                        Asec[Drawed+3],
                        Bsec[Drawed+3],
                        Cdim[Drawed+3],AdjOffset,Azimuth,Aux1^.Next^.NumSPC,False);

    if Aux1^.Next^.NumCar>0 then
    TraceCarsMIR(NumCam,Xsec[Drawed+3],
                        Ysec[Drawed+3],
                        Zsec[Drawed+3],
                        Asec[Drawed+3],
                        Bsec[Drawed+3],
                        Cdim[Drawed+3],AdjOffset,Azimuth,Aux1^.Next^.NumCar);

    if Aux1^.Next^.NumSmk>0 then
    TraceSmkMIR (NumCam,Xsec[Drawed+3],
                        Ysec[Drawed+3],
                        Zsec[Drawed+3],
                        Asec[Drawed+3],
                        Cdim[Drawed+3],AdjOffset,Azimuth,Aux1^.Next^.NumSmk);

   end
  end
 end else begin

(*******************************************************************)
(********************* CAMMIR IN REVERSE ******************************)
(*******************************************************************)

  aux1 :=Cam[NumCam].Sec;
  drawed:=0;
  totalpoints:=720;
  cnt2:=2;

  baserise:=-Cam[NumCam].CurrRise;
  rise:=0;

  BaseAngle:=Cam[NumCam].Angle;
  AdjOffset:=AziX shl SVGA+(Cam[NumCam].Angle*10 div 2 mod 5 div 2) shl 1;
  Angle:=BaseAngle mod 360; if Angle<0 then inc(Angle,360);
  Angle:=360-Angle;

  x:= integer( longint(trunc(-Cam[NumCam].Z))*sn[Angle] div 128+longint(trunc(-Cam[NumCam].X))*cs[Angle] div 128);
  z:= integer(-longint(trunc(-Cam[NumCam].Z))*cs[Angle] div 128+longint(trunc(-Cam[NumCam].X))*sn[Angle] div 128)-80;
  for cnt1:=1 to 4 do begin
   Aux1:=Aux1^.Next;
   if aux1^.turn<>0 then begin
    inc(x,longint(aux1^.taxis)*sn[Angle] div 128);
    dec(z,longint(aux1^.taxis)*cs[Angle] div 128);
    dec(BaseAngle,-aux1^.turn);
    Angle:=BaseAngle mod 360; if Angle<0 then inc(Angle,360);
    Angle:=360-Angle;
   end else begin
    inc(x,longint(SecDistance)*sn[Angle] div 128);
    dec(z,longint(SecDistance)*cs[Angle] div 128);
   end;
  end;

  Pcos:=cs[Angle];
  Psen:=sn[Angle];

  while (cnt2<20) do begin

   (*************************** CAMING MIR ******************************)

   if (Aux1^.NumCar>0) or (Aux1^.NumSmk>0) or (Aux1^.NumSpc>0) then begin
    Xsec[cnt2]:=x;
    Ysec[cnt2]:=Ymy-rise div 15;
    Zsec[cnt2]:=z+128;
    Bsec[cnt2]:=BaseRise;
    Asec[cnt2]:=Angle;
    Cdim[cnt2]:=CurrSecDist;
   end;

   currpoint:=totalpoints;
   for cnt1:=1 to aux1^.maxpn do begin
    inc(currpoint);
    efx :=   -aux1^.x[cnt1] div 4;
    auxx:=  integer(efx*Pcos div 32)+x;
    auxz:=  integer(efx*Psen div 32)+z+128;
    if (abs(auxx)<700+auxz shr 2) and (auxz>0) then begin
     auxy:=ymy-aux1^.y[cnt1]-rise div 15;
     auxz:=auxz shr 4+1;
     px[currpoint]:=-auxx shl PRAP2 div auxz shl SVGA+AdjOffset;
     py[currpoint]:= auxy shl PRAP2 div auxz shl SVGA+azimuth;
     if px[currpoint]> 840 then px[currpoint]:= 840 else
     if px[currpoint]<-200 then px[currpoint]:=-200;
     chk[currpoint]:=true;
    end else chk[currpoint]:=false;
   end;
   dec(totalpoints,30);
   inc(cnt2);
   if (aux1^.turn<>0) then begin
    inc(BaseAngle,-aux1^.turn);
    Angle:=BaseAngle mod 360; if Angle<0 then inc(Angle,360);
    Angle:=360-Angle;
    Pcos:=cs[Angle];
    Psen:=sn[Angle];
    dec(x,longint(aux1^.taxis+CurrSecDist)*Psen div 128);
    inc(z,longint(aux1^.taxis+CurrSecDist)*Pcos div 128);
   end else begin
    dec(x,longint(SecDistance+CurrSecDist)*Psen div 128);
    inc(z,longint(SecDistance+CurrSecDist)*Pcos div 128);
   end;
   if cnt2>6 then begin
    inc(baserise ,aux1^.rise); inc(rise,baserise);
    if cnt2>10 then inc(CurrSecDist,10);
   end;
   inc(drawed);
   aux1:=aux1^.last;
  end;

  while drawed>0 do begin

   (*************************** CAMING MIR ******************************)

   dec(drawed);
   aux1:=aux1^.Next;
   edgebase:=720-drawed*30;
   curpol:=aux1^.ppolys;

    if Aux1^.Next^.NumSPC>0 then
    TraceSPCMir (NumCam,Xsec[Drawed+1],
                        Ysec[Drawed+1],
                        Zsec[Drawed+1],
                        Asec[Drawed+1]+180,
                        Bsec[Drawed+1],
                        Cdim[Drawed+1],AdjOffset,Azimuth,Aux1^.Next^.NumSPC,True);

   while curpol<>nil do begin
    edge[1]:=edgebase+curpol^.edge[1];
    edge[2]:=edgebase+curpol^.edge[2];
    edge[3]:=edgebase+curpol^.edge[3];if curpol^.edge[3]=0 then chk[edge[3]]:=true;
    edge[4]:=edgebase+curpol^.edge[4];if curpol^.edge[4]=0 then chk[edge[4]]:=true;

    if chk[edge[1]] and chk[edge[2]] and chk[edge[3]] and chk[edge[4]] and
        (edge[1]<750) and (edge[2]<750)
    and (edge[3]<750) and (edge[4]<750) then begin

     pv1:= py[edge[2]]-py[edge[1]];
     pv2:=-px[edge[3]]+px[edge[1]];
     pv3:=-px[edge[2]]+px[edge[1]];
     pv4:= py[edge[3]]-py[edge[1]];

     if (pv1*pv2<pv3*pv4+10) then begin

      (*************************** CAMINGMIR ******************************)

      tipo:=curpol^.tipo;
      colr:=curpol^.color;

      if(tipo=0) and (edge[1]>0) and (edge[2]>0) then
      line      (px[edge[1]],py[edge[1]],px[edge[2]],py[edge[2]],colr  ) else
      if(tipo=1) and (edge[1]>0) and (edge[2]>0) and (edge[3]>0) and (edge[4]>0) then
      polygon   (px[edge[1]],py[edge[1]],px[edge[2]],py[edge[2]],
                 px[edge[3]],py[edge[3]],px[edge[4]],py[edge[4]],colr  ) else
      if (tipo=2) and (edge[1]>0) and (edge[2]>0) and (edge[3]>0) and (edge[4]>0) and (drawed>15) then
      polygon   (px[edge[1]],py[edge[1]],px[edge[2]],py[edge[2]],
                 px[edge[3]],py[edge[3]],px[edge[4]],py[edge[4]],colr  ) else
      if(tipo=4) and (edge[1]>0) and (edge[2]>0)  and (Px[edge[1]]>-200) and (Px[Edge[1]]<840) then
      frbob    (colr,px[edge[1]],py[edge[1]],px[edge[2]],py[edge[2]],3) else
      if(tipo=5) and (edge[1]>0) and (edge[2]>0) and (edge[3]>0) and (edge[4]>0) then
      vmapbob   (px[edge[2]],px[edge[1]],py[edge[2]],py[edge[1]],py[edge[4]],py[edge[3]],colr) else
      if(tipo=6) and (edge[1]>0) and (edge[2]>0) and (edge[3]>0) and (edge[4]>0) then
      mapbob    (px[edge[1]],py[edge[1]],px[edge[2]],py[edge[2]],
                px[edge[3]],py[edge[3]],px[edge[4]],py[edge[4]],colr) else
      if(tipo=7) and (edge[1]>0) and (edge[2]>0) and (edge[3]>0) and (edge[4]>0) then
      tvmapbob  (px[edge[2]],px[edge[1]],py[edge[2]],py[edge[1]],py[edge[4]],py[edge[3]],colr) else
      if(tipo=8) and (edge[1]>0) and (edge[2]>0) and (edge[3]>0) and (edge[4]>0) then
      tmapbob   (px[edge[1]],py[edge[1]],px[edge[2]],py[edge[2]],
                 px[edge[3]],py[edge[3]],px[edge[4]],py[edge[4]],colr);

     end
    end;
    curpol:=curpol^.Next;
   end;
   if (Drawed<20-6) then begin
    if Aux1^.Last^.NumSPC>0 then
    TraceSPCMIR (NumCam,Xsec[Drawed+3],
                        Ysec[Drawed+3],
                        Zsec[Drawed+3],
                        Asec[Drawed+3]+180,
                        Bsec[Drawed+3],
                        Cdim[Drawed+3],AdjOffset,Azimuth,Aux1^.Last^.NumSPC,False);

    if Aux1^.Last^.NumCar>0 then
    TraceCarsMIR(NumCam,Xsec[Drawed+3],
                        Ysec[Drawed+3],
                        Zsec[Drawed+3],
                        Asec[Drawed+3]+180,
                        Bsec[Drawed+3],
                        Cdim[Drawed+3],AdjOffset,Azimuth,Aux1^.Last^.NumCar);

    if Aux1^.Last^.NumSmk>0 then
    TraceSmkMIR (NumCam,Xsec[Drawed+3],
                        Ysec[Drawed+3],
                        Zsec[Drawed+3],
                        Asec[Drawed+3]+180,
                        Cdim[Drawed+3],AdjOffset,Azimuth,Aux1^.Last^.NumSmk);

    end
  end;
  Fillchar(chk,SizeOf(Chk),0);
 end;
ChgRap(5);
end;

(*************************** END CAMING ******************************)
(*************************** END CAMING ******************************)
(*************************** END CAMING ******************************)

Procedure PlaceCam(Num:byte;iSec: PuntSec;iX,iZ,iY: extended; iAngle: Integer);
begin
 with cam[Num] do begin
  Mode          :=0;
  X             :=iX;
  Z             :=iZ;
  Y             :=iY;
  Angle         :=iAngle;
  GAngle        :=0;
  Grise         :=0;
  Sec           :=iSec;
  CurrRise      :=0;
  CurrDist      :=140;
  Reverse       :=False;
  DisPerc       :=0;
 end;
end;

Procedure CamNextSec(Num: byte);
begin
Cam[Num].Sec:=Cam[Num].Sec^.Next;
end;

Procedure CamLastSec(Num: byte);
begin
Cam[Num].Sec:=Cam[Num].Sec^.Last;
end;

begin
end.