/*
  Program:      Mine Mayhem
  File:         options.h
  Date:         July, 1996 to February, 1997

  The configuration dialog box definitions.

  Freeware, Copyright 1996-7 Jason Hood.

  You are free to use this code, or a portion thereof, as long as an
  appropriate acknowledgement is made.
*/

#ifndef _options_h
#define _options_h

#include <tws/tabwin.h>
#include <tws/radio.h>
#include <tws/checkbox.h>
#include <tws/button.h>

#define CLEAR           0
#define CROSS           1

#define NO_REPOS        0
#define ONE_REPOS       1
#define AUTO            2

#define ALL_OPENED      1               // Bit-masked
#define ALL_MARKED      2

#define CLRLEFT         0
#define CLRRIGHT        1
#define CLRMIDDLE       2


class OptionDlg : public TabWin
{
public:
  OptionDlg();
  ~OptionDlg();

  void Run();

protected:
  void PaintWindow(int x1, int y1, int x2, int y2);

  void cmOK();
  void cmCancel();

  DECLARE_RESPONSE_TABLE;

  int isOK;
  RadioButtonContainer *game, *start, *clear;
  CheckBox *marks, *wrap,
           *automark, *autoopen,
           *finishopen, *finishmark;
  TextButton *OK, *Cancel;
};

extern int Game, Start, Finish, ClearButton;
extern BOOL isMarks, isWrap, isAutoMark, isAutoOpen;

#endif

