'
'       ***************************************************************
'       *   ۻ   ۻ  ۻ  ۻ  ۻ  ۻ      ۻ  *
'       *   ۻ ۺ ۻ ۻ ۻ ۺ      ͼ  *
'       *   ۺ ۺ ɼ ɼ ۺ      ۻ    *
'       *   ۺɼۺ ۺ ۻ ۻ ۺ      ͼ    *
'       *   ۺ ͼ ۺ ۺ  ۺ ۺ  ۺ ɼ ۻ ۻ  *
'       *   ͼ     ͼ ͼ  ͼ ͼ  ͼ ͼ  ͼ ͼ  *
'       *        ۻ   ۻ  ۻ  ۻ   ۻ ۻ  ۻ          *
'       *        ۻ ۺ ۻ ۻ  ۺ ۺ ۻ         *
'       *        ۺ ۺ ۻ ۺ ۺ ۺ         *
'       *        ۺɼۺ ۺ ۺۻۺ ۺ ۺ         *
'       *        ۺ ͼ ۺ ۺ  ۺ ۺ ۺ ۺ ۺ  ۺ         *
'       *        ͼ     ͼ ͼ  ͼ ͼ  ͼ ͼ ͼ  ͼ         *
'       ***************************************************************
'                         by Nick Schweitzer
'
'       Description: Marble Mania, a breakthru like game in which the
'                    object is to break all of the blocks by bouncing
'                    the marble off of the paddle.
'
'       How to Play: Type "mm" to start the batch file ,
'                    the controls for the game are:
'             
'                    Press a key to release then ball(or wait 5 secs)
'                    Left Mouse Button  = move paddle left      
'                    Right Mouse Button = move paddle right
'
'       NOTE:  MM.GIF MUST BE PRESENT IN THE SAME DIRECTORY AS MM.BAS
'              DO NOT CHANGE MM.GIF OR ELSE THE GAME MIGHT NOT RUN RIGHT
'
'               This program as all others of mine are FREEWARE,
'                       Please distribute widely, THANKYOU!
'
'----------------------------------------------------------------------------






DEFINT A-Z
TYPE PaletteType
Red AS INTEGER
Green AS INTEGER
Blue AS INTEGER
END TYPE

TYPE RegTypeX
  ax    AS INTEGER
  bx    AS INTEGER
  cx    AS INTEGER
  dx    AS INTEGER
  bp    AS INTEGER
  si    AS INTEGER
  di    AS INTEGER
  flags AS INTEGER
  ds    AS INTEGER
  es    AS INTEGER
END TYPE

DECLARE SUB InterruptX (IntNum%, regsx AS RegTypeX)
DECLARE SUB Palette.Set (nColor%, pInfo AS PaletteType)
DECLARE SUB Palette.Get (nColor%, pInfo AS PaletteType)
DECLARE SUB Palette.Fadeout ()
DECLARE SUB Palette.FadeIn ()
DECLARE SUB MouseHide ()
DECLARE SUB MouseShow ()
DECLARE SUB MouseClear ()
DECLARE SUB MouseDriver (m0%, m1%, m2%, m3%)
DECLARE SUB MouseInfo (MouseVers!, MouseType$, MouseIRQ%)
DECLARE SUB MouseTextPos (Row%, Col%, lbutton%, rbutton%)

DECLARE FUNCTION MouseCheck% ()

DIM SHARED regsx AS RegTypeX
DIM SHARED MousePresent
DIM SHARED MouseChecked
DIM SHARED Pal AS PaletteType
DIM SHARED pData(0 TO 255, 1 TO 3)

DEFINT A-Z
CONST TRUE = -1
CONST FALSE = NOT TRUE
CONST ESC = 27

IF NOT MouseCheck% THEN GOTO NoMouse
  
   KEY 15, CHR$(4 + 128 + 32 + 64) + CHR$(70)
   ON KEY(15) GOSUB NoBreak: KEY(15) ON
   KEY 16, CHR$(4 + 128) + CHR$(70): ON KEY(16) GOSUB NoBreak: KEY(16) ON
   KEY 17, CHR$(4 + 128 + 32) + CHR$(70): ON KEY(17) GOSUB NoBreak
   KEY(17) ON: KEY 18, CHR$(4 + 128 + 64) + CHR$(70): ON KEY(18) GOSUB NoBreak
   KEY(18) ON: KEY 19, CHR$(4) + CHR$(70): ON KEY(21) GOSUB NoBreak
   KEY(21) ON: KEY 22, CHR$(4 + 64) + CHR$(70)
   ON KEY(22) GOSUB NoBreak: KEY(22) ON: KEY 23, CHR$(4 + 32) + CHR$(46)
   ON KEY(23) GOSUB NoBreak: KEY(23) ON: KEY 24, CHR$(4 + 64) + CHR$(46)
   ON KEY(24) GOSUB NoBreak: KEY(24) ON
   KEY 25, CHR$(4 + 32 + 64) + CHR$(46): ON KEY(25) GOSUB NoBreak: KEY(25) ON

A$ = "mm.gif"     'title screen/sprite source

DEFINT A-Z
DIM Prefix(4095), Suffix(4095), OutStack(4095), shiftout%(8)
DIM Ybase AS LONG, powersof2(11) AS LONG, WorkCode AS LONG
FOR A% = 0 TO 7: shiftout%(8 - A%) = 2 ^ A%: NEXT A%
FOR A% = 0 TO 11: powersof2(A%) = 2 ^ A%: NEXT A%
IF INSTR(A$, ".") = 0 THEN A$ = A$ + ".gif"
OPEN A$ FOR BINARY AS #1
A$ = "      ": GET #1, , A$
IF A$ <> "GIF87a" THEN PRINT "Not a GIF87a file.": END
GET #1, , TotalX: GET #1, , TotalY: GOSUB GetByte
NumColors = 2 ^ ((A% AND 7) + 1): NoPalette = (A% AND 128) = 0
GOSUB GetByte: Background = A%
GOSUB GetByte: IF A% <> 0 THEN PRINT "Bad screen descriptor.": END
IF NoPalette = 0 THEN p$ = SPACE$(NumColors * 3): GET #1, , p$
DO
    GOSUB GetByte
    IF A% = 44 THEN
        EXIT DO
    ELSEIF A% <> 33 THEN
        PRINT "Unknown extension type.": END
    END IF
    GOSUB GetByte
    DO: GOSUB GetByte: A$ = SPACE$(A%): GET #1, , A$: LOOP UNTIL A% = 0
LOOP
GET #1, , XStart: GET #1, , YStart: GET #1, , XLength: GET #1, , YLength
XEnd = XStart + XLength: YEnd = YStart + YLength: GOSUB GetByte
IF A% AND 128 THEN PRINT "Can't handle local colormaps.": END
Interlaced = A% AND 64: PassNumber = 0: PassStep = 8
GOSUB GetByte
ClearCode = 2 ^ A%
EOSCode = ClearCode + 1
FirstCode = ClearCode + 2: NextCode = FirstCode
StartCodeSize = A% + 1: CodeSize = StartCodeSize
StartMaxCode = 2 ^ (A% + 1) - 1: MaxCode = StartMaxCode
 
BitsIn = 0: BlockSize = 0: BlockPointer = 1
x% = XStart: y% = YStart: Ybase = y% * 320&
 
SCREEN 13: DEF SEG = &HA000
IF NoPalette = 0 THEN
    OUT &H3C7, 0: OUT &H3C8, 0
    FOR A% = 1 TO NumColors * 3: OUT &H3C9, ASC(MID$(p$, A%, 1)) \ 4: NEXT A%
END IF
LINE (0, 0)-(319, 199), Background, BF
DO
    GOSUB GetCode
    IF Code <> EOSCode THEN
        IF Code = ClearCode THEN
            NextCode = FirstCode
            CodeSize = StartCodeSize
            MaxCode = StartMaxCode
            GOSUB GetCode
            CurCode = Code: LastCode = Code: LastPixel = Code
            IF x% < 320 THEN POKE x% + Ybase, LastPixel
            x% = x% + 1: IF x% = XEnd THEN GOSUB NextScanLine
        ELSE
            CurCode = Code: StackPointer = 0
            IF Code > NextCode THEN EXIT DO
            IF Code = NextCode THEN
                CurCode = LastCode
                OutStack(StackPointer) = LastPixel
                StackPointer = StackPointer + 1
            END IF
 
            DO WHILE CurCode >= FirstCode
                OutStack(StackPointer) = Suffix(CurCode)
                StackPointer = StackPointer + 1
                CurCode = Prefix(CurCode)
            LOOP
 
            LastPixel = CurCode
            IF x% < 320 THEN POKE x% + Ybase, LastPixel
            x% = x% + 1: IF x% = XEnd THEN GOSUB NextScanLine
 
            FOR A% = StackPointer - 1 TO 0 STEP -1
                IF x% < 320 THEN POKE x% + Ybase, OutStack(A%)
                x% = x% + 1: IF x% = XEnd THEN GOSUB NextScanLine
            NEXT A%
 
            IF NextCode < 4096 THEN
                Prefix(NextCode) = LastCode
                Suffix(NextCode) = LastPixel
                NextCode = NextCode + 1
                IF NextCode > MaxCode AND CodeSize < 12 THEN
                    CodeSize = CodeSize + 1
                    MaxCode = MaxCode * 2 + 1
                END IF
            END IF
            LastCode = Code
        END IF
    END IF
LOOP UNTIL DoneFlag OR Code = EOSCode
GOTO game

GetByte: A$ = " ": GET #1, , A$: A% = ASC(A$): RETURN
 
NextScanLine:
    IF Interlaced THEN
        y% = y% + PassStep
        IF y% >= YEnd THEN
            PassNumber = PassNumber + 1
            SELECT CASE PassNumber
            CASE 1: y% = 4: PassStep = 8
            CASE 2: y% = 2: PassStep = 4
            CASE 3: y% = 1: PassStep = 2
            END SELECT
        END IF
    ELSE
        y% = y% + 1
    END IF
    x% = XStart: Ybase = y% * 320&: DoneFlag = y% > 199
RETURN
GetCode:
    IF BitsIn = 0 THEN GOSUB ReadBufferedByte: LastChar = A%: BitsIn = 8
    WorkCode = LastChar \ shiftout%(BitsIn)
    DO WHILE CodeSize > BitsIn
        GOSUB ReadBufferedByte: LastChar = A%
        WorkCode = WorkCode OR LastChar * powersof2(BitsIn)
        BitsIn = BitsIn + 8
    LOOP
    BitsIn = BitsIn - CodeSize
    Code = WorkCode AND MaxCode
RETURN
ReadBufferedByte:
    IF BlockPointer > BlockSize THEN
        GOSUB GetByte: BlockSize = A%
        A$ = SPACE$(BlockSize): GET #1, , A$
        BlockPointer = 1
    END IF
    A% = ASC(MID$(A$, BlockPointer, 1)): BlockPointer = BlockPointer + 1
RETURN
game:
 CLOSE
 size% = 4 + INT(((PMAP(92, 0) - PMAP(69, 0) + 1) * (8) + 7) / 8) * 1 * (PMAP(146, 1) - PMAP(127, 1) + 1)
 size2% = 4 + INT(((PMAP(102, 0) - PMAP(59, 0) + 1) * (8) + 7) / 8) * 1 * (PMAP(152, 1) - PMAP(146, 1) + 1)
 DIM ball(size%)
 DIM pad(size2%)
 GET (69, 127)-(92, 146), ball(1)
 GET (59, 146)-(102, 152), pad(1)
 lives = 3
 MouseShow
 TIMER ON
 ON TIMER(10) GOSUB demo
 WHILE INKEY$ <> CHR$(27)
  MouseTextPos Row, Col, lbutton, rbutton
  IF lbutton THEN
   IF Row = 8 OR Row = 9 THEN
    IF Col >= 16 AND Col <= 22 THEN MouseHide: : TIMER OFF: GOTO start
   END IF
   IF Row = 1 AND Col = 1 THEN PLAY "t255l64>c<": lives = 99
  END IF
 WEND
 TIMER OFF
 JustQuit = 1
 GOTO done
start:
 Palette.Fadeout
 CLS
 DIM block$(8, 40)
 lupe = 3
 lupe2 = 1
 colr = 1
 FOR RR = 1 TO 8
  FOR cc = 2 TO 39
   block$(RR, cc) = ""
   LOCATE RR, cc
   IF lupe = 4 THEN colr = colr + 1: lupe = 3
   COLOR colr
   PRINT block$(RR, cc);
   lupe = lupe + 1
  NEXT
  colr = lupe2 + 1
  lupe2 = lupe2 + 1
  lupe = 1
  block$(RR, 1) = " "
  block$(RR, 40) = " "
 NEXT
 px = 149
 py = 80
 CONST up = 1
 CONST dn = 2
 CONST lt = 3
 CONST rt = 4
 CONST uplt = 5
 CONST uprt = 6
 CONST dnlt = 7
 CONST dnrt = 8
 CONST botm = 150
 padx = 140
 PUT (padx, botm), pad(1), PSET
hh:
 RANDOMIZE VAL(RIGHT$(TIME$, 2))
 hh = INT(RND * 10)
 IF hh < 5 THEN dir = dnlt
 IF hh >= 5 THEN dir = dnrt
 PUT (0, 170), ball(1), PSET
 PUT (24, 170), ball(1), PSET
 PUT (49, 170), ball(1), PSET
 Palette.FadeIn
 PUT (49, 170), ball(1), XOR
 PUT (px, py), ball(1), PSET
 SLEEP 5
 GOTO move
force:
 IF dir = up THEN GOTO forceup
 IF dir = dn THEN GOTO forcedn
 IF dir = uplt THEN GOTO forceuplt
 IF dir = uprt THEN GOTO forceuprt
 IF dir = dnlt THEN GOTO forcednlt
 IF dir = dnrt THEN GOTO forcednrt
forceup:
 IF py = 0 THEN dir = dn: GOTO forcedn
 py = py - 1: GOTO xorit
forcedn:
 IF py = botm - 20 THEN GOTO check
 IF py > botm THEN GOTO die:
 py = py + 1: GOTO xorit
forceuplt:
 IF px = 0 AND py = 0 THEN dir = dnrt: RETURN
 IF px = 0 THEN dir = uprt: RETURN
 IF py = 0 THEN dir = dnlt: RETURN
 px = px - 1: py = py - 1: GOTO xorit
forceuprt:
 IF px = 296 AND py = 0 THEN dir = dnlt: RETURN
 IF px = 296 THEN dir = uplt: RETURN
 IF py = 0 THEN dir = dnrt: RETURN
 px = px + 1: py = py - 1: GOTO xorit
forcednlt:
 IF py > botm THEN GOTO die
 IF py = botm - 20 THEN GOTO check
 IF px = 0 THEN dir = dnrt: RETURN
 px = px - 1: py = py + 1: GOTO xorit
forcednrt:
 IF py > botm THEN GOTO die
 IF py = botm - 20 THEN GOTO check
 IF px = 296 THEN dir = dnlt: RETURN
 px = px + 1: py = py + 1: GOTO xorit
xorit:
 PUT (px, py), ball(1), PSET: RETURN
move:
 WHILE INKEY$ <> CHR$(ESC)
  MouseTextPos Row, Col, lbutton, rbutton
  PLAY "l64t255p64"
  IF lbutton THEN GOSUB padlt
  IF rbutton THEN GOSUB padrt
  GOSUB hitblock
  GOSUB checkwin
  GOSUB force
 WEND
 GOTO done
padlt:
 IF padx = 0 THEN RETURN
 padx = padx - 1
 PUT (padx, botm), pad(1), PSET: RETURN
padrt:
 IF padx = 276 THEN RETURN
 padx = padx + 1
 PUT (padx, botm), pad(1), PSET: RETURN
check:
 IF px > padx THEN
  FOR p% = 0 TO 41   '41 '21 '25
   IF px = padx + p% THEN GOTO bounce
  NEXT
 END IF
 IF px < padx THEN
  FOR p% = 0 TO 23   '21   '25
   IF px = padx - p% THEN GOTO bounce
  NEXT
 END IF
 IF px = padx THEN
  IF dir = dn THEN dir = up: RETURN
  IF dir = dnrt THEN dir = uprt: RETURN
  IF dir = dnlt THEN dir = uplt: RETURN
 END IF
 GOTO die
bounce:
 PLAY "l64t255<<<c>>>"
 IF px < padx THEN
  IF dir = dn THEN
rand1:
   RANDOMIZE VAL(RIGHT$(TIME$, 2))
   dose = INT(RND * 3)
   IF dose = 0 THEN dir = up: RETURN
   IF dose = 1 THEN dir = uplt: RETURN
   IF dose = 2 THEN dir = uprt: RETURN
   IF dose = 3 THEN GOTO rand1
  END IF
 IF dir = dnlt THEN dir = uplt: RETURN
 IF dir = dnrt THEN dir = uprt: RETURN
 END IF
 IF px > padx THEN
  FOR dd = 20 TO 30
   IF px = padx + dd THEN dir = up: RETURN
   IF px = padx + (25) - (dd) THEN dir = up: RETURN
  NEXT
  IF dir = dn THEN
rand2:
  RANDOMIZE VAL(RIGHT$(TIME$, 2))
  dose = INT(RND * 3)
  IF dose = 0 THEN dir = up: RETURN
  IF dose = 1 THEN dir = uplt: RETURN
  IF dose = 2 THEN dir = uprt: RETURN
  IF dose = 3 THEN GOTO rand2
 END IF
 IF dir = dnlt THEN dir = uplt: RETURN
 IF dir = dnrt THEN dir = uprt: RETURN
 END IF
die:
 MouseClear
 PUT (px, py), ball(1), XOR    'erase the ball
 IF lives <> 1 THEN PUT (padx, botm), pad(1), XOR   'erase the padl
 PLAY "MST255L64O6FEDC<BAGFEDC<BAGFEDC<BAGFEDC<BAGFEDC<BAGFE"
 PLAY "DC<BAGFEDCBAGFEDCO6EDC<BAGFEDC<BAGFEDC<BAGFEDC<BAGFED>>"
 px = 149
 py = 80
 padx = 140
XX:
 RANDOMIZE VAL(RIGHT$(TIME$, 2))
 XX = INT(RND * 10)
 IF XX < 5 THEN dir = dnlt
 IF XX >= 5 THEN dir = dnrt
 lives = lives - 1
 IF lives = 2 THEN PUT (24, 170), ball(1), XOR
 IF lives = 1 THEN PUT (0, 170), ball(1), XOR
 IF lives = 0 THEN GOTO done
 PUT (px, py), ball(1), PSET
 PUT (padx, botm), pad(1), PSET
 SLEEP 5
 RETURN
done:
 IF JustQuit <> 1 THEN
  DIM melt%(3000)
  FOR RR = 1 TO 3000
    RANDOMIZE TIMER
    XX = INT(RND * 271)
    RANDOMIZE TIMER
    YX = INT(RND * 150)
    GET (XX, YX)-(XX + 48, YX + 48), melt%
    PUT (XX, YX + 1), melt%, PSET
    IF INKEY$ = CHR$(27) THEN GOTO SkipMelt
  NEXT RR
 END IF
SkipMelt:
 Palette.Fadeout
 SYSTEM
hitblock:
 IF px >= 8 THEN textcol = px / 8 + (2) ELSE textcol = 1
 IF py >= 8 THEN textrow = py / 8 ELSE textrow = 1
 IF textrow <= 8 THEN
  IF block$(textrow, textcol) = " " AND block$(textrow, textcol - 1) = " " AND block$(textrow, textcol + 1) = " " THEN RETURN
  block$(textrow, textcol) = " "
  block$(textrow, textcol - 1) = " "
  block$(textrow, textcol + 1) = " "
  PLAY "l64t255<<c+>>"
  IF dir = uprt THEN dir = dnrt
  IF dir = up THEN dir = dn
  IF dir = uplt THEN dir = dnlt
  lupe = 3
  lupe2 = 1
  colr = 1
  FOR RR = 1 TO 8
   FOR cc = 2 TO 39
    LOCATE RR, cc
    IF lupe = 4 THEN colr = colr + 1: lupe = 3
    COLOR colr
    PRINT block$(RR, cc);
    lupe = lupe + 1
   NEXT
    colr = lupe2 + 1
    lupe2 = lupe2 + 1
    lupe = 1
  NEXT
 END IF
 RETURN
checkwin:
 FOR testrow = 1 TO 8
  FOR testcol = 1 TO 40
   IF block$(testrow, testcol) = "" THEN RETURN
  NEXT
 NEXT
 PLAY "<<t180l2eag.mll4dmsemlamsgmldmsemnagl16gab>c+l3d.l4c+dl2c+<al1b.mn>>"
 Palette.Fadeout
 SYSTEM
NoBreak:
 RETURN
NoMouse:
 PRINT "Mouse not detected!"
 SYSTEM
demo:
 TIMER OFF
 Palette.Fadeout
 MouseHide
 CLS
 demox = 149
 demoy = 80
 n = 1
 s = 2
 ne = 3
 nw = 4
 se = 5
 sw = 6
 demobotm = 150
 demodir = ne
 PUT (demox, demoy), ball(1), PSET
 PUT (demox, demobotm), pad(1), PSET
 Palette.FadeIn
 WHILE INKEY$ <> "": WEND
 WHILE INKEY$ = ""
  MouseTextPos Row, Col, lbutton, rbutton
  IF lbutton OR rbutton THEN
   MouseClear
   IF demodir = ne THEN demodir = sw: GOTO MadeChange
   IF demodir = nw THEN demodir = se: GOTO MadeChange
   IF demodir = sw THEN demodir = ne: GOTO MadeChange
   IF demodir = se THEN demodir = nw: GOTO MadeChange
MadeChange:
  END IF
  PUT (demox, demobotm), pad(1), PSET
  PUT (demox, demoy), ball(1), PSET
  PLAY "l64t255p64"
  GOSUB demoforce
 WEND
 GOTO start
demoforce:
 IF demodir = n THEN
  IF demox = 0 THEN demodir = s: PLAY "l64t255<<<c+>>>": RETURN
  demoy = demoy - 1: RETURN
 END IF
 IF demodir = s THEN
  IF demoy = demobotm - 20 THEN demodir = n: PLAY "l64t255<<<c+>>>": RETURN
  demoy = demoy + 1
 END IF
 IF demodir = nw THEN
  IF demox = 0 AND demoy = 0 THEN demodir = se: PLAY "l64t255<<<c+>>>": RETURN
  IF demox = 0 THEN demodir = ne: PLAY "l64t255<<<c+>>>": RETURN
  IF demoy = 0 THEN demodir = sw: PLAY "l64t255<<<c+>>>": RETURN
  demox = demox - 1: demoy = demoy - 1: RETURN
 END IF
 IF demodir = ne THEN
  IF demox = 276 AND demoy = 0 THEN demodir = sw: PLAY "l64t255<<<c+>>>": RETURN
  IF demox = 276 THEN demodir = nw: PLAY "l64t255<<<c+>>>": RETURN
  IF demoy = 0 THEN demodir = se: PLAY "l64t255<<<c+>>>": RETURN
  demox = demox + 1: demoy = demoy - 1: RETURN
 END IF
 IF demodir = sw THEN
  IF demox = 0 AND demoy = demobotm - 20 THEN demodir = ne: PLAY "l64t255<<<c+>>>": RETURN
  IF demox = 0 THEN demodir = se: PLAY "l64t255<<<c+>>>": RETURN
  IF demoy = demobotm - 20 THEN demodir = nw: PLAY "l64t255<<<c+>>>": RETURN
  demox = demox - 1: demoy = demoy + 1: RETURN
 END IF
 IF demodir = se THEN
  IF demox = 276 AND demoy = demobotm - 20 THEN : PLAY "l64t255<<<c+>>>": demodir = nw: RETURN
  IF demox = 276 THEN demodir = sw: PLAY "l64t255<<<c+>>>": RETURN
  IF demoy = demobotm - 20 THEN : demodir = ne: PLAY "l64t255<<<c+>>>": RETURN
  demox = demox + 1: demoy = demoy + 1: RETURN
 END IF

'hex data for interrupt routines
DATA  &H55, &H8B, &HEC, &H83, &HEC, &H08, &H56, &H57, &H1E, &H55, &H8B, &H5E
DATA  &H06, &H8B, &H47, &H10, &H3D, &HFF, &HFF, &H75, &H04, &H1E, &H8F, &H47
DATA  &H10, &H8B, &H47, &H12, &H3D, &HFF, &HFF, &H75, &H04, &H1E, &H8F, &H47
DATA  &H12, &H8B, &H47, &H08, &H89, &H46, &HF8, &H8B, &H07, &H8B, &H4F, &H04
DATA  &H8B, &H57, &H06, &H8B, &H77, &H0A, &H8B, &H7F, &H0C, &HFF, &H77, &H12
DATA  &H07, &HFF, &H77, &H02, &H1E, &H8F, &H46, &HFA, &HFF, &H77, &H10, &H1F
DATA  &H8B, &H6E, &HF8, &H5B, &HCD, &H21, &H55, &H8B, &HEC, &H8B, &H6E, &H02
DATA  &H89, &H5E, &HFC, &H8B, &H5E, &H06, &H1E, &H8F, &H46, &HFE, &HFF, &H76
DATA  &HFA, &H1F, &H89, &H07, &H8B, &H46, &HFC, &H89, &H47, &H02, &H89, &H4F
DATA  &H04, &H89, &H57, &H06, &H58, &H89, &H47, &H08, &H89, &H77, &H0A, &H89
DATA  &H7F, &H0C, &H9C, &H8F, &H47, &H0E, &H06, &H8F, &H47, &H12, &H8B, &H46
DATA  &HFE, &H89, &H47, &H10, &H5A, &H1F, &H5F, &H5E, &H8B, &HE5, &H5D, &HCA
DATA  &H02, &H00

'[IM, from code by DG]
SUB InterruptX (IntNum, regsx AS RegTypeX) STATIC

  STATIC FileNum, IntOffset, Loaded
  
  ' use fixed-length string to fix its position in memory
  ' and so we don't mess up string pool before routine
  ' gets its pointers from caller
  DIM IntCode AS STRING * 200
  IF NOT Loaded THEN                        ' loaded will be 0 first time
   
    FOR k = 0 TO 145 'bit of a bodge, this, but it works <dg>
      READ h%        'if anyone fixes it, or explains it, let me know :) <dg>
      Icode$ = Icode$ + CHR$(h%)
    NEXT             'end of bodge <dg>
    
    IntCode = Icode$  ' load routine and determine
    IntOffset = INSTR(IntCode$, CHR$(&HCD) + CHR$(&H21)) + 1 ' int # offset
    Loaded = -1
  END IF
 
  DEF SEG = VARSEG(IntCode)             ' poke interrupt number into
  POKE VARPTR(IntCode) * 1& + IntOffset - 1, IntNum' code block
  CALL absolute(regsx, VARPTR(IntCode$)) ' call routine
  DEF SEG

END SUB

'Limit mouse movement
'[DB]
SUB MouseBorder (row1, col1, row2, col2) STATIC

  regsx.ax = &H1130
  regsx.bx = &H0
  InterruptX &H10, regsx
  ScrRows = (regsx.dx AND 255) + 1

  regsx.ax = &HF00
  InterruptX &H10, regsx
  ScrCols = (regsx.ax AND 65280) / 256

  SELECT CASE regsx.ax AND 255
    CASE 0, 2, 5, 7, 8, 9, 10, 11, 12  'Not used

    CASE 1, 4, 13, 19  'Screen 0/1/2, Width 40 x __//Screen 7/8/9, Width 40 x 25//Screen 13
      CharHor = 16
      CharVer = 8

    CASE 3, 6, 14  'Screen 0/1/2, Width 80 x __//Screen 7/8, Width 80 x 25
      CharHor = 8
      CharVer = 8

    CASE 15, 16  'Screen 10//Screen 9, Width 80 x __
      IF ScrRows = 25 THEN
        CharHor = 8
        CharVer = 14
      ELSE
        CharHor = 8
        CharVer = 8
      END IF

    CASE 17, 18  'Screen 11/12
      IF ScrRows = 30 THEN
        CharHor = 8
        CharVer = 16
      ELSE
        CharHor = 8
        CharVer = 8
      END IF

  END SELECT

  MouseDriver 7, 0, (col1 - 1) * CharHor, (col2 - 1) * CharHor
  MouseDriver 8, 0, (row1 - 1) * CharVer, (row2 - 1) * CharVer

END SUB

'Similar to MouseInit, but returns mouse status
'
FUNCTION MouseCheck

  MouseDriver 0, 0, 0, 0
  MouseCheck = MousePresent

END FUNCTION

'Waits until neither mouse button is pressed
'[DB]
SUB MouseClear

  DO
    MouseTextPos Row%, Col%, lbutton%, rbutton%
  LOOP UNTIL NOT (lbutton% OR rbutton%)

END SUB

'General interrupt routine for mouse. See more advanced programming
' information for list of possible parameters.
'[DB, from code by MS]
SUB MouseDriver (m0, m1, m2, m3) STATIC

  IF NOT (MouseChecked) THEN
    DEF SEG = 0
    MouseSegment& = 256& * PEEK(207) + PEEK(206)
    MouseOffset& = 256& * PEEK(205) + PEEK(204)
    DEF SEG = MouseSegment&

    IF (MouseSegment& = 0 AND MouseOffset& = 0) OR PEEK(MouseOffset&) = 207 THEN
      MousePresent = FALSE
      MouseChecked = TRUE
      DEF SEG
    END IF
  END IF

  IF NOT (MouseChecked) OR MousePresent THEN

    ' Calls interrupt &H33 to invoke mouse functions in the MS Mouse Driver.
    regsx.ax = m0
    regsx.bx = m1
    regsx.cx = m2
    regsx.dx = m3

    InterruptX &H33, regsx

    m0 = regsx.ax
    m1 = regsx.bx
    m2 = regsx.cx
    m3 = regsx.dx

    IF NOT MouseChecked THEN
      ' Check for successful mouse initialization
      IF m0 THEN
        MousePresent = TRUE
        DEF SEG
      END IF
      MouseChecked = TRUE
    END IF
  END IF

END SUB

'Hides mouse cursor
'[MS]
SUB MouseHide

  MouseDriver 2, 0, 0, 0

END SUB

'MouseVers = Mouse driver version (x.xx)
'MouseType$ = Describes mouse
'MouseIRQ = IRQ being used by mouse (0 = PS/2 system)
'[DB]
SUB MouseInfo (MouseVers!, MouseType$, MouseIRQ)

  m0% = &H24
  MouseDriver m0%, m1%, m2%, m3%

  MouseVers! = ((m1% AND &HFF00) / 256) + ((m1% AND 255) / 100)
  SELECT CASE (m2% AND &HFF00) / 256
    CASE 1: MouseType$ = "Bus"
    CASE 2: MouseType$ = "Serial"
    CASE 3: MouseType$ = "InPort"
    CASE 4: MouseType$ = "PS/2"
    CASE 5: MouseType$ = "HP"
    CASE ELSE: MouseType$ = "Unknown"
  END SELECT
  MouseIRQ = m2% AND 255

END SUB

'Mouse driver's initialisation routine
'[MS]
SUB MouseInit

  MouseDriver 0, 0, 0, 0

END SUB

'Sets limits for the mouse (XMin, YMin)-(XMax, YMax)
'[MS]
SUB MouseLimit (XMin, YMin, XMax, YMax)

  MouseDriver 7, 0, XMin, XMax
  MouseDriver 8, 0, YMin, YMax

END SUB

'Polls mouse driver, then sets parameters accordingly
' NB: This routine returns the >character< position of the mouse cursor, even
'   though the >graphics< position is passed back by MouseDriver. This leads
'   to problems in some screens, with the cursor apparently pointing lower
'   than it actually is.
'     For safety in these cases, use MouseTextPos.
'     This routine works fine for SCREEN 0: WIDTH 80, 25.
'     For other modes, please see the file MOUSEDJB.TXT
'     I have not changed this querk, in order to maintain compatibility.
'[DB, from code by MS]
SUB MousePoll (Row, Col, lbutton, rbutton) STATIC

  MouseDriver 3, Button, Col, Row
  Row = Row / 8 + 1
  Col = Col / 8 + 1

  IF Button AND 1 THEN
    lbutton = TRUE
  ELSE
    lbutton = FALSE
  END IF

  IF Button AND 2 THEN
    rbutton = TRUE
  ELSE
    rbutton = FALSE
  END IF

END SUB

'Polls mouse driver, then sets parameters accordingly
'[MS]
SUB MousePos (XPos, YPos, lbutton, rbutton) STATIC

  MouseDriver 3, Button, XPos, YPos

  regsx.ax = &HF00
  InterruptX &H10, regsx
  test = regsx.ax AND 255
  IF (test = 4) OR (test = 5) OR (test = 13) OR (test = 19) THEN
    XPos = XPos / 2
  END IF

  IF Button AND 1 THEN
    lbutton = TRUE
  ELSE
    lbutton = FALSE
  END IF

  IF Button AND 2 THEN
    rbutton = TRUE
  ELSE
    rbutton = FALSE
  END IF

END SUB

'Shows mouse cursor
'[MS]
SUB MouseShow

  MouseDriver 1, 0, 0, 0

END SUB

'Polls mouse driver, then sets parameters accordingly.
' (Only tested on VGA screen)
'[DB]
SUB MouseTextPos (Row, Col, lbutton, rbutton) STATIC

  MouseDriver 3, Button, Col, Row

  regsx.ax = &H1130
  regsx.bx = &H0
  InterruptX &H10, regsx
  ScrRows = (regsx.dx AND 255) + 1

  regsx.ax = &HF00
  InterruptX &H10, regsx
  ScrCols = (regsx.ax AND 65280) / 256

  SELECT CASE regsx.ax AND 255
    CASE 0, 2, 5, 7, 8, 9, 10, 11, 12  'Not used

    CASE 1, 4, 13, 19  'Screen 0/1/2, Width 40 x __//Screen 7/8/9, Width 40 x 25//Screen 13
         CharHor = 16
         CharVer = 8

    CASE 3, 6, 14  'Screen 0/1/2, Width 80 x __//Screen 7/8, Width 80 x 25
         CharHor = 8
         CharVer = 8

    CASE 15, 16  'Screen 10//Screen 9, Width 80 x __
         IF ScrRows = 25 THEN
           CharHor = 8
           CharVer = 14
         ELSE
           CharHor = 8
           CharVer = 8
         END IF

    CASE 17, 18  'Screen 11/12
         IF ScrRows = 30 THEN
           CharHor = 8
           CharVer = 16
         ELSE
           CharHor = 8
           CharVer = 8
         END IF

  END SELECT

  Row = FIX(Row / CharVer) + 1
  Col = FIX(Col / CharHor) + 1

  IF Button AND 1 THEN
    lbutton = TRUE
  ELSE
    lbutton = FALSE
  END IF

  IF Button AND 2 THEN
    rbutton = TRUE
  ELSE
    rbutton = FALSE
  END IF

END SUB

SUB Palette.FadeIn
DIM tt(1 TO 3)
FOR i = 1 TO 64
WAIT &H3DA, 8, 8
  FOR O = 0 TO 255
    Palette.Get O, Pal
    tt(1) = Pal.Red
    tt(2) = Pal.Green
    tt(3) = Pal.Blue
    IF tt(1) < pData(O, 1) THEN tt(1) = tt(1) + 1
    IF tt(2) < pData(O, 2) THEN tt(2) = tt(2) + 1
    IF tt(3) < pData(O, 3) THEN tt(3) = tt(3) + 1
    Pal.Red = tt(1)
    Pal.Green = tt(2)
    Pal.Blue = tt(3)
    Palette.Set O, Pal
  NEXT O
NEXT i

END SUB

SUB Palette.Fadeout
DIM tt(1 TO 3)
FOR i = 0 TO 255
  Palette.Get i, Pal
  pData(i, 1) = Pal.Red
  pData(i, 2) = Pal.Green
  pData(i, 3) = Pal.Blue
NEXT i
FOR i = 1 TO 64
WAIT &H3DA, 8, 8
  FOR O = 0 TO 255
    Palette.Get O, Pal
    tt(1) = Pal.Red
    tt(2) = Pal.Green
    tt(3) = Pal.Blue
    IF tt(1) > 0 THEN tt(1) = tt(1) - 1
    IF tt(2) > 0 THEN tt(2) = tt(2) - 1
    IF tt(3) > 0 THEN tt(3) = tt(3) - 1
    Pal.Red = tt(1)
    Pal.Green = tt(2)
    Pal.Blue = tt(3)
    Palette.Set O, Pal
  NEXT O
NEXT i
END SUB

SUB Palette.Get (nColor%, pInfo AS PaletteType)
OUT &H3C6, &HFF
OUT &H3C7, nColor%
pInfo.Red = INP(&H3C9)
pInfo.Green = INP(&H3C9)
pInfo.Blue = INP(&H3C9)
END SUB

SUB Palette.Set (nColor%, pInfo AS PaletteType)
OUT &H3C6, &HFF
OUT &H3C8, nColor%
OUT &H3C9, pInfo.Red
OUT &H3C9, pInfo.Green
OUT &H3C9, pInfo.Blue
END SUB

