' Kamikaze Aliens VI by Jester

DECLARE SUB explode (xp AS INTEGER, yp AS INTEGER, mode AS INTEGER)
DECLARE SUB cleararea (xb AS INTEGER, yb AS INTEGER, xp AS INTEGER, yp AS INTEGER, s AS INTEGER)
DECLARE SUB shoot (xp AS INTEGER, yp AS INTEGER)
DECLARE SUB center (text AS STRING)
DECLARE SUB soundfx (freq AS INTEGER)
DECLARE SUB loadpal (pname AS INTEGER)
DECLARE SUB loadpics ()
DECLARE SUB movealien ()
DECLARE SUB movebonus ()
DECLARE SUB keyboard ()
DECLARE SUB showscore ()
DECLARE SUB colscroll ()
DECLARE SUB moveshot ()
DECLARE SUB explosion ()
DECLARE SUB movestars ()
DECLARE SUB moveplayer ()
DECLARE SUB moverocket ()
DECLARE SUB moveshield ()
DECLARE SUB moveships ()
DECLARE FUNCTION hitro% (xp AS INTEGER, yp AS INTEGER, s AS INTEGER)
DECLARE FUNCTION hitpl% (xp AS INTEGER, yp AS INTEGER, s AS INTEGER)
DECLARE FUNCTION inside% (xp AS INTEGER, yp AS INTEGER, s AS INTEGER)

CONST gamespeed = 1
CONST root = ""
CONST limx = 639
CONST limy = 479
CONST minx = 0
CONST miny = 0
CONST rocketmax = 16
CONST shotmax = 5
CONST explmax = 16
CONST psize = 1000

TYPE sprite
 nrg AS INTEGER
 x AS INTEGER
 y AS INTEGER
 spdx AS INTEGER
 spdy AS INTEGER
 sz AS INTEGER
END TYPE

DIM player AS sprite
DIM rocket(1 TO rocketmax) AS sprite
DIM expl(1 TO explmax) AS sprite
DIM shot(1 TO shotmax) AS sprite
DIM alien(1 TO 4) AS sprite
DIM shield(1 TO 3) AS sprite
DIM ship(1 TO 4) AS sprite
DIM star(1 TO 11) AS sprite
DIM bonus AS sprite
DIM gamescore AS INTEGER
DIM wing(1 TO 2) AS INTEGER
DIM pical(psize) AS INTEGER
DIM picalx(psize) AS INTEGER
DIM picplay(psize) AS INTEGER
DIM piclw(psize) AS INTEGER
DIM picrw(psize) AS INTEGER
DIM picrock(psize) AS INTEGER
DIM picshield(psize) AS INTEGER
DIM picship(psize) AS INTEGER
DIM picshot(INT(psize / 2)) AS INTEGER

SCREEN 12
RANDOMIZE TIMER
COLOR 2
loadpal 1
loadpics

DO

 keyboard
 movestars
 moveplayer
 moverocket
 moveshield
 moveships
 movealien
 moveshot
 movebonus
 showscore
 colscroll
 explosion

LOOP

SUB center (text AS STRING)

LOCATE 15, 40 - INT(LEN(text) / 2)
PRINT UCASE$(text)
DO
LOOP UNTIL INKEY$ = CHR$(13)

END SUB

SUB cleararea (xb AS INTEGER, yb AS INTEGER, xp AS INTEGER, yp AS INTEGER, s AS INTEGER)

IF xb - s > xp - s THEN
 LINE (xp + s, yb - s)-(xb + s, yb + s), 0, BF

 IF yb - s > yp - s THEN
  LINE (xb - s, yp + s)-(xp + s, yb + s), 0, BF
 ELSEIF yb - s < yp - s THEN
  LINE (xb - s, yb - s)-(xp + s, yp - s), 0, BF
 END IF

ELSE
 IF xb - s < xp - s THEN
  LINE (xb - s, yb - s)-(xp - s, yb + s), 0, BF
 END IF

 IF yb - s > yp - s THEN
  LINE (xp - s, yp + s)-(xb + s, yb + s), 0, BF
 ELSEIF yb - s < yp - s THEN
  LINE (xp - s, yb - s)-(xb + s, yp - s), 0, BF
 END IF

END IF

END SUB

SUB colscroll

STATIC col AS INTEGER

col = col + 2
IF col = 40 THEN col = -40

PALETTE 15, 23 + ABS(col)

END SUB

SUB explode (xp AS INTEGER, yp AS INTEGER, mode AS INTEGER)

SHARED expl() AS sprite
DIM nr AS INTEGER

soundfx 1

FOR nr = 1 TO explmax
 IF expl(nr).nrg = 0 THEN
  expl(nr).nrg = 1
  expl(nr).x = xp
  expl(nr).y = yp
  expl(nr).spdx = 3
  expl(nr).spdy = mode * 10
  EXIT FOR
 END IF
NEXT

END SUB

SUB explosion

DIM nr AS INTEGER
SHARED expl() AS sprite

FOR nr = 1 TO explmax

 IF expl(nr).nrg > 0 THEN
 
  expl(nr).sz = expl(nr).sz + expl(nr).spdx * gamespeed
 
  IF expl(nr).sz > expl(nr).spdy THEN
   expl(nr).sz = 70
   LINE (expl(nr).x - INT(expl(nr).sz / 2), expl(nr).y - INT(expl(nr).sz / 2))-(expl(nr).x + INT(expl(nr).sz / 2), expl(nr).y + INT(expl(nr).sz / 2)), 0, BF
   expl(nr).nrg = 0
   expl(nr).spdx = 0
   expl(nr).sz = 0
  ELSE
   LINE (expl(nr).x - INT(expl(nr).sz / 2), expl(nr).y - INT(expl(nr).sz / 2))-(expl(nr).x + INT(expl(nr).sz / 2), expl(nr).y + INT(expl(nr).sz / 2)), 14 - INT(expl(nr).sz / 10), BF
  END IF

 END IF

NEXT

END SUB

FUNCTION hitpl% (xp AS INTEGER, yp AS INTEGER, s AS INTEGER)

SHARED player AS sprite

IF xp + s > player.x - player.sz AND xp - s < player.x + player.sz AND yp + s > player.y - player.sz AND yp - s < player.y + player.sz THEN
 hitpl% = 1
ELSE
 hitpl% = 0
END IF

END FUNCTION

FUNCTION hitro% (xp AS INTEGER, yp AS INTEGER, s AS INTEGER)

SHARED rocket() AS sprite
DIM nr AS INTEGER
DIM value AS INTEGER

FOR nr = 1 TO rocketmax
 IF rocket(nr).nrg > 0 THEN
  IF xp + s > rocket(nr).x - rocket(nr).sz AND xp - s < rocket(nr).x + rocket(nr).sz THEN
   IF yp + s > rocket(nr).y - rocket(nr).sz AND yp - s < rocket(nr).y + rocket(nr).sz THEN
    value = nr
    EXIT FOR
   END IF
  END IF
 END IF
NEXT

hitro% = value

END FUNCTION

FUNCTION inside% (xp AS INTEGER, yp AS INTEGER, s AS INTEGER)

IF xp - s > minx AND xp + s < limx AND yp - s > miny AND yp + s < limy THEN
 inside% = 1
ELSE
 inside% = 0
END IF

END FUNCTION

SUB keyboard

STATIC slowdown AS INTEGER
SHARED wing() AS INTEGER
SHARED player AS sprite
SHARED rocket() AS sprite

IF slowdown > 0 THEN slowdown = slowdown - 1

SELECT CASE INKEY$
 CASE CHR$(0) + "M"
  IF player.spdx < 15 THEN player.spdx = player.spdx + 3
 
 CASE CHR$(0) + "K"
  IF player.spdx > -15 THEN player.spdx = player.spdx - 3
 
 CASE CHR$(0) + "P"
  IF player.spdy < 10 THEN player.spdy = player.spdy + 2
 
 CASE CHR$(0) + "H"
  IF player.spdy > -10 THEN player.spdy = player.spdy - 2

 CASE " "
  IF slowdown = 0 THEN
  
   DIM check AS INTEGER
 
   FOR xd = -1 TO 1
   
    IF xd = -1 THEN
     check = wing(1)
    ELSEIF xd = 0 THEN
     check = 1
    ELSEIF xd = 1 THEN
     check = wing(2)
    END IF
   
    IF check THEN
   
     DIM nr AS INTEGER
    
     FOR nr = 6 + xd * 5 TO 11 + xd * 5
      IF rocket(nr).nrg = 0 THEN
       rocket(nr).nrg = 1
       rocket(nr).x = player.x + xd * (rocket(nr).sz * 2)
       rocket(nr).y = player.y - player.sz - rocket(nr).sz
       rocket(nr).spdx = xd
       rocket(nr).spdy = -9
       soundfx 0
       EXIT FOR
      END IF
     NEXT
   
    END IF

   NEXT

  slowdown = INT(10 / gamespeed)
 
  ELSEIF slowdown = 2 * gamespeed - 1 THEN
   DIM keybuf AS STRING
   DIM n AS INTEGER
   FOR n = 1 TO 3
    keybuf = INKEY$
   NEXT
 
  END IF

 CASE CHR$(27)
  END
 
 CASE ELSE
  IF player.spdx > 0 THEN
   player.spdx = player.spdx - 1
  ELSEIF player.spdx < 0 THEN
   player.spdx = player.spdx + 1
  END IF
  IF player.spdy > 0 THEN
   player.spdy = player.spdy - 1
  ELSEIF player.spdy < 0 THEN
   player.spdy = player.spdy + 1
  END IF
 
END SELECT

END SUB

SUB loadpal (pname AS INTEGER)

DIM c, c1, c2, c3 AS INTEGER

OPEN root + "pal" + LTRIM$(LEFT$(STR$(pname), 8)) + ".dat" FOR INPUT AS #1
 FOR c = 0 TO 15
  INPUT #1, c1
  INPUT #1, c2
  INPUT #1, c3
  PALETTE c, 2 ^ 16 * c1 + 2 ^ 8 * c2 + c3
 NEXT
CLOSE #1

END SUB

SUB loadpics

SHARED pical() AS INTEGER
SHARED picalx() AS INTEGER
SHARED picplay() AS INTEGER
SHARED piclw() AS INTEGER
SHARED picrw() AS INTEGER
SHARED picrock() AS INTEGER
SHARED picshield() AS INTEGER
SHARED picship() AS INTEGER
SHARED picshot() AS INTEGER

DEF SEG = VARSEG(pical(0))
 BLOAD root + "alien.GRH", VARPTR(pical(0))
DEF SEG
DEF SEG = VARSEG(picalx(0))
 BLOAD root + "alienx.GRH", VARPTR(picalx(0))
DEF SEG
DEF SEG = VARSEG(piclw(0))
 BLOAD root + "lwing.GRH", VARPTR(piclw(0))
DEF SEG
DEF SEG = VARSEG(picrw(0))
 BLOAD root + "rwing.GRH", VARPTR(picrw(0))
DEF SEG
DEF SEG = VARSEG(picplay(0))
 BLOAD root + "player.GRH", VARPTR(picplay(0))
DEF SEG
DEF SEG = VARSEG(picrock(0))
 BLOAD root + "rocket.GRH", VARPTR(picrock(0))
DEF SEG
DEF SEG = VARSEG(picshield(0))
 BLOAD root + "shield.GRH", VARPTR(picshield(0))
DEF SEG
DEF SEG = VARSEG(picship(0))
 BLOAD root + "ship.GRH", VARPTR(picship(0))
DEF SEG
DEF SEG = VARSEG(picshot(0))
 BLOAD root + "shot.GRH", VARPTR(picshot(0))
DEF SEG

END SUB

SUB movealien

DIM buf AS sprite
DIM nr AS INTEGER
SHARED alien() AS sprite
SHARED player AS sprite
SHARED rocket() AS sprite
SHARED gamescore AS INTEGER
SHARED pical() AS INTEGER
SHARED picalx() AS INTEGER

FOR nr = 1 TO 4

 IF alien(nr).nrg > 0 THEN
 
  buf.x = alien(nr).x
  buf.y = alien(nr).y

  alien(nr).x = alien(nr).x + alien(nr).spdx * gamespeed
  alien(nr).y = alien(nr).y + alien(nr).spdy * gamespeed
 
  IF alien(nr).y - alien(nr).sz > limy THEN
   alien(nr).x = INT(RND * limx)
   alien(nr).y = -300
   alien(nr).nrg = 5
  END IF

  IF hitpl%(alien(nr).x, alien(nr).y, alien(nr).sz) THEN
   alien(nr).nrg = alien(nr).nrg - 3
   IF alien(nr).nrg > 0 THEN
    explode alien(nr).x, alien(nr).y, 3
   ELSE
    explode alien(nr).x, alien(nr).y, 6
   END IF
   player.nrg = player.nrg - 3
 
  ELSE
   lnr = hitro%(alien(nr).x, alien(nr).y, alien(nr).sz)
   IF lnr > 0 THEN
    alien(nr).nrg = alien(nr).nrg - 1
    IF alien(nr).nrg > 0 THEN
     explode alien(nr).x, alien(nr).y, 3
    ELSE
     explode alien(nr).x, alien(nr).y, 6
    END IF
    explode rocket(lnr).x, rocket(lnr).y, 3
    gamescore = gamescore + 10
    rocket(lnr).nrg = 0
   END IF
 
  END IF
 
  IF alien(nr).x < player.x AND alien(nr).spdx < 3 THEN
   IF RND * 50 < 5 * gamespeed THEN alien(nr).spdx = alien(nr).spdx + 1
  ELSEIF alien(nr).x > player.x AND alien(nr).spdx > -3 THEN
   IF RND * 50 < 5 * gamespeed THEN alien(nr).spdx = alien(nr).spdx - 1
  ELSEIF alien(nr).x > player.x - 20 AND alien(nr).x < player.x + 20 THEN
   IF RND * 50 < 5 THEN shoot alien(nr).x, alien(nr).y + alien(nr).sz
  END IF

  IF alien(nr).nrg > 0 THEN
  
   IF inside%(alien(nr).x, alien(nr).y, alien(nr).sz) THEN
    
    IF alien(nr).spdy < 4 THEN
     PUT (alien(nr).x - alien(nr).sz, alien(nr).y - alien(nr).sz), pical, PSET
    ELSE
     PUT (alien(nr).x - alien(nr).sz, alien(nr).y - alien(nr).sz), picalx, PSET
    END IF
   
   END IF
   cleararea buf.x, buf.y, alien(nr).x, alien(nr).y, alien(nr).sz

  END IF

 ELSEIF RND * 1000 < 5 THEN
 
  alien(nr).sz = 15
  alien(nr).nrg = 5
  alien(nr).x = INT(RND * limx)
  alien(nr).y = miny + alien(nr).sz
  alien(nr).spdx = RND * 4 - 2
  alien(nr).spdy = INT(RND * 4) + 1
 
 END IF

NEXT

END SUB

SUB movebonus

STATIC sizeadd AS INTEGER
SHARED bonus AS sprite
SHARED wing() AS INTEGER
SHARED gamescore AS INTEGER
SHARED player AS sprite

IF bonus.nrg > 0 THEN

 DIM nr AS INTEGER
 FOR nr = -2 TO 2
  CIRCLE (bonus.x, bonus.y), bonus.sz + nr, 0
 NEXT

 bonus.y = bonus.y + bonus.spdy * gamespeed

 sizeadd = sizeadd + 1
 IF sizeadd = 9 THEN sizeadd = -9

 bonus.sz = 4 + ABS(sizeadd)

 IF bonus.y > limy + bonus.sz THEN
  bonus.nrg = 0

 ELSEIF hitro%(bonus.x, bonus.y, bonus.sz) THEN
  soundfx 1
  bonus.nrg = 0

 ELSEIF hitpl%(bonus.x, bonus.y, bonus.sz) THEN
  soundfx 4
  bonus.nrg = 0
  IF wing(1) = 0 THEN
   wing(1) = 1
  ELSEIF wing(2) = 0 THEN
   wing(2) = 1
  ELSEIF player.nrg < 20 THEN
   player.nrg = 20
  ELSE
   gamescore = gamescore + 500
  END IF

 END IF

 IF inside%(bonus.x, bonus.y, bonus.sz) AND bonus.nrg > 0 THEN
  FOR nr = -2 TO 2
   CIRCLE (bonus.x, bonus.y), bonus.sz + nr, 1 * (10 - ABS(nr))
  NEXT
 END IF

ELSEIF RND * 1000 < 5 THEN

 bonus.nrg = 1
 bonus.x = (RND * limx - minx - 30) + minx + 30
 bonus.y = -10
 bonus.spdy = 3
 bonus.sz = 4

END IF

END SUB

SUB moveplayer

DIM buf AS sprite
SHARED player AS sprite
SHARED wing() AS INTEGER
SHARED picplay() AS INTEGER
SHARED piclw() AS INTEGER
SHARED picrw() AS INTEGER

IF player.nrg > 0 THEN

 buf.x = player.x
 buf.y = player.y

 player.x = player.x + player.spdx * gamespeed
 player.y = player.y + player.spdy * gamespeed

 IF player.x > limx - player.sz * 2 THEN
  player.x = limx - player.sz * 2
  player.spdx = 0
 ELSEIF player.x < minx + player.sz * 2 THEN
  player.x = minx + player.sz * 2
  player.spdx = 0
 ELSEIF player.y > limy - player.sz * 2 THEN
  player.y = limy - player.sz * 2
  player.spdy = 0
 ELSEIF player.y < limy / 2 + player.sz + 2 THEN
  player.y = limy / 2 + player.sz * 2
  player.spdy = 0
 END IF
       
 cleararea buf.x, buf.y, player.x, player.y, player.sz
 IF inside%(player.x, player.y, player.sz) THEN
  PUT (player.x - player.sz, player.y - player.sz), picplay, PSET
 END IF
 IF wing(1) = 1 THEN
  cleararea buf.x - player.sz * 2, buf.y, player.x, player.y, player.sz
  IF inside%(player.x - player.sz * 2, player.y, player.sz) THEN
   PUT (player.x - player.sz * 3, player.y - player.sz), piclw, PSET
  END IF
 END IF
 IF wing(2) = 1 THEN
  cleararea buf.x + player.sz * 2, buf.y, player.x, player.y, player.sz
  IF inside%(player.x + player.sz * 2, player.y, player.sz) THEN
   PUT (player.x + player.sz, player.y - player.sz), picrw, PSET
  END IF
 END IF

ELSE

 player.sz = 15
 player.x = limx / 2
 player.y = limy - player.sz * 2
 player.nrg = 30

END IF

END SUB

SUB moverocket

DIM buf AS sprite
SHARED player AS sprite
SHARED rocket() AS sprite
SHARED picrock() AS INTEGER

FOR nr = 1 TO rocketmax

 IF rocket(nr).nrg > 0 THEN
 
  buf.x = rocket(nr).x
  buf.y = rocket(nr).y
 
  rocket(nr).x = rocket(nr).x + rocket(nr).spdx * gamespeed
  rocket(nr).y = rocket(nr).y + rocket(nr).spdy * gamespeed
 
  cleararea buf.x, buf.y, rocket(nr).x, rocket(nr).y, rocket(nr).sz
  IF rocket(nr).y > limy + rocket(nr).sz OR rocket(nr).y < miny - rocket(nr).sz OR rocket(nr).x > limx + rocket(nr).sz OR rocket(nr).x < minx - rocket(nr).sz THEN
   rocket(nr).nrg = 0
  ELSEIF inside%(rocket(nr).x, rocket(nr).y, rocket(nr).sz) THEN
   PUT (rocket(nr).x - rocket(nr).sz, rocket(nr).y - rocket(nr).sz), picrock, PSET
  END IF

 ELSEIF rocket(nr).sz = 0 THEN
  rocket(nr).sz = 15
 
 END IF

NEXT

END SUB

SUB moveshield

DIM nr AS INTEGER
DIM buf AS sprite
SHARED shield() AS sprite
SHARED picshield() AS INTEGER
SHARED rocket() AS sprite
SHARED gamescore AS INTEGER

FOR nr = 1 TO 3

 IF shield(nr).nrg > 0 THEN

  buf.x = shield(nr).x
  buf.y = shield(nr).y

  IF shield(nr).y < INT(limy / 2) + shield(nr).sz * 2 THEN
   shield(nr).y = shield(nr).y + 1
  ELSEIF shield(nr).y > INT(limy / 2) + shield(nr).sz * 2 THEN
   shield(nr).y = shield(nr).y - 1
  END IF
  
  shield(nr).x = shield(nr).x + shield(nr).spdx * gamespeed
  shield(nr).y = shield(nr).y + shield(nr).spdy * gamespeed

  IF shield(nr).x <= minx OR shield(nr).x >= limx THEN
   shield(nr).spdx = shield(nr).spdx * -1
  END IF

  IF shield(nr).y < limy / 3 AND shield(nr).spdy < 0 THEN
   shield(nr).spdy = shield(nr).spdy * -1
  ELSEIF shield(nr).y > limy - (limy / 4) AND shield(nr).spdy > 0 THEN
   shield(nr).spdy = shield(nr).spdy * -1
  ELSEIF shield(nr).y <= miny THEN
   shield(nr).y = miny
  END IF

  lnr = hitro%(shield(nr).x, shield(nr).y, shield(nr).sz)
  IF lnr > 0 THEN
  
   shield(nr).y = shield(nr).y + (shield(nr).sz / 2) * rocket(lnr).spdy
   shield(nr).nrg = shield(nr).nrg - 1
   rocket(lnr).spdy = rocket(lnr).spdy * -1
   rocket(lnr).spdx = shield(nr).spdx
   IF shield(nr).nrg > 0 THEN
    gamescore = gamescore + 5
    soundfx 0
   ELSE
    gamescore = gamescore + 100
    explode shield(nr).x, shield(nr).y, 6
   END IF
 
  END IF
 
  cleararea buf.x, buf.y, shield(nr).x, shield(nr).y, shield(nr).sz
  IF shield(nr).nrg > 0 THEN
   IF inside%(shield(nr).x, shield(nr).y, shield(nr).sz) THEN
    IF RND * 50 > 5 THEN
     PUT (shield(nr).x - shield(nr).sz, shield(nr).y - shield(nr).sz), picshield, PSET
    ELSE
     PUT (shield(nr).x - shield(nr).sz, shield(nr).y - shield(nr).sz), picshield, PRESET
    END IF
   END IF
  END IF

 ELSEIF RND * 3000 < 5 THEN
  
  shield(nr).nrg = 30
  shield(nr).sz = 15
  shield(nr).x = limx - (shield(nr).sz * 9) * nr
  shield(nr).y = -shield(nr).sz * 2' INT(limy / 2) + shield(nr).sz * 2
  shield(nr).spdx = -3
  shield(nr).spdy = nr

 END IF

NEXT

END SUB

SUB moveships

DIM nr AS INTEGER
DIM lnr AS INTEGER
DIM buf AS sprite
STATIC barrel AS INTEGER
SHARED ship() AS sprite
SHARED picship() AS INTEGER
SHARED rocket() AS sprite
SHARED gamescore AS INTEGER
SHARED player AS sprite

FOR nr = 1 TO 4
 
 IF ship(nr).nrg > 0 THEN

  IF ship(nr).y < limy + ship(nr).sz * 4 THEN
 
   buf.x = ship(nr).x
   buf.y = ship(nr).y
 
   ship(nr).x = ship(nr).x + ship(nr).spdx * gamespeed
   ship(nr).y = ship(nr).y + ship(nr).spdy * gamespeed
 
   IF ship(nr).x > limx - ship(nr).sz OR ship(nr).x < minx + ship(nr).sz THEN
    ship(nr).spdx = ship(nr).spdx * -1
    ship(nr).y = ship(nr).y + ship(nr).sz * 2
  
   ELSEIF ship(nr).y - ship(nr).sz > limy THEN
    ship(nr).nrg = 0

   ELSEIF ship(nr).spdy = 0 THEN
  
    lnr = hitro%(ship(nr).x, ship(nr).y, ship(nr).sz)
    IF lnr > 0 THEN
     explode ship(nr).x, ship(nr).y, 3
     ship(nr).spdy = 4
     rocket(lnr).spdx = rocket(lnr).spdx * -1
     rocket(lnr).spdy = rocket(lnr).spdy * -1
     gamescore = gamescore + 50
    END IF
  
   END IF

   IF hitpl%(ship(nr).x, ship(nr).y, ship(nr).sz) THEN
    soundfx 3
    gamescore = gamescore + 200

    barrel = barrel + 1
    IF barrel = 9 THEN
     soundfx 4
     center "well done"
     END
    END IF
   
   ship(nr).y = limy + ship(nr).sz
   END IF
    
   END IF
  
   cleararea buf.x, buf.y, ship(nr).x, ship(nr).y, ship(nr).sz
   IF inside%(ship(nr).x, ship(nr).y, ship(nr).sz) THEN
    PUT (ship(nr).x - ship(nr).sz, ship(nr).y - ship(nr).sz), picship, PSET
   END IF

 ELSEIF RND * 1500 < 5 THEN

  ship(nr).nrg = 1
  ship(nr).sz = 15
  ship(nr).x = nr * ship(nr).sz * 2
  ship(nr).y = nr * 2 + (ship(nr).sz * 2)
  ship(nr).spdy = 0
  ship(nr).spdx = 3

 END IF

NEXT

END SUB

SUB moveshot

DIM buf AS sprite
DIM nr AS INTEGER
SHARED shot() AS sprite
SHARED player AS sprite
SHARED wing() AS INTEGER
SHARED picshot() AS INTEGER

FOR nr = 1 TO shotmax

 IF shot(nr).nrg > 0 THEN
  
  buf.x = shot(nr).x
  buf.y = shot(nr).y
 
  shot(nr).x = shot(nr).x + shot(nr).spdx * gamespeed
  shot(nr).y = shot(nr).y + shot(nr).spdy * gamespeed
 
  IF shot(nr).y > limy + shot(nr).sz THEN
   shot(nr).nrg = 0
   shot(nr).spdy = 0
  END IF

  IF hitpl%(shot(nr).x, shot(nr).y, shot(nr).sz) THEN
   explode shot(nr).x, shot(nr).y, 3
   player.nrg = player.nrg - 1
   shot(nr).nrg = 0
  
  ELSE
  
   cleararea buf.x, buf.y, shot(nr).x, shot(nr).y, shot(nr).sz
   IF inside%(shot(nr).x, shot(nr).y, shot(nr).sz) THEN
    PUT (shot(nr).x - shot(nr).sz, shot(nr).y - shot(nr).sz), picshot, PSET
   END IF
  
  END IF
 
 ELSEIF shot(nr).sz = 0 THEN
  shot(nr).sz = 7
  
 END IF

NEXT

END SUB

SUB movestars

DIM nr AS INTEGER
SHARED star() AS sprite

FOR nr = 1 TO 11

 IF star(nr).nrg > 0 THEN

  LINE (star(nr).x - star(nr).sz, star(nr).y - star(nr).sz)-(star(nr).x + star(nr).sz, star(nr).y + star(nr).sz), 0, BF
  
  star(nr).y = star(nr).y + star(nr).spdy * gamespeed

  IF star(nr).y > limy THEN
   star(nr).y = miny
   star(nr).x = INT(RND * limx)
  END IF

  LINE (star(nr).x - star(nr).sz, star(nr).y - star(nr).sz)-(star(nr).x + star(nr).sz, star(nr).y + star(nr).sz), 2, BF

 ELSE
 
  star(nr).sz = INT(nr / 3)
  star(nr).nrg = 1
  star(nr).x = INT(RND * limx - minx) + minx
  star(nr).y = INT(RND * limy - minx) + minx
  star(nr).spdy = INT(nr / 2)

 END IF

NEXT

END SUB

SUB shoot (xp AS INTEGER, yp AS INTEGER)

SHARED shot() AS sprite
DIM nr AS INTEGER

FOR nr = 1 TO shotmax
 IF shot(nr).nrg = 0 THEN
  soundfx 1
  shot(nr).x = xp
  shot(nr).y = yp
  shot(nr).spdy = 8
  shot(nr).nrg = 1
  EXIT FOR
 END IF
NEXT

END SUB

SUB showscore

STATIC counter AS INTEGER
SHARED gamescore AS INTEGER
SHARED player AS sprite

counter = counter + 1
IF counter = 10 THEN

 LOCATE 1, 1
 PRINT gamescore
 LOCATE 1, 74
 counter = 0

END IF

IF player.nrg <= 0 THEN
 DIM nr AS INTEGER
 FOR nr = -63 TO 63 STEP 3
  PALETTE 0, 63 - ABS(nr)
 NEXT
 center "game over"
 END
END IF

END SUB

SUB soundfx (freq AS INTEGER)

DIM nr AS INTEGER

FOR nr = -freq * 100 TO freq * 100 STEP 100
 SOUND 1000 - ABS(nr), .03
NEXT

END SUB

