' ***************************************************************************
'                                JETFIGHTER 
                                  
'                          A Program By:

'                               Tyler  Tigue 

'                     Special Thanks To:

'                                Ryan Weltz 

'                                Greg Morse 
   
'                                Version: 4.3 (Internet Version)
              
'       This game is basically a shoot 'em up game.  You are in a Jet Fighter
' (Thus the Name!).  Your object is to shoot the other guy and get as many
' kills as possible.  There are powerups flying around to help you out in
' in destroying the other guy. Try not to shoot yourself!

' You can change these numbers if you want, although I wouldn't recommend it.
' The numbers in parenteses are the best possible configurations.

CONST SIZE = 10             'Size of the fighters (10)
CONST MAXSPEED = 10         'Maximum speed of the fighters (10)
CONST SPEED = .8            'How much faster the fighters accelerate (.8)
CONST TURN = 24             'How far of an angle the fighters turn (24)
CONST MAXLIFEFIRE = 75      'How long the lasers last (75)
CONST INITMAXFIRE = 5       'Initial number of how many lasers are active (5)
CONST FMAXFIRE = 25         'Maximum amount of guns a jet can get (25)
CONST NUMPOWERUPS = 5       'How many powerups are active as one time (5)
CONST MAXPOWLIFE = 250      'Maximum life of a powerup (250)
CONST INITDAMAGE = 10       'Initial damage lasers cause (10)
CONST INITLIVES = 5         'Initial amounts of lives for each jet (5)
CONST INITSMARTMIS = 5      'Initial amount of smart missles (5)
CONST INITMINES = 5         'Initial amount of mines (5)

' Not one REM statement after this!
' ***************************************************************************

DECLARE SUB killship (cship)
DECLARE SUB prnmsg (nmsg$, msgclr)
DECLARE SUB explode (xsize, x, y, clr)
DECLARE SUB clrscrn ()
DECLARE SUB introscreen ()
DECLARE SUB intro ()
DECLARE SUB menu ()
DECLARE SUB ext ()

TYPE ship
 x AS SINGLE
 y AS SINGLE

 xdir AS SINGLE
 ydir AS SINGLE

 spd AS SINGLE
 angle AS INTEGER

 oclr AS INTEGER
 iclr AS INTEGER

 health AS INTEGER
 damage AS INTEGER
 armor AS SINGLE

 maxfire AS INTEGER

 smissles AS INTEGER
 mine AS INTEGER

 lives AS INTEGER
 computer AS INTEGER

 power AS INTEGER
 plife AS INTEGER

 info AS INTEGER
END TYPE

TYPE spters

 lx1 AS INTEGER
 ly1 AS INTEGER
 lx2 AS INTEGER
 ly2 AS INTEGER
 lx3 AS INTEGER
 ly3 AS INTEGER

END TYPE

TYPE shoot

 sxdir AS SINGLE
 sydir AS SINGLE

 sx1  AS INTEGER
 sy1  AS INTEGER
 sx2  AS INTEGER
 sy2  AS INTEGER

 life AS INTEGER
 typ AS INTEGER
  angle AS INTEGER
  push AS SINGLE
END TYPE

TYPE powerup
 x AS INTEGER
 y AS INTEGER

 pxdir AS SINGLE
 pydir AS SINGLE

 power AS INTEGER
 life AS INTEGER
 clr AS INTEGER
END TYPE

TYPE explosion
 x AS SINGLE
 y AS SINGLE

 xdir AS SINGLE
 ydir AS SINGLE
 spd AS INTEGER
 life AS INTEGER
END TYPE

TYPE dec
 x AS INTEGER
 y AS INTEGER
 rad AS INTEGER
END TYPE

DIM SHARED powerups(NUMPOWERUPS) AS powerup
DIM SHARED ships(2) AS ship
DIM SHARED shpsers(2) AS spters
DIM SHARED fire(2, FMAXFIRE) AS shoot
DIM SHARED xplode(50) AS explosion
DIM SHARED decoy(2) AS dec
DIM SHARED coslook(360), sinlook(360)
DIM SHARED nam$(2)
DIM SHARED ers, snd, msg$, msglife
DIM SHARED crngame, nwgm

 tx1 = SIZE
 ty1 = 0
 tx2 = -SIZE
 ty2 = SIZE
 tx3 = -SIZE
 ty3 = -SIZE

FOR angle = 0 TO 360
 rad = angle * 3.1416 / 180
 coslook(angle) = COS(rad)
 sinlook(angle) = SIN(rad)
NEXT angle

 SCREEN 12
 RANDOMIZE TIMER

 intro

 nam$(1) = "Jet Fighter 1"
 ships(1).iclr = 10
 ships(1).oclr = 4

 nam$(2) = "Jet Fighter 2"
 ships(2).iclr = 14
 ships(2).oclr = 1

 crngame = 0
 menu

newgame:

 ships(1).angle = 180
 ships(1).spd = 0
 ships(1).x = 320 - SIZE * 2
 ships(1).y = 240
 ships(1).health = 100
 ships(1).armor = 0
 ships(1).lives = INITLIVES
 ships(1).damage = INITDAMAGE
 ships(1).maxfire = INITMAXFIRE
 ships(1).smissles = INITSMARTMIS
 ships(1).mine = INITMINES
 ships(1).info = 1
 ships(1).power = 0

 ships(2).angle = 0
 ships(2).spd = 0
 ships(2).x = 320 + SIZE * 2
 ships(2).y = 240
 ships(2).health = 100
 ships(2).armor = 0
 ships(2).lives = INITLIVES
 ships(2).damage = INITDAMAGE
 ships(2).maxfire = INITMAXFIRE
 ships(2).smissles = INITSMARTMIS
 ships(2).mine = INITMINES
 ships(2).info = 1
 ships(2).power = 0

 FOR cpow = 1 TO NUMPOWERUPS
  powerups(cpow).life = 0
 NEXT cpow

 FOR cfir = 1 TO FMAXFIRE
  FOR jf = 1 TO 2
   fire(jf, cfir).life = 0
  NEXT jf
 NEXT cfir

 msg$ = ""

clrscrn
crngame = 1

DO
FOR shp = 1 TO 2
act$ = INKEY$
IF shp = 1 THEN kshp = 2 ELSE kshp = 1
IF ers = 0 THEN

LINE (shpsers(shp).lx1, shpsers(shp).ly1)-(shpsers(shp).lx2, shpsers(shp).ly2), 0
LINE (shpsers(shp).lx3, shpsers(shp).ly3)-(shpsers(shp).lx1, shpsers(shp).ly1), 0
LINE (shpsers(shp).lx2, shpsers(shp).ly2)-((((shpsers(shp).lx2 + shpsers(shp).lx3) / 2) + ships(shp).x) / 2, (((shpsers(shp).ly2 + shpsers(shp).ly3) / 2) + ships(shp).y) / 2), 0
LINE (shpsers(shp).lx3, shpsers(shp).ly3)-((((shpsers(shp).lx2 + shpsers(shp).lx3) / 2) + ships(shp).x) / 2, (((shpsers(shp).ly2 + shpsers(shp).ly3) / 2) + ships(shp).y) / 2), 0
PAINT (ships(shp).x, ships(shp).y), 0, 0
LINE (shpsers(shp).lx1, shpsers(shp).ly1)-((((shpsers(shp).lx2 + shpsers(shp).lx3) / 2) + ships(shp).x) / 2, (((shpsers(shp).ly2 + shpsers(shp).ly3) / 2) + ships(shp).y) / 2), 0
IF ships(shp).power = 1 THEN
CIRCLE (ships(shp).x, ships(shp).y), SIZE, 0
END IF
IF ships(shp).power = 14 THEN
 CIRCLE (decoy(shp).x, decoy(shp).y), decoy(shp).rad, 0
END IF

 FOR cfir = 1 TO ships(shp).maxfire
  IF fire(shp, cfir).life > 0 THEN
   IF fire(shp, cfir).typ = 1 THEN LINE (fire(shp, cfir).sx1, fire(shp, cfir).sy1)-(fire(shp, cfir).sx2, fire(shp, cfir).sy2), 0
   IF fire(shp, cfir).typ = 2 THEN CIRCLE (fire(shp, cfir).sx1, fire(shp, cfir).sy1), 2, 0
   IF fire(shp, cfir).typ = 3 THEN CIRCLE (fire(shp, cfir).sx1, fire(shp, cfir).sy1), 4, 0: PAINT (fire(shp, cfir).sx1, fire(shp, cfir).sy1), 0, 0
  END IF
 NEXT cfir

 FOR cpow = 1 TO NUMPOWERUPS
  IF powerups(cpow).life > 0 THEN
   CIRCLE (powerups(cpow).x, powerups(cpow).y), 5, 0
   PAINT (powerups(cpow).x, powerups(cpow).y), 0, 0
  END IF
 NEXT cpow

 IF msglife > 100 THEN CALL prnmsg("", 0)

END IF

IF msglife > 0 THEN msglife = msglife + 1

IF SQR((ships(shp).x - ships(kshp).x) ^ 2 + (ships(shp).y - ships(kshp).y) ^ 2) < SIZE * 2 THEN
   IF ships(shp).spd = 0 THEN
    ships(shp).spd = ships(kshp).spd
    ships(kshp).spd = ships(kshp).spd * -1
   ELSEIF ships(kshp).spd = 0 THEN
    ships(kshp).spd = ships(shp).spd
    ships(shp).spd = ships(shp).spd * -1
   ELSE
    ships(kshp).spd = ships(kshp).spd * -1
    ships(shp).spd = ships(shp).spd * -1
   END IF
   IF ships(shp).power <> 1 THEN
    tdmg = ABS(ships(kshp).spd * (INT(RND * 3) + 1))
    ships(shp).health = ships(shp).health - (tdmg - tdmg * ships(shp).armor)
    ships(shp).armor = ships(shp).armor - (tdmg - tdmg * ships(shp).armor) / 100
   END IF
   IF ships(kshp).power <> 1 THEN
    tdmg = ABS(ships(shp).spd * (INT(RND * 3) + 1))
    ships(kshp).health = ships(kshp).health - (tdmg - tdmg * ships(kshp).armor)
    ships(kshp).armor = ships(kshp).armor - (tdmg - tdmg * ships(kshp).armor) / 100
   END IF
   FOR cshp = 1 TO 2
    IF ships(cshp).armor < 0 THEN ships(cshp).armor = 0
    IF ships(cshp).health < 0 THEN killship (cshp)
   NEXT cshp

   IF snd = 0 THEN SOUND 150, 1
   IF ers = 0 THEN clrscrn
END IF

ships(shp).xdir = coslook(ships(shp).angle) * ships(shp).spd
ships(shp).ydir = sinlook(ships(shp).angle) * ships(shp).spd
 
ships(shp).x = ships(shp).x + ships(shp).xdir
ships(shp).y = ships(shp).y + ships(shp).ydir

IF (ships(shp).x + SIZE) > 630 THEN ships(shp).x = ships(shp).x - 600
IF (ships(shp).x + SIZE) < 20 THEN ships(shp).x = ships(shp).x + 600
IF (ships(shp).y + SIZE) > 460 THEN ships(shp).y = ships(shp).y - 400
IF (ships(shp).y + SIZE) < 50 THEN ships(shp).y = ships(shp).y + 400

shpsers(shp).lx1 = (tx1 * coslook(ships(shp).angle) - ty1 * sinlook(ships(shp).angle)) + ships(shp).x
shpsers(shp).ly1 = (tx1 * sinlook(ships(shp).angle) + ty1 * coslook(ships(shp).angle)) + ships(shp).y
shpsers(shp).lx2 = (tx2 * coslook(ships(shp).angle) - ty2 * sinlook(ships(shp).angle)) + ships(shp).x
shpsers(shp).ly2 = (tx2 * sinlook(ships(shp).angle) + ty2 * coslook(ships(shp).angle)) + ships(shp).y
shpsers(shp).lx3 = (tx3 * coslook(ships(shp).angle) - ty3 * sinlook(ships(shp).angle)) + ships(shp).x
shpsers(shp).ly3 = (tx3 * sinlook(ships(shp).angle) + ty3 * coslook(ships(shp).angle)) + ships(shp).y

LINE (shpsers(shp).lx1, shpsers(shp).ly1)-(shpsers(shp).lx2, shpsers(shp).ly2), ships(shp).oclr
LINE (shpsers(shp).lx3, shpsers(shp).ly3)-(shpsers(shp).lx1, shpsers(shp).ly1), ships(shp).oclr
LINE (shpsers(shp).lx2, shpsers(shp).ly2)-((((shpsers(shp).lx2 + shpsers(shp).lx3) / 2) + ships(shp).x) / 2, (((shpsers(shp).ly2 + shpsers(shp).ly3) / 2) + ships(shp).y) / 2), ships(shp).oclr
LINE (shpsers(shp).lx3, shpsers(shp).ly3)-((((shpsers(shp).lx2 + shpsers(shp).lx3) / 2) + ships(shp).x) / 2, (((shpsers(shp).ly2 + shpsers(shp).ly3) / 2) + ships(shp).y) / 2), ships(shp).oclr
IF ships(shp).power = 8 THEN cclr = INT(RND * 15) + 1 ELSE cclr = ships(shp).iclr
PAINT (ships(shp).x, ships(shp).y), cclr, ships(shp).oclr
LINE (shpsers(shp).lx1, shpsers(shp).ly1)-((((shpsers(shp).lx2 + shpsers(shp).lx3) / 2) + ships(shp).x) / 2, (((shpsers(shp).ly2 + shpsers(shp).ly3) / 2) + ships(shp).y) / 2), ships(shp).oclr
IF ships(shp).plife > 0 THEN
ships(shp).plife = ships(shp).plife + 1
 IF ships(shp).plife > MAXPOWLIFE THEN
  ships(shp).power = 0
  ships(shp).plife = 0
 END IF
END IF
IF ships(shp).power = 1 THEN CIRCLE (ships(shp).x, ships(shp).y), SIZE, INT(RND * 15) + 1
IF ships(shp).power = 14 THEN
 decoy(shp).rad = decoy(shp).rad + 1
 IF decoy(shp).rad > SIZE THEN decoy(shp).rad = 1
 CIRCLE (decoy(shp).x, decoy(shp).y), decoy(shp).rad, ships(shp).iclr
END IF

FOR cfir = 1 TO ships(shp).maxfire
 IF fire(shp, cfir).life > 0 THEN

 fire(shp, cfir).life = fire(shp, cfir).life + 1
 IF fire(shp, cfir).life > MAXLIFEFIRE THEN fire(shp, cfir).life = 0

 IF fire(shp, cfir).typ = 1 THEN
  xspd = 5
  yspd = 5
 END IF
 IF fire(shp, cfir).typ = 2 THEN
  IF ships(kshp).power = 14 THEN
   cx = decoy(kshp).x
   cy = decoy(kshp).y
  ELSE
   cx = ships(kshp).x
   cy = ships(kshp).y
  END IF
  xdis = fire(shp, cfir).sx1 - cx
  ydis = fire(shp, cfir).sy1 - cy
  IF fire(shp, cfir).push > 0 THEN fire(shp, cfir).push = fire(shp, cfir).push - .1
  xpush = fire(shp, cfir).push * coslook(fire(shp, cfir).angle)
  ypush = fire(shp, cfir).push * sinlook(fire(shp, cfir).angle)
  IF xdis < -320 THEN fire(shp, cfir).sxdir = -1 + xpush
  IF xdis > -320 AND xdis < 0 THEN fire(shp, cfir).sxdir = 1 + xpush
  IF xdis > 320 THEN fire(shp, cfir).sxdir = 1 + xpush
  IF xdis < 320 AND xdis > 0 THEN fire(shp, cfir).sxdir = -1 + xpush
  IF ydis < -205 THEN fire(shp, cfir).sydir = -1 + ypush
  IF ydis > -205 AND ydis < 0 THEN fire(shp, cfir).sydir = 1 + ypush
  IF ydis > 205 THEN fire(shp, cfir).sydir = 1 + ypush
  IF ydis < 205 AND ydis > 0 THEN fire(shp, cfir).sydir = -1 + ypush
  IF ABS(xdis) = 2 THEN
   xspd = 0
   yspd = MAXSPEED - 1
  ELSEIF ABS(ydis) = 2 THEN
   yspd = 0
   xspd = MAXSPEED - 1
  ELSE
   xspd = MAXSPEED - 1
   yspd = MAXSPEED - 1
  END IF
 END IF
 IF fire(shp, cfir).typ = 3 THEN
  xspd = 0
  yspd = 0
 END IF
  fire(shp, cfir).sx1 = fire(shp, cfir).sx1 + fire(shp, cfir).sxdir * xspd
  fire(shp, cfir).sx2 = fire(shp, cfir).sx2 + fire(shp, cfir).sxdir * xspd
  fire(shp, cfir).sy1 = fire(shp, cfir).sy1 + fire(shp, cfir).sydir * yspd
  fire(shp, cfir).sy2 = fire(shp, cfir).sy2 + fire(shp, cfir).sydir * yspd

  IF fire(shp, cfir).sx2 > 620 THEN
   fire(shp, cfir).sx1 = fire(shp, cfir).sx1 - 600
   fire(shp, cfir).sx2 = fire(shp, cfir).sx2 - 600
  END IF
  IF fire(shp, cfir).sx2 < 20 THEN
   fire(shp, cfir).sx1 = fire(shp, cfir).sx1 + 600
   fire(shp, cfir).sx2 = fire(shp, cfir).sx2 + 600
  END IF
  IF fire(shp, cfir).sy2 > 460 THEN
   fire(shp, cfir).sy1 = fire(shp, cfir).sy1 - 400
   fire(shp, cfir).sy2 = fire(shp, cfir).sy2 - 400
  END IF
  IF fire(shp, cfir).sy2 < 50 THEN
   fire(shp, cfir).sy1 = fire(shp, cfir).sy1 + 400
   fire(shp, cfir).sy2 = fire(shp, cfir).sy2 + 400
  END IF

FOR fshp = 1 TO 2

IF fire(shp, cfir).typ = 1 THEN
 fsiz = 0
ELSEIF fire(shp, cfir).typ = 2 THEN
 fsiz = 2
ELSE
 fsiz = 4
END IF

IF SQR((fire(shp, cfir).sx2 - ships(fshp).x) ^ 2 + (fire(shp, cfir).sy2 - ships(fshp).y) ^ 2) <= SIZE + fsiz THEN

 fire(shp, cfir).life = 0
 IF ships(shp).power = 11 THEN GOTO override
 IF ships(fshp).power <> 1 THEN

override:
 IF fshp = 1 THEN kshp = 2 ELSE kshp = 1
 IF fire(shp, cfir).typ = 1 THEN
  dmg = ships(kshp).damage
 ELSEIF fire(shp, cfir).typ = 2 THEN
  IF ships(shp).power = 11 THEN killship (fshp)
  CALL explode(2, (fire(shp, cfir).sx1), (fire(shp, cfir).sy1), (ships(shp).oclr))
  dmg = 20
 ELSE
  CALL explode(3, (fire(shp, cfir).sx1), (fire(shp, cfir).sy1), (ships(shp).oclr))
  dmg = 30
 END IF
 ships(fshp).health = ships(fshp).health - (dmg - (dmg * ships(fshp).armor))
 ships(fshp).armor = ships(fshp).armor - (dmg - (dmg * ships(fshp).armor)) / 100

 IF ships(fshp).armor < 0 THEN ships(fshp).armor = 0

 IF ships(fshp).health <= 0 THEN
  killship (fshp)
 ELSE
  CALL prnmsg(nam$(fshp) + " was HIT!", 15)
  msglife = 1
  IF snd = 0 THEN SOUND 100, 1
 END IF
  IF ers = 0 THEN clrscrn
 END IF
END IF
NEXT fshp

END IF

NEXT cfir

FOR cfir = 1 TO ships(shp).maxfire
IF fire(shp, cfir).life > 0 THEN
IF fire(shp, cfir).typ = 1 THEN LINE (fire(shp, cfir).sx1, fire(shp, cfir).sy1)-(fire(shp, cfir).sx2, fire(shp, cfir).sy2), ships(shp).iclr
IF fire(shp, cfir).typ = 2 THEN CIRCLE (fire(shp, cfir).sx1, fire(shp, cfir).sy1), 2, ships(shp).oclr
IF fire(shp, cfir).typ = 3 THEN CIRCLE (fire(shp, cfir).sx1, fire(shp, cfir).sy1), 4, ships(shp).oclr: PAINT (fire(shp, cfir).sx1, fire(shp, cfir).sy1), ships(shp).iclr, ships(shp).oclr
END IF
NEXT cfir

FOR cpow = 1 TO NUMPOWERUPS
IF powerups(cpow).life > 0 THEN
 powerups(cpow).life = powerups(cpow).life + 1
 IF powerups(cpow).life > MAXPOWLIFE THEN powerups(cpow).life = 0

 powerups(cpow).x = powerups(cpow).x + powerups(cpow).pxdir
 powerups(cpow).y = powerups(cpow).y + powerups(cpow).pydir
 
 IF powerups(cpow).x > 620 THEN powerups(cpow).x = powerups(cpow).x - 600
 IF powerups(cpow).x < 20 THEN powerups(cpow).x = powerups(cpow).x + 600
 IF powerups(cpow).y > 460 THEN powerups(cpow).y = powerups(cpow).y - 400
 IF powerups(cpow).y < 50 THEN powerups(cpow).y = powerups(cpow).y + 400

 FOR fshp = 1 TO 2
  IF SQR((powerups(cpow).x - ships(fshp).x) ^ 2 + (powerups(cpow).y - ships(fshp).y) ^ 2) < SIZE + 5 THEN
   powerups(cpow).life = 0
   powr = powerups(cpow).power
   IF powr = 1 THEN pwr$ = "the force field!"
   IF powr = 2 THEN pwr$ = "stronger blasters!"
   IF powr = 3 THEN pwr$ = "a health bonus!"
   IF powr = 4 THEN pwr$ = "the floating mine!"
   IF powr = 5 THEN pwr$ = "an armor bonus!"
   IF powr = 6 THEN pwr$ = "75% armor!"
   IF powr = 7 THEN
   IF ships(fshp).maxfire + 1 <= FMAXFIRE THEN
     pwr$ = "another gun!"
   ELSE
     nmsg$ = "You can not get any more guns!"
     msglife = 1
     CALL prnmsg(nmsg$, 15)
     GOTO nopower
    END IF
   END IF
   IF powr = 8 THEN pwr$ = "disorientation!"
   IF powr = 9 THEN pwr$ = "a smart missle!"
   IF powr = 10 THEN pwr$ = "a missle pack!"
   IF powr = 11 THEN pwr$ = "the death missle upgrade!"
   IF powr = 12 THEN pwr$ = "a mine!"
   IF powr = 13 THEN pwr$ = "a mine pack!"
   IF powr = 14 THEN pwr$ = "the decoy!"

   IF powr = 2 THEN ships(fshp).damage = ships(fshp).damage + INT(RND * 3) + 1
   IF powr = 3 THEN ships(fshp).health = ships(fshp).health + INT(RND * 10) + 1
   IF powr = 4 THEN killship (fshp)
   IF powr = 5 THEN ships(fshp).armor = ships(fshp).armor + ((INT(RND * 10) + 1) / 100)
   IF powr = 6 THEN ships(fshp).armor = .75
   IF powr = 7 THEN ships(fshp).maxfire = ships(fshp).maxfire + 1
   IF powr = 9 THEN ships(fshp).smissles = ships(fshp).smissles + 1
   IF powr = 10 THEN ships(fshp).smissles = ships(fshp).smissles + 5
   IF powr = 12 THEN ships(fshp).mine = ships(fshp).mine + 1
   IF powr = 13 THEN ships(fshp).mine = ships(fshp).mine + 5
   IF powr = 14 THEN
     decoy(fshp).x = ships(fshp).x
     decoy(fshp).y = ships(fshp).y
     decoy(fshp).rad = 1
   END IF

   ships(fshp).power = powr
   ships(fshp).plife = 1
   msglife = 1
   nmsg$ = nam$(fshp) + " got " + pwr$
   CALL prnmsg(nmsg$, 15)
nopower:
   IF ers = 0 THEN clrscrn
   IF snd = 0 THEN
    SOUND 500, 1
    SOUND 1000, 1
    SOUND 1500, 1
   END IF
  END IF
 NEXT fshp

ELSE
 IF INT(RND * 100) + 1 = 1 THEN
  powerups(cpow).life = 1
  powerups(cpow).power = INT(RND * 45) + 1
  IF powerups(cpow).power >= 1 AND powerups(cpow).power <= 5 THEN powerups(cpow).power = 1: powerups(cpow).clr = 14
  IF powerups(cpow).power >= 6 AND powerups(cpow).power <= 10 THEN powerups(cpow).power = 2: powerups(cpow).clr = 2
  IF powerups(cpow).power >= 11 AND powerups(cpow).power <= 15 THEN powerups(cpow).power = 3: powerups(cpow).clr = 4
  IF powerups(cpow).power = 22 THEN powerups(cpow).power = 4: powerups(cpow).clr = 8
  IF powerups(cpow).power >= 17 AND powerups(cpow).power <= 21 THEN powerups(cpow).power = 5: powerups(cpow).clr = 9
  IF powerups(cpow).power = 16 THEN powerups(cpow).power = 6: powerups(cpow).clr = 1
  IF powerups(cpow).power = 23 THEN powerups(cpow).power = 7: powerups(cpow).clr = 10
  IF powerups(cpow).power >= 24 AND powerups(cpow).power <= 28 THEN powerups(cpow).power = 8: powerups(cpow).clr = 7
  IF powerups(cpow).power >= 29 AND powerups(cpow).power <= 33 THEN powerups(cpow).power = 9: powerups(cpow).clr = 6
  IF powerups(cpow).power = 34 THEN powerups(cpow).power = 10: powerups(cpow).clr = 13
  IF powerups(cpow).power = 35 THEN powerups(cpow).power = 11: powerups(cpow).clr = 3
  IF powerups(cpow).power >= 36 AND powerups(cpow).power <= 40 THEN powerups(cpow).power = 12: powerups(cpow).clr = 12
  IF powerups(cpow).power = 41 THEN powerups(cpow).power = 13: powerups(cpow).clr = 5
  IF powerups(cpow).power >= 42 AND powerups(cpow).power <= 45 THEN powerups(cpow).power = 14: powerups(cpow).clr = 11
  ang = INT(RND * 360) + 1
  spd = RND * 3 + 1
  powerups(cpow).pxdir = coslook(ang) * spd
  powerups(cpow).pydir = sinlook(ang) * spd
  powerups(cpow).x = INT(RND * 600) + 20
  powerups(cpow).y = INT(RND * 360) + 20
 END IF
END IF
NEXT cpow

FOR cpow = 1 TO NUMPOWERUPS
IF powerups(cpow).life > 0 THEN
CIRCLE (powerups(cpow).x, powerups(cpow).y), 5, powerups(cpow).clr
PAINT (powerups(cpow).x, powerups(cpow).y), powerups(cpow).clr, powerups(cpow).clr
END IF
NEXT cpow

IF ships(shp).spd > 0 THEN ships(shp).spd = ships(shp).spd - .01
IF ships(shp).spd < 0 THEN ships(shp).spd = ships(shp).spd + .01

command = 0
 IF act$ = CHR$(0) + "K" THEN command = 1
 IF act$ = CHR$(0) + "M" THEN command = 2
 IF act$ = CHR$(0) + "H" THEN command = 3
 IF act$ = CHR$(0) + "P" THEN command = 4
 IF act$ = CHR$(0) + "O" THEN command = 5
 IF act$ = CHR$(0) + "S" THEN command = 6
 IF act$ = CHR$(0) + "Q" THEN command = 7

IF act$ = CHR$(0) + "G" THEN
 ships(1).info = ships(1).info + 1
 IF ships(1).info > 7 THEN ships(1).info = 1
 IF ers = 0 THEN clrscrn
END IF

IF ships(1).power = 8 THEN ctrn = INT(RND * (90) + 90) ELSE ctrn = TURN
IF command = 1 THEN ships(1).angle = ships(1).angle - ctrn
IF command = 2 THEN ships(1).angle = ships(1).angle + ctrn

IF ships(1).angle < 0 THEN ships(1).angle = ships(1).angle + 360
IF ships(1).angle > 360 THEN ships(1).angle = ships(1).angle - 360

IF ships(1).power = 8 THEN cspd = 100 ELSE cspd = SPEED
IF command = 3 THEN ships(1).spd = ships(1).spd + cspd
IF command = 4 THEN ships(1).spd = ships(1).spd - cspd
IF command >= 5 AND command <= 7 THEN
 
  cfir = 0
  DO
  cfir = cfir + 1
  IF cfir > ships(1).maxfire THEN GOTO nofire1
  LOOP UNTIL (fire(1, cfir).life = 0)

  IF command = 5 THEN fire(1, cfir).typ = 1
  IF command = 6 THEN
   IF ships(1).smissles = 0 THEN GOTO nofire1
   fire(1, cfir).typ = 2
   ships(1).smissles = ships(1).smissles - 1
   IF ers = 0 THEN clrscrn
  END IF
  IF command = 7 THEN
   IF ships(1).mine = 0 THEN GOTO nofire1
   fire(1, cfir).typ = 3
   ships(1).mine = ships(1).mine - 1
   IF ers = 0 THEN clrscrn
  END IF
 
  fire(1, cfir).angle = ships(1).angle
  fire(1, cfir).sxdir = coslook(ships(1).angle) * 3
  fire(1, cfir).sydir = sinlook(ships(1).angle) * 3
                                              
 IF fire(1, cfir).typ = 1 OR fire(1, cfir).typ = 2 THEN
  fire(1, cfir).sx1 = shpsers(1).lx1
  fire(1, cfir).sy1 = shpsers(1).ly1
  fire(1, cfir).sx2 = shpsers(1).lx1 + fire(1, cfir).sxdir * 5
  fire(1, cfir).sy2 = shpsers(1).ly1 + fire(1, cfir).sydir * 5
 ELSE
  IF ships(1).spd < 0 THEN offset = 8
  IF ships(1).spd > 0 THEN offset = -8
  IF ships(1).spd = 0 THEN offset = 8
  fire(1, cfir).sx1 = shpsers(1).lx1 + fire(1, cfir).sxdir * offset
  fire(1, cfir).sy1 = shpsers(1).ly1 + fire(1, cfir).sydir * offset
  fire(1, cfir).sx2 = fire(1, cfir).sx1
  fire(1, cfir).sy2 = fire(1, cfir).sy1
 END IF
  fire(1, cfir).life = 1
  fire(1, cfir).push = 3
  IF snd = 0 THEN SOUND 400, 1

END IF

nofire1:
command = 0

IF UCASE$(act$) = "S" THEN command = 8
IF UCASE$(act$) = "F" THEN command = 9
IF UCASE$(act$) = "E" THEN command = 10
IF UCASE$(act$) = "D" THEN command = 11
IF UCASE$(act$) = "R" THEN command = 12
IF UCASE$(act$) = "W" THEN command = 13
IF UCASE$(act$) = "A" THEN command = 14

IF UCASE$(act$) = "Q" THEN
 ships(2).info = ships(2).info + 1
 IF ships(2).info > 7 THEN ships(2).info = 1
 IF ers = 0 THEN clrscrn
END IF

IF ships(2).power = 8 THEN ctrn = INT(RND * (90) + 90) ELSE ctrn = TURN
IF command = 8 THEN ships(2).angle = ships(2).angle - ctrn
IF command = 9 THEN ships(2).angle = ships(2).angle + ctrn

IF ships(2).angle < 0 THEN ships(2).angle = ships(2).angle + 360
IF ships(2).angle > 360 THEN ships(2).angle = ships(2).angle - 360

IF ships(2).power = 8 THEN cspd = 100 ELSE cspd = SPEED
IF command = 10 THEN ships(2).spd = ships(2).spd + cspd
IF command = 11 THEN ships(2).spd = ships(2).spd - cspd
IF command >= 12 AND command <= 14 THEN
 
  cfir = 0
  DO
  cfir = cfir + 1
  IF cfir > ships(2).maxfire THEN GOTO nofire2
  LOOP UNTIL (fire(2, cfir).life = 0)

  IF command = 12 THEN fire(2, cfir).typ = 1
  IF command = 13 THEN
   IF ships(2).smissles = 0 THEN GOTO nofire2
   fire(2, cfir).typ = 2
   ships(2).smissles = ships(2).smissles - 1
   IF ers = 0 THEN clrscrn
  END IF
  IF command = 14 THEN
   IF ships(2).mine = 0 THEN GOTO nofire2
   fire(2, cfir).typ = 3
   ships(2).mine = ships(2).mine - 1
   IF ers = 0 THEN clrscrn
  END IF

  fire(2, cfir).angle = ships(2).angle
  fire(2, cfir).sxdir = coslook(ships(2).angle) * 3
  fire(2, cfir).sydir = sinlook(ships(2).angle) * 3
                                             
 IF fire(2, cfir).typ = 1 OR fire(2, cfir).typ = 2 THEN
  fire(2, cfir).sx1 = shpsers(2).lx1
  fire(2, cfir).sy1 = shpsers(2).ly1
  fire(2, cfir).sx2 = shpsers(2).lx1 + fire(2, cfir).sxdir * 5
  fire(2, cfir).sy2 = shpsers(2).ly1 + fire(2, cfir).sydir * 5
 ELSE
  IF ships(2).spd < 0 THEN offset = 8
  IF ships(2).spd > 0 THEN offset = -8
  IF ships(2).spd = 0 THEN offset = 8
  fire(2, cfir).sx1 = shpsers(2).lx1 + fire(2, cfir).sxdir * offset
  fire(2, cfir).sy1 = shpsers(2).ly1 + fire(2, cfir).sydir * offset
  fire(2, cfir).sx2 = fire(2, cfir).sx1
  fire(2, cfir).sy2 = fire(2, cfir).sy1
 END IF
  fire(2, cfir).life = 1
  fire(2, cfir).push = 3
  IF snd = 0 THEN SOUND 400, 1
END IF

nofire2:

IF (act$ = CHR$(0) + "=") AND ers = 0 THEN clrscrn
IF act$ = CHR$(0) + "<" THEN IF ers = 1 THEN ers = 0 ELSE ers = 1
IF act$ = CHR$(0) + ";" THEN IF snd = 1 THEN snd = 0 ELSE snd = 1
IF act$ = CHR$(0) + ">" THEN
 COLOR 15
 LOCATE 14, 38: PRINT "PAUSED!"
 DO: LOOP UNTIL INKEY$ <> ""
 clrscrn
END IF
IF act$ = CHR$(0) + "?" THEN
 CLS
 PRINT "Are you sure you want to leave?"
 DO: act$ = INKEY$: LOOP UNTIL act$ <> ""
 IF UCASE$(act$) = "Y" THEN ext ELSE clrscrn
END IF

IF act$ = CHR$(27) THEN
 menu
 IF nwgm = 1 THEN GOTO newgame
 clrscrn
END IF

IF ships(shp).spd < -MAXSPEED THEN ships(shp).spd = -MAXSPEED
IF ships(shp).spd > MAXSPEED THEN ships(shp).spd = MAXSPEED

NEXT shp

LOOP

SUB clrscrn
 CLS
 COLOR ships(1).iclr
 LOCATE 1, 1: PRINT USING "&"; nam$(1)
 LOCATE 2, 1
 SELECT CASE ships(1).info
  CASE 1: PRINT USING "Health        : %###"; ships(1).health
  CASE 2: PRINT USING "Armor         : %###"; ships(1).armor * 100
  CASE 3: PRINT USING "Laser Damage  :  ###"; ships(1).damage
  CASE 4: PRINT USING "Guns          :  ###"; ships(1).maxfire
  CASE 5: PRINT USING "Smart Missles :  ###"; ships(1).smissles
  CASE 6: PRINT USING "Mine          :  ###"; ships(1).mine
  CASE 7: PRINT USING "Lives         :  ###"; ships(1).lives
 END SELECT
 COLOR ships(2).iclr
 LOCATE 1, 60: PRINT USING "&"; nam$(2)
 LOCATE 2, 60
 SELECT CASE ships(2).info
  CASE 1: PRINT USING "Health        : %###"; ships(2).health
  CASE 2: PRINT USING "Armor         : %###"; ships(2).armor * 100
  CASE 3: PRINT USING "Laser Damage  :  ###"; ships(2).damage
  CASE 4: PRINT USING "Guns          :  ###"; ships(2).maxfire
  CASE 5: PRINT USING "Smart Missles :  ###"; ships(2).smissles
  CASE 6: PRINT USING "Mines         :  ###"; ships(2).mine
  CASE 7: PRINT USING "Lives         :  ###"; ships(2).lives
 END SELECT
 COLOR 15
 IF msglife > 0 THEN CALL prnmsg(msg$, 15)

END SUB

SUB explode (xsize, x, y, clr)
FOR cxplode = 1 TO 50
 angle = INT(RND * 360) + 1
 xplode(cxplode).x = 0
 xplode(cxplode).y = 0
 xplode(cxplode).xdir = coslook(angle)
 xplode(cxplode).ydir = sinlook(angle)
 xplode(cxplode).spd = INT(RND * 3) + 1
 xplode(cxplode).life = 1
NEXT cxplode

s = 100
FOR xlif = 1 TO xsize
FOR cx = 1 TO 50
IF xplode(cx).life <> 0 THEN
IF ers = 0 THEN PSET (xplode(cx).x + x, xplode(cx).y + y), 0
 xplode(cx).x = xplode(cx).x + xplode(cx).xdir * xplode(cx).spd
 xplode(cx).y = xplode(cx).y + xplode(cx).ydir * xplode(cx).spd
 PSET (xplode(cx).x + x, xplode(cx).y + y), clr
 xplode(cx).life = INT(RND * 50)
END IF
NEXT cx
s = s - 1
IF snd = 0 THEN SOUND s, 1
NEXT xlif

END SUB

SUB ext
CLS
 IF ships(1).lives > ships(2).lives THEN
  winner = 1
 ELSEIF ships(1).lives = ships(2).lives THEN
  winner = 0
 ELSE
  winner = 2
 END IF
 IF winner > 0 THEN
  COLOR ships(winner).iclr
  PRINT nam$(winner); " WON!!"
  IF ships(winner).lives = 1 THEN kil$ = "life" ELSE kil$ = "lives"
  PRINT "With "; ships(winner).lives; kil$; "!!"
  PRINT "Excellent "; nam$(winner); "!!!"
 ELSE
  COLOR 15
  PRINT "It was a Tie!"
  PRINT "Good Match!"
 END IF
 DO: LOOP UNTIL INKEY$ <> ""

COLOR 15
PRINT "Thanks for Playing 'JETFIGHTER'(By: Tyler Tigue)"
PRINT
PRINT "All code and concept contrived by Tyler Tigue"
PRINT "Thanks to Ryan Weltz for 'idea' contributions!"
PRINT "Thanks to Greg Morse for the cosine and sine formula for moving!"
END
END SUB

SUB intro
introscreen
LOCATE 22, 35: PRINT "JETFIGHTER"
LOCATE 23, 32: PRINT "By: Tyler Tigue"

DO: LOOP UNTIL INKEY$ <> ""

 tx1 = 2
 ty1 = 0
 tx2 = -2
 ty2 = 2
 tx3 = -2
 ty3 = -2

 xp1 = 320
 yp1 = 240
 ang1 = 0

DO
LINE (rx11, ry11)-(rx12, ry12), 0
LINE (rx13, ry13)-(rx11, ry11), 0
LINE (rx12, ry12)-((((rx12 + rx13) / 2) + xp1) / 2, (((ry12 + ry13) / 2) + yp1) / 2), 0
LINE (rx13, ry13)-((((rx12 + rx13) / 2) + xp1) / 2, (((ry12 + ry13) / 2) + yp1) / 2), 0
PAINT (xp1, yp1), 0, 0
LINE (rx11, ry11)-((((rx12 + rx13) / 2) + xp1) / 2, (((ry12 + ry13) / 2) + yp1) / 2), 0

tx1 = tx1 + 1
tx2 = tx2 - 1
ty2 = ty2 + 1
tx3 = tx3 - 1
ty3 = ty3 - 1
ang1 = ang1 + 2

rx11 = (tx1 * coslook(ang1) - ty1 * sinlook(ang1)) + xp1
ry11 = (tx1 * sinlook(ang1) + ty1 * coslook(ang1)) + yp1
rx12 = (tx2 * coslook(ang1) - ty2 * sinlook(ang1)) + xp1
ry12 = (tx2 * sinlook(ang1) + ty2 * coslook(ang1)) + yp1
rx13 = (tx3 * coslook(ang1) - ty3 * sinlook(ang1)) + xp1
ry13 = (tx3 * sinlook(ang1) + ty3 * coslook(ang1)) + yp1

LINE (rx11, ry11)-(rx12, ry12), 2
LINE (rx13, ry13)-(rx11, ry11), 2
LINE (rx12, ry12)-((((rx12 + rx13) / 2) + xp1) / 2, (((ry12 + ry13) / 2) + yp1) / 2), 2
LINE (rx13, ry13)-((((rx12 + rx13) / 2) + xp1) / 2, (((ry12 + ry13) / 2) + yp1) / 2), 2
PAINT (xp1, yp1), 10, 2
LINE (rx11, ry11)-((((rx12 + rx13) / 2) + xp1) / 2, (((ry12 + ry13) / 2) + yp1) / 2), 2
act$ = INKEY$
IF act$ <> "" THEN EXIT SUB
LOOP UNTIL ang1 > 269

END SUB

SUB introscreen
CLS

LINE (110, 50)-(110, 250), 1
LINE (110, 250)-(80, 300), 1
LINE (80, 300)-(35, 250), 1

LINE (125, 50)-(125, 300), 4
LINE (125, 150)-(175, 150), 4

LINE (205, 50)-(205, 300), 14

LINE (230, 50)-(230, 300), 2
LINE (230, 150)-(265, 150), 2

LINE (280, 50)-(280, 300), 6

LINE (315, 50)-(355, 125), 10
LINE (315, 50)-(295, 125), 10
LINE (295, 125)-(295, 275), 10
LINE (295, 275)-(315, 300), 10
LINE (330, 300)-(355, 275), 10
LINE (355, 275)-(355, 225), 10
LINE (355, 225)-(325, 225), 10

LINE (375, 50)-(375, 300), 3
LINE (375, 150)-(425, 150), 3
LINE (425, 50)-(425, 300), 3

LINE (455, 50)-(455, 300), 12

LINE (485, 50)-(485, 300), 13
LINE (485, 150)-(535, 150), 13

LINE (550, 50)-(550, 300), 11
LINE (580, 50)-(600, 125), 11
LINE (600, 125)-(590, 150), 11
LINE (590, 150)-(550, 150), 11
LINE (590, 150)-(600, 200), 11
LINE (600, 200)-(600, 300), 11

LINE (30, 50)-(600, 50), 15
LINE (30, 300)-(600, 300), 15

END SUB

SUB killship (cshp)
  ships(cshp).lives = ships(cshp).lives - 1
 
  ldeath = 0
  IF ships(cshp).lives = 0 THEN
   ldeath = 1
   cclr = INT(RND * 15) + 1
   CALL explode(SIZE * 5, (ships(cshp).x), (ships(cshp).y), (ships(cshp).iclr))
  END IF

kldeath:

  IF ldeath > 0 THEN
   kx = INT(RND * 50) - 25 + ships(cshp).x
   ky = INT(RND * 50) - 25 + ships(cshp).y
   ldeath = ldeath + 1
   cclr = cclr + 1
   IF cclr > 15 THEN cclr = cclr - 15
  ELSE
   cclr = ships(cshp).iclr
   kx = ships(cshp).x
   ky = ships(cshp).y
  END IF
  CALL explode(SIZE * 5, kx, ky, cclr)
  IF ldeath > 0 AND ldeath < 5 THEN GOTO kldeath

 IF ships(cshp).lives > 0 THEN
  ships(cshp).health = 100
  ships(cshp).armor = 0
  ships(cshp).damage = INITDAMAGE
  ships(cshp).spd = 0
  ships(cshp).maxfire = INITMAXFIRE
  ships(cshp).power = 0
  ships(cshp).angle = INT(RND * (360 / TURN) + 1) * TURN
  ships(cshp).x = INT(RND * 600) + 20
  ships(cshp).y = INT(RND * 340) + 20
  CALL prnmsg(nam$(cshp) + " was Destroyed!", 15)
  msglife = 1
 ELSE
  CALL prnmsg(nam$(cshp) + " has no lives left!", 15)
  DO: LOOP UNTIL INKEY$ <> ""
  ext
 END IF
IF ers = 0 THEN clrscrn
END SUB

SUB menu
mnu:
introscreen
COLOR 15
LOCATE 22, 30
PRINT "1) Start New Game"
IF crngame = 0 THEN COLOR 7
LOCATE 23, 30
PRINT "2) Continue the Current Game"
LOCATE 24, 30
COLOR 15
PRINT "3) Change Names or Colors"
LOCATE 25, 30
PRINT "4) Intstructions"
LOCATE 26, 30
PRINT "5) Key Commands"
LOCATE 27, 30
PRINT "6) Exit"
DO
act$ = INKEY$
IF act$ = "1" THEN
 IF crngame = 1 THEN
  CLS
  PRINT "Are you sure you want to start a new game?"
  DO: act$ = INKEY$: LOOP UNTIL act$ <> ""
  IF UCASE$(act$) <> "Y" THEN GOTO mnu
 END IF
 nwgm = 1
 EXIT DO
END IF
                       
IF act$ = "2" AND crngame = 1 THEN
 nwgm = 0
 EXIT DO
END IF

IF act$ = "3" THEN
CLS

FOR clr = 1 TO 15
COLOR clr
PRINT clr; "  ";
NEXT clr
PRINT

FOR jf = 1 TO 2
 PRINT "Jet Fighter "; jf; ":"
 INPUT "Name: "; cnam$
 IF cnam$ <> "" THEN nam$(jf) = cnam$
geticlr:
 INPUT "Inside Color: "; iclr
 IF iclr < 1 OR iclr > 15 THEN GOTO geticlr ELSE ships(jf).iclr = iclr
getoclr:
 INPUT "Outside Color: "; oclr
 IF oclr < 1 OR oclr > 15 THEN GOTO getoclr ELSE ships(jf).oclr = oclr
NEXT jf

 PRINT "NAMES AND COLORS SET-"
FOR jf = 1 TO 2
 COLOR 15: PRINT nam$(jf)
 COLOR ships(jf).iclr: PRINT "Inside Color"
 COLOR ships(jf).oclr: PRINT "Outside Color"
NEXT jf

 DO: LOOP UNTIL INKEY$ <> ""
 GOTO mnu
END IF

IF act$ = "4" THEN
 CLS
 COLOR 15
 PRINT
 PRINT "It might seem complex at first, but the game is pretty basic.  You're"
 PRINT "objective is destroy the other guy. "
 PRINT "     Your Fighter is equipped with lasers, smart missles, and mines.  Lasers"
 PRINT "are unlimited and can be made stronger with the right powerups.  Smart"
 PRINT "missles are a great weapon that will follow the other guy, but your ship"
 PRINT "can run out of them.  Smart missles can be replenished with the right "
 PRINT "powerups.  Mines don't move, but when they are hit take down a"
 PRINT "considerable amount of damage.  These are limited too, but can also be "
 PRINT "replenished."
 PRINT "    The game is not all offense, there are defensive aspects of this game too."
 PRINT "Your ship can get armor, that will block some of the damage caused, the"
 PRINT "higher the percentage, the less damage.  There are powerups that can supply"
 PRINT "your ship with armor.  There are other powerups too, that give your ship"
 PRINT "an advantage over the other.  Play the game and find out what powerups do"
 PRINT "what."
 PRINT "    Have fun and try not to shoot yourself!"
 DO: LOOP UNTIL INKEY$ <> ""
 GOTO mnu
END IF

IF act$ = "5" THEN
 CLS
 COLOR 15
 PRINT "       "; nam$(1); STRING$(28, 32); nam$(2)
 PRINT
 PRINT "              [Home]         "
 PRINT "       [Del]  [End]  [PgDwn]"; STRING$(20, 32); "[Q] [W] [E] [R]"
 PRINT "               ["; CHR$(24); "]"; STRING$(30, 32); "[A] [S] [D] [F]"
 PRINT "           ["; CHR$(27); "] ["; CHR$(25); "] ["; CHR$(26); "]"
 PRINT
 PRINT
 PRINT "Up ............["; CHR$(24); "] "; STRING$(35, 46); "[E]"
 PRINT "Down ..........["; CHR$(25); "] "; STRING$(35, 46); "[D]"
 PRINT "Left ..........["; CHR$(27); "] "; STRING$(35, 46); "[S]"
 PRINT "Right .........["; CHR$(26); "] "; STRING$(35, 46); "[F]"
 PRINT "Toggle Stats ..[Home] ................................[Q]"
 PRINT "Smart Missle ..[Del] .................................[W]"
 PRINT "Laser .........[End] .................................[R]"
 PRINT "Mine ..........[PgDwn] ...............................[A]"
 PRINT
 PRINT "Back to Menu..........[Esc]"
 PRINT "Toggle Sound..........[F1]"
 PRINT "Toggle Erase..........[F2]"
 PRINT "Clear Screen..........[F3]"
 PRINT "Pause.................[F4]"
 PRINT "Exit Without Menu.....[F5]"
 PRINT
 PRINT "Press [Return] When Ready..."
 DO
 LOOP UNTIL INKEY$ = CHR$(13)
 GOTO mnu
END IF
IF act$ = "6" THEN ext
LOOP
END SUB

SUB prnmsg (nmsg$, msgclr)
  COLOR 0
  LOCATE 3, 40 - LEN(msg$) / 2
  PRINT msg$
  msglife = 1
  msg$ = nmsg$
  COLOR msgclr
  LOCATE 3, 40 - LEN(msg$) / 2
  PRINT msg$
END SUB

