DECLARE FUNCTION num$ (pint%)
SCREEN 13

DIM bl%(4096), charset%(32766), Level%(32766), dc%(80), paltab&(512), drawcur(500)
DIM Qs AS STRING * 80
Monochrome% = 0
border% = 10

chrfile$ = "ice.til"
levlfile$ = "ice.lev"
palfile$ = "nintendo.pal"
New% = 0
CONST LEVELXSIZE = 160
CONST LEVELYSIZE = 24

windowx% = 0: windowy% = 0: ypos% = 0
DEF SEG = VARSEG(charset%(0)): BLOAD chrfile$, VARPTR(charset%(0))
DEF SEG = VARSEG(paltab&(0)): BLOAD palfile$, 0: i% = 0
FOR clr% = 0 TO 255
    OUT &H3C8, clr%
    RED% = PEEK(i%)
    GREEN% = PEEK(i% + 1)
    BLUE% = PEEK(i% + 2)
  
    IF Monochrome% = 1 THEN
        average% = ((RED% * 1.5) + GREEN% + BLUE%) / 3
        IF average% > 63 THEN average% = 63
      
        RED% = average%
        GREEN% = average%
        BLUE% = average%
    END IF
  
    OUT &H3C9, RED%
    OUT &H3C9, GREEN%
    OUT &H3C9, BLUE%
    i% = i% + 3
NEXT

GOSUB asm

LINE (0, 0)-(15, 15), 15, B
GET (0, 0)-(15, 15), drawcur

LINE (0, 128)-(319, 135), border%, BF
LINE (256, 136)-(319, 199), border%, BF

IF New% = 0 THEN GOSUB loadlevel

cx% = 0: cy% = 0: ccx% = 0: ccy% = 0
ypos% = 0: char% = 0: auto% = 0

GOSUB getccxypos

DEF SEG = VARSEG(bl%(0))
CALL ABSOLUTE(&H2F0)
CALL ABSOLUTE(&H270)
DEF SEG

PUT (ccx%, ccy%), drawcur
PUT (cx%, cy%), drawcur

rotate% = 0

DO WHILE a$ <> CHR$(27)
    a$ = INKEY$
    IF a$ <> "" THEN GOSUB keytest
LOOP
END

keytest:
IF valueflag% = 1 THEN GOSUB erasevalue
PUT (cx%, cy%), drawcur
IF a$ = CHR$(0) + "H" THEN cy% = cy% - 16: IF cy% < 0 THEN GOSUB scrollup
IF a$ = CHR$(0) + "M" THEN cx% = cx% + 16: IF cx% > 304 THEN GOSUB scrollright
IF a$ = CHR$(0) + "P" THEN cy% = cy% + 16: IF cy% > 112 THEN GOSUB scrolldown
IF a$ = CHR$(0) + "K" THEN cx% = cx% - 16: IF cx% < 0 THEN GOSUB scrollleft
IF a$ = "a" THEN GOSUB toggleauto
IF auto% = 1 THEN GOSUB drawchar
IF a$ = "b" THEN GOSUB drawchar
IF a$ = "0" THEN GOSUB erasechar
IF a$ = "c" THEN rotate% = rotate% XOR 1
IF a$ = "+" THEN inc% = 1: GOSUB charcontrol
IF a$ = "-" THEN inc% = -1: GOSUB charcontrol
IF a$ = "s" THEN GOSUB savelevel
IF a$ = "l" THEN GOSUB loadlevel
IF a$ = "v" THEN GOSUB value

IF a$ = "/" THEN
    DEF SEG = VARSEG(Level%(0))
    nc% = PEEK(((cy% / 16) + windowy%) * LEVELXSIZE + ((cx% / 16) + windowx%))
    inc% = nc% - char%
    GOSUB charcontrol
END IF

DEF SEG = VARSEG(bl%(0)): CALL ABSOLUTE(&H2F0): DEF SEG
PUT (cx%, cy%), drawcur
RETURN

scrollup:
cy% = 0
windowy% = windowy% - 1
 IF windowy% < 0 THEN windowy% = 0
RETURN

scrollright:
cx% = 304
windowx% = windowx% + 1
IF (windowx% + 20) > LEVELXSIZE THEN windowx% = LEVELXSIZE - 20
RETURN

scrolldown:
cy% = 112
windowy% = windowy% + 1
IF (windowy% + 8) > LEVELYSIZE THEN windowy% = LEVELYSIZE - 8
RETURN

scrollleft:
cx% = 0
windowx% = windowx% - 1
IF windowx% < 0 THEN windowx% = 0
RETURN

drawchar:
adress% = ((cy% / 16) + windowy%) * LEVELXSIZE + ((cx% / 16) + windowx%)
DEF SEG = VARSEG(Level%(0))
POKE VARPTR(Level%(0)) + adress%, char%
DEF SEG
RETURN

erasechar:
adress% = ((cy% / 16) + windowy%) * LEVELXSIZE + ((cx% / 16) + windowx%)
DEF SEG = VARSEG(Level%(0))
    POKE VARPTR(Level%(0)) + adress%, 0
DEF SEG
RETURN

getccxypos:
oldypos% = ypos%
page% = INT((char% AND 192) / 64)
ypos% = page% * 4
ccy% = INT((char% AND 63) / 16)
ccx% = INT(char% AND 15)
ccx% = ccx% * 16
ccy% = ccy% * 16
ccy% = ccy% + 136
IF oldypos% <> ypos% THEN DEF SEG = VARSEG(bl%(0)): CALL ABSOLUTE(&H270): DEF SEG
RETURN

charcontrol:
PUT (ccx%, ccy%), drawcur
char% = char% + inc%
char% = char% AND 255
GOSUB getccxypos
PUT (ccx%, ccy%), drawcur
RETURN

savelevel:
numbytes& = LEVELYSIZE * LEVELXSIZE
DEF SEG = VARSEG(Level%(0))
BSAVE levlfile$, VARPTR(Level%(0)), numbytes&
DEF SEG
RETURN

loadlevel:
DEF SEG = VARSEG(Level%(0))
BLOAD levlfile$, VARPTR(Level%(0))
DEF SEG
RETURN

toggleauto:
auto% = auto% XOR 1
IF auto% = 0 THEN LINE (256, 136)-(319, 199), border%, BF
IF auto% = 1 THEN LOCATE 23, 37: COLOR 19: PRINT "A"
RETURN

asm:
DEF SEG = VARSEG(bl%(0))
BLOAD "blitlib.prg", 0
POKE 771, LEVELXSIZE AND 255
POKE 772, LEVELXSIZE \ 256
POKE 863, (LEVELXSIZE - 20) AND 255
POKE 864, (LEVELXSIZE - 20) \ 256
DEF SEG
bl%(132) = VARSEG(ypos%)
bl%(133) = VARPTR(ypos%)
bl%(134) = VARSEG(charset%(0))
bl%(135) = VARPTR(charset%(0))
bl%(136) = VARSEG(windowx%)
bl%(137) = VARPTR(windowx%)
bl%(138) = VARSEG(windowy%)
bl%(139) = VARPTR(windowy%)
bl%(142) = VARSEG(Level%(0))
bl%(143) = VARPTR(Level%(0))
RETURN

value:
COLOR 3
LOCATE 19, 33
x% = (((cx% / 16) + windowx%) * 16)
PRINT "x="; num$(x%)
LOCATE 20, 33
y% = (((cy% / 16) + windowy%) * 16)
PRINT "y="; num$(y%)
valueflag% = 1
RETURN

erasevalue:
valueflag% = 0
LINE (256, 144)-(319, 159), border%, BF
RETURN

FUNCTION num$ (pint%)
num$ = MID$(STR$(pint%), 2, LEN(STR$(pint%)) - 1)
END FUNCTION

