DEFINT A-Z

COMMON SHARED Length, LengthOfInput, PatternDelay!

DECLARE SUB ChangeColor (Colour, Red, Green, Blue)

DECLARE SUB Delay (Interval!)

DECLARE SUB FadeOut ()

DECLARE SUB Intro ()

DECLARE SUB Fade ()

DECLARE SUB PlaySeqence ()

DECLARE SUB PlayButton (Button$)

DECLARE SUB GetSeqence ()

DECLARE SUB PressButton (Button$)

DECLARE SUB CheckOnMouse (x, y, Button)

DECLARE SUB CheckOnButtons (x, y, Button)

DECLARE SUB DefineColors ()

DECLARE SUB PlaceScreen ()

DECLARE SUB SetupMouse ()

DIM SHARED Mouse(9)

DIM SHARED Sequence(1000) AS STRING * 1

DIM SHARED UserInput(1000) AS STRING * 1

DEF Fndistance (x1, y1, x2, y2)

 Side1 = (x1 / 2) - x2

 Side2 = y1 - y2

 Fndistance = ABS(SQR(Side1 ^ 2 + Side2 ^ 2))

END DEF

SCREEN 13

CLS

RANDOMIZE TIMER

PatternDelay! = 1.3

Intro

DefineColors

PlaceScreen

GetSeqence

SetupMouse

PlaySeqence

StartInput:

DO UNTIL LengthOfInput = Length

 CheckOnMouse x, y, Button

 CheckOnButtons x, y, Button

LOOP

FOR i = 1 TO Length

 IF UserInput(i) <> Sequence(i) THEN Fade

NEXT i

Length = Length + 1

LengthOfInput = 0

IF Length < 8 THEN PatternDelay! = PatternDelay! - .1

IF Length < 19 THEN PatternDelay! = PatternDelay! - .05

IF Length = 1000 THEN END

SLEEP 1

PlaySeqence

GOTO StartInput



DATA "F L A S H   B A C K"

DATA "B Y   J E F F   E L M O R E"

DATA "G E T   R E A D Y"

DATA &HB8,&H00,&H00

DATA &H55

DATA &H8B,&HEC

DATA &HCD,&H33

DATA &H92

DATA &H8B,&H5E,&H06

DATA &H89,&H07

DATA &H5D

DATA &HCA,&H02,&H00



SUB ChangeColor (Colour, Red, Green, Blue)

OUT &H3C8, Colour

OUT &H3C9, Red

OUT &H3C9, Green

OUT &H3C9, Blue

END SUB



SUB CheckOnButtons (x, y, Button)

IF Button = 1 THEN

 IF Fndistance(x, y, 100, 50) < 40 THEN PressButton "R"

 IF Fndistance(x, y, 220, 50) < 40 THEN PressButton "B"

 IF Fndistance(x, y, 100, 140) < 40 THEN PressButton "G"

 IF Fndistance(x, y, 220, 140) < 40 THEN PressButton "Y"

 IF Fndistance(x, y, 163, 91) < 28 THEN Fade

END IF

END SUB



SUB CheckOnMouse (x, y, Button)

POKE VARPTR(Mouse(4)), &H92

CALL absolute(y, VARPTR(Mouse(0)))

POKE VARPTR(Mouse(4)), &H91

CALL absolute(x, VARPTR(Mouse(0)))

POKE VARPTR(Mouse(4)), &H93

CALL absolute(Button, VARPTR(Mouse(0)))



END SUB



SUB DefineColors

FOR i = 16 TO 65

ChangeColor i, i - 15, 0, 0

NEXT i

FOR i = 66 TO 116

ChangeColor i, 0, 0, i - 66

NEXT i

FOR i = 117 TO 167

ChangeColor i, 0, i - 177, 0

NEXT i

FOR i = 168 TO 218

ChangeColor i, i - 168, i - 168, 0

NEXT i

FOR i = 220 TO 243

ChangeColor i, 0, 0, i - 220

NEXT i

END SUB



SUB Delay (Interval!)

Newtime! = TIMER + Interval!

DO

LOOP UNTIL TIMER > Newtime!

END SUB



SUB Fade

FadeOut

POKE VARPTR(Mouse(0)) + 1, 2

CALL absolute(c, VARPTR(Mouse(0)))

DEF SEG

CLS

ChangeColor 1, 0, 0, 0

COLOR 1

LOCATE 5, 12

PRINT "You have just lost"

LOCATE 6, 10

PRINT "You made it to Level"; Length - 3

SELECT CASE Length

 CASE IS < 8

  LOCATE 7, 6

  PRINT "Which would make you a Beginner"

 CASE IS < 18

  LOCATE 7, 7

  PRINT "Which would make you a Player"

 CASE IS < 25

  LOCATE 7, 6

  PRINT "Which would make you an Expert"

 CASE IS > 25

  LOCATE 7, 6

  PRINT "Which would make you a Master"

END SELECT

FOR i = 0 TO 63

 ChangeColor 1, 0, 0, i

 Delay .01

NEXT i

COLOR 0

END

END SUB



SUB FadeOut

FOR p = 1 TO 32

FOR i = 2 TO 250

 OUT &H3C7, i

 Red = INP(&H3C9)

 Green = INP(&H3C9)

 Blue = INP(&H3C9)

 IF Red < 2 THEN Red = 2

 IF Green < 2 THEN Green = 2

 IF Blue < 2 THEN Blue = 2

 ChangeColor i, Red - 2, Green - 2, Blue - 2

 

NEXT i

NEXT p



END SUB



SUB GetSeqence

FOR i = 1 TO 1000

 Colour = INT(RND * 4)

 SELECT CASE Colour

  CASE 0

   Sequence(i) = "R"

  CASE 1

   Sequence(i) = "B"

  CASE 2

   Sequence(i) = "G"

  CASE 3

   Sequence(i) = "Y"

 END SELECT

NEXT i

Length = 3

END SUB



SUB Intro

COLOR 17

FOR m = 1 TO 3

READ message$

LOCATE 8, (40 - LEN(message$)) / 2

PRINT message$

FOR i = 0 TO 63

 ChangeColor 17, i, 0, i

 Delay .01

NEXT i

FOR i = 63 TO 0 STEP -1

 ChangeColor 17, i, 0, i

 Delay .01

NEXT i

CLS

NEXT m

END SUB



SUB PlaceScreen

Red = 16 + 45

Blue = 66 + 45

Green = 117 + 45

Yellow = 168 + 45

FOR i = 1 TO 45

 Radius = Radius + 1

 Red = Red - 1

 Blue = Blue - 1

 Green = Green - 1

 Yellow = Yellow - 1

 CIRCLE (100, 50), Radius, Red

 CIRCLE (220, 50), Radius, Blue

 CIRCLE (100, 140), Radius, Green

 CIRCLE (220, 140), Radius, Yellow

 CIRCLE (101, 50), Radius, Red

 CIRCLE (221, 50), Radius, Blue

 CIRCLE (101, 140), Radius, Green

 CIRCLE (221, 140), Radius, Yellow

NEXT i

FOR i = 10 TO 23

 CIRCLE (163, 91), i, 210 + i

 CIRCLE (164, 91), i, 210 + i

NEXT i

LOCATE 12, 20

COLOR 243

PRINT "END"

END SUB



SUB PlayButton (Button$)

PLAY "mbl12"

SELECT CASE (Button$)

 CASE "R"

  FOR i = 16 TO 60

   ChangeColor i, i, 0, 0

  NEXT i

  PLAY "o1e"

 CASE "B"

  FOR i = 61 TO 111

   ChangeColor i, 0, 0, i - 66 + 15

  NEXT i

  PLAY "o1g"

 CASE "G"

  FOR i = 112 TO 162

   ChangeColor i, 0, i - 117 + 15, 0

  NEXT i

  PLAY "o1b"

 CASE "Y"

  FOR i = 163 TO 213

   ChangeColor i, i - 168 + 15, i - 168 + 15, 0

  NEXT i

  PLAY "o1d"

END SELECT

Delay PatternDelay! / 2

DefineColors

Delay PatternDelay! / 2

END SUB



SUB PlaySeqence

POKE VARPTR(Mouse(0)) + 1, 2

CALL absolute(c, VARPTR(Mouse(0)))

FOR i = 1 TO Length

 PlayButton Sequence(i)

NEXT i

POKE VARPTR(Mouse(0)) + 1, 1

CALL absolute(c, VARPTR(Mouse(0)))

POKE VARPTR(Mouse(0)) + 1, 3

CALL absolute(c, VARPTR(Mouse(0)))

END SUB



SUB PressButton (Button$)

IF LengthOfInput = Length THEN EXIT SUB

LengthOfInput = LengthOfInput + 1

SELECT CASE (Button$)

 CASE "R"

  UserInput(LengthOfInput) = "R"

  FOR i = 16 TO 60

   ChangeColor i, i, 0, 0

  NEXT i

  PLAY "o1e"

 CASE "B"

  UserInput(LengthOfInput) = "B"

  FOR i = 61 TO 111

   ChangeColor i, 0, 0, i - 66 + 15

  NEXT i

  PLAY "o1g"

 CASE "G"

  UserInput(LengthOfInput) = "G"

  FOR i = 112 TO 162

   ChangeColor i, 0, i - 117 + 15, 0

  NEXT i

  PLAY "o1b"

 CASE "Y"

  UserInput(LengthOfInput) = "Y"

  FOR i = 163 TO 213

   ChangeColor i, i - 168 + 15, i - 168 + 15, 0

  NEXT i

  PLAY "o1d"

END SELECT

POKE VARPTR(Mouse(0)) + 1, 2

CALL absolute(c, VARPTR(Mouse(0)))

Delay .2

POKE VARPTR(Mouse(0)) + 1, 1

CALL absolute(c, VARPTR(Mouse(0)))

POKE VARPTR(Mouse(0)) + 1, 3

CALL absolute(c, VARPTR(Mouse(0)))

DefineColors

END SUB



SUB SetupMouse

DEF SEG = VARSEG(Mouse(0))

FOR i = 0 TO 17

 READ r

 POKE VARPTR(Mouse(0)) + i, r

NEXT i

FOR i = 1 TO 3

 SELECT CASE i

  CASE 1

   act = 0

  CASE 2

   act = 1

  CASE 3

   act = 3

 END SELECT

 POKE VARPTR(Mouse(0)) + 1, act

 CALL absolute(c, VARPTR(Mouse(0)))

NEXT i



END SUB



