REM The Dungeon Player List Utility v11.0 r2.0 Program Source

' declare all variables as integer type
DEFINT A-Z

' declares variable storage for user record structure type
TYPE UserType
 CodeName AS STRING * 32
 PassWord AS STRING * 32
 Spell(1 TO 40) AS INTEGER
 Wand(1 TO 10) AS INTEGER
 Potion(1 TO 10) AS INTEGER
 Staff(1 TO 10) AS INTEGER
 Ring(1 TO 10) AS INTEGER
 Globe(1 TO 10) AS INTEGER
 Stats1(1 TO 6) AS DOUBLE
 Stats2(1 TO 17) AS INTEGER
END TYPE

' define error routine trap label
ON ERROR GOTO Error.Routine

' declare structures common to main program
DIM UserRecord AS UserType

' define function to convert encrypted string to 20 character string
DEF FNdecrypt$ (z$)
  i$ = ""' reset decrypted return string
  FOR j = 1 TO 4' loop in 4 blocks of 5 bytes
    j$ = ""' reset block string
    z# = CVD(MID$(z$, j * 8 - 7, 8))' store block value
    FOR q = 1 TO 5' loop in block bytes
      dvid# = INT(z# / 1000)' store block byte value
      num# = z# - dvid# * 1000' compute block byte value
      z# = dvid#' decrement block value
      j$ = j$ + CHR$(num#)' add byte to string
    NEXT ' next block byte
    Y$ = MID$(j$, 1, 1)' reverse stored bytes
    MID$(j$, 1, 1) = MID$(j$, 5, 1)' reverse
    MID$(j$, 5, 1) = Y$' reverse
    Y$ = MID$(j$, 2, 1)' reverse stored bytes
    MID$(j$, 2, 1) = MID$(j$, 4, 1)' reverse
    MID$(j$, 4, 1) = Y$' reverse
    i$ = i$ + j$' add string to return string
  NEXT ' next block
  FNdecrypt$ = i$' store return function string
END DEF ' end decryption function

' main program
GOSUB Open.User.File ' open the users data file
GOSUB Header1 ' display header one
Page.Length = 5 ' reset page length
FOR User.Number = 1 TO LOF(1) / LEN(UserRecord) ' loop through all users in file
   Page.Length = Page.Length + 1 ' increment page length
   IF Page.Length = 24 THEN ' check page length
      Page.Length = 5 ' reset page length
      GOSUB Press.Key ' get a keypress
      GOSUB Header1 ' redisplay header one
   END IF ' end check page length
   GET 1, User.Number, UserRecord ' read next user record
   User.Name$ = FNdecrypt$(UserRecord.CodeName) ' store decypted user name
   MID$(User.Name$, 1, 1) = UCASE$(MID$(User.Name$, 1, 1)) ' uppercase name
   Dungeon.Level$ = STR$(UserRecord.Stats1(1)) ' store dungeon levels
   Dungeon.Level$ = Dungeon.Level$ + SPACE$(14 - LEN(Dungeon.Level$)) ' pad spaces
   Player.Level$ = STR$(UserRecord.Stats1(2)) ' store player level
   Player.Level$ = Player.Level$ + SPACE$(14 - LEN(Player.Level$)) ' pad spaces
   Display.Line$ = User.Name$ + Dungeon.Level$ + " " + Player.Level$ ' append
   Wands = 0 ' reset wand counter
   FOR Count = 1 TO 10 ' count number of wands
      IF UserRecord.Wand(Count) > 0 THEN ' check wands
         Wands = Wands + 1 ' increment wands
      END IF ' end check wands
   NEXT ' end count wands
   Display.Field$ = STR$(Wands) ' store number of wands
   Display.Field$ = Display.Field$ + SPACE$(7 - LEN(Display.Field$)) ' pad spaces
   Display.Line$ = Display.Line$ + Display.Field$ ' append to display line
   Potions = 0 ' reset potion counter
   FOR Count = 1 TO 10 ' count number of potions
      IF UserRecord.Potion(Count) > 0 THEN ' check potions
         Potions = Potions + 1 ' increment potions
      END IF ' end check potions
   NEXT ' end count potions
   Display.Field$ = STR$(Potions) ' store number ofp otions
   Display.Field$ = Display.Field$ + SPACE$(9 - LEN(Display.Field$)) ' pad spaces
   Display.Line$ = Display.Line$ + Display.Field$ ' append to display line
   Staffs = 0 ' reset staff counter
   FOR Count = 1 TO 10 ' count number of staffs
      IF UserRecord.Staff(Count) > 0 THEN ' check staffs
         Staffs = Staffs + 1 ' increment staffs
      END IF ' end check staffs
   NEXT ' end counter staffs
   Display.Field$ = STR$(Staffs) ' store number of staffs
   Display.Field$ = Display.Field$ + SPACE$(8 - LEN(Display.Field$)) ' pad spaces
   Display.Line$ = Display.Line$ + Display.Field$ ' append to display line
   Rings = 0 ' reset ring counter
   FOR Count = 1 TO 10 ' count number of rings
      IF UserRecord.Ring(Count) > 0 THEN ' check rings
         Rings = Rings + 1 ' increment rings
      END IF ' end check rings
   NEXT ' end count rings
   Display.Field$ = STR$(Rings) ' store number of rings
   Display.Line$ = Display.Line$ + Display.Field$ ' append to display line
   COLOR 13 ' color magenta
   PRINT Display.Line$ ' display report line on screen
   PRINT #2, Display.Line$ ' print display line to file
NEXT ' end loop through user file
PRINT #2, "" ' print linefeed to file
GOSUB Press.Key ' get a keypress
GOSUB Header2 ' display header two
Page.Length = 5 ' reste page length
FOR User.Number = 1 TO LOF(1) / LEN(UserRecord) ' loop through all users in file
   Page.Length = Page.Length + 1 ' increment page length
   IF Page.Length = 24 THEN ' check page length
      Page.Length = 5 ' reset page length
      GOSUB Press.Key ' get a keypress
      GOSUB Header2 ' redisplay header two
   END IF ' end check page length
   GET 1, User.Number, UserRecord ' read next user record
   User.Name$ = FNdecrypt$(UserRecord.CodeName) ' store decrypted user name
   MID$(User.Name$, 1, 1) = UCASE$(MID$(User.Name$, 1, 1)) ' uppercase name
   Strength$ = STR$(UserRecord.Stats2(1)) ' store strength statistic
   Strength$ = Strength$ + SPACE$(9 - LEN(Strength$)) ' pad spaces
   Wisdom$ = STR$(UserRecord.Stats2(2)) ' store wisdom statistic
   Wisdom$ = Wisdom$ + SPACE$(7 - LEN(Wisdom$)) ' pad spaces
   Intellect$ = STR$(UserRecord.Stats2(3)) ' store intellect statistic
   Intellect$ = Intellect$ + SPACE$(10 - LEN(Intellect$)) ' pad spaces
   Constitution$ = STR$(UserRecord.Stats2(4)) ' store consitution statistic
   Constitution$ = Constitution$ + SPACE$(13 - LEN(Constitution$)) ' pad spaces
   Dexterity$ = STR$(UserRecord.Stats2(5)) ' store dexterity statistic
   Dexterity$ = Dexterity$ + SPACE$(10 - LEN(Dexterity$)) ' pad spaces
   Charisma$ = STR$(UserRecord.Stats2(6)) ' store charisma statistic
   COLOR 13 ' color magenta
   ' append all statistics to display line
   Display.Line$ = User.Name$ ' store user name
   Display.Line$ = Display.Line$ + Strength$ ' append strength
   Display.Line$ = Display.Line$ + Wisdom$ ' append wisdom
   Display.Line$ = Display.Line$ + Intellect$ ' append intellect
   Display.Line$ = Display.Line$ + Constitution$ ' append constitution
   Display.Line$ = Display.Line$ + Dexterity$ ' sppend dexterity
   Display.Line$ = Display.Line$ + Charisma$ ' append charisma
   PRINT Display.Line$ ' display report line on screen
   PRINT #2, Display.Line$ ' print display line to file
NEXT ' end loop through user file
PRINT #2, "" ' print linefeed to file
GOSUB Press.Key ' get a keypress
GOSUB Header3 ' display header three
Page.Length = 5 ' reset page length
FOR User.Number = 1 TO LOF(1) / LEN(UserRecord) ' loop through all users in file
   Page.Length = Page.Length + 1 ' increment page length
   IF Page.Length = 24 THEN ' check page length
      Page.Length = 5 ' reset page length
      GOSUB Press.Key ' get a keypress
      GOSUB Header3 ' redisplay header three
   END IF ' end check page length
   GET 1, User.Number, UserRecord ' read next user record
   User.Name$ = FNdecrypt$(UserRecord.CodeName) ' store decrypted user name
   MID$(User.Name$, 1, 1) = UCASE$(MID$(User.Name$, 1, 1)) ' uppercase name
   Experience$ = STR$(UserRecord.Stats1(3)) ' store experience
   Experience$ = Experience$ + SPACE$(22 - LEN(Experience$)) ' pad spaces
   Gold$ = STR$(UserRecord.Stats1(5)) ' store gold
   Gold$ = Gold$ + SPACE$(22 - LEN(Gold$)) ' pad spaces
   Hit.Points$ = STR$(UserRecord.Stats1(6)) ' store hit points
   COLOR 13 ' color magenta
   ' append all statistics to display line
   Display.Line$ = User.Name$ ' store user name
   Display.Line$ = Display.Line$ + Experience$ ' append experience
   Display.Line$ = Display.Line$ + Gold$ ' append gold
   Display.Line$ = Display.Line$ + Hit.Points$ ' append hit points
   PRINT Display.Line$ ' display report line on screen
   PRINT #2, Display.Line$ ' print report line to file
NEXT ' end loop through user file
PRINT #2, "" ' print linefeed to file
GOSUB Press.Key ' get a keypress
GOSUB Header4 ' display header four
Page.Length = 5 ' reset page length
FOR User.Number = 1 TO LOF(1) / LEN(UserRecord) ' loop through all users in file
   Page.Length = Page.Length + 1 ' increment page length
   IF Page.Length = 24 THEN ' check page length
      Page.Length = 5 ' reset page length
      GOSUB Press.Key ' get a keypress
      GOSUB Header4 ' redisplay header four
   END IF ' end check page length
   GET 1, User.Number, UserRecord ' read next user record
   User.Name$ = FNdecrypt$(UserRecord.CodeName) ' store decrypted user name
   MID$(User.Name$, 1, 1) = UCASE$(MID$(User.Name$, 1, 1)) ' uppercase name
   Display.Line$ = User.Name$ ' store user name
   FOR Count = 7 TO 12 ' loop through remaining statistics
      Display.Field$ = STR$(UserRecord.Stats2(Count)) ' store statistic
      Display.Field$ = Display.Field$ + SPACE$(7 - LEN(Display.Field$)) ' pad spaces
      Display.Line$ = Display.Line$ + Display.Field$ ' append to display line
   NEXT ' end loop through remaining statistics
   COLOR 13 ' color magenta
   PRINT Display.Line$ ' display report line on screen
   PRINT #2, Display.Line$ ' print report line to file
NEXT ' end loop through user file
PRINT #2, "" ' print linefeed to file
GOSUB Press.Key ' get a keypress
COLOR 7, 0 ' color white on black
CLS ' clear screen
END ' quit program

' routine to get a keypress
Press.Key:
 LOCATE 25, 1, 0 ' set cursor to bottom of screen
 COLOR 10 ' color cyan
 PRINT "Press a key to continue:"; ' display message prompt
 WHILE INKEY$ = "" ' loop until keypress
 WEND ' end keypress loop
 RETURN ' exit routine

' routine to display header one to screen and file
Header1:
 GOSUB Page.Header ' display main header
 COLOR 14 ' color yellow
 ' make header one
 Header$ = "Player Name          Dungeon Level  Player Level  Wands  Potions  Staffs  Rings"
 PRINT Header$ ' display header
 PRINT #2, Header$ ' print header to file
 Header$ = STRING$(79, "-") ' make header underline
 PRINT Header$ ' display header underline
 PRINT #2, Header$ ' print header underline to file
 RETURN ' exit routine

' routine to display header two to screen and file
Header2:
 GOSUB Page.Header ' display main header
 COLOR 14 ' color yellow
 ' make header two
 Header$ = "Player Name          Strength Wisdom Intellect Constitution Dexterity Charisma"
 PRINT Header$ ' display header
 PRINT #2, Header$ ' print header to file
 Header$ = STRING$(78, "-") ' make header underline
 PRINT Header$ ' display header underline
 PRINT #2, Header$ ' print header underline to file
 RETURN ' exit routine

' routine to display header three to screen and file
Header3:
 GOSUB Page.Header ' display main header
 COLOR 14 ' color yellow
 ' make header three
 Header$ = "Player Name          Experience            Gold                  Hit Points"
 PRINT Header$ ' display header
 PRINT #2, Header$ ' print header to file
 Header$ = STRING$(74, "-") ' make header underline
 PRINT Header$ ' display header underline
 PRINT #2, Header$ ' print header underline to file
 RETURN ' exit routine

' routine to display header four to screen and file
Header4:
 GOSUB Page.Header ' display main header
 COLOR 14 ' color yellow
 ' make header four
 Header$ = "Player Name          Weapon Shield Armor  Cloak  Helmet Boots"
 PRINT Header$ ' display header
 PRINT #2, Header$ ' print header to file
 Header$ = STRING$(61, "-") ' make header underline
 PRINT Header$ ' display header underline
 PRINT #2, Header$ ' print header underline to file
 RETURN ' exit routine

' display the main page header
Page.Header:
 COLOR 14, 1' color yellow on blue
 CLS ' clear screen
 COLOR 15 ' color white
 PRINT "The Dungeon Player List v11.0 r2.0 Utility" ' display header
 PRINT STRING$(36, "=") ' display header underline
 PRINT ' linefeed
 RETURN ' exit routine

' open the user file, length of user record
Open.User.File:
 CLOSE ' close files
 ' open user file random
 OPEN "players.dat" FOR RANDOM SHARED AS #1 LEN = LEN(UserRecord)
 OPEN "ranklist.dat" FOR OUTPUT SHARED AS #2
 RETURN ' exit routine

' error routine traps fatal runtime errors
Error.Routine:
 COLOR 7, 0' color whiote on black
 CLS ' clear screen
 PRINT "The Utility Crashed.." ' display error message
 END ' quit program

