REM The Dungeon Map Edit Utility v11.0 r2.0 Program Source

' declare all variables as integer type
DEFINT A-Z

' declares variable storage for dungeon record structure type
TYPE DungeonType
 LevelData(1 TO 24, 1 TO 80) AS INTEGER
 ScreenData(1 TO 24, 1 TO 80) AS INTEGER
 Stats(1 TO 32) AS INTEGER
END TYPE

' declares variable storage for user record structure type
TYPE UserType
 CodeName AS STRING * 32
 PassWord AS STRING * 32
 Spell(1 TO 40) AS INTEGER
 Wand(1 TO 10) AS INTEGER
 Potion(1 TO 10) AS INTEGER
 Staff(1 TO 10) AS INTEGER
 Ring(1 TO 10) AS INTEGER
 Globe(1 TO 10) AS INTEGER
 Stats1(1 TO 6) AS DOUBLE
 Stats2(1 TO 17) AS INTEGER
END TYPE

' define error routine trap label
ON ERROR GOTO Error.Routine

' declare structures common to main program
DIM UserRecord AS UserType, DungeonRecord AS DungeonType

' define function to convert encrypted string to 20 character string
DEF FNdecrypt$ (z$)
  I$ = ""' reset decrypted return string
  FOR J = 1 TO 4' loop in 4 blocks of 5 bytes
    J$ = ""' reset block string
    z# = CVD(MID$(z$, J * 8 - 7, 8))' store block value
    FOR q = 1 TO 5' loop in block bytes
      dvid# = INT(z# / 1000)' store block byte value
      num# = z# - dvid# * 1000' compute block byte value
      z# = dvid#' decrement block value
      J$ = J$ + CHR$(num#)' add byte to string
    NEXT ' next block byte
    Y$ = MID$(J$, 1, 1)' reverse stored bytes
    MID$(J$, 1, 1) = MID$(J$, 5, 1)' reverse
    MID$(J$, 5, 1) = Y$' reverse
    Y$ = MID$(J$, 2, 1)' reverse stored bytes
    MID$(J$, 2, 1) = MID$(J$, 4, 1)' reverse
    MID$(J$, 4, 1) = Y$' reverse
    I$ = I$ + J$' add string to return string
  NEXT ' next block
  FNdecrypt$ = I$' store return function string
END DEF ' end decryption function

' main routine loop
GOSUB Open.User.File ' open the user data file
User.Index = 1 ' reset the user number being edited
DO ' loop through the user data file
   GET 1, User.Index, UserRecord ' read the next user record
   User.Name$ = FNdecrypt$(UserRecord.CodeName) ' get the decrypted user name
   MID$(User.Name$, 1, 1) = UCASE$(MID$(User.Name$, 1, 1)) ' uppercase name
   User.Name$ = RTRIM$(User.Name$) ' trim blanks from the right
   COLOR 14, 1 ' color yellow on blue
   CLS ' clear screen
   PRINT User.Name$; ": Edit(Y/N/Q)? "; ' display input prompt
   Input.Char$ = INPUT$(1) ' read a keyboard character
   SELECT CASE UCASE$(Input.Char$) ' determine input character
   CASE "N" ' input no
      User.Index = User.Index + 1 ' increment to the next user record
   CASE "Y" ' input yes
      GOSUB Edit.Map ' edit the current user number
      User.Index = User.Index + 1 ' increment to the next user record
   CASE "Q" ' input quit
      EXIT DO ' exit the edit loop
   END SELECT ' end determine input character
' loop until the user index number exceeds the data file length
LOOP WHILE User.Index <= LOF(1) / LEN(UserRecord)
COLOR 7, 0 ' color white on black
CLS ' clear screen
END ' quit program

' routine to edit the user dungeon maps
Edit.Map:
 GOSUB Open.Data.File ' open the user dungeon map data file
 Dungeon.Level = 1 ' reset the dungeon level being edited
 ' loop through all dungeon map levels
 ' until the dungeon level exceeds the data file length
 DO WHILE Dungeon.Level <= LOF(2) / LEN(DungeonRecord)
    COLOR 14, 1 ' color yellow on blue
    CLS ' clear screen
    PRINT "Edit Dungeon Level"; Dungeon.Level; "(Y/N/Q)? "; ' make input prompt
    Input.Char$ = INPUT$(1) ' get a key board character
    SELECT CASE UCASE$(Input.Char$) ' determine input character
    CASE "N" ' input no
       Dungeon.Level = Dungeon.Level + 1 ' increment dungeon level
    CASE "Y" ' input yes
       GOSUB Edit.Level ' edit the current dungeon level
       Dungeon.Level = Dungeon.Level + 1 ' increment dungeon level
    CASE "Q" ' input quit
       EXIT DO ' exit dungeon map edit loop
    END SELECT ' end determine input character
 LOOP ' end dungeon map level edit loop
 RETURN ' exit routine

' routine to edit a dungeon level
Edit.Level:
 GOSUB Display.Level ' display the dungeon level map
 Status.Line = -1 ' reset status line toggle
 GOSUB Display.Status.Line ' display the status line
 DO ' loop while the map is edited
    Input.Char$ = "" ' reset input string
    WHILE Input.Char$ = "" ' loop until key entered
       Input.Char$ = INKEY$ ' read the keyboard
    WEND ' end key input loop
    SELECT CASE LEN(Input.Char$) ' determine input scan code
    CASE 1 ' input length is single key scan code
       SELECT CASE ASC(UCASE$(Input.Char$)) ' determine single keypress
       CASE 9 ' tab
          ' try to tab as far right until column 80
          IF Dungeon.Y + 8 < 80 THEN ' next tab stop is within screen edge
             Dungeon.Y = Dungeon.Y + 8 ' increment the map Y cursor value
             COLOR 15, 1 ' color white on blue
             LOCATE Dungeon.X, Dungeon.Y, 1 ' set cursor to new position
          ELSE ' next tab stop is beyond screen
             IF Dungeon.Y < 79 THEN ' check rightmost column
                Dungeon.Y = 79 ' set map Y cursor value
                COLOR 15, 1 ' color white on blue
                LOCATE Dungeon.X, Dungeon.Y, 1 ' set cursor to new position
             END IF ' end check rightmost column
          END IF ' end check next tab stop
       CASE 27 ' escape
          PUT 2, Dungeon.Level, DungeonRecord ' write current dungeon level
          EXIT DO ' exit dungeon level edit loop
       CASE ASC("-") ' minus
          ' toggle the status line
          IF Status.Line = 0 THEN ' check current status toggle
             Status.Line = -1 ' toggle status line
             GOSUB Display.Status.Line ' display status line
          END IF ' end check current status toggle
       CASE ASC("+") ' plus
          ' toggle the status line
          IF Status.Line THEN ' check current status toggle
             Status.Line = 0 ' toggle status line
             GOSUB Display.Status.Line ' display status line
          END IF ' end check current status toggle
       CASE 48 TO 57, 65 TO 70, 79, 88 ' character is a dungeon cell symbol
          GOSUB Change.Cell ' routine to change that cell
       END SELECT ' end determine key scan type
    CASE 2 ' key scan type is double byte
       Key.Scan = ASC(RIGHT$(Input.Char$, 1)) ' store second key scan byte
       SELECT CASE Key.Scan ' determine key scan byte value
       CASE 15 ' shift-tab
          ' try to tab left as far as column 1
          IF Dungeon.Y - 8 > 0 THEN ' next left tab stop is within screen edge
             Dungeon.Y = Dungeon.Y - 8 ' decrement the map Y cursor value
             COLOR 15, 1 ' color white on blue
             LOCATE Dungeon.X, Dungeon.Y, 1 ' set the cursor to new position
          ELSE ' next left tab stop is beyond screen
             IF Dungeon.Y > 1 THEN ' check leftmost column
                Dungeon.Y = 1 ' set map Y cursor value
                COLOR 15, 1 ' color white on blue
                LOCATE Dungeon.X, Dungeon.Y, 1 ' set the cursor to new position
             END IF ' end check leftmost column
          END IF ' end check left tab stop
       CASE 79 ' end
          ' move cursor to end of screen
          IF Dungeon.Y <> 79 THEN ' check is cursor already at screen edge
             Dungeon.Y = 79 ' set the map Y cursor value
             COLOR 15, 1 ' color white on blue
             LOCATE Dungeon.X, Dungeon.Y, 1 ' set the cursor to new psotion
          END IF ' end check cursor position
       CASE 80 ' down
          ' move cursor down one row
          IF Dungeon.X < 23 THEN ' check is cursor already at screen bottom
             Dungeon.X = Dungeon.X + 1 ' set the map X cursor value
             COLOR 15, 1 ' color white on blue
             LOCATE Dungeon.X, Dungeon.Y, 1 ' set the cursor to new position
          END IF ' end check cursor position
       CASE 81 ' page down
          ' move the cursor to bottom of screen
          IF Dungeon.X <> 23 THEN ' check is cursor already at screen bottom
             Dungeon.X = 23 ' set the map X cursor value
             COLOR 15, 1 ' color white on blue
             LOCATE Dungeon.X, Dungeon.Y, 1 ' set the cursor to new position
          END IF ' end check cursor position
       CASE 75 ' left
          ' move the cursor left one column
          IF Dungeon.Y > 1 THEN ' check is cursor already at screen edge
             Dungeon.Y = Dungeon.Y - 1 ' set the map Y cursor value
             COLOR 15, 1 ' color white on blue
             LOCATE Dungeon.X, Dungeon.Y, 1 ' set the cursor to new position
          END IF ' end check cursor position
       CASE 77 ' right
          ' move the cursor right one column
          IF Dungeon.Y < 79 THEN ' check is cursor already at screen edge
             Dungeon.Y = Dungeon.Y + 1 ' set the map Y cursor value
             COLOR 15, 1 ' color white on blue
             LOCATE Dungeon.X, Dungeon.Y, 1 ' set the cursor to new position
          END IF ' end check cursor position
       CASE 71 ' home
          ' move the cursor to the left side of screen
          IF Dungeon.Y <> 1 THEN ' check is cursor already at left side
             Dungeon.Y = 1 ' set the map Y cursor value
             COLOR 15, 1 ' color white on blue
             LOCATE Dungeon.X, Dungeon.Y, 1 ' set the cursor to new position
          END IF ' end check cursor position
       CASE 72 ' up
          ' move cursor up one row
          IF Dungeon.X > 1 THEN ' check is cursor already at top edge
             Dungeon.X = Dungeon.X - 1 ' set the map X cursor value
             COLOR 15, 1 ' color white on blue
             LOCATE Dungeon.X, Dungeon.Y, 1 ' set the cursor to new position
          END IF ' end check cursor position
       CASE 73 ' page up
          ' move the cursor to top edge
          IF Dungeon.X <> 1 THEN ' check is cursor already at top edge
             Dungeon.X = 1 ' set the map X cursor value
             COLOR 15, 1 ' color white on blue
             LOCATE Dungeon.X, Dungeon.Y, 1 ' set the cursor to new position
          END IF ' end check cursor position
       END SELECT ' end determine key scan code
    END SELECT ' end determine key scan type
 LOOP ' end dungeon map edit loop
 RETURN ' exit routine

' routine displays the current dungeon level map
Display.Level:
 CLS ' clear screen
 GET 2, Dungeon.Level, DungeonRecord ' read the dungeon level data record
 ' loop through all dungeon record level cells
 FOR Dungeon.Row = 1 TO 23 ' rows by
    FOR Dungeon.Column = 1 TO 79 ' columns
       LOCATE Dungeon.Row, Dungeon.Column, 0 ' locate at dungeon xy
       ' get ascii value of dungeon coordinate
       Dungeon.Cell = DungeonRecord.LevelData(Dungeon.Row, Dungeon.Column)
       ' display character in dungeon screen array on screen
       IF Dungeon.Cell = 46 OR Dungeon.Cell = 176 THEN ' cell is dungeon wall
          COLOR 7 ' color low white
       ELSE ' compare dungeon cell type
          ' check dungeon cell is room border
          IF Dungeon.Cell > 21 AND Dungeon.Cell < 26 THEN ' compare dot
             Dungeon.Cell = 176 ' reset dungeon character to wall block
             COLOR 15 ' dungeon room border
          ELSE ' color dot
             COLOR 7 ' dungeon dot/wall
          END IF ' end compare dungeon cell type
       END IF ' end check dungeon cell type
       PRINT CHR$(Dungeon.Cell); ' print ascii character
    NEXT ' end dungeon column loop
    COLOR 7 ' display rightmost column
    PRINT CHR$(176); ' print ascii character
 NEXT ' end dungeon row loop
 Dungeon.X = 1 ' reset edit X cursor
 Dungeon.Y = 1 ' reset edit Y cursor
 COLOR 15 ' color white
 LOCATE 1, 1, 1 ' reset editing cursor
 RETURN ' exit routine

' routine to display one of two status lines
Display.Status.Line:
 IF Status.Line THEN ' check status line toggle
    GOSUB Display.Status.Line1 ' display the first status line
 ELSE ' check status line toggle
    GOSUB Display.Status.Line2 ' display the second status line
 END IF ' end check status line toggle
 LOCATE Dungeon.X, Dungeon.Y, 1 ' reset the cursor at the dungeon cell
 RETURN ' exit routine

' routine to display status line one
Display.Status.Line1:
 GOSUB Clear.Status.Line ' clear the status line area
 LOCATE 24, 1 ' locate cursor at status line
 ' display status line part one
 PRINT "1 = ~,  2 = $,  3 = " + CHR$(254) + ",  4 = ^,  5 = o,  6 = *,  7 = !,  8 = ?,  9 = >,  (+)Next";
 LOCATE 25, 1 ' locate cursor at status line
 ' display status line part two
 PRINT "Scroll, Gold,   Chest,  Trap,   Pit,    Gem,    Tele,   Temple, Stairs Up.";
 RETURN ' exit routine

' routine to display status line two
Display.Status.Line2:
 GOSUB Clear.Status.Line ' clear the status line area
 LOCATE 24, 1 ' locate cursor at status line
 ' display status line part one
 PRINT "A = <,  B = &,  C = |,  D = @,  E = %,  F = " + CHR$(34) + ",  0 = #,   X = .,         (-)Prev";
 LOCATE 25, 1 ' locate cursor at status line
 ' display status line part two
 PRINT "Down,   Coins,  Wand,   Potion, Staff,  Ring,   Monster, Empty Cell, <esc>=quit";
 RETURN ' exit routine

' routine to clear status lines with blanks
Clear.Status.Line:
 LOCATE 24, 1 ' locate cursor at status line
 PRINT SPACE$(79); ' display line of blanks
 LOCATE 25, 1 ' locate cursor at status line
 PRINT SPACE$(79); ' display line of blanks
 COLOR 7 ' color white
 RETURN ' exit routine

' routine changes the dungeon cell in the current dungeon level map
' at the current dungeon x, y coordinates at the cursor location.
Change.Cell:
 Current.Cell = DungeonRecord.LevelData(Dungeon.X, Dungeon.Y)
 SELECT CASE Current.Cell ' check dungeon cell type to wall, room border
 CASE 21, 22, 23, 24, 25, 26, 176 ' dungeon cell wall, room border values
    RETURN ' exit routine without changing cell
 END SELECT ' end check dungeon cell type
 SELECT CASE UCASE$(Input.Char$) ' determine cell type to change
 ' store current cell to change to, and current cell type.
 CASE "O" ' monster
    Current.Cell = ASC("#") ' cell symbol
    Cell.Type = 6 ' cell type
 CASE "1" ' scroll
    Current.Cell = ASC("~") ' cell symbol
    Cell.Type = 7 ' cell type
 CASE "2" ' gold
    Current.Cell = ASC("$") ' cell symbol
    Cell.Type = 11 ' cell type
 CASE "3" ' chest
    Current.Cell = 254 ' block character (chest)
    Cell.Type = 23 ' cell type
 CASE "4" ' trap
    Current.Cell = ASC("^") ' cell symbl
    Cell.Type = 9 ' cell type
 CASE "5" ' pit
    Current.Cell = ASC("o") ' cell symbol
    Cell.Type = 13 ' cell type
 CASE "6" ' gem
    Current.Cell = ASC("*") ' cell symbol
    Cell.Type = 19 ' cell type
 CASE "7" ' teleporter
    Current.Cell = ASC("!") ' cell symbol
    Cell.Type = 15 ' cell type
 CASE "8" ' temple
    Current.Cell = ASC("?") ' cell symbol
    Cell.Type = 17 ' cell type
 CASE "9" ' stairs down
    Current.Cell = ASC(">") ' cell symbol
    Cell.Type = 0 ' cell type
 CASE "A" ' stairs up
    Current.Cell = ASC("<") ' cell symbol
    Cell.Type = 0 ' cell type
 CASE "B" ' coins
    Current.Cell = ASC("&") ' cell symbol
    Cell.Type = 21 ' cell type
 CASE "C" ' wand
    Current.Cell = ASC("|") ' cell symbol
    Cell.Type = 25 ' cell type
 CASE "D" ' potion
    Current.Cell = ASC("@") ' cell symbol
    Cell.Type = 27 ' cell type
 CASE "E" ' staff
    Current.Cell = ASC("%") ' cell symbol
    Cell.Type = 29 ' cell type
 CASE "F" ' ring
    Current.Cell = 34 ' double quote
    Cell.Type = 31 ' cell type
 CASE "X" ' dot
    Current.Cell = ASC(".") ' dot/non-symbol (hallway)
    Cell.Type = -1 ' cell type (decrement if changing other symbol)
 CASE ELSE ' some other synbol
    Current.Cell = ASC(".") ' default to dot/non-symbol
    Cell.Type = 0 ' any cell type
 END SELECT ' end determine cell type to change
 ' check the cell change type
 SELECT CASE Cell.Type ' determine change type
 CASE IS > 0 ' cell is an additional symbol
    ' increment the value of the number of symbols in dungeon
    DungeonRecord.Stats(Cell.Type) = DungeonRecord.Stats(Cell.Type) + 1
 CASE -1 ' new cell is dot/non-symbol,
    ' otherwise cell is changed to dot/non-symbol,
    GOSUB Update.Counters ' decrement the number of symbols in dungeon
 END SELECT ' end determine change type
 ' store the new cell type in the dungeon level data array
 DungeonRecord.LevelData(Dungeon.X, Dungeon.Y) = Current.Cell
 ' check is dungeon cell was uncovered during game play
 IF DungeonRecord.ScreenData(Dungeon.X, Dungeon.Y) <> 32 THEN ' cell not space
    DungeonRecord.ScreenData(Dungeon.X, Dungeon.Y) = Current.Cell ' add cell type
 END IF ' end check cell already uncovered
 COLOR 7 ' color white
 LOCATE Dungeon.X, Dungeon.Y, 1 ' set cursor at x, y position on screen
 PRINT CHR$(Current.Cell); ' display the new cell value
 LOCATE Dungeon.X, Dungeon.Y, 1 ' reset cursor at x, y position on screen
 RETURN ' exit routine

' routine to decrement the total number of a specific dungeon cell symbol
' if the cell is replaced with a dot/non-symbol.
Update.Counters:
 ' get the current dungeon cell before changing,
 Previous.Cell = DungeonRecord.LevelData(Dungeon.X, Dungeon.Y)
 SELECT CASE Previous.Cell ' determine the cell symbol to replace
 CASE ASC("#") ' monster
    Previous.Cell.Type = 6 ' cell type
 CASE ASC("~") ' scroll
    Previous.Cell.Type = 7 ' cell type
 CASE ASC("$") ' gold
    Previous.Cell.Type = 11 ' cell type
 CASE 254 ' block character (chest)
    Previous.Cell.Type = 23 ' cell type
 CASE ASC("^") ' trap
    Previous.Cell.Type = 9 ' cell type
 CASE ASC("o") ' pit
    Previous.Cell.Type = 13 ' cell type
 CASE ASC("*") ' gem
    Previous.Cell.Type = 19 ' cell type
 CASE ASC("!") ' teleporter
    Previous.Cell.Type = 15 ' cell type
 CASE ASC("?") ' temple
    Previous.Cell.Type = 17 ' cell type
 CASE ASC("&") ' coins
    Previous.Cell.Type = 21 ' cell type
 CASE ASC("|") ' wand
    Previous.Cell.Type = 25 ' cell type
 CASE ASC("@") ' potion
    Previous.Cell.Type = 27 ' cell type
 CASE ASC("%") ' staff
    Previous.Cell.Type = 29 ' cell type
 CASE 34 ' double quote (ring)
    Previous.Cell.Type = 31 ' cell type
 CASE ELSE ' some other symbol
    Previous.Cell.Type = 0 ' other cell type
 END SELECT ' end determine replacement cell type
 IF Previous.Cell.Type > 0 THEN ' check cell type
    ' decrement the total number of cell type being replaced
    DungeonRecord.Stats(Previous.Cell.Type) = DungeonRecord.Stats(Previous.Cell.Type) - 1
 END IF ' end check cell type
 RETURN ' exit routine

' open the user file, length of user record
Open.User.File:
 ' open user file random
 OPEN "players.dat" FOR RANDOM SHARED AS #1 LEN = LEN(UserRecord)
 RETURN ' exit routine

' open the data file, length of dungeon record
Open.Data.File:
 CLOSE 2 ' close file 2
 ' name the data file to store the dungeon statistics,
 ' the extension being the users index padded in zeroes
 FileName$ = "datafile." + RIGHT$(STR$(User.Index + 1000), 3)
 ' open the file, randomly, length of the record equal to
 ' the record structure containing the dungeon level data
 OPEN FileName$ FOR RANDOM SHARED AS #2 LEN = LEN(DungeonRecord)
 RETURN ' exit routine

 ' global error routine
Error.Routine:
 COLOR 7, 0 ' reset ansi
 CLS ' clear screen
 LOCATE 10, 10 ' locate message
 PRINT "The Map Editor Crashed! (Error:" + STR$(ERR) + ")"' print message
 END ' end program

