DECLARE SUB DoCredits ()
TYPE PaletteType
Red AS INTEGER
Green AS INTEGER
Blue AS INTEGER
END TYPE
DECLARE SUB DisplayMenu ()
DECLARE SUB DisplayLogo ()
DECLARE SUB Palette.Set (nColor%, pInfo AS PaletteType)
DECLARE SUB Palette.Get (nColor%, pInfo AS PaletteType)
DECLARE SUB Palette.Fadeout ()
DECLARE SUB Palette.Fadein ()

DoCredits

SCREEN 13: DEFINT A-Z
DIM SHARED Pal AS PaletteType
DIM SHARED pData(0 TO 255, 1 TO 3)

PRINT "Please wait..."
Palette.Fadeout
CLS
DisplayLogo
Palette.Fadein
WHILE INKEY$ <> "": WEND
Palette.Fadeout
DisplayMenu
Palette.Fadein
CHAIN "title.bas"

DEFSNG A-Z
SUB DisplayLogo
  DEF SEG = &HA000
  BLOAD "ddlogo.fsi"
END SUB

DEFINT A-Z
SUB DisplayMenu
  LINE (0, 0)-(319, 44), 201, BF          'This SUB draws the backround
  LINE (0, 45)-(319, 74), 104, BF         'of the main menu screen.
  LINE (0, 75)-(319, 94), 1, BF
  LINE (0, 95)-(319, 109), 9, BF
  LINE (0, 110)-(319, 119), 80, BF
  LINE (0, 120)-(319, 129), 191, BF
  LINE (0, 130)-(319, 144), 120, BF
  LINE (0, 145)-(319, 164), 2, BF
  LINE (0, 165)-(319, 194), 47, BF
  LINE (0, 195)-(319, 199), 70, BF
END SUB

SUB DoCredits
  SCREEN 12                                     ' Change screen modes.

  WHILE INKEY$ <> "": WEND                      ' Clear keyboard buffer.
 
  ' Print misc info on the screen
  LOCATE 9, 31: PRINT "The Legend of Lith 2"
  LOCATE 11, 25: PRINT "By Dark Dreams, Demo Version 1.0"
  LOCATE 13, 15: PRINT "    This game is freeware and may be distributed     "
  LOCATE 14, 15: PRINT "as long as nothing is modified and no fee is charged "
  LOCATE 15, 15: PRINT " This is a short demo version of the upcoming first  "
  LOCATE 16, 15: PRINT "  episode, Betrayal and Bereavement, which will be   "
  LOCATE 17, 15: PRINT "               released as shareware.                "
  LOCATE 19, 26: PRINT "Copyright (c) 1996 Dark Dreams"
  LOCATE 20, 28: PRINT "Created by: Matt Zuchowski"

  WHILE INKEY$ = "": WEND                       ' Wait for key press.
END SUB

SUB Palette.Fadein
DIM tT(1 TO 3)
FOR I = 1 TO 64
WAIT &H3DA, 8
  FOR O = 0 TO 255
    Palette.Get O, Pal
    tT(1) = Pal.Red
    tT(2) = Pal.Green
    tT(3) = Pal.Blue
    IF tT(1) < pData(O, 1) THEN tT(1) = tT(1) + 1
    IF tT(2) < pData(O, 2) THEN tT(2) = tT(2) + 1
    IF tT(3) < pData(O, 3) THEN tT(3) = tT(3) + 1
    Pal.Red = tT(1)
    Pal.Green = tT(2)
    Pal.Blue = tT(3)
    Palette.Set O, Pal
  NEXT O
NEXT I

END SUB

SUB Palette.Fadeout
DIM tT(1 TO 3)
FOR I = 0 TO 255
  Palette.Get I, Pal
  pData(I, 1) = Pal.Red
  pData(I, 2) = Pal.Green
  pData(I, 3) = Pal.Blue
NEXT I
FOR I = 1 TO 64
WAIT &H3DA, 8
  FOR O = 0 TO 255
    Palette.Get O, Pal
    tT(1) = Pal.Red
    tT(2) = Pal.Green
    tT(3) = Pal.Blue
    IF tT(1) > 0 THEN tT(1) = tT(1) - 1
    IF tT(2) > 0 THEN tT(2) = tT(2) - 1
    IF tT(3) > 0 THEN tT(3) = tT(3) - 1
    Pal.Red = tT(1)
    Pal.Green = tT(2)
    Pal.Blue = tT(3)
    Palette.Set O, Pal
  NEXT O
NEXT I
END SUB

SUB Palette.Get (nColor%, pInfo AS PaletteType)
OUT &H3C6, &HFF
OUT &H3C7, nColor%
pInfo.Red = INP(&H3C9)
pInfo.Green = INP(&H3C9)
pInfo.Blue = INP(&H3C9)
END SUB

SUB Palette.Set (nColor%, pInfo AS PaletteType)
OUT &H3C6, &HFF
OUT &H3C8, nColor%
OUT &H3C9, pInfo.Red
OUT &H3C9, pInfo.Green
OUT &H3C9, pInfo.Blue
END SUB

