/**********************************************************************************************************

						LL-IO.C - Input Output module for LANDER.C, the Lunar Lander Game


	DESCRIPTION:	Input Output module for LANDER.EXE (well it's called that as of now).



	COMMENTS:		Some of the code and ideas in the LANDER project was adapted from Tricks Of
					The Game Programming Gurus.


	Components: 	LL-IO.C		-	Implementation file

	Written By:		Joe Lambert
	Date:			06-23-95

	Revisions:
	06-23-95		So it began, stopped with just a ship moving on the screen.
	03-08-96		Added gravity, boundary checking, active fuel and score, crashes,
					number of lives.  Started looking like a real game instead of
					just sprite stuff.
	03-15-96		Broke code into separate modules for graphics functions and the like.
	03-20-96		Added hooks for keyboard and timer.  Broke code into IO module, out
					of near heap space.	
	03-24-96		Added sprite animation, messaging system, and started on fonts.
	10-23-96		Dropped fonts and did clean up.
    11-01-96        Lander went to X2FTP. I'm somebody now, I'm somebody now!!
***********************************************************************************************************/
#include <io.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <bios.h>
#include <fcntl.h>
#include <memory.h>
#include <math.h>
#include <string.h>
#include <malloc.h>
#include "lander.h"


/********************************************************************
	
	Function:
		VOID _INTERRUPT _FAR New_Key_Int(VOID)	

	Description:
		This function links into the keyboard interrupt and takes over.
		It is called when a key is pressed.  
		

	Returns:
		None
		
	Comments:
  
*********************************************************************/
void _interrupt _far New_Key_Int(void)
{
	_asm
	   {
	   sti                    ; re-enable interrupts
	   in al, KEY_BUFFER      ; get the key that was pressed
	   xor ah,ah              ; zero out upper 8 bits of AX
	   mov nRawKey, ax        ; store the key in global
	   in al, KEY_CONTROL     ; set the control register
	   or al, 82h             ; set the proper bits to reset the FF
	   out KEY_CONTROL,al     ; send the new data back to the control register
	   and al,7fh
	   out KEY_CONTROL,al     ; complete the reset
	   mov al,20h
	   out INT_CONTROL,al     ; re-enable interrupts
	   }

// Process the key and update the arrow state table

	switch(nRawKey)
	      {
	      case MAKE_UP:			// UP arrow pressed.
	           {
	           nKeyTable[INDEX_UP]    = 1;
	           } break;
	
	      case MAKE_DOWN:		// DOWN arrow pressed
	           {
	           nKeyTable[INDEX_DOWN]  = 1;
	           } break;
	
	      case MAKE_RIGHT:		// RIGHT arrow pressed
	           {
	           nKeyTable[INDEX_RIGHT] = 1;
	           } break;
	
	      case MAKE_LEFT:		// LEFT arrow pressed
	           {
	           nKeyTable[INDEX_LEFT]  = 1;
	           } break;
	
	      case BREAK_UP:		// UP arrow released
	           {
	           nKeyTable[INDEX_UP]    = 0;
	           } break;
	
	      case BREAK_DOWN:		// DOWN arrow released
	           {
	           nKeyTable[INDEX_DOWN]  = 0;
	           } break;
	
	      case BREAK_RIGHT:		// RIGHT arrow released
	           {
	           nKeyTable[INDEX_RIGHT] = 0;
	           } break;
	
	      case BREAK_LEFT:		// LEFT arrow released
	           {
	           nKeyTable[INDEX_LEFT]  = 0;
	           } break;
	
	      default: break;
	
		}
	

}// End of New_Key_Int function


/********************************************************************
	
	Function:
		INT Get_Input(VOID)	

	Description:
		This function returns true if there is a motion key being
		pressed.
		

	Returns:
		None
		
	Comments:
  
*********************************************************************/
int Get_Input(void)
{

   if (nKeyTable[0] || nKeyTable[1] || nKeyTable[2] || nKeyTable[3])	// Is there a key press

       return(1);	// If a key is being pressed, return ONE
   else
       return(0);	// If no key is being pressed return a ZERO


}// End of Get_Input function


/********************************************************************
	
	Function:
		VOID Timer(INT)	

	Description:
		This function uses the internal timer running at 1.19318MHz.
		This function is passed the number of ticks to wait, if the 
		clock is reprogrammed this function will wait n clicks at n Hz.

	Returns:
		None
		
	Comments:
		The timer can be reprogrammed with...
		0x26D7 for 120 hz
		0x4DAE for 60 hz
		0x965C for 30 hz
		0xE90B for 20 hz
		0xFFFF for 18.2 hz etc...
  
*********************************************************************/
void Timer(int nClicks)
{
	int nTimeLoop;
	for (nTimeLoop = 0; nTimeLoop < nClicks; nTimeLoop++)
	{
		while(!nTimeOut);		// Hang out until timer lets us go
		nTimeOut = 0;
	}
}



/********************************************************************
	
	Function:
		VOID Change_Time(VOID)
	
	Description:
		This function re-programs the timer chip.

					
	Returns:
		None
		
	Comments: Try this to see if it's faster
	
	outp(COUNTER_0,new_count & 0x00ff);
	outp(COUNTER_0,(new_count >> 8) & 0x00ff);
  
*********************************************************************/
void Change_Timer(unsigned int new_count)
{
	_outp(CONTROL_8253, CONTROL_WORD);		// Send the control word, mode 2, binary, least/most
	_outp(COUNTER_0,LOW_BYTE(new_count));	// Write the LEAST significant byte to the counter register
	_outp(COUNTER_0,HI_BYTE(new_count));	// Write the MOST significant byte to the counter registerand
}


/********************************************************************
	
	Function:
		VOID _INTERRUPT _FAR New_Timer_Int(VOID)	

	Description:
		This function links into the timer interrupt and takes over.
		It is called when the timer times out.
		

	Returns:
		None
		
	Comments:
  
*********************************************************************/
void _interrupt _far New_Timer_Int(void)
{
	nTimeOut = 1;		// Set nTimeOut variable
}



