DECLARE SUB fade (z%)
DECLARE FUNCTION delay% (i%)
DECLARE SUB getpal (attr%, R%, G%, B%)
DECLARE SUB putpal (attr%, R%, G%, B%)
DECLARE SUB getitifyawantta (a$)

'Gemtris- free software by Daniel Kalna
'
' I wrote the game to see if I could avoid using basic's
' slow PUT/GET commands.  All the animation in this game
' uses direct writes out the ports to manipulate the palette.

'The game board is a gif file that contains 220 blocks arranged in
' 22x10 grid, each block has its own color attribute that is color black.
' Using an array to represent the game board, all I have to do is change
'the attribute's color to create an effect of falling blocks.

'The GIF loader was written by some unknown author.  I came across the
'code inside an ABC (All Basic Code) magazine.

DEFINT A-Z
SCREEN 13
CLS

DIM cr(255), cg(255), cb(255)
DIM gb(22, 10)
REDIM gbc(22, 10)

pscore = 0
level = 1

start:
 RANDOMIZE TIMER

 IF level = 1 THEN fpymax = 10   'max column
 IF level = 1 THEN fpymin = 1   'min column
 IF level = 2 THEN fpymax = 9   'max column
 IF level = 2 THEN fpymin = 2   'min column
 IF level = 3 THEN fpymax = 8   'max column
 IF level = 3 THEN fpymin = 3   'min column
 GOSUB SETUP

 LOCATE 23, 5: PRINT pscore;
 LOCATE 19, 5: PRINT "Level"; level

 fpx = 0: fpy = 0      'falling piece location on game board (bottom piece)
 falld = 0
 checkf = 0
 falldelay = 4

 WHILE INKEY$ <> "": WEND
 
top:
 k$ = INKEY$
 IF k$ = CHR$(27) THEN GOTO fini
 IF k$ = CHR$(0) + CHR$(75) THEN GOSUB move.left
 IF k$ = CHR$(0) + CHR$(77) THEN GOSUB move.right
 IF k$ = CHR$(0) + CHR$(72) THEN GOSUB rotate.up
 IF k$ = CHR$(0) + CHR$(80) THEN GOSUB rotate.down
 IF k$ = " " OR k$ = CHR$(13) THEN GOSUB piece.to.bottom

 IF delay(falld) > falldelay THEN
   falld = 0
   'check to see if a piece is falling  0=no
   IF fpx = 0 AND checkf = 0 THEN GOSUB drop.piece
   
   'update piece falling
   IF fpx <> 0 THEN GOSUB update.piece
 END IF

start2:
 GOSUB update.display

 IF checkf = 1 THEN
   WHILE checkf = 1
      checkf = 0
      GOSUB check.patterns
      IF checkf = 1 THEN GOSUB trickle.down
   WEND
 END IF

 GOSUB update.display

 IF level = 1 AND pscore > 2000 THEN GOTO new.level
 IF level = 2 AND pscore > 3500 THEN GOTO new.level
 IF level = 3 AND pscore > 5000 THEN GOTO new.level

GOTO top


'===========================================================================
new.level:
  WHILE INKEY$ <> "": WEND
  level = level + 1
  IF level = 4 THEN GOTO fini
 
  fade 3
  CLS
  LOCATE 5, 16: PRINT "Level Over"
  LOCATE 7, 15: PRINT "  Score"
  LOCATE 8, 16: PRINT pscore
  LOCATE 20, 10: PRINT "Press any key."
  WHILE INKEY$ <> "": WEND
  z$ = INPUT$(1)

GOTO start

'===========================================================================
trickle.down:
 'have pieces fall when some have been removed
 trickf = 1
 WHILE trickf = 1
  trickf = 0
  FOR y = 1 TO 10
    FOR x = 1 TO 21
      IF gb(x, y) <> 0 AND gb(x + 1, y) = 0 THEN
         gb(x + 1, y) = gb(x, y): gb(x, y) = 0
         trickf = 1
      END IF
    NEXT x
  NEXT y
  'BEEP: zx$ = INPUT$(1)
  GOSUB update.display
 WEND
RETURN

'===========================================================================
check.patterns:
  REDIM gbc(22, 10)
 
  'check horizontal
  FOR x = 1 TO 22
    FOR y = 1 TO 8
      IF gb(x, y) = gb(x, y + 1) THEN
         IF gb(x, y + 1) = gb(x, y + 2) THEN
            IF gb(x, y) <> 0 THEN
               gbc(x, y) = 1: gbc(x, y + 1) = 1: gbc(x, y + 2) = 1
               checkf = 1
            END IF
         END IF
      END IF
    NEXT y
  NEXT x

  'check vertical
  FOR y = 1 TO 10
    FOR x = 1 TO 20
      IF gb(x, y) = gb(x + 1, y) THEN
         IF gb(x + 1, y) = gb(x + 2, y) THEN
            IF gb(x, y) <> 0 THEN
               gbc(x, y) = 1: gbc(x + 1, y) = 1: gbc(x + 2, y) = 1
               checkf = 1
            END IF
         END IF
      END IF
    NEXT x
  NEXT y

  'check diag up right
  FOR x = 3 TO 22
    FOR y = 1 TO 8
      IF gb(x, y) = gb(x - 1, y + 1) THEN
         IF gb(x, y) = gb(x - 2, y + 2) THEN
            IF gb(x, y) <> 0 THEN
               gbc(x, y) = 1: gbc(x - 1, y + 1) = 1: gbc(x - 2, y + 2) = 1
               checkf = 1
            END IF
         END IF
      END IF
    NEXT y
  NEXT x

  'check diag down right
  FOR x = 1 TO 20
    FOR y = 1 TO 8
      IF gb(x, y) = gb(x + 1, y + 1) THEN
         IF gb(x, y) = gb(x + 2, y + 2) THEN
            IF gb(x, y) <> 0 THEN
               gbc(x, y) = 1: gbc(x + 1, y + 1) = 1: gbc(x + 2, y + 2) = 1
               checkf = 1
            END IF
         END IF
      END IF
    NEXT y
  NEXT x

 FOR x = 1 TO 22
  FOR y = 1 TO 10
    IF gbc(x, y) = 1 THEN gb(x, y) = 0: pscore = pscore + 10
  NEXT y
 NEXT x
 LOCATE 23, 5: PRINT pscore;
 IF pscore > 500 THEN falldelay = 3
 IF pscore > 1000 THEN falldelay = 2
 IF pscore > 1500 THEN falldelay = 1
 IF pscore > 2000 THEN falldelay = 3
 IF pscore > 2500 THEN falldelay = 2
 IF pscore > 3000 THEN falldelay = 1
 IF pscore > 3500 THEN falldelay = 3
 IF pscore > 4000 THEN falldelay = 2
 IF pscore > 4500 THEN falldelay = 1
RETURN

'===========================================================================
rotate.up:
 IF fpx = 0 THEN RETURN
 tmp = gb(fpx - 2, fpy)
 gb(fpx - 2, fpy) = gb(fpx - 1, fpy)
 gb(fpx - 1, fpy) = gb(fpx - 0, fpy)
 gb(fpx - 0, fpy) = tmp
RETURN

'===========================================================================
rotate.down:
 IF fpx = 0 THEN RETURN
 tmp = gb(fpx, fpy)
 gb(fpx, fpy) = gb(fpx - 1, fpy)
 gb(fpx - 1, fpy) = gb(fpx - 2, fpy)
 gb(fpx - 2, fpy) = tmp
RETURN

'===========================================================================
piece.to.bottom:
 IF fpx = 0 THEN RETURN
 FOR x = fpx TO 21
   IF gb(x + 1, fpy) <> 0 THEN EXIT FOR
 NEXT x
 IF x <> fpx THEN
    gb(x, fpy) = gb(fpx, fpy): gb(fpx, fpy) = 0
    gb(x - 1, fpy) = gb(fpx - 1, fpy): gb(fpx - 1, fpy) = 0
    gb(x - 2, fpy) = gb(fpx - 2, fpy): gb(fpx - 2, fpy) = 0
    checkf = 1
 END IF
 fpx = 0
RETURN

'===========================================================================
move.right:
 IF fpx = 0 THEN RETURN
 IF fpy + 1 > fpymax THEN RETURN
 IF gb(fpx, fpy + 1) <> 0 THEN RETURN
 IF gb(fpx - 1, fpy + 1) <> 0 THEN RETURN
 IF gb(fpx - 2, fpy + 1) <> 0 THEN RETURN
 gb(fpx, fpy + 1) = gb(fpx, fpy): gb(fpx, fpy) = 0
 gb(fpx - 1, fpy + 1) = gb(fpx - 1, fpy): gb(fpx - 1, fpy) = 0
 gb(fpx - 2, fpy + 1) = gb(fpx - 2, fpy): gb(fpx - 2, fpy) = 0
 fpy = fpy + 1
RETURN

'===========================================================================
move.left:
 IF fpx = 0 THEN RETURN
 IF fpy - 1 < fpymin THEN RETURN
 IF gb(fpx, fpy - 1) <> 0 THEN RETURN
 IF gb(fpx - 1, fpy - 1) <> 0 THEN RETURN
 IF gb(fpx - 2, fpy - 1) <> 0 THEN RETURN
 gb(fpx, fpy - 1) = gb(fpx, fpy): gb(fpx, fpy) = 0
 gb(fpx - 1, fpy - 1) = gb(fpx - 1, fpy): gb(fpx - 1, fpy) = 0
 gb(fpx - 2, fpy - 1) = gb(fpx - 2, fpy): gb(fpx - 2, fpy) = 0
 fpy = fpy - 1
RETURN

'===========================================================================
update.piece:

 'if piece is on bottom of screen, stop piece
 IF fpx = 22 THEN fpx = 0: checkf = 1: RETURN
  
 IF gb(fpx + 1, fpy) = 0 THEN      'is there room to fall more?  0=yes
    fpx = fpx + 1
    gb(fpx, fpy) = gb(fpx - 1, fpy)
    gb(fpx - 1, fpy) = gb(fpx - 2, fpy)
    gb(fpx - 2, fpy) = gb(fpx - 3, fpy)
    gb(fpx - 3, fpy) = 0
   ELSE
    fpx = 0
    checkf = 1
 END IF
RETURN

'===========================================================================
drop.piece:
 fpx = 3
 fpy = 5
 IF gb(fpx, fpy) <> 0 THEN GOTO fini    'game over, no room
 gb(fpx - 2, fpy) = INT(RND * 5) + 1
 gb(fpx - 1, fpy) = INT(RND * 5) + 1
 gb(fpx, fpy) = INT(RND * 5) + 1
RETURN

'===========================================================================
update.display:
 attr = 15
 FOR y = 1 TO 10
   FOR x = 1 TO 22
     attr = attr + 1
     i = gb(x, y)
     SELECT CASE i
       CASE IS = 0
         putpal attr, 0, 0, 0   'black
       CASE IS = 1
         putpal attr, 63, 0, 0   'red
       CASE IS = 2
         putpal attr, 0, 63, 0   'green
       CASE IS = 3
         putpal attr, 0, 0, 63   'blue
       CASE IS = 4
         putpal attr, 63, 3, 63   'purple
       CASE IS = 5
         putpal attr, 0, 55, 60   'cyan
       CASE IS = 6
         putpal attr, 63, 63, 63   'wild white
     END SELECT
   NEXT x
 NEXT y

RETURN

'===========================================================================
SETUP:
 'clear game board
 FOR x = 1 TO 22
   FOR y = 1 TO 10
     gb(x, y) = 0
   NEXT y
 NEXT x

 fil1$ = "main.gif"
 CALL getitifyawantta(fil1$)

 IF level = 2 THEN
    LINE (125, 11)-(145, 189), 7, BF: LINE (145, 11)-(145, 189), 15
    LINE (291, 11)-(310, 189), 7, BF: LINE (291, 11)-(291, 189), 15
    FOR i = 2 TO 9
      gb(21, i) = INT(RND * 5) + 1
      gb(22, i) = INT(RND * 5) + 1
    NEXT i
 END IF

 IF level = 3 THEN
    LINE (125, 11)-(163, 189), 7, BF
    LINE (163, 11)-(163, 189), 15
    LINE (273, 11)-(310, 189), 7, BF
    LINE (273, 11)-(273, 189), 15
    FOR i = 3 TO 8
      gb(20, i) = INT(RND * 5) + 1
      gb(21, i) = INT(RND * 5) + 1
      gb(22, i) = INT(RND * 5) + 1
    NEXT i
 END IF

RETURN

'===========================================================================
fini:

 WHILE INKEY$ <> "": WEND

 fade 3
 CLS
 LOCATE 5, 16: PRINT "Game Over"
 LOCATE 7, 15: PRINT "Final Score"
 LOCATE 8, 16: PRINT pscore
 LOCATE 20, 10: PRINT "Press any key to exit."
 WHILE INKEY$ <> "": WEND
 z$ = INPUT$(1)

 SCREEN 0, 0, 0
 CLOSE
 END

'===========================================================================

FUNCTION delay (i)
 jj = i
 ticks = 1
 DEF SEG = 0
 FOR ii = 1 TO ticks
  Now = PEEK(&H46C)
  DO: LOOP WHILE PEEK(&H46C) = Now
 NEXT ii
 i = jj + 1
 delay = i
END FUNCTION

SUB fade (z)
SHARED cr(), cg(), cb()

 FOR i = 16 TO 254
   getpal i, cr(i), cg(i), cb(i)
 NEXT i

 cflag = 1
 WHILE cflag = 1
  cflag = 0
  FOR i = 16 TO 254
    IF cr(i) < 43 THEN cr(i) = cr(i) + 1: cflag = 1
    IF cg(i) < 43 THEN cg(i) = cg(i) + 1: cflag = 1
    IF cb(i) < 43 THEN cb(i) = cb(i) + 1: cflag = 1
    putpal i, cr(i), cg(i), cb(i)
  NEXT i
  FOR j& = 1 TO (z * 1000): NEXT j&
 WEND

 cflag = 1
 WHILE cflag = 1
  cflag = 0
  FOR i = 16 TO 254
    IF cr(i) > 0 THEN cr(i) = cr(i) - 1: cflag = 1
    IF cg(i) > 0 THEN cg(i) = cg(i) - 1: cflag = 1
    IF cb(i) > 0 THEN cb(i) = cb(i) - 1: cflag = 1
    putpal i, cr(i), cg(i), cb(i)
  NEXT i
  FOR j& = 1 TO (z * 1000): NEXT j&
 WEND

END SUB

SUB getitifyawantta (a$)
SHARED Xstart, Ystart, xlength, ylength

 DIM Prefix(4095), Suffix(4095), OutStack(4095), ShiftOut(8)
 
 'The following line is for the QB environment(slow).
 DIM Ybase AS LONG, Powersof2(11) AS LONG, WorkCode AS LONG
 
 'For more speed, unremark the next line and remark the one above,
 'before you compile... (Change back when inside the environment.)
 'DIM Ybase AS INTEGER, Powersof2(11) AS INTEGER, WorkCode AS INTEGER
 
 FOR a = 0 TO 7
   ShiftOut(8 - a) = 2 ^ a
 NEXT a
 
 FOR a = 0 TO 11
   Powersof2(a) = 2 ^ a
 NEXT a
 
 OPEN a$ FOR BINARY AS #1
  a$ = "      "
  GET #1, , a$
  IF a$ <> "GIF87a" THEN PRINT "Not a GIF87a file.": END

 GET #1, , TotalX
 GET #1, , TotalY
 GOSUB GetByte

 NumColors = 2 ^ ((a AND 7) + 1)
 NoPalette = (a AND 128) = 0

 GOSUB GetByte
 Background = a

 GOSUB GetByte
 IF a <> 0 THEN PRINT "Bad screen descriptor.": END

 IF NoPalette = 0 THEN P$ = SPACE$(NumColors * 3): GET #1, , P$
 DO
     GOSUB GetByte
     IF a = 44 THEN
         EXIT DO
     ELSEIF a <> 33 THEN
         PRINT "Unknown extension type.": END
     END IF
     GOSUB GetByte
     DO: GOSUB GetByte: a$ = SPACE$(a): GET #1, , a$: LOOP UNTIL a = 0
 LOOP

 GET #1, , Xstart
 GET #1, , Ystart
 GET #1, , xlength
 GET #1, , ylength
 XEnd = Xstart + xlength
 YEnd = Ystart + ylength

 GOSUB GetByte
 IF a AND 128 THEN PRINT "Can't handle local colormaps.": END
 Interlaced = a AND 64
 PassNumber = 0
 PassStep = 8
 GOSUB GetByte
 ClearCode = 2 ^ a
 EOSCode = ClearCode + 1
 FirstCode = ClearCode + 2: NextCode = FirstCode
 StartCodeSize = a + 1: CodeSize = StartCodeSize
 StartMaxCode = 2 ^ (a + 1) - 1: MaxCode = StartMaxCode
 BitsIn = 0: BlockSize = 0: BlockPointer = 1
 x = Xstart: y = Ystart: Ybase = y * 320&

 SCREEN 13: DEF SEG = &HA000
 IF NoPalette = 0 THEN
     OUT &H3C7, 0: OUT &H3C8, 0
     FOR a = 1 TO NumColors * 3: OUT &H3C9, ASC(MID$(P$, a, 1)) \ 4: NEXT
 END IF

 LINE (0, 0)-(319, 199), Background, BF

 DO
     GOSUB GetCode
     IF Code <> EOSCode THEN
         IF Code = ClearCode THEN
             NextCode = FirstCode
             CodeSize = StartCodeSize
             MaxCode = StartMaxCode
             GOSUB GetCode
             CurCode = Code: LastCode = Code: LastPixel = Code
             IF x < 320 THEN POKE x + Ybase, LastPixel
             x = x + 1: IF x = XEnd THEN GOSUB NextScanLine
         ELSE
             CurCode = Code: StackPointer = 0
             IF Code > NextCode THEN EXIT DO 'bad GIF if this happens
             IF Code = NextCode THEN
                 CurCode = LastCode
                 OutStack(StackPointer) = LastPixel
                 StackPointer = StackPointer + 1
             END IF
 
             DO WHILE CurCode >= FirstCode
                 OutStack(StackPointer) = Suffix(CurCode)
                 StackPointer = StackPointer + 1
                 CurCode = Prefix(CurCode)
             LOOP
 
             LastPixel = CurCode
             IF x < 320 THEN POKE x + Ybase, LastPixel
             x = x + 1: IF x = XEnd THEN GOSUB NextScanLine
 
             FOR a = StackPointer - 1 TO 0 STEP -1
                 IF x < 320 THEN POKE x + Ybase, OutStack(a)
                 x = x + 1: IF x = XEnd THEN GOSUB NextScanLine
             NEXT
 
             IF NextCode < 4096 THEN
                 Prefix(NextCode) = LastCode
                 Suffix(NextCode) = LastPixel
                 NextCode = NextCode + 1
                 IF NextCode > MaxCode AND CodeSize < 12 THEN
                     CodeSize = CodeSize + 1
                     MaxCode = MaxCode * 2 + 1
                 END IF
             END IF
             LastCode = Code
         END IF
     END IF
 LOOP UNTIL DoneFlag OR Code = EOSCode
 GOTO tt

'------------------------------------------------------------------------
GetByte:
  a$ = " "
  GET #1, , a$
  a = ASC(a$)
RETURN

'------------------------------------------------------------------------
NextScanLine:
     IF Interlaced THEN
         y = y + PassStep
         IF y >= YEnd THEN
             PassNumber = PassNumber + 1
             SELECT CASE PassNumber
             CASE 1: y = 4: PassStep = 8
             CASE 2: y = 2: PassStep = 4
             CASE 3: y = 1: PassStep = 2
             END SELECT
         END IF
     ELSE
         y = y + 1
     END IF
     x = Xstart: Ybase = y * 320&: DoneFlag = y > 199
RETURN

'------------------------------------------------------------------------
GetCode:
     IF BitsIn = 0 THEN GOSUB ReadBufferedByte: LastChar = a: BitsIn = 8
     WorkCode = LastChar \ ShiftOut(BitsIn)
     DO WHILE CodeSize > BitsIn
         GOSUB ReadBufferedByte: LastChar = a
         WorkCode = WorkCode OR LastChar * Powersof2(BitsIn)
         BitsIn = BitsIn + 8
     LOOP
     BitsIn = BitsIn - CodeSize
     Code = WorkCode AND MaxCode
RETURN

'------------------------------------------------------------------------
ReadBufferedByte:
     IF BlockPointer > BlockSize THEN
         GOSUB GetByte: BlockSize = a
         a$ = SPACE$(BlockSize): GET #1, , a$
         BlockPointer = 1
     END IF
     a = ASC(MID$(a$, BlockPointer, 1)): BlockPointer = BlockPointer + 1
RETURN

'------------------------------------------------------------------------
tt:
 CLOSE #1
 END SUB

SUB getpal (attr%, R%, G%, B%)
 OUT &H3C7, attr%
 R% = INP(&H3C9)
 G% = INP(&H3C9)
 B% = INP(&H3C9)
END SUB

SUB putpal (attr%, R%, G%, B%)
 OUT &H3C8, attr%
 OUT &H3C9, R%
 OUT &H3C9, G%
 OUT &H3C9, B%
END SUB

