/* MKEY
   keyboard interface unit
*/

#include <dpmi.h>
#include "mkey.h"

#define _KB_intr 9

keyarray oldkeyb,keyb;
static _go32_dpmi_seginfo old_rm_kb_vector,
                          new_rm_kb_vector,
                          old_pm_kb_vector,
                          new_pm_kb_vector;

unsigned char keyspressed[20];
unsigned char numkeyspressed;
unsigned char keyevent;

static _go32_dpmi_registers _kb_r;

void pm_kb_handler(void);
void rm_kb_handler(void);

void kb_clearbuf()
{
  numkeyspressed=0;
}

void kb_init()
{
  new_pm_kb_vector.pm_selector=_go32_my_cs();
  new_pm_kb_vector.pm_offset=(int) pm_kb_handler;
  new_rm_kb_vector.pm_selector=_go32_my_cs();
  new_rm_kb_vector.pm_offset=(int) rm_kb_handler;
  keyevent=0;
  memset(keyb,0,128);
  memset(oldkeyb,0,128);
  disable();
  _go32_dpmi_get_protected_mode_interrupt_vector(_KB_intr,
    &old_pm_kb_vector);
  _go32_dpmi_chain_protected_mode_interrupt_vector(_KB_intr,
    &new_pm_kb_vector);
  _go32_dpmi_allocate_real_mode_callback_iret(&new_rm_kb_vector, &_kb_r);
  _go32_dpmi_get_real_mode_interrupt_vector(_KB_intr, 
    &old_rm_kb_vector);
  enable();
}

void kb_exit(void)
{
  disable();
  _go32_dpmi_set_real_mode_interrupt_vector(_KB_intr, 
    &old_rm_kb_vector);
  _go32_dpmi_set_protected_mode_interrupt_vector(_KB_intr, 
    &old_pm_kb_vector);
  _go32_dpmi_free_real_mode_callback(&new_rm_kb_vector);
  enable();
}

unsigned char keypress()
{
  unsigned char k;
  k=keyevent;
  keyevent=0;
  return k;
}

unsigned char keystate(unsigned char k)
{
  unsigned char ok;
  ok=oldkeyb[k];
  oldkeyb[k]=keyb[k];
  if(ok==0) {
    if(keyb[k]==0) return open;
    return pressed;
  }
  if(keyb[k]==1) return held;
  return released;
}

void pm_kb_handler(void)
{
  unsigned char b;
  disable();
  b=inportb(0x60);
  while(kbhit()) getch();
  if((b<128)&&(numkeyspressed<20)&&(oldkeyb[b]==0))
    keyspressed[numkeyspressed++]=b;
  memcpy(oldkeyb,keyb,128);
  if(b>127) keyb[b-128]=0;
  else keyb[b]=1;
  if(b<128) keyevent=1;
  memset(&_kb_r, 0, sizeof(_kb_r));
  _kb_r.x.cs = old_rm_kb_vector.rm_segment;
  _kb_r.x.ip = old_rm_kb_vector.rm_offset;
  _kb_r.x.ss = _kb_r.x.sp = 0;
  enable();
  _go32_dpmi_simulate_fcall_iret(&_kb_r);
}

void rm_kb_handler(void)
{
  unsigned char b;
  disable();
  b=inportb(0x60);
  while(kbhit()) getch();
  if((b<128)&&(numkeyspressed<20)&&(oldkeyb[b]==0))
    keyspressed[numkeyspressed++]=b;
  memcpy(oldkeyb,keyb,128);
  if(b>127) keyb[b-128]=0;
  else keyb[b]=1;
  if(b<128) keyevent=1;
  memset(&_kb_r, 0, sizeof(_kb_r));
  _kb_r.x.cs = old_rm_kb_vector.rm_segment;
  _kb_r.x.ip = old_rm_kb_vector.rm_offset;
  _kb_r.x.ss = _kb_r.x.sp = 0;
  enable();
  _go32_dpmi_simulate_fcall_iret(&_kb_r);
}
