#include <stdio.h>
#include <dpmi.h>
#include <sys\movedata.h>
#include <stdlib.h>
#include <sys\nearptr.h>
#include "mgraph.h"
#include "mfont.h"
#include "mkey.h"
#include <pc.h>

fontset font;
  
char scantoascii[86]=("!!1234567890-=!!qwertyuiop[]!~asdfghjkl:\"~~\\zxcvbnm,.?~*~ ~~~~~~~~~~~~~~!~-!~!+~!~~~~~");

void font_init(char *fname)
{
  FILE *f;
  /* set the characters I couldn't figure out how to represent in the
     initializer */
  scantoascii[1]=27;
  scantoascii[14]=8;
  scantoascii[15]=9;
  scantoascii[28]=13;
  scantoascii[72]=24;
  scantoascii[75]=8;
  scantoascii[77]=26;
  scantoascii[80]=25;
  f=fopen(fname,"rb");
  fread(font,1,sizeof(fontset),f);
  fclose(f);
}

char *input(char *text,int x,int y,byte len,byte col)
{
  char key;
  int bx,j,count;
  bx=x;
  count=0;
  text[0]='\0';
  do {
    while(!kbhit()) {
      box(x,y,x+5,y+5,col,screen);
      waitretrace();
      box(x,y,x+5,y+5,0,screen);
    }
    key=getch();
    if((key>='a')&&(key<='z')) key=key-32;
    if((key==8)&&(count>0)) {
      box(bx,y,x+5,y+5,0,screen);
      text[--count]='\0';
      print(bx,y,col,0,text,screen);
      x=bx+strlen(text)*6;
    }
    if((key<126)&&(key>31)&&(count<len)) {
      text[count++]=key;
      text[count]='\0';
      print(bx,y,col,0,text,screen);
      x=bx+strlen(text)*6;
    }
  } while (key!=13);
  return text;
}

void printchar(unsigned char c,int x,int y,scrntype scrn,byte c1,byte c2)
{
  byte *src;
  byte *dst;
  register byte ty;
  register byte tx;
  c-=33;
  if(c>63) return;
  src=&(font[c][0]);
  dst=&(scrn[x+y*320]);
  for(ty=0;ty<5;ty++) {
    tx=*(src++);
    if(tx&1) {
      *dst=c1;
      *(++dst)=c2;
    } else ++dst;
    if(tx&2) {
      *dst=c1;
      *(++dst)=c2;
    } else ++dst;
    if(tx&4) {
      *dst=c1;
      *(++dst)=c2;
    } else ++dst;
    if(tx&8) {
      *dst=c1;
      *(++dst)=c2;
    } else ++dst;
    if(tx&16) {
      *dst=c1;
      *(++dst)=c2;
    } else ++dst;
    if(tx&32) {
      *dst=c1;
      *(++dst)=c2;
    } else ++dst;
    dst+=314;
  }
}

void print(int x,int y,byte c1,byte c2,char *s,scrntype scrn)
{
  int i;
  for(i=0;i<strlen(s);i++) {
    printchar(s[i],x,y,scrn,c1,c2);
    x+=6;
  }
}

void printnum(int x,int y,byte c1,byte c2,long num,scrntype scrn)
{
  char text[40];
  sprintf(text,"%i",num);
  print(x,y,c1,c2,text,scrn);
}

char *kb_input(char *text,int x,int y,byte len,byte col)
{
  char key;
  int bx,j,count;
  bx=x;
  count=0;
  text[0]='\0';
  do {
    while(!keypress()) {
      box(x,y,x+5,y+5,col,screen);
      waitretrace();
      box(x,y,x+5,y+5,0,screen);
    }
    key=0;
    for(j=1;j<85;j++)
      if(keystate(j)==pressed) {
        key=scantoascii[j];
        j=84;
      }
    if((key>='a')&&(key<='z')) key=key-32;
    if((keystate(LShift)==held)||(keystate(RShift)==held)) {
      if((key>='a')&&(key<='z')) key=key-32;
      if((key>='0')&&(key<='9')) key='!';
    }
    if((key==8)&&(count>0)) {
      box(bx,y,x+5,y+5,0,screen);
      text[--count]='\0';
      print(bx,y,col,0,text,screen);
      x=bx+strlen(text)*6;
    }
    if((key<126)&&(key>31)&&(count<len)) {
      text[count++]=key;
      text[count]='\0';
      print(bx,y,col,0,text,screen);
      x=bx+strlen(text)*6;
    }
  } while (key!=13);
  return text;
}
