;=================== FM SOUND DRIVER ============================
;*YNSOUND /A220 /I5 /R						*
;*	/Axxx:BASE I/O ADRESS /Ixx:IRQ NO /R:hCo[	*
;*	/N:raPU						*
;*^C}[荞݂0.2148ms(1/256)ɐݒ肷			*
;*FNC 0CH3.4375mS(1/16)̊荞݂w肵AhXɔ\	*
;*	 AL=0 DS:DX=vOAhX(RETFŖ߂)	*
;*		AL=1̂ƂԂɖ߂			*
;================================================================

; CRTV غ ֳ

FM_PORT		EQU	0
AFM_PORT	EQU	2
MIX_PORT	EQU	4

print	MACRO	BUFF
	PUSH	DS
	PUSH	AX
	PUSH	DX
	MOV	AX,CS
	MOV	DS,AX
	MOV	DX,OFFSET BUFF
	MOV	AH,09H
	INT	21H
	POP	DX
	POP	AX
	POP	DS
	ENDM

;------------------ Ҳ ۸ -------------------------------
CODE	SEGMENT	PUBLIC
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG	2CH
ENVSEG	DW	?				;ϐ̈̃ZOg
	ORG	80H
ARGC	DB	?				;R}hC
ARGV	DB	127	DUP(?)			;R}hC
	ORG	100H				;COM	̧
START:	JMP	DRVINIT				;INT40Zbg[`
;========= BGM-DRV ۰ غ  ٰ (INT40)============
DRV_IO:	CLI					;غ STOP
	PUSH	BX
	MOV	BL,AH
	SHL	BL,01
	XOR	BH,BH
	ADD	BX,OFFSET IO_TBL
	CALL	CS:[BX]
	POP	BX
	STI					;غ ON
	IRET
IO_TBL	DW	IO_INIT,NOISE_SET,SOUND_SET,VSYNC_START,ALL_STOP
	DW	SOUND_CODE,BGM_SET,BGM_START,BGM_END,FEAD_OUT
	DW	FLAG_READ,FMVOL_SET,ADR_SET
;------------ {[h -----------------------
IO_RET:	XOR	AX,AX				;TEh{[h
	RET
;------------ INT 62Hݒ ----------------------
INT62H_SET:
	CALL	TIMER_INIT
	XOR	AX,AX
	RET
;------------ INT 62H ----------------------
INT62H_CLS:
	CALL	TIMER_STOP
	XOR	AX,AX
	RET
;-------------  ٰ (AH=00) ---------------
;AH=0
IO_INIT:
	PUSH	DS
	PUSH	AX
	PUSH	SI
	MOV	BYTE PTR CS:SOU_NO,0FFH		;R[h(FF:~)
	MOV	BYTE PTR CS:WAON,1		;ܵݽ 
	CALL	DATA_INIT
	MOV	AX,CS
	MOV	DS,AX
;----------- nokRݒ ------------------
	MOV	DX,BASE_ADR			;raPŨx[XAhX
	ADD	DX,AFM_PORT			;nokR@SIy[^[h
	MOV	AX,0105H
	CALL	FMOUT_PROC
	MOV	AX,3F04H
	CALL	FMOUT_PROC
	MOV	AX,01				;{[h
	POP	SI
	POP	AX
	POP	DS
	RET

;-------------- ɲ ò ٰ (AH=01) ---------------
;AH=1:AL=ɲ  (Noise Period)
NOISE_SET:
	RET					;

;------ SOUND START ADRESS SET (AH=02) ---------------
;AH=02: DS:SI= ް ĳ ڽ
SOUND_SET:
	PUSH	AX
	MOV	AX,DS
	MOV	CS:SOU_SEG,AX
	MOV	CS:SOU_OFF,SI
	POP	AX
	RET
;----^C}[` rs`qs(AH=03) ---------------
;AH=03:AL=NUL
VSYNC_START:
	PUSH	DS
	PUSH	ES
	PUSH	AX
	PUSH	BX
	PUSH	DX
	MOV	BYTE PTR CS:CHG_FLG,0		;yt𖳎
	CALL	TIMER_INIT
;----- ʉp^C}[Zbg ------------------
	MOV	AX,351CH			;擾
	INT	21H
	MOV	CS:SINT_OFF,BX			;AhXi[
	MOV	CS:SINT_SEG,ES
	MOV	AX,CS
	MOV	DS,AX
	MOV	DX,OFFSET LFO_CONTROL		;荞݃[`Zbg
	MOV	AX,251CH			;荞ݔԍ
	INT	21H
	POP	DX
	POP	BX
	POP	AX
	POP	ES
	POP	DS
	RET
;-------------- ALL STOP     (AH=04) ---------------
;AH=04:AL=NUL
ALL_STOP:
	PUSH	DS
	PUSH	ES
	PUSH	AX
	PUSH	BX
	PUSH	DX
	CALL	TIMER_STOP
	LDS	DX,DWORD PTR CS:SINT_OFF	;AhXǂ݂
	MOV	AX,251CH			;荞ݔԍǂ݂
	INT	21H
;--------- [N ------------------------
	MOV	AX,CS
	MOV	DS,AX				;DS=CS
	MOV	BYTE PTR SOUND_FLG,0		;ʉaJE^[
	CALL	DATA_INIT			; ް 
	MOV	AH,05
ASLOP1:	CALL	KEYSUB				;KEY OFF
	DEC	AH
	JNL	ASLOP1
	CALL	FMCOL_INIT			;el[XNA
	POP	DX
	POP	BX
	POP	AX
	POP	ES
	POP	DS
	RET
;-------------- SOUND CODE SET (AH=05) ---------------
;AH=05:AL=CODE
SOUND_CODE:
	PUSH	AX
	CALL	SOUND_ON
	POP	AX
	RET

;-------- BGM START ADRESS SET (AH=06) ---------------
;AH=06 AL=ܵݽ(6 ķ  į) DS:SI=BGM ް ĳ ڽ
BGM_SET:
	PUSH	AX
	MOV	BYTE PTR CS:WAON,6		;ܵݽ 
	MOV	AX,DS
	MOV	CS:BGM_SEG,AX
	MOV	CS:BGM_OFF,SI
	POP	AX
	RET
;-------------- BGM START      (AH=07) ---------------
;AH=07:AL=NUL
BGM_START:
	PUSH	DS
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	SI
	CALL	DATA_INIT			;[N
	CALL	FMCOL_INIT ;el̉FɂOԂZbghCo[̃[N킹
	MOV	DS,CS:BGM_SEG
	MOV	BX,CS:BGM_OFF
	MOV	SI,10H				;p[gf[^̃wb_
BSLOP1:	MOV	AX,[SI+BX]			;BGM ް ͯ12޲Ħ BGM_ADD
	ADD	AX,BX				;ItZbĝC
	MOV	CS:BGM_ADD-10H[SI],AX		;( ߰ ĳڽ ʲò)
	INC	SI
	INC	SI
	CMP	SI,1CH
	JB	BSLOP1
	MOV	SI,02H				;Ff[^ItZbg
	MOV	AX,[SI+BX]
	ADD	AX,BX				;ItZbĝC
	MOV	CS:FM_DATA,AX
	INC	SI
	INC	SI
	MOV	AX,[SI+BX]
	ADD	AX,BX				;ItZbĝC
	MOV	CS:SG_DATA,AX
	MOV	AX,0800H
	XOR	AX,AX				;̒Zbg
	MOV	CX,6
	MOV	BX,OFFSET ONNCYOU
BSLOP3:	MOV	CS:[BX],AX
	INC	BX
	INC	BX
	LOOP	BSLOP3
	MOV	BYTE PTR CS:TIMER_FLG,3FH	;^C}[`aƂ삳
	OR	BYTE PTR CS:CHG_FLG,02H		;ttOZbg
	AND	BYTE PTR CS:CHG_FLG,0FEH	;̪ޱătONA
	MOV	BYTE PTR CS:TMP_SPD,1		;e|JE^[ōl
	MOV	BYTE PTR CS:TMP_CNT,1		;JE^[ōl
	POP	SI
	POP	CX
	POP	BX
	POP	AX
	POP	DS
	RET

;-------------- BGM END        (AH=08) ---------------
;AH=08:AL=NUL
BGM_END:
	TEST	BYTE PTR CS:CHG_FLG,02H		;ttOf
	JE	BEJP1
	CLD
	PUSH	DS
	PUSH	ES
	PUSH	AX
	PUSH	CX
	PUSH	DI
	MOV	AX,CS
	MOV	DS,AX				;DS=CS
	MOV	ES,AX
	XOR	AX,AX
	MOV	CX,35
	MOV	DI,OFFSET FM_DATA
	REP	STOSW
	MOV	CX,45
	MOV	DI,OFFSET VOLUM
	REP	STOSW
	MOV	AH,05
BELOP1:	CALL	KEYSUB				;KEY OFF
	DEC	AH
	JNL	BELOP1
	CALL	FMCOL_INIT			;el[XNA
	AND	BYTE PTR CS:CHG_FLG,0FDH	;ttONA
	POP	DI
	POP	CX
	POP	AX
	POP	ES
	POP	DS
BEJP1:	RET

;-------------- FEAD OUT(AH=09) ---------------
;AL=̪ޱ ް(7-4:ݶخ 3-0:ݶ )
FEAD_OUT:
	TEST	BYTE PTR CS:CHG_FLG,02H		;ttOf
	JE	FOJP1
	PUSH	DS
	PUSH	AX
	PUSH	BX
	PUSH	CX				;CALL CX ¶ò
	MOV	BX,CS
	MOV	DS,BX
	AND	BYTE PTR CHG_FLG,0FEH		;tF[hAEgtOZbg
	MOV	AH,91H
	XCHG	AH,AL
	MOV	BX,WAONW
	DEC	BX
FOLOP1:	PUSH	AX
	CALL	BGMCHG
	POP	AX
	DEC	BX
	JNL	FOLOP1
	OR	CHG_FLG,01H			;tF[hAEgtOZbg
	POP	CX
	POP	BX
	POP	AX
	POP	DS
FOJP1:	RET

;------------- FLAG ǂ݂ (AH=0AH) ---------------
FLAG_READ:
	XOR	AH,AH
	MOV	AL,CS:CHG_FLG			;tOǂݏo
	RET			;(0ޯON:̪ޱ 1:BGMt 2:ʉ)

;---------- elʐݒ (AH=0BH) ---------------
FMVOL_SET:
	PUSH	DS
	PUSH	ES
	MOV	CS:FMVOL,AL			;el̉ʂύX
	MOV	AX,CS
	MOV	DS,AX				;DS=CS
	MOV	ES,BGM_SEG			;BGM ð 
	XOR	AH,AH
FSLOP1:	CALL	FVOLUM				;ʋύX
	INC	AH
	CMP	AH,03
	JNE	FSLOP1
	POP	ES
	POP	DS
	RET

;--- 3.4375mS荞݃AhXݒ(AH=0CH) ------
ADR_SET:
	CMP	AL,01
	JE	@F
	MOV	WORD PTR CS:TIMEINT_ADR,DX
	MOV	WORD PTR CS:2[TIMEINT_ADR],DS
	RET
@@:	MOV	AX,OFFSET TIMEINT_PROC		;
	MOV	WORD PTR CS:TIMEINT_ADR,AX
	MOV	AX,CS
	MOV	WORD PTR CS:2[TIMEINT_ADR],AX
	RET

;=========== ALL DATA INIT ٰ ======================
;LFO,VOLUM  æ  
;׽ CLI  ޯ
DATA_INIT:
	CLD
	PUSH	ES
	PUSH	AX
	PUSH	CX
	PUSH	DI
	MOV	AX,CS
	MOV	ES,AX
	XOR	AX,AX
	MOV	CX,47				;10 ݽ
	MOV	DI,OFFSET READFLG
	REP	STOSW
	MOV	CX,37
	MOV	DI,OFFSET ONNCYOU
	REP	STOSW
	MOV	CX,45
	MOV	DI,OFFSET VOLUM
	REP	STOSW
	POP	DI
	POP	CX
	POP	AX
	POP	ES
	RET

;=========== elF ================
;WX^ύX
FMCOL_INIT:
	PUSH	DS
	PUSH	ES
	PUSH	AX
	PUSH	CX
	MOV	AX,CS
	MOV	DS,AX			;DS=CS
	MOV	ES,BGM_SEG		;BGM ð 
	XOR	AH,AH			;AH=aԍ
	MOV	CX,6
@@:	CALL	FM_SOU_INIT
	INC	AH
	LOOP	@B
	POP	CX
	POP	AX
	POP	ES
	POP	DS
	RET

;-------- F[` ----------------------------------
;FM̉FOԂ̉FɕύXKEY OFFԂɂ
;AH=aԍ
FM_SOU_INIT:
	PUSH	AX
	PUSH	BX
	PUSH	CX
	CALL	KEYSUB				;OFF
	MOV	BL,AH
	XOR	BH,BH
	MOV	SOU_COL[BX],BH		;FOԃZbg(NAȂĂO)
;------- T.L INIT-----------------------
	MOV	DX,CS:BASE_ADR
	MOV	AX,3F40H			;sDkNA
	CALL	FMOUT_PROC
	MOV	AL,43H
	CALL	FMOUT_PROC
	MOV	AL,48H
	CALL	FMOUT_PROC
	MOV	AL,4BH
	CALL	FMOUT_PROC
;------- S.L,R.R INIT ------------------
	MOV	AX,0FF80H			;rk,qqNA
	CALL	FMOUT_PROC
	MOV	AL,83H
	CALL	FMOUT_PROC
	MOV	AL,88H
	CALL	FMOUT_PROC
	MOV	AL,8BH
	CALL	FMOUT_PROC
	MOV	AH,BL
	OR	AH,0F0H
	CALL	KEYSUB				;ON(Ԃ𔭐[X)
	AND	AH,0FH
	CALL	KEYSUB				;OFF
	POP	CX
	POP	BX
	POP	AX
	RET

;============ ײް Ҳ =================
BGMINT:
	MOV	CS:SS_SAV1,SS
	MOV	CS:SP_SAV1,SP
	MOV	SS,CS:CS_SAVE
	MOV	SP,OFFSET STACK_W
	PUSHF
	PUSH	DS
	PUSH	ES
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	CALL	BGM_CONTROL
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	POP	ES
	POP	DS
	POPF
	MOV	SP,CS:SP_SAV1
	MOV	SS,CS:SS_SAV1
	RET

;========== y ===================
BGM_CONTROL:
	MOV	AX,CS
	MOV	DS,AX				;DS=CS
	MOV	ES,BGM_SEG			;BGM ð 
;FM&SSG BGM ۰
	XOR	BX,BX		;FM ݹ	BX=ܵ 
BLOOP4:	MOV	BYTE PTR KEY_SW,00H		;ON OFF ż
	MOV	SI,BX
	SHL	SI,01
	DEC	ONNCYOU[SI]			; Ŷ޻ - 1
	JG	LOPEND				; Ŷ޻ > 0 ?
	MOV	DI,BGM_ADD[SI]
RETUR1:	MOV	AX,ES:[DI]			;ް к
	CMP	AL,80H
	JB	BJUMP4
	JMP	SHORT SETSUB			;;aflȊO̐ݒ JUMP
BJUMP4:	TEST	AH,80H				;7ޯ ON?
	JNE	BJUMP8
	PUSH	AX				;	    (KEY OFF ò)
	MOV	AH,BL
	CALL	KEYSUB				;KEY OFF
	MOV	BYTE PTR KEY_SW,01		;ON OFF 
	POP	AX
BJUMP8:	AND	AH,07FH				;װ   ׸ަ ر
	PUSH	BX
	PUSH	AX
	MOV	BL,AH
	XOR	BH,BH
	MOV	AL,BGM_LON[BX]			; Ŷ޻ (Ľ) к
	MOV	AH,BH				;AH=0
	MOV	ONNCYOU[SI],AX			; Ŷ޻ 
	POP	AX
	POP	BX
	TEST	AL,0FH				;xH
	JNE	BJUMP5
	MOV	AH,BL
	CALL	KEYSUB				;L[̋OFF
	JMP	SHORT BJUMP9
BJUMP5:	MOV	AH,BL
	CALL	OTOOUT				; ް خ
	CMP	BYTE PTR KEY_SW,0
	JE	BJUMP9
	MOV	CL,BL
	OR	CL,0F0H
	MOV	AH,CL
	CALL	KEYSUB				;KEY ON
BJUMP9:	INC	DI
	INC	DI
	MOV	BGM_ADD[SI],DI
LOPEND: INC	BX
	CMP	BL,WAON
	JAE	BJUMP7
	JMP	BLOOP4
BJUMP7:	RET
; --------------- aflȊÕf[^ݒ -------------------
;ݺ ޷Ų  BX,SI,DI(PUSH),AX ް ֳŲķ ݺ޷
SETSUB: INC	DI				;· ް ߲ ½
	INC	DI
	PUSH	DI
	PUSH	BX
	MOV	BL,AL
	AND	BL,70H				;ޮ 4ޯ ƽ(7ޯ OFF)
	MOV	CL,03
	SHR	BL,CL				;BL=BL/16*2(3ޯ з )
	MOV	DI,BX
	POP	BX
	CALL	CS:COMADR[DI]
	POP	DI
	JMP	RETUR1
COMADR	DW	BGMVOL,BGMCHG,BGMCOL,BGMSPD,BGM_JL,BGMSET,BGM_NOISE,BGMFLG
;------ ح ݺ (80H)--------
BGMVOL:	ADD	AH,FEADCNT[BX]
	JG	VOLJP2			;ʂ}CiXH
	MOV	AH,BH			;BH=0
	JMP	SHORT BGMVO2
VOLJP2:	CMP	AH,0FH			;ʂPTȏォH
	JBE	BGMVO2
	MOV	AH,0FH
BGMVO2:	MOV	VOLUM[BX],AH
	MOV	AH,BL
	CALL	FVOLUM
	RET
;------ ح  ݺ (90H,91H)---------
BGMCHG:	TEST	BYTE PTR CHG_FLG,01	;OR}h̃tF[hAEgH
	JNE	CHGJP3
	AND	AL,01H			;tF[hJE^[͏IɂOɖ߂邽ߏ̕Kv
	JNE	CHGJP1				;0ޯ ON
	INC	AL				;AL=1
	JMP	SHORT CHGJP2
CHGJP1:	NEG	AL				;AL=0FFH(-1)
CHGJP2:	MOV	CHGLEV[BX],AL
	XOR	AL,AL				;AL=0
	MOV	CL,04				;AH 0-3AL 4-7AH 
	SHR	AX,CL
	MOV	CL,02				;ݶ ޶ *4  
	SHR	AL,CL
	MOV	CHG_N[BX],AH			;ݶ  
	MOV	CHGCNT[BX],AL			;ݶ ޶ (1ݶ ޶)
	MOV	CHG_W[BX],AL			;ݶ ޶ݦ ܰ 
CHGJP3:	RET
;------ Ȳ ݺ (A0H)----------------
BGMCOL:	MOV	SOU_COL[BX],AH
	MOV	AH,BL
	CALL	FM_SOU
	RET
;------  ݺ (B0H)----------------
BGMSPD:	MOV	AL,AH
	CALL	TIMER_TMP
;+++	out_FM	26H,AL				;ϰ 
	RET
;------ ެ&ٰ (CxH)--------------
BGM_JL:	POP	DX				;RETڽ ɳ
	POP	DI				;DI ޽
	CMP	AL,0C1H
	JE	JL_JP1
	CMP	AL,0C2H
	JE	JL_JP2
	CMP	AL,0C3H
	JE	JL_JP3
	MOV	DI,JL_D0[SI]			;C0 ޯ
JL_RET:	PUSH	DI
	PUSH	DX				; ޽
	RET
JL_JP1:	DEC	JL_CNT[BX]			;C1ޯ
	JE	JL_RET				;0ķ
	MOV	DI,JL_D1[SI]
	JMP	SHORT JL_RET
JL_JP2:	MOV	JL_D3[SI],DI			;C2 ޯ :D3 ڽ 
	MOV	DI,JL_D2[SI]
	JMP	SHORT JL_RET
JL_JP3:	CMP	JL_D3[SI],00			;C3 ޯ
	JE	JL_RET				;0ķ
	MOV	DI,JL_D3[SI]
	JMP	SHORT JL_RET
;------ ڽ  (DxH)-----------------
BGMSET:	POP	DX
	POP	DI
	PUSH	DI
	PUSH	DX
	CMP	AL,0D1H
	JE	SETJP1
	CMP	AL,0D2H
	JE	SETJP2
	MOV	JL_D0[SI],DI			;D0 ޯ
	RET
SETJP1:	MOV	JL_CNT[BX],AH			;D1 ޯ :ٰ  
	MOV	JL_D1[SI],DI
	RET
SETJP2:	MOV	JL_D3[SI],00H			;D2 ޯ :D3 0ر
	MOV	JL_D2[SI],DI
	RET
;-------- Noise g@ύX (E0H) -----------------------------
BGM_NOISE:
	RET
;-------- gR}hGA(F0H) ----------------------------
BGMFLG:	MOV	CS:ADR_NO,AH			;݂͎s߈ʒuftO
	RET

;---------------- FM ݼò ---------------------------------
;	AH=ܵ ݺ޳(0-5) Ȳ ݺ޳ SOU_COL
FM_SOU:	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	CALL	KEYSUB				;OFF
	MOV	BL,AH
	XOR	BH,BH
	MOV	BL,SOU_COL[BX]			;Ȳ ۰
	MOV	CL,05H
	SHL	BX,CL				;BX*32
	ADD	BX,FM_DATA			;Ȳް ͯަ к
	MOV	SI,BX
;---------- o̓|[g`FbN -----------------
	MOV	DX,BASE_ADR			;o̓|[gǂ݂
	CMP	AH,03
	JB	@F
	SUB	AH,03
	ADD	DX,AFM_PORT			;gelɕύX
;---------- NA ---------------------------
@@:	MOV	BL,ES:14H[SI]			;FB/CONNECT
	MOV	BH,ES:15H[SI]
	AND	BX,0101H			;CONNECT̂
	SHL	BL,01
	OR	BL,BH				;()
	XOR	BH,BH
	MOV	CH,CONNECT[BX]			;ر 
	ADD	AH,40H
	MOV	AL,AH				;AhXALɃZbg
	MOV	AH,3FH
	XOR	BX,BX
FLOOP4:	SHR	CH,01
	JNB	@F				;ر ޲ Ѽ
	CALL	FMOUT_PROC
@@:	ADD	AL,OPLTBL[BX]			;SB16Iy[^AhX
	INC	BX
	CMP	BL,4
	JB	FLOOP4
	MOV	BYTE PTR KEY_SW,01		;  ON OFF 
	MOV	AH,CL
	ADD	AL,80H-0BH			;AL=0C0Hɂ
;---------- FB/CONNECT -------------------------
	MOV	AH,ES:14H[SI]
	CALL	FMOUT_PROC
	MOV	AH,ES:15H[SI]
	ADD	AL,3
	CALL	FMOUT_PROC
	SUB	AL,0A0H+3			;DT/MULTI ڸ
;--------- MULTI -------------------------------
	XOR	BX,BX
FLOOP1:	MOV	AH,ES:[SI]			;DT/MULTI
	CALL	FMOUT_PROC
	INC	SI
	ADD	AL,OPLTBL[BX]			;SB16Iy[^AhX
	INC	BX
	CMP	BL,4
	JB	FLOOP1
;--------- T.L ---------------------------------
	ADD	AL,40H-0BH			;T.L ޽
	ADD	SI,04H
;--------- AR/DR -------------------------------
	XOR	BX,BX
FLOOP2:	MOV	AH,ES:[SI]			;`qǂ݂
	CALL	FMOUT_PROC
	INC	SI
	ADD	AL,OPLTBL[BX]			;SB16Iy[^AhX
	INC	BX
	CMP	BL,4
	JB	FLOOP2
	ADD	AL,20H-0BH
;---------- SL/RR ------------------------------
	XOR	BX,BX
FLOOP3:	MOV	AH,ES:[SI]			;SL/RR
	CALL	FMOUT_PROC
	INC	SI
	ADD	AL,OPLTBL[BX]			;SB16Iy[^AhX
	INC	BX
	CMP	BL,4
	JB	FLOOP3
	ADD	AL,60H-0BH
;------------ WS -------------------------------
	XOR	BX,BX
FLOOP5:	MOV	AH,ES:[SI]			;SL/RR
	CALL	FMOUT_PROC
	INC	SI
	ADD	AL,OPLTBL[BX]			;SB16Iy[^AhX
	INC	BX
	CMP	BL,4
	JB	FLOOP5
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	JMP	FVOLUM
	RET

;-------------------- FM خ  -----------------------------
;	ر TL  ݺ
;	AH=ܵ ݺ޳(0-5) خ VOLUM
FVOLUM:	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	MOV	BL,AH
	XOR	BH,BH
	MOV	BL,SOU_COL[BX]			;Ȳ ۰
	MOV	CL,05H
	SHL	BX,CL				;BX*32
	ADD	BX,FM_DATA			;Ȳް ͯަ к
	MOV	SI,BX
	MOV	CL,AH				;aԍi[
;----------- o̓|[g`FbN ----------------
	MOV	DX,BASE_ADR			;o̓|[gǂ݂
	CMP	AH,03
	JB	@F
	SUB	AH,03
	ADD	DX,AFM_PORT			;gelɕύX
;----------- ʁskZbg ------------------
@@:	MOV	BL,ES:14H[SI]			;FB/CONNECT
	MOV	BH,ES:15H[SI]			;FB/CONNECT
 	AND	BX,0101H			;CONNECT 
	SHL	BL,01
	OR	BL,BH
	XOR	BH,BH
	MOV	CH,CONNECT[BX]			;ر 
	MOV	BL,CL				;̘aԍZbg
	MOV	AL,AH
	ADD	AL,40H				;TL ADRESS
	MOV	CL,15				;15(VOLUM=MAX15)
	SUB	CL,VOLUM[BX]			;AL=VOLUM 
	SHL	CL,01H				;AL*4
	SHL	CL,01H
	ADD	CL,CS:FMVOL			;FM̉
	CMP	CL,3FH				;I[o[t[`FbN
	JB	@F
	MOV	CL,3FH
@@:	ADD	SI,04H				;ް TL ĳ
	XOR	BX,BX				;CL  
FVLOP1:	MOV	AH,ES:[SI]			;T.L ޼
	SHR	CH,01
	JNB	FVJP1				;ر ޲ Ѽ
	MOV	BH,AH
	AND	AH,3FH				;sk̂
	AND	BH,0C0H				;jr̂
	ADD	AH,CL				;ر خ 
	CMP	AH,3FH				;ől`FbN
	JB	@F
	MOV	AH,3FH
@@:	OR	AH,BH				;skCjr
	XOR	BH,BH				;agOɖ߂
FVJP1:	CALL	FMOUT_PROC
	INC	SI
	ADD	AL,OPLTBL[BX]			;SB16Iy[^AhX
	INC	BX
	CMP	BL,4
	JB	FVLOP1
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	RET

;-------------------  خ --------------------------------
;	AH=ܵ ݺ޳ AL=ݶ ް
OTOOUT:	PUSH	AX
	PUSH	BX
	PUSH	CX
;----------- gZbg ----------------------
	MOV	BL,AL
	XOR	BH,BH
	MOV	CH,FONTBLH[BX]			;ʽ 
	AND	BL,0FH
	MOV	CL,FONTBLL[BX]
	MOV	BL,AH
	SHL	BX,01
	OR	CH,20H				;KEY ON FLGZbg
	MOV	ONNKAI[BX],CX
	POP	CX
	POP	BX
	POP	AX
	RET

;-------------------- KEY ON/OFF -------------------------------
; AH=0F?H KEY ON /00?H KEY OFF
; FM/SSG   ٰŲ 
KEYSUB:	PUSH	AX
	PUSH	BX
	PUSH	DX
	MOV	BL,AH
	AND	BX,0FH
	SHL	BX,01
	MOV	CX,ONNKAI[BX]			;gǂ݂
;---------- L[nmCnee`FbN -----------
	CMP	AH,0F0H			;XL[ItO̓ZbgĂ
	JAE	@F
	XOR	CX,CX
;----------- o̓|[g`FbN ----------------
@@:	AND	AH,0FH				;L[tONA
	MOV	DX,BASE_ADR			;o̓|[gǂ݂
	CMP	AH,03
	JB	@F
	SUB	AH,03
	ADD	DX,AFM_PORT			;gelɕύX
;----------- f[^Zbg ----------------------
@@:	MOV	AL,AH
	ADD	AL,0A0H
	MOV	AH,CL
	CALL	FMOUT_PROC
	ADD	AL,010H
	MOV	AH,CH
	CALL	FMOUT_PROC
	POP	DX
	POP	BX
	POP	AX
	RET

;====== Gx[vʉ ===================
LFO_CONTROL:
	CLI
	MOV	CS:SS_SAV1,SS
	MOV	CS:SP_SAV1,SP
	MOV	SS,CS:CS_SAVE
	MOV	SP,OFFSET STACK_W
	PUSHF
	PUSH	DS
	PUSH	ES
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	CALL	INTSOUND_MAIN			;ʉ`FbN
	MOV	AX,CS
	MOV	DS,AX				;DS=CS
	MOV	CX,6		;f[^9ms̊荞݂Ă邽
VJUMP7:	PUSH	CX
VJUMP4:	MOV	ES,BGM_SEG			;BGM ð 
	XOR	BX,BX				;BX=ܵ 
VLOOP4:	MOV	SI,BX
	SHL	SI,01
;------  LFO ۰ ٰ -------------------
	CMP	CHGCNT[BX],00H
	JE	VJUMP6
	CALL	CHGVOL				;خ ݺ ٰ
VJUMP6:	INC	BX
	CMP	BL,WAON
	JB	VLOOP4
	POP	CX
	LOOP	VJUMP7
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	POP	ES
	POP	DS
	POPF
	MOV	SP,CS:SP_SAV1
	MOV	SS,CS:SS_SAV1
	STI
	PUSH	WORD PTR CS:SINT_SEG
	PUSH	WORD PTR CS:SINT_OFF
	RETF					;INT1CHɃWv
;	IRET					;_~[

;------ خ ݺ ٰ( No 90H,91H)-------
CHGVOL:	DEC	CHG_W[BX]			;ݶ TIME
	JG	CVJP1
	DEC	CHG_N[BX]			;ݶ خ
	JNL	CVJP2				;ϲŽ?
	MOV	BYTE PTR CHGCNT[BX],00H
	MOV	BYTE PTR FEADCNT[BX],00H	;tF[hJE^[NA
	TEST	BYTE PTR CHG_FLG,01		;OR}hH
	JE	CVJP1
	AND	BYTE PTR CHG_FLG,0FEH		;tF[hAEgI(tONA)
	MOV	AX,0800H			;NA
	CALL	BGM_END				;BGM̃Xgbv
	JMP	SHORT CVJP1
CVJP2:	MOV	AH,CHGCNT[BX]			;MOV CHG_W,CHGCNT
	MOV	CHG_W[BX],AH
	MOV	AH,CHGLEV[BX]			;ݶ (90H=01 91H=0FFH)
	ADD	FEADCNT[BX],AH			;tF[hJE^[ύX
	ADD	AH,VOLUM[BX]
	JG	CVJP3				;خ ϲŽ?
	MOV	AH,BH				;AH=0
	JMP	SHORT CVJP4
CVJP3:	CMP	AH,0FH				;خ 15?
	JNA	CVJP4
	MOV	AH,0FH
CVJP4:	CALL	BGMVO2				;خ 
	MOV	SI,BX
	SUB	SI,03				;SSG VOLUM LFO  خ 
	JB	CVJP1
	SHL	SI,01
	MOV	AX,SSG_V[SI]
	ADD	AH,CHGLEV[BX]			;ݶ (90H=01 91H=0FFH)
	JNL	CVJP6				;خ ϲŽ?
	MOV	AH,BH				;AH=0
	JMP	SHORT CVJP7
CVJP6:	CMP	AH,0FH				;خ 15?
	JNA	CVJP7
	MOV	AH,0FH
CVJP7:	MOV	SSG_V[SI],AX			;خ 
CVJP1:	RET

;@===============================================================
;*	ʉ[`					*
;================================================================

;============= ʉ荞݃Rg[ =======================
;荞݌ʉRg[
INTSOUND_MAIN:
	CMP	BYTE PTR CS:SOU_NO,0FFH		;ʉԁH
	JE	@F
	DEC	BYTE PTR CS:SOU_CNT
	JNE	@F
	MOV	AL,CS:SOU_NO			;̌ʉ
	CALL	SOUND_ON
@@:	RET

;============== ʉ ======================================
;AL=ʉԍ
;AXȊOύX
SOUND_ON:
	PUSH	DS
	PUSH	BX
	PUSH	SI
	OR	BYTE PTR CS:CHG_FLG,04H		;ʉ
	AND	AL,AL				;ʉNAH
	JNE	@F
	AND	BYTE PTR CS:CHG_FLG,0FBH	;ʉtONA
@@:	MOV	BL,AL				;ʉԍ
	XOR	AH,AH
	SHL	AX,01				;Pf[^PUoCg
	SHL	AX,01
	SHL	AX,01
	SHL	AX,01
	MOV	DS,CS:SOU_SEG			;ʉf[^AhXǂ݂
	ADD	AX,CS:SOU_OFF
	MOV	SI,AX
	MOV	AL,0DH[SI]			;ʉԍ
	MOV	CS:SOU_NO,AL
	MOV	AL,0EH[SI]			;ʉEGCg
	MOV	CS:SOU_CNT,AL
	XOR	AL,AL
	CALL	SOUNDFM_SET
	POP	SI
	POP	BX
	POP	DS
	RET

;=============== Fݒ =======================================
;AL=Zbgaԍ(0`5)
;BL=ʉԍ
;DS:SI=f[^AhX
;AX,SIύX
SOUNDFM_SET:
	PUSH	CX
	PUSH	DX
;----------- o̓|[g`FbN ----------------
	MOV	DX,CS:BASE_ADR			;o̓|[gǂ݂
	CMP	AL,03
	JB	@F
	SUB	AL,03
	ADD	DX,AFM_PORT			;gelɕύX
;----------- ʉNA ----------------------
@@:	ADD	AL,0B6H
	XOR	AH,AH
	CALL	FMOUT_PROC			;KEY OFF
	SUB	AL,63H				;2OP̂skZNg
	MOV	AH,3FH				;̃Iy[^NA
	CALL	FMOUT_PROC
	SUB	AL,3
	CALL	FMOUT_PROC
	SUB	AL,20H				;AL=030H
	AND	BL,BL				;Ԃ̌ʉH
	JE	SFSJP1
;----------- f[^Zbg ----------------------
	MOV	CX,4				;MULI,TL,AR,SLZbg
@@:	MOV	AH,[SI]				;f[^ǂ݂
	CALL	FMOUT_PROC
	INC	SI
	ADD	AL,03
	MOV	AH,[SI]				;f[^ǂ݂
	CALL	FMOUT_PROC
	INC	SI
	ADD	AL,20H-3
	LOOP	@B
	ADD	AL,40H				;AL=F0H
;----------- vrZbg ------------------------
	MOV	AH,[SI]				;f[^ǂ݂
	CALL	FMOUT_PROC
	INC	SI
	ADD	AL,03
	MOV	AH,[SI]				;f[^ǂ݂
	CALL	FMOUT_PROC
	INC	SI
	SUB	AL,33H-6			;AL=C6H
;----------- eaݒ --------------------------
	MOV	AH,[SI]
	CALL	FMOUT_PROC
	INC	SI
	SUB	AL,20H				;AL=A6H
;----------- gZbg ----------------------
	MOV	AH,[SI]				;f[^ǂ݂
	CALL	FMOUT_PROC
	INC	SI
	ADD	AL,10H
	MOV	AH,[SI]				;f[^ǂ݂
	CALL	FMOUT_PROC			;KEY ON
SFSJP1:	POP	DX
	POP	CX
	RET

;@===============================================================
;*	f[^o̓[`					*
;================================================================

;================== FMf[^Zbg ==============================
;raPUDXŎwꂽel|[gɃf[^o͂
;AL=R}h AH=f[^
;DX=o̓|[gAhX
;WX^ύX
FMOUT_PROC:
	PUSH	AX
	PUSH	CX
	OUT	DX,AL		;R}ho
	MOV	CX,1H
@@:	IN	AL,DX
	LOOP	@B
	XCHG	AL,AH
	INC	DX
	OUT	DX,AL		;f[^o
	DEC	DX
	MOV	CX,3H		;EGCgJEg
@@:	IN	AL,DX
	LOOP	@B
	POP	CX
	POP	AX
	RET

;================ lhwf[^ǂ݂ ===========================
;raPŮgel|[gɃf[^o͂(+4,+5)
;AL=R}h
;߂l AL=f[^
;WX^ύX
MIXIN_PROC:
	PUSH	DX
	MOV	DX,CS:BASE_ADR
	ADD	DX,MIX_PORT
	OUT	DX,AL		;R}ho
	INC	DX
	IN	AL,DX
	POP	DX
	RET

PRO_END	DW	0
;================================================================
;*	^C}[荞ݐ					*
;================================================================

;================ ^C}[ ================================
TIMER_INIT:
	PUSH	DS
	PUSH	ES
	PUSH	AX
	PUSH	BX
	PUSH	DX
	MOV	AX,3508H		;^C}[荞݃AhXǂ݂
	INT	21H
	MOV	WORD PTR CS:TIMER_ADR,BX
	MOV	WORD PTR CS:2[TIMER_ADR],ES
	MOV	AX,CS
	MOV	DS,AX			;荞݃[`AhXݒ
	MOV	DX,OFFSET TIMER_PLAY
	MOV	AX,2508H
	INT	21H
;--------- ^C}[ύX ------------
	MOV	AL,36H			;`g
	OUT	43H,AL
	MOV	AX,100H			;1/256ɕύX(214uS)
	OUT	40H,AL
	MOV	AL,AH
	OUT	40H,AL
	MOV	BYTE PTR CS:TIMEINT_CNT,16 ;ꊄ荞݂̃JE^[
	MOV	BYTE PTR CS:TIMER_CNT,0	;X̃^C}[荞
	POP	DX
	POP	BX
	POP	AX
	POP	ES
	POP	DS
	RET

;============= Xgbv ======================================
TIMER_STOP:
	PUSH	DS
	PUSH	AX
	PUSH	DX
	LDS	DX,DWORD PTR CS:TIMER_ADR	;AhXǂ݂
	MOV	AX,2508H
	INT	21H
;--------- ^C}[ύX ------------
	MOV	AL,36H			;`g
	OUT	43H,AL
	XOR	AX,AX			;55msɖ߂
	OUT	40H,AL
	MOV	AL,AH
	OUT	40H,AL
	POP	DX
	POP	AX
	POP	DS
	RET

;============= ^C}[荞ݐ䃁C =============================
TIMER_PLAY:
	CLI
	PUSHF
	PUSH	AX
	TEST	BYTE PTR CS:CHG_FLG,02H	;ttO`FbN
	JE	@F
	DEC	BYTE PTR CS:TMP_CNT	;e|ɂ킹
	JNE	@F
	MOV	AL,CS:TMP_SPD
	MOV	CS:TMP_CNT,AL
	CALL	BGMINT			;TEhRg[
;---------- ꊄ荞݂ -------------
@@:	DEC	BYTE PTR CS:TIMEINT_CNT	;JE^[P
	JNE	@F
	MOV	BYTE PTR CS:TIMEINT_CNT,16
	DB	09AH			;^C}[荞ݕ(JMP FAR)
TIMEINT_ADR	DD	0
	CLI				;STIԂ̉\EEE
;------ ̃^C}[荞݂ ---------
@@:	DEC	BYTE PTR CS:TIMER_CNT	;JE^[P(256Ń[v̂ߏ͖)
	JNE	@F
	POP	AX
	POPF
	DB	0EAH			;̃^C}[荞݂(JMP FAR)
TIMER_ADR	DD	0
;---------- ʏI -------------------
@@:	MOV	AL,20H			;EOI SET
	OUT	20H,AL
	POP	AX
	POPF
	STI
	IRET

;============== e|ݒ ======================================
;AH=e|
TIMER_TMP:
	PUSH	AX
	PUSH	BX
	MOV	AL,0FFH
	SUB	AL,AH
	XOR	AH,AH
	MOV	BX,AX				;PP{
	SHL	AX,01
	ADD	BX,AX
	SHL	AX,01
	SHL	AX,01
	ADD	AX,BX
	SHR	AX,01				;WŊ
	SHR	AX,01
	SHR	AX,01				;킹ĂPDRVT{
	MOV	CS:TMP_SPD,AL			;e|ݒ
	POP	BX
	POP	AX
	RET

;============== ꊄ荞݂̏[` =====================
TIMEINT_PROC:
	RETF

; =================== ް ر (CODE SEGMENT) ==================
EVEN
; ------------------- ʃ[N -------------------------------
BASE_ADR DW	220H			;raPŨftHgx[XAhX
MIDI_ADR DW	330H			;raPUlot̃x[XAhX
CS_SAVE	DW	0000H				;CS ɳ ر
SS_SAV1	DW	0000H				;INT40 SS,SP ɳ ر
SP_SAV1	DW	0000H				;(ʰ غ )
SS_SAV2	DW	0000H				;ʰ غ SS,SP ɳ ر
SP_SAV2	DW	0000H
INTMASK	DW	00H			;PIC̃}XNf[^(+0:Ͻ +1:ڰ)
TIMER_FLG	DB	0		;el̃^C}[Rg[̒l
SOUND_FLG	DB	0		;ʉaJE^[
; ------------------- DRIVER BUFF -------------------------------
SOU_SEG	DW	0000H				; ް 
SOU_OFF	DW	0000H				; ް ̾
BGM_SEG	DW	0000H				;BGM ް 
BGM_OFF	DW	0000H				;BGM ް ̾
FMVOL	DB	00H,00				;el̃{|ݒ
READFLG	DB	00H 				;tF[hAEg̎s
ADR_NO	DB	00H				;sߔԍ
FM_DATA	DW	0000H				;FM Ȳ ް ڽ (OFFSET)
SG_DATA DW	0000H				;SSG Ȳ ް ڽ(OFFSET)
CHG_FLG DB	00H		;(0ޯON:̪ޱ 1:BGMt 2:ʉ)
	DB	00H;*********а*************
CHGCNT	DB	00H,00H,00H,00H,00H,00H		;ݶ TIME
CHG_W	DB	00H,00H,00H,00H,00H,00H		;CHGCNT ܰ(ڶ  )
CHG_N	DB	00H,00H,00H,00H,00H,00H		;ݶ خ(0 OR 0FHķ ݶ ż)
CHGLEV	DB	00H,00H,00H,00H,00H,00H		;ADD (1 OR 0FFH(-1))
JL_D0	DW	0000H,0000H,0000H,0000H,0000H,0000H
JL_D1	DW	0000H,0000H,0000H,0000H,0000H,0000H
JL_D2	DW	0000H,0000H,0000H,0000H,0000H,0000H
JL_D3	DW	0000H,0000H,0000H,0000H,0000H,0000H
JL_CNT	DB	00H,00H,00H,00H,00H,00H		;D1 ٰ 
; ------------------- SOUND DATA ------------------
SOU_NO	DB	0FFH		;R[h(FF:~)
SOU_CNT	DB	00H				;SOUND ʯ ޶(WAIT)
SOU_ADD	DW	0000H				;ò ޳
SOU_WOR	DW	0000H				;̎g
SOU_ADR	DW	0000H				;ݔf̃f[^AhX
; ------------------- BGM WORK --------------------
BGM_ADD	DW	0000H,0000H,0000H,0000H,0000H,0000H	;ݶ޸ ް ߲
ONNCYOU	DW	0000H,0000H,0000H,0000H,0000H,0000H	; Ŷ޻ 
ONNKAI	DW	0000H,0000H,0000H,0000H,0000H,0000H	;ݶ  ް
DELAY_C	DB	00H,00H,00H,00H,00H,00H		;DELAY 
WAV_CNT	DB	00H,00H,00H,00H,00H,00H		;WAVE  (0-4)
SPE_CNT	DB	00H,00H,00H,00H,00H,00H		;SPEED 
HENNKA	DW	0000H,0000H,0000H,0000H,0000H,0000H	;ݶخ 
FEADCNT	DB	00H,00H,00H,00H,00H,00H		;FEAD IN(OUT)̉ʂ̕ωʃJE^[
SSG_KEY	DB	00H,00H,00H			;01:ON 04:OFF(  )
SSG_CNT	DB	00H,00H,00H			;AR,DR (0 ض)
SSG_V	DW	0000H,0000H,0000H		;H= L=(H=VOLUM)
KEY_SW	DB	00H
	DB	00H;************а************
WAONW	LABEL	WORD
WAON	DB	00H,00H				;ܵ  
CONNECT	DB	08H,0AH,09H,0DH			;ر ڰ ҽ
OPLTBL	DB	03H,05H,03H,00H			;SB16Iy[^AhX
; ------------------- BGM DATA --------------------
VOLUM	DB	00H,00H,00H,00H,00H,00H		;FM(3޲)/SSG خ(0-15)
SOU_COL	DB	00H,00H,00H,00H,00H,00H		;FM(3޲)/SSG Ȳ ݺ޳
LFO_DA1	DB	00H,00H,00H,00H,00H,00H		;޳  خ(6ܵ )
LFO_DA2	DB	00H,00H,00H,00H,00H,00H		;ݽ خ(6ܵ )
LFO_DA3	DB	00H,00H,00H,00H,00H,00H		;޳  خ(6ܵ )
LFO_DA4	DB	00H,00H,00H,00H,00H,00H		;ݽ خ(6ܵ )
PMD_S	DB	00H,00H,00H,00H,00H,00H		;(߸)
SPEED	DB	00H,00H,00H,00H,00H,00H		;ݶ Ի
DELAY	DB	00H,00H,00H,00H,00H,00H		;LFO  ݸ(KEY ON )
SSG_AR	DB	00H,00H,00H			;SSG A.R
SSG_DR	DB	00H,00H,00H			;SSG D.R
SSG_SR	DB	00H,00H,00H			;SSG S.R
SSG_RR	DB	00H,00H,00H			;SSG R.R
SSG_AL	DW	0000H,0000H,0000H		;SSG A.L
SSG_DL	DW	0000H,0000H,0000H		;SSG D.L
SSG_SL	DW	0000H,0000H,0000H		;SSG S.L
SSG_RL	DW	0000H,0000H,0000H		;SSG R.L
; --------------- ̒e[u ----------------
BGM_LON	DB	0C0H,60H,30H,18H,0CH,06H,03H,00H;NOMAL WAIT
	DB	000H,90H,48H,24H,12H,09H,00H,00H;_(S,32,64͏oȂ)
	DB	080H,40H,20H,10H,08H,04H,02H,01H;OA
	DB	0C0H,60H,30H,18H,0CH,06H,03H,00H;_OA(64͕s)
; ---------------FM Kf[^e[u ------------
FONTBLH	DB 00,01H,01H,01H,01H,01H,01H,01H,02H,02H,02H,02H,02H,0,0,0 ;1
	DB 00,05H,05H,05H,05H,05H,05H,05H,06H,06H,06H,06H,06H,0,0,0 ;2
	DB 00,09H,09H,09H,09H,09H,09H,09H,0AH,0AH,0AH,0AH,0AH,0,0,0 ;3
	DB 00,0DH,0DH,0DH,0DH,0DH,0DH,0DH,0EH,0EH,0EH,0EH,0EH,0,0,0 ;4
	DB 00,11H,11H,11H,11H,11H,11H,11H,12H,12H,12H,12H,12H,0,0,0 ;5
	DB 00,15H,15H,15H,15H,15H,15H,15H,16H,16H,16H,16H,16H,0,0,0 ;6
	DB 00,19H,19H,19H,19H,19H,19H,19H,1AH,1AH,1AH,1AH,1AH,0,0,0 ;7
	DB 00,1DH,1DH,1DH,1DH,1DH,1DH,1DH,1EH,1EH,1EH,1EH,1EH,0,0,0 ;8
FONTBLL	DB 00,55H,6BH,081H,098H,0B0H,0CAH,0E5H,02H,020H,041H,63H,87H,0	;ݶ

;********* STACK AREA *************
INT_OFF	DW	0000H
INT_SEG	DW	0000H				;INT40̃AhXi[
SINT_OFF DW	0000H
SINT_SEG DW	0000H				;INT1CC^[o^C}[i[
HINT_NO	DB	5				;n[h荞ݔԍ(ftHgIRQ5)
	DB	0
TMP_SPD	DB	4				;e|̒l(l)
TMP_CNT DB	4				;e|̃JE^[
TIMEINT_CNT DB	0				;ꊄ荞݃JE^[(16ɂP)
TIMER_CNT DB	0				;^C}[荞(256ɂP)
	DW	127	DUP(?)
STACK_W	DW	0000H

;============== غ  =======================
DRVINIT:
	MOV	SP,OFFSET STACK_W		;X^bN|C^[̕ύX	CMP	ARGC,0				;H
	MOV	AH,'R'
	CALL	KENSAKU				;𒲂ׂ
	JNB	DREXIT
	CALL	CHKMEM				;ɏ풓Ă邩H
	CMP	CX,0
	JE	DRJP2
;---------- I/OAhX`FbN ----------------
	MOV	AH,'N'				;{[h
	CALL	KENSAKU
	JB	@F
	JMP	SHORT DRJP4			;{[h
@@:	MOV	AH,'A'				;AhX
	CALL	KENSAKU
	JB	@F
	MOV	BASE_ADR,AX			;x[XAhXZbg
@@:	MOV	AH,'I'				;荞
	CALL	KENSAKU
	JB	@F
	MOV	HINT_NO,AL			;n[h荞ݔԍ
@@:
;	MOV	AL,80H
;	CALL	MIXIN_PROC			;荞ݔԍp[^ǂ݂
;	CMP	AL,0FFH
;	JE	DRJP4
	JMP	SHORT DRJP6
;////////// hCo[̊J ///////////////////
DREXIT:	CALL	CHKMEM
	CMP	CX,00
	JNE	DRJP3
	print	MSG3				;hCo[̊J
	PUSH	DS
	MOV	AX,3561H			;݃xN^[̎擾
	INT	21H
	LDS	DX,DWORD PTR ES:INT_OFF
	MOV	AX,2561H
	INT	21H
	POP	DS
	MOV	AH,49H				;풓ĂvO̊J
	INT	21H
	JC	DRJP3
	MOV	AX,4C00H
	INT	21H
DRJP3:	MOV	AX,4C01H
	INT	21H
;////////// hCo[풓Ă ///////////
DRJP2:	print	MSG2				;ɏ풓Ă
	MOV	AX,4C01H
	INT	21H
;/////////// {[h //////////////////////
DRJP4:	print	MSG1				;FM{[hȂ
	CALL	CHGTBL
	JMP	SHORT DRJP5
;/////////// {[hL //////////////////////
DRJP6:	print	MSG1				;{[h
DRJP5:	MOV	AX,OFFSET TIMEINT_PROC		;ꊄ荞ݐݒ
	MOV	WORD PTR TIMEINT_ADR,AX
	MOV	AX,CS
	MOV	WORD PTR 2[TIMEINT_ADR],AX
	MOV	AX,3561H
	INT	21H
	MOV	INT_SEG,ES			;INT40̃AhXi[
	MOV	INT_OFF,BX
	CLI
	PUSH	DS
	MOV	AX,CS				;۸ 
	MOV	DS,AX
	MOV	DX,OFFSET DRV_IO		;۸ ̾
	MOV	AX,2561H
	INT	21H				;INT40Zbg
	POP	DS
	STI
	MOV	ES,ENVSEG			;ϐ̈̃NA
	MOV	AH,49H
	INT	21H
	MOV	ENVSEG,0			;Ô({͉łǂ)
	MOV	AX,OFFSET STACK_W		;۸  ڽ
	MOV	CL,04
	SHR	AX,CL				;16޲ ׸ ݶ
	INC	AX
	MOV	DX,AX
	MOV	AX,3100H
	INT	21H				;ޮ خ
;--------- ɏ풓Ă邩H ---------------------------
;CX=0:풓 ȊO:풓
CHKMEM:	MOV	AX,3561H			;݃xN^[̎擾
	INT	21H
	MOV	SI,OFFSET BGMINT		;r擪AhX
	MOV	DI,SI
	MOV	CX,OFFSET PRO_END
	SUB	CX,OFFSET BGMINT		;rf[^
	CLD
	REPE	CMPSB				;r
	RET
;---------  ----------------------------------------
;AH=`FbN镶R[h(啶At@xbg)
;߂l CY=OFF AX=ɕtĂ鐔l
;	CY=ON 
KENSAKU:
	PUSH	BX
	PUSH	CX
;--------- `FbN ----------------------
	XOR	CH,CH				;CH=0
	MOV	CL,ARGC				;ǂݍ
	AND	CL,CL				;OH
	JE	KEJP3
	MOV	BX,0
	MOV	AL,'/'				;/?Ń`FbN
KELOP1:	CMP	AX,WORD PTR ARGV[BX]		;啶`FbN
	JE	@F
	ADD	AH,'a'-'A'
	CMP	AX,WORD PTR ARGV[BX]		;`FbN
	JE	@F
	SUB	AH,'a'-'A'
	INC	BX
	LOOP	KELOP1
KEJP3:	STC
	JMP	SHORT KEJP1			;G[I
;---------- l`FbN -----------------------
@@:	ADD	BX,2				;ړ
	XOR	AX,AX				;lJE^[
KELOP2:	MOV	CL,ARGV[BX]			;Pǂ݂
	SUB	CL,'0'				;l͈̓`FbN
	JB	KEJP2
	CMP	CL,9
	JBE	@F
	SUB	CL,'A'-'0'-10			;啶PUi`FbN
	JB	KEJP2
	CMP	CL,15
	JBE	@F
	SUB	CL,'a'-'A'			;PUi`FbN
	JB	KEJP2
	CMP	CL,15
	JA	KEJP2
@@:	SHL	AX,01				;PU{
	SHL	AX,01
	SHL	AX,01
	SHL	AX,01
	XOR	CH,CH
	ADD	AX,CX				;lZ
	INC	BX
	JMP	SHORT KELOP2
KEJP2:	CLC
KEJP1:	POP	CX
	POP	BX
	RET
;------------ INT40H̃Wve[u̕ύX ------------------
CHGTBL:	PUSH	ES
	PUSH	AX
	PUSH	CX
	PUSH	DI
	PUSH	CS				;ES=CS
	POP	ES
	CLD
	MOV	DI,OFFSET IO_TBL
	MOV	AX,OFFSET IO_RET
	MOV	CX,12				;SẴe[uɓ
	REP	STOSW
	MOV	DI,OFFSET IO_TBL
	MOV	AX,OFFSET INT62H_SET		;INT 62Ĥݐ
	MOV	ES:6[DI],AX
	MOV	AX,OFFSET INT62H_CLS
	MOV	ES:8[DI],AX
	POP	DI
	POP	CX
	POP	AX
	POP	ES
	RET
;------------ bZ[W@GA ------------------------------
MSG1	DB	'YNSound Driver Version 1.51  (1995/04/18)',0DH,0AH
	DB	'Sound driver installed',0DH,0AH,0DH,0AH,'$'
MSG2	DB	'Existing Sound driver enabled',0DH,0AH,0DH,0AH,'$'
MSG3	DB	'Existing Sound driver from memory',0DH,0AH,0DH,0AH,'$'
CODE	ENDS
	END	START
