/*
 * TITLE:       tetris.hpp
 *
 * TOPIC:       A Tribute to TETRIS
 *
 * METHOD:      
 *
 * WRITTEN BY:  Matthew Versluys
 *		COPYRIGHT August 1995
 *
 * ORIGINAL:    10 July, 1995
 * CURRENT:     3 August, 1995
 */

#include "xtypes.hpp"

#define COLR 	0xFF

#define CLEAR	0
#define LINES	1
#define RANDOM	2
#define PYRAMID	3
#define BASTARD 4
#define MESH	5

#pragma PACK (4)

struct piece_struct {
	char	face_colour;
	char	high_colour;
	char	low_colour;
	char	*map[4];
	char	*bitmap[4];
};

struct stygian_levels_struct {
	char	speed;
	char	lines;
	char	base;
	short	advancing;
	short	random;
	short	random2;
	short	score_m;
	short	score_b;
	char	special;
	char	msg1[12];
	char	msg2[12];
	char	msg3[12];
	char	msg4[12];
};

struct arcade_levels_struct {
	char	lines;
	char	base;
	short	advancing;
	short	random;
	short	score_m;
	short	score_b;
	char	special;
	char	msg1[12];
	char	msg2[12];
	char	msg3[12];
	char	msg4[12];
};

struct highscore_entry {
	long		score;
	short		level;
	short		lines;
	char		name[12];
};

struct highscore_table {
	char			name[30];
	struct highscore_entry	table[10];
};

struct insult_struct {
	char	msg1[12];
	char	msg2[12];
	char	msg3[12];
};

typedef struct piece_struct		pstruct;
typedef struct stygian_levels_struct	stygian_levels;
typedef struct arcade_levels_struct	arcade_levels;
typedef char				pit;
typedef struct insult_struct		insult;

char	reda[16] = { 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
char	redb[16] = { 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0 };
char	redc[16] = { 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
char	redd[16] = { 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0 };

char	bluea[16] = { 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
char	blueb[16] = { 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
char	bluec[16] = { 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
char	blued[16] = { 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

char	greena[16] = { 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
char	greenb[16] = { 0, 1, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0 };
char	greenc[16] = { 0, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
char	greend[16] = { 1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0 };

char	magentaa[16] = { 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
char	magentab[16] = { 1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0 };
char	magentac[16] = { 0, 0, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
char	magentad[16] = { 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0 };

char	yellowa[16] = { 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
char	yellowb[16] = { 0, 1, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0 };
char	yellowc[16] = { 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
char	yellowd[16] = { 1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0 };

char	cyana[16] = { 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
char	cyanb[16] = { 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0 };
char	cyanc[16] = { 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
char	cyand[16] = { 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0 };

char	orangea[16] = { 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
char	orangeb[16] = { 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0 };
char	orangec[16] = { 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
char	oranged[16] = { 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0 };

pstruct piece_map[7] = {
	{ 0xF4, 0xF5, 0xF3, { reda, redb, redc, redd }, { NULL, NULL, NULL, NULL } },
	{ 0xF1, 0xF2, 0xF0, { bluea, blueb, bluec, blued }, { NULL, NULL, NULL, NULL }},
	{ 0xEE, 0xEF, 0xED, { greena, greenb, greenc, greend }, { NULL, NULL, NULL, NULL }},
	{ 0xEB, 0xEC, 0xEA, { magentaa, magentab, magentac, magentad }, { NULL, NULL, NULL, NULL }},
	{ 0xE8, 0xE9, 0xE7, { yellowa, yellowb, yellowc, yellowd }, { NULL, NULL, NULL, NULL }},
	{ 0xE5, 0xE6, 0xE4, { cyana, cyanb, cyanc, cyand }, { NULL, NULL, NULL, NULL }},
	{ 0xE2, 0xE3, 0xE1, { orangea, orangeb, orangec, oranged }, { NULL, NULL, NULL, NULL }}
};

stygian_levels slevels[32] = {
	{ 12,  5, CLEAR,     0,   0,   0,  1,  1, 1, "WELCOME", "TO", "TETRIS", "(YAWN)" },
	{ 12, 10, CLEAR,     0, 200,   0,  2,  4, 1, "WATCH OUT", "FOR RANDOM", "BLOCKS", "" },
	{ 12,  5, CLEAR,     0,   0, 100,  4,  8, 1, "NOW YOU", "SEE THEM", "NOW YOU", "DON'T" },
	{ 12, 10, CLEAR,     0, 200,  93,  8, 16, 1, "COMMING", "AND", "GOING", "" },
	{ 12, 10, CLEAR,   400,   0,   0, 10, 20, 1, "BEWARE OF", "ADVANCING", "LINES", "" },
	{ 12, 10, CLEAR,   400, 202,  93, 12, 24, 1, "", "COMBO", "LEVEL", "" },
	{  4, 10, CLEAR,     0,   0,   0, 14, 28, 1, "CAUTION", "!!!", "HIGH", "SPEED" },

	{ 10, 20, LINES,     0,   0,   0, 16, 32, 1, "TRY TO", "USE THESE", "BLOCKS" },
	{ 10, 20, RANDOM,    0,   0,   0, 18, 36, 1, "DIFFICULTY", "INCRESAING", "", "GOOD LUCK" },
	{ 10, 20, PYRAMID,   0,   0,   0, 20, 40, 1, "NOW TRY", "THIS", "ROUND", "" },
	{ 10, 20, BASTARD,   0,   0,   0, 24, 44, 1, "NO ONE", "SAID LIFE", "IS EASY", "" },
	{ 10, 20, MESH,      0,   0,   0, 26, 48, 1, "CAN YOU", "HANDLE", "THIS", "???" },
	{  4, 10, CLEAR,     0,   0,   0, 28, 52, 1, "CAUTION", "!!!", "HIGH", "SPEED" },

	{  8, 20, LINES,     0, 202,  93, 30, 56, 1, "", "BE", "PREPARED", "" },
	{  8, 20, RANDOM,    0, 202,  93, 32, 60, 1, "DIFFICULTY", "INCRESAING", "", "GOOD LUCK" },
	{  8, 20, PYRAMID,   0, 202,  93, 34, 64, 1, "NOW TRY", "THIS", "ROUND", "" },
	{  8, 20, BASTARD,   0, 202,  93, 36, 68, 1, "NO ONE", "SAID LIFE", "IS EASY", "" },
	{  7, 20, MESH,      0, 202,  93, 38, 72, 1, "CAN YOU", "HANDLE", "THIS", "???" },
	{  4, 10, CLEAR,     0,   0,   0, 40, 76, 1, "CAUTION", "!!!", "HIGH", "SPEED" },

	{  8, 20, LINES,   400,   0,   0, 42, 80, 1, "ARE YOU", "READY FOR", "THIS", "ROUND" },
	{  8, 20, RANDOM,  400,   0,   0, 44, 84, 1, "DIFFICULTY", "INCRESAING", "", "GOOD LUCK" },
	{  8, 20, PYRAMID, 400,   0,   0, 46, 88, 1, "NOW TRY", "THIS", "ROUND", "" },
	{  8, 20, BASTARD, 400,   0,   0, 48, 92, 1, "NO ONE", "SAID LIFE", "IS EASY", "" },
	{  7, 20, MESH,    400,   0,   0, 50, 96, 1, "CAN YOU", "HANDLE", "THIS", "???" },
	{  3, 10, CLEAR,     0,   0,   0, 52, 100, 1, "CAUTION", "!!!", "HIGH", "SPEED" },

	{  7, 20, LINES,   400, 202,  93, 54, 104, 1, "OKAY", "", "NOW FOR A", "REAL ROUND" },
	{  7, 20, RANDOM,  400, 202,  93, 56, 108, 1, "DIFFICULTY", "INCRESAING", "", "GOOD LUCK" },
	{  7, 20, PYRAMID, 400, 202,  93, 58, 112, 1, "NOW TRY", "THIS", "ROUND", "" },
	{  7, 20, BASTARD, 400, 202,  93, 60, 120, 1, "NO ONE", "SAID LIFE", "IS EASY", "" },
	{  6, 20, MESH,    400, 202,  93, 62, 124, 1, "CAN YOU", "HANDLE", "THIS", "???" },
	{  2, 10, CLEAR,     0,   0,   0, 64, 128, 1, "CAUTION", "!!!", "HIGH", "SPEED" },

	{  5, 255, MESH,   400, 202,  93, 66, 132, 1, "FINAL", "ROUND", "", "NO CHANCE" }
};

arcade_levels alevels[21] = {
	{  5, CLEAR,     0,   0,  1,  1, 0, "", "", "", "" },
	{  8, CLEAR,     0,   0,  2,  4, 0, "", "", "", "" },
	{ 12, CLEAR,     0,   0,  4,  8, 0, "", "", "", "" },
	{ 15, LINES,     0,   0,  8, 16, 1, "TRY TO", "USE THESE", "BLOCKS", "" },
	{ 15, RANDOM,    0,   0, 16, 20, 1, "DIFFICULTY", "INCREASING", "", "GOOD LUCK" },
	{ 15, PYRAMID,   0,   0, 18, 24, 1, "NOW TRY", "THIS", "ROUND", ""  },
	{ 15, CLEAR,     0, 405, 20, 28, 1, "WATCH OUT", "FOR RANDOM", "BLOCKS", "" },
	{ 15, CLEAR,     0, 405, 22, 32, 0, "", "", "", "" },
	{ 18, CLEAR,     0, 405, 24, 36, 0, "", "", "", "" },
	{ 12, CLEAR,   600,   0, 26, 40, 1, "BEWARE OF", "ADVANCING", "LINES", "" },
	{ 15, CLEAR,   600,   0, 28, 44, 0, "", "", "", "" },
	{ 18, CLEAR,   600,   0, 30, 48, 0, "", "", "", "" },
	{ 18, LINES,   600,   0, 32, 52, 1, "TRY TO", "USE THESE", "BLOCKS", "" },
	{ 18, RANDOM,  600,   0, 34, 56, 1, "DIFFICULTY", "INCREASING", "", "GOOD LUCK" },
	{ 18, PYRAMID, 600,   0, 36, 60, 1, "NOW TRY", "THIS", "ROUND", "" },
	{ 15, CLEAR,   600, 405, 38, 64, 1, "MAXIMUM", "DIFFICULTY", "", "GOOD LUCK" },
	{ 18, CLEAR,   600, 405, 40, 68, 0, "", "", "", "" },
	{ 21, CLEAR,   600, 405, 44, 72, 0, "", "", "", "" },
	{ 21, LINES,   600, 405, 48, 76, 1, "TRY TO", "USE THESE", "BLOCKS", "" },
	{ 21, RANDOM,  600, 405, 50, 80, 1, "DIFFICULTY", "INCREASING", "", "GOOD LUCK" },
	{ 21, PYRAMID, 600, 405, 52, 84, 1, "NOW TRY", "THIS", "ROUND", "" } 
};

insult	insults[11] = {
		{ "KICKED", "YOUR", "ASS" },
		{ "WIPPED", "YOUR", "BUTT" },
		{ "TOTALLY", "ACED", "YOU" },
		{ "IS", "LAUGHING", "AT YOU" },
		{ "KNOWS YOU", "CAN'T PLAY", "TETRIS" },
		{ "WANTS TO", "BEAT YOU", "AGAIN" },
		{ "IS A", "TETRIS", "GRANDMASTER" },
		{ "LIKES", "THIS", "GAME" },
		{ "TOTALLY", "FLUKED", "IT" },
		{ "PROBABLY", "CHEATED", "" },
		{ "WAS A", "BETA", "TESTER" },
};

unsigned char	num_0[72] = {
		0xFC, COLR, COLR, COLR, COLR, 0xFC, 0xFC, 0xFC,
		COLR, COLR, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		COLR, COLR, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		COLR, COLR, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		COLR, COLR, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		COLR, COLR, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		COLR, COLR, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		COLR, COLR, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		0xFC, COLR, COLR, COLR, COLR, 0xFC, 0xFC, 0xFC };
unsigned char	num_1[72] = {
		0xFC, COLR, COLR, COLR, 0xFC, 0xFC, 0xFC, 0xFC,
		0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC, 0xFC, 0xFC,
		0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC, 0xFC, 0xFC,
		0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC, 0xFC, 0xFC,
		0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC, 0xFC, 0xFC,
		0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC, 0xFC, 0xFC,
		0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC, 0xFC, 0xFC,
		0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC, 0xFC, 0xFC,
		0xFC, COLR, COLR, COLR, COLR, 0xFC, 0xFC, 0xFC };
unsigned char	num_2[72] = {
		0xFC, COLR, COLR, COLR, COLR, 0xFC, 0xFC, 0xFC,
		COLR, COLR, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		0xFC, 0xFC, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		0xFC, 0xFC, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		0xFC, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC, 0xFC,
		0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC, 0xFC, 0xFC,
		0xFC, COLR, COLR, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC,
		COLR, COLR, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC,
		COLR, COLR, COLR, COLR, COLR, COLR, 0xFC, 0xFC };
unsigned char	num_3[72] = {
		0xFC, COLR, COLR, COLR, COLR, 0xFC, 0xFC, 0xFC,
		COLR, COLR, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		0xFC, 0xFC, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		0xFC, 0xFC, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		0xFC, 0xFC, COLR, COLR, COLR, 0xFC, 0xFC, 0xFC,
		0xFC, 0xFC, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		0xFC, 0xFC, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		COLR, COLR, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		0xFC, COLR, COLR, COLR, COLR, 0xFC, 0xFC, 0xFC };
unsigned char	num_4[72] = {
		COLR, COLR, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		COLR, COLR, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		COLR, COLR, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		COLR, COLR, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		COLR, COLR, COLR, COLR, COLR, COLR, 0xFC, 0xFC,
		0xFC, 0xFC, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		0xFC, 0xFC, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		0xFC, 0xFC, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		0xFC, 0xFC, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC };
unsigned char	num_5[72] = {
		COLR, COLR, COLR, COLR, COLR, COLR, 0xFC, 0xFC,
		COLR, COLR, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC,
		COLR, COLR, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC,
		COLR, COLR, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC,
		COLR, COLR, COLR, COLR, COLR, 0xFC, 0xFC, 0xFC,
		0xFC, 0xFC, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		0xFC, 0xFC, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		COLR, COLR, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		0xFC, COLR, COLR, COLR, COLR, 0xFC, 0xFC, 0xFC };
unsigned char	num_6[72] = {
		0xFC, COLR, COLR, COLR, COLR, 0xFC, 0xFC, 0xFC,
		COLR, COLR, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		COLR, COLR, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC,
		COLR, COLR, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC,
		COLR, COLR, COLR, COLR, COLR, 0xFC, 0xFC, 0xFC,
		COLR, COLR, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		COLR, COLR, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		COLR, COLR, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		0xFC, COLR, COLR, COLR, COLR, 0xFC, 0xFC, 0xFC };
unsigned char	num_7[72] = {
		COLR, COLR, COLR, COLR, COLR, COLR, 0xFC, 0xFC,
		0xFC, 0xFC, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		0xFC, 0xFC, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		0xFC, 0xFC, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		0xFC, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC, 0xFC,
		0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC, 0xFC, 0xFC,
		0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC, 0xFC, 0xFC,
		0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC, 0xFC, 0xFC,
		0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC, 0xFC, 0xFC };
unsigned char	num_8[72] = {
		0xFC, COLR, COLR, COLR, COLR, 0xFC, 0xFC, 0xFC,
		COLR, COLR, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		COLR, COLR, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		COLR, COLR, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		0xFC, COLR, COLR, COLR, COLR, 0xFC, 0xFC, 0xFC,
		COLR, COLR, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		COLR, COLR, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		COLR, COLR, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		0xFC, COLR, COLR, COLR, COLR, 0xFC, 0xFC, 0xFC };
unsigned char	num_9[72] = {
		0xFC, COLR, COLR, COLR, COLR, 0xFC, 0xFC, 0xFC,
		COLR, COLR, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		COLR, COLR, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		COLR, COLR, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		0xFC, COLR, COLR, COLR, COLR, COLR, 0xFC, 0xFC,
		0xFC, 0xFC, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		0xFC, 0xFC, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		COLR, COLR, 0xFC, 0xFC, COLR, COLR, 0xFC, 0xFC,
		0xFC, COLR, COLR, COLR, COLR, 0xFC, 0xFC, 0xFC };

struct blitbuf numbers[10] = {
	{ 8, 9, num_0 },
	{ 8, 9, num_1 },
	{ 8, 9, num_2 },
	{ 8, 9, num_3 },
	{ 8, 9, num_4 },
	{ 8, 9, num_5 },
	{ 8, 9, num_6 },
	{ 8, 9, num_7 },
	{ 8, 9, num_8 },
	{ 8, 9, num_9 } };

char fontconvert[128] = {
		59, 59, 59, 59, 59, 59, 59, 59,
		59, 59, 59, 59, 59, 59, 59, 59,

		59, 59, 59, 59, 59, 59, 59, 59,
		59, 59, 59, 59, 59, 59, 59, 59,

		59, 29, 59, 46, 47, 48, 49, 40, 
		57, 58, 54, 50, 27, 51, 26, 59,

		30, 31, 32, 33, 34, 35, 36, 37,
		38, 39, 44, 43, 55, 52, 56, 28,

		45,  0,  1,  2,  3,  4,  5,  6,
		 7,  8,  9, 10, 11, 12, 13, 14,

		15, 16, 17, 18, 19, 20, 21, 22,
		23, 24, 25, 59, 59, 59, 53, 59,

		41,  0,  1,  2,  3,  4,  5,  6,
		 7,  8,  9, 10, 11, 12, 13, 14,

		15, 16, 17, 18, 19, 20, 21, 22,
		23, 24, 25, 59, 59, 59, 42, 59
};

char fontspacing[128] = {
		 0,  0,  0,  0,  0,  0,  0,  0,
		 0,  0,  0,  0,  0,  0,  0,  0,

		 0,  0,  0,  0,  0,  0,  0,  0,
		 0,  0,  0,  0,  0,  0,  0,  0,

		 8,  4,  0, 12,  8, 12,  8,  8,
		 4,  4,  8,  8,  8,  8,  8,  0,

		 8,  8,  8,  8,  8,  8,  8,  8,
		 8,  8,  8,  8,  8,  8,  8,  8,

		12,  8,  8,  8,  8,  8,  8,  8,
		 8,  4,  8,  8,  8, 12,  8,  8,

		 8,  8,  8,  8,  8,  8,  8, 12,
		 8,  8,  8,  0,  0,  0,  8,  0,

		 8,  8,  8,  8,  8,  8,  8,  8,
		 8,  4,  8,  8,  8, 12,  8,  8,

		 8,  8,  8,  8,  8,  8,  8, 12,
		 8,  8,  8,  0,  0,  0,  12,  0,
};

char scantoascii[64] =      "//1234567890-=//QWERTYUIOP////ASDFGHJKL\;'`//ZXCVBNM,.//// "; 
char shiftscantoascii[64] = "//!@#$%^&*()/+//QWERTYUIOP////ASDFGHJKL:\"~//ZXCVBNM<>?/// ";

#pragma PACK (1)
struct highscore_table	arcade;
struct highscore_table	traditional;
struct highscore_table	stygian;
struct highscore_table	competitive;
#pragma PACK (4)

