/*
 * TITLE:       joystick.hpp
 *
 * TOPIC:       Routines to read in the joystick values
 *
 * METHOD:      Polls for the joystick stuff.
 *		Do not use during DMA otherwise 
 *		we may get fuzzy results.
 *
 *		Pretest before each time you
 *		want to read the joystick.
 *
 *
 * WRITTEN BY:  Matthew Versluys
 *
 * ORIGINAL:    18 July, 1995
 * CURRENT:     18 July, 1995
 */

unsigned short JOYSTICK = 0x201;

#pragma aux pretest =		\
	"mov	dx, JOYSTICK"	\
	"@PREL:"		\
	"in	al, dx"		\
	"and	al, 03h"	\
	"jne	@PREL"		\
	modify[ax dx];

unsigned short time_ja_x(void);
#pragma aux time_ja_x =		\
	"mov	cx, 0"		\
	"cli"			\
	"mov	dx, JOYSTICK"	\
	"out	dx, al"		\
	"@JAXL:"		\
	"inc	cx"		\
	"cmp	cx, 0FFFFh"	\
	"je	@JAXD"		\
	"in	al, dx"		\
	"and	al, 01h"	\
	"jne	@JAXL"		\
	"@JAXD:"		\
	"sti"			\
	modify[ax cx dx]	\
	value[cx];

unsigned short time_ja_y(void);
#pragma aux time_ja_y =		\
	"mov	cx, 0"		\
	"cli"			\
	"mov	dx, JOYSTICK"	\
	"out	dx, al"		\
	"@JAYL:"		\
	"inc	cx"		\
	"cmp	cx, 0FFFFh"	\
	"je	@JAYD"		\
	"in	al, dx"		\
	"and	al, 02h"	\
	"jne	@JAYL"		\
	"@JAYD:"		\
	"sti"			\
	modify[ax cx dx]	\
	value[cx];

unsigned short time_jb_x(void);
#pragma aux time_jb_x =		\
	"mov	cx, 0"		\
	"cli"			\
	"mov	dx, JOYSTICK"	\
	"out	dx, al"		\
	"@JBXL:"		\
	"inc	cx"		\
	"cmp	cx, 0FFFFh"	\
	"je	@JBXD"		\
	"in	al, dx"		\
	"and	al, 04h"	\
	"jne	@JBXL"		\
	"@JBXD:"		\
	"sti"			\
	modify[ax cx dx]	\
	value[cx];

unsigned short time_jb_y(void);
#pragma aux time_jb_y =		\
	"mov	cx, 0"		\
	"cli"			\
	"mov	dx, JOYSTICK"	\
	"out	dx, al"		\
	"@JBYL:"		\
	"inc	cx"		\
	"cmp	cx, 0FFFFh"	\
	"je	@JBYD"		\
	"in	al, dx"		\
	"and	al, 08h"	\
	"jne	@JBYL"		\
	"@JBYD:"		\
	"sti"			\
	modify[ax cx dx]	\
	value[cx];

