/*
 * TITLE:       flclib.hpp
 *
 * TOPIC:       FLC Library
 *
 * METHOD:      Routines to handle FLC files
 *		Has foundations built on a FLI lib by Ivo Bosticky
 *		Other info from PCGPE ver 1.0
 *
 * WRITTEN BY:  Matthew Versluys
 *
 * ORIGINAL:    7 July, 1995
 * CURRENT:     7 July, 1995
 */

#define FLI_COLOR	11
#define FLI_LC		12
#define FLI_BLACK	13
#define FLI_BRUN	15
#define FLI_COPY	16
#define FLI_DELTA	7
#define FLI_256COLOR	4
#define FLI_MINI	18

#define FLC_MAGIC	0xAF12
#define FLI_MAGIC	0xAF11
#define FRAME_MAGIC	0xF1FA

#define PACKED_PIXEL	0
#define PLANE_4		1

#define FLC_OK		0
#define FLC_ERR1	1		// File not found
#define FLC_ERR2	2		// File is not a FLI/FLC file
#define	FLC_ERR3	3		// Out of Memory

struct flc_header_struct {
	unsigned long	length;
	unsigned short	magic;
	unsigned short	frames;
	unsigned short	width;
	unsigned short	height;
	unsigned short	depth;
	unsigned short	flags;
	unsigned short	speed;
	unsigned long	next;
	unsigned long	frit;
	unsigned char	expand[102];
};

struct flc_frame_struct {
	unsigned long	size;
	unsigned short	magic;
	unsigned short	chunks;
	unsigned char	expand[8];
};

struct flc_chunk_struct {
	unsigned long	size;
	unsigned short	type;
};

struct pal {
	char	red;
	char	green;
	char	blue;
};

struct styxmovie_struct {
	unsigned short	colours;
	struct pal	palette[256];
	char		type;
	char		speed;
	unsigned short	width;
	unsigned short	height;
	unsigned short	frames;
	unsigned short	current_frame;
	unsigned long	moviesize;
	char		*movie;
};


/*
 * exported routines
 */
int load_flc(FILE *, struct styxmovie_struct *);
void cleanup(struct styxmovie_struct *);
