
' TOWERS OF HANOI (1995)
' 
'
'                                    Copyright (C) 1995, SEAV Softwares
'
'                                    This program written by Eugene Villar
'                                    a.k.a SEAV (evillar@geocities.com)
'
'                                    Visit my web site at
'                                    http://seav.findhere.com
'
' 

' View the online Instructions for help.

SCREEN 12

RANDOMIZE TIMER
config = 3
sounds = 1
Filedat$ = "Hanoit10.dat"

CONST Pi = 3.141592654#
DIM s(11)
FOR i = 1 TO 6
   s(i * 2 - 1) = 2 ^ (i - 1) * 130.81
NEXT
FOR i = 1 TO 5
   s(i * 2) = 2 ^ (i - 1) * 196
NEXT

n = 3
ln = 2 ^ n - 1
DIM lin(ln)
FOR i = 1 TO n
   FOR ii = 2 ^ (i - 1) TO ln + 1 - 2 ^ (i - 1) STEP 2 ^ i
      lin(ii) = i
   NEXT
NEXT

DIM t10$(10, 6)
OPEN Filedat$ FOR RANDOM AS #1 LEN = 33
   FIELD #1, 15 AS Name$, 6 AS score$, 2 AS ring$, 5 AS tim$, 4 AS move$, 1 AS solve$
   IF EOF(1) <> 0 THEN GOTO Start
   FOR i = 1 TO 10
      GET #1, i
      t10$(i, 1) = Name$
      t10$(i, 2) = score$
      t10$(i, 3) = ring$
      t10$(i, 4) = tim$
      t10$(i, 5) = move$
      t10$(i, 6) = solve$
   NEXT

' *********
' * TITLE *
' *********
Start:
   CLOSE
   LOCATE 4
   COLOR 15
   PRINT "                                      The"
   PRINT
   COLOR 1
   PRINT "                                         "
   COLOR 7
   PRINT "                                       "
   COLOR 4
   PRINT "                                "
   COLOR 7
   IF endd = 2 THEN
      LOCATE 28
      PRINT "(C) 1995, SEAV Softwares Inc."
      in$ = INPUT$(1)
      SYSTEM
   END IF
   LOCATE 28: PRINT "                          Press any key to continue.  "
   in$ = INPUT$(1)
   csl = 1
   'GOSUB Cute
   CLS

Menu:
   COLOR 7
   FOR i = 1 TO n
      r(i) = i * 17 + 30
      rpeg(i) = 1
   NEXT
   rep = 0
   GOSUB Resets
   
   GOSUB Clsr
   LOCATE 1: PRINT "1.  Solve the puzzle by yourself        6.  Options                             "
   LOCATE 3: PRINT "2.  Let the computer solve it           7.  Exit                                "
   LOCATE 5: PRINT "3.  See the instructions                                                        "
   LOCATE 7: PRINT "4.  Set the number of rings                                                     "
   LOCATE 9: PRINT "5.  View the Top Ten                                                            "
   LOCATE 11: PRINT "    Choice (1-7)?                                                              "
   COLOR 7

   DO
      in$ = INPUT$(1)
   LOOP UNTIL VAL(in$) < 8 AND VAL(in$) > 0 OR in$ = "d" OR in$ = "s"
   COLOR 7
   IF in$ = "1" THEN GOTO Played3
   IF in$ = "2" THEN GOTO Played2
   IF in$ = "3" THEN GOTO Instruct
   IF in$ = "4" THEN GOTO Rings
   IF in$ = "5" THEN GOTO Topten
   IF in$ = "6" THEN GOTO Options
   IF in$ = "s" THEN
      IF sounds = 1 THEN sounds = 0 ELSE sounds = 1
      csl = 0: GOTO Menu
   END IF
   IF in$ = "d" THEN
      IF config = 2 THEN config = 3 ELSE config = 2
      csl = 1: GOTO Menu
   END IF
   endd = 2
   CLS
   GOTO Start

' ***************************
' * Set the number of rings *
' ***************************
Rings:
   GOSUB Clsr
   NN = n
   LOCATE 1
   DO
      DO
         LOCATE 1
         PRINT " Enter a number of rings (1-10):   "
         LOCATE 1, 34
         INPUT "", n$
      LOOP UNTIL ASC(n$) < 58 AND ASC(n$) > 48
   LOOP UNTIL VAL(n$) < 11 AND VAL(n$) > 0
   n = VAL(n$)

   ln = 2 ^ n - 1
   REDIM lin(ln)
   FOR i = 1 TO n
      FOR ii = 2 ^ (i - 1) TO ln + 1 - 2 ^ (i - 1) STEP 2 ^ i
         lin(ii) = i
      NEXT
   NEXT
   IF NN = n THEN csl = 0 ELSE csl = 1
   GOTO Menu

' ************************
' * See the instructions *
' ************************
Instruct:
   CLS
   COLOR 7
   PRINT " Instructions for TOWERS of HANOI"
   PRINT STRING$(80, 205)
   PRINT "   The TOWERS of HANOI is an educational puzzle that teaches logic, math and"
   PRINT " technique finding.  This game is made up of a platform on which three pegs are"
   PRINT " set up.  There are numerous rings of different sizes on which the game is"
   PRINT " played. "
   PRINT "   The object of the game is to move a specified number of rings from the first"
   PRINT " peg to the last peg in the smallest number of moves possible.  There are"
   PRINT " certain rules:  1) You must move one ring at a time and this will be"
   PRINT " considered a move;  and 2) You cannot place a larger ring on top of a smaller"
   PRINT " ring."
   LOCATE 28: PRINT " Press any key to continue."
   in$ = INPUT$(1)
   LOCATE 28: PRINT "                           "
   csl = 1
   GOSUB Clsr
   GOTO Menu

' ***********
' * Options *
' ***********
Options:
   GOSUB Clsr
   NN = config
   WHILE in$ <> "3"
      IF sounds = 1 THEN
         LOCATE 1: PRINT "1.  Sound       :  On "
      ELSE
         LOCATE 1: PRINT "1.  Sound       :  Off"
      END IF
      LOCATE 3: PRINT "2.  Perspective : "; RTRIM$(STR$(config)); "-Dimension"
      LOCATE 5: PRINT "3.  Exit"
      LOCATE 7: PRINT "    Press 1 or 2 to toggle switches; 3 to Exit"
      DO
         in$ = INPUT$(1)
      LOOP UNTIL in$ = "3" OR in$ = "2" OR in$ = "1"
      IF in$ = "1" THEN IF sounds = 1 THEN sounds = 0 ELSE sounds = 1
      IF in$ = "2" THEN
         IF config = 2 THEN config = 3 ELSE config = 2
         csl = 1: GOSUB Resets: csl = 0
      END IF
   WEND
   csl = 0
   GOSUB Clsr
   GOTO Menu


' *****************************
' * Let the computer solve it *
' *****************************
Played2:
   GOSUB Clsr
   IF n = 1 THEN
      LOCATE 6
      PRINT "          You must be some stupid to look for help with only one ring!          "
      IF sounds = 1 THEN PLAY "t200l48 o3 cc+dd+eff+gg+aa+bo4cp8o3fed+dc+c"
      in$ = INPUT$(1)
      GOTO Menu
   END IF
   LOCATE 1: PRINT "1.  Solve it slow and clear"
   LOCATE 3: PRINT "2.  Solve it at average speed"
   LOCATE 5: PRINT "3.  Solve it very, very fast"
   LOCATE 7: PRINT "4.  Exit"
   LOCATE 9: PRINT "    Choice (1-4)?"
   DO
      in$ = INPUT$(1)
   LOOP UNTIL in$ = "1" OR in$ = "2" OR in$ = "3" OR in$ = "4"
   SELECT CASE VAL(in$)
   CASE 1: dur = 2000
   CASE 2: dur = 800
   CASE 3: dur = 100
   END SELECT
   IF in$ = "4" THEN csl = 0: GOSUB Clsr: GOTO Menu
  
   LINE (0, 0)-(640, 192), 0, BF
   LOCATE 1: PRINT "Moves:    0"
   LOCATE 1, 65: PRINT "[ESC] - Exit"
   IF n / 2 = INT(n / 2) THEN dir = 2 ELSE dir = 1
   FOR rep = 1 TO ln
      NN = rpeg(lin(rep))
      ring = lin(rep)
      SELECT CASE dir
         CASE 1
            rpeg(lin(rep)) = rpeg(lin(rep)) + (2 ^ lin(rep) MOD 3)
            IF rpeg(lin(rep)) > 3 THEN rpeg(lin(rep)) = rpeg(lin(rep)) - 3
         CASE 2
            rpeg(lin(rep)) = rpeg(lin(rep)) - 2 ^ lin(rep) MOD 3
            IF rpeg(lin(rep)) < 1 THEN rpeg(lin(rep)) = rpeg(lin(rep)) + 3
      END SELECT
      IF sounds = 1 THEN
         SELECT CASE config
         CASE 2: SOUND s(ring), dur / 250
         CASE 3: SOUND s(ring), dur / 125
         END SELECT
      END IF
      GOSUB Showboard
      SELECT CASE config
         CASE 2
            FOR t = 1 TO dur: NEXT
         CASE 3
            FOR t = 1 TO dur * .75: NEXT
      END SELECT
      IF INKEY$ = CHR$(27) THEN endd = 3: rep = ln
   NEXT
   IF endd = 3 THEN endd = 0: SOUND 37, 0: csl = 1: GOSUB Clsr: GOTO Menu
   IF sounds = 1 THEN
      SOUND s(n + 1), dur / 175
      PLAY "t200l8 ml o2 p8 cgco3co2cgco3g"
   END IF
   LOCATE 11: PRINT "Press any key to continue."
   in$ = INPUT$(1)
   csl = 1
   GOSUB Clsr
   GOTO Menu

' ********************************
' * Solve the puzzle by yourself *
' ********************************
Played3:
   GOSUB Clsr
   LOCATE 1, 65: PRINT "[ESC] - Exit"
   LOCATE 1: PRINT "Moves:    0"

Played3.1:
   COLOR 7
   endd = 0
   inv = 0
   ring = 0
   LOCATE 3, 32: PRINT SPACE$(40)
   LOCATE 3: PRINT "Move the topmost ring of peg #"
   DO
      in$ = INKEY$
      LOCATE 3, 32: PRINT "  "
      in$ = INPUT$(1)
      IF rep = 0 THEN ftime$ = TIME$
      COLOR 3
      LOCATE 3, 32: PRINT in$
      COLOR 7
      pl = VAL(in$)
   LOOP UNTIL pl = 1 OR pl = 2 OR pl = 3 OR in$ = CHR$(27) OR in$ = CHR$(8)
   IF in$ = CHR$(27) THEN
      IF rep = 0 THEN csl = 0 ELSE csl = 1
      GOSUB Clsr
      GOTO Menu
   END IF
   IF in$ = CHR$(8) THEN GOTO Played3.1
   LOCATE 3, 34: PRINT "to peg #"
   DO
      LOCATE 3, 43: PRINT "  "
      in$ = INPUT$(1)
      COLOR 3
      LOCATE 3, 43: PRINT in$
      COLOR 7
      pl2 = VAL(in$)
   LOOP UNTIL (pl2 < 4 AND pl2 > 0 AND pl2 <> pl) OR in$ = CHR$(27) OR in$ = CHR$(8)
   IF in$ = CHR$(27) THEN
      IF rep = 0 THEN csl = 0 ELSE csl = 1
      GOSUB Clsr
      GOTO Menu
   END IF
   IF in$ = CHR$(8) THEN GOTO Played3.1

   FOR i = n TO 1 STEP -1
      IF rpeg(i) = pl THEN ring = i
   NEXT
   IF ring = 0 THEN
      COLOR 4
      LOCATE 9: PRINT "                           ERROR!!! No ring there!"
      in$ = INKEY$
      IF sounds = 1 THEN GOSUB Beep1 ELSE FOR t = 1 TO 1000: NEXT
      LOCATE 9: PRINT SPACE$(80)
      GOTO Played3.1
   END IF
   FOR i = ring - 1 TO 1 STEP -1
      IF pl2 = rpeg(i) THEN inv = 1
   NEXT
   IF inv = 1 THEN
      COLOR 4
      LOCATE 9: PRINT "            ERROR!!! Larger ring cannot be placed over smaller ring!"
      in$ = INKEY$
      IF sounds = 1 THEN GOSUB Beep1 ELSE FOR t = 1 TO 1000: NEXT
      LOCATE 9: PRINT SPACE$(80)
      GOTO Played3.1
   END IF
  
   NN = pl
   rpeg(ring) = pl2
   IF sounds = 1 THEN SOUND s(ring), 1
   rep = rep + 1
   GOSUB Showboard
   LOCATE 3: PRINT SPACE$(80)
  
   'check
   FOR i = 1 TO n
      IF rpeg(i) <> 3 THEN inv = 1
   NEXT
   IF inv = 0 THEN
      ltime$ = TIME$
      FOR i = 2 TO 3
         timed(i) = VAL(MID$(ltime$, i * 3 - 2, 2)) - VAL(MID$(ftime$, i * 3 - 2, 2))
         IF timed(i) < 0 THEN timed(i) = timed(i) + 60: timed(i - 1) = timed(i - 1) - 1
      NEXT
      IF rep = ln THEN
         LOCATE 3
         SELECT CASE n
            CASE 1
               PRINT " It's that simple, isn't it?"
               PRINT " Maybe you can stop being a baby and try three rings."
            CASE 2
               PRINT " Two ring's much too easy."
               PRINT " Try four rings."
            CASE 3 TO 4
               PRINT " Good!"
               PRINT " How about trying harder stuff?"
            CASE 5
               PRINT " You're becoming good!"
               PRINT " Now, try some more!"
            CASE 6
               PRINT " Nice shot! You must be good!"
               PRINT " How about seven rings?"
            CASE 7
               PRINT " Whoa! Even I can't do that (istir!)"
               PRINT " Would you like to try 8 rings?"
            CASE 8
               PRINT " Now that's pure and logical thinking!"
               PRINT " I've got to hand it to you, you grrreat!"
            CASE 9
               PRINT " Out of this world!"
               PRINT " How did you solve nine rings with 511 moves?"
            CASE 10
               PRINT " Congratulations!       "
               PRINT " No doubt about your ultimate solving power!"
               PRINT " How about solving the legendary 64-ring puzzle in Hanoi?"
         END SELECT
         GOSUB Timered
         IF sounds = 1 THEN PLAY "t200l8 ml o2 p8 cgco3co2cgco3g"
         endd = 1
      ELSE
         LOCATE 3
         IF n = 1 THEN
            PRINT " One ring? You really must be some stupid!"
         ELSE
            PRINT " You solved the puzzle!"
            PRINT " But unfortunately, you didn't solve it in the"
            PRINT " least number of moves which is "; LTRIM$(RTRIM$(STR$(ln))); "."
         END IF
         IF rep - ln <> 1 THEN
            PRINT " You exceeded by"; rep - ln; "moves."
         ELSE
            PRINT " You exceeded by a move."
         END IF
         GOSUB Timered
         IF sounds = 1 THEN PLAY "t200l8 ml o2 p8 cgco3c"
         endd = 1
      END IF
   END IF
   IF endd = 1 THEN
      LOCATE 11: PRINT "Press any key to continue."
      in$ = INPUT$(1)
      GOSUB Scoring
      IF P10 <> 0 THEN in$ = "y": GOTO Topten
      csl = 1
      GOSUB Clsr
      GOTO Menu
   END IF
   GOTO Played3.1

' ********************
' * View the Top Ten *
' ********************
Topten:
   GOSUB Clsr
   COLOR 7
   LOCATE 1, 13: PRINT "      No  Name             Score  Rings  Time   Moves     Solved "
   LOCATE 2, 13: PRINT "   " + STRING$(62, 205) + ""
   FOR i = 1 TO 10
      LOCATE i + 2, 13
           PRINT USING "      ##  \             \  ######   ##   \   \  \  \/####    \\  "; i; t10$(i, 1); VAL(t10$(i, 2)); VAL(t10$(i, 3)); t10$(i, 4); t10$(i, 5); 2 ^ VAL(t10$(i, 3)) - 1; t10$(i, 6)
   NEXT
   COLOR 4
   LOCATE 3, 15: PRINT "T": LOCATE 4, 15: PRINT "O": LOCATE 5, 15: PRINT "P"
   LOCATE 8, 15: PRINT "T": LOCATE 9, 15: PRINT "E": LOCATE 10, 15: PRINT "N"
   COLOR 7
   COLOR 14
   IF in$ = "y" THEN LOCATE P10 + 2, 19: PRINT CHR$(16)
   COLOR 7
   LOCATE 4
   '      123456789012
   PRINT "  Just"
   PRINT "  press"
   PRINT "  any"
   PRINT "  key"
   PRINT "  to"
   PRINT "  continue"
   in$ = INPUT$(1)
   csl = 0
   GOSUB Clsr
   GOTO Menu

' ***************
' * Subroutines *
' ***************
Showboard:
   LOCATE 1: PRINT USING "Moves: ####"; rep
  
   SELECT CASE config
      CASE 3
         'remove ring
         pile = 0
         FOR ii = ring TO n
            IF NN = rpeg(ii) THEN pile = pile + 1
         NEXT
         'pile = pile - 1
         CIRCLE (NN * 210 - 100, 419 - pile * 20), r(ring) / 2, 0, , , 1 / 5
         CIRCLE (NN * 210 - 100, 419 - pile * 20 + 17), r(ring) / 2, 0, 1 * Pi, 0, 1 / 5
         LINE (NN * 210 - (200 - r(ring)) / 2, 419 - pile * 20)-(NN * 210 - (200 - r(ring)) / 2, 419 - pile * 20 + 17), 0
         LINE (NN * 210 - 100 - r(ring) / 2, 419 - pile * 20)-(NN * 210 - 100 - r(ring) / 2, 419 - pile * 20 + 17), 0
         PAINT (NN * 210 - 100, 419 - pile * 20 - 1), 0, 0
         PAINT (NN * 210 - 100, 419 - pile * 20 + r(ring) / 5.7), 0, 0
         IF pile > 0 THEN
            'draw ring below
            FOR ii = n TO ring STEP -1
               IF NN = rpeg(ii) THEN ringg = ii
            NEXT
            pile = pile - 1
            CIRCLE (rpeg(ringg) * 210 - 100, 419 - pile * 20), r(ringg) / 2, 7, , , 1 / 5
            PAINT (rpeg(ringg) * 210 - 100, 419 - pile * 20 - 1), 15, 7
            CIRCLE (rpeg(ringg) * 210 - 100, 419 - pile * 20), 5, 8, , , 1 / 5
            LINE (rpeg(ringg) * 210 - 95, 419 - pile * 20)-(rpeg(ringg) * 210 - 105, 222), 8, B
            LINE (rpeg(ringg) * 210 - 96, 419 - pile * 20)-(rpeg(ringg) * 210 - 104, 222), 6, BF
         ELSE
            'draw platform
            LINE (NN * 210 - 200, 416)-(NN * 210, 456), 8, B
            LINE (NN * 210 - 199, 417)-(NN * 210 - 1, 455), 6, BF
            LINE (NN * 210 - 95, 400)-(NN * 210 - 105, 436), 8, B
            LINE (NN * 210 - 96, 400)-(NN * 210 - 104, 436), 6, BF
            CIRCLE (NN * 210 - 100, 436), 5, 8, 1 * Pi, 0, 1 / 5
         END IF
        
         'place ring
         pile = 0
         FOR ii = ring TO n
            IF rpeg(ring) = rpeg(ii) THEN pile = pile + 1
         NEXT
         pile = pile - 1
         LINE (rpeg(ring) * 210 - (200 - r(ring)) / 2 - 1, 419 - pile * 20)-(rpeg(ring) * 210 - 99 - r(ring) / 2, 419 - pile * 20 + 16), 0, BF
         CIRCLE (rpeg(ring) * 210 - 100, 419 - pile * 20), r(ring) / 2, 7, , , 1 / 5
         CIRCLE (rpeg(ring) * 210 - 100, 419 - pile * 20 + 17), r(ring) / 2, 7, 1 * Pi, 0, 1 / 5
         LINE (rpeg(ring) * 210 - (200 - r(ring)) / 2, 419 - pile * 20)-(rpeg(ring) * 210 - (200 - r(ring)) / 2, 419 - pile * 20 + 17), 7
         LINE (rpeg(ring) * 210 - 100 - r(ring) / 2, 419 - pile * 20)-(rpeg(ring) * 210 - 100 - r(ring) / 2, 419 - pile * 20 + 17), 7
         PAINT (rpeg(ring) * 210 - 100, 419 - pile * 20 + 18), 0, 7
         PAINT (rpeg(ring) * 210 - 100, 419 - pile * 20 - 1), 15, 7
         PAINT (rpeg(ring) * 210 - 100, 419 - pile * 20 + r(ring) / 5.7), 7, 7
         CIRCLE (rpeg(ring) * 210 - 100, 419 - pile * 20), 5, 8, , , 1 / 5
         LINE (rpeg(ring) * 210 - 95, 419 - pile * 20)-(rpeg(ring) * 210 - 105, 222), 8, B
         LINE (rpeg(ring) * 210 - 96, 419 - pile * 20)-(rpeg(ring) * 210 - 104, 222), 6, BF
      CASE 2
         'remove ring
         pile = 0
         FOR ii = ring TO n
            IF NN = rpeg(ii) THEN pile = pile + 1
         NEXT
         'pile = pile - 1
         LINE (NN * 210 - (200 - r(ring)) / 2, 429 - pile * 20)-(NN * 210 - 100 - r(ring) / 2, 429 - pile * 20 - 17), 0, BF
         LINE (NN * 210 - 95, 429 - pile * 20)-(NN * 210 - 105, 429 - pile * 20 - 17), 6, BF

         'place ring
         pile = 0
         FOR ii = ring TO n
            IF rpeg(ring) = rpeg(ii) THEN pile = pile + 1
         NEXT
         pile = pile - 1
         LINE (rpeg(ring) * 210 - (200 - r(ring)) / 2, 429 - pile * 20)-(rpeg(ring) * 210 - 100 - r(ring) / 2, 429 - pile * 20 - 17), 15, BF
   END SELECT
   RETURN

Resets:
   IF csl = 1 THEN
      LOCATE 13: COLOR 7: PRINT STRING$(80, 205)
      SELECT CASE config
         CASE 3
            FOR i = 1 TO 3
               COLOR 3
               LOCATE 14, i * 27 - 26: PRINT " Peg #"; i
               LINE (i * 210 - 200, 223)-(i * 210 - 106, 415), 0, BF
               LINE (i * 210 - 94, 223)-(i * 210, 415), 0, BF
               LINE (i * 210 - 200, 416)-(i * 210, 456), 8, B
               LINE (i * 210 - 199, 417)-(i * 210 - 1, 455), 6, BF
               LINE (i * 210 - 200, 456)-(i * 210, 470), 8, B
               LINE (i * 210 - 199, 457)-(i * 210 - 1, 469), 6, BF
               LINE (i * 210 - 95, 220)-(i * 210 - 105, 436), 8, B
               LINE (i * 210 - 96, 220)-(i * 210 - 104, 436), 6, BF
               LINE (i * 210 - 95, 200)-(i * 210 - 105, 219), 0, BF
               CIRCLE (i * 210 - 100, 220), 5, 8, , , 1 / 5
               CIRCLE (i * 210 - 100, 436), 5, 8, 1 * Pi, 0, 1 / 5
            NEXT
            FOR i = n TO 1 STEP -1
               LINE (rpeg(i) * 210 - (200 - r(i)) / 2 - 1, 419 - (n - i) * 20)-(rpeg(i) * 210 - 99 - r(i) / 2, 419 - (n - i) * 20 + 16), 0, BF
               CIRCLE (rpeg(i) * 210 - 100, 419 - (n - i) * 20), r(i) / 2, 7, , , 1 / 5
               CIRCLE (rpeg(i) * 210 - 100, 419 - (n - i) * 20 + 17), r(i) / 2, 7, 1 * Pi, 0, 1 / 5
               LINE (rpeg(i) * 210 - (200 - r(i)) / 2, 419 - (n - i) * 20)-(rpeg(i) * 210 - (200 - r(i)) / 2, 419 - (n - i) * 20 + 17), 7
               LINE (rpeg(i) * 210 - 100 - r(i) / 2, 419 - (n - i) * 20)-(rpeg(i) * 210 - 100 - r(i) / 2, 419 - (n - i) * 20 + 17), 7
               PAINT (rpeg(i) * 210 - 100, 419 - (n - i) * 20 - 1), 15, 7
               PAINT (rpeg(i) * 210 - 100, 419 - (n - i) * 20 + r(i) / 5.7), 7, 7
               IF i = 1 THEN
                  CIRCLE (rpeg(i) * 210 - 100, 419 - (n - i) * 20), 5, 8, , , 1 / 5
                  LINE (i * 210 - 95, 419 - (n - i) * 20)-(i * 210 - 105, 222), 8, B
                  LINE (i * 210 - 96, 419 - (n - i) * 20)-(i * 210 - 104, 222), 6, BF
               END IF
            NEXT
         CASE 2
            FOR i = 1 TO 3
               COLOR 3
               LOCATE 14, i * 27 - 26: PRINT " Peg #"; i
               LINE (i * 210 - 200, 432)-(i * 210, 470), 6, BF
               LINE (i * 210 - 95, 210)-(i * 210 - 105, 431), 6, BF
               LINE (i * 210 - 200, 431)-(i * 210 - 106, 223), 0, BF
               LINE (i * 210 - 94, 223)-(i * 210, 431), 0, BF
            NEXT
            FOR i = 1 TO n
               LINE (rpeg(i) * 210 - (200 - r(i)) / 2, 429 - (n - i) * 20)-(rpeg(i) * 210 - 100 - r(i) / 2, 429 - (n - i) * 20 - 17), 15, BF
            NEXT
      END SELECT
   END IF
   COLOR 7
   RETURN

Clsr:
   LINE (0, 0)-(640, 192), 0, BF
   RETURN

Beep1:
   FOR i = 1 TO 250
      SOUND 400, .05
      SOUND 200, .05
   NEXT
   RETURN

Timered:
   PRINT
   PRINT USING " Solving time: ##:##"; timed(2); timed(3)
   IF timed(2) < 10 THEN LOCATE CSRLIN - 1, 16: PRINT "0"
   IF timed(3) < 10 THEN LOCATE CSRLIN - 1, 19: PRINT "0"
  
   'score
   score1 = timed(2) * 60 + timed(3)
   score1 = score1 - ln
   'time evaluation
      score = score1 / -1 * (1 / ln) * 100
   'difficulty bonus
      score = score + ln
   'solving bonus
      IF rep = ln THEN score = score + (2 * ln)
   score = CINT(score)
   SELECT CASE n
   CASE 1: score = score - 75
   CASE 2: score = score - 45
   CASE 3: score = score - 15
   CASE 4: score = score + 15
   CASE 5: score = score + 45
   CASE 6: score = score + 100
   CASE 7: score = score + 130
   CASE 8: score = score + 160
   CASE 9: score = score + 190
   CASE 10: score = score + 220
   END SELECT
   PRINT USING "        Score: #####"; score
   RETURN


Scoring:
   P10 = 0
   FOR i = 1 TO 10
      IF score > VAL(t10$(i, 2)) THEN P10 = i: i = 10
   NEXT
   IF P10 <> 0 THEN
      'get name
      GOSUB Clsr
      LOCATE 1: PRINT "You've got a high score!"
      IF sounds = 1 THEN PLAY "t200l8 ml o3 p8 cgco4co3cgco4g"
      DO
         INPUT "Enter your name: ", Named$
      LOOP UNTIL Named$ <> ""
     
      'use time
      Tim1$ = LTRIM$(RTRIM$(STR$(timed(2))))
      Tim2$ = LTRIM$(RTRIM$(STR$(timed(3))))
      IF timed(2) < 10 THEN Tim1$ = "0" + LTRIM$(RTRIM$(STR$(timed(2))))
      IF timed(3) < 10 THEN Tim2$ = "0" + LTRIM$(RTRIM$(STR$(timed(3))))
      Timd$ = Tim1$ + ":" + Tim2$
      IF rep = ln THEN in$ = "Y" ELSE in$ = "N"

      'arrange everything
      FOR ii = 10 TO P10 + 1 STEP -1
         t10$(ii, 1) = t10$(ii - 1, 1)
         t10$(ii, 2) = t10$(ii - 1, 2)
         t10$(ii, 3) = t10$(ii - 1, 3)
         t10$(ii, 4) = t10$(ii - 1, 4)
         t10$(ii, 5) = t10$(ii - 1, 5)
         t10$(ii, 6) = t10$(ii - 1, 6)
      NEXT
     
      t10$(P10, 1) = Named$
      t10$(P10, 2) = LTRIM$(STR$(score))
      t10$(P10, 3) = LTRIM$(STR$(n))
      t10$(P10, 4) = Timd$
      t10$(P10, 5) = LTRIM$(STR$(rep))
      t10$(P10, 6) = in$
   END IF

   'save top ten
   IF P10 <> 0 THEN
      OPEN Filedat$ FOR RANDOM AS #1 LEN = 33
         FIELD #1, 15 AS Name$, 6 AS score$, 2 AS ring$, 5 AS tim$, 4 AS move$, 1 AS solve$
         FOR i = 1 TO 10
            LSET Name$ = t10$(i, 1)
            RSET score$ = t10$(i, 2)
            RSET ring$ = t10$(i, 3)
            LSET tim$ = t10$(i, 4)
            LSET move$ = t10$(i, 5)
            LSET solve$ = t10$(i, 6)
            PUT #1, i
         NEXT
      CLOSE
   END IF
   RETURN


