'***************************************************************************
'
' Midnight Oil -- A Solitare Game
'
'  (c) Copyright 1989-95 by Randy Rasa
'                           18215 Troost
'                           Olathe, KS 66062
'
'  Notice: This source code is provided for reference and educational
'          purposes only, and is protected under United States Copyright
'          Law.  In other words, you may look this over, learn from it,
'          and play with it, but not steal it.  Questions, comments, and
'          suggestions are encouraged, and may be sent to the author at
'          the above address.
'
'   Command Line Syntax:  MO [/Q][/M]
'           /Q = quiet mode -- most noises will be stifled
'           /M = mono mode -- black and white video
'
'***************************************************************************
'
'   Revision History
'
' Revision   Date   Description
' -------- -------- ----------------------------------------------------
'   0.00   10-23-89 program started
'   1.00   11-08-89 released to public
'   1.01   11-12-89 - change README on title screen to DOC
'                   - use left mouse button to select, right to escape
'                   - for new game, go back to title screen
'   1.02   12-03-89 - get rid of Trefoil option to simplify scoring
'                   - make middle mouse button (or "B") blank screen
'                   - make options inverse text instead of boxes
'                   - add "Sound On/Off" option on-screen
'                   - only allow options when selecting first card
'   1.03   03-03-90 - restore Trefoil Option
'                   - add "WIN" or "LOSE" finish
'   1.04   03-23-90 - add "Esc to Cancel" message during draw
'                   - fix to allow backing out of "Draw" without
'                     corrupting screen
'                   - make F1 = Help
'   1.05   04-24-90 - add "Undo" command, limited to the last move only
'   1.10   05-07-90 - add Color Set options ("/1", "/2", "/3")
'                   - add configuration file (MO.CFG) option
'                   - add command-line help
'   1.11   05-13-90 - change file-read routines to QuickPak Professional
'   1.20   06-10-90 - fix to observe sound off after losing game
'                   - add scoring option
'                   - fix so that cards cannot be put on wrong
'                     foundation during auto-scan
'   1.21   08-11-90 - set screen size to 25 x 80 and restore on exit
'   1.30   08-30-90 - add "Setup" option to main menu, get rid of old
'                     method using config file
'                   - removed "shell to DOS" option
'                   - add Auto mode
'   1.31   10-07-90 - add "Quit" option to title screen
'                   - don't do auto-scan after initial deal
'   1.32   11-03-90 - Allow "boss key" to work after a card is selected
'                   - If a new game is requested before any moves have
'                     been made, give option of bypassing the main screen.
'                   - Add setup option for a "strict" or "relaxed" draw.
'   1.33   12-17-90 - Fix "Draw" bug, where the fan you drew from would move
'                     to the bottom of the screen and be unavailable for
'                     play if an invalid move was attempted with the drawn
'                     card, and then Esc was pressed.
'                   - Assign "Shell to DOS" to F10.
'   1.34   01-19-91 - Make changes to accomodate MO 2.xx data file.
'   1.35   09-02-91 - Make program totally freeware.
'   1.36   02-04-95 - Updated for final freeware release.
'
'
'***************************************************************************
'
' Midnight Oil was written with QuickBASIC 4.5, compiled to
' a stand-alone EXE file, and linked with NOCOM.OBJ and
' SMALLERR.OBJ (included with QB) to reduce the file size.
'
' This program makes use of routines provided in the
' QuickPak Professional library published by
'       Crescent Software, Inc.
'       11 Grandview Avenue
'       Stamford, CT 06905
'       (203) 846-2500
' The library is excellent and definitely recommended.
'
' Since this program calls routines in an external library,
' and I cannot distribute that library, I have included a
' "Quick Library" (MO.QLB), which contains the external
' routines in a form usable within the QuickBASIC environment.
' Use the command line:
'       QB MO /L MO.QLB
' to load the program and quick library into QuickBASIC.
' You will be able to run the program, make changes, and
' fool around with the program all you want, but you will
' not be able to compile to an EXE file.  If you really want
' to do this you will either need to buy QuickPak Professional,
' or substitute your own routines.
'
'***************************************************************************

	DEFINT A-Z
'
' QuickPak Professional routines
'
	DECLARE SUB Box0 (ULRow%, ULCol%, LRRow%, LRCol%, Char%, Colr%)
	DECLARE SUB GetCursor (x%, y%, button%)
	DECLARE SUB HideCursor ()
	DECLARE SUB InitMouse (There%)
	DECLARE SUB MouseTrap (ULRow%, ULCol%, LRRow%, LRCol%)
	DECLARE SUB SetCursor (x%, y%)
	DECLARE SUB ShowCursor ()
	DECLARE SUB TextCursor (fg%, bg%)
	DECLARE SUB ScrnSave0 (ULRow%, ULCol%, LRRow%, LRCol%, SEG Element%)
	DECLARE SUB ScrnRest0 (ULRow%, ULCol%, LRRow%, LRCol%, SEG Element%)
	DECLARE FUNCTION OneColor% (fg%, bg%)
	DECLARE SUB GetVMode (Mode%, Page%, PageSize%, rows%, columns%)
	DECLARE SUB Pause (Ticks%)
	DECLARE SUB Chime (TuneNumber%)
'
' RAR's routines
'
	DECLARE SUB CardMove (FanNum%, CardValue%, Action%)
	DECLARE SUB DrawACard (FanNum%, CardValue%, Action%)
	DECLARE SUB DspFan (FanNum%, Action%)
	DECLARE SUB DspFoundation (FoundNum%)
	DECLARE SUB DspScore ()
	DECLARE FUNCTION Legal% (OldPile%, NewPile%)
	DECLARE SUB Mork (Key$, x%, y%)
	DECLARE FUNCTION YesOrNo$ ()
	DECLARE SUB Display (row%, Col%, Text$, FGColor%, BGColor%)
	DECLARE SUB DspCard (ULRow%, ULCol%, CardNum%, Action%)
	DECLARE FUNCTION Exists% (FileName$)
	DECLARE FUNCTION Legal% (OldPile%, NewPile%)
'
' Program Constants
'
	CONST FALSE = 0, TRUE = NOT FALSE
	CONST Black = 0, Blue = 1, Green = 2, Cyan = 3, Red = 4, Magenta = 5, Brown = 6, White = 7
	CONST Gray = 8, BrightBlue = 9, BrightGreen = 10, BrightCyan = 11
	CONST BrightRed = 12, BrightMagenta = 13, Yellow = 14, BrightWhite = 15

	TYPE RegTypeX               'Type Declaration for INTERRUPTX
		 AX    AS INTEGER
		 bx    AS INTEGER
		 CX    AS INTEGER
		 DX    AS INTEGER
		 bp    AS INTEGER
		 si    AS INTEGER
		 di    AS INTEGER
		 flags AS INTEGER
		 DS    AS INTEGER
		 es    AS INTEGER
	END TYPE
	DECLARE SUB InterruptX (intnum AS INTEGER, inreg AS RegTypeX, outreg AS RegTypeX)
	DIM SHARED InRegs AS RegTypeX, OutRegs AS RegTypeX
'
'   The start of the program.
'
	CALL GetVMode(VideoMode, VideoPage, PageSize, OldRows, OldCols)
	REDIM scrn1(PageSize)                     'arrays to save screens
	REDIM Scrn2(2000)
	CALL ScrnSave0(1, 1, OldRows, 80, SEG scrn1(0))      'save calling screen

	StartingRow = CSRLIN: StartingCol = POS(0)
	StartColor = SCREEN(StartingRow, StartingCol, 1)
	CALL SplitColor(StartColor, StartColorFG, StartColorBG)

	cmnd$ = UCASE$(COMMAND$)
	IF INSTR(cmnd$, "?") <> 0 THEN
		PRINT
		PRINT "Midnight Oil 1.36                                Copyright 1989-95 by Randy Rasa"
		PRINT STRING$(80, 205)
		PRINT " Syntax: MO [?][/Q][/M]"
		PRINT "  Where:  ? = Command line help"
		PRINT "         /Q = Quiet mode (no sound)"
		PRINT "         /M = Monochrome video (black & white)"
		PRINT : PRINT
		END
	END IF

	Video = 0
	IF INSTR(cmnd$, "/Q") <> 0 THEN Quiet = TRUE ELSE Quiet = FALSE   'check for quiet mode
	IF INSTR(cmnd$, "/M") <> 0 THEN Video = &HB4
	DataFile$ = "MO.DAT"
	IF Exists(DataFile$) THEN
		OPEN DataFile$ FOR INPUT AS #2
		INPUT #2, TotalScores&, AvgScore!, NumGames, GamesWon
		IF NOT EOF(2) THEN
			IF Video = 0 THEN
				INPUT #2, foreground, background, highlight, RedColor, BlackColor, InverseFG, InverseBG
				IF foreground <> background THEN Video = 99
			ELSE
				INPUT #2, dummy, dummy, dummy, dummy, dummy, dummy, dummy
			END IF
			IF Quiet = FALSE THEN
				INPUT #2, Quiet
			ELSE
				INPUT #2, dummy
			END IF
			INPUT #2, AutoMode
			IF NOT EOF(2) THEN
				INPUT #2, StrictDraw
			END IF
		END IF
		CLOSE
	ELSE
		StrictDraw = TRUE
	END IF
	IF Video = 0 THEN
		DEF SEG = 0
		Video = PEEK(&H463)                 'check for color card
	END IF
	SELECT CASE Video
		CASE &HB4       'mono
			foreground = White      'mono
			background = Black
			highlight = BrightWhite
			InverseFG = Black: InverseBG = White
			RedColor = BrightWhite: BlackColor = White
		CASE 99                     'custom
		CASE ELSE                   'default colors
			foreground = Black
			background = White
			highlight = Blue
			InverseFG = BrightCyan: InverseBG = Blue
			RedColor = Red: BlackColor = Black
	END SELECT

	CALL InitMouse(mouse%)          'check for mouse (returns 0=no mouse, 1=mouse present)
	IF NOT mouse THEN
		PRINT "A mouse is required."
		END
	END IF
	CALL TextCursor(-2, -2)         'set text cursor to be inverse
	'
	' Opening Screen
	'
titles:
	norm = OneColor(foreground, background)
	hl = OneColor(highlight, background)
	inv = OneColor(InverseFG, InverseBG)
	WIDTH 80, 25        'set screen size to 80 columns by 25 rows
	SCREEN 0: COLOR foreground, background: CLS
	Display 2, 0, " Ŀ Ŀ    Ŀ         Ŀ        Ŀ      Ŀ     Ŀ Ŀ Ŀ ", highlight, background
	Display 3, 0, "                                          Ŀ     ", highlight, background
	Display 4, 0, "      Ŀ   Ŀ Ŀ Ŀ  Ŀ           Ŀ   ", highlight, background
	Display 5, 0, "             Ŀ        Ŀ    Ŀ          ", highlight, background
	Display 6, 0, "       Ŀ           ", highlight, background
	Display 7, 0, "                                                                      ", highlight, background
	Display 8, 0, "ٰ", highlight, background
	Display 9, 0, STRING$(75, 177), highlight, background
	Display 10, 0, STRING$(75, 178), highlight, background
	Display 12, 0, "Version 1.36", highlight, background
	Display 14, 0, "By Randy Rasa", foreground, background
	Display 15, 0, "18215 Troost", foreground, background
	Display 16, 0, "Olathe, KS 66062", foreground, background
	Display 17, 0, "(C) Copyright 1989-95 by Randy Rasa", foreground, background
	DO
		CALL Display(25, 0, "Instructions, Setup, play Midnight Oil, play Trefoil, or Quit (I/S/M/T/Q)?", foreground, background)
		CALL MouseTrap(25, 66, 25, 74)      'set mouse limits
		CALL SetCursor(64, 25)              'set mouse cursor
		CALL Mork(ans$, x, y)
		IF x = 66 OR ans$ = "I" THEN GOSUB help: GOTO titles
		IF x = 68 OR ans$ = "S" THEN GOSUB Setup: GOTO titles
		IF x = 70 OR ans$ = "M" THEN Game$ = "M": GOTO Start
		IF x = 72 OR ans$ = "T" THEN Game$ = "T": GOTO Start
		IF x = 74 OR ans$ = "Q" THEN GOTO TheEnd
		IF NOT Quiet THEN SOUND 550, .5
	LOOP
	'
	' Instructions
	'
help:
	COLOR foreground, background: CLS
	PRINT
	COLOR InverseFG, InverseBG: PRINT " MIDNIGHT OIL ";
	COLOR foreground, background: PRINT "    (A.K.A. La Belle Lucie, Clover Leaf, Alexander The Great)"
	PRINT
	PRINT " In Midnight Oil, the deck is dealt into eighteen fans of three cards each."
	PRINT " The object is to move the four aces, as they become available, to the"
	PRINT " foundations, which are then built up in suit to king.  Only the top card of"
	PRINT " each fan is available for play.  The fans may be built down in suit, taking a"
	PRINT " card from the top of one fan and moving it to another.  When selecting the"
	PRINT " first card, if you click on one of the foundations, the fans will be scanned"
	PRINT " for valid plays.  If a playable card is found, it will be pulled from its fan"
	PRINT " and placed on the foundation."
	PRINT
	PRINT " You are allowed to re-shuffle the deck two times, and then draw a buried card"
	PRINT " from a fan and play it on another fan or on a foundation.  At any time you may"
	PRINT " peek into a fan, ask for help, undo the last move, start a new game, or quit. "
	PRINT " The Esc key is the 'boss switch' - pressing it will blank the screen.  Press"
	PRINT " any key to restore it.  In general, the left mouse button is used to select,"
	PRINT " and the right button means Esc (or cancel)."
	PRINT
	COLOR InverseFG, InverseBG: PRINT " TREFOIL ";
	COLOR foreground, background: PRINT "    (A.K.A. Three Shuffles and a Draw)"
	PRINT " Trefoil is the same as Midnight Oil, except that the four aces are put on the"
	PRINT " foundations in advance, thus making the game a bit easier.";
	GOSUB PressAnyKey
	RETURN
	'
	' Setup
	'
Setup:
	COLOR White, Black: CLS
	LOCATE 4, 3: PRINT " Foreground +-"
	LOCATE 5, 3: PRINT " Background +-"
	LOCATE 6, 3: PRINT "  Highlight +-"
	LOCATE 7, 3: PRINT " Inverse FG +-"
	LOCATE 8, 3: PRINT " Inverse BG +-"
	LOCATE 9, 3: PRINT "  Red Cards +-"
	LOCATE 10, 3: PRINT "Black Cards +-"
	LOCATE 4, 46: PRINT "Use the mouse to select a new"
	LOCATE 5, 46: PRINT "color scheme.  Press 'Enter'"
	LOCATE 6, 46: PRINT "or the right mouse button"
	LOCATE 7, 46: PRINT "when finished."
	Display 1, 0, " Midnight Oil Setup ", Black, White
	CALL Box0(3, 20, 12, 43, 1, White)
	DO
		Done = FALSE
		CALL ClearScr0(4, 21, 11, 42, OneColor(foreground, background))
		Display 4, 26, "Normal Text", foreground, background
		Display 5, 25, "Highlight Text", highlight, background
		Display 6, 25, " Inverse Text ", InverseFG, InverseBG
		CALL DspCard(7, 25, 6, 0)
		CALL DspCard(7, 34, 36, 0)
		CALL MouseTrap(4, 15, 10, 16)
		CALL Mork(k$, x, y)
		IF k$ = "" THEN
			SELECT CASE y
				CASE 4
					IF x = 15 THEN
						foreground = foreground + 1
						IF foreground > 15 THEN foreground = 0
					ELSE
						foreground = foreground - 1
						IF foreground < 0 THEN foreground = 15
					END IF
				CASE 5
					IF x = 15 THEN
						background = background + 1
						IF background > 7 THEN background = 0
					ELSE
						background = background - 1
						IF background < 0 THEN background = 7
					END IF
				CASE 6
					IF x = 15 THEN
						highlight = highlight + 1
						IF highlight > 15 THEN highlight = 0
					ELSE
						highlight = highlight - 1
						IF highlight < 0 THEN highlight = 15
					END IF
				CASE 7
					IF x = 15 THEN
						InverseFG = InverseFG + 1
						IF InverseFG > 15 THEN InverseFG = 0
					ELSE
						InverseFG = InverseFG - 1
						IF InverseFG < 0 THEN InverseFG = 15
					END IF
				CASE 8
					IF x = 15 THEN
						InverseBG = InverseBG + 1
						IF InverseBG > 7 THEN InverseBG = 0
					ELSE
						InverseBG = InverseBG - 1
						IF InverseBG < 0 THEN InverseBG = 7
					END IF
				CASE 9
					IF x = 15 THEN
						RedColor = RedColor + 1
						IF RedColor > 15 THEN RedColor = 0
					ELSE
						RedColor = RedColor - 1
						IF RedColor < 0 THEN RedColor = 15
					END IF
				CASE 10
					IF x = 15 THEN
						BlackColor = BlackColor + 1
						IF BlackColor > 15 THEN BlackColor = 0
					ELSE
						BlackColor = BlackColor - 1
						IF BlackColor < 0 THEN BlackColor = 15
					END IF
			END SELECT
		ELSE
			IF k$ = CHR$(13) OR k$ = CHR$(27) THEN Done = TRUE
		END IF
	LOOP UNTIL Done
	CALL Display(14, 1, "Draw Rule: 1 - Strict: draw only after the third shuffle.", White, Black)
	CALL Display(15, 1, "           2 - Relaxed: draw at any time.", White, Black)
	CALL Display(16, 1, "Which draw rule do you want to use (1/2)?", White, Black)
	CALL MouseTrap(16, 37, 16, 39)      'set mouse limits
	CALL SetCursor(37, 16)              'set mouse cursor
	DO
		Done = FALSE
		CALL Mork(ans$, x, y)
		IF x = 37 OR ans$ = "1" THEN
			StrictDraw = TRUE
			PRINT " 1"
			Done = TRUE
		END IF
		IF x = 39 OR ans$ = "2" THEN
			StrictDraw = FALSE
			PRINT " 2"
			Done = TRUE
		END IF
	LOOP UNTIL Done
	 
	CALL Display(18, 1, "Do you want to clear all scores (Y/N)?", White, Black)
	IF YesOrNo$ = "Y" THEN
		TotalScores& = 0
		AvgScore! = 0
		NumGames = 0
		GamesWon = 0
	END IF
	GOSUB SaveScores        'save configuration info
	RETURN
	'
	' Start the game
	'
Start:
	RANDOMIZE TIMER
	COLOR foreground, background: CLS
	'
	' Card Number Table:
	'
	'           |       Suit
	'     Value |H(3) D(4) C(5) S(6)
	'     ------|---- ---- ---- ----
	'         A |  1   14   27   40
	'         2 |  2   15   28   41
	'         3 |  3   16   29   42
	'         4 |  4   17   30   43
	'         5 |  5   18   31   44
	'         6 |  6   19   32   45
	'         7 |  7   20   33   46
	'         8 |  8   21   34   47
	'         9 |  9   22   35   48
	'        10 | 10   23   36   49
	'         J | 11   24   37   50
	'         Q | 12   25   38   51
	'         K | 13   26   39   52
	'
	'
	' Initialize the card deck
	'
	REDIM card(53)
	IF Game$ = "M" THEN
		FOR n = 1 TO 52
			card(n) = n
		NEXT
		NumCards = 52
	ELSE
		FOR n = 1 TO 12
			card(n) = n + 1
			card(n + 12) = card(n) + 13
			card(n + 24) = card(n) + 26
			card(n + 36) = card(n) + 39
		NEXT
		NumCards = 48
	END IF
	WinScore = NumCards
	'
	' Set up game screen
	'
	CLS
	CALL Box0(1, 1, 17, 69, 1, norm)
	CALL Box0(18, 1, 24, 35, 1, norm)
	CALL Box0(18, 36, 24, 69, 1, norm)
	COLOR InverseFG, InverseBG
	LOCATE 1, 23: PRINT " M I D N I G H T   O I L "
	LOCATE 2, 71: PRINT " Shuffle  "
	LOCATE 4, 71: PRINT " Draw     "
	LOCATE 6, 71: PRINT " Peek     "
	GOSUB DspSoundStat
	GOSUB DspAutoStat
	LOCATE 12, 71: PRINT " Help     "
	LOCATE 14, 71: PRINT " Undo     "
	LOCATE 16, 71: PRINT " New      "
	LOCATE 18, 71: PRINT " Quit     "
	GOSUB shuffle
	REDIM Fan(20, 15)
	REDIM Foundation(4)
	IF Game$ = "M" THEN
		FOR n = 1 TO 4
			CALL DspFoundation(n + 100)
			Foundation(n) = (n - 1) * 13        'initialize foundations
		NEXT
	ELSE
		FOR n = 1 TO 4
			Foundation(n) = (n - 1) * 13 + 1
			CALL DspFoundation(n + 100)
		NEXT
	END IF
	GOSUB DealCards

	score = 0: ShufflesLeft = 2: DrawsLeft = 1
	IF NumGames > 0 THEN PercentWon! = (GamesWon / NumGames) * 100 ELSE PercentWon! = 0
	Quitting = FALSE
	CALL DspScore
	'GOSUB AutoScan
	DO
		CALL MouseTrap(1, 1, 23, 80)
		Display 25, 0, "Select a card to move ...", foreground, background
		GOSUB GetPlace
		IF ans$ <> "" THEN
			SELECT CASE ans$
				CASE "S"
					IF ShufflesLeft <> 0 THEN
						Display 25, 0, "Reshuffle (Y/N)?", foreground, background
						IF YesOrNo$ = "Y" THEN
							REDIM card(52)
							CardNum = 1
							FOR FanNum = 1 TO 18
								FOR n = 1 TO 15
									CardVal = Fan(FanNum, n)
									IF CardVal <> 0 THEN
										card(CardNum) = CardVal
										CardNum = CardNum + 1
									END IF
								NEXT
							NEXT
							NumCards = CardNum - 1
							GOSUB shuffle
							REDIM Fan(20, 15)
							GOSUB DealCards
							ShufflesLeft = ShufflesLeft - 1
							CALL DspScore
						END IF
					ELSE
						IF NOT Quiet THEN SOUND 250, 1
					END IF
				CASE "D"
					IF DrawsLeft <> 0 AND (ShufflesLeft * StrictDraw) = 0 THEN
						Display 25, 0, "Select Pile ...", foreground, background
						CALL MouseTrap(2, 3, 16, 67)
						DO
							GOSUB GetPlace
						LOOP UNTIL Fan(xy, 1) <> 0 OR ans$ = CHR$(27)
						IF ans$ = "" THEN
							CardToMove = xy: FanMovedFrom = xy
							FOR n = 1 TO 15
								Fan(20, n) = Fan(CardToMove, n)     'back up old pile
							NEXT
							Display 25, 0, "Select a card ...", foreground, background
							CALL DrawACard(xy, CardValue, 1)
							IF xy <> 27 THEN
								CALL DspFan(xy, 0)
								'CALL Box0(18, 72, 24, 79, 1, inv)
								CALL DspCard(19, 73, CardValue, 0)
								Fan(19, 1) = CardValue
								DO
									OK = TRUE
									Display 25, 0, "Select Destination ...", foreground, background
									CALL MouseTrap(2, 1, 24, 67)
									GOSUB GetPlace
									IF ans$ <> "" THEN
										FOR n = 1 TO 15
											'Fan(CardToMove, n) = Fan(20, n) 'restore old pile
											Fan(FanMovedFrom, n) = Fan(20, n) 'restore old pile
										NEXT
										'CALL DspFan(CardToMove, 0)
										CALL DspFan(FanMovedFrom, 0)
									ELSE
										PickedCard = CardToMove: CardToMove = 19
										IF xy < 19 THEN
											IF Legal(CardToMove, xy) THEN
												CALL CardMove(xy, CardValue, 1)
												CALL DspFan(xy, 0)
											ELSE
												GOSUB ErrMsg
												OK = FALSE
											END IF
										ELSE
											IF Legal(CardToMove, xy) THEN
												Foundation(xy - 100) = CardValue
												CALL DspFoundation(xy)
												score = score + 1
											ELSE
												GOSUB ErrMsg
												OK = FALSE
												CardToMove = PickedCard
											END IF
										END IF
									END IF
								LOOP UNTIL OK = TRUE
								IF ans$ = "" THEN
									DrawsLeft = DrawsLeft - 1
									COLOR foreground, background
									CALL DspScore
								END IF
							END IF
							FOR n = 19 TO 24
								LOCATE n, 72: PRINT "        ";
							NEXT
						END IF
					ELSE
						IF NOT Quiet THEN SOUND 250, 1
					END IF
				CASE "P"
					Display 25, 0, "Select Pile ...", foreground, background
					CALL MouseTrap(2, 3, 16, 67)
					DO
						GOSUB GetPlace
					LOOP UNTIL Fan(xy, 1) <> 0 OR ans$ = CHR$(27)
					IF ans$ <> "P" AND ans$ <> CHR$(27) THEN
						CALL DrawACard(xy, CardValue, 0)
						GOSUB PressAnyKey
						CALL ScrnRest0(1, 1, 25, 80, SEG Scrn2(0))
					END IF
				CASE "N"
					Display 25, 0, "New Game (Y/N)?", foreground, background
					IF YesOrNo$ = "Y" THEN
						IF score <> 0 GOTO GameOver
						IF Game$ = "M" THEN g$ = "Midnight Oil" ELSE g$ = "Trefoil"
						Display 25, 0, "Play " + g$ + " Again (Y/N)?", foreground, background
						IF YesOrNo$ = "Y" THEN GOTO Start ELSE GOTO GameOver
					END IF
				CASE "H", CHR$(0) + CHR$(59)    'F1
					CALL ScrnSave0(1, 1, 25, 80, SEG Scrn2(0))
					GOSUB help
					CALL ScrnRest0(1, 1, 25, 80, SEG Scrn2(0))
				CASE CHR$(0) + CHR$(68)         'F10
					CALL ScrnSave0(1, 1, 25, 80, SEG Scrn2(0))
					COLOR 7, 0: CLS
					PRINT "Type 'Exit' to return to Midnight Oil."
					SHELL
					CALL ScrnRest0(1, 1, 25, 80, SEG Scrn2(0))
				CASE "Q"
					Display 25, 0, "Are you sure you want to quit (Y/N)?", foreground, background
					IF YesOrNo$ = "Y" THEN Quitting = TRUE: GOTO GameOver
				CASE "T"
					IF Quiet THEN Quiet = FALSE ELSE Quiet = TRUE
					GOSUB DspSoundStat
				CASE "A"
					IF AutoMode THEN AutoMode = FALSE ELSE AutoMode = TRUE
					GOSUB DspAutoStat
				CASE CHR$(27), "B"      'Esc or Blank
					GOSUB Blank
				CASE "U"
					IF PileMovedFrom <> 0 THEN
						CALL CardMove(PileMovedTo, CardValue, 0)
						CALL DspFan(PileMovedTo, 0)
						CALL CardMove(PileMovedFrom, CardValue, 1)
						CALL DspFan(PileMovedFrom, 0)
						PileMovedFrom = 0
						Display 25, 0, "Last move undone ...", foreground, background
						CALL Pause(9)
					ELSE
						IF NOT Quiet THEN SOUND 250, 1
					END IF
			END SELECT
		ELSE
			IF xy < 19 THEN
				CALL DspFan(xy, 1)          'highlight selected pile
				CardToMove = xy
				CALL CardMove(CardToMove, CardToMoveValue, 0)
				CALL CardMove(CardToMove, CardToMoveValue, 1)
				SELECT CASE CardToMoveValue
					CASE 1 TO 13: CardToMoveSuit = 3
					CASE 14 TO 26: CardToMoveSuit = 4
					CASE 27 TO 39: CardToMoveSuit = 5
					CASE 40 TO 52: CardToMoveSuit = 6
				END SELECT
				CALL MouseTrap(2, 4, 23, 67)
				DO
					OK = TRUE
					Display 25, 0, "Move to where?", foreground, background
Move1:
					GOSUB GetPlace
					IF ans$ = CHR$(27) THEN
						GOSUB Blank         'blank the screen
						GOTO Move1
					END IF
					IF xy = CardToMove THEN
						CALL DspFan(xy, 0)
					ELSE
						IF xy < 19 THEN
							IF Legal(CardToMove, xy) THEN
								PileMovedFrom = CardToMove: PileMovedTo = xy
								CALL CardMove(CardToMove, CardValue, 0)
								CALL DspFan(CardToMove, 0)
								CALL CardMove(xy, CardValue, 1)
								CALL DspFan(xy, 0)
							ELSE
								GOSUB ErrMsg
								OK = FALSE
							END IF
						ELSE
							IF Legal(CardToMove, xy) THEN
								PileMovedFrom = 0
								CALL CardMove(CardToMove, CardValue, 0)
								CALL DspFan(CardToMove, 0)
								Foundation(xy - 100) = CardValue
								CALL DspFoundation(xy)
								score = score + 1
								CALL DspScore
							ELSE
								GOSUB ErrMsg
								OK = FALSE
							END IF
						END IF
					END IF
				LOOP UNTIL OK = TRUE
			ELSE
				AM = AutoMode: AutoMode = TRUE
				GOSUB AutoScan
				AutoMode = AM
			END IF
		END IF
		GOSUB AutoScan
	LOOP UNTIL score = WinScore
GameOver:
	IF score <> 0 THEN
		GOSUB ClrLin25
		CALL ClearScr0(19, 2, 23, 34, inv)
		COLOR InverseFG, InverseBG
		IF score >= WinScore THEN
			LOCATE 19, 10: PRINT "              "
			LOCATE 20, 10: PRINT "             "
			LOCATE 21, 10: PRINT "       "
			LOCATE 22, 10: PRINT "          "
			LOCATE 23, 10: PRINT "      "
			GamesWon = GamesWon + 1
			IF NOT Quiet THEN CALL Chime(9)
			GOSUB CalcFinalScore
		ELSE
			LOCATE 20, 13: PRINT "You Lose."
			LOCATE 22, 7: PRINT "Better Luck Next Time."
			IF NOT Quiet THEN SOUND 100, 2
			GOSUB CalcFinalScore
			CALL Pause(36)
		END IF
	END IF

	IF NOT Quitting THEN
		IF score >= WinScore THEN
			Display 25, 0, "Play Again (Y/N)?", foreground, background
			ans$ = YesOrNo$
		ELSE
			ans$ = "Y"
		END IF
		IF ans$ = "Y" THEN GOTO titles
	END IF
TheEnd:
	COLOR 7, 0
	WIDTH OldCols, OldRows                              'restore starting screen size
	CALL ScrnRest0(1, 1, OldRows, 80, SEG scrn1(0))     'restore calling screen
	LOCATE StartingRow, 1: COLOR StartingColorFG, StartingColorBG
	END
'
'************** End Of Main Program ******************
'-------------- Start Of Subroutines -----------------
'
' Wait for mouse or key input
'
GetPlace:
	DO
		xy = 0: ans$ = ""
		CALL Mork(Place$, mx, my)
		IF (my > 1 AND my < 17) AND (mx > 3 AND mx < 68) THEN
			y = (my - 2) \ 5
			SELECT CASE mx
				CASE 4 TO 12: x = 1
				CASE 15 TO 23: x = 2
				CASE 26 TO 34: x = 3
				CASE 37 TO 45: x = 4
				CASE 48 TO 56: x = 5
				CASE 59 TO 67: x = 6
				CASE ELSE: x = 0: y = 0
			END SELECT
			xy = (x + y) + y * 5
		END IF
		IF (my > 18 AND my < 24) AND (mx > 3 AND mx < 41) THEN
			SELECT CASE mx
				CASE 4 TO 8: xy = 101
				CASE 12 TO 16: xy = 102
				CASE 20 TO 24: xy = 103
				CASE 28 TO 32: xy = 104
				CASE ELSE: xy = 0
			END SELECT
		END IF
		IF my < 20 AND mx > 70 THEN
			SELECT CASE my
				CASE 2: ans$ = "S"
				CASE 4: ans$ = "D"
				CASE 6: ans$ = "P"
				CASE 8: ans$ = "T"
				CASE 10: ans$ = "A"
				CASE 12: ans$ = "H"
				CASE 14: ans$ = "U"
				CASE 16: ans$ = "N"
				CASE 18: ans$ = "Q"
				CASE ELSE: ans$ = "Z"
			END SELECT
		END IF
		IF mx = 0 THEN ans$ = Place$
	LOOP UNTIL xy <> 0 OR ans$ <> ""
	RETURN
'
' SHUFFLE the deck
'
shuffle:
	Display 25, 0, "Shuffling ...", foreground + 16, background
	FOR i = 1 TO (3 * NumCards)         ' go thru the deck 3 times
		x = INT(RND * NumCards) + 1
		y = INT(RND * NumCards) + 1
		SWAP card(x), card(y)
	NEXT i
	GOSUB ClrLin25
	RETURN
'
' Deal Cards
'
DealCards:
	CardCnt = 1: FanCnt = 1: Crd = 1
	DO
		Fan(FanCnt, Crd) = card(CardCnt)
		CardCnt = CardCnt + 1
		Crd = Crd + 1
		IF Crd > 3 THEN
			Crd = 1: FanCnt = FanCnt + 1
		END IF
	LOOP UNTIL CardCnt > NumCards
	FOR FanNum = 1 TO 18
		IF NOT Quiet THEN SOUND 200, .05: SOUND 50, .05
		CALL DspFan(FanNum, 0)
	NEXT
	RETURN
'
' clear line 25 (status line)
'
ClrLin25:
	LOCATE 25, 1: COLOR foreground, background: PRINT SPACE$(80);
	RETURN
'
' Error Message
'
ErrMsg:
	GOSUB ClrLin25
	Display 25, 0, "You Can't Do That", foreground, background
	IF NOT Quiet THEN SOUND 250, 1
	CALL Pause(18)
	RETURN
'
' Display "Press any key ..." and wait for key or mouse
'
PressAnyKey:
	Display 25, 0, "Press any key ...", foreground, background
	CALL MouseTrap(25, 32, 25, 48)
	'CALL SetCursor(25, 48)
	CALL Mork(ans$, x, y)
	RETURN
'
' Calculate the final score
'
CalcFinalScore:
	NumGames = NumGames + 1
	TotalScores& = TotalScores& + score
	AvgScore! = TotalScores& / NumGames
	PercentWon! = (GamesWon / NumGames) * 100
	CALL DspScore
SaveScores:
	OPEN DataFile$ FOR OUTPUT AS #2
	WRITE #2, TotalScores&, AvgScore!, NumGames, GamesWon, foreground, background, highlight, RedColor, BlackColor, InverseFG, InverseBG, Quiet, AutoMode, StrictDraw
	CLOSE
	RETURN
'
' Display sound status
'
DspSoundStat:
	IF Quiet THEN Stat$ = "OFF" ELSE Stat$ = "ON "
	Display 8, 71, " Sound:" + Stat$, InverseFG, InverseBG
	RETURN
'
' Display AutoScan status
'
DspAutoStat:
	IF AutoMode THEN Stat$ = "ON " ELSE Stat$ = "OFF"
	Display 10, 71, " Auto: " + Stat$, InverseFG, InverseBG
	RETURN
'
' Perform an Auto-Scan on all foundations
'
AutoScan:
	IF AutoMode THEN
		FOR FoundNum = 101 TO 104
			FOR FanNum = 1 TO 18         'do auto-scan
				CALL CardMove(FanNum, CardValue, 0)
				SELECT CASE CardValue
					CASE 1 TO 13: CardSuit = 101
					CASE 14 TO 26: CardSuit = 102
					CASE 27 TO 39: CardSuit = 103
					CASE 40 TO 52: CardSuit = 104
				END SELECT
				IF CardSuit = FoundNum AND CardValue = Foundation(FoundNum - 100) + 1 THEN
					CALL DspFan(FanNum, 0)
					Foundation(FoundNum - 100) = CardValue
					CALL DspFoundation(FoundNum)
					IF NOT Quiet THEN SOUND 100, .5
					CALL Pause(5)
					score = score + 1
					CALL DspScore
					FoundNum = 100: FanNum = 0
					PileMovedFrom = 0
				ELSE
					CALL CardMove(FanNum, CardValue, 1)
				END IF
			NEXT
		NEXT
	END IF
	RETURN
'
'   Blank the screen
'
Blank:
	CALL ScrnSave0(1, 1, 25, 80, SEG Scrn2(0))
	COLOR 7, 0
	CLS
	DO
		CALL GetCursor(x, y, button)      'wait until all mouse buttons are released
	LOOP UNTIL button = 0
	DO
		ky$ = UCASE$(INKEY$)
		CALL GetCursor(x, y, button)      'wait for mouse button to be pressed
	LOOP UNTIL button <> 0 OR ky$ <> ""
	CALL ScrnRest0(1, 1, 25, 80, SEG Scrn2(0))
	RETURN

SUB CardMove (FanNum, CardValue, Action)
'
' Add or romove a card from a fan
'  Action -- 0 = remove a card from fan number FanNum,
'                returning the value in CardValue
'            1 = add CardValue to fan number FanNum
'
SHARED Fan()

	CardNum = 1
	DO
		CardVal = Fan(FanNum, CardNum)
		CardNum = CardNum + 1
	LOOP UNTIL CardVal = 0
	IF Action = 0 THEN
		CardNum = CardNum - 2
		CardValue = Fan(FanNum, CardNum)    'remove card
		Fan(FanNum, CardNum) = 0
	ELSE
		CardNum = CardNum - 1
		Fan(FanNum, CardNum) = CardValue    'add card
	END IF

END SUB

SUB Display (row%, Col%, Text$, FGColor%, BGColor%)
'
'   This routine displays Text$ at the specified row and column
'   using the specified foreground and background colors.
'   Note: If Col% is specified as 0, the text will be centered.
'         If Row% = 25, then line 25 will be cleared.
'
	IF Col = 0 THEN Col = 40 - (LEN(Text$) \ 2)
	IF row = 25 THEN
		LOCATE 25, 1: COLOR FGColor, BGColor: PRINT SPACE$(80);
	END IF
	COLOR FGColor, BGColor
	LOCATE row, Col
	PRINT Text$;

END SUB

SUB DrawACard (FanNum, CardValue, Action%)
'
' Draw a card from a pile
'  FanNum -- Fan Number
'  CardValue -- card selected
'  Action -- 0 = peek only, 1 = draw a card
'
SHARED inv, Fan(), Scrn2(), InverseFG, InverseBG

	CALL ScrnSave0(1, 1, 25, 80, SEG Scrn2(0))      'save screen
	CALL Box0(18, 44, 24, 80, 1, inv)
	COLOR InverseFG, InverseBG
	IF Action <> 0 THEN LOCATE 24, 46: PRINT " Esc or right button to cancel ";
	r = 19: c = 45
	FOR n = 0 TO 4
		LOCATE r + n, c: PRINT SPACE$(35)
	NEXT
	CrdCnt = 1
	DO UNTIL Fan(FanNum, CrdCnt) = 0: CrdCnt = CrdCnt + 1: LOOP
	CrdCnt = CrdCnt - 1
	FOR CardNum = 1 TO CrdCnt
		Col = c + ((CardNum - 1) * 2)
		CALL DspCard(r, Col, Fan(FanNum, CardNum), 0)
	NEXT
	IF Action = 1 THEN
		CALL MouseTrap(20, 46, 20, 46 + (CrdCnt - 2) * 2)
		CALL SetCursor(46 * 8 - 8, 20 * 8 - 8)
		CALL Mork(ans$, mx, my)
		IF ans$ <> "" THEN
			FanNum = 27
		ELSE
			Crd = ((mx - 46) \ 2) + 1
			CardValue = Fan(FanNum, Crd)
			FOR n = Crd TO CrdCnt
				Fan(FanNum, n) = Fan(FanNum, n + 1)
			NEXT
		END IF
		CALL ScrnRest0(1, 1, 25, 80, SEG Scrn2(0))      'restore screen
	END IF

END SUB

SUB DspCard (ULRow%, ULCol%, CardNum%, Action%)
'
'   Action: 0 = normal color
'           1 = highlighted
'
	SHARED foreground, background, highlight, RedColor, BlackColor

	CardFG = foreground: CardBG = background
	IF Action = 1 THEN CardFG = highlight
	CALL Box0(ULRow, ULCol, ULRow + 4, ULCol + 4, 1, OneColor(CardFG, CardBG))
	CardValue = (CardNum - 1) MOD 13 + 1
	CardSuit = ((CardNum - 1) \ 13) + 3
	SELECT CASE CardValue
		CASE 1: Crd$ = " A"
		CASE 2 TO 9: Crd$ = STR$(CardValue)
		CASE 10: Crd$ = "10"
		CASE 11: Crd$ = " J"
		CASE 12: Crd$ = " Q"
		CASE 13: Crd$ = " K"
	END SELECT
	IF CardSuit = 3 OR CardSuit = 4 THEN
		CardColor = RedColor      'red for hearts or diamonds
	ELSE
		CardColor = BlackColor    'black for clubs or spades
	END IF
	IF LEFT$(Crd$, 1) = " " THEN
		CrdH$ = RIGHT$(Crd$, 1): CrdL$ = " "
	ELSE
		CrdH$ = LEFT$(Crd$, 1): CrdL$ = RIGHT$(Crd$, 1)
	END IF
	COLOR CardColor, CardBG
	LOCATE ULRow + 1, ULCol + 1: PRINT CrdH$; "";
	LOCATE ULRow + 2, ULCol + 1: PRINT CrdL$; "";
	LOCATE ULRow + 3, ULCol + 1: PRINT CHR$(CardSuit); "";

END SUB

SUB DspFan (FanNum, Action)
'
' Display A Fan
'  FanNum: fan number (1 to 18)
'  Action: 0 = display normal fan
'          1 = highlight top card
'
SHARED foreground, background, highlight, Fan()

	IF Action = 0 THEN
		fg = foreground
		bg = background
	ELSE
		fg = highlight
		bg = background
	END IF
	COLOR foreground, background
	r = ((FanNum - 1) \ 6) * 5 + 2
	c = ((FanNum - 1) MOD 6) * 11 + 3
	CrdCnt = 1
	DO UNTIL Fan(FanNum, CrdCnt) = 0: CrdCnt = CrdCnt + 1: LOOP
	CrdCnt = CrdCnt - 1
	IF CrdCnt = 2 THEN
		FOR row = 0 TO 4
			LOCATE r + row, c + 8: PRINT "  "
		NEXT
	END IF
	IF CrdCnt = 1 THEN
		FOR row = 0 TO 4
			LOCATE r + row, c + 6: PRINT "    "
		NEXT
	END IF
	IF CrdCnt = 0 THEN
		LOCATE r + 0, c: PRINT "       "
		LOCATE r + 1, c: PRINT "          "
		LOCATE r + 2, c: PRINT "        "
		LOCATE r + 3, c: PRINT "          "
		LOCATE r + 4, c: PRINT "       "
	ELSE
		IF CrdCnt <= 3 THEN
			FirstCard = 1
			LOCATE r + 0, c: PRINT " "
			LOCATE r + 1, c: PRINT " "
			LOCATE r + 2, c: PRINT " "
			LOCATE r + 3, c: PRINT " "
			LOCATE r + 4, c: PRINT " "
		ELSE
			FirstCard = CrdCnt - 2
			LOCATE r + 0, c: PRINT ""
			LOCATE r + 1, c: PRINT ""
			LOCATE r + 2, c: PRINT ""
			LOCATE r + 3, c: PRINT ""
			LOCATE r + 4, c: PRINT ""
		END IF
		FOR CardNum = FirstCard TO CrdCnt
			Col = c + ((CardNum - FirstCard) * 2) + 1
			IF Action = 1 AND CardNum = CrdCnt THEN Act = 1
			CALL DspCard(r, Col, Fan(FanNum, CardNum), Act)
		NEXT
	END IF

END SUB

SUB DspFoundation (FoundNum)
'
' Display a Foundation
'  FoundNum = Foundation number (101-104)
'
SHARED foreground, background, RedColor, BlackColor, Foundation()

	COLOR foreground, background
	row = 19: Col = (FoundNum - 101) * 8 + 4
	IF Foundation(FoundNum - 100) = 0 THEN
		LOCATE row + 0, Col: PRINT "  "
		LOCATE row + 1, Col: PRINT "     "
		LOCATE row + 2, Col: PRINT "   "
		LOCATE row + 3, Col: PRINT "     "
		LOCATE row + 4, Col: PRINT "  "
		IF FoundNum < 103 THEN CardColor = RedColor ELSE CardColor = BlackColor
		COLOR CardColor, background
		LOCATE row + 2, Col + 2: PRINT CHR$(FoundNum - 98)
	ELSE
		CALL DspCard(row, Col, Foundation(FoundNum - 100), 0)
	END IF

END SUB

SUB DspScore

SHARED score, ShufflesLeft, DrawsLeft, AvgScore!
SHARED foreground, background, NumGames, GamesWon, PercentWon!

	COLOR foreground, background
	LOCATE 19, 38: PRINT "Score:"; score;
	LOCATE 20, 38: PRINT "Shuffles Left:"; ShufflesLeft; " Draws:"; DrawsLeft;
	LOCATE 21, 38: PRINT "Games Played:"; NumGames;
	LOCATE 22, 38: PRINT "Games Won:"; GamesWon;
	PRINT " (";
	IF PercentWon! < 100 THEN
		PRINT USING "##.#"; PercentWon!;
	ELSE
		PRINT USING "###.#"; PercentWon!;
	END IF
	PRINT "%)"
	LOCATE 23, 38: PRINT "Average Score: ";
	PRINT USING "##.#"; AvgScore!;

END SUB

FUNCTION Exists% (FileName$)
'
'   Determine if a file exists
'
	InRegs.AX = &H4E00
	InRegs.CX = 63
	Spec$ = FileName$ + CHR$(0)
	InRegs.DS = VARSEG(Spec$)
	InRegs.DX = SADD(Spec$)
	CALL InterruptX(&H21, InRegs, OutRegs)
	SELECT CASE OutRegs.AX
		CASE 0
			Exists% = TRUE
		CASE ELSE
			Exists% = FALSE
	END SELECT

END FUNCTION

FUNCTION Legal% (OldPile%, NewPile%)
'
' Check for valid move or build
'  OldPile -- Source Fan
'  NewPile -- Destination
'
SHARED Foundation()

	CALL CardMove(OldPile, CardToMoveValue, 0)
	CALL CardMove(OldPile, CardToMoveValue, 1)
	SELECT CASE CardToMoveValue
		CASE 1 TO 13: CardToMoveSuit = 3
		CASE 14 TO 26: CardToMoveSuit = 4
		CASE 27 TO 39: CardToMoveSuit = 5
		CASE 40 TO 52: CardToMoveSuit = 6
	END SELECT

	IF NewPile < 100 THEN
		CALL CardMove(NewPile, xyValue, 0)
		CALL CardMove(NewPile, xyValue, 1)
		SELECT CASE xyValue
			CASE 1 TO 13: xySuit = 3
			CASE 14 TO 26: xySuit = 4
			CASE 27 TO 39: xySuit = 5
			CASE 40 TO 52: xySuit = 6
		END SELECT
		IF CardToMoveSuit <> xySuit OR xyValue <> CardToMoveValue + 1 THEN
			Legal = 0
		ELSE
			Legal = 1
		END IF
	ELSE
		IF CardToMoveSuit <> (NewPile - 98) OR Foundation(NewPile - 100) + 1 <> CardToMoveValue THEN
			Legal = 0
		ELSE
			Legal = 1
		END IF
	END IF

END FUNCTION

SUB Mork (ky$, x, y)
'
'   get mouse or keyboard input
'
'   Inputs: none
'   Outputs: key$ -- key pressed ("" if no key pressed)
'            x,y -- mouse position when button was pressed
'                   x = text col, y = text row
'                   0,0 if mouse button not pressed
'
	CALL ShowCursor
	DO
		CALL GetCursor(x, y, button)      'wait until all mouse buttons are released
	LOOP UNTIL button = 0
	DO
		ky$ = UCASE$(INKEY$)
		CALL GetCursor(x, y, button)      'wait for a mouse button to be pressed
	LOOP UNTIL button <> 0 OR ky$ <> ""
	SELECT CASE button
		CASE 1
			x = x \ 8 + 1
			y = y \ 8 + 1
		CASE 2
			ky$ = CHR$(27)
			x = 0: y = x
		CASE 4
			ky$ = "B"
			x = 0: y = x
		CASE ELSE
			x = 0: y = x
	END SELECT
	CALL HideCursor

END SUB

FUNCTION YesOrNo$
'
' Gets a YES or NO answer using the mouse or keyboard
' Note: assumes that the cursor is at the end of the
'       "... (Y/N)?" prompt.
'
	CurX = POS(0)
	CALL MouseTrap(CSRLIN, CurX - 5, CSRLIN, CurX - 3)
	DO
		CALL SetCursor(CurX, CSRLIN)
		CALL Mork(k$, x, y)
		IF k$ = "" THEN
			IF x = CurX - 5 THEN k$ = "Y"
			IF x = CurX - 3 THEN k$ = "N"
		ELSE
			k$ = UCASE$(k$)
		END IF
	LOOP UNTIL k$ = "Y" OR k$ = "N"
	YesOrNo$ = k$

END FUNCTION

