/*--- routines de calcul de Liquid War */

#include "lwhd09.h"

#include <stdlib.h>
#include <time.h>




/*-- rafraichit un gradient --------------------------------------*/

void	refreshgradient(int numgrad,int dir)

{

	boostgradient(sizex,sizey,numgrad,dir,bigtab);
}

/*-- rafraichit tous les gradients -------------------------------*/

void refreshallgradient(void)

{
	int i;
	static int parity;

	for (i=0;i<6;++i)
		if (stillhowmany(i)!=0)
			refreshgradient(i,parity+i);

	++parity;
}


/*--- mets des p'tits carrs tous mignons sur le terrain (provisoire...)--*/

void	putmen(int color,int health,int number)

{
	int x,y;
	for (y=0;y<sizey;++y)
		for (x=0;x<sizex;++x)
			if ((0<number)
			 &&((peekwhatis(x,y,sizex,bigtab)>>12)==3))
			 {
			  putman(x,y,sizex,color,health,bigtab);
			  --number;
			 };

}


/*--- mets des p'tits carrs au hasard sur le terrain (provisoire...)--*/

void   randommen(int color,int health,int number)

{
	int x,y;

	while (0<number)
		{
		x=random(sizex-2)+1;
		y=random(sizey-2)+1;
		if ((peekwhatis(x,y,sizex,bigtab)>>12)==3)
			 {
			  putman(x,y,sizex,color,health,bigtab);
			  --number;
			 }
		}

}


/*---met qq points, pour voir -----------------------------------*/

void putsomemen(void)

{
	int i;

	for (i=0;i<3;++i)
		randommen(i,31,resolution ? 128 : 512);

}

/*--- donne la place libre du tableau --------------------------*/

int getfreeroom(void)

{
	int x,y;
	int k=0;

	for (y=0;y<sizey;++y)
		for (x=0;x<sizex;++x)
			if ((peekwhatis(x,y,sizex,bigtab)>>12)==3)
				k++;

	return(k);

}


/*--- renvoie true si la place est libre -------------------------*/

int cangoto(int x,int y)

{
	return((peekwhatis(x,y,sizex,bigtab)>>12)!=2);
}




/*-- met les p'tits gars en piste autour des curseurs------------*/

void putmenenhanced(int pourcent)

{

	int x,y;
	int nman,ncolor=0;
	int limit=0;
	int left;
	int i;
	int bool;
	int forcolor[6]={0,0,0,0,0,0};

	clearmen(sizex,sizey,bigtab);

	randomize();

	nman=((long) pourcent*(long) getfreeroom())/100;

	for (i=0;i<MAXCURSOR;++i)
		if (cursor[i].select)
			forcolor[cursor[i].color]=1;

	for (i=0;i<6;++i)
		ncolor+=forcolor[i];

	nman/=ncolor;
	nman=maxi(nman,3);

	for (i=0;i<6;++i)
		forcolor[i]=forcolor[i] ? nman : 0;




	for (i=0;i<MAXCURSOR;++i)
		if (forcolor[cursor[i].color]&&cursor[i].actif)
			{
			putman(cursor[i].x,cursor[i].y,sizex,
			       cursor[i].color,8191,bigtab);
			--forcolor[cursor[i].color];
			}

	movesquare();

	do
		{
		for (x=1;x<sizex-1;++x)
		for (y=1;y<sizey-1;++y)

		if ((peekwhatis(x,y,sizex,bigtab)>>12)==3)

			{
			i=0;
			bool=1;

			do
			{
			if ((forcolor[i])
			   && (peekgradient(y*sizex+x,i,bigtab)<=limit))
				{
				putman(x,y,sizex,i,8191,bigtab);
				--forcolor[i];
				bool=0;
				}
			++i;
			}
			while (bool&&(i<=6));

			}


		pokeallcursor();
		refreshallgradient();
		limit++;


		left=0;
		for (i=0;i<6;++i)
			left+=forcolor[i];

		}

	while   (left);


}


/*-- positionne les curseurs au hasard ---------------------------*/

void randomcursor(void)

{
	int i,x,y;

	randomize();
	for (i=0;i<MAXCURSOR;++i)
		if (cursor[i].select)
			{
			while
				(cangoto(x=random(sizex-2)+1,
					 y=random(sizey-2)+1)==0);
			cursor[i].x=x;
			cursor[i].y=y;
			cursor[i].rot=random(25000);
			}

}

/*--- poke tous les curseurs dans le tableau ---------------------------*/

void pokeallcursor(void)

{
	int i;

	for (i=0;i<MAXCURSOR;++i)
		if (cursor[i].actif)
			pokegradient(cursor[i].val,
				     cursor[i].y*sizex+cursor[i].x,
				     cursor[i].color,
				     bigtab);
}


/*--- fait bouger les carrs ------------------------------------------*/

void movesquare(void)
{
	static int updown;

	boostsquare(sizex,sizey,(updown++)%2,50,25,400,bigtab);

}