GOTO Defines

// these tables show the FACING transitions for animations
RunningTrans:
RunA 0
RunB 0
RunC 0
RunD 0
RunE 0
RunD 1
RunC 1
RunB 1

DefendTrans:
DfndC 1
DfndC 1
DfndC 1
DfndC 1
DfndC 0
DfndC 0
DfndC 0
DfndC 0

RDribbleTrans:
DribA 0
DribB 0
DribC 0
DribD 0
DribE 0
DribD 1
DribC 1
DribB 1

SDribbleTrans:
SDribA 0
SDribC 0
SDribC 0
SDribC 0
SDribE 0
SDribC 1
SDribC 1
SDribC 1

PassBallTrans:
PassA 0
PassB 0
PassC 0
PassD 0
PassE 0
PassD 1
PassC 1
PassB 1

JmpShotTrans:
JshotA 0
JshotB 0
JshotC 0
JshotC 0
JshotE 0
JshotC 1
JshotC 1
JshotB 1

StandTrans:
StandA 0
StandB 0
StandC 0
StandD 0
StandE 0
StandD 1
StandC 1
StandB 1

BallStandTrans:
StandBA 0
StandBB 0
StandBC 0
StandBD 0
StandBE 0
StandBD 1
StandBC 1
StandBB 1

StealTrans:
StealB 0
StealB 0
StealB 0
StealB 0
StealB 1
StealB 1
StealB 1
StealB 1

ReBndTrans:
ReBndE 0
ReBndE 0
ReBndE 0
ReBndE 0
ReBndE 1
ReBndE 1
ReBndE 1
ReBndE 1

FallTrans:
FallA 0
FallA 0
FallA 0
FallA 0
FallA 1
FallA 1
FallA 1
FallA 1

LayUpTrans:
LayUpC 0
LayUpC 0
LayUpC 0
LayUpC 0
LayUpC 1
LayUpC 1
LayUpC 1
LayUpC 1

DunkTrans:
DunkA 0
DunkC 0
DunkC 0
DunkC 0
DunkE 0
DunkC 1
DunkC 1
DunkC 1

SlamTrans:
SlamD 0
SlamD 0
SlamD 0
SlamD 0
SlamD 1
SlamD 1
SlamD 1
SlamD 1

RvDunkTrans:
RvDunkC 0
RvDunkC 0
RvDunkC 0
RvDunkC 0
RvDunkC 1
RvDunkC 1
RvDunkC 1
RvDunkC 1

GorlSlmTrans:
GorlSlm 0
GorlSlm 0
GorlSlm 0
GorlSlm 0
GorlSlm 1
GorlSlm 1
GorlSlm 1
GorlSlm 1

ThmkSlmTrans:
ThmkSlm 0
ThmkSlm 0
ThmkSlm 0
ThmkSlm 0
ThmkSlm 1
ThmkSlm 1
ThmkSlm 1
ThmkSlm 1

JumpTrans:
JumpA 0
JumpC 0
JumpC 0
JumpC 0
JumpE 0
JumpC 1
JumpC 1
JumpC 1

BlockTrans:
Block 0
Block 0
Block 0
Block 0
Block 1
Block 1
Block 1
Block 1

SitDTrans:
SitD 1
SitD 1
SitD 1
SitD 1
SitD 0
SitD 0
SitD 0
SitD 0

PickUpTrans:
Squat 0
Squat 0
Squat 0
Squat 0
Squat 1
Squat 1
Squat 1
Squat 1

Defines:
DEFINE me
DEFINE prevMe
DEFINE myX
DEFINE myY
DEFINE role
DEFINE prevRole
DEFINE roleChange
DEFINE rndnumber
DEFINE rndnumber2
DEFINE value
DEFINE Btn1Seen
DEFINE Btn2Seen
DEFINE distance
DEFINE olddistance
DEFINE basketX
DEFINE basketY
DEFINE basketZ
DEFINE SpecialX
DEFINE SpecialY
DEFINE PassZOffset
DEFINE SwitchSeq
DEFINE hisX
DEFINE hisY
DEFINE hisZ
DEFINE targetX
DEFINE targetY
DEFINE oldX
DEFINE oldY
DEFINE holdFrame
DEFINE tempX
DEFINE tempY
DEFINE tempZ

Btn1Seen = 0
Btn2Seen = 0
SwitchSeq = 0
prevRole = -1

SEQUENCE SWITCH StandE


// Init position
RNDNUM 0 4 rndnumber
FOR holdFrame = 0 TO rndnumber STEP 1
	DRAW CURRENT
END FOR

RNDNUM 0 20 targetX
targetY = 185
MOVE TO targetX targetY 0
COOKIE ME value


SUPPRESS 0
SOLID 0

// check my current role in the game and jump to the correct control block
CheckRole:
	ROLE role
	IF role != prevRole
		prevRole = role
		roleChange = 1
	ENDIF
	
	IF role > 28
		DEBUG SENTENCE_VAL 2 Invalid role! role
		DRAW CURRENT
		GOTO CheckRole
	ENDIF	
	
	// determine with case to run
	JUMP role
		Bench
		TimeOut
		KnockDown
		LooseBall
		LooseBallPlr
		ThrowInBallDef
		ThrowInBallDefPlr
		ThrowInBallOff
		ThrowInBallOffPlr
		ThrowInDef
		ThrowInDefPlr
		ThrowInOff
		ThrowInOffPlr
		PassBallDef
		PassBallDefPlr
		PassBallOff
		PassBallOffPlr
		PassDef
		PassDefPlr
		PassOff
		PassOffPlr
		NormalBallDef
		NormalBallDefPlr
		NormalBallOff
		NormalBallOffPlr
		NormalDef
		NormalDefPlr
		NormalOff
		NormalOffPlr
	
GOTO CheckRole
			

// Offense - computer w/o ball
NormalOff:
	IF roleChange = 1
	
	DEBUG SENTENCE 2 Start NormalOff
	
		roleChange = 0
		SOLID 1
		roleChange = 0
		SET_STATE BOUND2COURT 1
		GET_STATE BASKETPOSITION basketX basketY basketZ
		SEQUENCE SWITCH RunC
		PATH STRAIGHT
		PATH SPEED 10
		FlagDone = 1
	ENDIF

	IF FlagDone = 1
		targetX = basketX
		targetY = basketY
		RNDNUM 10 200 rndnumber
		targetX -= rndnumber
		RNDNUM -20 20 rndnumber
		targetY += rndnumber
		PATH FINISH targetX targetY 0
		GET_STATE PARTNERPOSITION hisX hisY
		DIST hisX hisY distance
		RNDNUM 0 10 rndnumber
		IF rndnumber > 8
			SIGNAL SET 4	// request teammate to pass the ball
		ENDIF
	ENDIF

	PATH NEXT myX myY myZ

	FACE TOWARD targetX targetY RunningTrans
	MOVE TOWARD myX myY 12
	
	DRAW NEXT
	
GOTO CheckRole


// Offense - computer with ball
NormalBallOff:
	IF roleChange = 1
		roleChange = 0
		SOLID 1
		SET_STATE BOUND2COURT 1
		GET_STATE BASKETPOSITION basketX basketY basketZ
		COOKIE ME value
		SEQUENCE SWITCH DribC
		PATH STRAIGHT
		PATH SPEED 10
		FlagDone = 1
	ENDIF

	IF KBChar = 20
		KBChar = 0
		RECORD TIMEANNOUNCE		//announcer
		SIGNAL SET 9
		GOTO CheckRole
	ENDIF
	
	IF FlagDone = 1
		RUNPLAY BALLOFF SwitchSeq
		// SwitchSeq
		//  1 = running
		//  2 = shooting
		//  3 = passing
		//  4 = standing
		//  5 = charge the net
	ELSE
		//  6 = run 3pt line
		//  7 = run straight line
		PATH NEXT myX myY myZ
		IF SwitchSeq = 6
			BOUND OUTSIDE_3PT myX myY
		ENDIF
		FACE TOWARD myX myY RDribbleTrans
		MOVE TOWARD myX myY 12
		COOKIE ME value
	ENDIF
	
	// run around some more
	IF SwitchSeq = 1
		targetX = basketX
		targetY = basketY
		RNDNUM 0 200 rndnumber
		targetX -= rndnumber
		RNDNUM -40 40 rndnumber
		targetY += rndnumber
		RNDNUM 0 1 rndnumber
		IF rndnumber = 0
			SwitchSeq = 6
			BOUND OUTSIDE_3PT targetX targetY
		ELSE
			SwitchSeq = 7
		ENDIF
		PATH FINISH targetX targetY 0
		FACE SWITCH RDribbleTrans
	ENDIF
	
	// shoot the ball 
	IF SwitchSeq = 2
		SwitchSeq = 0
		SIGNAL GET 2 value
		IF value = 0 		
			GOTO ShootBall
		ENDIF
	ENDIF
	
	// start pass
	IF SwitchSeq = 3
		SwitchSeq = 0
		SIGNAL SET 14
	ENDIF

	IF SwitchSeq = 4
		SwitchSeq = 0
		FACE SWITCH SDribbleTrans
	ENDIF
	
	//	Charge the net, dude.
	IF SwitchSeq = 5
		SwitchSeq = 0

		//	this code...
		targetX = basketX
		targetY = basketY
		RNDNUM 20 60 rndnumber
		targetX -= rndnumber
		RNDNUM -20 20 rndnumber
		targetY += rndnumber
		PATH FINISH targetX targetY 0
		FACE SWITCH RDribbleTrans
	ENDIF
	
 	SIGNAL GET 4 value			// Partner ready for throw in
	IF value = 1
		SIGNAL CLEAR 4
 		SIGNAL SET 14			// start passing
	ENDIF
	
	DRAW NEXT
	
GOTO CheckRole


// Offense - human player w/o ball
NormalOffPlr:
	IF roleChange = 1
		roleChange = 0
		SOLID 1
		SET_STATE BOUND2COURT 1
		GET_STATE BASKETPOSITION basketX basketY basketZ
		Btn1Seen = 0
		Btn2Seen = 0
		SEQUENCE SWITCH RunC
		SwitchSeq = 1
	ENDIF

	IF Btn2 = 1
		IF Btn2Seen = 0
			Btn2Seen = 1
			SIGNAL SET 14	// start a ball pass
		ENDIF
	ELSE
		Btn2Seen = 0
	ENDIF

	IF FlagMove = 1
		FlagMove = 0
		IF SwitchSeq = 0
			SwitchSeq = 1
			SEQUENCE SWITCH RunC
		ENDIF
		X += MoveX
		Y += MoveY
		FACE TOWARD X Y RunningTrans
		MOVE TO X Y 0
	ELSE	
		IF SwitchSeq = 1
			SwitchSeq = 0
			FACE SWITCH StandTrans
		ENDIF
	ENDIF

	DRAW NEXT
GOTO CheckRole


// Offense - human player with ball
NormalBallOffPlr:
	IF roleChange = 1
		roleChange = 0
		SOLID 1
		SET_STATE BOUND2COURT 1
		GET_STATE BASKETPOSITION basketX basketY basketZ
		COOKIE ME value
		SEQUENCE SWITCH DribC
		COOKIE ME value
		Btn1Seen = 0
		Btn2Seen = 0
		SwitchSeq = 3
	ENDIF

	IF KBChar = 20
		KBChar = 0
		RECORD TIMEANNOUNCE		//announcer
		SIGNAL SET 9
		GOTO CheckRole
	ENDIF
	
	IF Btn1 = 1
		IF Btn1Seen = 0
			Btn1Seen = 1
			SIGNAL GET 2 value
			IF value = 0 		
				GOTO ShootBall
			ENDIF
		ENDIF
	ELSE
		Btn1Seen = 0
	ENDIF

	IF Btn2 = 1
		IF Btn2Seen = 0
			// Btn2Seen = 1
			SIGNAL SET 14
			//Blaaaaaaa
			DRAW CURRENT
			roleChange = 1
			GOTO PassBallOffPlr
		ENDIF
	ELSE
		Btn2Seen = 0
	ENDIF

	IF FlagMove = 1
		FlagMove = 0
		IF SwitchSeq != 1
			SwitchSeq = 1
			SEQUENCE SWITCH DribC
		ENDIF
		X += MoveX
		Y += MoveY
		FACE TOWARD X Y RDribbleTrans
		MOVE TO X Y 0
	ELSE
		IF SwitchSeq != 0
			SwitchSeq = 0
			FACE SWITCH SDribbleTrans
		ENDIF
	ENDIF
	
	DRAW NEXT
GOTO CheckRole


// Defense - computer w/o ball
NormalDef:
	IF roleChange = 1
		roleChange = 0
		SOLID 1
		SET_STATE BOUND2COURT 1
		GET_STATE MYBASKET basketX basketY

DCNBGoDownCourt:
		IF X > 350
			RNDNUM 10 200 rndnumber
			RNDNUM -20 20 rndnumber2
			CALL RunDownCourt
			GOTO DCNBGoDownCourt
		ENDIF
		SEQUENCE SWITCH DfndC
	ENDIF
		
	GET_STATE OPPONENT1POSITION hisX hisY

	IF hisX = oldX
		IF hisY = oldY
			IF CurFrame = 0
				holdFrame = 1
			ENDIF
			IF CurFrame = 4
				holdFrame = 1
			ENDIF
			IF CurFrame = 8
				holdFrame = 1
			ENDIF
		ELSE
			holdFrame = 0
		ENDIF
	ELSE
		holdFrame = 0
	ENDIF
	
	IF holdFrame = 1
		DRAW CURRENT
	ELSE
		//  Shuffle toward my guy.
		targetX = hisX
		targetX -= 70
		IF targetX > 400
			targetX = 400
		ENDIF
		FACE TOWARD hisX hisY DefendTrans
		MOVE TOWARD targetX hisY 10
		DRAW NEXT
	ENDIF

	oldX = hisX
	oldY = hisY

GOTO CheckRole

// Defense - computer with ball
NormalBallDef:
	IF roleChange = 1
		roleChange = 0
		SOLID 1
		SET_STATE BOUND2COURT 1
		GET_STATE MYBASKET basketX basketY
		RNDNUM -15 15 rndnumber
		basketY += rndnumber
		BOUND OUTSIDE_3PT basketX basketY
		PATH SPEED 11
		PATH FINISH basketX basketY 0
		value = 0
		holdFrame = 0
	ENDIF

	holdFrame += 1
	
	IF FlagDone = 1
		RUNPLAY DEFEND_BALL SwitchSeq hisX hisY
		// 1 = stand
		// 2 = run
		// 3 = new place
		// 4 = steal
		// 5 = block
	ELSE
		SwitchSeq = 0
		
		PATH NEXT myX myY myZ
		FACE TOWARD myX myY RunningTrans
		MOVE TOWARD myX myY 12
		
		IF value = 1
			IF holdFrame > 4
				FlagDone = 1
				holdFrame = 0
			ENDIF
		ENDIF
		
	ENDIF
	
	IF SwitchSeq = 2	
		SwitchSeq = 0
		value = 1
		holdFrame = 0
		PATH SPEED 10
		PATH FINISH hisX hisY 0
	ENDIF
		
	IF SwitchSeq = 3
		SwitchSeq = 0
		GET_STATE OPPONENT1POSITION targetX targetY
		IF oldX = hisX
			IF oldY = hisY
				FACE SWITCH StandTrans
			ELSE
				FACE TOWARD targetX targetY DefendTrans
				MOVE TOWARD hisX hisY 10
			ENDIF
		ELSE
			FACE TOWARD targetX targetY DefendTrans
			MOVE TOWARD hisX hisY 10
		ENDIF
		oldX = hisX
		oldY = hisY
	ENDIF

	IF SwitchSeq = 4
		SwitchSeq = 0
		CALL StealBall
	ENDIF
	
	IF SwitchSeq = 5
		SwitchSeq = 0
		GET_STATE BALLPOSITION hisX hisY hisZ
		DIST hisX hisY distance
		IF distance < 80
			RNDNUM 0 1 rndnumber
			IF rndnumber = 0
				CALL BlockShot
			ELSE
				CALL BlockPass
			ENDIF
		ENDIF
		SEQUENCE SWITCH DfndC
	ENDIF
		
	DRAW NEXT
	
GOTO CheckRole

// Defense - human player w/o ball

NormalDefPlr:
NormalBallDefPlr:
	IF roleChange = 1
		roleChange = 0
		SOLID 1
		SET_STATE BOUND2COURT 1
		GET_STATE MYBASKET basketX basketY
		SEQUENCE SWITCH RunC
		SwitchSeq = 1
		Btn1Seen = 0
		Btn2Seen = 0
	ENDIF
		
	IF Btn1 = 1
		IF Btn1Seen = 0
			Btn1Seen = 1
			CALL StealBall
			SwitchSeq = 1
			FlagMove = 0
		ENDIF
	ELSE
		Btn1Seen = 0
	ENDIF

	IF Btn2 = 1
		IF Btn2Seen = 0
			Btn2Seen = 1
			CALL BlockShot
			SwitchSeq = 1
			FlagMove = 0
		ENDIF
	ELSE
		Btn2Seen = 0
	ENDIF

	IF FlagMove = 1
		FlagMove = 0
		GET_STATE OPPONENT1POSITION hisX hisY
		DIST hisX hisY distance
		
		value = 0
		IF X > 350
			value = 1
		ENDIF
		IF distance > 60
			value = 1
		ENDIF
		IF X > hisX
			value = 1
		ENDIF
		
		IF value = 1
			IF SwitchSeq != 1
				SwitchSeq = 1
				FACE SWITCH RunningTrans
			ENDIF
			X += MoveX
			Y += MoveY
			FACE TOWARD X Y RunningTrans
		ELSE
			IF SwitchSeq != 2
				SwitchSeq = 2
				FACE SWITCH DefendTrans
			ENDIF
			MoveX /= 2
			MoveY /= 2
			X += MoveX
			Y += MoveY
			FACE SWITCH DefendTrans
			FACE TOWARD hisX hisY DefendTrans
		ENDIF
		MOVE TO X Y 0
	ELSE
		IF SwitchSeq != 0
			SwitchSeq = 0
			FACE SWITCH StandTrans
		ENDIF
	ENDIF
	
	DRAW NEXT
GOTO CheckRole

// Ball is loose - computer players scramble for ball!

LooseBall:
	IF roleChange = 1
		roleChange = 0
		SOLID 1
		SET_STATE BOUND2COURT 0
		SEQUENCE SWITCH RunC
	ENDIF

	GET_STATE BALLPOSITION hisX hisY hisZ
	FACE TOWARD hisX hisY RunningTrans
	MOVE TOWARD hisX hisY 10
	DRAW NEXT
	
	RNDNUM 0 1 rndnumber
	IF rndnumber = 0
		GET_STATE BALLPOSITION hisX hisY hisZ
		DIST hisX hisY distance
		IF distance < 20			// close enough to look at ball
			IF hisZ > 50			// above my head
				SEQUENCE SWITCH JumpC
				FACE TOWARD hisX hisY JumpTrans
				WHILE CurFrame != 4
					DRAW NEXT		// draw the jump into the air
				ENDWHILE
				GET_STATE BALLPOSITION hisX hisY hisZ
				DIST hisX hisY distance
				IF distance < 10	// now if the ball still close enough
					IF hisZ < 110	// catchable
						SIGNAL GET 3 value
						IF value = 1 // This player reached ball first
							BALL MINE
							RECORD REBOUND		//announcer
							FACE TOWARD hisX hisY ReBndTrans
							SEQUENCE SWITCH RebndE
							DRAW FRAME 5
						ENDIF
						WHILE CurFrame != EndFrame
							DRAW NEXT
						ENDWHILE
					ENDIF
				ENDIF
			ELSE
				MOVE TOWARD hisX hisY 10
				DRAW NEXT
				DIST hisX hisY distance
				IF distance < 5
					IF hisZ < 50	// catchable
						SEQUENCE SWITCH Squat
						DRAW NEXT
						DRAW NEXT
						SIGNAL GET 3 value
						IF value = 1
							// DEBUG SENTENCE 2 LOOSEBALL COLLECTED
							BALL MINE
							RECORD POSSESION		//announcer
							DRAW NEXT
							DRAW NEXT
							DRAW NEXT
							SEQUENCE SWITCH StandBC
							FACE TOWARD hisX hisY BallStandTrans
							DRAW NEXT
							DRAW NEXT
						ELSE
							SEQUENCE SWITCH StandC
							FACE TOWARD hisX hisY StandTrans
							DRAW NEXT
							DRAW NEXT
						ENDIF
					ENDIF
				ENDIF
			ENDIF
		ENDIF
	ENDIF
GOTO CheckRole


// Ball is loose - human players scramble for ball!
LooseBallPlr:
	IF roleChange = 1
		roleChange = 0
		SOLID 1
		SET_STATE BOUND2COURT 1
		GET_STATE MYBASKET basketX basketY
		SEQUENCE SWITCH RunC
		SwitchSeq = 1
		Btn1Seen = 0
		Btn2Seen = 0
	ENDIF
		
	GET_STATE BALLPOSITION hisX hisY hisZ
	DIST hisX hisY distance
	IF distance < 5
		IF hisZ > 60
			SEQUENCE SWITCH JumpC
			FACE TOWARD hisX hisY JumpTrans
			// draw the jump into the air
			WHILE CurFrame != 4
				DRAW NEXT
			ENDWHILE
			SIGNAL GET 3 value
			IF value = 1
				// This player reached ball first
				BALL MINE
				RECORD REBOUND		//announcer
				FACE TOWARD hisX hisY ReBndTrans
				SEQUENCE SWITCH RebndE
				DRAW FRAME 5
				WHILE CurFrame != EndFrame
					DRAW NEXT
				ENDWHILE
			ELSE
				WHILE CurFrame != EndFrame
					DRAW NEXT
				ENDWHILE
			ENDIF
		ELSE
			SIGNAL GET 3 value
			IF value = 1
				SEQUENCE SWITCH Squat
				DRAW NEXT
				DRAW NEXT
				SIGNAL GET 3 value
				IF value = 1
					BALL MINE
					RECORD POSSESION		//announcer
					DRAW NEXT
					DRAW NEXT
					DRAW NEXT
				ENDIF
				SEQUENCE SWITCH StandBC
				FACE TOWARD hisX hisY BallStandTrans
				DRAW NEXT
			ENDIF
		ENDIF
		FlagMove = 0
		SwitchSeq = 1
	ENDIF

	IF FlagMove = 1
		FlagMove = 0
		IF SwitchSeq != 1
			SwitchSeq = 1
			FACE SWITCH RunningTrans
		ENDIF
		X += MoveX
		Y += MoveY
		FACE TOWARD X Y RunningTrans
		MOVE TO X Y 0
	ELSE
		IF SwitchSeq != 0
			SwitchSeq = 0
			FACE SWITCH StandTrans
		ENDIF
	ENDIF
	
	DRAW NEXT
GOTO CheckRole

ThrowInBallOff:
ThrowInBallOffPlr:
	IF roleChange = 1
		roleChange = 0
		SOLID 0
		SET_STATE BOUND2COURT 0
		COOKIE ME value
		SEQUENCE SWITCH RunC
		SIGNAL GET 7 value
		IF value = 0
			// no basket, run to ball
			CALL ChaseBall
			// now, I have the ball, take it out
			IF Y < 230
				SpecialY = 180
			ELSE
				SpecialY = 285
			ENDIF
			SpecialX = 370
			PATH SPEED 10
			PATH FINISH SpecialX SpecialY 0
			SEQUENCE SWITCH DribC
			WHILE FlagDone = 0
				FACE TOWARD SpecialX SpecialY RDribbleTrans
				PATH NEXT myX myY myZ
				MOVE TO myX myY 0
				DRAW NEXT
			ENDWHILE
		ELSE
			// basket just make, use end line
			CALL ChaseBall
			// now, I have the ball, take it out
			SpecialY = 240
			RNDNUM -50 50 rndnumber
			SpecialY += rndnumber
			SpecialX = 0
			BOUND COURT SpecialX SpecialY
			SpecialX -= 30
			PATH SPEED 10
			PATH FINISH SpecialX SpecialY 0
			SEQUENCE SWITCH DribC
			FACE TOWARD SpecialX SpecialY RDribbleTrans
			WHILE FlagDone = 0
				PATH NEXT myX myY myZ
				FACE TOWARD myX myY RDribbleTrans
				MOVE TOWARD myX myY 10
				DRAW NEXT
			ENDWHILE
			BOUND COURT myX myY
			myX -= 30
			MOVE TO myX myY 0
		ENDIF
		SIGNAL CLEAR 7
		SEQUENCE SWITCH StandBC
	ENDIF
	
	GET_STATE PARTNERPOSITION hisX hisY
	FACE TO hisX hisY BallStandTrans
	
	SIGNAL GET 4 value			// Partner ready for throw in
	IF value = 1
		SIGNAL CLEAR 4
 		RECORD INBOUND
 		SIGNAL SET 14			// start passing
 		SIGNAL CLEAR 8			// no longer taking ball out
	ENDIF
	
	DRAW NEXT
	
GOTO CheckRole


ThrowInOff:
ThrowInOffPlr:
	IF roleChange = 1
	
	DEBUG SENTENCE 2 Start ThrowInOff
	
		roleChange = 0
		SOLID 1
		SET_STATE BOUND2COURT 1
		SEQUENCE SWITCH RunC
		myX = 250
		myY = 250
		RNDNUM -40 40 rndnumber
		myX += rndnumber
		RNDNUM -20 20 rndnumber
		myY += rndnumber
		PATH STRAIGHT
		PATH SPEED 10
		PATH FINISH myX myY 0
		value = 0
	ENDIF
	
	IF FlagDone = 0
		PATH NEXT myX myY myZ
		FACE TOWARD myX myY RunningTrans
		MOVE TOWARD myX myY 10
	ELSE
		value = 1
		SIGNAL SET 4
		GET_STATE PARTNERPOSITION hisX hisY 
		SEQUENCE SWITCH StandC
		FACE TOWARD hisX hisY StandTrans
	ENDIF
	
	DRAW NEXT
	
GOTO CheckRole

ThrowInBallDef:
	IF roleChange = 1
		roleChange = 0
		SOLID 1
		roleChange = 0
		SET_STATE BOUND2COURT 1
		// SwitchSeq  0 = Run
		//            1 = Defend
		//            2 = Stand
		//            3 = no state
		SwitchSeq = 3
		rndnumber = 8
		holdFrame = 9
	ENDIF
	
	// run a play every so often
	IF holdFrame > rndnumber
		RNDNUM 16 32 rndnumber
		holdFrame = 0
		RUNPLAY DEFEND_BETWEEN_1_2 myX myY
		SEQUENCE SWITCH RunC
		SwitchSeq = 0
	ENDIF
		
	holdFrame += 1
	
	DIST myX myY distance
	
	// decide which sequence to paint
	IF distance > 10
		IF SwitchSeq != 0 // running
			SwitchSeq = 0
			SEQUENCE SWITCH RunC
		ENDIF
		FACE TOWARD myX myY RunningTrans
		MOVE TOWARD myX myY 12
		DRAW NEXT
	ELSE
		IF SwitchSeq != 2 // standing
			SwitchSeq = 2
			SEQUENCE SWITCH StandC
			FACE TOWARD myX myY StandTrans
		ENDIF
		DRAW CURRENT
	ENDIF
	
GOTO CheckRole

ThrowInDef:
	IF roleChange = 1
		roleChange = 0
		SOLID 1
		SET_STATE BOUND2COURT 1
		// SwitchSeq  0 = Run
		//            1 = Defend
		//            2 = Stand
		//            3 = no state
		SwitchSeq = 3
		GET_STATE OPPONENT1POSITION hisX hisY
		RNDNUM 16 32 rndnumber
		holdFrame = 0
		RUNPLAY DEFEND_BEHIND_2 targetX targetY
		RNDNUM 16 32 rndnumber
	ENDIF
	
	// run a play every so often
	IF holdFrame > rndnumber
		RNDNUM 16 32 rndnumber
		holdFrame = 0
		RUNPLAY DEFEND_BEHIND_2 targetX targetY
		SEQUENCE SWITCH RunC
		SwitchSeq = 0
	ENDIF
		
	holdFrame += 1
	
	DIST targetX targetY distance
	
	// decide which sequence to paint
	IF distance > 10
		IF SwitchSeq != 0 // running
			SwitchSeq = 0
			SEQUENCE SWITCH RunC
		ENDIF
		FACE TOWARD targetX targetY RunningTrans
		MOVE TOWARD targetX targetY 12
		DRAW NEXT
	ELSE
		IF SwitchSeq != 2 // standing
			SwitchSeq = 2
			SEQUENCE SWITCH StandC
			FACE TOWARD targetX targetY StandTrans
		ENDIF
		DRAW CURRENT
	ENDIF

GOTO CheckRole

// Pass the ball to your partner
PassBallOff:
	IF roleChange = 1
	
	DEBUG SENTENCE 2 Start PassBallOff
	
		roleChange = 0
		SOLID 1
		SET_STATE BOUND2COURT 0
		GET_STATE PARTNERPOSITION hisX hisY
		SEQUENCE SWITCH PassC
		FACE TO hisX hisY PassBallTrans
	ENDIF
	
	SIGNAL GET 2 value
	IF value = 0
		RECORD PASSES

		GET_STATE SPECIALPT1 hisX hisY hisZ
		SET_STATE BALLPOSITION hisX hisY hisZ
		
		GET_STATE PARTNERPOSITION hisX hisY
		SET_STATE PASSPOSITION hisX hisY 30

		WHILE CurFrame != EndFrame
			DRAW NEXT
		ENDWHILE
		
		SET_STATE BOUND2COURT 1
	ENDIF

	DRAW CURRENT
	
GOTO CheckRole

// wait for passed ball to get to me
PassOff:
	IF roleChange = 1
	
	DEBUG SENTENCE 2 Start PassOff
	
		roleChange = 0
		SOLID 1
		SET_STATE BOUND2COURT 1
		SEQUENCE SWITCH StandC
	ENDIF
	
	GET_STATE PARTNERPOSITION hisX hisY
	FACE TOWARD hisX hisY StandTrans
	DRAW NEXT
	
	GET_STATE BALLPOSITION hisX hisY hisZ
	DIST hisX hisY distance
	IF distance < 25
		SIGNAL GET 2 value
		IF value = 1
			BALL MINE
			SIGNAL CLEAR 8
			RECORD GETPASS		//announcer
			IF hisZ > 70
				SEQUENCE SWITCH RebndE
				DRAW FRAME 6
			ELSE
				SEQUENCE SWITCH PassC
				FACE TOWARD hisX hisY PassBallTrans
				DRAW FRAME 3
			ENDIF
			SEQUENCE SWITCH StandBC
			FACE TOWARD hisX hisY BallStandTrans
		ENDIF
	ENDIF
	
GOTO CheckRole

// Pass the ball to your partner
PassBallOffPlr:
	IF roleChange = 1
		roleChange = 0
		SOLID 1
		SET_STATE BOUND2COURT 0
		GET_STATE PARTNERPOSITION hisX hisY
		SEQUENCE SWITCH PassC
		FACE TO hisX hisY PassBallTrans
		Btn1Seen = 0
		Btn2Seen = 0
	ENDIF
	
	IF Btn2 = 1
		IF Btn2Seen = 0
			Btn2Seen = 1
			SIGNAL GET 2 value
			IF value = 0
				RECORD PASSES
			
				GET_STATE SPECIALPT1 hisX hisY hisZ
				SET_STATE BALLPOSITION hisX hisY hisZ
				
				GET_STATE PARTNERPOSITION hisX hisY
				SET_STATE PASSPOSITION hisX hisY 30
			
				WHILE CurFrame != EndFrame
					DRAW NEXT
				ENDWHILE
			ENDIF
		ENDIF
	ELSE
		Btn2Seen = 0
	ENDIF

	DRAW CURRENT
	
GOTO CheckRole

// wait for passed ball to get to me
PassOffPlr:
	IF roleChange = 1
		roleChange = 0
		SOLID 1
		SET_STATE BOUND2COURT 1
		SEQUENCE SWITCH RunC
		FACE TOWARD hisX hisY RunningTrans
		SwitchSeq = 1
		Btn1Seen = 0
		Btn2Seen = 0
	ENDIF
	
	IF FlagMove = 1
		FlagMove = 0
		IF SwitchSeq != 1
			SwitchSeq = 1
			FACE SWITCH RunningTrans
		ENDIF
		X += MoveX
		Y += MoveY
		FACE TOWARD X Y RunningTrans
		MOVE TO X Y 0
	ELSE
		IF SwitchSeq != 0
			SwitchSeq = 0
			FACE SWITCH StandTrans
		ENDIF
	ENDIF
	
	GET_STATE BALLPOSITION hisX hisY hisZ
	DIST hisX hisY distance
	IF distance < 30
		IF hisZ < 70
			SIGNAL GET 2 value
			IF value = 1
				BALL MINE
				SIGNAL CLEAR 8
				RECORD GETPASS		//announcer
				IF hisZ > 50
					SEQUENCE SWITCH RebndE
					DRAW FRAME 4
				ELSE
					SEQUENCE SWITCH PassC
					FACE TOWARD hisX hisY PassBallTrans
					DRAW FRAME 3
				ENDIF
				SEQUENCE SWITCH StandBC
				FACE TOWARD hisX hisY BallStandTrans
			ENDIF
		ENDIF
	ENDIF
	
	DRAW NEXT
	
GOTO CheckRole

// try to block a pass from the thrower
PassBallDef:
	IF roleChange = 1
		roleChange = 0
		SOLID 1
		SET_STATE BOUND2COURT 1
		GET_STATE OPPONENT1POSITION hisX hisY
		SEQUENCE SWITCH StandC
		FACE TO hisX hisY StandTrans
		SwitchSeq = 3
		rndnumber = 8
		holdFrame = 9
	ENDIF
	
	// run a play every so often
	IF holdFrame > rndnumber
		RNDNUM 16 32 rndnumber
		holdFrame = 0
		RUNPLAY DEFEND_BETWEEN_1_2 myX myY
	ENDIF
		
	holdFrame += 1
	
	DIST myX myY distance
	
	// decide which sequence to paint
	IF distance > 10
		IF SwitchSeq != 0 // running
			SwitchSeq = 0
			SEQUENCE SWITCH RunC
		ENDIF
		FACE TOWARD myX myY RunningTrans
		MOVE TOWARD myX myY 12
	ELSE
		IF SwitchSeq != 2 // standing
			SwitchSeq = 2
			SEQUENCE SWITCH StandC
			FACE TOWARD hisX hisY StandTrans
		ENDIF
	ENDIF
	
	SIGNAL GET 2 value	// ball in flight
	IF value = 1
		GET_STATE BALLPOSITION hisX hisY hisZ
		DIST hisX hisY distance
		IF distance < 80
			CALL BlockPass
		ENDIF
		SEQUENCE SWITCH StandC
		FACE TO hisX hisY StandTrans
	ENDIF
	
	DRAW NEXT
	
GOTO CheckRole

// try to block reciever from a pass
PassDef:
	IF roleChange = 1
		roleChange = 0
		SOLID 1
		SEQUENCE SWITCH StandC
	ENDIF
	GET_STATE OPPONENT1POSITION hisX hisY
	FACE TO hisX hisY StandTrans
	SIGNAL GET 2 value	// ball in flight
	IF value = 1
		GET_STATE BALLPOSITION hisX hisY hisZ
		DIST hisX hisY distance
		IF distance < 80
			CALL BlockPass
		ENDIF
	ENDIF
	DRAW NEXT
GOTO CheckRole

// try to block a pass from the thrower
ThrowInDefPlr:
ThrowInBallDefPlr:
PassDefPlr:
PassBallDefPlr:
	IF roleChange = 1
		roleChange = 0
		SOLID 1
		SET_STATE BOUND2COURT 1
		SEQUENCE SWITCH StandC
		FACE TO hisX hisY StandTrans
		SwitchSeq = 0
		Btn2Seen = 0
	ENDIF
	
	IF FlagMove = 1
		FlagMove = 0
		IF SwitchSeq != 1
			SwitchSeq = 1
			FACE SWITCH RunningTrans
		ENDIF
		X += MoveX
		Y += MoveY
		FACE TOWARD X Y RunningTrans
		MOVE TO X Y 0
	ELSE
		IF SwitchSeq != 0
			SwitchSeq = 0
			FACE SWITCH StandTrans
		ENDIF
	ENDIF
	
	IF Btn2 = 1
		IF Btn2Seen = 0
			Btn2Seen = 1
			CALL BlockPass
		ENDIF
	ELSE
		Btn2Seen = 0
	ENDIF

	DRAW NEXT
	
GOTO CheckRole

// Inactive - player on bench
Bench:
	IF roleChange = 1
		roleChange = 0
		SOLID 0
		SET_STATE BOUND2COURT 0
		SEQUENCE SWITCH RunC
		GET_STATE WHOAMI value
		
		targetX = 188
		targetY = 185
		value = 1
		WHILE value = 1
			IF X = targetX
				IF Y = targetY
					value = 0
				ENDIF
			ENDIF
			FACE TOWARD targetX targetY RunningTrans
			MOVE TOWARD targetX targetY 10
			DRAW NEXT
		ENDWHILE
		FACE TO 800 180 SitDTrans
		MOVE TOWARD targetX 180 10
		SEQUENCE SWITCH SitD
		WHILE CurFrame != EndFrame
			DRAW NEXT
		ENDWHILE
	ENDIF

	DRAW CURRENT

GOTO CheckRole

TimeOut:
	IF roleChange = 1
		roleChange = 0
		SOLID 0
		RECORD TIMEOUT
		SET_STATE BOUND2COURT 0
		SEQUENCE SWITCH RunC
		GET_STATE WHOAMI prevMe
		
		IF prevMe = 0
			targetX = 212
		ENDIF
		IF prevMe = 1
			targetX = 236
		ENDIF
		IF prevMe = 2
			targetX = 212
		ENDIF
		IF prevMe = 3
			targetX = 236
		ENDIF
		
		targetY = 185
		// remind the ball where to go
		SET_STATE PASSPOSITION 400 185 0
		SwitchSeq = 0
	
		value = 1
		WHILE value = 1
			IF X = targetX
				IF Y = targetY
					value = 0
				ENDIF
			ENDIF
			FACE TOWARD targetX targetY RunningTrans
			MOVE TOWARD targetX targetY 10
			DRAW NEXT
		ENDWHILE
		FACE TO 800 180 SitDTrans
		MOVE TOWARD targetX 180 10
		SEQUENCE SWITCH SitD
		WHILE CurFrame != EndFrame
			DRAW NEXT
		ENDWHILE
	
	ENDIF
	
	ROLE role
	prevRole = role
	WHILE role = prevRole
		DRAW CURRENT
		ROLE role
		IF role = prevRole
			GET_STATE WHOAMI me
			IF me != prevMe
				roleChange = 1
				SEQUENCE SWITCH SitU
				WHILE CurFrame != EndFrame
					DRAW NEXT
				ENDWHILE
				GOTO TimeOut
			ENDIF
		ENDIF
	ENDWHILE
	
	SEQUENCE SWITCH SitU
	WHILE CurFrame != EndFrame
		DRAW NEXT
	ENDWHILE
	
	// if the throwin signal not set, set it
	SIGNAL GET 8 value
	IF value = 0
		SIGNAL SET 8
	ENDIF
	
GOTO CheckRole

// Knock down player
KnockDown:
	SOLID 0
	SEQUENCE SWITCH FallA
	GET_STATE OPPONENT1POSITION hisX hisY
	FACE TO hisX hisY FallTrans
	WHILE CurFrame != 4
		DEBUG SENTENCE 9 Help me, I've fallen and I can't get up
		DRAW NEXT
	ENDWHILE

	RNDNUM 0 15 rndnumber
	FOR holdFrame = 0 TO rndnumber STEP 1
		DRAW CURRENT
	END FOR

	WHILE CurFrame != EndFrame
		DRAW NEXT
	ENDWHILE
	
GOTO CheckRole

// ***************** Subroutines ************************
// ***************** Subroutines ************************
// ***************** Subroutines ************************
// ***************** Subroutines ************************
// ***************** Subroutines ************************
// ***************** Subroutines ************************
// ***************** Subroutines ************************
// ***************** Subroutines ************************

// Go after the ball
ChaseBall:
	SwitchSeq = 0
	holdFrame = 0

	WHILE SwitchSeq < 2
		SIGNAL GET 9 value // timeout, give it up
		IF value = 1
			POP
			POP
			GOTO CheckRole
		ENDIF
		GET_STATE BALLPOSITION hisX hisY hisZ
		DIST hisX hisY distance
		IF distance < 5
			SwitchSeq = 1
			SEQUENCE SWITCH StandC
			FACE TOWARD hisX hisY StandTrans
			DRAW NEXT
			IF hisZ < 40
				SIGNAL GET 7 value		// if a basket was just made
				IF value = 1
					SIGNAL GET 3 value	// if the ball is loose
					IF value = 1
						SwitchSeq = 2	// we are there
					ENDIF
				ELSE
					SwitchSeq = 2	// we are there
				ENDIF
			ELSE
				holdFrame += 1
				IF holdFrame > 10
					SwitchSeq = 2
				ENDIF
			ENDIF
		ELSE
			IF SwitchSeq = 1
				SwitchSeq = 0
				SEQUENCE SWITCH RunC
			ENDIF
			FACE TOWARD hisX hisY RunningTrans
			MOVE TOWARD hisX hisY 10
			DRAW NEXT
		ENDIF
	ENDWHILE
	
	SEQUENCE SWITCH Squat
	DRAW NEXT
	DRAW NEXT
	
	BALL MINE
	
	DRAW NEXT
	DRAW NEXT
	DRAW NEXT
		
	SEQUENCE SWITCH StandBC
	FACE TOWARD hisX hisY BallStandTrans
	DRAW NEXT
	
RETURN

// Run down the court to defend your own basket

RunDownCourt:
	SEQUENCE SWITCH RunC
	PATH STRAIGHT
	PATH SPEED 11

	targetX = basketX
	targetY = basketY
	targetX += rndnumber
	targetY += rndnumber2
	IF rndnumber2 < 0
		targetY -= 20
	ELSE
		targetY += 20
	ENDIF
	PATH FINISH targetX targetY 0

	WHILE FlagDone = 0
		PATH NEXT myX myY myZ
		FACE TOWARD targetX targetY RunningTrans
		MOVE TOWARD myX myY 12
		DRAW NEXT

		ROLE role
		IF role != prevRole
			POP				// pop out of the while loop
			POP				// pop out of the subroutine
			GOTO CheckRole
		ENDIF
	ENDWHILE
RETURN


// Shoot the ball

ShootBall:
	//SEQUENCE SWITCH SDribC
	//WHILE CurFrame != EndFrame
	//	DRAW NEXT
	//ENDWHILE

	SIGNAL GET 2 value			// is the ball already in the air?
	IF value = 1
		GOTO CheckRole
	ENDIF
	
	SOLID 0
	
	RECORD SHOOT				// record the ball being shot

	WHICHSHOT value				// decide which kind of shot
	GET_STATE BASKETPOSITION basketX basketY basketZ
	
	IF value = 0				// JumpShot
		GOTO JumpShot
	ENDIF
	IF value = 1				// Layup
		GOTO Layup
	ENDIF
	IF value = 2				// Dunk
		SEQUENCE SWITCH DunkC
		FACE TO basketX basketY DunkTrans
		PATH FRAMES 7			// how many frame to rim
		GOTO SlamDunk
	ENDIF
	IF value = 3				// Slam Dunk
		basketX -= 5
		FACE TO basketX basketY SlamTrans
		SEQUENCE SWITCH SlamD
		// PATH FRAMES 6
		PATH FRAMES 7
		GOTO SlamDunk
	ENDIF
	IF value = 4				// Reverse Slam
		FACE TO basketX basketY RvDunkTrans
		SEQUENCE SWITCH RvDunkC
		PATH FRAMES 9
		GOTO SlamDunk
	ENDIF
	IF value = 5				// Gorilla Slam
		FACE TO basketX basketY GorlSlmTrans
		SEQUENCE SWITCH GorlSlm
		PATH FRAMES 6
		GOTO SlamDunk
	ENDIF
	IF value = 6				// Thomahawk Slam
		FACE TO basketX basketY ThmkSlmTrans
		SEQUENCE SWITCH ThmkSlm
		PATH FRAMES 9
		GOTO SlamDunk
	ENDIF

GOTO CheckRole

JumpShot:
	// Shoot the ball
	RECORD JUMPER			//announcer
	SEQUENCE SWITCH JshotC
	FACE TO basketX basketY JmpShotTrans

	GET_STATE SPECIALPT1 hisX hisY hisZ
	SET_STATE BALLPOSITION hisX hisY hisZ
	
	WHILE CurFrame != EndFrame
		DRAW NEXT
	ENDWHILE
	
	SEQUENCE SWITCH RunC
	
	value = 1
	WHILE value = 1
		SIGNAL GET 2 value
		IF X = basketX
			IF Y = basketY
				FACE SWITCH StandTrans
			ELSE
				FACE TO basketX basketY RunningTrans
			ENDIF
		ELSE
			FACE TO basketX basketY RunningTrans
		ENDIF
		
		MOVE TOWARD basketX basketY 7
		DRAW NEXT
		SIGNAL GET 9 tempZ
		IF tempZ = 1
			POP
			GOTO CheckRole
		ENDIF
	ENDWHILE
	
GOTO CheckRole

Layup:
	RECORD LAYUP			//announcer
	FACE TO basketX basketY LayUpTrans
	SEQUENCE SWITCH LayUpC
	SET_STATE BALLPOSITION basketX basketY basketZ

	PATH STRAIGHT
	PATH FRAMES 11
	targetX = basketX
	targetX -= 5
	PATH FINISH targetX basketY 0

	CurFrame = 0
	WHILE FlagDone = 0
		PATH NEXT myX myY myZ
		MOVE TO myX myY 0
		DRAW NEXT
		SIGNAL GET 9 tempZ
		IF tempZ = 1
			POP
			GOTO CheckRole
		ENDIF
	ENDWHILE

	MOVE TO basketX basketY 0

GOTO CheckRole


SlamDunk:
	RECORD DUNKIT			//for announcer
	SET_STATE BALLPOSITION basketX basketY basketZ
	
	PATH STRAIGHT
	targetX = basketX
	targetX -= 5
	PATH FINISH targetX basketY 0

	WHILE FlagDone = 0
		PATH NEXT myX myY myZ
		MOVE TO myX myY 0
		DRAW NEXT
	ENDWHILE

	WHILE CurFrame != EndFrame
		DRAW NEXT
	ENDWHILE
	
	SEQUENCE SWITCH StandE
	MOVE TO basketX basketY 0

GOTO CheckRole

// try to block a shot
BlockShot:
	SEQUENCE SWITCH Block
	FACE TOWARD basketX basketY BlockTrans
	DRAW FRAME 6

	WHILE CurFrame != 16
		BLOCKIT value
		IF value = 1
			RNDNUM -15 15 rndnumber
			X += rndnumber
			RNDNUM -15 15 rndnumber
			Y += rndnumber
			DEBUG SENTENCE 1 BLOCKED!
			BALL TOUCHED
			BALL LOOSE
			DRAW NEXT
			POP
			RETURN
		ENDIF
		IF value = 2
			SIGNAL GET 2 value
			IF value = 1
				DEBUG SENTENCE 1 GRABBED!
				BALL MINE
				RECORD POSSESION		//announcer
				FACE SWITCH ReBndTrans
				DRAW FRAME 5
				WHILE CurFrame != EndFrame
					DRAW NEXT
				ENDWHILE
				POP
				RETURN
			ENDIF
		ENDIF
		DRAW NEXT
	ENDWHILE

	DRAW NEXT
	
RETURN

// try to block a pass
BlockPass:
	SEQUENCE SWITCH JumpC

	WHILE CurFrame != EndFrame
		GET_STATE BALLPOSITION hisX hisY hisZ
		FACE TOWARD hisX hisY JumpTrans
		DRAW NEXT
		SIGNAL GET 2 value	// ball in flight
		IF value = 1
			BLOCKIT value
			IF value = 1
				DEBUG SENTENCE 1 BLOCKED!
				BALL TOUCHED
				BALL LOOSE
				DRAW NEXT
				POP
				RETURN
			ENDIF
			IF value = 2
				SIGNAL GET 2 value
				IF value = 1
					DEBUG SENTENCE 1 GRABBED!
					BALL MINE
					RECORD POSSESION		//announcer
					SEQUENCE SWITCH ReBndE
					DRAW FRAME 5
					WHILE CurFrame != EndFrame
						DRAW NEXT
					ENDWHILE
					POP
					RETURN
				ENDIF
			ENDIF
		ENDIF
		DRAW NEXT
	ENDWHILE
RETURN


StealBall:

	SIGNAL GET 0 value
	IF value = 1		// If he's shooting, dont steal
		RETURN
	ENDIF

	SIGNAL GET 1 value
	IF value = 1		// If he's passing, dont steal
		RETURN
	ENDIF

	SIGNAL GET 2 value
	IF value = 1		// If ball is in air, dont steal
		RETURN
	ENDIF

	SIGNAL GET 10 value
	IF value = 1		// If layup or dunk, dont steal
		RETURN
	ENDIF

	SEQUENCE SWITCH StealB
	GET_STATE OPPONENT1POSITION hisX hisY
	IF role = 22
		GET_STATE OPPONENT1POSITION hisX hisY
	ENDIF
	IF role = 26
		GET_STATE OPPONENT2POSITION hisX hisY
	ENDIF
	FACE TOWARD hisX hisY StealTrans

	//	CurFrame = 0
	DRAW FRAME 3
	WHILE CurFrame != EndFrame
		DRAW NEXT

		IF CurFrame = 6
			SIGNAL GET 0 value
			IF value = 0  //  If he's not shooting
				STEALIT value
				IF value = 1
					SET_STATE BALLPOSITION X Y 35
					BALL TOUCHED
					BALL LOOSE
				ENDIF
				IF value = 2
					BALL MINE
					RECORD STEAL
				ENDIF
			ENDIF
			POP
			GOTO EndSteal
		ENDIF

	ENDWHILE

EndSteal:

	DRAW NEXT
RETURN


END SCRIPT	// Player
