{$G+ }

{ Clak-A-Void v.0.7b             Source Distribution
(c) 1995 Jari Savander , Henri Block, Timo Pihlaja and Tero makela.
-------------------------------------------------------------------------}

unit gamevga;

{---------------------------------------------------------------------------}
interface
{---------------------------------------------------------------------------}

type palettidata = array [0..767] of byte;

const _vga_s:word = $a000;


procedure InitLibrary;
procedure SetColor(color,r,g,b:byte);
procedure SetPalette(palette:palettidata);
procedure CopyScreen(src,dst:word);
procedure ReTrace;
procedure ClrS(screen:word);
procedure PutPixel(x,y:integer;color:byte;where:word);
procedure Line(x1,y1,x2,y2:integer;color:byte;where:word);
procedure PutSprite(x,y:integer;Sprite:pointer;where:word);
procedure PutSpriteS(x,y:integer;Sprite:pointer;where:word);

{---------------------------------------------------------------------------}
implementation
{---------------------------------------------------------------------------}

const
      _sprite_x= 16;
      _sprite_y= 16;
      _sprite_xs= 6;
      _sprite_ys= 6;

procedure InitLibrary; assembler;
  asm mov ah,0; mov al,13h; int 10h;
end;

procedure SetColor(color,r,g,b:byte); assembler;
{loads values to color registers}
asm
  mov dx,3c8h; mov al,[color]; out dx,al; inc dx; mov al,[r]
  out dx,al; mov al,[g]; out dx,al; mov al,[b]; out dx,al;
end;

procedure SetPalette(palette:palettidata);
{ sets palette to CLT}
var I: byte; B: word;
begin
b:=0;
for I:= 0 to 255 do begin
  SetColor(i,palette[b],palette[b+1],palette[b+2]);
  inc(b,3);
 end;
end;

procedure CopyScreen(src,dst:word); assembler;
{copies 320x200 bytes from one place to other in memory}
asm

  push ds; mov ax,[dst]; mov es,ax; mov ax,[src]; mov ds,ax
  xor si,si; xor di,di; mov cx,320*200/2; rep movsw; pop ds;
end;

procedure retrace; assembler;
asm
  mov dx,3dah; @vert1: in al,dx; test al,8; jz @vert1
  @vert2: in al,dx; test al,8; jnz @vert2;
end;

procedure clrs(screen:word); assembler;
asm
 mov es,[screen]; xor di,di; xor ax,ax; mov cx,320*200/2; rep stosw;
end;


procedure PutPixel(x,y:integer;color:byte;where:word); assembler;
{sets a one byte in memory with specified color, cheks if its inside
 valid area}
asm

 mov ax,[where]; mov es,ax; mov bx,[x]; cmp bx,13Fh; ja @out;
 mov dx,[y]; cmp dx,0c7h; ja @out; mov di,bx;
 mov bx,dx; shl dx,8; shl bx,6; add dx,bx; add di,dx; mov al,[color];
 stosb;
@out:
end;


function sgn(a:real):integer;
begin
     if a>0 then sgn:=+1;
     if a<0 then sgn:=-1;
     if a=0 then sgn:=0;
end;

procedure Line(x1,y1,x2,y2:integer;color:byte;where:word);
{bressermans line routine}

var u,s,v,d1x,d2x,d1y,d2y,m,n: real;
    i:integer;

begin
     u:= x2 - x1;
     v:= y2 - y1;
     d1x:= SGN(u);
     d1y:= SGN(v);
     d2x:= SGN(u);
     d2y:= 0;
     m:= ABS(u);
     n := ABS(v);
     IF NOT (M>N) then
     BEGIN
          d2x := 0 ;
          d2y := SGN(v);
          m := ABS(v);
          n := ABS(u);
     END;
     s := INT(m / 2);
     FOR i := 0 TO round(m) DO
     BEGIN
          putpixel(x1,y1,color,where);
          s := s + n;
          IF not (s<m) THEN
          BEGIN
               s := s - m;
               x1 := x1 + round(d1x);
               y1 := y1 + round(d1y);
          END
          ELSE
          BEGIN
               x1 := x1 + round(d2x);
               y1 := y1 + round(d2y);
          end;
     end;
end;


procedure cbitmap(x,y,xs,ys,fk:integer;Sprite:pointer;where:word); assembler;
{copies a bitplane from pointers place to somewhere else ..=) }
asm

  push ds; lds si,[sprite]; mov es,[where]; xor di,di; mov ax,[y];
  shl ax,6; mov di,ax; shl ax,2; add di,ax; add di,[x]; mov dx,(fk);
  mov bx,ys; @l1: mov cx,xs; @l0: lodsb; or al,al; jz @skip;
  mov [es:di],al; @skip: inc di; dec cx; jnz @l0; add di,dx; dec bx;
  jnz @l1; pop ds;
end;

function testit(x,y:integer):boolean; assembler;
{chks if point is in valid area}
asm
mov ax,[x]; cmp ax,13Fh; ja @out; mov ax,[y]; cmp ax,0c7h; ja @out;
mov al,1; jmp @end; @out: xor ax,ax; @end:
end;


procedure putsprite(x,y:integer;Sprite:pointer;where:word);
begin
if testit(x,y) then cbitmap(x,y,_sprite_x,_sprite_y,320-_sprite_x,sprite,where);
end;



procedure putspriteS(x,y:integer;Sprite:pointer;where:word);
begin
  cbitmap(x,y,_sprite_xs,_sprite_ys,320-_sprite_xs,sprite,where);
end;



{-------------------------------------------------------------------------}
begin
end.

