'===========================================================================
' Subject: BLACK JACK                         Date: Year of 1994 (00:00:00)
'  Author: The ABC Programmer                 Code: QB 4.5                 
'  Origin: BLACK,JACK,EGA                   Packet: GAMES.ABC
'===========================================================================
'===============================================================
'  A Simple Black Jack Game by William Yu 1994 (My Rules)
'  When I finished programming this game, I found out that the
'    rules that I have been using are incorrect, but like me
'    I'm just too stubborn and lazy to change it.  Oh well, maybe
'    you'll discover them and change it yourself.
'  Requires EGA or better, but can be changed to whatever
'    Screen mode you like.
'
'  You need QuickBASIC 4.5 for this, so load with QB /LQB
'  
'  This is a THREE part snippet:  One is the game (BJ.BAS)
'                                 One is the Icon (BJ.ICO)
'                                 And Another one (BJ2.ICO)
'===============================================================

'----------------8<-------[ Begin BJ.BAS ]------->8--------------

'$INCLUDE: 'QB.BI'
DEFINT A-Z
DECLARE SUB Pause (ticks%)
DECLARE SUB ColorPrint (TEXT$, Row%, Col%, FC%, BC%)
DECLARE SUB SideWrite (Mot$, PosX, PosY, Couleur, Opt)
DIM FirstNum$(52), Match$(16), Player$(11), Dealer$(11)
REDIM Sprite%(210)
CLS : SCREEN 7, 0, , 0: COLOR 3, 1
LOCATE 6, 8
LOCATE , 8: PRINT "        "
LOCATE , 8: PRINT "               "
LOCATE , 8: PRINT "          "
LOCATE , 8: PRINT "                "
LOCATE , 8: PRINT "        "
PRINT
LOCATE , 10: PRINT "     "
LOCATE , 10: PRINT "            "
LOCATE , 10: PRINT "         "
LOCATE , 10: PRINT "             "
LOCATE , 10: PRINT "        "
PCOPY 0, 1

LOCATE 2, 6: COLOR 10: PRINT "PROGRAMMED BY WILLIAM YU 1995"
CARD = 1: CARD2 = 2

MAINMENU:

IF CARD = 1 THEN ICON$ = "BJ.ICO"
IF CARD = 2 THEN ICON$ = "BJ2.ICO"
OPEN ICON$ FOR INPUT AS #1
FOR A = 0 TO 210
  INPUT #1, Sprite%(A)
NEXT
CLOSE #1

PUT (20, 90), Sprite%, PSET
PUT (22, 88), Sprite%, PSET
PUT (24, 86), Sprite%, PSET
PUT (26, 84), Sprite%, PSET

LOCATE 18, 13: COLOR 14: PRINT "PLAY FOR FUN"
LOCATE 20, 13: PRINT "GAMBLE WITH MONEY"
LOCATE 22, 13: PRINT "CHANGE FACE CARD"
LOCATE 24, 13: PRINT "QUIT GAME";
PCOPY 0, 2

MENUSELECT:
PCOPY 2, 0
FUN = 0: GAMBLE = 0
GMD = 5000: GM = 1000: MS = 1: WP = 0: WL = 0
LOCATE 18, 11: COLOR 10: PRINT CHR$(16); : COLOR 12: PRINT " PLAY FOR FUN"

DO
  V$ = INKEY$
  IF V$ = CHR$(0) + "P" THEN MS = MS + 1: GOSUB MSMAIN
  IF V$ = CHR$(0) + "H" THEN MS = MS - 1: GOSUB MSMAIN
  IF V$ = CHR$(27) THEN GOTO ENDGAME
  IF V$ = CHR$(13) THEN GOTO MSENTER
LOOP

MSMAIN:
  COLOR 14
  LOCATE 18, 11: PRINT "  PLAY FOR FUN"
  LOCATE 20, 11: PRINT "  GAMBLE WITH MONEY"
  LOCATE 22, 11: PRINT "  CHANGE FACE CARD"
  LOCATE 24, 11: PRINT "  QUIT GAME";
  IF MS = 0 THEN MS = 4
  IF MS = 5 THEN MS = 1
  IF MS = 1 THEN LOCATE 18, 11: COLOR 10: PRINT CHR$(16); : COLOR 12: PRINT " PLAY FOR FUN"
  IF MS = 2 THEN LOCATE 20, 11: COLOR 10: PRINT CHR$(16); : COLOR 12: PRINT " GAMBLE WITH MONEY"
  IF MS = 3 THEN LOCATE 22, 11: COLOR 10: PRINT CHR$(16); : COLOR 12: PRINT " CHANGE FACE CARD"
  IF MS = 4 THEN LOCATE 24, 11: COLOR 10: PRINT CHR$(16); : COLOR 12: PRINT " QUIT GAME";
RETURN

MSENTER:
  IF MS = 1 THEN FUN = 1: GOTO STARTBJ
  IF MS = 2 THEN GAMBLE = 1: GOTO STARTBJ
  IF MS = 3 THEN GOTO CHANGECARD
  IF MS = 4 THEN GOTO ENDGAME

CHANGECARD:
LOCATE 22, 11: PRINT " "
SWAP CARD, CARD2
GOTO MAINMENU

STARTBJ:
PALETTE 3, 3
PCOPY 1, 0

IF GAMBLE = 1 THEN
  COLOR 14: LOCATE 2, 3: PRINT "WINS:"; : COLOR 10: PRINT WP
  COLOR 14: LOCATE 2, 15: PRINT "LOSSES:"; : COLOR 10: PRINT WL
  COLOR 15: LOCATE 18, 2: PRINT "YOU HAVE   "; : COLOR 14: PRINT "$"; LTRIM$(STR$(GM))

  IF GM = 0 THEN COLOR 10: LOCATE 21, 2: PRINT "AW, TOO BAD, YOU'RE BROKE!  HA HA HA!": A$ = INPUT$(1): GOTO MENUSELECT
  COLOR 15: LOCATE 19, 2: PRINT "DEALER HAS "; : COLOR 12: PRINT "$"; LTRIM$(STR$(GMD))
  IF GMD = 0 THEN COLOR 10: LOCATE 21, 1: PRINT "HEY, HOW ABOUT THAT, CONGRATS!  YOU WIN!": A$ = INPUT$(1): GOTO MENUSELECT
  COLOR 10: LOCATE 21, 2: PRINT "AMOUNT TO GAMBLE [Q=QUIT]: "; : COLOR 11
  LINE INPUT AG$
  IF UCASE$(AG$) = "Q" THEN GOTO MENUSELECT
  IF VAL(AG$) > GM THEN AG$ = STR$(GM)
  IF VAL(AG$) > GMD THEN AG$ = STR$(GMD)
  PCOPY 1, 0
END IF

PUT (100, 45), Sprite%, PSET
PUT (130, 45), Sprite%, PSET
PUT (100, 95), Sprite%, PSET
PUT (130, 95), Sprite%, PSET
Z = 130

I = 1: A$ = "A"
DO
  FOR Y = 1 TO 4
	FirstNum$(I) = A$
	I = I + 1
  NEXT Y
  IF I = 5 THEN A$ = "2"
  IF I = 9 THEN A$ = "3"
  IF I = 13 THEN A$ = "4"
  IF I = 17 THEN A$ = "5"
  IF I = 21 THEN A$ = "6"
  IF I = 25 THEN A$ = "7"
  IF I = 29 THEN A$ = "8"
  IF I = 33 THEN A$ = "9"
  IF I = 37 THEN A$ = "10"
  IF I = 41 THEN A$ = "J"
  IF I = 45 THEN A$ = "Q"
  IF I = 49 THEN A$ = "K"
LOOP UNTIL I = 53

FOR N = 1 TO 15
  Match$(N) = "0"
NEXT N

IF GAMBLE = 1 THEN CALL SideWrite("On the line:", 300, 175, 15, 6)
IF GAMBLE = 1 THEN CALL SideWrite("$" + LTRIM$(AG$), 300, 67, 14, 6)

CALL SideWrite("Dealer Hand", 1, 50, 14, 12)

PAINT (110, 50), 7, 15
X = 101: D = 0
RANDOMIZE TIMER
I = INT(RND * 52) + 1
IF FirstNum$(I) = "10" THEN X = X - 4
Match$(1) = FirstNum$(I)
D = D + 1: Dealer$(D) = FirstNum$(I)
CALL SideWrite(FirstNum$(I), X, 50, 15, 11)

CALL SideWrite("Player Hand", 1, 100, 12, 12)
PAINT (110, 100), 7, 15
PAINT (150, 100), 7, 15

X = 101: Y = 0: P = 0
DO
  RANDOMIZE TIMER
  I = INT(RND * 52) + 1
  IF FirstNum$(I) = "10" THEN X = X - 4
  FOR N = 1 TO 15
	IF FirstNum$(I) = Match$(N) THEN EXIT FOR
  NEXT N
  IF FirstNum$(I) <> Match$(N) THEN
	CALL SideWrite(FirstNum$(I), X, 100, 15, 11): Y = Y + 1: X = X + 31
	Match$(Y + 1) = FirstNum$(I)
	P = P + 1: Player$(P) = FirstNum$(I)
  END IF
  IF FirstNum$(I) = "10" THEN X = X + 4
LOOP UNTIL Y = 2

X = 161
MAX = P: PlayerHand = 0: ACE = 0
FOR V = 1 TO MAX
  IF Player$(V) = "K" THEN Player$(V) = "10"
  IF Player$(V) = "Q" THEN Player$(V) = "10"
  IF Player$(V) = "J" THEN Player$(V) = "10"
  IF Player$(V) = "A" THEN Player$(V) = "11": ACE = ACE + 1
  PlayerHand = PlayerHand + VAL(Player$(V))
NEXT V
LOCATE 20, 20: COLOR 11: PRINT "Player Has";
IF PlayerHand = 21 THEN
  COLOR 12: PRINT " BLACKJACK"
  PALETTE 3, 12
  LOCATE 2, 3: COLOR 10: PRINT "PLAYER BEATS DEALER WITH A BLACKJACK"
  A$ = INPUT$(1)
  IF FUN = 1 THEN
  LOCATE 2, 3: PRINT SPACE$(36)
  COLOR 14: LOCATE 2, 3: PRINT "ANOTHER GAME [Y/N]? ";
  DO
	A$ = INPUT$(1)
  LOOP UNTIL UCASE$(A$) = "Y" OR UCASE$(A$) = "N"
  IF UCASE$(A$) = "Y" THEN GOTO STARTBJ
  IF UCASE$(A$) = "N" THEN GOTO MENUSELECT
  END IF
  IF GAMBLE = 1 THEN GM = GM + VAL(AG$): GMD = GMD - VAL(AG$): WP = WP + 1: GOTO STARTBJ
END IF
GOTO SKIP

HILIGHT:
MAX = P
  IF Player$(MAX) = "K" THEN Player$(MAX) = "10"
  IF Player$(MAX) = "Q" THEN Player$(MAX) = "10"
  IF Player$(MAX) = "J" THEN Player$(MAX) = "10"
  IF Player$(MAX) = "A" THEN Player$(MAX) = "11": ACE = ACE + 1
  PlayerHand = PlayerHand + VAL(Player$(MAX))
  FOR V = 1 TO MAX
	IF ACE > 0 AND Player$(V) = "11" AND PlayerHand > 21 THEN PlayerHand = PlayerHand - 10: ACE = ACE - 1
  NEXT V

SKIP:
COLOR 10: LOCATE 20, 30: PRINT PlayerHand
IF PlayerHand > 21 THEN
  COLOR 12: LOCATE 2, 5: PRINT " YOU'RE BUSTED!!!  DEALER WINS!"
  A$ = INPUT$(1)
  IF FUN = 1 THEN
  LOCATE 2, 3: PRINT SPACE$(36)
  COLOR 14: LOCATE 2, 3: PRINT "ANOTHER GAME [Y/N]? ";
  DO
	A$ = INPUT$(1)
  LOOP UNTIL UCASE$(A$) = "Y" OR UCASE$(A$) = "N"
  IF UCASE$(A$) = "Y" THEN GOTO STARTBJ
  IF UCASE$(A$) = "N" THEN GOTO MENUSELECT
  END IF
  IF GAMBLE = 1 THEN GM = GM - VAL(AG$): GMD = GMD + VAL(AG$): WL = WL + 1: GOTO STARTBJ
END IF
IF PlayerHand = 21 THEN
  LOCATE 2, 3: COLOR 10: PRINT "PLAYER AUTOMATICALLY WINS WITH 21!!!"
  A$ = INPUT$(1)
  IF FUN = 1 THEN
  LOCATE 2, 3: PRINT SPACE$(36)
  COLOR 14: LOCATE 2, 3: PRINT "ANOTHER GAME [Y/N]? ";
  DO
	A$ = INPUT$(1)
  LOOP UNTIL UCASE$(A$) = "Y" OR UCASE$(A$) = "N"
  IF UCASE$(A$) = "Y" THEN GOTO STARTBJ
  IF UCASE$(A$) = "N" THEN GOTO MENUSELECT
  END IF
  IF GAMBLE = 1 THEN GM = GM + VAL(AG$): GMD = GMD - VAL(AG$): WP = WP + 1: GOTO STARTBJ
END IF
CALL ColorPrint(" HIT! ", 19, 6, 10, 4)
COLOR 2: LOCATE 21, 7: PRINT "STAY"
LOCATE 23, 7: PRINT "QUIT"

MENU = 1
DO
  V$ = INKEY$
  IF V$ = CHR$(0) + "P" THEN MENU = MENU + 1: GOSUB MOVEHI
  IF V$ = CHR$(0) + "H" THEN MENU = MENU - 1: GOSUB MOVEHI
  IF V$ = CHR$(13) THEN GOTO PLAYSELECT
LOOP

MOVEHI:
  COLOR 2
  LOCATE 19, 6: PRINT " HIT! "
  LOCATE 21, 6: PRINT " STAY "
  LOCATE 23, 6: PRINT " QUIT "
  IF MENU = 0 THEN MENU = 3
  IF MENU = 4 THEN MENU = 1
  IF MENU = 1 THEN CALL ColorPrint(" HIT! ", 19, 6, 10, 4)
  IF MENU = 2 THEN CALL ColorPrint(" STAY ", 21, 6, 10, 4)
  IF MENU = 3 THEN CALL ColorPrint(" QUIT ", 23, 6, 10, 4)
RETURN

PLAYSELECT:
  IF MENU = 1 THEN GOTO HITME
  IF MENU = 2 THEN GOTO DEALERTURN
  IF MENU = 3 THEN GOTO MENUSELECT


HITME:
  Z = Z + 30
  PUT (Z, 95), Sprite%, PSET
  Pause (3)
  PAINT (Z + 10, 100), 7, 15
Y = 0
DO
  RANDOMIZE TIMER
  I = INT(RND * 52) + 1
  IF FirstNum$(I) = "10" THEN X = X - 4
  FOR N = 1 TO 15
	IF FirstNum$(I) = Match$(N) THEN EXIT FOR
  NEXT N
  IF FirstNum$(I) <> Match$(N) THEN
	CALL SideWrite(FirstNum$(I), X, 100, 15, 11): Y = Y + 1: X = X + 30
	Match$(Y + 1) = FirstNum$(I)
	P = P + 1: Player$(P) = FirstNum$(I)
  END IF
  IF FirstNum$(I) = "10" THEN X = X + 4
LOOP UNTIL Y = 1
GOTO HILIGHT

DEALERTURN:
LOCATE 19, 6: PRINT "      "
LOCATE 21, 6: PRINT "      "
LOCATE 23, 6: PRINT "      "
PAINT (150, 50), 7, 15
X = 131: Y = 0: Z = 130
DO
  RANDOMIZE TIMER
  I = INT(RND * 52) + 1
  IF FirstNum$(I) = "10" THEN X = X - 4
  FOR N = 1 TO 15
	IF FirstNum$(I) = Match$(N) THEN EXIT FOR
  NEXT N
  IF FirstNum$(I) <> Match$(N) THEN
	CALL SideWrite(FirstNum$(I), X, 50, 15, 11): Y = Y + 1: X = X + 30
	Match$(Y + 1) = FirstNum$(I)
	D = D + 1: Dealer$(D) = FirstNum$(I)
  END IF
  IF FirstNum$(I) = "10" THEN X = X + 4
LOOP UNTIL Y = 1

X = 161
MAX = D: DealerHand = 0: ACE = 0
FOR V = 1 TO MAX
  IF Dealer$(V) = "K" THEN Dealer$(V) = "10"
  IF Dealer$(V) = "Q" THEN Dealer$(V) = "10"
  IF Dealer$(V) = "J" THEN Dealer$(V) = "10"
  IF Dealer$(V) = "A" THEN Dealer$(V) = "11": ACE = ACE + 1
  DealerHand = DealerHand + VAL(Dealer$(V))
NEXT V
LOCATE 22, 20: COLOR 11: PRINT "Dealer Has";
IF DealerHand = 21 THEN
  COLOR 12: PRINT " BLACKJACK"
  PALETTE 3, 12
  LOCATE 2, 3: COLOR 10: PRINT "DEALER BEATS PLAYER WITH A BLACKJACK"
  A$ = INPUT$(1)
  IF FUN = 1 THEN
  LOCATE 2, 3: PRINT SPACE$(36)
  COLOR 14: LOCATE 2, 3: PRINT "ANOTHER GAME [Y/N]? ";
  DO
	A$ = INPUT$(1)
  LOOP UNTIL UCASE$(A$) = "Y" OR UCASE$(A$) = "N"
  IF UCASE$(A$) = "Y" THEN GOTO STARTBJ
  IF UCASE$(A$) = "N" THEN GOTO MENUSELECT
  END IF
  IF GAMBLE = 1 THEN GMD = GMD + VAL(AG$): GM = GM - VAL(AG$): WL = WL + 1: GOTO STARTBJ
END IF
GOTO DEALSKIP

DEALHILIGHT:
MAX = D
  IF Dealer$(MAX) = "K" THEN Dealer$(MAX) = "10"
  IF Dealer$(MAX) = "Q" THEN Dealer$(MAX) = "10"
  IF Dealer$(MAX) = "J" THEN Dealer$(MAX) = "10"
  IF Dealer$(MAX) = "A" THEN Dealer$(MAX) = "11": ACE = ACE + 1
  DealerHand = DealerHand + VAL(Dealer$(MAX))
  FOR V = 1 TO MAX
	IF ACE > 0 AND Dealer$(V) = "11" AND DealerHand > 21 THEN DealerHand = DealerHand - 10: ACE = ACE - 1
  NEXT V

DEALSKIP:
COLOR 12: LOCATE 22, 30: PRINT DealerHand
IF DealerHand > 21 THEN
  COLOR 14: LOCATE 2, 7: PRINT "DEALER GOES BUST!  YOU WIN!"
  A$ = INPUT$(1)
  IF FUN = 1 THEN
  LOCATE 2, 3: PRINT SPACE$(36)
  COLOR 14: LOCATE 2, 3: PRINT "ANOTHER GAME [Y/N]? ";
  DO
	A$ = INPUT$(1)
  LOOP UNTIL UCASE$(A$) = "Y" OR UCASE$(A$) = "N"
  IF UCASE$(A$) = "Y" THEN GOTO STARTBJ
  IF UCASE$(A$) = "N" THEN GOTO MENUSELECT
  END IF
  IF GAMBLE = 1 THEN GMD = GMD - VAL(AG$): GM = GM + VAL(AG$): WP = WP + 1: GOTO STARTBJ
END IF
IF DealerHand > PlayerHand THEN
  COLOR 13: LOCATE 2, 11: PRINT "DEALER WINS WITH"; DealerHand
  A$ = INPUT$(1)
  IF FUN = 1 THEN
  LOCATE 2, 3: PRINT SPACE$(36)
  COLOR 14: LOCATE 2, 3: PRINT "ANOTHER GAME [Y/N]? ";
  DO
	A$ = INPUT$(1)
  LOOP UNTIL UCASE$(A$) = "Y" OR UCASE$(A$) = "N"
  IF UCASE$(A$) = "Y" THEN GOTO STARTBJ
  IF UCASE$(A$) = "N" THEN GOTO MENUSELECT
  END IF
  IF GAMBLE = 1 THEN GMD = GMD + VAL(AG$): GM = GM - VAL(AG$): WL = WL + 1: GOTO STARTBJ
END IF

LOCATE 20, 3: COLOR 10: PRINT "DEALER HITS!"
Z = Z + 30
PUT (Z, 45), Sprite%, PSET
Pause (8)
PAINT (Z + 10, 50), 7, 15
Y = 0
DO
  RANDOMIZE TIMER
  I = INT(RND * 52) + 1
  IF FirstNum$(I) = "10" THEN X = X - 4
  FOR N = 1 TO 15
	IF FirstNum$(I) = Match$(N) THEN EXIT FOR
  NEXT N
  IF FirstNum$(I) <> Match$(N) THEN
	CALL SideWrite(FirstNum$(I), X, 50, 15, 11): Y = Y + 1: X = X + 30
	Match$(Y + 1) = FirstNum$(I)
	D = D + 1: Dealer$(D) = FirstNum$(I)
  END IF
  IF FirstNum$(I) = "10" THEN X = X + 4
LOOP UNTIL Y = 1
GOTO DEALHILIGHT

ENDGAME:
COLOR 7, 0: CLS
SCREEN 0, 0, , 0
WIDTH 80, 25

SUB ColorPrint (TEXT$, Row%, Col%, FC%, BC%)
  DIM inreg AS RegTypeX, outreg AS RegTypeX
  C$ = STRING$(LEN(TEXT$), 219)       ' String of solid chars
  inreg.ax = &H1300             ' Video service 13h, subfunction
  inreg.bx = BC%                ' Background colour
  inreg.cx = LEN(TEXT$)         ' String length
  inreg.dx = 256 * (Row% - 1) + (Col% - 1)      ' Text pos. in
  inreg.es = VARSEG(C$)           ' String's segment
  inreg.bp = SADD(C$)           ' String's address
  CALL INTERRUPTX(&H10, inreg, outreg)     ' Output the
  inreg.bx = (FC% XOR BC%) + &H80   ' BL=ForeColor; BH=&H80 uses
  inreg.es = VARSEG(TEXT$)
  inreg.bp = SADD(TEXT$)
  CALL INTERRUPTX(&H10, inreg, outreg) ' Output the text, XORing

END SUB

SUB Pause (ticks%)
	DEF SEG = 0
	DO UNTIL TestTick% > ticks%
	   LastTick% = GetTick%
	   GetTick% = PEEK(&H46C)
		IF LastTick% <> GetTick% THEN
		 TestTick% = TestTick% + 1
		END IF
	LOOP
	DEF SEG

END SUB

SUB SideWrite (Mot$, PosX, PosY, Couleur, Opt) STATIC
FOR Nombre = 1 TO LEN(Mot$)
	LOCATE 1, 1: COLOR 1
	PRINT MID$(Mot$, Nombre, 1)        'print word's letters one by one
	FOR X = 0 TO 7
	 FOR Y = 0 TO 13                   'use 0 TO 13 for EGA
	   IF POINT(X, Y) THEN            'read pixel on/off for sideways copy
		 IF Opt = 1 THEN
			PSET (Y + PosX, 8 - X + PosY - (8 * Nombre)), Couleur
		 ELSEIF Opt = 2 THEN
			PSET (Y + PosX, 8 - X + PosY - (8 * Nombre) + Y), Couleur
		 ELSEIF Opt = 3 THEN
			PSET (X + PosX, PosY + (8 * Nombre) + Y), Couleur
		 ELSEIF Opt = 4 THEN
			PSET (8 - Y + PosX, PosY + (8 * Nombre) + X), Couleur
		 ELSEIF Opt = 5 THEN
			PSET (8 - Y + PosX, PosY + (8 * Nombre) + X - Y), Couleur
		 ELSEIF Opt = 6 THEN
			PSET (Y + PosX + Y, 8 - X + PosY - (8 * Nombre)), Couleur
			PSET (1 + Y + PosX + Y, 8 - X + PosY - (8 * Nombre)), Couleur
		 ELSEIF Opt = 7 THEN
			PSET (Y + PosX + Y, 8 - X + PosY - (8 * Nombre) + Y), Couleur
			PSET (1 + Y + PosX + Y, 8 - X + PosY - (8 * Nombre) + Y), Couleur
		ELSEIF Opt = 8 THEN
			PSET (X + PosX + X, PosY + (8 * Nombre) + Y), Couleur
			PSET (1 + X + PosX + X, PosY + (8 * Nombre) + Y), Couleur
		 ELSEIF Opt = 9 THEN
			PSET (X + PosX + (Nombre * 8), PosY + Y), Couleur
		 ELSEIF Opt = 10 THEN
			PSET (X + PosX + (Nombre * 8) - Y, PosY + Y), Couleur
		 ELSEIF Opt = 11 THEN
			PSET (X + PosX + (Nombre * 8), PosY + Y + Y), Couleur
			PSET (X + PosX + (Nombre * 8), 1 + PosY + Y + Y), Couleur
		 ELSEIF Opt = 12 THEN
			PSET (X + PosX + (Nombre * 8) - Y, PosY + Y + Y), Couleur
			PSET (X + PosX + (Nombre * 8) - Y, 1 + PosY + Y + Y), Couleur
		 END IF
	   END IF
	 NEXT Y
	NEXT X
NEXT Nombre

END SUB
'----------------8<-------[ End BJ.BAS ]------->8--------------



'----------------8<-------[ Begin BJ.ICO ]------->8--------------

'----------------8<-------[ End BJ.ICO ]------->8--------------



'----------------8<-------[ Begin BJ2.ICO ]------->8--------------

'----------------8<-------[ End BJ2.ICO ]------->8--------------
