
#define MAX_ACTIVE_PLAYERS		50
#define MAX_INACTIVE_PLAYERS	50
#define MAX_LEAGUE_TEAMS		30
#define MAX_GAMES_PER_WEEK		(MAX_LEAGUE_TEAMS/2)
#define MAX_WEEKS_IN_LEAGUE		24
#define MAX_SCREEN_TEAMS		8
#define MAX_LEAGUE_DESC			15
#define MAX_EXTERN_DESC			MAX_LEAGUE_DESC + 34
#define NO_TEAM					MAX_LEAGUE_TEAMS
#define MAX_CUSTOM_TEAMS      16

#define WILDCARD_PLAYOFFS	19
#define DIVISION_PLAYOFFS	20
#define CHAMPIONSHIP_GAMES	21
#define SUPER_BOWL			22



#define TRADE_SCREEN_TEAM1	0
#define TRADE_SCREEN_TEAM2	1
#define TEAM_EDIT_SCREEN	2


#define NEW_LEAGUE_DRAFT	1
#define OFFSEASON_DRAFT		2


#define SEASON88 88
#define SEASON89 89
#define SEASON90 90
#define SEASON91 91
#define SEASON92 92
#define SEASON93 93
#define SEASON94 94
#define RAND16	 116
#define RAND17  117
#define RAND_SEASON 118
#define STRAIGHT 99


struct OpponentStats
	{
	short RushYards;
	short PassYards;
	UWORD Rushes;
	UWORD RushTDs;
	UWORD PassTDs;
	UWORD Fumbles;
	UWORD PointsAgainst;
	};


struct TeamLeagueStats
	{
	UBYTE TeamNum;
	UBYTE Wins;
	UBYTE Losses;
	UBYTE Ties;
	struct GameStats     TeamStats;
	struct OpponentStats OpponentStats;
	};


struct LeagueTeamInfo
{
	char Description[MAX_DESCRIPTION];
	UBYTE Uniform;
	UBYTE Status;  // 0 is no team, 1 is active team
	char TeamName[MAX_TEAMNAME];
	char CityName[MAX_CITYNAME];
	char CoachName[MAX_COACHNAME];
	UBYTE Year;
	char Playbook[9];					// name of the default playbook for this team
	char Starters[MAX_STARTERS];
	UBYTE CoachRatings[MAX_COACH_RATINGS];
	UBYTE TeamRatings[MAX_TEAM_RATINGS];
	char FileName[_MAX_PATH];
	UWORD Active_Players[MAX_INACTIVE_PLAYERS];	 // array of player id numbers
	UWORD Inactive_Players[MAX_INACTIVE_PLAYERS];	 // array of player id numbers
	struct TeamLeagueStats SeasonStats;     // stats for the current season
};

struct LeagueScheduleGameInfo
{
	BYTE Status;
	BYTE Team[2];  // 0 is home 1 is visitors
	BYTE Score[2];
};

// defines for the LeagueScheduleGameInfo status
#define GAME_STATUS_NO_GAME			0
#define GAME_STATUS_TO_BE_PLAYED	1
#define GAME_STATUS_PLAYED			2
#define GAME_STATUS_EXTERN			3
#define GAME_STATUS_SAVED			4
#define GAME_STATUS_HOLD			5

struct LeagueScheduleWeekInfo
{
	struct LeagueScheduleGameInfo Game[MAX_GAMES_PER_WEEK];
};

struct LeagueScheduleInfo
{
	BYTE weeks;			// how many weeks in this season
	struct LeagueScheduleWeekInfo Week[MAX_WEEKS_IN_LEAGUE];
};


struct LeagueInfo
{
	BYTE organization;  // 0 is NFL   1 is straight(no divs or confs)
	char description[ MAX_LEAGUE_DESC ];
	BYTE start_year;
	BYTE current_year;
	BYTE current_week;  // this also represents playoffs and offseason
	BYTE current_team;
	BYTE number_of_teams;
	BYTE team_last_used[ MAX_SCREEN_TEAMS ];
	struct LeagueTeamInfo Team[MAX_LEAGUE_TEAMS];
	struct LeagueScheduleInfo Schedule;
};














struct LeagueInterceptStats
{
	UWORD Intercepts;
	UWORD Touchdowns;
	UBYTE Long;
	short Yards;
};

struct LeagueQBStats
{
	short Yards;
	short SackYards;
	UWORD Attempts;
	UWORD Completions;
	UWORD Sacks;
	UWORD Intercepts;
	UWORD Touchdowns;
	UWORD Long;
};

struct LeagueReceiverStats
{
	UBYTE Long;
	UWORD Touchdowns;
	UWORD Catches;
	short Yards;
};

struct LeagueRunnerStats
{
	UBYTE Long;
	UWORD Touchdowns;
	UWORD Attempts;
	short Yards;
};

struct LeaguePunterStats
{
	UBYTE Long;
	UWORD Blocks;
	UWORD Touchbacks;
	UWORD Punts;
	short Yards;
};

struct LeagueKickerStats
{
	UWORD FG10_Att;
	UWORD FG20_Att;
	UWORD FG30_Att;
	UWORD FG40_Att;
	UWORD FG50_Att;
	UWORD FG10_Made;
	UWORD FG20_Made;
	UWORD FG30_Made;
	UWORD FG40_Made;
	UWORD FG50_Made;
	UWORD EP_Made;
	UWORD EP_Att;
	UWORD Long;
};

struct LeagueTackleStats
{
	UWORD Sacks;
	UWORD Tackles;
};



struct LeaguePlayerStats
{
	struct LeagueQBStats        QBStats;
	struct LeagueRunnerStats    RunStats;
	struct LeagueReceiverStats  RcvrStats;
	struct LeaguePunterStats    PuntStats;
	struct LeagueRunnerStats    KRStats;
	struct LeagueRunnerStats    PRStats;
	struct LeagueKickerStats    KickStats;
	struct LeagueInterceptStats IntStats;
	struct LeagueTackleStats    TackleStats;
};

struct LeaguePlayerInfo
{
	UWORD ID;
	BYTE Team;
	BYTE Status;
	BYTE Injury;
	BYTE Timer;
	BYTE Seasons;
	BYTE filler[5];
	struct RosterInfo Player;
	struct LeaguePlayerStats Career_Stats;
};


#define PLAYER_ACTIVE	0
#define PLAYER_INJURED  1
#define PLAYER_INACTIVE 2
#define PLAYER_FREE_AGENT 3
#define PLAYER_DRAFTEE  4
#define PLAYER_RETIRED  5







