'
'                         Q B a s i c   N i b b l e s 2
'
'
' Nibbles is a game for one or two players.  Navigate your snakes
' around the game board trying to eat up numbers while avoiding
' running into walls or other snakes.  The more numbers you eat up,
' the more points you gain and the longer your snake becomes.
'
' To run this game, press Shift+F5.
'
' To exit QBasic, press Alt, F, X.
'
' To get help on a BASIC keyword, move the cursor to the keyword and press
' F1 or click the right mouse button.
'

'Set default data type to integer for faster game play
DEFINT A-Z

'User-defined TYPEs
TYPE snakeBody
    row AS INTEGER
    col AS INTEGER
END TYPE

'This type defines the player's snake
TYPE snaketype
    head      AS INTEGER
    length    AS INTEGER
    row       AS INTEGER
    col       AS INTEGER
    direction AS INTEGER
    lives     AS INTEGER
    score     AS INTEGER
    scolor    AS INTEGER
    alive     AS INTEGER
END TYPE

'This type is used to represent the playing screen in memory
'It is used to simulate graphics in text mode, and has some interesting,
'and slightly advanced methods to increasing the speed of operation.
'Instead of the normal 80x25 text graphics using chr$(219) "", we will be
'using chr$(220)"" and chr$(223) "" and chr$(219) "" to mimic an 80x50
'pixel screen.
'Check out sub-programs SET and POINTISTHERE to see how this is implemented
'feel free to copy these (as well as arenaType and the DIM ARENA stmt and the
'initialization code in the DrawScreen subprogram) and use them in your own
'programs
TYPE arenaType
    realRow     AS INTEGER        'Maps the 80x50 point into the real 80x25
    acolor      AS INTEGER        'Stores the current color of the point
    sister      AS INTEGER        'Each char has 2 points in it.  .SISTER is
END TYPE                          '-1 if sister point is above, +1 if below

'Sub Declarations
DECLARE SUB SpacePause (text$)
DECLARE SUB PrintScore (NumPlayers%, score1%, score2%, lives1%, lives2%)
DECLARE SUB Intro ()
DECLARE SUB GetInputs (NumPlayers, speed, diff$, monitor$)
DECLARE SUB DrawScreen ()
DECLARE SUB PlayNibbles (NumPlayers, speed, diff$)
DECLARE SUB set (row, col, acolor)
DECLARE SUB Center (row, text$)
DECLARE SUB DoIntro ()
DECLARE SUB win ()
DECLARE SUB lose ()
DECLARE SUB Initialize ()
DECLARE SUB SparklePause ()
DECLARE SUB Level (WhatToDO, sammy() AS snaketype)
DECLARE SUB InitColors ()
DECLARE SUB EraseSnake (snake() AS ANY, snakeBod() AS ANY, snakeNum%)
DECLARE FUNCTION StillWantsToPlay ()
DECLARE FUNCTION PointIsThere (row, col, backColor)

'Constants
CONST TRUE = -1
CONST FALSE = NOT TRUE
CONST MAXSNAKELENGTH = 5000
CONST STARTOVER = 1             ' Parameters to 'Level' SUB
CONST SAMELEVEL = 2
CONST NEXTLEVEL = 3

'Global Variables
DIM SHARED arena(1 TO 50, 1 TO 80) AS arenaType
DIM SHARED curLevel, colortable(10)

    RANDOMIZE TIMER
    GOSUB ClearKeyLocks
    Intro
    GetInputs NumPlayers, speed, diff$, monitor$
    GOSUB SetColors
    DrawScreen

    DO
      PlayNibbles NumPlayers, speed, diff$
    LOOP WHILE StillWantsToPlay

    GOSUB RestoreKeyLocks
    COLOR 15, 0
    CLS
    CALL lose
END

ClearKeyLocks:
    DEF SEG = 0                     ' Turn off CapLock, NumLock and ScrollLock
    KeyFlags = PEEK(1047)
    POKE 1047, &H0
    DEF SEG
    RETURN

RestoreKeyLocks:
    DEF SEG = 0                     ' Restore CapLock, NumLock and ScrollLock states
    POKE 1047, KeyFlags
    DEF SEG
    RETURN

SetColors:
    IF monitor$ = "M" THEN
        RESTORE mono
    ELSE
        RESTORE normal
    END IF

    FOR a = 1 TO 6
        READ colortable(a)
    NEXT a
    RETURN
    LET c% = 3
           'snake1     snake2   Walls  Background  Dialogs-Fore  Back
mono:   DATA 15,         7,       7,     0,          15,            0
normal: DATA 12,         10,      9,     0,          13,            6
END

'Center:
'  Centers text on given row
SUB Center (row, text$)
    LOCATE row, 41 - LEN(text$) / 2
    PRINT text$;
END SUB

'DrawScreen:
'  Draws playing field
SUB DrawScreen

    'initialize screen
    VIEW PRINT
    COLOR colortable(1), colortable(4)
    CLS

    'Print title & message
    Center 1, "Nibbles!"
    Center 11, "Initializing Playing Field..."
    
    'Initialize arena array
    FOR row = 1 TO 50
        FOR col = 1 TO 80
            arena(row, col).realRow = INT((row + 1) / 2)
            arena(row, col).sister = (row MOD 2) * 2 - 1
        NEXT col
    NEXT row
END SUB

'EraseSnake:
'  Erases snake to facilitate moving through playing field
SUB EraseSnake (snake() AS snaketype, snakeBod() AS snakeBody, snakeNum)

    FOR c = 0 TO 9
        FOR b = snake(snakeNum).length - c TO 0 STEP -10
            tail = (snake(snakeNum).head + MAXSNAKELENGTH - b) MOD MAXSNAKELENGTH
            set snakeBod(tail, snakeNum).row, snakeBod(tail, snakeNum).col, colortable(4)
        NEXT b
    NEXT c
    
END SUB

'GetInputs:
'  Gets player inputs
SUB GetInputs (NumPlayers, speed, diff$, monitor$)
    COLOR 7, 0
    CLS
PLAY "MB"
PLAY "T255"
PLAY "ML"
PLAY "L4"
PLAY "<<<<b- >de-"
PLAY "L1"
PLAY "f"
PLAY "L4"
PLAY "<b->de-"
PLAY "L1"
PLAY "f"
PLAY "L4"
PLAY "<b->de-"
PLAY "L2"
PLAY "fd<b->d"
PLAY "L1"
PLAY "c"
PLAY "p4"
PLAY "L4"
PLAY "dc"
PLAY "L2"
PLAY "<b-."
PLAY "L4"
PLAY "b-"
PLAY "L2"
PLAY ">df"
PLAY "L4"
PLAY "f"
PLAY "L4"
PLAY "e-"
PLAY "p4"
PLAY "L4"
PLAY "de-"
PLAY "L2"
PLAY "fd<b->c"
PLAY "L1"
PLAY "<b-"
PLAY "L4"
PLAY "b-"


    DO
        LOCATE 5, 47: PRINT SPACE$(34);
        LOCATE 5, 20
        INPUT "How many players (1 or 2)"; num$
    LOOP UNTIL VAL(num$) = 1 OR VAL(num$) = 2
    NumPlayers = VAL(num$)

    LOCATE 8, 21: PRINT "Skill level (1 to 100)"
    LOCATE 9, 22: PRINT "1   = Novice"
    LOCATE 10, 22: PRINT "90  = Expert"
    LOCATE 11, 22: PRINT "100 = Twiddle Fingers"
    LOCATE 12, 15: PRINT "(Computer speed may affect your skill level)"
    DO
        LOCATE 8, 44: PRINT SPACE$(35);
        LOCATE 8, 43
        INPUT gamespeed$
    LOOP UNTIL VAL(gamespeed$) >= 1 AND VAL(gamespeed$) <= 100
    speed = VAL(gamespeed$)
  
    speed = (100 - speed) * 2 + 1

    DO
        LOCATE 15, 56: PRINT SPACE$(25);
        LOCATE 15, 15
        INPUT "Increase game speed during play (Y or N)"; diff$
        diff$ = UCASE$(diff$)
    LOOP UNTIL diff$ = "Y" OR diff$ = "N"

    DO
        LOCATE 17, 46: PRINT SPACE$(34);
        LOCATE 17, 17
        INPUT "Monochrome or color monitor (M or C)"; monitor$
        monitor$ = UCASE$(monitor$)
    LOOP UNTIL monitor$ = "M" OR monitor$ = "C"

    startTime# = TIMER                          ' Calculate speed of system
    FOR i# = 1 TO 1000: NEXT i#                 ' and do some compensation
    stopTime# = TIMER
    speed = speed * .5 / (stopTime# - startTime#)

END SUB

'InitColors:
'Initializes playing field colors
SUB InitColors
    
    FOR row = 1 TO 50
        FOR col = 1 TO 80
            arena(row, col).acolor = colortable(4)
        NEXT col
    NEXT row

    CLS
   
    'Set (turn on) pixels for screen border
    FOR col = 1 TO 80
        set 3, col, colortable(3)
        set 50, col, colortable(3)
    NEXT col

    FOR row = 4 TO 49
        set row, 1, colortable(3)
        set row, 80, colortable(3)
    NEXT row

END SUB

'Intro:
'  Displays game introduction
SUB Intro
    SCREEN 0
    WIDTH 80, 25
    COLOR 14, 0
    CLS

    Center 4, "Q B a s i c   N i b b l e s 2... ~THE RETURN~"
    COLOR 12
    Center 6, ""
    Center 8, "Nibbles is a game for one or two players.  Navigate your snakes"
    Center 9, "around the game board trying to eat up numbers while avoiding"
    Center 10, "running into walls or other snakes.  The more numbers you eat up,"
    Center 11, "the more points you gain and the longer your snake becomes."
    Center 13, " Game Controls "
    Center 15, "  General             Player 1               Player 2    "
    Center 16, "                        (Up)                   (Up)      "
    Center 17, "P - Pause                " + CHR$(24) + "                      W       "
    Center 18, "   Q - Quit       (Left) " + CHR$(27) + "   " + CHR$(26) + " (Right)   (Left) A   D (Right)  "
    Center 19, "                         " + CHR$(25) + "                      S       "
    Center 20, "                       (Down)                 (Down)     "
    Center 24, "Press any key to continue"

    SparklePause

END SUB

'Level:
'Sets game level
SUB Level (WhatToDO, sammy() AS snaketype) STATIC
    
    SELECT CASE (WhatToDO)

    CASE STARTOVER
        IF curLevel < 1 THEN LET curLevel = 1

    CASE NEXTLEVEL
        curLevel = curLevel + 1
    END SELECT

    sammy(1).head = 1                       'Initialize Snakes
    sammy(1).length = 2
    sammy(1).alive = TRUE
    sammy(2).head = 1
    sammy(2).length = 2
    sammy(2).alive = TRUE

    InitColors
    
    SELECT CASE curLevel
    CASE 1
        FOR i = 10 TO 20
        set i, 10, colortable(3)
        set i, 30, colortable(2)
        set i, 50, colortable(3)
        set i, 70, colortable(2)
        NEXT i
        FOR i = 30 TO 40
        set i, 10, colortable(2)
        set i, 30, colortable(3)
        set i, 50, colortable(2)
        set i, 70, colortable(3)
        NEXT i
        sammy(1).row = 5: sammy(2).row = 15
        sammy(1).col = 5: sammy(2).col = 15
        sammy(1).direction = 2: sammy(2).direction = 4
   
    CASE 2
        FOR i = 20 TO 60
            set 7, i, colortable(3)
            set 12, i, colortable(3)
            set 17, i, colortable(3)
            set 22, i, colortable(3)
            set 32, i, colortable(3)
            set 42, i, colortable(3)
            set 37, i, colortable(3)
            set 27, i, colortable(3)
            set 47, i, colortable(3)
        NEXT i
        sammy(1).row = 5: sammy(2).row = 43
        sammy(1).col = 5: sammy(2).col = 20
        sammy(1).direction = 2: sammy(2).direction = 4



    CASE 3
        FOR i = 5 TO 75 STEP 5
            FOR w = 5 TO 45 STEP 5
              set w, i, colortable(3)
              set w, i, colortable(3)
            NEXT w
        NEXT i
        sammy(1).row = 23: sammy(2).row = 23
        sammy(1).col = 52: sammy(2).col = 32
        sammy(1).direction = 2: sammy(2).direction = 1

    CASE 4
        FOR i = 1 TO 50
            IF i <> 43 THEN
           FOR w = 10 TO 50 STEP 10
            set w, i, colortable(3)
          NEXT w
          END IF
        NEXT i
        FOR i = 30 TO 80
            IF i <> 43 THEN
         FOR w = 15 TO 45 STEP 10
            set w, i, colortable(3)
          NEXT w
          END IF
        NEXT i
        sammy(1).row = 9: sammy(2).row = 23
        sammy(1).col = 75: sammy(2).col = 12
        sammy(1).direction = 3: sammy(2).direction = 4
   
    CASE 5
        FOR i = 1 TO 30
        LET c% = INT(RND * 40) + 5
        LET d% = INT(RND * 70) + 5
        set c%, d%, colortable(3)
        NEXT i
        sammy(1).row = 25: sammy(2).row = 25
        sammy(1).col = 50: sammy(2).col = 30
        sammy(1).direction = 1: sammy(2).direction = 2

    CASE 6
        FOR i = 4 TO 49
            IF i > 30 OR i < 22 OR i = 26 THEN
                set i, 10, colortable(3)
                set i, 20, colortable(3)
                set i, 30, colortable(3)
                set i, 40, colortable(3)
                set i, 50, colortable(3)
                set i, 60, colortable(3)
                set i, 70, colortable(3)
            END IF
        NEXT i
        FOR i = 5 TO 75
          set 26, i, colortable(3)
        NEXT i
        FOR i = 23 TO 29
          FOR w = 15 TO 65 STEP 10
            set i, w, colortable(3)
          NEXT w
        NEXT i
        sammy(1).row = 7: sammy(2).row = 43
        sammy(1).col = 65: sammy(2).col = 15
        sammy(1).direction = 2: sammy(2).direction = 1

    CASE 7
        FOR i = 10 TO 70
         set 7, i, colortable(3)
        NEXT i
        FOR i = 7 TO 40
         set i, 10, colortable(3)
         set i, 70, colortable(3)
        NEXT i
        FOR i = 15 TO 65
         set 40, i, colortable(3)
        NEXT i
        FOR i = 12 TO 40
         set i, 15, colortable(3)
         set i, 65, colortable(3)
        NEXT i
        FOR i = 20 TO 60
         set 12, i, colortable(3)
        NEXT i
        FOR i = 12 TO 35
         set i, 20, colortable(3)
         set i, 60, colortable(3)
        NEXT i
        FOR i = 25 TO 55
         set 30, i, colortable(3)
        NEXT i
        FOR i = 17 TO 30
         set i, 25, colortable(3)
         set i, 55, colortable(3)
        NEXT i
        FOR i = 30 TO 50
         set 22, i, colortable(2)
        NEXT i
        sammy(1).row = 6: sammy(2).row = 47
        sammy(1).col = 4: sammy(2).col = 6
        sammy(1).direction = 2: sammy(2).direction = 2

    CASE 8
        LET b% = 0
        FOR i = 3 TO 45 STEP 3
        FOR w = 4 TO 75 STEP 6
        LET b% = INT(RND * 3) + 1
            set i, w + b%, colortable(3)
        NEXT w
        NEXT i
        sammy(1).row = 7: sammy(2).row = 5
        sammy(1).col = 8: sammy(2).col = 15
        sammy(1).direction = 2: sammy(2).direction = 1

    CASE 9
        FOR i = 6 TO 47
            set i, i, colortable(3)
            set i, i + 14, colortable(3)
            set i, i + 28, colortable(3)
        NEXT i
        sammy(1).row = 40: sammy(2).row = 15
        sammy(1).col = 75: sammy(2).col = 5
        sammy(1).direction = 1: sammy(2).direction = 2
   
    CASE ELSE
    CALL win
    END SELECT
END SUB

SUB lose
    OPEN "score.DAT" FOR INPUT AS #1
    PRINT "Here is a listing of all the people who have beat this game and a short message from them."
    PRINT
    DO
        LINE INPUT #1, n$
        PRINT n$
        PRINT m$
    LOOP UNTIL (EOF(1))
END SUB

'PlayNibbles:
'  Main routine that controls game play
SUB PlayNibbles (NumPlayers, speed, diff$)

    'Initialize Snakes
    DIM sammyBody(MAXSNAKELENGTH - 1, 1 TO 2) AS snakeBody
    DIM sammy(1 TO 2) AS snaketype
    sammy(1).lives = 5
    sammy(1).score = 0
    sammy(1).scolor = colortable(1)
    sammy(2).lives = 5
    sammy(2).score = 0
    sammy(2).scolor = colortable(2)
                 
    Level STARTOVER, sammy()
    startRow1 = sammy(1).row: startCol1 = sammy(1).col
    startRow2 = sammy(2).row: startCol2 = sammy(2).col

    curSpeed = speed

    'play Nibbles until finished

    SpacePause "     Level" + STR$(curLevel) + ",  Push Space"
    gameOver = FALSE
    DO
        IF NumPlayers = 1 THEN
            sammy(2).row = 0
        END IF

        number = 1          'Current number that snakes are trying to run into
        nonum = TRUE        'nonum = TRUE if a number is not on the screen

        playerDied = FALSE
        PrintScore NumPlayers, sammy(1).score, sammy(2).score, sammy(1).lives, sammy(2).lives
   

        DO
            'Print number if no number exists
            IF nonum = TRUE THEN
                DO
                    numberRow = INT(RND(1) * 47 + 3)
                    NumberCol = INT(RND(1) * 78 + 2)
                    sisterRow = numberRow + arena(numberRow, NumberCol).sister
                LOOP UNTIL NOT PointIsThere(numberRow, NumberCol, colortable(4)) AND NOT PointIsThere(sisterRow, NumberCol, colortable(4))
                numberRow = arena(numberRow, NumberCol).realRow
                nonum = FALSE
                COLOR colortable(1), colortable(4)
                LOCATE numberRow, NumberCol
                PRINT RIGHT$(STR$(number), 1);
                count = 0
            END IF

            'Delay game
            FOR a# = 1 TO curSpeed:  NEXT a#

            'Get keyboard input & Change direction accordingly
            kbd$ = INKEY$
            SELECT CASE kbd$
                CASE "w", "W": IF sammy(2).direction <> 2 THEN sammy(2).direction = 1
                CASE "s", "S": IF sammy(2).direction <> 1 THEN sammy(2).direction = 2
                CASE "a", "A": IF sammy(2).direction <> 4 THEN sammy(2).direction = 3
                CASE "d", "D": IF sammy(2).direction <> 3 THEN sammy(2).direction = 4
                CASE CHR$(0) + "H": IF sammy(1).direction <> 2 THEN sammy(1).direction = 1
                CASE CHR$(0) + "P": IF sammy(1).direction <> 1 THEN sammy(1).direction = 2
                CASE CHR$(0) + "K": IF sammy(1).direction <> 4 THEN sammy(1).direction = 3
                CASE CHR$(0) + "M": IF sammy(1).direction <> 3 THEN sammy(1).direction = 4
                CASE "q", "Q": END
                CASE "p", "P": SpacePause " Game Paused ... Push Space  "
                CASE ELSE
            END SELECT

            FOR a = 1 TO NumPlayers
                'Move Snake
                SELECT CASE sammy(a).direction
                    CASE 1: sammy(a).row = sammy(a).row - 1
                    CASE 2: sammy(a).row = sammy(a).row + 1
                    CASE 3: sammy(a).col = sammy(a).col - 1
                    CASE 4: sammy(a).col = sammy(a).col + 1
                END SELECT

                'If snake hits number, respond accordingly
                IF numberRow = INT((sammy(a).row + 1) / 2) AND NumberCol = sammy(a).col THEN
                       PLAY "MBT255O2L8DP64DP64DP64L4E"
                    IF sammy(a).length < (MAXSNAKELENGTH - 30) THEN
                        sammy(a).length = sammy(a).length + number * 4
                    END IF
                    sammy(a).score = sammy(a).score + number
                    PrintScore NumPlayers, sammy(1).score, sammy(2).score, sammy(1).lives, sammy(2).lives
                    number = number + 1
                    IF number = 10 THEN
                        EraseSnake sammy(), sammyBody(), 1
                        EraseSnake sammy(), sammyBody(), 2
                        LOCATE numberRow, NumberCol: PRINT " "
                        Level NEXTLEVEL, sammy()
                        PrintScore NumPlayers, sammy(1).score, sammy(2).score, sammy(1).lives, sammy(2).lives
                        SpacePause "     Level" + STR$(curLevel) + ",  Push Space"
                        IF NumPlayers = 1 THEN sammy(2).row = 0
                        number = 1
                        IF diff$ = "P" THEN speed = speed - 10: curSpeed = speed
                    END IF
                    nonum = TRUE
                    IF curSpeed < 1 THEN curSpeed = 1
                END IF
            NEXT a

            FOR a = 1 TO NumPlayers
                'If player runs into any point, or the head of the other snake, it dies.
                IF PointIsThere(sammy(a).row, sammy(a).col, colortable(4)) OR (sammy(1).row = sammy(2).row AND sammy(1).col = sammy(2).col) THEN
                  
                   COLOR , colortable(4)
                    LOCATE numberRow, NumberCol
                    PRINT " "
                   
                    playerDied = TRUE
                    sammy(a).alive = FALSE
                    sammy(a).lives = sammy(a).lives - 1
                    IF sammy(a).lives > 0 THEN PLAY "MBT225O1L4DP64CP64C<P64L2BAG"
                'Otherwise, move the snake, and erase the tail
                ELSE
                    sammy(a).head = (sammy(a).head + 1) MOD MAXSNAKELENGTH
                    sammyBody(sammy(a).head, a).row = sammy(a).row
                    sammyBody(sammy(a).head, a).col = sammy(a).col
                    tail = (sammy(a).head + MAXSNAKELENGTH - sammy(a).length) MOD MAXSNAKELENGTH
                    set sammyBody(tail, a).row, sammyBody(tail, a).col, colortable(4)
                    sammyBody(tail, a).row = 0
                    set sammy(a).row, sammy(a).col, sammy(a).scolor
                END IF
            NEXT a

        LOOP UNTIL playerDied

        curSpeed = speed                ' reset speed to initial value
       
        FOR a = 1 TO NumPlayers
            EraseSnake sammy(), sammyBody(), a

            'If dead, then erase snake in really cool way
            IF sammy(a).alive = FALSE THEN
                'Update score
                sammy(a).score = sammy(a).score - 10
                PrintScore NumPlayers, sammy(1).score, sammy(2).score, sammy(1).lives, sammy(2).lives
                
                IF a = 1 THEN
                    SpacePause " Sammy Dies! Push Space! --->"
                ELSE
                    SpacePause " <---- Jake Dies! Push Space "
                END IF
            END IF
        NEXT a

        Level SAMELEVEL, sammy()
        PrintScore NumPlayers, sammy(1).score, sammy(2).score, sammy(1).lives, sammy(2).lives
     
    'play next round, until either of snake's lives have run out.
    LOOP UNTIL sammy(1).lives = 0 OR sammy(2).lives = 0

END SUB

'PointIsThere:
'  Checks the global  arena array to see if the boolean flag is set
FUNCTION PointIsThere (row, col, acolor)
    IF row <> 0 THEN
        IF arena(row, col).acolor <> acolor THEN
            PointIsThere = TRUE
        ELSE
            PointIsThere = FALSE
        END IF
    END IF
END FUNCTION

'PrintScore:
'  Prints players scores and number of lives playaining
SUB PrintScore (NumPlayers, score1, score2, lives1, lives2)
    COLOR 15, colortable(4)

    IF NumPlayers = 2 THEN
        LOCATE 1, 1
        PRINT USING "#,###,#00  Lives: #  <--JAKE"; score2; lives2
    END IF

    LOCATE 1, 49
    PRINT USING "SAMMY-->  Lives: #     #,###,#00"; lives1; score1
END SUB

'Set:
'  Sets row and column on playing field to given color to facilitate moving
'  of snakes around the field.
SUB set (row, col, acolor)
    IF row <> 0 THEN
        arena(row, col).acolor = acolor             'assign color to arena
        realRow = arena(row, col).realRow           'Get real row of pixel
        topFlag = arena(row, col).sister + 1 / 2    'Deduce whether pixel
                                                    'is on top, or bottom
        sisterRow = row + arena(row, col).sister    'Get arena row of sister
        sisterColor = arena(sisterRow, col).acolor  'Determine sister's color

        LOCATE realRow, col

        IF acolor = sisterColor THEN                'If both points are same
            COLOR acolor, acolor                           'Print chr$(219) ""
            PRINT CHR$(219);
        ELSE
            IF topFlag THEN                         'Since you cannot have
                IF acolor > 7 THEN                  'bright backgrounds
                    COLOR acolor, sisterColor       'determine best combo
                    PRINT CHR$(223);                'to use.
                ELSE
                    COLOR sisterColor, acolor
                    PRINT CHR$(220);
                END IF
            ELSE
                IF acolor > 7 THEN
                    COLOR acolor, sisterColor
                    PRINT CHR$(220);
                ELSE
                    COLOR sisterColor, acolor
                    PRINT CHR$(223);
                END IF
            END IF
        END IF
    END IF
END SUB

'SpacePause:
'  Pauses game play and waits for space bar to be pressed before continuing
SUB SpacePause (text$)

    COLOR colortable(5), colortable(6)
    Center 11, ""
    Center 12, " " + LEFT$(text$ + SPACE$(29), 29) + " "
    Center 13, ""
    WHILE INKEY$ <> "": WEND
    WHILE INKEY$ <> " ": WEND
    COLOR 15, colortable(4)

    FOR i = 21 TO 26            ' Restore the screen background
        FOR j = 24 TO 56
            set i, j, arena(i, j).acolor
        NEXT j
    NEXT i

END SUB

'SparklePause:
'  Creates flashing border for intro screen
SUB SparklePause

    COLOR 13, 0
    a$ = "*    *    *    *    *    *    *    *    *    *    *    *    *    *    *    *    *    "
    WHILE INKEY$ <> "": WEND 'Clear keyboard buffer

    WHILE INKEY$ = ""
        FOR a = 1 TO 5
            LOCATE 1, 1                             'print horizontal sparkles
            PRINT MID$(a$, a, 80);
            LOCATE 22, 1
            PRINT MID$(a$, 6 - a, 80);

            FOR b = 2 TO 21                         'Print Vertical sparkles
                c = (a + b) MOD 5
                IF c = 1 THEN
                    LOCATE b, 80
                    PRINT "*";
                    LOCATE 23 - b, 1
                    PRINT "*";
                ELSE
                    LOCATE b, 80
                    PRINT " ";
                    LOCATE 23 - b, 1
                    PRINT " ";
                END IF
            NEXT b
        NEXT a
    WEND

END SUB

'StillWantsToPlay:
'  Determines if users want to play game again.
FUNCTION StillWantsToPlay
    REM taps
    LET c% = c% - 1
    IF c% = 0 THEN GOTO uncodend
    COLOR colortable(5), colortable(6)
    Center 10, ""
    Center 11, "       G A M E   O V E R       "
    Center 12, "                               "
    Center 13, "      play Again?   (Y/N)      "
    Center 14, ""

    WHILE INKEY$ <> "": WEND
    DO
        kbd$ = UCASE$(INKEY$)
    LOOP UNTIL kbd$ = "Y" OR kbd$ = "N"

    COLOR 15, colortable(4)
    Center 10, "                                 "
    Center 11, "                                 "
    Center 12, "                                 "
    Center 13, "                                 "
    Center 14, "                                 "

    IF kbd$ = "Y" THEN
        StillWantsToPlay = TRUE
    ELSE
        StillWantsToPlay = FALSE
        COLOR 7, 0
        CLS
    END IF
    GOTO END2
uncodend:
    COLOR colortable(5), colortable(6)
    Center 10, ""
    Center 11, "  ***************************  "
    Center 12, "  ********GAME OVER**********  "
    Center 13, "  **HIT ANY KEY TO CONTINUE**  "
    Center 14, ""
    WHILE INKEY$ <> "": WEND
    CLS
    END
END2: END FUNCTION

SUB win
    COLOR 4, 7
    CLS
    OPEN "score.DAT" FOR APPEND AS #1
        PRINT "Congatulations!!! You Just Murdered This Program"
        PRINT
        PRINT "Please enter your computer Style john hancock:"
        INPUT n$
        PRINT
        PRINT "Please enter a Note to Non-Winners"
        INPUT m$
        WRITE #1, n$, m$
        PRINT
        PRINT "Good Job, And Come Again"
    CLOSE #1
END
END SUB

