@echo off

Rem /  Batch File Installer for
Rem /      Hand of Fate
Rem /      version 1.04
Rem /  (c) 1994 Virgin Games
Rem /  MJS3.15

cls
if exist HOFP104.EXE goto NOERR
goto ERR3

:NOERR
if %1x==x goto TryDefault
if exist %1\HOF.EXE goto DO_IT
goto ERR

:TryDefault
if exist c:\westwood\hof\hof.exe goto CONTINUE
goto usage

:CONTINUE
echo Detected default install directory. 
echo.
set HOFPTH=C:\WESTWOOD\HOF
if %HOFPTH%==C:\WESTWOOD\HOF goto DO_IT2
goto ERR2

:DO_IT
set HOFPTH=%1
if %HOFPTH%==%1 goto DO_IT2 
goto ERR2

:DO_IT2
echo One moment please...
echo.
echo Loading update information...
copy \hofp104.exe %HOFPTH% > NUL
echo Updating old files... 
echo.
%HOFPTH%\hofp104 %HOFPTH% 
del %HOFPTH%\hofp104.exe
%HOFPTH%\patch %HOFPTH%
pause
if exist %HOFPTH%\readme.bat goto SUCCESS
goto ERROR

:ERR3
echo.
echo             HOFP104.EXE file not found  
echo.
echo           Please ensure that the install is run from the 
echo           floppy disk drive.
echo.
echo           For example, you should be typing:
echo           A:
echo           INSTALL
echo.
echo.
goto ERROR

:ERR2
echo.
echo             Not enough environment space   
echo                  to finish installation of update.
echo.
echo            Please increase the environment space before 
echo            running the install. 
echo.
echo            For example, add: 
echo            SHELL=C:\DOS\COMMAND.COM C:\DOS\ /p /e:256
echo            to you CONFIG.SYS file.
echo.
echo            Do NOT run the install from Windows.
echo.
echo.
goto ERROR

:ERR
echo. 
echo      *** Could not find Hand of Fate files in: 
echo          %1 
echo          please check path.

:USAGE
echo. 
echo      To update your installation of Hand of Fate, type "INSTALL"
echo      followed by a space and the name of the directory where the
echo      Hand of fate files were originally installed.
echo. 
echo      For example, if the update files are located on a disk in
echo      drive A:, and HOF was originally installed to D:\HOF, the 
echo      commands would look like this:
echo. 
echo      A:
echo      INSTALL D:\HOF
echo. 
goto end

:ERROR
echo            Failed attempt to update Lands of Lore 
echo.
echo                  For assistance, please contact 
echo                  Virgin Games Technical Support
echo                         (714) 833-1999
goto end

:SUCCESS
cls
echo       Updated "Hand of Fate" to version 1.04 
echo.
echo      Do NOT re-install Hand of FAte from the original disks or
echo      else the updated files will be overwritten.  You MAY however
echo      run the INSTALL program from the hard drive to reconfigure
echo      your hardware setup.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.

:END
set HOFPTH=
echo. 

