#include <stdlib.h>
#include "screen.h"
#include "palette.h"
#include "pattern.h"
#include "sprite.h"
#include "keyboard.h"
#include "angle.h"
#include "xem.h"
#include "voice.h"
#include "p_player.h"
#include "p_effect.h"

#define STAND   0
#define SIT     1
#define JUMP    2
#define FALL    3
#define RUN     4

#define LEFT_DIR   1
#define RIGHT_DIR  0
#define CDIR_SIGN   (-((cspr.flip<<1)-1))
#define DIR_SIGN(_spr)   (-((sprite[_spr].flip<<1)-1))

#define MOVE     1
#define NO_MOVE  0

extern long score;
extern int p1Rest;
extern int p2Rest;
extern long scrollSpeed;
extern int p1Barrier;
extern int p2Barrier;
extern int p1BarrierSpr;
extern int p2BarrierSpr;


void attackZako(int spr,int p)
{
	sprite[spr].var[0]-=p;
	score=10;
	if (sprite[spr].var[0]<=0) {
		explosion1(sprite[spr].x,sprite[spr].y);
		resetSprite(spr);
		sayVoice(V_EXPLO1);
		setItem(sprite[spr].var[1],sprite[spr].x,sprite[spr].y);
		switch(sprite[spr].var[5]) {
			case 1:
				score=150;
				break;
			case 2:
				score=2000;
				break;
			case 3:
				score=300;
				break;
			case 4:
			case 24:
				score=5000;
				explosion2(sprite[spr].x,sprite[spr].y);
				break;
			case 5:
			case 25:
				score=150;
				break;
			case 21:
				score=500;
				break;
			case 31:
				score=100;
				break;
		}
	}
	else sayVoice(V_PUNCH1);

}
void zakoCheck2()
{
	B_WALL;
	cspr.vx=-cspr.vx;
	cspr.flip=1-cspr.flip;
}
void zakoCheck2r()
{
	explosion1(cspr.x,cspr.y);
	resetSprite(curSpr);
}


void zakoBulletCrush()
{
	if (p1Barrier>0&&CRUSH(p1BarrierSpr,1,0)) {
		resetSprite(curSpr);
		p1Barrier--;
	}
	if (p2Barrier>0&&CRUSH(p2BarrierSpr,1,0)) {
		resetSprite(curSpr);
		p2Barrier--;
	}
	if (CRUSH(P1_SPR,1,2)) {
		resetSprite(curSpr);
		dieP1();
	}
	if (CRUSH(P2_SPR,1,2)) {
		resetSprite(curSpr);
		dieP2();
	}
}

void zakoBulletReset()
{
	resetSprite(curSpr);
}


// zakot1

void zako1Move()
{
	byte newSpr;
	int r;

	if (cspr.x<I2FF(30)) cspr.vx=-cspr.vx;
	if (!random(300)) {
//		sayVoice(V_EXPLO3);
		newSpr=setSprite(NEW_SPR(EFFECT_SPR),ETC_SLOT,cspr.x,cspr.y,cspr.flip,1,0,G_SCR_OUT);
//		cspr.var[1]=50;
		setSpriteCrushFunction(newSpr,zakoBulletCrush);
		setSpriteCheckFunction2(newSpr,zakoBulletReset);
		setSpriteCheckFunction0(newSpr,zakoBulletReset);
		setSpriteCheckFunction1(newSpr,zakoBulletReset);
		r=random(360);
		setSpriteVelocity(newSpr,AD2XY(r,1));
	}
//	cspr.var[1]--;
//	sprite[newSpr].var[9]=currentEvent;
	if ((cspr.x>I2FF(350))&&(cspr.vx>0)) resetSprite(curSpr);
}
void zako1Crush()
{
	if (p1Barrier>0&&CRUSH(p1BarrierSpr,1,0)) {
		resetSprite(curSpr);
		p1Barrier-=30;
	}
	if (p2Barrier>0&&CRUSH(p2BarrierSpr,1,0)) {
		resetSprite(curSpr);
		p2Barrier-=30;
	}
	if (CRUSH(P1_SPR,1,2)) {
		attackZako(curSpr,10);
		dieP1();
	}
	if (CRUSH(P2_SPR,1,2)) {
		attackZako(curSpr,10);
		dieP2();
	}
}

void loadZako1(char* fname)
{
	loadSprite(ZAKO1_SLOT,fname);
}

void setZako1a(int x,int y, int hp)
{
	byte newSpr;

// 	sayVoice(V_EXPLO3);
	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO1_SLOT,I2FF(SCREEN_X(x)),I2FF(SCREEN_Y(y)));
	setSpriteMoveFunction(newSpr,zako1Move);
	setSpriteCrushFunction(newSpr,zako1Crush);
	setSpriteCheckFunction2(newSpr,zakoCheck2);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=I2FF(-1);
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[5]=1;
	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO1_SLOT,I2FF(SCREEN_X(x)+20),I2FF(SCREEN_Y(y)));
	setSpriteMoveFunction(newSpr,zako1Move);
	setSpriteCrushFunction(newSpr,zako1Crush);
	setSpriteCheckFunction2(newSpr,zakoCheck2);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=I2FF(-1);
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[5]=1;
	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO1_SLOT,I2FF(SCREEN_X(x)+40),I2FF(SCREEN_Y(y)));
	setSpriteMoveFunction(newSpr,zako1Move);
	setSpriteCrushFunction(newSpr,zako1Crush);
	setSpriteCheckFunction2(newSpr,zakoCheck2);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=I2FF(-1);
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[5]=1;
	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO1_SLOT,I2FF(SCREEN_X(x)+60),I2FF(SCREEN_Y(y)));
	setSpriteMoveFunction(newSpr,zako1Move);
	setSpriteCrushFunction(newSpr,zako1Crush);
	setSpriteCheckFunction2(newSpr,zakoCheck2);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=I2FF(-1);
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[5]=1;
	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO1_SLOT,I2FF(SCREEN_X(x)+80),I2FF(SCREEN_Y(y)));
	setSpriteMoveFunction(newSpr,zako1Move);
	setSpriteCrushFunction(newSpr,zako1Crush);
	setSpriteCheckFunction2(newSpr,zakoCheck2);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=I2FF(-1);
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[5]=1;
	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO1_SLOT,I2FF(SCREEN_X(x)+100),I2FF(SCREEN_Y(y)),0,1);
	setSpriteMoveFunction(newSpr,zako1Move);
	setSpriteCrushFunction(newSpr,zako1Crush);
	setSpriteCheckFunction2(newSpr,zakoCheck2);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=I2FF(-1);
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[1]=1;
	sprite[newSpr].var[5]=21;
//	sprite[newSpr].var[9]=currentEvent;
}
void setZako1b(int x,int y, int hp)
{
	byte newSpr;

// 	sayVoice(V_EXPLO3);
	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO1_SLOT,I2FF(SCREEN_X(x)),I2FF(SCREEN_Y(y)));
	setSpriteMoveFunction(newSpr,zako1Move);
	setSpriteCrushFunction(newSpr,zako1Crush);
	setSpriteCheckFunction2(newSpr,zakoCheck2);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=I2FF(-1);
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[5]=1;
	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO1_SLOT,I2FF(SCREEN_X(x)+20),I2FF(SCREEN_Y(y)));
	setSpriteMoveFunction(newSpr,zako1Move);
	setSpriteCrushFunction(newSpr,zako1Crush);
	setSpriteCheckFunction2(newSpr,zakoCheck2);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=I2FF(-1);
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[5]=1;
	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO1_SLOT,I2FF(SCREEN_X(x)+40),I2FF(SCREEN_Y(y)));
	setSpriteMoveFunction(newSpr,zako1Move);
	setSpriteCrushFunction(newSpr,zako1Crush);
	setSpriteCheckFunction2(newSpr,zakoCheck2);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=I2FF(-1);
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[5]=1;
	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO1_SLOT,I2FF(SCREEN_X(x)+60),I2FF(SCREEN_Y(y)));
	setSpriteMoveFunction(newSpr,zako1Move);
	setSpriteCrushFunction(newSpr,zako1Crush);
	setSpriteCheckFunction2(newSpr,zakoCheck2);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=I2FF(-1);
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[5]=1;
	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO1_SLOT,I2FF(SCREEN_X(x)+80),I2FF(SCREEN_Y(y)));
	setSpriteMoveFunction(newSpr,zako1Move);
	setSpriteCrushFunction(newSpr,zako1Crush);
	setSpriteCheckFunction2(newSpr,zakoCheck2);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=I2FF(-1);
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[5]=1;
	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO1_SLOT,I2FF(SCREEN_X(x)+100),I2FF(SCREEN_Y(y)),0,1);
	setSpriteMoveFunction(newSpr,zako1Move);
	setSpriteCrushFunction(newSpr,zako1Crush);
	setSpriteCheckFunction2(newSpr,zakoCheck2);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=I2FF(-1);
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[1]=2;
	sprite[newSpr].var[5]=21;
}

void setZako1c(int x,int y, int hp)
{
	byte newSpr;

// 	sayVoice(V_EXPLO3);
	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO1_SLOT,I2FF(SCREEN_X(x)),I2FF(SCREEN_Y(y)));
	setSpriteMoveFunction(newSpr,zako1Move);
	setSpriteCrushFunction(newSpr,zako1Crush);
	setSpriteCheckFunction2(newSpr,zakoCheck2);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=I2FF(-2);
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[5]=1;
	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO1_SLOT,I2FF(SCREEN_X(x)+20),I2FF(SCREEN_Y(y)));
	setSpriteMoveFunction(newSpr,zako1Move);
	setSpriteCrushFunction(newSpr,zako1Crush);
	setSpriteCheckFunction2(newSpr,zakoCheck2);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=I2FF(-2);
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[5]=1;
	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO1_SLOT,I2FF(SCREEN_X(x)+40),I2FF(SCREEN_Y(y)));
	setSpriteMoveFunction(newSpr,zako1Move);
	setSpriteCrushFunction(newSpr,zako1Crush);
	setSpriteCheckFunction2(newSpr,zakoCheck2);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=I2FF(-2);
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[5]=1;
	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO1_SLOT,I2FF(SCREEN_X(x)+60),I2FF(SCREEN_Y(y)));
	setSpriteMoveFunction(newSpr,zako1Move);
	setSpriteCrushFunction(newSpr,zako1Crush);
	setSpriteCheckFunction2(newSpr,zakoCheck2);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=I2FF(-2);
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[5]=1;
	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO1_SLOT,I2FF(SCREEN_X(x)+80),I2FF(SCREEN_Y(y)));
	setSpriteMoveFunction(newSpr,zako1Move);
	setSpriteCrushFunction(newSpr,zako1Crush);
	setSpriteCheckFunction2(newSpr,zakoCheck2);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=I2FF(-2);
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[5]=1;
	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO1_SLOT,I2FF(SCREEN_X(x)+100),I2FF(SCREEN_Y(y)),0,1);
	setSpriteMoveFunction(newSpr,zako1Move);
	setSpriteCrushFunction(newSpr,zako1Crush);
	setSpriteCheckFunction2(newSpr,zakoCheck2);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=I2FF(-2);
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[1]=1;
	sprite[newSpr].var[5]=21;
//	sprite[newSpr].var[9]=currentEvent;
}

void zako2Check0()
{
	B_FLOOR;
	cspr.vy=-cspr.vy;
}
void zako2Move()
{
	byte newSpr;
	int r;

	if (cspr.x<I2FF(-10)) {cspr.vx=-cspr.vx;cspr.flip=1-cspr.flip;}
	if (cspr.x<I2FF(-30)) resetSprite(curSpr);

	if (cspr.x>I2FF(265)&&cspr.vx>0) {cspr.vx=-cspr.vx;cspr.flip=1-cspr.flip;}
	if (!random(100)) {
//
//		sayVoice(V_EXPLO3);
		newSpr=setSprite(NEW_SPR(EFFECT_SPR),ETC_SLOT,cspr.x,cspr.y,cspr.flip,1,0,G_SCR_OUT);
		setSpriteCrushFunction(newSpr,zakoBulletCrush);
		setSpriteCheckFunction2(newSpr,zakoBulletReset);
		setSpriteCheckFunction0(newSpr,zakoBulletReset);
		setSpriteCheckFunction1(newSpr,zakoBulletReset);
		setSpriteVelocity(newSpr,AD2XY(23,1));
		sprite[newSpr].vx>>=1;
		sprite[newSpr].vy>>=1;
		newSpr=setSprite(NEW_SPR(EFFECT_SPR),ETC_SLOT,cspr.x,cspr.y,cspr.flip,1,0,G_SCR_OUT);
		setSpriteCrushFunction(newSpr,zakoBulletCrush);
		setSpriteCheckFunction2(newSpr,zakoBulletReset);
		setSpriteCheckFunction0(newSpr,zakoBulletReset);
		setSpriteCheckFunction1(newSpr,zakoBulletReset);
		setSpriteVelocity(newSpr,AD2XY(68,1));
		sprite[newSpr].vx>>=1;
		sprite[newSpr].vy>>=1;
		newSpr=setSprite(NEW_SPR(EFFECT_SPR),ETC_SLOT,cspr.x,cspr.y,cspr.flip,1,0,G_SCR_OUT);
		setSpriteCrushFunction(newSpr,zakoBulletCrush);
		setSpriteCheckFunction2(newSpr,zakoBulletReset);
		setSpriteCheckFunction0(newSpr,zakoBulletReset);
		setSpriteCheckFunction1(newSpr,zakoBulletReset);
		setSpriteVelocity(newSpr,AD2XY(113,1));
		sprite[newSpr].vx>>=1;
		sprite[newSpr].vy>>=1;
		newSpr=setSprite(NEW_SPR(EFFECT_SPR),ETC_SLOT,cspr.x,cspr.y,cspr.flip,1,0,G_SCR_OUT);
		setSpriteCrushFunction(newSpr,zakoBulletCrush);
		setSpriteCheckFunction2(newSpr,zakoBulletReset);
		setSpriteCheckFunction0(newSpr,zakoBulletReset);
		setSpriteCheckFunction1(newSpr,zakoBulletReset);
		setSpriteVelocity(newSpr,AD2XY(158,1));
		sprite[newSpr].vx>>=1;
		sprite[newSpr].vy>>=1;
		newSpr=setSprite(NEW_SPR(EFFECT_SPR),ETC_SLOT,cspr.x,cspr.y,cspr.flip,1,0,G_SCR_OUT);
		setSpriteCrushFunction(newSpr,zakoBulletCrush);
		setSpriteCheckFunction2(newSpr,zakoBulletReset);
		setSpriteCheckFunction0(newSpr,zakoBulletReset);
		setSpriteCheckFunction1(newSpr,zakoBulletReset);
		setSpriteVelocity(newSpr,AD2XY(203,1));
		sprite[newSpr].vx>>=1;
		sprite[newSpr].vy>>=1;
		newSpr=setSprite(NEW_SPR(EFFECT_SPR),ETC_SLOT,cspr.x,cspr.y,cspr.flip,1,0,G_SCR_OUT);
		setSpriteCrushFunction(newSpr,zakoBulletCrush);
		setSpriteCheckFunction2(newSpr,zakoBulletReset);
		setSpriteCheckFunction0(newSpr,zakoBulletReset);
		setSpriteCheckFunction1(newSpr,zakoBulletReset);
		setSpriteVelocity(newSpr,AD2XY(258,1));
		sprite[newSpr].vx>>=1;
		sprite[newSpr].vy>>=1;
		newSpr=setSprite(NEW_SPR(EFFECT_SPR),ETC_SLOT,cspr.x,cspr.y,cspr.flip,1,0,G_SCR_OUT);
		setSpriteCrushFunction(newSpr,zakoBulletCrush);
		setSpriteCheckFunction2(newSpr,zakoBulletReset);
		setSpriteCheckFunction0(newSpr,zakoBulletReset);
		setSpriteCheckFunction1(newSpr,zakoBulletReset);
		setSpriteVelocity(newSpr,AD2XY(293,1));
		sprite[newSpr].vx>>=1;
		sprite[newSpr].vy>>=1;
		newSpr=setSprite(NEW_SPR(EFFECT_SPR),ETC_SLOT,cspr.x,cspr.y,cspr.flip,1,0,G_SCR_OUT);
		setSpriteCrushFunction(newSpr,zakoBulletCrush);
		setSpriteCheckFunction2(newSpr,zakoBulletReset);
		setSpriteCheckFunction0(newSpr,zakoBulletReset);
		setSpriteCheckFunction1(newSpr,zakoBulletReset);
		setSpriteVelocity(newSpr,AD2XY(338,1));
		sprite[newSpr].vx>>=1;
		sprite[newSpr].vy>>=1;
	}
	if (cspr.x<I2FF(-30)) resetSprite(curSpr);
//	cspr.var[1]--;
//	sprite[newSpr].var[9]=currentEvent;
//	if ((cspr.x>I2FF(350))&&(cspr.vx>0)) resetSprite(curSpr);
}
void zako2Crush()
{
	if (p1Barrier>0&&CRUSH(p1BarrierSpr,1,0)) {
		resetSprite(curSpr);
		p1Barrier-=40;
	}
	if (p2Barrier>0&&CRUSH(p2BarrierSpr,1,0)) {
		resetSprite(curSpr);
		p2Barrier-=40;
	}
	if (CRUSH(P1_SPR,1,2)) {
		attackZako(curSpr,10);
		dieP1();
	}
	if (CRUSH(P2_SPR,1,2)) {
		attackZako(curSpr,10);
		dieP2();
	}
}

void loadZako2(char* fname)
{
	loadSprite(ZAKO2_SLOT,fname);
}

void setZako2a(int x,int y,int hp)
{
	byte newSpr;

	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO2_SLOT,I2FF(SCREEN_X(x)),I2FF(SCREEN_Y(y)),0,0,0,G_NAY);
	setSpriteMoveFunction(newSpr,zako2Move);
	setSpriteCrushFunction(newSpr,zako2Crush);
	setSpriteCheckFunction0(newSpr,zako2Check0);
	setSpriteCheckFunction2(newSpr,zakoCheck2);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=I2FF(-1);
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[1]=0;
	sprite[newSpr].var[5]=2;
}

void setZako2b(int x,int y,int hp)
{
	byte newSpr;

	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO2_SLOT,I2FF(SCREEN_X(x)),I2FF(SCREEN_Y(y)),0,0,0,G_NAY);
	setSpriteMoveFunction(newSpr,zako2Move);
	setSpriteCrushFunction(newSpr,zako2Crush);
	setSpriteCheckFunction0(newSpr,zako2Check0);
	setSpriteCheckFunction2(newSpr,zakoCheck2);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=I2FF(-1);
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[1]=1;
	sprite[newSpr].var[5]=2;
}

void setZako2c(int x,int y,int hp)
{
	byte newSpr;

	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO2_SLOT,I2FF(SCREEN_X(x)),I2FF(SCREEN_Y(y)),0,0,0,G_NAY);
	setSpriteMoveFunction(newSpr,zako2Move);
	setSpriteCrushFunction(newSpr,zako2Crush);
	setSpriteCheckFunction0(newSpr,zako2Check0);
	setSpriteCheckFunction2(newSpr,zakoCheck2);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=I2FF(-1);
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[1]=2;
	sprite[newSpr].var[5]=2;
}

void zako3Move()
{
	byte newSpr;

	if (cspr.x<I2FF(-10)) resetSprite(curSpr);
}
void zako3Crush()
{
	if (p1Barrier>0&&CRUSH(p1BarrierSpr,1,0)) {
		resetSprite(curSpr);
		p1Barrier-=30;
	}
	if (p2Barrier>0&&CRUSH(p2BarrierSpr,1,0)) {
		resetSprite(curSpr);
		p2Barrier-=30;
	}
	if (CRUSH(P1_SPR,1,2)) {
		attackZako(curSpr,10);
		dieP1();
	}
	if (CRUSH(P2_SPR,1,2)) {
		attackZako(curSpr,10);
		dieP2();
	}
}

void loadZako3(char* fname)
{
	loadSprite(ZAKO3_SLOT,fname);
}

void setZako3a(int x,int y,int hp)
{
	byte newSpr;

	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO3_SLOT,I2FF(SCREEN_X(x)),I2FF(random(200)),0,0,0);
	setSpriteMoveFunction(newSpr,zako3Move);
	setSpriteCrushFunction(newSpr,zako3Crush);
	setSpriteCheckFunction2(newSpr,zakoCheck2r);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=I2FF(-3);
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[1]=0;
	sprite[newSpr].var[5]=3;
	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO3_SLOT,I2FF(SCREEN_X(x)+20),I2FF(random(200)),0,0,0);
	setSpriteMoveFunction(newSpr,zako3Move);
	setSpriteCrushFunction(newSpr,zako3Crush);
	setSpriteCheckFunction2(newSpr,zakoCheck2r);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=I2FF(-3);
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[1]=0;
	sprite[newSpr].var[5]=3;
	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO3_SLOT,I2FF(SCREEN_X(x)+40),I2FF(random(200)),0,0,0);
	setSpriteMoveFunction(newSpr,zako3Move);
	setSpriteCrushFunction(newSpr,zako3Crush);
	setSpriteCheckFunction2(newSpr,zakoCheck2r);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=I2FF(-3);
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[1]=0;
	sprite[newSpr].var[5]=3;
	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO3_SLOT,I2FF(SCREEN_X(x)+60),I2FF(random(200)),0,0,0);
	setSpriteMoveFunction(newSpr,zako3Move);
	setSpriteCrushFunction(newSpr,zako3Crush);
	setSpriteCheckFunction2(newSpr,zakoCheck2r);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=I2FF(-3);
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[1]=0;
	sprite[newSpr].var[5]=3;
	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO3_SLOT,I2FF(SCREEN_X(x)+80),I2FF(random(200)),0,0,0);
	setSpriteMoveFunction(newSpr,zako3Move);
	setSpriteCrushFunction(newSpr,zako3Crush);
	setSpriteCheckFunction2(newSpr,zakoCheck2r);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=I2FF(-3);
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[1]=0;
	sprite[newSpr].var[5]=3;
	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO3_SLOT,I2FF(SCREEN_X(x)+100),I2FF(random(200)),0,0,0);
	setSpriteMoveFunction(newSpr,zako3Move);
	setSpriteCrushFunction(newSpr,zako3Crush);
	setSpriteCheckFunction2(newSpr,zakoCheck2r);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=I2FF(-3);
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[1]=0;
	sprite[newSpr].var[5]=3;
	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO3_SLOT,I2FF(SCREEN_X(x)+120),I2FF(random(200)),0,0,0);
	setSpriteMoveFunction(newSpr,zako3Move);
	setSpriteCrushFunction(newSpr,zako3Crush);
	setSpriteCheckFunction2(newSpr,zakoCheck2r);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=I2FF(-3);
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[1]=0;
	sprite[newSpr].var[5]=3;
	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO3_SLOT,I2FF(SCREEN_X(x)+140),I2FF(random(200)),0,0,0);
	setSpriteMoveFunction(newSpr,zako3Move);
	setSpriteCrushFunction(newSpr,zako3Crush);
	setSpriteCheckFunction2(newSpr,zakoCheck2r);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=I2FF(-3);
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[1]=0;
	sprite[newSpr].var[5]=3;
}

void setZako3b(int x,int y,int hp)
{
	byte newSpr;

    if (p1Rest<0) sprite[P1_SPR].y=sprite[P2_SPR].y;
	if (p2Rest<0) sprite[P2_SPR].y=sprite[P1_SPR].y;

	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO3_SLOT,I2FF(SCREEN_X(x)),sprite[random(2)].y,0,0,0);
	setSpriteMoveFunction(newSpr,zako3Move);
	setSpriteCrushFunction(newSpr,zako3Crush);
	setSpriteCheckFunction2(newSpr,zakoCheck2r);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=I2FF(-3);
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[1]=0;
	sprite[newSpr].var[5]=3;
	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO3_SLOT,I2FF(SCREEN_X(x)+20),sprite[random(2)].y,0,0,0);
	setSpriteMoveFunction(newSpr,zako3Move);
	setSpriteCrushFunction(newSpr,zako3Crush);
	setSpriteCheckFunction2(newSpr,zakoCheck2r);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=I2FF(-3);
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[1]=0;
	sprite[newSpr].var[5]=3;
	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO3_SLOT,I2FF(SCREEN_X(x)+40),sprite[random(2)].y,0,0,0);
	setSpriteMoveFunction(newSpr,zako3Move);
	setSpriteCrushFunction(newSpr,zako3Crush);
	setSpriteCheckFunction2(newSpr,zakoCheck2r);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=I2FF(-3);
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[1]=0;
	sprite[newSpr].var[5]=3;
	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO3_SLOT,I2FF(SCREEN_X(x)+60),sprite[random(2)].y,0,0,0);
	setSpriteMoveFunction(newSpr,zako3Move);
	setSpriteCrushFunction(newSpr,zako3Crush);
	setSpriteCheckFunction2(newSpr,zakoCheck2r);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=I2FF(-3);
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[1]=0;
	sprite[newSpr].var[5]=3;
	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO3_SLOT,I2FF(SCREEN_X(x)+80),sprite[random(2)].y,0,0,0);
	setSpriteMoveFunction(newSpr,zako3Move);
	setSpriteCrushFunction(newSpr,zako3Crush);
	setSpriteCheckFunction2(newSpr,zakoCheck2r);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=I2FF(-3);
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[1]=0;
	sprite[newSpr].var[5]=3;
	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO3_SLOT,I2FF(SCREEN_X(x)+100),sprite[random(2)].y,0,0,0);
	setSpriteMoveFunction(newSpr,zako3Move);
	setSpriteCrushFunction(newSpr,zako3Crush);
	setSpriteCheckFunction2(newSpr,zakoCheck2r);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=I2FF(-3);
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[1]=0;
	sprite[newSpr].var[5]=3;
	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO3_SLOT,I2FF(SCREEN_X(x)+120),sprite[random(2)].y,0,0,0);
	setSpriteMoveFunction(newSpr,zako3Move);
	setSpriteCrushFunction(newSpr,zako3Crush);
	setSpriteCheckFunction2(newSpr,zakoCheck2r);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=I2FF(-3);
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[1]=0;
	sprite[newSpr].var[5]=3;
	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO3_SLOT,I2FF(SCREEN_X(x)+140),sprite[random(2)].y,0,0,0);
	setSpriteMoveFunction(newSpr,zako3Move);
	setSpriteCrushFunction(newSpr,zako3Crush);
	setSpriteCheckFunction2(newSpr,zakoCheck2r);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=I2FF(-3);
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[1]=0;
	sprite[newSpr].var[5]=3;
}


void zako4Move()
{
	byte newSpr;
	int r;

//	if (cspr.x>I2FF(265)&&cspr.vx>0) {cspr.vx=-cspr.vx;cspr.flip=1-cspr.flip;}
	if (cspr.action!=1&&cspr.var[2]==0) {setSpriteAction(curSpr,1);cspr.var[2]=150;}
	cspr.var[2]--;
	if (cspr.aAttrib&A_ATTACK) {
//
//		sayVoice(V_EXPLO3);
		newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO4_SLOT,cspr.x,cspr.y,cspr.flip,4,0,G_SCR_OUT);
		setSpriteCrushFunction(newSpr,zakoBulletCrush);
		setSpriteCheckFunction2(newSpr,zakoBulletReset);
		setSpriteCheckFunction0(newSpr,zakoBulletReset);
		setSpriteCheckFunction1(newSpr,zakoBulletReset);
		setSpriteLayer(newSpr,4);
		r=random(180);
		setSpriteVelocity(newSpr,AD2XY(r,1));
		sprite[newSpr].vx>>=1;
		sprite[newSpr].vx-=scrollSpeed;
		sprite[newSpr].vy>>=1;
		sprite[newSpr].var[5]=31;
	}
	if (cspr.x<I2FF(-30)) resetSprite(curSpr);

}
void zako4Crush()
{
	if (p1Barrier>0&&CRUSH(p1BarrierSpr,1,0)) {
		resetSprite(curSpr);
		p1Barrier-=100;
	}
	if (p2Barrier>0&&CRUSH(p2BarrierSpr,1,0)) {
		resetSprite(curSpr);
		p2Barrier-=100;
	}
	if (CRUSH(P1_SPR,1,2)) {
		attackZako(curSpr,10);
		dieP1();
	}
	if (CRUSH(P2_SPR,1,2)) {
		attackZako(curSpr,10);
		dieP2();
	}
}

void loadZako4(char* fname)
{
	loadSprite(ZAKO4_SLOT,fname);
}

void setZako4a(int x,int y,int hp)
{
	byte newSpr;

	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO4_SLOT,I2FF(SCREEN_X(x)),I2FF(SCREEN_Y(y)),0,0,0,G_NAY);
	setSpriteMoveFunction(newSpr,zako4Move);
	setSpriteCrushFunction(newSpr,zako4Crush);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=-scrollSpeed;
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[1]=0;
	sprite[newSpr].var[2]=100;
	sprite[newSpr].var[5]=4;
}

void setZako4b(int x,int y,int hp)
{
	byte newSpr;

	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO4_SLOT,I2FF(SCREEN_X(x)),I2FF(SCREEN_Y(y)),0,0,0,G_NAY);
	setSpriteMoveFunction(newSpr,zako4Move);
	setSpriteCrushFunction(newSpr,zako4Crush);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=-(scrollSpeed<<1);
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[1]=0;
	sprite[newSpr].var[2]=100;
	sprite[newSpr].var[5]=4;
}

void zako4rCheck0()
{
	B_FLOOR;
	cspr.var[3]=0;
}

void zako4rMove()
{
	byte newSpr;
	int r;

	if (cspr.x<I2FF(-10)) {cspr.vx=-cspr.vx;cspr.flip=1-cspr.flip;}

	if (cspr.x>I2FF(265)&&cspr.vx>0) {cspr.vx=-cspr.vx;cspr.flip=1-cspr.flip;}
	if (cspr.action!=3&&cspr.var[2]==0) {setSpriteAction(curSpr,3);cspr.var[2]=150;}
	cspr.var[2]--;
	if (cspr.aAttrib&A_ATTACK) {
		newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO4_SLOT,cspr.x,cspr.y,cspr.flip,4,0,G_SCR_OUT);
		setSpriteCrushFunction(newSpr,zakoBulletCrush);
		setSpriteCheckFunction2(newSpr,zakoBulletReset);
		setSpriteCheckFunction0(newSpr,zakoBulletReset);
		setSpriteCheckFunction1(newSpr,zakoBulletReset);
		setSpriteLayer(newSpr,4);
		r=random(360);
		setSpriteVelocity(newSpr,AD2XY(-r,1));
		sprite[newSpr].vx-=scrollSpeed;
		sprite[newSpr].var[5]=31;
		newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO4_SLOT,cspr.x,cspr.y,cspr.flip,4,0,G_SCR_OUT);
		setSpriteCrushFunction(newSpr,zakoBulletCrush);
		setSpriteCheckFunction2(newSpr,zakoBulletReset);
		setSpriteCheckFunction0(newSpr,zakoBulletReset);
		setSpriteCheckFunction1(newSpr,zakoBulletReset);
		setSpriteLayer(newSpr,4);
		r=random(360);
		setSpriteVelocity(newSpr,AD2XY(-r,1));
		sprite[newSpr].vx-=scrollSpeed;
		sprite[newSpr].var[5]=31;
	}
	if (cspr.var[3]==0&&!random(40)) {
		cspr.vy=-I2FF(random(7));
		cspr.var[3]=1;

	}
	if (cspr.vy>0x020000) cspr.vy=0x20000;
}
void zako4rCrush()
{
	if (p1Barrier>0&&CRUSH(p1BarrierSpr,1,0)) {
		resetSprite(curSpr);
		p1Barrier-=100;
	}
	if (p2Barrier>0&&CRUSH(p2BarrierSpr,1,0)) {
		resetSprite(curSpr);
		p2Barrier-=100;
	}
	if (CRUSH(P1_SPR,1,2)) {
		attackZako(curSpr,10);
		dieP1();
	}
	if (CRUSH(P2_SPR,1,2)) {
		attackZako(curSpr,10);
		dieP2();
	}
}

void setZako4ra(int x,int y,int hp)
{
	byte newSpr;

	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO4_SLOT,I2FF(SCREEN_X(x)),I2FF(SCREEN_Y(y)),0,3,0,G_NAY);
	setSpriteMoveFunction(newSpr,zako4rMove);
	setSpriteCrushFunction(newSpr,zako4rCrush);
	setSpriteCheckFunction0(newSpr,zako4rCheck0);
	setSpriteCheckFunction2(newSpr,zakoCheck2);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=-scrollSpeed;
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[1]=2;
	sprite[newSpr].var[2]=100;
	sprite[newSpr].var[5]=24;
}

void setZako4rb(int x,int y,int hp)
{
	byte newSpr;

	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO4_SLOT,I2FF(SCREEN_X(x)),I2FF(SCREEN_Y(y)),0,3,0,G_NAY);
	setSpriteMoveFunction(newSpr,zako4rMove);
	setSpriteCrushFunction(newSpr,zako4rCrush);
	setSpriteCheckFunction0(newSpr,zako4rCheck0);
	setSpriteCheckFunction2(newSpr,zakoCheck2);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=-(scrollSpeed<<1);
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[1]=2;
	sprite[newSpr].var[2]=100;
	sprite[newSpr].var[5]=24;
}


void zako5Move()
{
	byte newSpr;
	int r;

	if (!random(100)) {
		newSpr=setSprite(NEW_SPR(EFFECT_SPR),ETC_SLOT,cspr.x,cspr.y,cspr.flip,1,0,G_SCR_OUT);
		setSpriteCrushFunction(newSpr,zakoBulletCrush);
		setSpriteCheckFunction2(newSpr,zakoBulletReset);
		setSpriteCheckFunction0(newSpr,zakoBulletReset);
		setSpriteCheckFunction1(newSpr,zakoBulletReset);
		r=random(180);
		setSpriteVelocity(newSpr,AD2XY(r,1));
	}
	if (cspr.x<I2FF(-30)) resetSprite(curSpr);
}

void zako5Crush()
{
	if (p1Barrier>0&&CRUSH(p1BarrierSpr,1,0)) {
		resetSprite(curSpr);
		p1Barrier-=30;
	}
	if (p2Barrier>0&&CRUSH(p2BarrierSpr,1,0)) {
		resetSprite(curSpr);
		p2Barrier-=30;
	}
	if (CRUSH(P1_SPR,1,2)) {
		attackZako(curSpr,10);
		dieP1();
	}
	if (CRUSH(P2_SPR,1,2)) {
		attackZako(curSpr,10);
		dieP2();
	}
}

void loadZako5(char* fname)
{
	loadSprite(ZAKO5_SLOT,fname);
}

void setZako5a(int x,int y,int hp)
{
	byte newSpr;

	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO5_SLOT,I2FF(SCREEN_X(x)),I2FF(SCREEN_Y(y)),0,0,0,G_NAY);
	setSpriteMoveFunction(newSpr,zako5Move);
	setSpriteCrushFunction(newSpr,zako5Crush);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=-scrollSpeed;
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[1]=0;
	sprite[newSpr].var[5]=5;
}

void setZako5b(int x,int y,int hp)
{
	byte newSpr;

	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO5_SLOT,I2FF(SCREEN_X(x)),I2FF(SCREEN_Y(y)),0,0,0,G_NAY);
	setSpriteMoveFunction(newSpr,zako5Move);
	setSpriteCrushFunction(newSpr,zako5Crush);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=-scrollSpeed;
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[1]=0;
	sprite[newSpr].var[5]=5;
	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO5_SLOT,I2FF(SCREEN_X(x+16)),I2FF(SCREEN_Y(y)),0,0,0,G_NAY);
	setSpriteMoveFunction(newSpr,zako5Move);
	setSpriteCrushFunction(newSpr,zako5Crush);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=-scrollSpeed;
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[1]=0;
	sprite[newSpr].var[5]=5;
}

void setZako5c(int x,int y,int hp)
{
	byte newSpr;

	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO5_SLOT,I2FF(SCREEN_X(x)),I2FF(SCREEN_Y(y)),0,0,0,G_NAY);
	setSpriteMoveFunction(newSpr,zako5Move);
	setSpriteCrushFunction(newSpr,zako5Crush);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=-scrollSpeed;
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[1]=0;
	sprite[newSpr].var[5]=5;
	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO5_SLOT,I2FF(SCREEN_X(x+16)),I2FF(SCREEN_Y(y)),0,0,0,G_NAY);
	setSpriteMoveFunction(newSpr,zako5Move);
	setSpriteCrushFunction(newSpr,zako5Crush);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=-scrollSpeed;
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[1]=0;
	sprite[newSpr].var[5]=5;
	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO5_SLOT,I2FF(SCREEN_X(x+32)),I2FF(SCREEN_Y(y)),0,0,0,G_NAY);
	setSpriteMoveFunction(newSpr,zako5Move);
	setSpriteCrushFunction(newSpr,zako5Crush);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=-scrollSpeed;
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[1]=0;
	sprite[newSpr].var[5]=5;
}

void setZako5d(int x,int y,int hp)
{
	byte newSpr;

	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO5_SLOT,I2FF(SCREEN_X(x)),I2FF(SCREEN_Y(y)),0,0,0,G_NAY);
	setSpriteMoveFunction(newSpr,zako5Move);
	setSpriteCrushFunction(newSpr,zako5Crush);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=-scrollSpeed;
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[1]=0;
	sprite[newSpr].var[5]=5;
	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO5_SLOT,I2FF(SCREEN_X(x+16)),I2FF(SCREEN_Y(y)),0,0,0,G_NAY);
	setSpriteMoveFunction(newSpr,zako5Move);
	setSpriteCrushFunction(newSpr,zako5Crush);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=-scrollSpeed;
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[1]=0;
	sprite[newSpr].var[5]=5;
	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO5_SLOT,I2FF(SCREEN_X(x+32)),I2FF(SCREEN_Y(y)),0,0,0,G_NAY);
	setSpriteMoveFunction(newSpr,zako5Move);
	setSpriteCrushFunction(newSpr,zako5Crush);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=-scrollSpeed;
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[1]=0;
	sprite[newSpr].var[5]=5;
	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO5_SLOT,I2FF(SCREEN_X(x+48)),I2FF(SCREEN_Y(y)),0,0,0,G_NAY);
	setSpriteMoveFunction(newSpr,zako5Move);
	setSpriteCrushFunction(newSpr,zako5Crush);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].vx=-scrollSpeed;
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[1]=0;
	sprite[newSpr].var[5]=5;
}


// zako2 : flame devil AI functions
/*
void zako2FrameCrush()
{
	byte newSpr;

	if (CRUSH(0,1,2)&&!(sprite[0].aAttrib&A_DEFENCE)){//&&sprite[0].var[1]<ATTACKED) {
		sprite[0].globalAttrib&=0x7fff;
		if (sprite[0].var[2]==SIT)
			setSpriteAction(0,13);
		else
			setSpriteAction(0,12);
		setSpriteFrame(0,0);
		sprite[0].flip=1-cspr.flip;
		sprite[0].var[1]=NO_ATTACK+ATTACKED;
		resetSprite(curSpr);
		explosion1();
		sprite[0].var[0]--;
		if (sprite[0].var[0]<0) {
		   explosion2(sprite[0].x,sprite[0].y);
		   sprite[0].var[0]=0;
		   sayVoice(V_EXPLO2);
		   resetSprite(0);
		}
	}

	if (CRUSH(0,2,1)&&(sprite[0].aAttrib&A_ATTACK)) {
		dust1();
		resetSprite(curSpr);
		score+=100;
	}
}


void zako2Move()
{
	byte newSpr;

	int &attack = cspr.var[1];
	int &shootCounter = cspr.var[2];


	if (cspr.action==4) return;
	if (cspr.action!=2)
		if (sprite[0].x<cspr.x) cspr.flip=LEFT_DIR;
		else cspr.flip=RIGHT_DIR;
	if (abs(FF2I(sprite[0].x-cspr.x))>100&&cspr.action==0)
		setSpriteAction(curSpr,1);
	else {
		if (abs(FF2I(sprite[0].x-cspr.x))<=100&&shootCounter<0)
			setSpriteAction(curSpr,2);
		if (cspr.aAttrib&A_ATTACK) {
			newSpr=setSprite(NEW_SPR(EFFECT_SPR),ZAKO2_SLOT,cspr.x,cspr.y,cspr.flip,3,0,G_NO_NAY|G_SCR_OUT|G_NO_CHAIN);
			setSpriteCrushFunction(newSpr,zako2FrameCrush);
			setSpriteVelocity(newSpr,AD2XY((cspr.flip*200+random(20)-20),3));
			setSpriteLayer(newSpr,4);
			sayVoice(V_BURN1);
			shootCounter=30;
		}
    }
    if (gAttrib&G_EOA) attack=NO_ATTACK;
    shootCounter--;
}

void zako2Crush()
{
    int &hp = cspr.var[0];
    int &attack = cspr.var[1];

	if (CRUSH(0,2,1)&&!(cspr.aAttrib&A_DEFENCE)&&(sprite[0].aAttrib&A_ATTACK)&&(attack!=sprite[0].var[1]+ATTACKED)) {
        CLEAR_EOA;
		if (cspr.action==4) score+=500;
        setSpriteAction(curSpr,4);
        setSpriteFrame(curSpr,0);
        cspr.flip=1-sprite[0].flip;
        if (sprite[0].var[1]!=DASH_ATTACK) {
            setSpriteDelay(0,9);
            setSpriteLayer(curSpr,2);
        }
        else setSpriteLayer(curSpr,4);
        attack=sprite[0].var[1]+ATTACKED;
        sayVoice(V_EXPLO1);
		hp--;
        if (hp<=0) {
			explosion2();
            sayVoice(V_EXPLO3);
            resetSprite(curSpr);
            score+=2000;
            setEventItem();
        }
		else score+=200;
	}
}

void loadZako2()
{
	loadSprite(ZAKO2_SLOT,"zako2.spr");
}

void setZako2(int x,int y,int hp)
{
	byte newSpr;

	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO2_SLOT,I2FF(x),I2FF(y),1,0,0);
	setSpriteMoveFunction(newSpr,zako2Move);
	setSpriteCrushFunction(newSpr,zako2Crush);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[9]=currentEvent;
}

// zako3 : smexy AI functions

void zako3BombCrush()
{
	byte newSpr;

	if (CRUSH(0,1,2)&&!(sprite[0].aAttrib&A_DEFENCE)) {//&&sprite[0].var[1]<ATTACKED) {
		sprite[0].globalAttrib&=0x7fff;
		if (sprite[0].var[2]==SIT)
			setSpriteAction(0,13);
		else
			setSpriteAction(0,12);
		setSpriteFrame(0,0);
		sprite[0].flip=1-cspr.flip;
		sprite[0].var[1]=NO_ATTACK+ATTACKED;
		resetSprite(curSpr);
		blood1();
		sprite[0].var[0]--;
		if (sprite[0].var[0]<0) {
		   explosion2(sprite[0].x,sprite[0].y);
		   sprite[0].var[0]=0;
		   sayVoice(V_EXPLO2);
		   resetSprite(0);
		}
	}

	if (CRUSH(0,2,1)&&(sprite[0].aAttrib&A_ATTACK)&&DIR_SIGN(0)*2!=FF2I(cspr.vx)) {
		cspr.vx=I2FF(DIR_SIGN(0)*2);
		score+=300;
		sayVoice(V_STEEL1);
	}
}

void zako3BombExplosion()
{
	dust1();
	resetSprite(curSpr);
}

void zako3Check0()
{
	int &attack = cspr.var[1];
	int &status = cspr.var[2];
	int &floorFlag = cspr.var[4];
	int &shootCounter = cspr.var[5];

	B_FLOOR;
	floorFlag = FLOOR_EXIST;
	switch (status) {
		case FALL:
		case JUMP:  status=STAND;
					setSpriteAction(curSpr,0);
					attack=NO_ATTACK;
					if (random(4)==0)
						shootCounter=0;
					break;
	}
	cspr.vx/=2;
}

void zako3Move()
{
	int &attack = cspr.var[1];
	int &status = cspr.var[2];
    int &moveFlag = cspr.var[3];
	int &floorFlag = cspr.var[4];
    int &shootCounter = cspr.var[5];
    int &bombCounter = cspr.var[7];

    byte newSpr;
    int distanceX=abs(FF2I(sprite[0].x-cspr.x));
    int distanceY=abs(FF2I(sprite[0].y-cspr.y));

	moveFlag = NO_MOVE;


    if (gAttrib&G_EOA) attack=NO_ATTACK;
    if (cspr.action<=2)
        if (sprite[0].x<cspr.x) cspr.flip=LEFT_DIR;
        else cspr.flip=RIGHT_DIR;
    if (distanceY<10) {
      if (attack==NO_ATTACK&&status!=JUMP&&status!=FALL) {
		if (distanceX>100) {
            setSpriteAction(curSpr,1);
            moveFlag = MOVE;
			status = RUN;
        }
		else if (distanceX<90){
            setSpriteAction(curSpr,2);
            moveFlag = MOVE;
            status = RUN;
            if (random(25)==0&&floorFlag)
              if (sprite[0].var[1]==SIT_ATTACK||sprite[0].var[1]==STAND_ATTACK||sprite[0].var[2]==JUMP||distanceX<=30)
                switch (status) {
                    case RUN:     setSpriteVx(curSpr,-I2FF(CDIR_SIGN*3));
                    case STAND:   setSpriteVy(curSpr,I2FF(-4));
                                  setSpriteAction(curSpr,4);
                                  moveFlag = MOVE;
                                  status = JUMP;
                                  if (random(6)==0) shootCounter = 5;
								  CLEAR_EOA;
                }
        }
      }
      if (distanceX<=100&&shootCounter<0&&attack<ATTACKED) {
        switch (status) {
            case RUN:
			case STAND:  setSpriteAction(curSpr,5);break;
            case JUMP:
			case FALL:   setSpriteAction(curSpr,6);break;
        }
        attack=STAND_ATTACK;
        moveFlag=MOVE;
        CLEAR_EOA;
        shootCounter=random(200)+distanceX;
      }
	  if (cspr.aAttrib&A_ATTACK) {
        bombCounter++;
        newSpr=setSprite(NEW_SPR(EFFECT_SPR),ZAKO3_SLOT,cspr.x,cspr.y,cspr.flip,9,0,G_NO_NAY|G_SCR_OUT);
        setSpriteCrushFunction(newSpr,zako3BombCrush);
		setSpriteCheckFunction0(newSpr,zako3BombExplosion);
        setSpriteCheckFunction1(newSpr,zako3BombExplosion);
		setSpriteCheckFunction2(newSpr,zako3BombExplosion);
        setSpriteVelocity(newSpr,AD2XY((cspr.flip*160+random(20)),3));
        setSpriteLayer(newSpr,4);
      }
    }
    shootCounter--;

    if (floorFlag==NO_FLOOR&&status!=JUMP&&status!=FALL) {setSpriteAction(curSpr,8);status=FALL;}
    else if (moveFlag==NO_MOVE&&attack==NO_ATTACK)
         switch (status) {
             case RUN:   setSpriteAction(curSpr,0);status=STAND;break;
         }
    floorFlag = NO_FLOOR;
}

void zako3Crush()
{
    int &hp = cspr.var[0];
    int &attack = cspr.var[1];
	int &status = cspr.var[2];
    int &shootCounter = cspr.var[5];
	int &comboCounter = cspr.var[6];
    int &bombCounter = cspr.var[7];

    if (CRUSH(0,2,1)&&!(cspr.aAttrib&A_DEFENCE)&&(sprite[0].aAttrib&A_ATTACK)&&(attack!=sprite[0].var[1]+ATTACKED)) {
        CLEAR_EOA;
        if (cspr.action==7) {
            score+=800;
			comboCounter++;
        }
        cspr.flip=1-sprite[0].flip;
        if (sprite[0].var[1]!=DASH_ATTACK) {
            setSpriteDelay(0,9);
			setSpriteLayer(curSpr,2);
        }
        else setSpriteLayer(curSpr,4);
        if (random(3)==0)
            shootCounter=0;
        if (random(3)==0&&(status==STAND||status==RUN)) {
            setSpriteAction(curSpr,3);
            setSpriteFrame(curSpr,0);
            attack=sprite[0].var[1]+ATTACKED;
            sayVoice(V_STEEL1);
        }
        else {
            blood1();
            setSpriteAction(curSpr,7);
            setSpriteFrame(curSpr,0);
			attack=sprite[0].var[1]+ATTACKED;
            sayVoice(V_EXPLO1);
            hp--;
            if (hp<=0) {
                if (comboCounter>=3&&sprite[0].var[1]==JUMP_ATTACK&&bombCounter>=25&&(status==RUN||status==STAND)) {
					setSpriteAction(curSpr,10);
                    setSpriteFrame(curSpr,0);
					attack=sprite[0].var[1]+ATTACKED;
                    sayVoice(V_GIRL2);
                    cspr.globalAttrib=G_NO_CHAIN;
                    score+=10000;
                    setEventItem();
                }
                else {
					sayVoice(V_GIRL1);
                    explosion2();
//                sayVoice(V_EXPLO3);
                    resetSprite(curSpr);
                    score+=2000;
                    setEventItem();
				}
            }
            else score+=200;
        }
    }
}

void loadZako3()
{
    loadSprite(ZAKO3_SLOT,"zako3.spr");
}

void setZako3(int x,int y,int hp)
{
    byte newSpr;

    newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO3_SLOT,I2FF(x),I2FF(y),1,0,0);
    setSpriteMoveFunction(newSpr,zako3Move);
    setSpriteCrushFunction(newSpr,zako3Crush);
	setSpriteCheckFunction0(newSpr,zako3Check0);
    setSpriteLayer(newSpr,2);
	sprite[newSpr].var[0]=hp;
    sprite[newSpr].var[9]=currentEvent;
}

// zako4 : N arms AI functions

void zako4BeamExplosion()
{
    dust1(cspr.x-I2FF(cspr.flip*20-10),cspr.y-I2FF(20),0,4,I2FF(cspr.flip*4-2),I2FF(-2));
    resetSprite(curSpr);
}

void zako4BeamCrush()
{
	byte newSpr;

    if (CRUSH(0,1,2)&&!(sprite[0].aAttrib&A_DEFENCE)) {
        sprite[0].globalAttrib&=0x7fff;
        if (sprite[0].var[2]==SIT)
            setSpriteAction(0,13);
        else
            setSpriteAction(0,12);
        setSpriteFrame(0,0);
        sprite[0].flip=1-cspr.flip;
        sprite[0].var[1]=NO_ATTACK+ATTACKED;
        resetSprite(curSpr);
        explosion1(cspr.x-I2FF(cspr.flip*20-10),cspr.y-I2FF(20),0,4,I2FF(cspr.flip*4-2),I2FF(-2));
        sprite[0].var[0]--;
        if (sprite[0].var[0]<0) {
		   explosion2(sprite[0].x,sprite[0].y);
           sprite[0].var[0]=0;
           sayVoice(V_EXPLO2);
		   resetSprite(0);
        }
	}

    if (CRUSH(0,2,1)&&(sprite[0].aAttrib&A_ATTACK)) {
        dust1();
        resetSprite(curSpr);
        score+=100;
    }
}


void zako4Check0()
{
    int &attack = cspr.var[1];
    int &status = cspr.var[2];
    int &floorFlag = cspr.var[4];
	int &shootCounter = cspr.var[5];

    B_FLOOR;
    floorFlag = FLOOR_EXIST;
    switch (status) {
        case FALL:
                    setQuake(20,3);
                    status=STAND;
                    setSpriteAction(curSpr,0);
                    attack=NO_ATTACK;
                    if (random(4)==0)
                        shootCounter=0;
                    break;
    }
    cspr.vx/=2;
}
void zako4Move()
{
    int &attack = cspr.var[1];
	int &status = cspr.var[2];
    int &moveFlag = cspr.var[3];
    int &floorFlag = cspr.var[4];
    int &shootCounter = cspr.var[5];

    byte newSpr;
    int distanceX=abs(FF2I(sprite[0].x-cspr.x));

    moveFlag = NO_MOVE;

    if (gAttrib&G_EOA) attack=NO_ATTACK;
    if (cspr.action<=2)
        if (sprite[0].x<cspr.x) cspr.flip=LEFT_DIR;
        else cspr.flip=RIGHT_DIR;
    if (attack==NO_ATTACK&&status!=FALL) {
        if (distanceX>40) {
			setSpriteAction(curSpr,1);
            moveFlag = MOVE;
            status = RUN;
        }
        else if (distanceX<35){
            setSpriteAction(curSpr,2);
            moveFlag = MOVE;
            status = RUN;
        }
    }


    if (distanceX<=120&&shootCounter<0&&attack<ATTACKED) {
        switch (status) {
            case RUN:
			case STAND:  setSpriteAction(curSpr,5);break;
		}
        attack=STAND_ATTACK;
		moveFlag=MOVE;
        CLEAR_EOA;
        shootCounter=random(10)+distanceX;
    }
    if (distanceX<=60&&attack<ATTACKED) {
        switch (status) {
            case RUN:
			case STAND:  setSpriteAction(curSpr,4);break;
        }
        attack=STAND_ATTACK;
        moveFlag=MOVE;
        CLEAR_EOA;
    }
    if (cspr.aAttrib&0x20) {
        newSpr=setSprite(NEW_SPR(EFFECT_SPR),ZAKO4_SLOT,cspr.x,cspr.y,cspr.flip,6,0,G_NO_NAY|G_SCR_OUT);
        setSpriteCrushFunction(newSpr,zako4BeamCrush);
        setSpriteCheckFunction0(newSpr,zako4BeamExplosion);
		setSpriteCheckFunction1(newSpr,zako4BeamExplosion);
        setSpriteCheckFunction2(newSpr,zako4BeamExplosion);
        setSpriteLayer(newSpr,4);
    }
    shootCounter--;

    if (floorFlag==NO_FLOOR&&status!=JUMP&&status!=FALL) {setSpriteAction(curSpr,0);status=FALL;}
    else if (moveFlag==NO_MOVE&&attack==NO_ATTACK)
         switch (status) {
             case RUN:   setSpriteAction(curSpr,0);status=STAND;break;
         }
    floorFlag = NO_FLOOR;
}

void zako4Crush()
{
    int &hp = cspr.var[0];
	int &attack = cspr.var[1];
    int &shootCounter = cspr.var[5];

    if (CRUSH(0,1,2)&&cspr.aAttrib&A_ATTACK&&!(sprite[0].aAttrib&A_DEFENCE)&&sprite[0].var[1]<ATTACKED) {
        sprite[0].globalAttrib&=0x7fff;
        if (sprite[0].var[2]==SIT)
            setSpriteAction(0,13);
		else
            setSpriteAction(0,12);
        setSpriteFrame(0,0);
        sprite[0].flip=1-cspr.flip;
        sprite[0].var[1]=NO_ATTACK+ATTACKED;
        sprite[0].var[0]-=3;
        blood1(sprite[0].x,sprite[0].y,0,4,I2FF(cspr.flip*4-2));
        blood1(sprite[0].x,sprite[0].y,0,4,I2FF(cspr.flip*6-3));
        sayVoice(V_EXPLO2);
        if (sprite[0].var[0]<0) {
           sprite[0].var[0]=0;
		   explosion2(sprite[0].x,sprite[0].y);
           sayVoice(V_EXPLO2);
           resetSprite(0);
        }
    }

    if (CRUSH(0,2,1)&&!(cspr.aAttrib&A_DEFENCE)&&(sprite[0].aAttrib&A_ATTACK)&&(attack!=sprite[0].var[1]+ATTACKED)) {
        CLEAR_EOA;
        if (cspr.action==4) score+=500;
        setSpriteAction(curSpr,3);
        setSpriteFrame(curSpr,0);
        cspr.flip=1-sprite[0].flip;
        if (sprite[0].var[1]!=DASH_ATTACK) {
            setSpriteDelay(0,9);
			setSpriteLayer(curSpr,2);
		}
		else setSpriteLayer(curSpr,4);
        attack=sprite[0].var[1]+ATTACKED;
        sayVoice(V_EXPLO1);
        shootCounter=0;
        hp--;
        if (hp<=0) {
            explosion2();
			sayVoice(V_EXPLO3);
            resetSprite(curSpr);
            score+=5000;
            setEventItem();
        }
        else score+=300;
    }
}

void loadZako4()
{
    loadSprite(ZAKO4_SLOT,"zako4.spr");
}

void setZako4(int x,int y,int hp)
{
    byte newSpr;

    newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO4_SLOT,I2FF(x),I2FF(y),1,0,0);
    setSpriteMoveFunction(newSpr,zako4Move);
    setSpriteCheckFunction0(newSpr,zako4Check0);
    setSpriteCrushFunction(newSpr,zako4Crush);
    setSpriteLayer(newSpr,2);
    sprite[newSpr].var[0]=hp;
    sprite[newSpr].var[9]=currentEvent;
}

// zako5 : ninja AI functions
//
// a w ́
// qA aeӡ ᷶aa iAa eae
// aAi x a bi ea.
// iA᷁ á a a{a ee aq
// bi ea.
// iAa  bi ae ᝡ a
// bi ea.
// a bi ae { aaa  a.
// e a aA aЁ ácA
// bea.
// ១ eA b ỡe wae
// bea.

// ab a ˥
void zako5Check0()
{
    // b e
    int &attack = cspr.var[1];
	int &status = cspr.var[2];
    int &floorFlag = cspr.var[4];
    int &shootCounter = cspr.var[5];

    // ab  Aaa.
    // a gae abA  a gea.
    B_FLOOR;
    // ab  a eA i ia.
    floorFlag = FLOOR_EXIST;
    switch (status) {
        // baa aA abA }ae ba a
        // a ba iea.
		case FALL:
        case JUMP:  status=STAND;
					setSpriteAction(curSpr,1);
					attack=NO_ATTACK;
                    if (random(4)==0)
                        shootCounter=0;
                    break;
    }
    // aib Aa
	cspr.vx/=2;
}

void zako5Move()
{
    // ϩae b eii ea.
    // (awi e i .ae w i.)

    int &attack = cspr.var[1];
    int &status = cspr.var[2];
    int &moveFlag = cspr.var[3];
    int &floorFlag = cspr.var[4];
    int &shootCounter = cspr.var[5];

	// AIA ϩae  ១i  e
    int distanceX=abs(FF2I(sprite[0].x-cspr.x));
    int distanceY=abs(FF2I(sprite[0].y-cspr.y));

    //  A vea a
    moveFlag = NO_MOVE;

    // b {vae  ba aa.
    // attacke a be ATTACKEDa xe t
    // bi hi e ATTACKED+ba ti ea.
    if (gAttrib&G_EOA) attack=NO_ATTACK;

    // wз a
	// e 4巡a we wз aa.
    //  w 4e aȓa.
	if (cspr.action<=4)
        if (sprite[0].x<cspr.x) cspr.flip=LEFT_DIR;
        else cspr.flip=RIGHT_DIR;

    // qA aeӡ ᷶A Ёa.
	if (cspr.action==0) {
       // b a eae b aA iea.
       if (distanceX<80&&distanceY<20) setSpriteAction(curSpr,2);
          // e 2e baA ae ba. 1a A
       moveFlag = MOVE;
       status = STAND;
       CLEAR_EOA;
    }
    // b a
    // iA Y១a á w vi(a AA)e
    //  gea.
    else if (cspr.action!=2&&!(sprite[0].var[2]!=JUMP&&distanceY>30)) {
      // aa ba a a b a  gi
      // i ea.
      if (attack==NO_ATTACK&&status!=JUMP&&status!=FALL) {
		  // ១a e |a a.
          if (distanceX>90) {
              setSpriteAction(curSpr,3);
              moveFlag = MOVE;
              status = RUN;
              // e ai i a
              // e iA ab aa ae aea.
              // (a gae aa Ea.)
              if ((random(70)==0||distanceY>10)&&floorFlag)
                // w᷁ ea a awaa iAa b aea.
				if ((sprite[0].var[1]==SIT_ATTACK||sprite[0].var[1]==STAND_ATTACK||sprite[0].var[2]==JUMP)||distanceY>10||random(2)==0) {
                      // aA a  iae wa
					  // be wA, aAe a 2/3 ea.
                      // a, ae i ϩӡ aaA aa
                      //   e wa ụa.
					  if (random(3)!=0)
                          setSpriteVx(curSpr,I2FF(CDIR_SIGN*4));
                      if (random(2)==0) shootCounter = 0;
                      setSpriteVy(curSpr,I2FF(-random(5)-4));
					  setSpriteAction(curSpr,6);
                      moveFlag = MOVE;
                      status = JUMP;
                      // aae bi iA e aa
                      CLEAR_EOA;
                }
          }
          // aȓ
          else if (distanceX<80){
            setSpriteAction(curSpr,4);
            moveFlag = MOVE;
            status = RUN;
            // a
            if ((random(25)==0||distanceY>10)&&floorFlag)
              if ((sprite[0].var[1]==SIT_ATTACK||sprite[0].var[1]==STAND_ATTACK||sprite[0].var[2]==JUMP||distanceX<=30)||distanceY>10) {
                  setSpriteVx(curSpr,-I2FF(CDIR_SIGN*3));
				  setSpriteVy(curSpr,I2FF(-random(5)-4));
                  setSpriteAction(curSpr,6);
                  moveFlag = MOVE;
                  status = JUMP;
                  if (random(2)==0) shootCounter = 5;
                  CLEAR_EOA;
              }
          }
      }
	  // bi ae a.
      // shootCountere b i aaeA
	  // ១a aae aq b i aea.

      if (distanceX<=100&&shootCounter<0&&attack<ATTACKED) {
        switch (status) {
			case RUN:
            case STAND:
            case JUMP:
			case FALL:   setSpriteAction(curSpr,5);break;
        }
        attack=STAND_ATTACK;
        moveFlag=MOVE;
        // EOAi   gae e   gaa
        //  bi bie  iea.
        CLEAR_EOA;
        shootCounter=random(100)+distanceX;
      }
      // b a q
      shootCounter--;

      //  ba ae  ១a.
      // ab  wȁa a ba aae baea aa.
      if (floorFlag==NO_FLOOR&&status!=JUMP&&status!=FALL) {setSpriteAction(curSpr,9);status=FALL;}
      //   b aae aA aa.
      else if (moveFlag==NO_MOVE&&attack==NO_ATTACK)
		 switch (status) {
             case RUN:   setSpriteAction(curSpr,1);status=STAND;break;
         }
    }

    // ab ai Ё eA ab a A˷ea.
    // (ae check0qA a A˷Ёa.)
    floorFlag = NO_FLOOR;
}

void zako5Crush()
{
    // b e
    int &hp = cspr.var[0];
    int &attack = cspr.var[1];
	int &status = cspr.var[2];
    int &moveFlag = cspr.var[3];
	int &shootCounter = cspr.var[5];

    // iAi áe wa.
    if (CRUSH(0,1,2)&&cspr.aAttrib&A_ATTACK&&!(sprite[0].aAttrib&A_DEFENCE)&&sprite[0].var[1]<ATTACKED) {
    //  CRUSH :  1e b 2e ab ᷡa.
    //  cspr.aAttribe xedexeA ae a. 0x80
    //  iAa ab ae abi aea.
    //  a e {e we aba xea.
    //   e ee b AA Ea.

        // iA᷁ EOAi i ea.
        sprite[0].globalAttrib&=0x7fff;
        // fa ae fe ab
        // aA we  ab
        if (sprite[0].var[2]==SIT)
            setSpriteAction(0,13);
        else
            setSpriteAction(0,12);
		// b A 
        // a we bi waA a Ё
        // bA ava.
        // setSpriteDelay(curSpr,9);

        // ᕡ Ae  {e eA a.
        // abA abi hie
		// setSpriteActionae aA 0a A˷
        // A gaa aq w ϩa
		setSpriteFrame(0,0);
        // iA᷁ wзi b he a a.
        sprite[0].flip=1-cspr.flip;
        // iA b eA b hvqi A˷ea.
        // b Ae NO_ATTACKa Ё waa.
        // ⷡ ei awi a aa...
		// ei eae a ab e {e
		// bA  waeA e ei Ёi a.
        sprite[0].var[1]=NO_ATTACK+ATTACKED;
        // HPq
        sprite[0].var[0]--;

        // ba
        // ϡ ዡ
        blood1(sprite[0].x,sprite[0].y,0,4,I2FF(cspr.flip*4-2));
        blood1(sprite[0].x,sprite[0].y,0,4,I2FF(cspr.flip*6-3));
        // aq
        sayVoice(V_EXPLO1);
        // HPa ve a
        // ỡe ᴡ.
        if (sprite[0].var[0]<0) {
           sprite[0].var[0]=0;
           explosion2(sprite[0].x,sprite[0].y);
           sayVoice(V_EXPLO2);
           resetSprite(0);
        }
	}

    // iA᷁ bi he w
    if (CRUSH(0,2,1)&&!(cspr.aAttrib&A_DEFENCE)&&(sprite[0].aAttrib&A_ATTACK)&&(attack!=sprite[0].var[1]+ATTACKED)) {
        // aš EOA i
        CLEAR_EOA;
		// e a 
        // ab eA  xae 
		if (cspr.action==8||cspr.action==7) score+=500;
        // 3店 ee  ai ae wea.
        // wi i  i a.
        if (random(3)==0) {
            setSpriteAction(curSpr,8);
            // e 8e ᝡ e e 
            //  wȁa  wae A
			// a iA x gea.
            setSpriteVx(curSpr,-I2FF(CDIR_SIGN*3));
            setSpriteVy(curSpr,I2FF(-7));
            moveFlag = MOVE;
            status = JUMP;
        }
        else setSpriteAction(curSpr,7);
        setSpriteFrame(curSpr,0);
        cspr.flip=1-sprite[0].flip;
        //  be b Aa a.
		// ΁b a a ia a 
        if (sprite[0].var[1]!=DASH_ATTACK) {
            setSpriteDelay(0,9);
            setSpriteLayer(curSpr,2);
        }
        //  be ⷁ A iAa aaa
        // aa Ai ea.
        else setSpriteLayer(curSpr,4);
        // ⷁ b eA iA᷁ b ai ea.
        attack=sprite[0].var[1]+ATTACKED;
		sayVoice(V_EXPLO1);
        shootCounter=0;
        hp--;
        if (hp<=0) {
            explosion2();
			sayVoice(V_EXPLO3);
            resetSprite(curSpr);
			score+=5000;
            setEventItem();
        }
        else score+=300;
    }
}

// a q
void loadZako5()
{
	loadSprite(ZAKO5_SLOT,"zako5.spr");
}

// A˷ q
// aa intw A aa.
void setZako5(int x,int y,int hp)
{
	byte newSpr;

	newSpr=setSprite(NEW_SPR(ZAKO_SPR),ZAKO5_SLOT,I2FF(x),I2FF(y),1,0,0);
	setSpriteMoveFunction(newSpr,zako5Move);
	setSpriteCrushFunction(newSpr,zako5Crush);
	setSpriteCheckFunction0(newSpr,zako5Check0);
	setSpriteLayer(newSpr,2);
	sprite[newSpr].var[0]=hp;
	sprite[newSpr].var[9]=currentEvent;
}

*/

void (*event[256])(int,int,int)={
		setZako1a,               //0
		setZako1b,
		setZako1c,
		setZako2a,
		setZako2b,
		setZako2c,
		setZako3a,
		setZako3b,
		setZako4a,
		setZako4b,
		setZako4ra,
		setZako4rb,
		setZako5a,
		setZako5b,
		setZako5c,
		setZako5d,
		NULL,           //0x10
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,           //0x20
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,           //0x30
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,           //0x40
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,           //0x50
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,                   //0x60
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,                   //0x70
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,                   //0x80
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,                   //0x90
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,           //0xa0
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,                   //0xb0
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,                   //0xc0
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,                   //0xd0
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,                   //0xe0
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,                   //0xf0
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		areaEvent,
		sayVoiceEvent,
		playMusicEvent,
		setQuakeEvent,
		guideMoveEvent,
		scrollSpeedEvent,
		starOffEvent,
		starOnEvent,
		darkenEvent,
		brightenEvent,
};
