program five_in_a_row;
{ Five in a row automatic player, (c) 1993 by
   * MAK-TRAXON's Prophet
   * The last BIWUND Mammaltz
   * Georges-Richard B.           }

uses crt;

const
  gsize : byte = 19;
  gsizem: byte = 18;
  basex = 35;
  basey = 5;
  ncolors = 5;
  coeffs : record
             c_mk_open_4,
             c_mk_open_3,
             c_mk_blkd_4,
             c_blk_open_3,
             c_blk_open_2,
             c_mk_open_2,
             c_mk_blkd_3,
             c_blk_blkd_3,
             c_blk_open_1 : byte;
           end =
           ( c_mk_open_4 : 18;
             c_mk_open_3 : 38;
             c_mk_blkd_4 : 48;
             c_blk_open_3: 11;
             c_blk_open_2: 19;
             c_mk_open_2 : 20;
             c_mk_blkd_3 : 21;
             c_blk_blkd_3: 13;
             c_blk_open_1: 8 );

var
  back,grid,lines,msg,plyr1,plyr2:byte;

type
  stone = record
            col,

            mk_5,
            blk_4,
            mk_blkd_4,
            mk_open_4,
            mk_open_3,
            blk_open_3,
            blk_open_2,
            blk_blkd_3,

            mk_open_2,
            blk_open_1,
            mk_blkd_3,

            tactic : byte;

            value : word;
          end;

var
  maxx,maxy,miny,minx:integer;
  g:array[0..18,0..18] of stone;
  savecrstype:word;
  savemode:byte;
  quit,restart,fast:boolean;
  xwon:byte;
  ywon:byte;
  xst:byte;
  yst:byte;
  color:byte;
  computer:array[1..2] of boolean;
  full:word;
  cheat:boolean;  { is true if Take Back has been used }
  xreplay,yreplay:array[0..400] of byte;

procedure putcolor(b:byte);
begin
  case b of
    0 : begin
          back:=lightgray;
          grid:=white;
          lines:=lightblue;
          msg:=blue;
          plyr1:=black;
          plyr2:=magenta;
        end;
     1 : begin
          back:=blue;
          grid:=lightblue;
          lines:=lightcyan;
          msg:=yellow;
          plyr1:=white;
          plyr2:=lightmagenta;
        end;
     2 : begin
          back:=white;
          grid:=black;
          lines:=black;
          msg:=black;
          plyr1:=black;
          plyr2:=black;
        end;
     3 : begin
          back:=black;
          grid:=lightgray;
          lines:=lightgray;
          msg:=lightgray;
          plyr1:=white;
          plyr2:=white;
        end;
     4 : begin
          back:=black;
          grid:=lightgray;
          lines:=lightgreen;
          msg:=lightblue;
          plyr1:=white;
          plyr2:=white;
        end;
  end;
end;

procedure showplayers;
begin
  gotoxy(3,20);
  textcolor(plyr1);
  write(#9);
  textcolor(msg);
  write(' is ');
  if computer[1] then write('computer.') else write('human.    ');

  gotoxy(3,21);
  textcolor(plyr2);
  write(#254);
  textcolor(msg);
  write(' is ');
  if computer[2] then write('computer.') else write('human.    ');
end;

procedure showscreen;
var
  i:byte;
begin
  textbackground(back);
  clrscr;
  textcolor(lines);
  write(' ');
  for i:=1 to 78 do write('');
  writeln;
  writeln;
  write(' ');
  for i:=1 to 78 do write('');
  gotoxy(25,3);
  write('');
  for i:=4 to 24 do
  begin
    gotoxy(25,i);
    write('');
  end;
  gotoxy(2,25);
  for i:=1 to 78 do write('');
  gotoxy(25,25);
  write('');
  textcolor(msg);
  gotoxy(5,2);
  writeln('۲ Ylitano''s FIVE, by Kalahann Associates & TTE Ltd. ');
  textcolor(grid);
  gotoxy(basex,basey);
  write('Ŀ');
  for i:=1 to 17 do
  begin
    gotoxy(basex,basey+i);
    write('Ĵ');
  end;
  gotoxy(basex,basey+gsizem);
  write('');

  textcolor(msg);
  gotoxy(3,5);
  write('F1  : Change Player ');
  textcolor(plyr1);
  write(#9);

  textcolor(msg);
  gotoxy(3,6);
  write('F2  : Change Player ');
  textcolor(plyr2);
  write(#254);
  textcolor(msg);
  gotoxy(3,7);
  write('F8  : Take Back');
  gotoxy(3,8);
  write('F9  : Fast Demo');

  gotoxy(3,9);
  write('F10 : Change Colors');

  gotoxy(3,11);
  write('spc : Place Stone');
  gotoxy(3,12);
  write(#17#196#217' : Hint');
  gotoxy(3,13);
  write('TAB : New Game');
  gotoxy(3,14);
  write('ESC : Exit to DOS');
  showplayers;
end;

procedure cursoff; assembler;
{ clear cursor }
asm
  mov ah,1
  mov cx,2020h
  int 10h
end;

procedure curson; assembler;
{ display cursor; assumes init has already been called  }
asm
  cmp savemode,7
  mov cx,8b8ch
  jz @mode7
  mov cx,savecrstype
  @mode7:
  int 10h
end;

procedure drawline(pl:byte);
var
  i,xx,yy:byte;
begin
  xx:=xwon;
  yy:=ywon;
  if pl=1 then textcolor(plyr1+blink) else textcolor(plyr2+blink);
  for i:=0 to 4 do
  begin
    gotoxy(basex+xx+xx,basey+yy);
    if pl=2 then write('') else write(#9);
    xx:=(xx+xst);
    yy:=(yy+yst);
  end;
  case readkey of
    #0 : readkey;
    #27 : quit:=true;
  end;
end;

procedure redraw;
var
  i,j:byte;
begin
  showscreen;
  if cheat then
  begin
    textcolor(msg);
    gotoxy(5,17);
    write('CHEAT !');
  end;
  for i:=0 to 18 do for j:=0 to 18 do
  case g[i,j].col of
    1 : begin
          gotoxy(basex+i+i,basey+j);
          textcolor(plyr1);
          write(#9);
        end;
    2 : begin
          gotoxy(basex+i+i,basey+j);
          textcolor(plyr2);
          write('');
        end;
  end;
end;

procedure init;
{ save screen type, cursor shape }
var
  vmode:byte absolute $0000:$0449;
begin
  randomize;
  savemode:=vmode;
  if savemode=7 then color:=2 else color:=0;
  putcolor(color);
  asm
    mov ax,300h
    int 10h
    mov savecrstype,cx
  end;
  computer[1]:=false;
  computer[2]:=true;
end;

procedure draw(x,y,pl:byte);
begin
  gotoxy(basex+x+x-1,basey+y);
  if pl=1 then textcolor(plyr1) else textcolor(plyr2);
  write('(');
  gotoxy(basex+x+x+1,basey+y);
  write(')');
end;

procedure erase(x,y,pl:byte);
begin
  gotoxy(basex+x+x-1,basey+y);
  if x>0 then
  begin
    textcolor(grid);
    write('');
  end else write(' ');
  gotoxy(basex+x+x+1,basey+y);
  if x<gsizem then
  begin
    textcolor(grid);
    write('');
  end else write(' ');
end;

function test(x,y,pl:byte):boolean;
{ Returns TRUE if player PL has won by placing a stone at x,y }

  function testdir(xstep,ystep:byte):boolean;
  var
    xx,yy,i,c:byte;
  begin
    c:=1;
    xx:=x;
    yy:=y;

    while ((xx+xstep) and $ff<gsize) and ((yy+ystep) and $ff<gsize) and
    (g[(xx+xstep) and $ff,(yy+ystep) and $ff].col=pl) do
    { if xx+xstep gets < 0 then it will be $ff so it is also > gsize }
    begin
      inc(xx,xstep);
      inc(yy,ystep);
      inc(c);
    end;

    xx:=x;
    yy:=y;
    xstep:=-xstep;
    ystep:=-ystep;

    while ((xx+xstep) and $ff<gsize) and ((yy+ystep) and $ff<gsize) and
    (g[(xx+xstep) and $ff,(yy+ystep) and $ff].col=pl) do
    { if xx+xstep gets < 0 then it will be $ff so it is also > gsize }
    begin
      inc(xx,xstep);
      inc(yy,ystep);
      inc(c);
    end;
    testdir:=c>=5;
    if c>=5 then
    begin
      xwon:=xx;
      ywon:=yy;
      xst:=-xstep;
      yst:=-ystep;
    end;
  end;

begin
  if testdir(0,1) or testdir(1,0) or testdir(1,1) or testdir(1,$ff) then
  begin
    test:=true;
    erase(x,y,pl);
    if pl=1 then
    begin
      gotoxy(3,20);
      textcolor(plyr1);
      write(#9);
      textcolor(msg);
      write(' has won.     ');
    end else
    begin
      gotoxy(3,21);
      textcolor(plyr2);
      write(#254);
      textcolor(msg);
      write(' has won.     ');
    end;
    drawline(pl);
  end else test:=false;
end;

procedure count(x,y,xstep,ystep,pl:byte; var c,blk,split,blksplit:byte);
var
  xx,yy,spl1,spl2,blksplit1,blksplit2:byte;
begin
  c:=1;
  xx:=x;
  yy:=y;
  blk:=0;
  spl1:=0;
  spl2:=0;
  blksplit1:=0;
  blksplit2:=0;
  while ((xx+xstep) and $ff<gsize) and ((yy+ystep) and $ff<gsize) and
  (g[(xx+xstep) and $ff,(yy+ystep) and $ff].col=pl) do
  { if xx+xstep gets < 0 then it will be $ff so it is also > gsize }
  begin
    inc(xx,xstep);
    inc(yy,ystep);
    inc(c);
  end;

  if ((xx+xstep) and $ff>=gsize) or ((yy+ystep) and $ff>=gsize) or
     (g[(xx+xstep) and $ff,(yy+ystep) and $ff].col<>0) then inc(blk) else
  begin
    inc(xx,xstep);
    inc(yy,ystep);
    while ((xx+xstep) and $ff<gsize) and ((yy+ystep) and $ff<gsize) and
    (g[(xx+xstep) and $ff,(yy+ystep) and $ff].col=pl) do
    { if xx+xstep gets < 0 then it will be $ff so it is also > gsize }
    begin
      inc(xx,xstep);
      inc(yy,ystep);
      inc(spl1);
    end;
    if ((xx+xstep) and $ff>=gsize) or ((yy+ystep) and $ff>=gsize) or
      (g[(xx+xstep) and $ff,(yy+ystep) and $ff].col<>0) then inc(blksplit1);
  end;

  xx:=x;
  yy:=y;
  xstep:=-xstep;
  ystep:=-ystep;

  while ((xx+xstep) and $ff<gsize) and ((yy+ystep) and $ff<gsize) and
  (g[(xx+xstep) and $ff,(yy+ystep) and $ff].col=pl) do
  { if xx+xstep gets < 0 then it will be $ff so it is also > gsize }
  begin
    inc(xx,xstep);
    inc(yy,ystep);
    inc(c);
  end;

  if ((xx+xstep) and $ff>=gsize) or ((yy+ystep) and $ff>=gsize) or
     (g[(xx+xstep) and $ff,(yy+ystep) and $ff].col<>0) then inc(blk) else
  begin
    inc(xx,xstep);
    inc(yy,ystep);
    while ((xx+xstep) and $ff<gsize) and ((yy+ystep) and $ff<gsize) and
    (g[(xx+xstep) and $ff,(yy+ystep) and $ff].col=pl) do
    { if xx+xstep gets < 0 then it will be $ff so it is also > gsize }
    begin
      inc(xx,xstep);
      inc(yy,ystep);
      inc(spl2);
    end;
    if ((xx+xstep) and $ff>=gsize) or ((yy+ystep) and $ff>=gsize) or
      (g[(xx+xstep) and $ff,(yy+ystep) and $ff].col<>0) then inc(blksplit2);
  end;
  if spl1>spl2 then
  begin
    split:=spl1;
    blksplit:=blksplit1;
  end else
  begin
    split:=spl2;
    blksplit:=blksplit2;
  end;
end;

procedure update(x,y,pl:byte);
var
  c,blk,split,blksplit:byte;
begin
  with g[x,y] do
  begin
    mk_5:=0;
    blk_4:=0;
    mk_blkd_4:=0;
    mk_open_4:=0;
    mk_open_3:=0;
    blk_open_3:=0;
    blk_open_2:=0;
    blk_blkd_3:=0;
    mk_open_2:=0;
    blk_open_1:=0;
    mk_blkd_3:=0;
  end;

  count(x,y,1,0,pl,c,blk,split,blksplit);
  case c+split of
    5..19 : if split=0 then inc(g[x,y].mk_5) else
          if (c=4) and (blk=0) then inc(g[x,y].mk_open_4)
            else inc(g[x,y].mk_blkd_4);
    4 : if split=0 then
        begin
          if blk=0 then inc(g[x,y].mk_open_4) else
            if blk=1 then inc(g[x,y].mk_blkd_4);
        end else inc(g[x,y].mk_blkd_4);
    3 : if blk+blksplit=0 then inc(g[x,y].mk_open_3) else
        if blk+blksplit=1 then inc(g[x,y].mk_blkd_3);
    2 : if (blk or split)=0 then inc(g[x,y].mk_open_2);
  end;

  count(x,y,0,1,pl,c,blk,split,blksplit);
  case c+split of
    5..19 : if split=0 then inc(g[x,y].mk_5) else
          if (c=4) and (blk=0) then inc(g[x,y].mk_open_4)
            else inc(g[x,y].mk_blkd_4);
    4 : if split=0 then
        begin
          if blk=0 then inc(g[x,y].mk_open_4) else
            if blk=1 then inc(g[x,y].mk_blkd_4);
        end else inc(g[x,y].mk_blkd_4);
    3 : if blk+blksplit=0 then inc(g[x,y].mk_open_3) else
        if blk+blksplit=1 then inc(g[x,y].mk_blkd_3);
    2 : if (blk or split)=0 then inc(g[x,y].mk_open_2);
  end;

  count(x,y,1,1,pl,c,blk,split,blksplit);
  case c+split of
    5..19 : if split=0 then inc(g[x,y].mk_5) else
          if (c=4) and (blk=0) then inc(g[x,y].mk_open_4)
            else inc(g[x,y].mk_blkd_4);
    4 : if split=0 then
        begin
          if blk=0 then inc(g[x,y].mk_open_4) else
            if blk=1 then inc(g[x,y].mk_blkd_4);
        end else inc(g[x,y].mk_blkd_4);
    3 : if blk+blksplit=0 then inc(g[x,y].mk_open_3) else
        if blk+blksplit=1 then inc(g[x,y].mk_blkd_3);
    2 : if (blk or split)=0 then inc(g[x,y].mk_open_2);
  end;

  count(x,y,$ff,1,pl,c,blk,split,blksplit);
  case c+split of
    5..19 : if split=0 then inc(g[x,y].mk_5) else
          if (c=4) and (blk=0) then inc(g[x,y].mk_open_4)
            else inc(g[x,y].mk_blkd_4);
    4 : if split=0 then
        begin
          if blk=0 then inc(g[x,y].mk_open_4) else
            if blk=1 then inc(g[x,y].mk_blkd_4);
        end else inc(g[x,y].mk_blkd_4);
    3 : if blk+blksplit=0 then inc(g[x,y].mk_open_3) else
        if blk+blksplit=1 then inc(g[x,y].mk_blkd_3);
    2 : if (blk or split)=0 then inc(g[x,y].mk_open_2);
  end;

  count(x,y,0,1,3-pl,c,blk,split,blksplit);
  case c+split of
    5..19 : if split=0 then inc(g[x,y].blk_4) else
          if blk=0 then
            case c of
              4 : inc(g[x,y].blk_open_3);
              3 : inc(g[x,y].blk_open_2,2);
              2 : begin
                    inc(g[x,y].blk_open_1);
                    inc(g[x,y].blk_open_2);
                  end;
            end else
            case c of
              4 : begin
                    inc(g[x,y].blk_open_2);
                    inc(g[x,y].blk_blkd_3);
                  end;
              3 : inc(g[x,y].blk_blkd_3);
            end;
    4 : if split=0 then
        begin
          if blk=0 then inc(g[x,y].blk_open_3) else
            if blk=1 then inc(g[x,y].blk_blkd_3);
        end else
        if blk=0 then
          case c of
            3 : begin
                  inc(g[x,y].blk_blkd_3);
                  inc(g[x,y].blk_open_2);
                end;
            2 : begin
                  inc(g[x,y].blk_open_1);
                  inc(g[x,y].blk_open_2);
                end;
            1 : inc(g[x,y].blk_blkd_3);
          end else if c>1 then inc(g[x,y].blk_blkd_3);
    3 : if blk+blksplit=0 then inc(g[x,y].blk_open_2);
    2 : if split or blk=0 then inc(g[x,y].blk_open_1);
  end;

  count(x,y,1,0,3-pl,c,blk,split,blksplit);
  case c+split of
    5..19 : if split=0 then inc(g[x,y].blk_4) else
          if blk=0 then
            case c of
              4 : inc(g[x,y].blk_open_3);
              3 : inc(g[x,y].blk_open_2,2);
              2 : begin
                    inc(g[x,y].blk_open_1);
                    inc(g[x,y].blk_open_2);
                  end;
            end else
            case c of
              4 : begin
                    inc(g[x,y].blk_open_2);
                    inc(g[x,y].blk_blkd_3);
                  end;
              3 : inc(g[x,y].blk_blkd_3);
            end;
    4 : if split=0 then
        begin
          if blk=0 then inc(g[x,y].blk_open_3) else
            if blk=1 then inc(g[x,y].blk_blkd_3);
        end else
        if blk=0 then
          case c of
            3 : begin
                  inc(g[x,y].blk_blkd_3);
                  inc(g[x,y].blk_open_2);
                end;
            2 : begin
                  inc(g[x,y].blk_open_1);
                  inc(g[x,y].blk_open_2);
                end;
            1 : inc(g[x,y].blk_blkd_3);
          end else if c>1 then inc(g[x,y].blk_blkd_3);
    3 : if blk+blksplit=0 then inc(g[x,y].blk_open_2);
    2 : if split or blk=0 then inc(g[x,y].blk_open_1);
  end;

  count(x,y,1,1,3-pl,c,blk,split,blksplit);
  case c+split of
    5..19 : if split=0 then inc(g[x,y].blk_4) else
          if blk=0 then
            case c of
              4 : inc(g[x,y].blk_open_3);
              3 : inc(g[x,y].blk_open_2,2);
              2 : begin
                    inc(g[x,y].blk_open_1);
                    inc(g[x,y].blk_open_2);
                  end;
            end else
            case c of
              4 : begin
                    inc(g[x,y].blk_open_2);
                    inc(g[x,y].blk_blkd_3);
                  end;
              3 : inc(g[x,y].blk_blkd_3);
            end;
    4 : if split=0 then
        begin
          if blk=0 then inc(g[x,y].blk_open_3) else
            if blk=1 then inc(g[x,y].blk_blkd_3);
        end else
        if blk=0 then
          case c of
            3 : begin
                  inc(g[x,y].blk_blkd_3);
                  inc(g[x,y].blk_open_2);
                end;
            2 : begin
                  inc(g[x,y].blk_open_1);
                  inc(g[x,y].blk_open_2);
                end;
            1 : inc(g[x,y].blk_blkd_3);
          end else if c>1 then inc(g[x,y].blk_blkd_3);
    3 : if blk+blksplit=0 then inc(g[x,y].blk_open_2);
    2 : if split or blk=0 then inc(g[x,y].blk_open_1);
  end;

  count(x,y,1,$ff,3-pl,c,blk,split,blksplit);
  case c+split of
    5..19 : if split=0 then inc(g[x,y].blk_4) else
          if blk=0 then
            case c of
              4 : inc(g[x,y].blk_open_3);
              3 : inc(g[x,y].blk_open_2,2);
              2 : begin
                    inc(g[x,y].blk_open_1);
                    inc(g[x,y].blk_open_2);
                  end;
            end else
            case c of
              4 : begin
                    inc(g[x,y].blk_open_2);
                    inc(g[x,y].blk_blkd_3);
                  end;
              3 : inc(g[x,y].blk_blkd_3);
            end;
    4 : if split=0 then
        begin
          if blk=0 then inc(g[x,y].blk_open_3) else
            if blk=1 then inc(g[x,y].blk_blkd_3);
        end else
        if blk=0 then
          case c of
            3 : begin
                  inc(g[x,y].blk_blkd_3);
                  inc(g[x,y].blk_open_2);
                end;
            2 : begin
                  inc(g[x,y].blk_open_1);
                  inc(g[x,y].blk_open_2);
                end;
            1 : inc(g[x,y].blk_blkd_3);
          end else if c>1 then inc(g[x,y].blk_blkd_3);
    3 : if blk+blksplit=0 then inc(g[x,y].blk_open_2);
    2 : if split or blk=0 then inc(g[x,y].blk_open_1);
  end;

  with g[x,y] do
    with coeffs do
      value:=mk_open_4  * c_mk_open_4  + mk_open_3  * c_mk_open_3  +
             mk_blkd_4  * c_mk_blkd_4  + blk_open_3 * c_blk_open_3 +
             blk_open_2 * c_blk_open_2 + mk_open_2  * c_mk_open_2  +
             mk_blkd_3  * c_mk_blkd_3  + blk_blkd_3 * c_blk_blkd_3 +
             blk_open_1 * c_blk_open_1 ;
end;

procedure decide(var xx,yy,pl:byte);
{ decides for pl where to play }
var
  x,y:byte;
  nb:word;
  mintactic:byte;
  howmany,mxval,which:word;
begin
  if full=0 then
  begin
    xx:=9;
    yy:=9;
    exit;
  end;

  mxval:=0;
  howmany:=0;
  mintactic:=$ff;
  for x:=minx-2 to maxx+2 do
    for y:=miny-2 to maxy+2 do
      if g[x,y].col=0 then
      begin
        update(x,y,pl);
        with g[x,y] do
        begin
          if mk_5<>0 then tactic:=1 else       { make 5 }
          if blk_4<>0 then tactic:=2 else      { block 4 }
          if mk_open_4<>0 then tactic:=3 else  { extend open 3 }
          if mk_blkd_4>1 then tactic:=4 else   { extend double blocked 3 }
          if (mk_blkd_4>0) and (mk_open_3>0) then tactic:=5 else
                                               { extend blocked 3 + 2 }
          if blk_open_3>0 then tactic:=6 else  { block open 3 }
          if blk_blkd_3>1 then tactic:=7 else  { block double blocked 3 }
          if (blk_blkd_3>0) and (blk_open_2>0) then tactic:=8 else
                                               { block blocked 3 + 2 }
          if mk_open_3>1 then tactic:=9 else   { extend double open 2 }
          if blk_open_2>1 then tactic:=10 else { block double open 2 }
          tactic:=$ff;
          if tactic<mintactic then
          begin
            mintactic:=tactic;
            mxval:=value;
            howmany:=1;
          end else
          if tactic=mintactic then
            if value>mxval then
            begin
              mxval:=value;
              howmany:=1;
            end else if value=mxval then inc(howmany);
        end;
      end;
      which:=random(howmany);
      for x:=minx-2 to maxx+2 do
        for y:=miny-2 to maxy+2 do
          if (g[x,y].col=0) and (g[x,y].tactic=mintactic)
                            and (g[x,y].value=mxval) then
            if which=0 then
            begin
              xx:=x;
              yy:=y;
              exit;
            end else dec(which);
end;

procedure erasestone(var x,y:byte);
{ erases last stone and puts x,y=where it was }
begin
  cheat:=true;
  gotoxy(5,17);
  textcolor(msg);
  write('CHEAT !');
  x:=xreplay[full];
  y:=yreplay[full];
  dec(full);
  g[x,y].col:=0;
  gotoxy(basex+x+x,basey+y);
  textcolor(grid);
  if x=0 then
  begin
    if y=0 then write(#218) else
      if y=18 then write(#192) else write(#195)
  end else if x=18 then
  begin
    if y=0 then write(#191) else
      if y=18 then write(#217) else write(#180);
  end else
  begin
    if y=0 then write(#194) else
      if y=18 then write(#193) else write(#197);
  end;
end;

procedure waitkey(var x,y,pl:byte);
begin
  case readkey of
    #27 : quit:=true;
    #9  : restart:=true;
    #0  : case readkey of
           ';' : begin                                 { F1 }
                   computer[1]:=not(computer[1]);
                   showplayers;
                   waitkey(x,y,pl);
                 end;
           '<' : begin                                 { F2 }
                   computer[2]:=not(computer[2]);
                   showplayers;
                   waitkey(x,y,pl);
                 end;
           'D' : begin                                 { F10 }
                   color:=(color+1) mod ncolors;
                   putcolor(color);
                   redraw;
                   waitkey(x,y,pl);
                 end;
           'C' : fast:=not(fast);                      { F9 }
           'B' : if full>0 then
                 begin
                   erase(x,y,pl);
                   erasestone(x,y);
                   pl:=3-pl;
                   x:=xreplay[full];
                   y:=yreplay[full];
                   draw(x,y,pl);
                   waitkey(x,y,pl);
                 end;
          end;
  end;
end;

procedure showtoplay(pl:byte);
begin
  gotoxy(3,23);
  if pl=1 then
  begin
    textcolor(plyr1);
    write(#9);
  end else
  begin
    textcolor(plyr2);
    write(#254);
  end;
  textcolor(msg);
  write(' to play.');
end;

procedure choose(var x,y,pl:byte);
{ moves ( ) until enter or Spc pressed }
var
  done:boolean;
  ch:char;
begin
  showtoplay(pl);

  done:=false;
  draw(x,y,pl);
  repeat
    mem[0:$417]:=mem[0:$417] or $20;
    ch:=readkey;
    if ch=#0 then ch:=readkey;
    case ch of
      'H','8' : if y>0 then
              begin
                erase(x,y,pl);
                dec(y);
                draw(x,y,pl);
              end;
      'P','2' : if y<gsizem then
              begin
                erase(x,y,pl);
                inc(y);
                draw(x,y,pl);
              end;
       'K','4' : if x>0 then
              begin
                erase(x,y,pl);
                dec(x);
                draw(x,y,pl);
              end;
       'L','5' : begin
                   erase(x,y,pl);
                   x:=9;
                   y:=9;
                   draw(x,y,pl);
                 end;
        'M','6' : if x<gsizem then
              begin
                erase(x,y,pl);
                inc(x);
                draw(x,y,pl);
              end;
        'G','7' : if (x>0) and (y>0) then
              begin
                erase(x,y,pl);
                dec(x);
                dec(y);
                draw(x,y,pl);
              end;
        'Q','3' : if (x<gsizem) and (y<gsizem) then
              begin
                erase(x,y,pl);
                inc(x);
                inc(y);
                draw(x,y,pl);
              end;
        'O','1' : if (x>0) and (y<gsizem) then
              begin
                erase(x,y,pl);
                dec(x);
                inc(y);
                draw(x,y,pl);
              end;
        'I','9' : if (x<gsizem) and (y>0) then
              begin
                erase(x,y,pl);
                inc(x);
                dec(y);
                draw(x,y,pl);
              end;
           'D' : begin
                   color:=(color+1) mod ncolors;
                   putcolor(color);
                   redraw;
                   draw(x,y,pl);
                 end;
           'C' : begin
                   erase(x,y,pl);
                   computer[1]:=true;
                   computer[2]:=true;
                   showplayers;
                   decide(x,y,pl);
                   done:=true;
                   fast:=true;
                 end;
           'B' : if (full>=1) and ((not computer[3-pl]) or (full>1)) then
                 begin
                   erase(x,y,pl);
                   erasestone(x,y);
                   pl:=3-pl;
                   draw(x,y,pl);
                   if computer[pl] then
                   begin
                     erase(x,y,pl);
                     erasestone(x,y);
                     pl:=3-pl;
                     draw(x,y,pl);
                   end else showtoplay(pl);
                 end;
           ';' : begin
                   if pl=2 then
                   begin
                     computer[1]:=not(computer[1]);
                     showplayers;
                   end else
                   begin
                     erase(x,y,pl);
                     computer[1]:=not(computer[1]);
                     showplayers;
                     decide(x,y,pl);
                     done:=true;
                   end;
                 end;
           '<' : begin
                   if pl=1 then
                   begin
                     computer[2]:=not(computer[2]);
                     showplayers;
                   end else
                   begin
                     erase(x,y,pl);
                     computer[2]:=not(computer[2]);
                     showplayers;
                     decide(x,y,pl);
                     done:=true;
                   end;
                 end;
           ' ': if g[x,y].col<>0 then
                 begin
                   sound(220);
                   delay(50);
                   nosound;
                 end else
                 begin
                   done:=true;
                   erase(x,y,pl);
                 end;
        #13    : begin
                   erase(x,y,pl);
                   decide(x,y,pl);
                   draw(x,y,pl);
                 end;
        #27    : begin
                   quit:=true;
                   done:=true;
                 end;
        #9     : begin
                   restart:=true;
                   done:=true;
                 end;
    end;
  until done;
  gotoxy(3,23);
  write('           ');
end;

procedure play;
var
  x,y,pl,i,j:byte;
  five:boolean;
  ch:char;
begin
  maxx:=9;
  minx:=9;
  maxy:=9;
  miny:=9;

  fast:=false;
  cheat:=false;
  showscreen;
  x:=9;
  y:=9;
  xreplay[0]:=9;
  yreplay[0]:=9;
  quit:=false;
  restart:=false;
  five:=false;
  full:=0;
  for i:=0 to gsizem do for j:=0 to gsizem do g[i,j].col:=0;
  pl:=1;
  repeat
    if full=gsize*gsize then
    begin
      gotoxy(5,17);
      textcolor(msg);
      write('FULL BOARD !');
      sound(880);
      delay(50);
      nosound;
      restart:=true;
      if readkey=#0 then readkey;
    end else
    begin
      if computer[1] and computer[2] then
      begin
        if full<>0 then draw(x,y,pl);
        if not fast then waitkey(x,y,pl);
        if full<>0 then erase(x,y,pl);
      end;
      if computer[pl] then decide(x,y,pl) else choose(x,y,pl);
      if not (quit or restart) then if pl=1 then
      begin
        textcolor(plyr1);
        gotoxy(basex+x+x,basey+y);
        write(#9);
        g[x,y].col:=1;
        five:=test(x,y,pl);
        if x>maxx then
          if x<=gsizem-2 then maxx:=x else maxx:=gsizem-2;
        if x<minx then
          if x>=2 then minx:=x else minx:=2;
        if y>maxy then
          if y<=gsizem-2 then maxy:=y else maxy:=gsizem-2;
        if y<miny then
          if y>=2 then miny:=y else miny:=2;
        pl:=2;
        inc(full);
        xreplay[full]:=x;
        yreplay[full]:=y;
      end else
      begin
        textcolor(plyr2);
        gotoxy(basex+x+x,basey+y);
        write('');
        g[x,y].col:=2;
        five:=test(x,y,pl);
        if x>maxx then
          if x<=gsizem-2 then maxx:=x else maxx:=gsizem-2;
        if x<minx then
          if x>=2 then minx:=x else minx:=2;
        if y>maxy then
          if y<=gsizem-2 then maxy:=y else maxy:=gsizem-2;
        if y<miny then
          if y>=2 then miny:=y else miny:=2;
        pl:=1;
        inc(full);
        xreplay[full]:=x;
        yreplay[full]:=y;
      end;
      if keypressed then
      begin
        if full<>0 then draw(x,y,pl);
        waitkey(x,y,pl);
        if full<>0 then erase(x,y,pl);
      end;
    end;
  until quit or five or restart;
end;

begin
  init;
  cursoff;
  repeat
    play;
  until quit;
  textcolor(7);
  textbackground(0);
  clrscr;
  writeln;
  writeln('Thank you for playing Ylitano''s FIVE.');
  writeln('(k) 1993 Kalahann Associates & TTE Ltd. All rights reversed.');
  writeln('Serial Number: 453-6524-38M           Version Number: 1.01A');
  writeln;
end.
