
; 
;
;                                     achy
;
; 

Code     SEGMENT
         ASSUME    cs:Code,ds:Code
         ORG       100h

; ------ inicializace videomdu

Start:   mov       ah,0fh
         call      Int10P                   ; poskytnut videomdu
         cmp       al,7
         je        Start1
         mov       byte ptr ds:[SegmVRAM+1],0b8h ; segment videopamti
         cmp       al,2
         je        Start1
         mov       al,3
Start1:  mov       ah,0
         call      Int10P                   ; inicializace videomdu

;; ------ kontrola grafick karty VGA
;
;         mov       ax,1a00h
;         int       10h                      ; dotaz na poet linek na znak
;         cmp       al,1ah                   ; je funkce obsluhovan ?
;         jne       Start103                 ; funkce nen obsluhovan
;         cmp       bl,7                     ; je 7 linek na znak ?
;         je        Start100                 ; je karta OK
;         cmp       bl,8
;         je        Start100                 ; je karta OK
;         cmp       bl,11
;         jb        Start103                 ; nen karta
;         cmp       bl,12
;         ja        Start103                 ; nen karta
;
;; ====== oprava zobrazen VGA na 8 bod na linku
;
;Start100:cli
;
;; ------ pprava registru hodin
;
;         mov       dx,3cch
;         in        al,dx
;         xor       al,4
;         test      al,8+4
;         jnz       Start102
;         mov       bl,al
;
;; ------ pprava registru potu bod
;
;         mov       dl,0c4h
;         mov       al,1
;         out       dx,al
;         jmp       short $+2
;         inc       dx
;         in        al,dx
;         test      al,21h
;         jnz       Start102
;         xor       al,1
;         mov       bh,al
;
;; ------ kontrola registru posunu PANNING
;
;         call      Pan
;         out       dx,al
;         jmp       short $+2
;         inc       dx
;         in        al,dx
;         cmp       al,8
;         jne       Start101
;
;; ------ nastaven registru posunu PANNING
;
;         dec       dx
;         mov       al,0
;         out       dx,al
;
;; ------ nastaven registru potu bod
;
;         mov       al,bh
;         mov       dl,0c5h
;         out       dx,al
;
;; ------ nastaven registru hodin
;
;         mov       al,bl
;         mov       dl,0c2h
;         out       dx,al
;
;; ------ zapnut displeje
;
;Start101:call      Pan
;         mov       al,20h
;         out       dx,al
;Start102:sti

; ------ instalace obsluhy peruen

Start103:mov       ax,2523h
         mov       dx,offset INT23
         int       21h                      ; instalace INT 23h

; ------ zobrazen vodnho textu

         mov       ds:[Zasobnik],sp         ; schova ukazatele zsobnku
Zadej:   mov       sp,ds:[Zasobnik]         ; nvrat ukazatele zsobnku
         call      Clear                    ; vymazn displeje
         mov       si,offset Text1
         mov       dx,6*256 + 32
         call      DispB
         mov       dx,9*256 + 35
         call      DispB
         mov       dx,11*256 + 30
         call      DispB
         mov       dx,13*256 + 34
         call      DispB

; ------ pprava barvy hre

Zadej1:  mov       sp,ds:[Zasobnik]         ; nvrat ukazatele zsobnku
         mov       al,"A"                   ; automat
         cmp       byte ptr ds:[Automat],0  ; je automat ?
         jne       Zadej2                   ; je automat
         mov       al,"B"                   ; bl
         cmp       byte ptr ds:[Hrac],0     ; m hr bl ?
         jne       Zadej2                   ; hr m ble
         mov       al,"C"                   ; ern
Zadej2:  mov       ds:[ColTxt0],al          ; barva hre
         mov       ds:[ColTxt1],al          ; barva hre

; ------ vzva k zadn barvy hre

         mov       si,offset ColTxt         ; text vzvy k zadn barvy
         mov       dx,16*256 + 11
         call      DispB
         dec       dx

; ------ vstup znaku z klvesnice

Zadej3:  call      SetKurz
         call      InpChr                   ; vstup znaku z klvesnice

         call      JumpBX                   ; obsluha podle klvesy

         dw        "B",ZadejB               ; bl
         dw        "C",ZadejC               ; ern
         dw        "A",ZadejA               ; automat
         dw        13,ZadejM                ; ENTER
         dw        27,Konec                 ; ESC

         dw        0,Zadej3

; ------ konec programu ESC

Konec:   ;call      Clear                    ; vymazn displeje
         mov       ah,0fh
         int       10h
         mov       ah,0
         int       10h
         int       20h                      ; konec programu

; ------ volba automatu

ZadejA:  mov       byte ptr ds:[Automat],1  ; pznak automatu
         mov       al,0                     ; hr m ern
         jmp       short ZadejC3

; ------ volba bl barvy

ZadejB:  mov       al,80h                   ; barva hre bl
         jmp       short ZadejC2

; ------ volba ern barvy

ZadejC:  mov       al,0                     ; barva hre ern
ZadejC2: mov       byte ptr ds:[Automat],0  ; zruen pznaku automatu
ZadejC3: mov       ds:[Hrac],al             ; barva hre

; ------ potvrzen star volby ENTER (DX=star pozice kurzoru !!!)

ZadejM0: mov       ds:[ColTxt1],bl          ; zadan znak
ZadejM:  mov       si,offset ColTxt1
         call      DispB                    ; zobrazen text

; ------ pprava k volb obtnosti

         mov       al,ds:[Uroven]           ; rove obtnosti
         add       al,"0"
         mov       ds:[UrovTxt0],al

; ------ zobrazen vzvy k zadn rovn obtnosti

         mov       si,offset UrovTxt        ; text vzvy k zadn rovn
         mov       dx,18*256+10
         call      DispB
         dec       dx

; ------ vstup znaku z klvesnice

ZadejU1: call      SetKurz                  ; nastaven pozice kurzoru
         call      InpChr                   ; vstup znaku z klvesnice
         cmp       bl,13                    ; potvrzen ENTER ?
         je        ZadejU5                  ; potvrzen volby ENTER
         cmp       bl,27                    ; nvrat k pedel volb ?
         jne       ZadejU2                  ; nen ESC nvrat
         jmp       Zadej                    ; nvrat k volb barvy
ZadejU2: sub       bl,"0"
         jbe       ZadejU1                  ; neplatn znak
         cmp       bl,6
         ja        ZadejU1                  ; neplatn znak
         mov       ds:[Uroven],bl           ; zvolen rove

; ------ inicializace achovnice

ZadejU5: call      Clear                    ; vymazn obrazovky
         call      InitPole                 ; inicializace achovnice
         call      Disp                     ; zobrazen achovnice
         mov       word ptr ds:[CitTah],1   ; ta tah
         mov       byte ptr ds:[Radek],1    ; aktivn dek vstupu na displej
         call      KurzOff                  ; vypnut kurzoru

; ------ rozlien typu hry

Hrej:    call      DispTah                  ; zobrazen sla tahu
         test      byte ptr ds:[Hrac],80h   ; m hr bl ?
         jnz       Hrej1                    ; hr m bl  - zan

                                          ;* pota m bl - zan
         call      TahPoc                   ; tah potae
         call      TahHrac                  ; volba tahu hre
         jmp       short Hrej2
                                          ;* hr m bl - zan
Hrej1:   call      TahHrac                  ; volba tahu hre
         call      TahPoc                   ; tah potae

                                          ;* zven tae tah
Hrej2:   inc       word ptr ds:[CitTah]     ; zven tae tah
         jmp       short Hrej               ; dal tah

;; -----------------------------------------------------------------------------
;;        obsluha registru PANNING
;; -----------------------------------------------------------------------------
;
;Pan:     mov       dl,0dah
;         in        al,dx
;         mov       dl,0bah
;         in        al,dx
;         mov       dl,0c0h
;         mov       al,13h
;         ret

; -----------------------------------------------------------------------------
;        obsluha INT 23h
; -----------------------------------------------------------------------------

INT23:   iret

; -----------------------------------------------------------------------------
;        zobrazen textu ASCIIZ - BIOS (DX=souadnice, DS:SI=text)
; -----------------------------------------------------------------------------

DispB    PROC      NEAR

; ------ naten znaku

         mov       ah,7                     ; barva textu
DispB2:  cld
         lodsb
         cmp       al,0                     ; konec ?
         je        DispB8                   ; konec textu

; ------ dic znaky

         cmp       al,1
         jne       DispB3
         xor       ah,8
         jmp       short DispB2
DispB3:  cmp       al,2
         jne       DispB4
         xor       ah,77h
         jmp       short DispB2

; ------ zobrazen znaku

DispB4:  call      DispCh                   ; zobrazen znaku
         inc       dl                       ; zven pozice na displeji
         jmp       short DispB2             ; dal znak

DispB8:  ret

DispB    ENDP

; -----------------------------------------------------------------------------
;        zobrazen znaku AX (pozice DX)
; -----------------------------------------------------------------------------

DispCh   PROC      NEAR

; ------ schova registr

         push      ax
         push      di
         push      es

; ------ vpoet adresy ve videopamti

         push      ax
         mov       al,160                   ; poet bajt na dek
         mul       dh                       ; pepoet dk na bajty
         mov       di,ax                    ; adresa zatku dku
         mov       al,dl
         mov       ah,0
         add       di,ax
         add       di,ax                    ; piten pozice
         pop       ax

; ------ zpis znaku do videopamti

         mov       es,ds:[SegmVRAM]
         cld
         stosw                              ; uloen znaku

; ------ nvrat registr

         pop       es
         pop       di
         pop       ax
         ret

DispCh   ENDP

; -----------------------------------------------------------------------------
;        zobrazen provedenho tahu
; -----------------------------------------------------------------------------

DispMov  PROC      NEAR

         mov       dh,ds:[Radek]            ; dek

         mov       dl,5                     ; pozice
         mov       al,ds:[OldPoz]
         call      DispMv                   ; zobrazen polka

         mov       dl,8                     ; pozice
         mov       al,"-"                   ; oddlova tah
         call      DispChar

         mov       al,ds:[NewPoz]
         mov       dl,10
         call      DispMv

         mov       dl,12
         mov       al," "
         call      DispChar

         mov       dl,13
         mov       al,"X"
         test      byte ptr ds:[OldFig],7fh
         jnz       DispMov3
         mov       al," "
DispMov3:call      DispChar

         mov       dl,15
         mov       al,ds:[Rosad]
         mov       si,offset MalRosTx
         cmp       al,1
         je        DispMov4
         mov       si,offset VelRosTx
         cmp       al,2
         je        DispMov4
         mov       si,offset PxPepTx
         cmp       al,3
         jne       DispMov6
DispMov4:cld
         lodsb
         cmp       al,0
         je        DispMov6
         call      DispChar
         inc       dx
         jmp       short DispMov4
DispMov6:
         ret

DispMov  ENDP

; -----------------------------------------------------------------------------
;        zobrazen polka AL
; -----------------------------------------------------------------------------

DispMv   PROC      NEAR

; ------ vpoet dku a pozice

         mov       cl,10
         mov       ah,0
         div       cl                       ; vpoet dku a pozice

; ------ zobrazen pozice

         xchg      al,ah
         add       al,"a"-1
         call      DispChar

; ------ zobrazen dku

         inc       dx
         xchg      al,ah
         add       al,"1"-2
         call      DispChar
         ret

DispMv   ENDP

; -----------------------------------------------------------------------------
;        zobrazen sla tahu
; -----------------------------------------------------------------------------

DispTah  PROC      NEAR

; ------ schova registr

         push      ax
         push      cx
         push      dx

; ------ vymazn dku

         mov       dh,ds:[Radek]            ; aktivn dek
         call      DispClr                  ; vymazn dku

; ------ zobrazen oddlovac dvojteky

         mov       dl,3                     ; pozice k zobrazen sla tahu
         mov       al,":"
         call      DispChar
         dec       dx

; ------ dekdovn sla

         mov       cx,10
         mov       ax,ds:[CitTah]           ; ta tah
DispTah1:push      dx
         xor       dx,dx
         div       cx                       ; vpoet jedn slice
         xchg      bx,ax
         xchg      ax,dx
         pop       dx
         add       al,"0"                   ; korekce na slici
         call      DispChar                 ; zobrazen znaku
         xchg      ax,bx
         dec       dx                       ; snen pozice
         or        ax,ax                    ; je jet slo ?
         jnz       DispTah1                 ; dekdovn dalho sla

; ------ nvrat registr

         pop       dx
         pop       cx
         pop       ax
         ret

DispTah  ENDP

; -----------------------------------------------------------------------------
;        oddkovn vstupu na konzolu
; -----------------------------------------------------------------------------

DispCR   PROC      NEAR

; ------ schova registr

         push      cx
         push      dx
         push      si
         push      di
         push      es

; ------ zven ukazatele dku

         inc       byte ptr ds:[Radek]      ; zven ukazatele dku
         cmp       byte ptr ds:[Radek],25
         jb        DispCR9                  ; dek je OK
         dec       byte ptr ds:[Radek]      ; nvrat sla dku

; ------ rolovn obrazovky

         cld
         push      ds
         mov       es,ds:[SegmVRAM]
         push      es
         pop       ds
         mov       di,160-20*2 + 160
         mov       dx,23                    ; poet dk
DispCR2: mov       cx,20
         mov       si,di
         add       si,160
         rep       movsw
         add       di,160-20*2
         dec       dx
         jnz       DispCR2
         pop       ds

; ------ vymazn novho dku

DispCR9: mov       dh,ds:[Radek]            ; aktuln dek
         call      DispClr                  ; vymazn dku

; ------ nvrat registr

         pop       es
         pop       di
         pop       si
         pop       dx
         pop       cx
         ret

DispCR   ENDP

; -----------------------------------------------------------------------------
;        vstup znaku AL do vstupn konzoly (souadnice DX)
; -----------------------------------------------------------------------------

DispChar PROC      NEAR

; ------ schova registr

         push      ax
         push      di
         push      es

; ------ uren adresy k uloen textu

         push      ax
         mov       al,160                   ; poet bajt na dek
         mul       dh                       ; pepoet dk na pozice
         mov       di,ax                    ; adresa dku
         mov       al,dl                    ; pozice
         add       al,80-20
         mov       ah,0
         add       di,ax
         add       di,ax                    ; adresa
         pop       ax

; ------ uloen znaku

         mov       es,ds:[SegmVRAM]
         cld
         mov       ah,7
         cmp       dl,4
         jb        DispChr2
         mov       ah,0fh
DispChr2:stosw                              ; uloen znaku

; ------ nvrat registr

         pop       es
         pop       di
         pop       ax
         ret

DispChar ENDP

; -----------------------------------------------------------------------------
;        vymazn dku DH konzoly
; -----------------------------------------------------------------------------

DispClr  PROC      NEAR

         push      ax
         push      dx
         mov       al,32                    ; znak mezery
         mov       dl,0
DispClr1:call      DispChar                 ; vymazn znaku
         inc       dx
         cmp       dl,20
         jb        DispClr1
         pop       dx
         pop       ax
         ret

DispClr  ENDP

; -----------------------------------------------------------------------------
;        zobrazen hlen DS:SI (prvn bajt = dlka)
; -----------------------------------------------------------------------------

DispHlas PROC      NEAR

; ------ schova registr

         push      ax
         push      cx
         push      si
         push      di
         push      es

; ------ pprava registr

         cld
         mov       es,ds:[SegmVRAM]         ; segment videopamti
         lodsb                              ; dlka textu
         mov       bl,al                    ; dlka textu
         mov       cx,20                    ; ka dku
         sub       cl,bl                    ; zbytek na okraje
         shr       cl,1                     ; okraje / 2
         mov       bh,cl                    ; prav okraj
         adc       bh,0                     ; lich mezera

; ------ zobrazen lev mezery

         mov       di,160-2*20              ; poten adresa
         mov       ax,7020h                 ; znak mezery
         rep       stosw                    ; zobrazen lev mezery

; ------ zobrazen textu

         mov       cl,bl                    ; dlka textu
DispHls1:lodsb
         stosw
         loop      DispHls1

; ------ zobrazen prav mezery

         mov       cl,bh                    ; prav mezera
         mov       al," "                   ; znak mezery
         rep       stosw                    ; zobrazen prav mezery

; ------ nvrat registr

         pop       es
         pop       di
         pop       si
         pop       cx
         pop       ax
         ret

DispHlas ENDP

;==========================================================================
;        uloen nov definice do zsobnku tah
;==========================================================================
  
l_0000   PROC      NEAR

         mov       dx,ds:[d_09CC]           ; ukazatel v zsobnku tah
         mov       bx,offset d_09AA         ; konec zsobnku tah
         cmp       dx,bx                    ; je zsobnk ji pln ?
         jae       l_0046                   ; zsobnk je ji pln

         mov       bx,ds:[d_09CA]
         mov       ds:[d_09CA],dx
         mov       ds:[bx],dx
         test      byte ptr ds:[FigTst1],8
         jnz       l_0022
         or        byte ptr ds:[CilFig1],10h

l_0022:  mov       bx,dx                    ; ukazatel v zsobnku tah
         mov       word ptr ds:[bx],0       ; bodovn tahu
         mov       al,ds:[d_09B2]
         mov       ds:[bx+2],al
         mov       al,ds:[PozTah]           ; pozice pi pokusu o tah
         mov       ds:[bx+3],al
         mov       al,ds:[CilFig1]           ; pvodn obsah novho polka
         mov       ds:[bx+4],al
         mov       byte ptr ds:[bx+5],0
         add       bx,6                     ; zven ukazatele v zsobnku
         mov       ds:[d_09CC],bx           ; ukazatel v zsobnku tah
         ret

l_0046:  mov       word ptr ds:[bx],0       ; ohodnocen - dn bod
         ret

l_0000   ENDP
  
;==========================================================================
;        uloen definice tahu
;==========================================================================
  
l_004C   PROC      NEAR

         xor       byte ptr ds:[Protihr],80h
         jns       l_0057
         dec       word ptr ds:[CitTah]     ; ta tah
l_0057:  dec       word ptr ds:[d_09C6]
         dec       byte ptr ds:[d_09D6]     ; ta hloubky (rove hry)
         mov       bx,ds:[d_09C2]
         sub       bx,4
         mov       ds:[d_09C2],bx
         mov       ax,ds:[bx+2]
         mov       ds:[d_09CC],ax           ; ukazatel v zsobnku tah
         mov       ax,ds:[bx]
         mov       ds:[d_09C4],ax           ; ukazatel v bufferu tah
         call      l_0EC2                   ; nvrat tahu z bufferu tah
         ret

l_004C   ENDP
  
;==========================================================================
;        jeden posun
; -----------------------------------------------------------------------------
; VSTUP: DH=pznaky
;              bit 0 a bit 3: poet krok
;              bit 4:
;              bit 5: 1=nalezena soupeova figurka
;              bit 6: 1=nalezena vlastn figurka
;              bit 7: 1=skok na dmu
;        CL=smr pohybu (prustek pozice od souasn)
; -----------------------------------------------------------------------------

l_007A   PROC      NEAR

         push      cx
         push      dx
         push      di

         mov       al,byte ptr ds:[d_09C0]
         cmp       al,0
         je        l_00AE

         mov       bl,cl                    ; smr pohybu (prustek pozice)
         mov       dl,0
         mov       cl,al
         mov       ch,0
         mov       al,ds:[PozTah]           ; pozice pi pokusu o tah
         mov       di,offset d_0165         ; tabulka pozic figurek

         cld
l_0094:  repne     scasb                    ; nalezen pozice figurky
         jnz       l_00AE                   ; pozice nenalezena
         cmp       dl,0
         jne       l_00F3

         mov       dl,1
         mov       bh,ds:[di+9]             ; smr pohybu
         cmp       bh,bl                    ; je to stejn smr ?
         je        l_0094                   ; je stejn smr - dal
         neg       bh                       ; obrcen smr
         cmp       bh,bl                    ; je obrcen smr ?
         je        l_0094                   ; je obrcen smr - dal
         jmp       short l_00F3             ; konec

; ------ adresa tabulky pot figurek hre

l_00AE:  mov       di,word ptr ds:[CilFig2] ; clov figurka skoku (bez barvy)
         mov       bx,offset PocFigC        ; tabulka ernho hre
         mov       ah,0
         mov       al,ds:[CilFig1]          ; pvodn figurka na polku
         test      al,80h                   ; byla to bl figurka ?
         jz        l_00C3                   ; byla to ern figurka
         mov       bx,offset PocFigB        ; tabulka blho hre

; ------ skok na dmu

l_00C3:  and       al,7                     ; figurka
         test      dh,80h                   ; skok na dmu ?
         jz        l_00CC                   ; nen dma
         mov       al,5                     ; bude dma

; ------ zven celkovho potu figurek

l_00CC:  inc       byte ptr ds:[bx]         ; zven celkovho potu figurek

; ------ star body figurky

         add       bx,ax
         add       bx,ax
         mov       ax,ds:[bx]               ; stav figurek

; ------ rozlien, zda bylo ji njak bodovn

         cmp       al,0                     ; bylo ji prvn bodovn ?
         je        l_00EB                   ; je to prvn bodovn
         cmp       ah,0                     ; bylo druh bodovn
         je        l_00E4                   ; je to druh bodovn

; ------ tet bodovn figurky

         inc       bx
         inc       bx
         mov       ax,ds:[bx]               ; bodovn dalho typu figurek
         jmp       short l_00EB

; ------ druh bodovn figurky

l_00E4:  mov       ah,ds:[di+TabBod]        ; bodovn
         jmp       short l_00F1

; ------ prvn (a tet) bodovn figurky

l_00EB:  mov       ah,al                    ; nulovn registru AH
         mov       al,ds:[di+TabBod]        ; bodovn
l_00F1:  mov       ds:[bx],ax               ; schova bodovn

; ------ nvrat registr

l_00F3:  pop       di
         pop       dx
         pop       cx
         ret       

l_007A   ENDP
  
; -----------------------------------------------------------------------------
;        test okol figurky (bodovn pozice figurky)
; -----------------------------------------------------------------------------
; Testuje se ve smrech ikmo, kolmo a konm (krom kon se krokuje do konce)
; -----------------------------------------------------------------------------
;
TestOkol PROC      NEAR

; ------ pprava registr

         push      cx
         mov       ch,16                    ; ta smr
         xor       di,di                    ; ukazatel smr

; ------ test jednoho smru

TestOk1: mov       cl,ds:[di+TabSmer]       ; smr pohybu figurky
         mov       dh,0                     ; ta krok v jednom smru
         mov       al,ds:[PozTst]           ; testovan pozice
         mov       ds:[PozTah],al           ; pozice pi pokusu o tah

; ------ test vech krok v jednom smru (nalezen njak prvn figurky)

TestOk2: inc       dh                       ; ta krok v danm smru
         call      PokTah                   ; pokus o tah danm smrem CL
         cmp       al,1                     ; je skok na soupee ?
         je        TestOk5                  ; je skok na soupee
         cmp       al,2                     ; je skok na vlastn ?
         je        TestOk6                  ; je skok na vlastn
         cmp       al,0                     ; skok na przdn polko ?
         jne       TestOk3                  ; je skok mimo achovnici
         cmp       ch,9                     ; jsou tahy konm ?
         jae       TestOk2                  ; nen k - dal krok ve smru

; ------ konec jednoho smru - dal smr

TestOk3: inc       di                       ; zven adresy v tabulce smr
         dec       ch                       ; ta smr
         jnz       TestOk1                  ; test dalho smru
         mov       al,0                     ; pznak
TestOk4: pop       cx
         ret       

; ------ nalezen soupe

TestOk5: test      dh,40h                   ; byla ji nalezena vlastn ?
         jnz       TestOk3                  ; byla nalezena vlastn
         or        dh,20h                   ; pznak nalezen soupee
         jmp       short TestOk7            ; test povolench tah na soupee

; ------ nalezen vlastn

TestOk6: test      dh,20h                   ; byl ji nalezen soupe ?
         jnz       TestOk3                  ; byl ji nalezen soupe
         or        dh,40h                   ; pznak nalezen vlastnho

; ------ test, zda je skok na kon

TestOk7: mov       dl,ds:[CilFig2]          ; ruen figurka
         cmp       ch,9                     ; jsou tahy konm ?
         jb        TestOkC                  ; je tah konm - test, zda je k

; ------ kontrola skoku na dmu - libovoln pm smr o libovoln poet krok

         cmp       dl,5                     ; je dma ?
         jne       TestOk8                  ; nen dma
         or        dh,80h                   ; pznak, e je skok na dmu
         jmp       short TestOkD            ; smr je OK

; ------ kontrola tahu krle - 1 krok libovolnm smrem

TestOk8: mov       al,dh                    ; ta krok
         and       al,0Fh                   ; poet krok v danm smru
         cmp       al,1                     ; je 1 krok ?
         jne       TestOk9                  ; je vce krok
         cmp       dl,6                     ; je krl ?
         je        TestOkD                  ; je krl - OK

; ------ kontrola tahu stelce - ikm smr

TestOk9: cmp       ch,0Dh                   ; jsou ikm smry ?
         jb        TestOkB                  ; jsou kolm smry
         cmp       dl,3                     ; je stelec ?
         je        TestOkD                  ; je stelec - OK

; ------ jinak mus bt pk

         mov       al,dh                    ; ta krok
         and       al,0Fh                   ; poet krok
         cmp       al,1                     ; je 1 krok ?
         jne       TestOk3                  ; nen 1 krok
         cmp       dl,1                     ; je pk ?
         jne       TestOk3                  ; nen pk

; ------ kontrola tahu pka

         test      byte ptr ds:[CilFig1],80h ; je bl pk ?
         jz        TestOkA                  ; je ern pk
         cmp       ch,0Fh                   ; thne bl pk nahoru ?
         jb        TestOk3                  ; bl pk dol - chyba
         jmp       short TestOkD            ; bl pk nahoru - OK

TestOkA: cmp       ch,0Fh                   ; thne ern pk dol ?
         jae       TestOk3                  ; ern pk dol - OK
         jmp       short TestOkD            ; ern pk nahoru - chyba

; ------ kontrola tahu vا

TestOkB: cmp       dl,4                     ; je vا ?
         jne       TestOk3                  ; nen vا
         jmp       short TestOkD            ; je vا - OK

; ------ test, zda je skok na kon

TestOkC: cmp       dl,2                     ; je k ?
         jne       TestOk3                  ; nen k - dal smr

; ------ je tah povolenm smrem

TestOkD: cmp       byte ptr ds:[FigTst2],7
         je        TestOkE
         test      dh,20h                   ; je skok na soupee ?
         jz        TestOkF                  ; nen skok na soupee
         mov       al,1                     ; pznak, e v cest stoj soupe
         jmp       short TestOk4            ; konec

; ------ test, zda bude dal tah

TestOkE: call      l_007A                   ; uloen bodovn do tabulky figurek
TestOkF: mov       al,ds:[CilFig2]          ; pvodn figurka na polku
         cmp       al,6                     ; byl to krl ?
         je        TestOkG                  ; byl to krl - jen 1 krok
         cmp       al,2                     ; byl to k ?
         je        TestOkG                  ; byl to k - jen 1 krok
         jmp       TestOk2                  ; jinak test dalho kroku

TestOkG: jmp       TestOk3                  ; konec

TestOkol ENDP
  
;==========================================================================
;        nhodn vbr tabulky zahjen hry
;==========================================================================
  
l_01C8   PROC      NEAR

         push      ds
         xor       ax,ax
         mov       ds,ax
         mov       al,ds:[46ch]
         pop       ds

         and       al,3                     ; ni 2 bity setiny sekundy
         mov       dl,6                     
         mul       dl                       ; nhodn slo 0, 6, 12, 18
         mov       dx,offset d_000E
         add       ax,dx                    
         mov       ds:[d_09C8],ax           ; nalezen tah potae
         ret

l_01C8   ENDP

;==========================================================================
;        test rody
;==========================================================================
  
l_01DE   proc    near

         test      byte ptr ds:[FigTst1],8
         jz        l_01E6
         ret       

l_01E6:  cmp       byte ptr ds:[d_09D7],0
         je        l_01EE
         ret       

l_01EE:  mov       cx,0FF03h                ; posun krle o 3 pole vpravo
l_01F1:  add       cl,ds:[d_09B2]           
         mov       bh,0                     
         mov       bl,cl                    ; testovan polko
         mov       word ptr ds:[PozTst],bx
         mov       al,ds:[bx+Mapa]        ; obsah polka
         and       al,7Fh                   ; zruen pznaku barvy
         cmp       al,4                     ; je vا ?
         jne       l_026E                   ; nen vا
         jz        l_0229

l_0209:  mov       bx,word ptr ds:[PozTst]  ; pozice v achovnici
         cmp       byte ptr ds:[bx+Mapa],0 ; je przdn pole ?
         jne       l_026E                   ; nen przdn pole
         cmp       bl,5Ch                                ; '\'
         je        l_0229
         cmp       bl,16h
         je        l_0229
         call      TestOkol                   ; test okol figurky
         cmp       al,0                     ; bylo przdn polko ?
         jne       l_026E
         mov       bx,word ptr ds:[PozTst]
l_0229:  add       bl,ch
         mov       word ptr ds:[PozTst],bx
         cmp       bl,ds:[d_09B2]
         jne       l_0209
         sub       bl,ch
         sub       bl,ch
         mov       ds:[PozTah],bl           ; pozice pi pokusu o tah
         mov       byte ptr ds:[CilFig1],40h
         call      l_0000                   ; uloen definice do zsobnku tah
         mov       al,ds:[d_09B2]
         sub       al,ch
         mov       ds:[PozTah],al           ; pozice pi pokusu o tah
         mov       ds:[d_09B2],cl
         mov       byte ptr ds:[CilFig1],0
         call      l_0000                   ; uloen definice do zsobnku tah
         mov       bx,ds:[d_09CA]
         sub       bx,6
         mov       ds:[d_09CA],bx
         mov       word ptr ds:[bx],0
         mov       al,ds:[PozTst]
         mov       ds:[d_09B2],al

l_026E:  cmp       ch,1                     ; byl ji druh smr ?
         je        l_0279                   ; byl ji druh smr
         mov       cx,1FCh                  ; posun krle o 4 pozice vlevo
         jmp       l_01F1                   ; nov pokus

l_0279:  ret

l_01DE   ENDP

;==========================================================================
;        Tah potae
;==========================================================================
  
TahPoc   PROC      NEAR

; ------ hlen, e thne pota

         mov       byte ptr ds:[Hraje],1    ; pznak, e hraje pota

         mov       si,offset CekTxt
         call      DispHlas

         mov       dh,ds:[Radek]            ; aktuln dek
         mov       dl,4
         mov       al,16
         call      DispChar                 ; indiktor ekn

l_02CA:  call      l_0606                   ; nalezen tahu pro pota
         mov       ax,ds:[d_09C8]           ; nalezen tah potae
         mov       ds:[d_09C4],ax           ; ukazatel v bufferu tah
         cmp       byte ptr ds:[d_017F],1
         jne       l_02EA                   
         mov       cl,1                     
         call      l_05B0                   ; hlen o matu

l_02EA:  call      l_09B4                   ; proveden jednoho tahu
         mov       al,ds:[Hrac]           ; 80=hr m bl, 00=ern
         mov       ds:[Protihr],al           ; 80=pota m bl, 00=ern
         call      Rosada                   ; volba tahu pro rodu

         mov       byte ptr ds:[Rosad],0    ; pznak - nen roda

         mov       ds:[NewPoz],dl           ; clov pozice
         mov       ds:[OldPoz],cl           ; vchoz pozice

                                           ;* normln tah
         cmp       ch,0                     ; je normln tah ?
         jne       l_0316                   ; nen normln tah

;         mov       ds:[NewPoz],dl           ; clov pozice
;         mov       ds:[OldPoz],cl           ; vchoz pozice
         jmp       short l_033E             ; pokraovn
                                           ;* mal roda "O-O"
l_0316:  test      ch,2                     ; je mal roda ?
         jz        l_0326                   ; nen mal roda
         mov       byte ptr ds:[Rosad],1    ; pznak - je mal roda
         jmp       short l_033E             ; pokraovn
                                           ;* velk roda "O-O-O"
l_0326:  test      ch,4                     ; je velk roda ?
         jz        l_0336                   ; nen velk roda
         mov       byte ptr ds:[Rosad],2    ; pznak - je velk roda
         jmp       short l_033E             ; pokraovn
         nop                                

l_0336:  mov       byte ptr ds:[Rosad],3    ; pznak "PxPep"

l_033E:  cmp       byte ptr ds:[d_017F],0FFh
         jne       l_034D
         mov       cl,0                     
         call      l_05B0                   ; hlen o matu
         jmp       short l_0368             ; konec, ek na znak
         nop
                                            
l_034D:  lea       bx,ds:[d_09E2]           ;
         mov       al,ds:[Hrac]           ; 80=hr m bl, 00=ern
         xor       al,80h                   
         call      TestFig                   ; test okol aktivn figurky
         cmp       al,0                     
         je        l_0368                   
;         lea       dx,ds:[d_004E]
;         mov       ah,9
;         int       21h                      ; tisk textu "Check"
l_0368:

         mov       dh,ds:[Radek]            ; aktuln dek
         mov       dl,4
         mov       al," "
         call      DispChar                 ; indiktor ekn

         call      DispMov                  ; zobrazen provedenho tahu
         call      DispCR                   ; oddkovn textu
         ret

TahPoc   ENDP
  
;==========================================================================
;        Zobrazen achovnice
;==========================================================================
  
Disp     PROC      NEAR

; ------ schova registr

         push      ax
         push      bx
         push      cx
         push      dx
         push      di
         push      es

; ------ zobrazen achovnice

         xor       bx,bx                    ; slo prvnho polka
         mov       cx,offset(Mapa0-Mapa)
Disp2:   mov       dl,ds:[bx+Mapa]          ; mapa achovnice
         cmp       dl,0FFh                  ; je zakzan polko ?
         je        Disp3                    ; polko je zakzan
         mov       al,bl                    ; slo polka
         call      DispPol                  ; zobrazen polka
Disp3:   inc       bx                       ; zven sla polka
         loop      Disp2

; ------ zobrazen slic vlevo

         mov       di,160                   ; adresa k uloen
         mov       es,ds:[SegmVRAM]         ; segment videopamti
         mov       ax,0fh*256 + "8"
         mov       cl,8
         cld
Disp4:   stosw                              ; uloen slice dku
         add       di,3*160-2
         dec       ax
         loop      Disp4

; ------ zobrazen dku dole

         add       di,5*2-160
         mov       al,"a"
         mov       cl,8
Disp5:   stosw
         add       di,6*2
         inc       ax
         loop      Disp5

; ------ nvrat registr

         pop       es
         pop       di
         pop       dx
         pop       cx
         pop       bx
         pop       ax
         ret

Disp     ENDP

; -----------------------------------------------------------------------------
;        zobrazen polka
; -----------------------------------------------------------------------------
;
                                                 ; VSTUP: AL=slo polka
                                                 ;        DL=obsah polka
DispPol  PROC      NEAR

; ------ schova registr

         push      ax
         push      bx
         push      cx
         push      dx
         push      si
         push      di
         push      bp
         push      es

; ------ pprava registr

         mov       es,ds:[SegmVRAM]         ; segment videopamti
         cld

; ------ vpoet souadnic polka

         mov       ah,0                     ; AX=slo polka
         mov       cl,10                    ; poet pozic na dek
         div       cl                       ; vpoet dku a pozice polka
         sub       al,2                     ; odeten okraje
         neg       al                       ; - slo dku
         add       al,7                     ; poten offset sla dku
         dec       ah                       ; slo pozice - 1
         mov       bl,ah                    ; schova sla pozice

; ------ uren barvy polka

         mov       bp,70h*256 + 178         ; bl barva, pln polko
         cmp       dl,80h                   ; je przdn inverzn polko ?
         jne       DispPol1
         xor       bp,77h*256               ; inverzn przdn polko
DispPol1:xor       ah,al                    ; test barvy polka
         test      ah,1                     ; je ern polko ?
         jz        DispPol2                 ; je ern polko
         xor       bp,77h*256               ; zmna barvy polka
         xor       dl,80h                   ; zmna barvy figurky
DispPol2:test      dl,80h
         jnz       DispPl22
         add       bp,176-178               ; nhrada rafovanm polkem

; ------ vpoet adresy ve videopamti

DispPl22:mov       cl,80*3                  ; poet pozic na dek
         mul       cl                       ; pepoet dku na znaky
         shl       ax,1                     ; poet bajt
         add       ax,4
         mov       di,ax                    ; poten adresa dku
         mov       al,7*2                   ; poet bajt na ku polka
         mul       bl                       ; vpoet offsetu na dku
         add       di,ax                    ; adresa ve videopamti

; ------ test, zda se zobraz przdn polko

         mov       al,dl                    ; slo figurky
         and       al,7                     ; slo figurky
         jnz       DispPol4                 ; je figurka

; ------ zobrazen przdnho polka

         mov       bh,3                     ; poet dk na polko
         mov       ax,bp                    ; barva polka
         mov       al," "                   ; znak mezery
DispPol3:mov       cx,7                     ; poet znak na polko
         rep       stosw                    ; vymazn dku polka
         add       di,160-7*2               ; adresa dalho dku
         dec       bh                       ; ta dk polka
         jnz       DispPol3                 ; dal dek
         jmp       short DispPol9

; ------ adresa vzorku figurky

DispPol4:mov       cl,3*7                   ; poet bajt na obrzek
         mul       cl                       ; offset obrzky
         mov       si,offset Obrazky-3*7
         add       si,ax                    ; adresa obrzky

; ------ zobrazen figurky

         mov       bh,3                     ; poet dk k zobrazen
         mov       ax,bp                    ; barva polka
DispPol5:mov       cx,7                     ; poet bajt na dek
DispPol6:lodsb                              ; bajt k zobrazen
         cmp       al,178                   ; pln polko ?
         jne       DispPol7                 ; nen pln polko
         mov       ax,bp                    ; nhradn znak
DispPol7:stosw
         loop      DispPol6                 ; dal znak na dku
         add       di,160-2*7               ; adresa dalho dku
         dec       bh                       ; ta dk
         jnz       DispPol5                 ; zobrazen dalho dku

; ------ nvrat registr

DispPol9:pop       es
         pop       bp
         pop       di
         pop       si
         pop       dx
         pop       cx
         pop       bx
         pop       ax
         ret

DispPol  ENDP

;==========================================================================
;       vnoen do tahu
;==========================================================================
  
l_0492   PROC      NEAR

         mov       al,ds:[d_09B2]
         test      byte ptr ds:[FigTst1],80h
         jz        l_049E
         add       al,0Ah
l_049E:  cmp       al,3Dh                                ; '='
         jb        l_0508
         cmp       al,44h                                ; 'D'
         ja        l_0508
         mov       bx,ds:[d_09C4]           ; ukazatel v bufferu tah
         test      byte ptr ds:[bx+4],10h
         jz        l_0508
         mov       bl,ds:[bx+3]
         mov       ds:[d_09B8],bl
         mov       bh,0
         mov       al,ds:[bx+Mapa]        ; obsah pole
         mov       ds:[d_09D2],al           
         and       al,7                     
         cmp       al,1                     ; je pk ?
         jne       l_0508                   ; nen pk

         sub       bl,ds:[PozTah]           ; pozice pi pokusu o tah
         jns       l_04CE                   
         neg       bl                       ; absolutn hodnota rozdlu
l_04CE:  cmp       bl,0Ah
         jne       l_0508
         or        byte ptr ds:[CilFig1],40h              ; '@'
         call      l_0000                   ; uloen definice do zsobnku tah
         mov       al,ds:[d_09B2]
         mov       ds:[PozTst],al
         mov       al,ds:[d_09B8]
         mov       ds:[d_09B2],al
         mov       ds:[PozTah],al           ; pozice pi pokusu o tah
         mov       al,ds:[d_09D2]
         mov       ds:[CilFig1],al
         call      l_0000                   ; uloen definice do zsobnku tah
         mov       al,ds:[PozTst]
         mov       ds:[d_09B2],al
         mov       bx,ds:[d_09CA]
         sub       bx,6
         mov       ds:[d_09CA],bx
         mov       word ptr ds:[bx],0
l_0508:  ret

l_0492   ENDP
  
;==========================================================================
;       jeden tah s vyhodnocenm
;==========================================================================
  
l_050A   PROC      NEAR

         call      l_09B4                   ; proveden jednoho tahu
         mov       al,ds:[Protihr]
         call      TestFig                   ; test okol aktivn figurky
         cmp       al,0
         je        l_051F
         mov       byte ptr ds:[d_09D9],0
         jmp       short l_0525
         nop
l_051F:  call      l_0B24                   ; hodnocen jednoho stavu achovnice
         call      l_0CA8                   
l_0525:  call      l_0EC2                   ; nvrat tahu z bufferu tah
         ret

l_050A   ENDP
  
;==========================================================================
;        volba tahu pro rodu
;==========================================================================
  
Rosada   PROC      NEAR

         mov       si,ds:[d_09C4]           ; ukazatel v bufferu tah
         mov       al,ds:[Protihr]           ; 80=pota m bl, 00=ern
         cmp       al,ds:[Hrac]           ; 80=hr m bl, 00=ern
         jne       l_056C

l_0537:  mov       bh,0
         mov       bl,ds:[si+3]             ; clov pozice
         cmp       bl,ds:[si+2]             ; = vchoz pozice ?
         je        l_055B                   ; clov pozice = vchoz pozice

         mov       dh,ds:[bx+Mapa]        ; vektor achovnice
         test      byte ptr ds:[si+4],20h                   ; ' '
         jz        l_0551
         and       dh,0F8h
         or        dh,1
l_0551:  mov       dl,0
         mov       bl,ds:[si+2]                ; slo polka
         mov       ch,0Ah                      ; poet bliknut kurzoru
         call      BlikKurz                      ; blikn kurzoru

l_055B:  mov       bh,0
         mov       bl,ds:[si+3]             
         mov       dh,ds:[si+4]             
         mov       dl,ds:[bx+Mapa]        ; vektor achovnice
         mov       ch,0Ah                   
         call      BlikKurz                      ; blikn kurzoru

l_056C:  test      byte ptr ds:[si+4],40h                   ; '@'
         jz        l_0577
         add       si,6
         jmp       short l_0537

l_0577:  mov       bx,ds:[d_09C4]           ; ukazatel v bufferu tah
         mov       cl,ds:[bx+2]
         mov       dl,ds:[bx+3]
         mov       ch,0
         test      byte ptr ds:[bx+4],40h                   ; '@'
         jz        l_05AF
         add       bx,6
         mov       cl,ds:[bx+2]
         mov       dl,ds:[bx+3]
         cmp       cl,dl
         jne       l_059C
         or        ch,1
         jmp       short l_05AF

l_059C:  cmp       dl,1Ah
         je        l_05AC
         cmp       dl,60h                                ; '`'
         je        l_05AC
         or        ch,4
         jmp       short l_05AF
l_05AC:  or        ch,2
l_05AF:  ret

Rosada   ENDP

;==========================================================================
;        hlen o matu (nebo blcm se matu)
;==========================================================================
  
l_05B0   PROC      NEAR

         mov       al,ds:[d_09D3]           ; zbyl poet tah 1
         sub       al,byte ptr ds:[CitTah]  ; ta tah
         jnz       l_05D4                   ; nen vhra

         mov       al,ds:[Hrac]             ; barva hre
         cmp       cl,0                     ; je vtzem pota ?
         jne       l_05aaa                  ; ne - vyhrl hr
         xor       al,80h                   ; zmna barvy - barva potae
l_05aaa: mov       si,offset d_0A5A         ; ern vyhrl
         cmp       al,0                     ; vyhrl ern ?
         je        l_05aab                  ; vyhrl ern
         mov       si,offset d_0a3a         ; bl vyhrl
l_05aab:
         call      DispHlas
         jmp       l_0894                   ; konec hry

                                          ;* mat se bl
l_05D4:  cmp       cl,0                     ; hraje pota ?
         jne       l_05E6                   ; nehraje pota
         add       al,30h                   ; korekce na slici
         mov       ds:[d_0A52],al         
         mov       si,offset d_0a4a
         call      DispHlas

l_05E6:  ret

l_05B0   ENDP
  
;==========================================================================
;        blikn kurzoru
;==========================================================================
  
BlikKurz   PROC      NEAR
                                            ; VSTUP: CH=poet bliknut
                                            ;        BL=slo polka
                                            ;        DL=figurka
                                            ;        DH=figurka s kurzorem

         mov       al,dl
         xor       al,dh
         js        BlikKur1
         test      dl,7fh
         jz        BlikKur1
         test      dh,7fh
         jz        BlikKur1
         xor       dh,80h

; ------ obsluha klvesnice

BlikKur1:mov       cl,0                     ; pznak dvojho bliknut
BlikKur2:cmp       byte ptr ds:[Hraje],0
         jne       BlikKur3                 ; hraje pota
         call      Obsluha                  ; proveden obsluhy klvesy

; ------ prodleva

BlikKur3:push      ax
         mov       ah,1
         int       16h                      ; test stavu klvesnice
         pop       ax
         jnz       BlikKur4                 ; je klvesa
         call      Cekej                    ; ekn po 1/18 sekundy

; ------ zobrazen polka

BlikKur4:xchg      dl,dh                    ;
         mov       al,bl                    ; slo polka
         call      DispPol                  ; zobrazen polka AL
         xor       cl,1                     ; test pznaku ukonen tahu
         jnz       BlikKur2                 ; tah nebyl dokonen
         dec       ch                       ; ta potu bliknut
         jnz       BlikKur2                 ; dal cyklus bliknut
         ret

BlikKurz ENDP
  
;==========================================================================
;        nalezen tahu pro pota
;==========================================================================
  
l_0606   PROC      NEAR

; --- pprava

         mov       al,ds:[Uroven]           ; rove hry 1-6
         mov       ds:[d_0A6C],al           ; schova rovn hry pi tahu

; ------ prvn tah - nhodn zahjen       

         cmp       word ptr ds:[CitTah],1   ; je to prvn tah ?
         jne       l_062F                   ; nen prvn tah
         mov       byte ptr ds:[d_017F],0
         test      byte ptr ds:[Hrac],80h ; 80=hr m bl, 00=ern
         jnz       l_062F                   ; hr m bl
         call      l_01C8                   ; nhodn vbr tabulky zahjen
         ret                                

; ----- pro mn ne 4. tah omezen rovn hry na 1 (pro rozehrn)

l_062F: ; push      ds
        ; xor       ax,ax
        ; mov       ds,ax
        ; mov       al,ds:[46ch]
        ; pop       ds
        ; test      al,1ch                   ; nepozornost pi 1/8
        ; jnz       l_062f2
        ;
        ; and       al,3
        ; sub       byte ptr ds:[Uroven],al
        ; jbe       l_062f3

l_062f2: mov       al,ds:[Uroven]
         mov       ah,0
         cmp       ax,word ptr ds:[CitTah]  ; ta tah
         jb        l_063B
         mov       al,byte ptr ds:[CitTah]
         sub       al,1
         mov       ds:[Uroven],al           ; snen rovn
         ja        l_063b

l_062f3: mov       byte ptr ds:[Uroven],1   ; na zatku rove hry = 1

l_063B:  xor       ax,ax
         mov       byte ptr ds:[d_09D6],al  ; ta hloubky (rove hry)
         mov       ds:[d_09C8],ax           ; nalezen tah potae (nen nic)
         lea       ax,ds:[d_01B2]           ; zatek tabulky tah
         mov       ds:[d_09CC],ax           ; ukazatel v zsobnku tah
         lea       ax,ds:[d_018A]           
         sub       ax,2                     
         mov       ds:[d_09C2],ax           
         mov       al,ds:[Hrac]           ; 80=hr m bl, 00=ern
         mov       ds:[Protihr],al           ; 80=pota m bl, 00=ern
         lea       di,ds:[d_017E]           
         mov       ds:[d_09C6],di           
         mov       ch,0                     
         mov       cl,ds:[Uroven]           ; rove hry
         add       cl,2                     
         mov       al,0                     
         cld                                
         rep       stosb                    
         mov       ds:[d_09DF],al           
         mov       ds:[d_09E0],al           
         call      l_0B24                   
         call      l_0CA8                   ; hodnocen jednoho stavu achovnice
         mov       al,ds:[d_09DA]           
         mov       ds:[d_09DF],al           
         mov       al,ds:[d_09DE]           
         mov       ds:[d_09E0],al           
         jmp       short l_069D             


l_068C:                                     ; (zde m bt zobrazen asu)

         call      DispStav                 ; zobrazen stavu

l_069D:  inc       byte ptr ds:[d_09D6]     ; ta hloubky (rove hry)

;         call      DispStav

         mov       byte ptr ds:[d_09D8],0
         call      l_08A2                   ; test, zda m hr dal tah
         mov       al,byte ptr ds:[d_09D6]  ; ta hloubky (rove hry)
         cmp       al,ds:[Uroven]           ; rove hry
         jae       l_06B5
         call      l_0E88

l_06B5:  mov       ax,ds:[d_09C2]
         mov       ds:[d_09C4],ax           ; ukazatel v bufferu tah
l_06BB:  mov       bx,ds:[d_09C4]           ; ukazatel v bufferu tah
         mov       ax,ds:[bx]
         cmp       ax,0
         je        l_072A
         mov       ds:[d_09C4],ax           ; ukazatel v bufferu tah
         mov       bx,ds:[d_09C2]
         mov       ds:[bx],ax
         mov       al,byte ptr ds:[d_09D6]  ; ta hloubky (rove hry)
         cmp       al,ds:[Uroven]           ; rove hry
         jb        l_0701                   
         call      l_09B4                   ; proveden jednoho tahu
         mov       al,ds:[Protihr]
         call      TestFig                   ; test okol aktivn figurky
         cmp       al,0                     
         je        l_06EA                   
         call      l_0EC2                   ; nvrat tahu z bufferu tah
         jmp       short l_06BB

l_06EA:  mov       al,byte ptr ds:[d_09D6]  ; ta hloubky (rove hry)
         cmp       al,ds:[Uroven]           ; rove hry
         jne       l_0759                   
         mov       al,ds:[Protihr]
         xor       al,80h                   
         call      TestFig                   ; test okol aktivn figurky
         cmp       al,0
         je        l_0759
         jnz       l_070E
l_0701:  mov       bx,ds:[d_09C4]           ; ukazatel v bufferu tah
         cmp       byte ptr ds:[bx+5],0
         je        l_06BB
         call      l_09B4                   ; proveden jednoho tahu
l_070E:  xor       byte ptr ds:[Protihr],80h
         js        l_0719
         inc       word ptr ds:[CitTah]     ; ta tah
l_0719:  mov       bx,ds:[d_09C6]
         mov       al,ds:[bx]
         mov       ds:[bx+2],al
         inc       bx
         mov       ds:[d_09C6],bx
         jmp       l_068C

l_072A:  cmp       byte ptr ds:[d_09D8],0
         jne       l_0745
         mov       al,80h
         cmp       byte ptr ds:[d_09D7],0
         je        l_0765
         mov       al,byte ptr ds:[CitTah]  ; ta tah
         mov       ds:[d_09D3],al           ; zbyl poet tah 1
         mov       al,0FFh
         jmp       short l_0765

l_0745:  cmp       byte ptr ds:[d_09D6],1   ; ta hloubky (rove hry)
         je        l_07A6
         call      l_004C
         mov       bx,ds:[d_09C6]
         mov       al,ds:[bx+2]
         jmp       short l_076E

l_0759:  call      l_0B24                   ; hodnocen jednoho stavu achovnice
         call      l_0CA8                   
         call      l_0EC2                   ; nvrat tahu z bufferu tah
         mov       al,ds:[d_09D9]
l_0765:  mov       byte ptr ds:[d_09D8],1
         mov       bx,ds:[d_09C6]
l_076E:  cmp       al,ds:[bx]
         ja        l_0778
         call      l_004C
l_0775:  jmp       l_06BB

l_0778:  neg       al
         inc       bx
         cmp       al,ds:[bx]
         jbe       l_0775
         mov       ds:[bx],al

;         call      DispStav

         cmp       byte ptr ds:[d_09D6],1   ; ta hloubky (rove hry)
         jne       l_0775

         mov       ax,ds:[d_09C4]           ; ukazatel v bufferu tah
                                            ; - nalezen nejlep tah
         mov       ds:[d_09C8],ax           ; nalezen tah potae

         call      DispStav                 ; zobrazen stavu

         mov       ax,word ptr ds:[d_017E]
         cmp       ah,0FFh
         jne       l_0775
         sub       byte ptr ds:[Uroven],2   ; rove hry
         test      byte ptr ds:[Hrac],80h ; 80=hr m bl, 00=ern
         jz        l_07A6                   
         dec       byte ptr ds:[d_09D3]     ; zbyl poet tah 1
l_07A6:  mov       al,ds:[d_0A6C]           ; schova rovn hry pi tahu
         mov       ds:[Uroven],al           ; rove hry
         ret

l_0606   ENDP


DispStav PROC      NEAR

         push      ax
         push      bx
         push      cx
         push      dx
         push      si
         push      di

         mov       ah,1
         int       16h
         jz        l_068c5
         call      InpChr
         cmp       bl,27
         jne       l_068c5

         mov       si,offset PrerTxt        ; dotaz k peruen
         call      DispHlas                 ; zobrazen hlen
l_068c2: call      InpChr                   ; vstup znaku z klvesnice
         cmp       bl,27
         je        l_068c2
         cmp       bl,"A"
         jne       l_068c4

         mov       al,ds:[d_0A6C]           ; schova rovn hry pi tahu
         mov       ds:[Uroven],al           ; rove hry
         jmp       Zadej

l_068c4: mov       si,offset CekTxt
         call      DispHlas

l_068c5: mov       bx,ds:[d_09c8]
         or        bx,bx
         jz        DispSt18

         mov       al,ds:[OldPoz]
         mov       ah,ds:[NewPoz]
         push      ax
         mov       al,ds:[OldFig]
         mov       ah,ds:[Rosad]
         push      ax

         mov       ax,ds:[bx+2]
         mov       ds:[OldPoz],al
         mov       ds:[NewPoz],ah
         mov       al,ds:[bx+4]
         and       al,7
         mov       ds:[OldFig],al
         mov       byte ptr ds:[Rosad],0
         call      DispMov

         pop       ax
         mov       ds:[Rosad],ah
         mov       ds:[OldFig],al
         pop       ax
         mov       ds:[NewPoz],ah
         mov       ds:[OldPoz],al

DispSt18:

l_068c7:
         pop       di
         pop       si
         pop       dx
         pop       cx
         pop       bx
         pop       ax
         ret

DispStav ENDP

;==========================================================================
;        Tah hre - pohyb figurkou
;==========================================================================
  
Obsluha  PROC      NEAR

; ------ test, zda je njak klvesa

         mov       ah,1
         int       16h
         jz        Obsluha9                 ; nen klvesa

; ------ schova registr

         push      ax
         push      bx
         push      cx                       
         push      dx                       

; ------ vpoet aktulnho dku a pozice

         mov       ah,0
         mov       al,ds:[Kurzor]           ; pozice kurzoru
         mov       cl,10                    ; poet pozic na dek
         div       cl                       ; vpoet dku a pozice
         xchg      ax,dx                    ; DH=pozice, DL=dek

; ------ vstup znaku z klvesnice

         call      InpChr
         call      Obsluha2                 ; obsluha klvesy

; ------ nvrat registr

         pop       dx
         pop       cx
         pop       bx
         pop       ax
Obsluha9:ret

Obsluha  ENDP

;
Obsluha2:call      JumpBX                   ; skok na obsluhu klvesy

         dw        4800h,ObslUp             ; nahoru
         dw        4900h,ObslPgUp           ; pln nahoru
         dw        4b00h,ObslLeft           ; vlevo
         dw        4d00h,ObslRght           ; vpravo
         dw        5000h,ObslDwn            ; dol
         dw        5100h,ObslPgDn           ; pln dol
         dw        4f00h,ObslEnd            ; pln vpravo
         dw        4700h,ObslHome           ; pln vlevo

         dw        0dh,ObslEnt              ; ENTER
         dw        " ",ObslEnt              ; mezera
         dw        5200h,ObslEnt            ; INSERT
         dw        5300h,ObslEnt            ; DELETE
         dw        27,ObslEsc               ; ESC

         dw        0,Obsluha9

; -----------------------------------------------------------------------------
;        peruen programu
; -----------------------------------------------------------------------------

ObslEsc  PROC      NEAR

         push      si
         mov       si,offset PrerTxt        ; dotaz k peruen
         call      DispHlas                 ; zobrazen hlen
         pop       si
         call      InpChr                   ; vstup znaku z klvesnice
         cmp       bl,"A"
         jne       ObslEsc4
         jmp       short l_08942

                                          ;* konec hry - nkdo vyhrl
l_0894:  call      KurzOff
         call      InpChr
l_08942: call      Clear
         jmp       Zadej

ObslEsc4:mov       si,offset TahTxt
         call      DispHlas
         ret

ObslEsc  ENDP

; -----------------------------------------------------------------------------
;        klvesa Home - pln vlevo
; -----------------------------------------------------------------------------

ObslHome PROC      NEAR

         cmp       dh,1                     ; je zatek dku ?
         je        ObslHom4                 ; je ji zatek dku
         call      ObslLeft                 ; kurzor vlevo
         jmp       short ObslHome           ; dal test
ObslHom4:ret

ObslHome ENDP

; -----------------------------------------------------------------------------
;        klvesa Page Up - pln nahoru
; -----------------------------------------------------------------------------

ObslPgUp PROC      NEAR

         cmp       dl,9                     ; je horn dek ?
         je        ObslPgU4                 ; je horn dek
         call      ObslUp                   ; posun kurzoru nahoru
         jmp       short ObslPgUp
ObslPgU4:ret

ObslPgUp ENDP

; -----------------------------------------------------------------------------
;        klvesa End - pln vpravo
; -----------------------------------------------------------------------------

ObslEnd  PROC      NEAR

         cmp       dh,8                     ; je konec dku ?
         je        ObslEnd4                 ; je konec dku
         call      ObslRght                 ; posun kurzoru vpravo
         jmp       short ObslEnd
ObslEnd4:ret

ObslEnd  ENDP

; -----------------------------------------------------------------------------
;        Page Down - pln dol
; -----------------------------------------------------------------------------

ObslPgDn PROC      NEAR

         cmp       dl,2                     ; je spodn dek ?
         je        ObslPgD4                 ; je spodn dek
         call      ObslDwn                  ; posun kurzoru dol
         jmp       short ObslPgDn           ; dal posun
ObslPgD4:ret

ObslPgDn ENDP

; -----------------------------------------------------------------------------
;        kurzor nahoru
; -----------------------------------------------------------------------------

ObslUp   PROC      NEAR

         mov       al,ds:[Kurzor]           ; pozice kurzoru
         add       al,10                    ; zven dku o 10 pozic
         add       dl,1                     ; posun sla dku
         cmp       al,100                   ; je pekroen okraj ?
         jb        ObslUp2                  ; okraj jet nen pekroen
         sub       al,80                    ; snen na spodn okraj
         sub       dl,8
ObslUp2: mov       ds:[Kurzor],al           ; nov pozice kurzoru
         ret

ObslUp   ENDP

; -----------------------------------------------------------------------------
;        kurzor vlevo
; -----------------------------------------------------------------------------

ObslLeft PROC      NEAR

         dec       byte ptr ds:[Kurzor]     ; snen pozice kurzoru
         dec       dh                       ; snen pozice
         jnz       ObslLft4                 ; nebyl pechod pes okraj
         add       byte ptr ds:[Kurzor],8   ; korekce na konec dku
         add       dh,8
ObslLft4:ret

ObslLeft ENDP

; -----------------------------------------------------------------------------
;        kurzor vpravo
; -----------------------------------------------------------------------------

ObslRght PROC      NEAR

         inc       byte ptr ds:[Kurzor]     ; zven pozice kurzoru
         inc       dh                       ; zven pozice
         cmp       dh,9                     ; byl pechod pes okraj ?
         jne       ObslRgh4                 ; nebyl pechod pes okraj
         sub       byte ptr ds:[Kurzor],8   ; korekce na zatek dku
         sub       dh,8
ObslRgh4:ret

ObslRght ENDP

; -----------------------------------------------------------------------------
;        kurzor dol
; -----------------------------------------------------------------------------

ObslDwn  PROC      NEAR

         mov       al,ds:[Kurzor]           ; pozice kurzoru
         sub       al,10                    ; snen sla dku
         sub       dl,1
         cmp       al,20                    ; je podteen pod okraj ?
         ja        ObslDwn4                 ; nen pod spodnm okrajem
         add       al,80                    ; korekce na horn okraj
         add       dl,8
ObslDwn4:mov       ds:[Kurzor],al           ; nov pozice kurzoru
         ret

ObslDwn  ENDP

; -----------------------------------------------------------------------------
;        Enter - poloen figurky
; -----------------------------------------------------------------------------

ObslEnt  PROC      NEAR

; ------ poloen figurky

         cmp       byte ptr ds:[VolTah],2   ; ek se na poloen ?
         jne       ObslEnt2                 ; neek se na poloen
         mov       bh,0
         mov       bl,ds:[Kurzor]           ; pozice kurzoru
         mov       al,ds:[bx+Mapa]          ; figurka na nov pozici
         mov       ds:[OldFig],al           ; pvodn figurka
         test      al,7fh                   ; je njak figurka ?
         jz        ObslEnt0                 ; nen figurka - OK
         xor       al,ds:[Figurka]          ; je to figurka sprvn barvy ?
         jns       ObslEnt1                 ; je to patn figurka
ObslEnt0:mov       al,ds:[Kurzor]           ; pozice kurzoru
         mov       ds:[NewPoz],al           ; nov pozice figurky
         mov       byte ptr ds:[VolTah],0   ; pznak stavu klidu
ObslEnt1:ret

; ------ zvednut figurky

ObslEnt2:mov       bh,0
         mov       bl,ds:[Kurzor]           ; pozice kurzoru
         mov       al,ds:[bx+Mapa]          ; penen figurka
         cmp       al,0                     ; je njak figurka ?
         je        ObslEnt5                 ; nen figurka
         xor       al,ds:[Hrac]             ; je to figurka sprvn barvy ?
         jns       ObslEnt5                 ; je to patn figurka
         mov       ds:[OldPoz],bl           ; vchoz pozice figurky
         mov       al,ds:[bx+Mapa]          ; penen figurka
         mov       ds:[Figurka],al          ; penen figurka
         mov       byte ptr ds:[bx+Mapa],0  ; zruen figurky na achovnici
         mov       byte ptr ds:[VolTah],2   ; pznak ekn na poloen
ObslEnt5:ret

ObslEnt  ENDP


;==========================================================================
;        test, zda je njak figurka, s kterou lze thnout
;==========================================================================
  
l_08A2   PROC      NEAR

         mov       al,ds:[Protihr]           ; barva protihre
         call      TestFig                   ; test okol aktivn figurky
         mov       ds:[d_09D7],al           
         mov       dx,ds:[d_09CC]           ; ukazatel v zsobnku tah
         mov       bx,ds:[d_09C2]           
         mov       ds:[bx+2],dx             
         add       bx,4                     
         mov       ds:[d_09C2],bx           
         mov       ds:[d_09CA],bx           
         mov       bx,15h                   ; prvn polko achovnice

l_08C4:  mov       word ptr ds:[d_09B2],bx  ; ukazatel v achovnici
         mov       al,ds:[bx+Mapa]        ; kmen na achovnici
         cmp       al,0                     ; je przdn pole ?
         je        l_08E0                   ; przdn pole - dal
         cmp       al,0FFh                  ; mimo achovnici ?
         je        l_08E0                   ; je mimo - konec
         mov       ds:[FigTst1],al           ; testovan figurka
         xor       al,ds:[Protihr]           ; je to figurka hre ?
         js        l_08E0                   ; nen - dal
         call      l_0A30                   ; test, zda lze s figurkou thnout

l_08E0:  mov       bx,word ptr ds:[d_09B2]
         inc       bx
         cmp       bl,63h
         jb        l_08C4
         ret

l_08A2   ENDP
  
         db        0
  
; -----------------------------------------------------------------------------
;             test okol figurky protihre (barva hre AL)
; -----------------------------------------------------------------------------
  
TestFig  PROC      NEAR

         rol       al,1                     ; barva -> bit 0
         and       ax,1                     ; barva figurky
         mov       bx,ax                    ; BX <- barva figurky (1=bl)
         mov       bl,ds:[bx+KurzB]         ; pozice kurzoru protihre
         mov       bh,0                     ; BH <- 0
         mov       word ptr ds:[PozTst],bx  ; pracovn pozice hre
         mov       al,ds:[bx+Mapa]          ; figurka na pozici
         mov       ds:[FigTst1],al          ; figurka pi testu
         and       al,7                     
         mov       ds:[FigTst2],al          ; figurka pi testu
         call      TestOkol                 ; test okol figurky
         ret

TestFig  ENDP
  
; -----------------------------------------------------------------------------
;                     Inicializace achovnice
; -----------------------------------------------------------------------------

InitPole PROC      NEAR

; ------ vymazn achovnice

         cld                                
         mov       di,offset Mapa           ; mapa achovnice
         mov       si,offset MapaIni        ; inicializan rozmstn
         mov       cx,offset(Mapa0-Mapa)/2  ; dlka mapy achovnice (slov)
         rep       movsw                    ; inicializace mapy achovnice

; ------ inicializace ukazatel

         mov       byte ptr ds:[KurzB],25   ; pozice kurzoru blho
         mov       byte ptr ds:[KurzC],95   ; pozice kurzoru ernho
         mov       byte ptr ds:[DamaB],24   ; bl dma
         mov       byte ptr ds:[DamaC],94   ; ern dma

; ------ pozice kurzoru hre

         mov       al,25                    ; kurzor blho
         test      byte ptr ds:[Hrac],80h   ; je hr bl ?
         jnz       InitPol2                 ; je bl
         mov       al,95                    ; pozice kurzoru ernho
InitPol2:mov       ds:[HracPoz],al          ; pozice kurzoru hre
         ret

InitPole ENDP

;==========================================================================
;        omezen sla AL na CH (absolutn)
;==========================================================================
  
l_09A0   PROC      NEAR

                                          ;* kontrola pekroen sla AL
         and       al,al                    ; test AL
         lahf                               ; schova registru pznak
         jns       l_09A7                   ; je kladn slo
         neg       al                       ; absolutn hodnota sla
l_09A7:  cmp       al,ch                    
         jb        l_09AD                   
         mov       al,ch                    
l_09AD:  sahf                               ; nvrat registru pznak
         jns       l_09B2                   ; bylo to kladn slo
         neg       al                       ; nvrat zpornho sla
l_09B2:  ret

l_09A0   ENDP
  
;==========================================================================
;        proveden jednoho tahu
;==========================================================================
  
l_09B4   PROC      NEAR

         mov       si,ds:[d_09C4]           ; ukazatel v bufferu tah
l_09B8:  mov       bh,0                     
         mov       dh,ds:[si+4]             ; clov figurka
         and       byte ptr ds:[OldFig],7
         mov       bl,ds:[si+2]             ; vchoz pozice
         mov       di,bx                    ; vchoz pozice
         mov       bl,ds:[si+3]             ; clov pozice
         mov       si,bx                    ; clov pozice

         push      ax
         mov       al,ds:[si+Mapa]
         mov       ds:[OldFig],al          ; pvodn figurka
         pop       ax

         mov       dl,ds:[di+Mapa]        ; figurka, kter thne
         mov       bl,dl                    ; schova figurky k thnut
         rol       bl,1                     
         and       bx,1                     ; barva figurky
         nop
         test      dh,20h                   ; nhrada pka dmou ?
         jnz       l_0A07                   ; je nhrada pka dmou
         mov       al,dl                    ; aktivn figurka
         and       al,7                     ; zruen barvy
         cmp       al,5                     ; je dma ?
         je        l_0A0F                   ; je dma
         cmp       al,6                     ; je krl ?
         je        l_0A17                   ; je krl

l_09E4:  or        dl,8
         mov       ds:[si+Mapa],dl        ; aktivn figurka na nov pozici
         mov       byte ptr ds:[di+Mapa],0; zruen aktivn figurky
         test      dh,40h                   ; bude dal tah ?
         jnz       l_0A27                   ; bude dal tah (roda)
         mov       al,dh                    ; ruen figurka
         and       al,7                     ; zruen barvy
         cmp       al,5                     ; byla to dma ?
         jne       l_0A06                   ; nebyla to dma
         xor       bx,1
         nop
         mov       byte ptr ds:[bx+DamaB],0; zruen pozice dmy
l_0A06:  ret

; ------ nhrada pka dmou

l_0A07:  and       dl,0F8h                  ; zruen figurky
         or        dl,5                     ; nhrada dmou
         jmp       short l_09E4

; ------ tah dmou - nov pozice

l_0A0F:  mov     ax,si                      ; clov pozice figurky
         mov     ds:[bx+DamaB],al          ; nov pozice dmy
         jmp     short l_09E4

; ------- tah krlem

l_0A17:  test    dh,40h                     ; byla to roda ?
         jz      l_0A1F                     ; nebyla roda
         or      dl,10h                     ; pznak 2. tahu rody

l_0A1F:  mov     ax,si                      
         mov     ds:[bx+KurzB],al          ; nov pozice kurzoru
         jmp     short l_09E4

l_0A27:  mov     si,ds:[d_09C4]             ; ukazatel v bufferu tah
         add     si,6
         jmp     l_09B8

l_09B4   ENDP

;==========================================================================
;        test, zda lze s figurkou thnout
;==========================================================================
  
l_0A30   PROC      NEAR

; ------ pprava potu a adresy monch tah figurky

         mov       al,ds:[FigTst1]           ; testovan figurka
         and       al,87h                   ; figurka s barvou
         cmp       al,81h                   ; je ern pk ?
         jne       l_0A3B                   ; nen ern pk
         dec       al                       ; nhradn slo figurky 0
l_0A3B:  and       al,7                     ; zruen barvy
         mov       ds:[FigTst2],al           ; figurka
         mov       bh,0                     
         mov       bl,al                    ; figurka
         mov       ch,ds:[bx+NumSmer]        ; poet monch tah
         mov       bl,ds:[bx+OfsSmer]        ; adresa monch tah
         mov       di,bx                    ; adresa monch tah figurky

; --------- test jednoho tahu figurky

l_0A4E:  mov       cl,ds:[di+TabSmer]        ; mon smr tahu figurky
         mov       al,ds:[d_09B2]           ; pozice figurky
         mov       ds:[PozTah],al           ; pozice pi pokusu o tah

; ------- test jednoho kroku

l_0A58:  call      PokTah                   ; pokus o tah danm smrem

         cmp       al,2                     ; je skok na vlastn nebo ven ?
         jae       l_0A7A                   ; skok na vlastn nebo ven - chyba

         cmp       al,0                     ; je przdn ?
         lahf                               ; schova pznak
         mov       al,ds:[FigTst2]           ; figurka
         cmp       al,1                     ; je pk ?
         jbe       l_0A8A                   ; pk nebo przdn polko
         call      l_0000                   ; uloen definice do zsobnku tah
         sahf                               ; nvrat pznak
         jnz       l_0A7A                   ; nen przdn polko
         mov       al,ds:[FigTst2]           ; figurka
         cmp       al,6                     ; je krl ?
         je        l_0A7A                   ; je krl - nelze dal krok
         cmp       al,3                     ; je stelec, vا nebo dma ?
         jae       l_0A58                   ; stelec, vا nebo dma-dal krok

l_0A7A:  inc       di
         dec       ch
         jnz       l_0A4E
         mov       al,ds:[FigTst2]
         cmp       al,6
         jne       l_0A89
         call      l_01DE                   ; test rody
l_0A89:  ret

l_0A8A:  cmp       ch,3
         jb        l_0ABB
         jz        l_0AB3
         sahf                               ; jinak je prvn tah - pmo
         jnz       l_0A7A                   ; nen przdn pole - chyba
         mov       al,ds:[PozTah]           ; pozice pi pokusu o tah
         cmp       al,5Bh                                ; '['
         jae       l_0A9F
         cmp       al,1Dh
         jae       l_0AA4
l_0A9F:  or        byte ptr ds:[CilFig1],20h ; pznak posl. ady pkem
l_0AA4:  call      l_0000                   ; uloen definice do zsobnku tah
         inc       di
         dec       ch
         test      byte ptr ds:[FigTst1],8
         jz        l_0A58                   ; dal krok
         jnz       l_0A7A
l_0AB3:  sahf
         jnz       l_0A7A
l_0AB6:  call      l_0000                   ; uloen definice do zsobnku tah
         jmp       short l_0A7A

l_0ABB:  sahf
         jz        l_0AD0
         mov       al,ds:[PozTah]           ; pozice pi pokusu o tah
         cmp       al,5Bh                                ; '['
         jae       l_0AC9
         cmp       al,1Dh
         jae       l_0AB6
l_0AC9:  or        byte ptr ds:[CilFig1],20h              ; ' '
         jmp       short l_0AB6

l_0AD0:  call      l_0492
         jmp       short l_0A7A

l_0A30   ENDP
  
  
l_0AD6   PROC      NEAR

         inc       bp
         xchg      ch,cl
         xchg      di,si
         mov       ax,0
         cmp       ch,0
         je        l_0AF5
         dec       ch
         cld       
l_0AE6:  scasw
         jz        l_0AE6
         dec       di
         dec       di
         mov       ax,ds:[di]
         mov       ds:[di],ah
         mov       byte ptr ds:[di+1],0
         add       al,al
l_0AF5:  ret

l_0AD6   ENDP

;==========================================================================
;                  Pokus o tah danm smrem
;==========================================================================
  
PokTah   PROC      NEAR
                                               ;* pokus o tah danm smrem
                                                 ; VSTUP: CL=prustek skoku
                                                 ; VSTUP: AL=0 - przdn pole
                                                 ;         AL=1 - na soupee
                                                 ;         AL=2 - na vlastn
                                                 ;         AL=3 - tah ven

; ------ zskn obsahu clovho polka

         mov       bx,word ptr ds:[PozTah]  ; pozice pi pokusu o tah
         add       bl,cl                    ; zven pozice o tah
         mov       word ptr ds:[PozTah],bx  ; nov pozice pi pokusu o tah
         mov       al,ds:[bx+Mapa]          ; obsah nov pozice

; ------ test, zda je skok mimo achovnici

         cmp       al,0FFh                  ; je zakzan oblast ?
         je        PokTah2                  ; je tah ven z achovnice

; ------ schova obsahu clovho polka

         mov       ds:[CilFig1],al          ; pvodn obsah na polku
         and       al,7                     ; zruen pznaku barvy
         mov       ds:[CilFig2],al          ; ruen figurka
         jz        PokTah3                  ; przdn polko

; ------ test, zda je skok na vlastn figurku

         mov       al,ds:[CilFig1]          ; pvodn obsah polka
         xor       al,ds:[FigTst1]          ; test barvy figurky
         jns       PokTah1                  ; stejn barva - chyba
         mov       al,1                     ; skok na soupee - OK
         ret       

; ------ skok na vlastn

PokTah1: mov       al,2                     ; pznak - skok na vlastn
         ret       

; ------ skok ven z achovnice

PokTah2: mov       al,3                     ; pznak - tah je ven
PokTah3: ret

PokTah   ENDP

;==========================================================================
;        hodnocen jednoho stavu achovnice
;==========================================================================
  
l_0B24   PROC      NEAR

         mov       word ptr ds:[d_09C0],0
         mov       si,0
l_0B2D:  mov       bl,ds:[si+KurzB]        ; pozice kurzoru blho
         cmp       bl,0
         jne       l_0B39
         jmp       l_0BEE

l_0B39:  cmp       bl,0FFh
         jne       l_0B3F
         ret       

l_0B3F:  mov       bh,0
         mov       word ptr ds:[PozTst],bx  ; testovan pozice
         mov       al,ds:[bx+Mapa]        ; vektor achovnice
         mov       ds:[FigTst1],al           ; testovan figurka
         mov       ch,8                     ; poet pokus
         mov       di,0                     
l_0B51:  mov       al,ds:[PozTst]           ; testovan pozice
         mov       ds:[PozTah],al           ; pozice pi pokusu o tah
         mov       byte ptr ds:[d_09B8],0
         mov       cl,ds:[di+TabSmer]

l_0B60:  call      PokTah                   ; pokus o tah danm smrem
         cmp       al,0                     
         je        l_0B60                   ; je przdn pole - dal
         cmp       al,3                     
         je        l_0BE6                   ; tah ven
         cmp       al,2                     ; skok na vlastn
         je        l_0B8E

         cmp       byte ptr ds:[d_09B8],0
         je        l_0BE6
         mov       al,ds:[CilFig2]           ; pvodn figurka
         cmp       al,5                     ; byla to dma ?
         je        l_0B9D                   ; byla to dma
         cmp       ch,5                     
         jb        l_0B88                   
         cmp       al,3                     ; byl to stelece ?
         jne       l_0BE6                   ; nebyl to stelec
         jz        l_0BD2                   ; byl to stelec - OK

l_0B88:  cmp       al,4                     ; byla to vا ?
         jne       l_0BE6                   ; nebyla to vا
         jz        l_0BD2                   ; byla to vا

l_0B8E:  cmp       byte ptr ds:[d_09B8],0
         jne       l_0BE6
         mov       al,ds:[PozTah]           ; pozice pi pokusu o tah
         mov       ds:[d_09B8],al
         jmp       short l_0B60

l_0B9D:  mov       al,ds:[FigTst1]           ; testovan figurka
         and       al,7                     ; zruen barvy
         cmp       al,5                     ; byla to dma ?
         jne       l_0BD2                   ; nebyla to dma - dobr tah
         push      cx
         push      di
         mov       al,0
         mov       cx,0Eh
         lea       di,ds:[PocFigC]
         cld       
         rep       stosw
         mov       byte ptr ds:[FigTst2],7
         call      TestOkol                   ; test okol figurky
         pop       di
         pop       cx
         mov       al,ds:[PocFigC]
         sub       al,ds:[PocFigB]
         test      byte ptr ds:[FigTst1],80h
         jz        l_0BCE
         neg       al
l_0BCE:  dec       al
         jns       l_0BE6
l_0BD2:  mov       bx,ds:[d_09C0]
         inc       bx
         mov       ds:[d_09C0],bx
         mov       ds:[bx+d_016F],cl
         mov       al,ds:[d_09B8]
         mov       ds:[bx+d_0165],al
l_0BE6:  inc       di
         dec       ch
         jz        l_0BEE
         jmp       l_0B51
l_0BEE:  inc       si
         jmp       l_0B2D

l_0B24   ENDP

;==========================================================================
;                       Tah hre
;==========================================================================
;

TahHrac  PROC      NEAR

; ------ automatick hra - nhrada potaem

         cmp       byte ptr ds:[Automat],0  ; je automatick hra ?
         je        TahHrac2                 ; nen automatick hra
         xor       byte ptr ds:[Hrac],80h   ; zmna barvy hre
;         xor       byte ptr ds:[Protihr],80h ; zmna barvy potae
         call      TahPoc                   ; tah potae
         xor       byte ptr ds:[Hrac],80h   ; nvrat barvy hre
;         xor       byte ptr ds:[Protihr],80h ; nvrat barvy potae
         ret

; ------ pprava aktuln pozice kurzoru

TahHrac2:mov       byte ptr ds:[Hraje],0    ; pznak, e hraje hr

         mov       al,ds:[HracPoz]          ; pozice hre
         mov       ds:[Kurzor],al           ; aktuln pozice kurzoru

; ------ vzva k proveden tahu

         mov       si,offset TahTxt
         call      DispHlas                 ; zobrazen hlen

; ------ zvednut figurky

TahHrac4:mov       byte ptr ds:[VolTah],1   ; pznak ekn na DEL
         call      KurzOff                  ; vypnut kurzoru

; ------ ekn na zvednut figurky

TahHrac5:mov       bh,0                     ; BH <- 0
         mov       bl,ds:[Kurzor]           ; pozice kurzoru
         mov       dl,ds:[bx+Mapa]          ; figurka na pozici kurzoru
         mov       dh,dl                    ; schova figurky
         xor       dh,80h                   ; inverzn figurka
         mov       ch,1                     ; poet cykl = 1
         call      BlikKurz                 ; obsluha kurzoru
         cmp       byte ptr ds:[VolTah],1   ; ek se na zvednut ?
         je        TahHrac5                 ; ekn na zvednut figurky

; ------ ekn na poloen figurky

TahHrac6:mov       bh,0                     ; BH <- 0
         mov       bl,ds:[Kurzor]           ; pozice kurzoru
         mov       dl,ds:[bx+Mapa]          ; figurka na pozici kurzoru
         mov       dh,ds:[Figurka]          ; penen figurka
         mov       ch,1                     ; poet cykl = 1
         call      BlikKurz                 ; obsluha kurzoru
         cmp       byte ptr ds:[VolTah],2   ; ek se na poloen ?
         je        TahHrac6                 ; ekn na poloen figurky

; ------ test navrcen figurky

         mov       bh,0                     ; BH <- 0
         mov       bl,ds:[OldPoz]           ; vchoz pozice figurky
         mov       al,ds:[Figurka]          ; penen figurka
         mov       ds:[bx+Mapa],al          ; navrcen figurky zpt
         mov       dl,bl                    ; vchoz pozice penen
         mov       dh,ds:[NewPoz]           ; nov pozice figurky
         cmp       dl,dh                    ; je stejn pozice ?
         je        TahHrac4                 ; figurka navrcena - znovu

; ------ test sprvnosti tahu, nvrat tahu

         call      TestTah                  ; test sprvnosti tahu + proveden
         jnc       TahHrac7                 ; tah je OK - nov pozice
         mov       al,ds:[OldPoz]           ; vchoz pozice figurky
         mov       ds:[Kurzor],al           ; pozice kurzoru
         mov       dl,ds:[Figurka]          ; penen figurka
         call      DispPol                  ; zobrazen polka
         jmp       TahHrac4                 ; nov volba tahu

; ------ zobrazen nov pozice figurky

TahHrac7:mov       al,ds:[NewPoz]           ; nov pozice figurky
         mov       ds:[HracPoz],al          ; schova nov pozice kurzoru
         mov       bh,0                     ; BH <- 0
         mov       bl,al                    ; BX <- nov pozice figurky
         mov       dl,ds:[bx+Mapa]          ; vektor achovnice
         call      DispPol                  ; zobrazen polka

         mov       byte ptr ds:[Rosad],0
         call      Rosada                   ; volba tahu pro rodu

; ------ zobrazen provedenho tahu

         call      DispMov                  ; zobrazen provedenho tahu
         call      DispCR                   ; oddkovn textu
         ret

TahHrac   ENDP

;==========================================================================
;       nalezen dalho tahu
;==========================================================================
  
l_0CA8   PROC      NEAR

         mov       al,0
         mov       ds:[d_09DE],al
         mov       ds:[d_09DA],al
         mov       ds:[d_09DB],al
         mov       ds:[d_09DC],al
         mov       ds:[d_09DD],al
         mov       ds:[d_09E1],al
         mov       byte ptr ds:[FigTst2],7
         mov       bx,15h
l_0CC4:  mov       word ptr ds:[PozTst],bx
         mov       al,ds:[bx+Mapa]        ; vektor achovnice
         cmp       al,0FFh
         jne       l_0CD3
         jmp       l_0D90
l_0CD3:  mov       cl,al
         mov       ds:[FigTst1],al
         and       al,7
         mov       ds:[d_09BE],al
         cmp       al,1
         jbe       l_0D1C
         cmp       al,4
         jb        l_0D0A
         cmp       al,6
         je        l_0CF2
         cmp       word ptr ds:[CitTah],7   ; ta tah
         jb        l_0D03
         jnc       l_0D03
l_0CF2:  test      cl,10h
         jz        l_0D03
         mov       al,6
         test      cl,80h
         jz        l_0D18
         neg       al
         jmp       short l_0D18
         nop
l_0D03:  test      cl,8
         jz        l_0D1C
         jnz       l_0D0F
l_0D0A:  test      cl,8
         jnz       l_0D1C
l_0D0F:  mov       al,2
         test      cl,80h
         jnz       l_0D18
         neg       al
l_0D18:  add       ds:[d_09DA],al
l_0D1C:  mov       al,0
         mov       cx,0Eh
         lea       di,ds:[PocFigC]
         cld       
         rep       stosw
         call      TestOkol                   ; test okol figurky
         mov       al,ds:[PocFigC]
         sub       al,ds:[PocFigB]
         add       ds:[d_09DA],al
         cmp       byte ptr ds:[FigTst1],0
         je        l_0D90
         call      l_0F9E
         cmp       dl,0
         je        l_0D81
         dec       dh
         mov       al,ds:[FigTst1]
         xor       al,ds:[Protihr]
         js        l_0D6C
         cmp       dl,ds:[d_09DB]
         jb        l_0D81
         mov       ds:[d_09DB],dl
         mov       bx,ds:[d_09C4]           ; ukazatel v bufferu tah
         mov       al,ds:[PozTst]
         cmp       al,ds:[bx+3]
         jne       l_0D81
         mov       ds:[d_09E1],al
         jmp       short l_0D81

l_0D6C:  mov       al,dl
         cmp       al,ds:[d_09DC]
         jb        l_0D78
         xchg      al,ds:[d_09DC]
l_0D78:  cmp       al,ds:[d_09DD]
         jb        l_0D81
         mov       ds:[d_09DD],al
l_0D81:  mov       al,dh
         test      byte ptr ds:[FigTst1],80h
         jz        l_0D8C
         neg       al
l_0D8C:  add       ds:[d_09DE],al
l_0D90:  mov       bx,word ptr ds:[PozTst]
         inc       bx
         cmp       bx,63h
         jae       l_0D9D
         jmp       l_0CC4
l_0D9D:  cmp       byte ptr ds:[d_09E1],0
         je        l_0DAF
         mov       al,ds:[d_09DD]
         mov       ds:[d_09DC],al
         mov       byte ptr ds:[d_09DD],0
l_0DAF:  mov       al,ds:[d_09DB]
         cmp       al,0
         je        l_0DB8
         dec       al
l_0DB8:  mov       ch,al
         mov       al,ds:[d_09DC]
         cmp       al,0
         je        l_0DCC
         mov       al,ds:[d_09DD]
         cmp       al,0
         je        l_0DCC
         dec       al
         shr       al,1
l_0DCC:  sub       al,ch
         test      byte ptr ds:[Protihr],80h
         jz        l_0DD7
         neg       al
l_0DD7:  add       al,ds:[d_09DE]
         sub       al,ds:[d_09E0]
         mov       ch,1Eh                   ; max. hodnota = 30
         call      l_09A0                   ; omezen sla AL na CH
         mov       dl,al
         mov       al,ds:[d_09DA]
         sub       al,ds:[d_09DF]
         cmp       byte ptr ds:[d_09E1],0
         je        l_0DF6
         mov       al,0
l_0DF6:  mov       ch,6                     ; max. hodnota = 6
         call      l_09A0                   ; omezen sla AL na CH
         shl       dl,1
         shl       dl,1
         add       al,dl
         test      byte ptr ds:[Protihr],80h
         jnz       l_0E0A
         neg       al
l_0E0A:  add       al,80h
         mov       ds:[d_09D9],al
         mov       bx,ds:[d_09C4]           ; ukazatel v bufferu tah
         mov       [bx+5],al
         ret

l_0CA8   ENDP

;==========================================================================
;       posun tahu
;==========================================================================
  
l_0E88   PROC      NEAR

         mov       cx,ds:[d_09C2]
         mov       di,0
l_0E8F:  mov       bx,cx
         mov       cx,[bx]
         mov       [bx],di
         cmp       cx,0
         jne       l_0E9B
         ret       

l_0E9B:  mov       ds:[d_09C4],cx           ; ukazatel v bufferu tah
         call      l_050A
         mov       bx,ds:[d_09C2]
         mov       cx,ds:[d_09C4]           ; ukazatel v bufferu tah
l_0EAA:  mov       di,ds:[bx]
         cmp       di,0
         je        l_0EB9
         mov       al,ds:[d_09D9]
         cmp       al,ds:[di+5]
         jae       l_0EBD
l_0EB9:  mov       ds:[bx],cx
         jmp       short l_0E8F
l_0EBD:  mov       bx,di
         jmp       short l_0EAA

l_0E88   ENDP
  
         db        0
  
;==========================================================================
;        nvrat tahu z bufferu tah
;==========================================================================
  
l_0EC2   PROC      NEAR

         mov       si,ds:[d_09C4]           ; ukazatel v bufferu tah

l_0EC6:  mov       bh,0                     
         mov       dh,ds:[si+4]             ; pvodn obsah novho pole
         mov       bl,ds:[si+2]             ; vchoz pozice tahu
         mov       di,bx                    ; vchoz pozice tahu
         mov       bl,ds:[si+3]             ; clov pozice tahu
         mov       si,bx                    ; clov pozice tahu
         mov       dl,ds:[si+Mapa]        ; figurka, s kterou se thlo
         mov       bl,dl                    ; figurka k thnut
         rol       bl,1                     ; figurka * 2
         and       bx,1                     ; barva figurky
         test      dh,20h                   ; byla nhrada pka dmou ?
         jnz       l_0F1E                   ; byla nhrada pka dmou
         mov       al,dl                    ; figurka, kter thla
         and       al,7                     ; zruen barvy
         cmp       al,5                     ; byla to dma ?
         je        l_0F26                   ; thla dma
         cmp       al,6                     ; thl krl ?
         je        l_0F2E                   ; thl krl
                                            
l_0EF2:  test      dh,10h
         jz        l_0EFA                   
         and       dl,0F7h                  
l_0EFA:  mov       ds:[di+Mapa],dl        ; uloen pvodn figurky
         mov       al,dh                    ; pvodn figurka
         and       al,8Fh                   ; zruen pznak
         mov       ds:[si+Mapa],al        ; nvrat ruen figurky
         test      dh,40h                   ; bude dal tah ?
         jnz       l_0F3E                   ; nvrat dalho tahu
         mov       al,dh                    ; ruen figurka
         and       al,7                     ; zruen barvy
         cmp       al,5                     ; je to dma ?
         jne       l_0F1D                   ; nen to dma
         mov       ax,si                    ; pozice dmy
         xor       bx,1                     
         mov       ds:[bx+DamaB],al        ; pvodn pozice dmy
l_0F1D:  ret

; ------ byla nhrada pka dmou - nvrat pka

l_0F1E:  and       dl,0F8h                  ; zruen figurky
         or        dl,1                     ; nhrada pkem
         jmp       short l_0EF2

; ----- thla dma

l_0F26:  mov       ax,di                    ; pvodn pozice dmy
         mov       ds:[bx+DamaB],al        ; nvrat pozice dmy
         jmp       short l_0EF2

; ----- thne krl

l_0F2E:  test      dh,40h
         jz        l_0F36
         and       dl,0EFh
l_0F36:  mov       ax,di
         mov       ds:[bx+KurzB],al        ; pozice kurzoru blho
         jmp       short l_0EF2

; ------ dal tah

l_0F3E:  mov       si,ds:[d_09C4]           ; ukazatel v bufferu tah
         add       si,6                     ; zven pozice v bufferu
         jmp       l_0EC6

l_0EC2   ENDP

;==========================================================================
;     Test sprvnosti tahu a proveden tahu (DL=vchoz/DH=clov pozice)
;==========================================================================
;
TestTah  PROC      NEAR

; ------ pprava registr

         push      word ptr ds:[d_09C4]     ; ukazatel v bufferu tah
         mov       al,ds:[Hrac]             ; 80=hr m bl, 00=ern
         xor       al,80h                   ; zmna pznaku barvy
         mov       ds:[Protihr],al          ; poadovan barva protihre
         mov       word ptr ds:[d_09C2],offset d_018A-2 ; ukazatel v bufferu
         mov       word ptr ds:[d_09CC],offset d_05b2 ; ukazatel v zsobnku

; ------ test, zda m hr dal tah

         push      dx
         call      l_08A2                   ; test, zda m hr dal tah
         pop       dx                       


         lea       bx,ds:[d_05B2]
l_0F6E:  cmp       dl,ds:[bx+2]             
         jne       l_0F78                   
         cmp       dh,ds:[bx+3]             
         je        l_0F81                   
l_0F78:  mov       bx,ds:[bx]               
         cmp       bx,0                     
         jne       l_0F6E                   
         jz        l_0F98                   
l_0F81:  mov       ds:[d_09C4],bx           ; ukazatel v bufferu tah
         call      l_09B4                   ; proveden jednoho tahu

         mov       al,ds:[Protihr]           ; barva potae
         call      TestFig                   ; test okol aktivn figurky
         cmp       al,0                     
         jne       l_0F95                   

         pop       ax                       
         clc                                
         ret                                

l_0F95:  call      l_0EC2                   ; nvrat tahu z bufferu tah
l_0F98:  pop       word ptr ds:[d_09C4]     ; ukazatel v bufferu tah
         stc                                ; pznak chyby - nepovolen tah
         ret

TestTah   ENDP

;==========================================================================
;       obodovn jednoho tahu
;==========================================================================
  
l_0F9E   PROC      NEAR

         lea       di,ds:[BodFigC]
         lea       si,ds:[BodFigB]
         mov       ch,ds:[PocFigC]
         mov       cl,ds:[PocFigB]
         test      byte ptr ds:[FigTst1],80h
         jz        l_0FB9
         xchg      di,si
         xchg      ch,cl
l_0FB9:  mov       bp,0
         mov       dl,0
         mov       bx,word ptr ds:[d_09BE]
         mov       dh,ds:[bx+TabBod]
         shl       dh,1
         mov       bh,dh
         call      l_0AD6
         jz        l_0FFC
l_0FCF:  mov       bl,al
         call      l_0AD6
         jz        l_0FEA
         cmp       bh,bl
         jae       l_0FEA
l_0FDA:  cmp       al,bl
         jb        l_0FFC                            ;*
         call      l_0AD6
         jz        l_0FFC                            ;*
         mov       bl,al
         call      l_0AD6
         jnz       l_0FDA
l_0FEA:  test      bp,1
         jz        l_0FF2                            ;*
         neg       bh
l_0FF2:  add       dl,bh
         cmp       al,0
         je        l_0FFC
         mov       bh,bl
         jmp       short l_0FCF
l_0FFC:  ret

l_0F9E   ENDP

; -----------------------------------------------------------------------------
;        vymazn obrazovky
; -----------------------------------------------------------------------------

Clear    PROC      NEAR

; ------ schova registr

         push      ax
         push      bx
         push      cx
         push      dx
         push      di
         push      es

; ------ vymazn obrazovky

         mov       cx,25*80                 ; poet znak celkem
         mov       es,ds:[SegmVRAM]         ; segment videopamti
         xor       di,di
         cld
         mov       ax,720h                  ; znak mezery k vymazn
         rep       stosw                    ; vymazn obrazovky

; ------ nastaven kurzoru

         mov       bh,0
         mov       ah,2
         xor       dx,dx
         call      Int10P                   ; nastaven pozice kurzoru

; ------ nvrat registr

         pop       es
         pop       di
         pop       dx
         pop       cx
         pop       bx
         pop       ax
         ret

Clear    ENDP

; -----------------------------------------------------------------------------
;        ekn na hodinov impuls
; -----------------------------------------------------------------------------

Cekej    PROC      NEAR

         push      ax
         push      ds

         xor       ax,ax
         mov       ds,ax
         mov       ax,ds:[46ch]             ; asova
Cekej2:  sti
         cmp       ax,ds:[46ch]
         je        Cekej2                   ; ekn na zmnu hodin

         pop       ds
         pop       ax
         ret

Cekej    ENDP

; *****************************************************************************
;                    skok na obsluhu podle BX
; -----------------------------------------------------------------------------
; Procedura se vol instrukc CALL JumpBX, za kterou nsleduje tabulka
; skok. Procedura zmn svou nvratovou adresu na adresu podle nalezen
; poloky v tabulce (nebo podle poloky pro nenalezenou hodnotu).
; -----------------------------------------------------------------------------
; VSTUP: v zsobnku slovo (nvratov adresa NEAR) = zatek tabulky skok
;             stuktura tabulky: 1 slovo testovan hodnota BX
;                               1 slovo adresa NEAR obsluhy
;             konec tabulky: 1 slovo = 0 (pznak konce tabulky)
;                            1 slovo adresa NEAR obsluhy pi nenalezen kdu
; *****************************************************************************

JumpBX   PROC      NEAR

; ------ schova registr

                                            ; SS:[BP+6] = IP
         push      si                       ; SS:[BP+4] = SI
         push      bp                       ; SS:[BP+2] = BP
         push      ds                       ; SS:[BP+0] = DS
         mov       bp,sp

; ------ nalezen hodnoty v tabulce

         push      cs
         pop       ds
         mov       si,ss:[bp+6]             ; offset adresy tabulky
JumpBX1: cmp       word ptr ds:[si],0       ; je konec tabulky ?
         je        JumpBX2                  ; konec tabulky - nenalezeno
         cmp       word ptr ds:[si],bx      ; je to hledan hodnota ?
         je        JumpBX2                  ; hodnota nalezena
         add       si,4                     ; adresa dal poloky
         jmp       short JumpBX1            ; test dal poloky

; ------ nastaven nvratov adresy podle tabulky

JumpBX2: mov       si,ds:[si+2]             ; adresa skoku
         mov       ss:[bp+6],si             ; nov nvratov adresa

; ------ nvrat registr

         pop       ds
         pop       bp
         pop       si
         ret

JumpBX   ENDP

; -----------------------------------------------------------------------------
;        vstup znaku z klvesnice
; -----------------------------------------------------------------------------

InpChr   PROC      NEAR

; ------ vstup znaku z klvesnice

         sti
         push      ax
         mov       ah,0
         int       16h                      ; vstup znaku z klvesnice
         mov       bx,ax                    ; znak z klvesnice
         pop       ax

; ------ nhrada Ctrl-Break klvesou ESC

         or        bx,bx                    ; je Ctrl-Break ?
         jnz       InpChr2                  ; nen Ctrl-Break
         mov       bx,11bh                  ; nhrada klvesou Esc

; ------ konverze na velk psmeno

InpChr2: cmp       bl,"a"
         jb        InpChr3
         cmp       bl,"z"
         ja        InpChr3
         sub       bl,32                    ; konverze na velk psmeno

; ------ prava ASCII znak

InpChr3: cmp       bl,0
         je        InpChr4                  ; nen ASCII znak
         mov       bh,0

InpChr4: ret

InpChr   ENDP

; -----------------------------------------------------------------------------
;        nastaven kurzoru
; -----------------------------------------------------------------------------

SetKurz  PROC      NEAR

         push      ax
         push      bx
         push      dx

         mov       bh,0
         mov       ah,2
         call      Int10P

         pop       dx
         pop       bx
         pop       ax
         ret

SetKurz  ENDP

; -----------------------------------------------------------------------------
;        vypnut kurzoru
; -----------------------------------------------------------------------------

KurzOff  PROC      NEAR

         push      ax
         push      bx
         push      dx

         mov       bh,0
         mov       ah,2
         mov       dx,25*256
         call      Int10P

         pop       dx
         pop       bx
         pop       ax
         ret

KurzOff  ENDP

; -----------------------------------------------------------------------------
;        obsluha INT 10h
; -----------------------------------------------------------------------------

Int10P   PROC      NEAR

         push      si
         push      di
         push      bp
         push      ds
         push      es

         int       10h

         pop       es
         pop       ds
         pop       bp
         pop       di
         pop       si
         ret

Int10P   ENDP

; 
;
;                              Data
;
; 

;

SegmVRAM dw        0b000h                   ; segment videopamti
Zasobnik dw        0                        ; uschovan zsobnk

Automat  db        0                        ; pznak automatu: 0=nen, 1=je

Hraje    db        0                        ; hraje: 0=hr, 1=pota

Hrac     db        80h                      ; barva hre: 80h=bl, 0=ern
Protihr  db        0                        ; barva protihre: 80h=bl,0=ern

Uroven   db        1                        ; rove hry

CitTah   dw        1                        ; ta tah

Radek    db        1                        ; aktivn dek pro tisk textu

Kurzor   db        0                        ; aktivn pozice kurzoru

Rosad    db        0                        ; pznak rody
                                            ;   0=normln tah
                                            ;   1=mal roda
                                            ;   2=velk roda
                                            ;   3=PxPep

VolTah   db        0                        ; pznak volby figurky
                                            ;   0=figurka byla poloena
                                            ;   1=ek se na uchopen
                                            ;   2=figurka je uchopena
Figurka  db        0                        ; penen aktivn figurka
OldPoz   db        0                        ; vchoz pozice figurky
NewPoz   db        0,0                      ; nov pozice figurky
OldFig   db        0                        ; star figurka
HracPoz  db        0                        ; pozice kurzoru hre

d_000E   label     byte                     ; tabulka zahjen tah blho
         db        0,0,35,55,10h,0          ; lev pk uprosted o 2 pole
         db        0,0,34,54,10h,0          ; prav pk uprosted o 2 pole
         db        0,0,22,43,10h,0          ; prav jezdec
         db        0,0,27,46,10h,0          ; lev jezdec

d_0026   db        39 dup (20h),'$'         ; text pro vymazn

MalRosTx db        'O-O',0
VelRosTx db        'O-O-O',0
PxPepTx  db        'PxP',0  ;'PxPep',0

                                          ;* mon smry figurek
TabSmer  db        9,11,-11,-9              ; 0: smry ikmo
         db        10,-10,1,-1              ; 4: smry kolmo
         db        -21,-12,8,19             ; 8: konm vlevo
         db        21,12,-8,-19             ; 12: konm vpravo
         db        10,10,11,9               ; 16: tahy blho pka
         db        -10,-10,-11,-9           ; 20: tahy ernho pka

OfsSmer  label     byte                   ;* offset monch smr figurek
         db        20                       ; 0: bl pk
         db        16                       ; 1: ern pk
         db        8                        ; 2: jezdec
         db        0                        ; 3: stelec
         db        4                        ; 4: vا
         db        0                        ; 5: dma
         db        0                        ; 6: krl

NumSmer  label     byte                   ;* poet monch smr figurek
         db        4                        ; 0: bl pk
         db        4                        ; 1: ern pk
         db        8                        ; 2: jezdec
         db        4                        ; 3: stelec
         db        4                        ; 4: vا
         db        8                        ; 5: dma
         db        8                        ; 6: krl

TabBod   db        0,1,3,3,5,9,10           ; bodovn figurek

                                          ;* mapa achovnice
Mapa     db        21 dup (0)               ; spodn okraj achovnice
d_00E6   db        10 dup (0)               ; dek 1
d_00F0   db        10 dup (0)               ; dek 2
d_00FA   db        10 dup (0)               ; dek 3
d_0104   db        10 dup (0)               ; dek 4
d_010E   db        10 dup (0)               ; dek 5
d_0118   db        10 dup (0)               ; dek 6
d_0122   db        10 dup (0)               ; dek 7
d_012C   db        10 dup (0)               ; dek 8
d_0136   db        19 dup (0)               ; horn okraj achovnice
Mapa0    label     byte

                                          ;* inicializan mapa achovnice
MapaIni  db        20 dup(-1)               ; spodn okraj achovnice
         db        -1,4,2,3,5,6,3,2,4,-1    ; dek 1 (bl)
         db        -1,1,1,1,1,1,1,1,1,-1    ; dek 2
         db        -1,0,0,0,0,0,0,0,0,-1    ; dek 3
         db        -1,0,0,0,0,0,0,0,0,-1    ; dek 4
         db        -1,0,0,0,0,0,0,0,0,-1    ; dek 5
         db        -1,0,0,0,0,0,0,0,0,-1    ; dek 6
         db        -1,81h,81h,81h,81h,81h,81h,81h,81h,-1 ; dek 7
         db        -1,84h,82h,83h,85h,86h,83h,82h,84h,-1 ; dek 8 (ern)
         db        20 dup(-1)               ; horn okraj achovnice

                                                 ;    0=przdn polko
                                                 ;    1=pec
                                                 ;    2=jezdec
                                                 ;    3=stelec
                                                 ;    4=vا
                                                 ;    5=dma
                                                 ;    6=krl
                                                 ;    0ffh=zakzan polko
                                                 ; bit 7: 1=bl barva,0=ern

                                          ;* tabulka potu ernch figurek
PocFigC  db        0,0                      ; celkov poet figurek
BodFigC  dw        6 dup (0)                ; bodovn figurek

                                          ;* tabulka potu blch figurek
PocFigB  db        0,0                      ; celkov poet figurek
BodFigB  dw        6 dup (0)                ; bodovn figurek

d_0165   db        10 dup (0)               ; tabulka pozic figurek
d_016F   db        10 dup (0)

                                          ;* poad zachovat !
KurzB    db        19h                      ; pozice kurzoru blho
KurzC    db        5Fh                      ; pozice kurzoru ernho

DamaB    db        18h                      ; pozice bl dmy
DamaC    db        5Eh                      ; pozice ern dmy

         db        0FFh
d_017E   db        0
d_017F   db        0
         db        10 dup(0)


                                                 ; 0: (2) bodovn tahu
                                                 ; 2: (1) vchoz pozice tahu
                                                 ; 3: (1) clov pozice tahu
                                                 ; 4: (1) pvodn obsah novho pole
                                                 ; 5: (1)

d_018A   db        40 dup(0)                ; tabulka tah

d_01B2   db        1024 dup(0)

d_05B2   db        1016 dup (0)             ; tabulka tah

d_09AA   db        8 dup(0)

d_09B2   db        0,0
PozTah   db        0,0                      ; pozice pi pokusu o tah
PozTst   db        0,0                      ; testovan pozice hre
d_09B8   db        0,0
FigTst2  db        0,0                      ; pracovn figurka (bez barvy)

CilFig2  db        0,0                      ; ruen clov figurka pi skoku
                                            ;   (bez barvy)

d_09BE   db        0,0
d_09C0   dw        0
d_09C2   dw        18Ah                     ; ukazatel v zsobnku tah
                                            ;  <- 188h
d_09C4   dw        0                        ; ukazatel v bufferu tah
d_09C6   dw        0
d_09C8   dw        0                        ; nalezen tah potae (v tab.tah)
d_09CA   dw        0
d_09CC   dw        1B2h                     ; ukazatel v zsobnku tah
                                            ;  <- 5b2h

FigTst1  db        0                        ; figurka pi pracovnm testu
CilFig1  db        0                        ; pvod.obsah na novm polku
                                                 ;  0 a 6 - figurka
                                                 ;  10h - je to 2. tah rody
                                                 ;  20h - nhrada pka dmou
                                                 ;  40h - je to 1. tah rody
                                                 ;  80h - barva figurky

d_09D2   db        0
d_09D3   db        0                        ; zbyl poet tah
d_09D6   db        0
d_09D7   db        0
d_09D8   db        0
d_09D9   db        0
d_09DA   db        0
d_09DB   db        0
d_09DC   db        0
d_09DD   db        0
d_09DE   db        0
d_09DF   db        0
d_09E0   db        0
d_09E1   db        0
d_09E2   dw        0
d_09E4   dw        0

d_09EC   dw        0
;d_09EE   dw        0                        ; segment PSP


d_0A3A   db        19,'MAT - BILY VYHRAL !' ; bl vyhrl

d_0A4A   db        14,'MAT v '
d_0A52   db        'X tazich'               ; mat v X tazch

d_0A5A   db        20,'MAT - CERNY VYHRAL !'  ; ern vyhrl
         db        0

d_0A6C   db        0,0                      ; schova rovn hry pi tahu

Obrazky  label     byte                     ; obrzky figurek

                                            ; 1: pk
         db        '   o   '
         db        '      '
         db        '  '
                                            ; 2: jezdec
         db        ' /^   '
         db        ' Ĳ  '
         db        '  '
                                            ; 3: stelec
         db        '  ܲ  '
         db        '      '
         db        '  '
                                            ; 4: vا
         db        '    '
         db        '    '
         db        '  '
                                            ; 5: dma
         db        ' . . . '
         db        '    '
         db        '    '
                                            ; 6: krl
         db        '  _+_  '
         db        '    '
         db        '  '


Text1    db        2,' S  A  C  H  Y ',0
Text2    db        'verze ',1,'1.2',0
Text3    db        '(c) Miroslav Nemecek',0
Text4    db        '- FREEWARE -',0

ColTxt   db        'Zvolte barvu (',1,'B',1,'ila/',1,'C',1,'erna/'
         db        1,'A',1,'utomat/',1,'ENTER',1,', ',1,'ESC',1,'=konec): ',1
ColTxt0  db        'B',0
ColTxt1  db        'B',0
CRTxt    db        13,10,0

UrovTxt  db        'Zvolte uroven obtiznosti (',1,'1',1,' az ',1,'6',1
         db        ', ',1,'ENTER',1,', ',1,'ESC',1,'=navrat): ',1
UrovTxt0 db        '1',0

TahTxt   db        13,'Jste na tahu:'
CekTxt   db        16,'CEKEJTE - tahnu.'

PrerTxt  db        18,'Prerusit (A=ANO) ?'

         db        13 dup (0)

Code     ENDS

         END       Start
