#include <math.h>
#include <stdio.h>
#include <alloc.h>
#include <graphics.h>
#include <conio.h>
#include <stdlib.h>
#include <time.h>
#include <dos.h>

#define LEFT            0x4b00
#define RIGHT           0x4d00
#define UP              0x4800
#define DOWN            0x5000
#define Home            0x4700
#define End             0x4f00
#define PgUp            0x4900
#define PgDn            0x5100
#define ESC             0x011b
#define ENTER           0x1c0d

#define F1  0x3b00
#define F2  0x3c00
#define F3  0x3d00
#define F4  0x3e00
#define F5  0x3f00
#define F6  0x4000
#define F7  0x4100
#define F8  0x4200
#define F9  0x4300
#define F10 0x4400

#define ON			1
#define OFF			!ON
#define SXSIZE		20
#define SYSIZE		20
#define GXS			20
#define GYS			10
#define MRN			20
#define MAXLEV		20
#define PI			3.141592654
#define STAND_LIMIT 100
#define LNU			100

 int	Labir[GXS+1][GYS+1];
 int	d_labir[GXS+1][GYS+1];
 int	Robo[MRN+1][3];
 int	Stations[10];
 int	LabFlag=0;
 int	gwx=150,gwy=100;
 int	px=1,py=5;
 int	Level=1;
 int	Lives=5;
 int	Blasters=30;
 int	d_perc=50;
 int	r_nmb=4;
 int	GameResult=1;
 int	curv1=2;
 int	StepLimit=STAND_LIMIT;
 int	Sound=ON;
 char*	tmpnum="    ";
 char*	win;

 char* yhltl="You have lost the life!";
 char* cysa="Congratulation!!! You're still alive!";
 char* gaov="Game over!!!";
 char* wttnl="Welcome to the       room.";
 char* dest="Destroyers : ";
 char* liv="Lives :      ";
 char* smod="Step mode : ";
 char* tim="Time : ";
 char* menutexts[2]={"1 - Start Your game.","2 - Exit."};
 char* ends[5]={"th","st","nd","rd"};

 #include "r.inc"
 #include "mans.inc"
 #include "cyborgs.inc"
 #include "hall.inc"
 #include "exit.inc"


 /*		F u n c t i o n s	*/

 void DrawMenu(void);
 int  Menu(void);
 void PlayGame1(void);
 void ConstructLabir(void);
 void OutGameScreen(void);
 void SetLabir(void);
 void SetRobo(void);
 int  GoodLabir(void);
 void glr(int x,int y);
 int  Game(void);
 void MakeShoot(int x,int y);
 void OutDeath(int x,int y);
 void OutGround(int x,int y);
 void OutHero(int x,int y,int vec,int xo,int yo,int put);
 int  VectoryToMove(int x,int y,int x1,int y1);
 void OutRobot(int x,int y,int vec,int xo,int yo,int put);
 void MoveRobot(int x,int y,int x1,int y1,int num);
 void OutExit(int x,int y);
 void OutLightning(int x,int y,int n);
 void LightTo(int x,int y);
 void OutBoom(int x,int y);
 void OutAnySymbol(int x,int y,int sym);
 void OutNumBlast(void);
 void OutLives();
 void OutLevel(void);
 int  RoboMove(void);
 void MoveHero(int x,int y,int x1,int y1);
 void Death(void);
 void HappyEnd(void);
 void EndOfLevel(void);
 void GameOver(void);
 int  Sign(double x);
 char* TextNum(double numb);
 char* EndOfNum(int num);
 void TwoColorShadowText(int x,int y,int tc,int sc,char* text);
 void ShadowText(int x,int y,int color,char* text);
 void ClearKBBufer(void);
 unsigned GetKey(void);
 int  IsCtrl(void);
 int  IsRightSift(void);
 int  IsLeftSift(void);
 int  IsAlt(void);
 void Waitpress(){ClearKBBufer();GetKey();}

 main(){
 int gd=VGA,gm=VGAHI;
 int m_result=0;
  randomize();
  initgraph(&gd,&gm,'');
   gwx=(getmaxx()-GXS*SXSIZE)/2;
   gwy=(getmaxy()-GYS*SYSIZE)/2;
  win=malloc(imagesize(0,0,400,150));
  DrawMenu();
   while(1){
	m_result=Menu();
	 switch(m_result){
          case  1: PlayGame1();DrawMenu();break;
          case  2: closegraph();clrscr();
		   printf("\n            Expedition v0.1b\n Copyright (c) Mikhail Moldavskiy 1993\n");
		   exit(EXIT_SUCCESS);
	 }
	}
   }

 void DrawMenu(void){
  int mwx=160,mwy=105;
  cleardevice();
  settextstyle(TRIPLEX_FONT,HORIZ_DIR,5);
  ShadowText(mwx+50,mwy+1,BLUE,"Expedition.");
  settextstyle(TRIPLEX_FONT,HORIZ_DIR,3);
   setcolor(RED);
  outtextxy(mwx+15,mwy+70,menutexts[0]);
   setcolor(GREEN);
  outtextxy(mwx+15,mwy+108,menutexts[1]);
 }

 int Menu(void){
  int mwx=160,mwy=105,x;
  int com=0;
  int mp=1,mp1=1;
  x=mwx+15;
  settextstyle(TRIPLEX_FONT,HORIZ_DIR,3);
   while(com!=ENTER){
	mp1=mp;
	com=GetKey();
	 switch(com){
	  case UP:		mp--;if(mp<1)mp=2;com=0;break;
	  case DOWN:	mp++;if(mp>2)mp=1;com=0;break;
	  case 0x0231:             mp=1;com=ENTER;break;
	  case 0x0332:             mp=2;com=ENTER;break;
	 };
	if(mp!=mp1){
	 setcolor(RED);outtextxy(x,mwy+70+(mp-1)*38,menutexts[mp-1]);
	 setcolor(GREEN);outtextxy(x,mwy+70+(mp1-1)*38,menutexts[mp1-1]);
	}
   }
  return mp;
 }

 void PlayGame1(void){
 Level=1;
 Lives=5;
 Blasters=30;
 d_perc=50;
 r_nmb=4;
  do{
   if(GameResult==1){if(Level==MAXLEV){HappyEnd();return;}}
   d_perc-=2;
   SetLabir();
   GameResult=Game();
	switch(GameResult){
	 case -1:	Lives--;break;
	 case  1:	Level++;break;
	}
   r_nmb=4+Level/3;
  }while(Lives>=0);
  GameOver();
 }

 void ConstructLabir(void){
  int x,y;
   x=0;
	while(x++<GXS){
	 y=0;
	  while(y++<GYS){
	   if(random(100)<d_perc){
		Labir[x][y]=1;
	   }
		else
	   Labir[x][y]=0;
	  }
	}
   Labir[1][1]=0;Stations[1]=1;Stations[2]=1;
   Labir[GXS][1]=0;Stations[3]=20;Stations[4]=1;
   Labir[GXS][GYS]=0;Stations[5]=20;Stations[6]=10;
   Labir[1][GYS]=0;Stations[7]=1;Stations[8]=10;

   px=1+random(GXS/3);py=1+random(GYS-1);
   Labir[GXS-random(7)][random(GYS-1)+1]='e';
 }

 void OutGameScreen(void){
  int x,y,lo,hig;
  cleardevice();
  settextstyle(TRIPLEX_FONT,HORIZ_DIR,2);
  setcolor(YELLOW);rectangle(gwx-2,gwy-2,gwx+GXS*SXSIZE+1,gwy+GYS*SYSIZE+1);

  OutLives();
  OutNumBlast();
  OutLevel();

  y=gwy;
   x=0;
	while(x++<GXS){
	 y=0;
	  while(y++<GYS){
	   OutAnySymbol(x,y,Labir[x][y]);
	  }
	}
	settextstyle(TRIPLEX_FONT,HORIZ_DIR,2);
	lo=textwidth(tim);hig=textheight(tim);
	setcolor(GREEN);outtextxy(gwx,gwy-hig-5,tim);
	for(x=0;x<=StepLimit;x++){
	 setcolor(RED*(x<=30)+GREEN*(x>30));
	 line(lo+gwx+x*3,gwy-18,lo+gwx+x*3,gwy-5);
	 line(lo+gwx+x*3+1,gwy-18,lo+gwx+x*3+1,gwy-5);
	}
   }

 void SetLabir(void){
  int glf=0;
   do{
	ConstructLabir();
	glf=GoodLabir();
   }while(glf==0);
	SetRobo();
	StepLimit=STAND_LIMIT-Level*2;
	OutGameScreen();
 }

 int GoodLabir(void){
  int x,y;
   x=0;while(x++<GXS){y=0;while(y++<GYS){d_labir[x][y]=Labir[x][y];}}
	LabFlag=0;
	glr(px,py);
   return LabFlag;
 }

 void glr(int x,int y){
 if(LabFlag==1 || x<1 || x>GXS || y<1 || y>GYS)return;
  switch(d_labir[x][y]){
   case 1:		return;
   case	'e':	d_labir[x][y]='x';LabFlag=1;return;
   case 'x':	return;
  }
  d_labir[x][y]='x';
  glr(x-1,y-1);glr(x,y-1);glr(x+1,y-1);glr(x-1,y);
  glr(x+1,y);glr(x-1,y+1);glr(x,y+1);glr(x+1,y+1);
 }

 void SetRobo(void){
  int s=0,x,y;
   while(s++<r_nmb){
	x=random(GXS)+1;
	y=random(GYS)+1;
	 if(Labir[x][y]==1 || Labir[x][y]=='r' || Labir[x][y]=='e' || (x==px && y==py))s--;
	  else
	 {
	  Robo[s][1]=x;
	  Robo[s][2]=y;
	  Robo[s][3]=random(8);
	  Labir[x][y]='r';
	 }
   }
 }

 int Game(void){
  int px1,py1,sx,sy;
  int sym,lo;
  int Mflag=0,kb=0;
  int com=0;
  OutHero(px,py,2,0,0,COPY_PUT);
	while(1){
	 px1=px;py1=py;
	 com=GetKey();
	 Mflag=0;
	  switch(com&0xff00){
	   case LEFT	:px--;Mflag=1;break;
	   case RIGHT	:px++;Mflag=1;break;
	   case UP		:py--;Mflag=1;break;
	   case DOWN	:py++;Mflag=1;break;
	   case Home	:px--;py--;Mflag=1;break;
	   case End		:px--;py++;Mflag=1;break;
	   case PgUp	:px++;py--;Mflag=1;break;
	   case PgDn	:px++;py++;Mflag=1;break;
	   case F2		:Sound=!Sound;break;
	   case 0x0100		:closegraph();exit(EXIT_SUCCESS);
	  }
	 if(com&255 && Mflag){
	  sx=px;sy=py;
	  px=px1;py=py1;
	  MakeShoot(sx,sy);
	  Mflag=0;
	 }
	  else
	 {
	 if(px<1 || px>GXS)px=px1;
	 if(py<1 || py>GYS)py=py1;
	 sym=Labir[px][py];
	 switch(sym){
	 case 'r':	 	LightTo(px1,py1);
					Death();
					return -1;
	 case 1:        MoveHero(px,py,px1,py1);
					OutDeath(px,py);
					Death();
					return -1;
	 case 'e':		if(Level!=MAXLEV-1){
					MoveHero(px,py,px1,py1);
					EndOfLevel();
					}
					return 1;
	 }
	 if(Mflag)MoveHero(px,py,px1,py1);
	}
	 if(Mflag){
	 setcolor(0);
	 settextstyle(TRIPLEX_FONT,HORIZ_DIR,2);
     lo=textwidth(tim);
	  line(lo+gwx+StepLimit*3,gwy-18,lo+gwx+StepLimit*3,gwy-5);
	  line(lo+1+gwx+StepLimit*3,gwy-18,lo+1+gwx+StepLimit*3,gwy-5);
	  StepLimit--;
	  if(StepLimit<0){
	   Death();
	   return -1;
	  }
	  if(RoboMove()==-1){
	   LightTo(px,py);
	   Death();
	   return -1;
	  }
	 }
	}
   }

  int RoboMove(void){
   int x,y,x1,y1,s=0,s0,sym,station;
	while(s++<r_nmb){
	 x=Robo[s][1];x1=x;
	 y=Robo[s][2];y1=y;
	  x=x+Sign(px-x);
	  y=y+Sign(py-y);
	  sym=Labir[x][y];
	   if(x==px && y==py){
		OutRobot(x1,y1,VectoryToMove(x,y,x1,y1),0,0,COPY_PUT);
		return -1;
	   }
	   if(sym=='r' || sym=='e'){
		x=x1;
		y=y1;
	   }
		else
	   {
		MoveRobot(x,y,x1,y1,s);
	   if(sym==1){
		OutDeath(x,y);
		station=random(4)+1;
		x=Stations[station*2-1];
		y=Stations[station*2];
		Robo[s][3]=random(8);
		OutRobot(x,y,Robo[s][3],0,0,COPY_PUT);
	   }
	  Robo[s][1]=x;
	  Robo[s][2]=y;
	  Labir[x][y]='r';
	  Labir[x1][y1]=0;
	 }
	}
  }

  void MakeShoot(int x,int y){
   int sym,station,s1,vec;
   int s=0,rx,ry,rx1,ry1;
	if(!Blasters)return;
	Blasters--;
	OutNumBlast();
	 sym=Labir[x][y];
	  if(sym==1 || sym==0)return;
	 while(s++<r_nmb){
	  rx=Robo[s][1];rx1=rx;
	  ry=Robo[s][2];ry1=ry;
	   if(rx==x && ry==y){
        station=random(4)+1;
		rx=Stations[station*2-1];
		ry=Stations[station*2];
	  Robo[s][1]=rx;
	  Robo[s][2]=ry;
	  Robo[s][3]=random(8);
	  Labir[rx][ry]='r';
	  Labir[rx1][ry1]=0;

	 vec=VectoryToMove(rx1,ry1,px,py);
	  OutHero(px,py,vec,0,0,COPY_PUT);
	  curv1=vec;
	   OutBoom(rx1,ry1);
	   OutRobot(rx,ry,Robo[s][3],0,0,COPY_PUT);
	  }
	 }
  }

 void OutDeath(int x,int y){
  putimage(gwx+(x-1)*SXSIZE,gwy+(y-1)*SYSIZE,iHall,COPY_PUT);
 }

 void OutGround(int x,int y){
  putimage(gwx+(x-1)*SXSIZE,gwy+(y-1)*SYSIZE,iGround,COPY_PUT);
 }

 void OutHero(int x,int y,int vec,int xo,int yo,int put){
  putimage(gwx+(x-1)*SXSIZE+xo,gwy+(y-1)*SYSIZE+yo,iMans[vec],put);
 }

 void OutRobot(int x,int y,int vec,int xo,int yo,int put){
  putimage(gwx+(x-1)*SXSIZE+xo,gwy+(y-1)*SYSIZE+yo,iCyborgs[vec],put);
 }

 void OutExit(int x,int y){
  putimage(gwx+(x-1)*SXSIZE,gwy+(y-1)*SYSIZE,iExit,COPY_PUT);
 }

 void OutBoom(int x,int y){
  int s;
  for(s=0;s<200;s++){
   putpixel(gwx+(x-1)*SXSIZE+random(15),gwy+(y-1)*SYSIZE+random(15),0);
   sound(random(1000));
  }
  nosound();
  OutGround(x,y);
 }

 void LightTo(int x,int y){
  int c,r,cx,cy;
  cx=gwx+(x-1)*SXSIZE+SXSIZE/2;
  cy=gwy+(y-1)*SYSIZE+SYSIZE/2;
   for(c=WHITE;c>=0;c--){
	setcolor(c);
	for(r=0;r<SXSIZE/2;r++){
	 circle(cx,cy,r);
	}
   }
  OutGround(x,y);
 }

 void OutAnySymbol(int x,int y,int sym){
  switch(sym){
   case 1:		OutDeath(x,y);break;
   case 0:		OutGround(x,y);break;
   case 'e':	OutExit(x,y);break;
   case 'r':	OutRobot(x,y,random(8),0,0,COPY_PUT);break;
  }
 }

 void MoveHero(int x,int y,int x1,int y1){
  int vec,s,ax=0,ay=0,ax1,ay1;
  vec=VectoryToMove(x,y,x1,y1);
  OutHero(x1,y1,vec,0,0,COPY_PUT);
  curv1=vec;
   OutGround(x1,y1);
   OutHero(x,y,vec,0,0,XOR_PUT);
}

 void MoveRobot(int x,int y,int x1,int y1,int num){
  int vec,s,ax=0,ay=0,ax1,ay1,vec1;
  vec1=Robo[s][2];
  vec=VectoryToMove(x,y,x1,y1);
  OutGround(x1,y1);
  OutRobot(x,y,vec,0,0,COPY_PUT);
   Robo[s][3]=vec;
 }

 int VectoryToMove(int x,int y,int x1,int y1){
  int s,vx,vy;
   vx=x-x1;vy=y-y1;
	if(vx==0 && vy==-1)s=0;
	if(vx==1 && vy==-1)s=1;
	if(vx==1 && vy==0)s=2;
	if(vx==1 && vy==1)s=3;
	if(vx==0 && vy==1)s=4;
	if(vx==-1 && vy==1)s=5;
	if(vx==-1 && vy==0)s=6;
	if(vx==-1 && vy==-1)s=7;
  return s;
 }

 void OutLives(void){
  settextstyle(TRIPLEX_FONT,HORIZ_DIR,2);
  setcolor(GREEN);
  outtextxy(gwx+10,gwy+GYS*SYSIZE,"Lives : ");
  setcolor(RED);
  outtextxy(gwx+10+textwidth("Lives : "),gwy+GYS*SYSIZE,TextNum(Lives));
 }

 void OutNumBlast(void){
  settextstyle(TRIPLEX_FONT,HORIZ_DIR,2);
  setcolor(GREEN);
  outtextxy(gwx+10+textwidth(liv),gwy+GYS*SYSIZE,dest);
  setcolor(BLACK);
  outtextxy(gwx+10+textwidth(liv)+textwidth(dest),gwy+GYS*SYSIZE,TextNum(Blasters+1));
  setcolor(RED);
  outtextxy(gwx+10+textwidth(liv)+textwidth(dest),gwy+GYS*SYSIZE,TextNum(Blasters));
 }

 void OutLevel(void){
  int tmpx,tmpy;
  settextstyle(TRIPLEX_FONT,HORIZ_DIR,6);
  tmpx=(getmaxx()-textwidth("Room : ")-textwidth(TextNum(Level)))/2;
  tmpy=getmaxy()-2*textheight(" ");
   setcolor(YELLOW);outtextxy(tmpx,tmpy,"Room : ");
   setcolor(BLUE);outtextxy(tmpx+textwidth("Room : "),tmpy,TextNum(Level));
 }

 void Death(void){
  int x,y,len,h;
  x=gwx+SXSIZE*20/2;
  y=gwy+SYSIZE*10/2;
   settextstyle(TRIPLEX_FONT,HORIZ_DIR,4);
   len=textwidth(yhltl);
   h=textheight(" ");
   setfillstyle(1,BLACK);
   getimage(x-200,y-h,x+200,y+h,win);
   setcolor(YELLOW);
   bar(x-200,y-h,x+200,y+h);
   rectangle(x-200,y-h,x+200,y+h);
   TwoColorShadowText(x-len/2,y-h/2-6,RED,LIGHTBLUE,yhltl);
   Waitpress();
  putimage(x-200,y-textheight(" "),win,COPY_PUT);
 }

 void HappyEnd(void){
  int x,y,len,h;
  x=gwx+SXSIZE*20/2;
  y=gwy+SYSIZE*10/2;
   settextstyle(TRIPLEX_FONT,HORIZ_DIR,4);
   len=textwidth(cysa);
   h=textheight(" ");
   setfillstyle(1,BLACK);
	setcolor(YELLOW);
	 bar(x-300,y-h,x+300,y+h);
	 rectangle(x-300,y-h,x+300,y+h);
	ShadowText(x-len/2,y-h/2-6,GREEN,cysa);
  Waitpress();
  cleardevice();
 }

 void GameOver(void){
  int x,y,len,h;
  x=gwx+SXSIZE*20/2;
  y=gwy+SYSIZE*10/2;
   settextstyle(TRIPLEX_FONT,HORIZ_DIR,4);
   len=textwidth(gaov);
   h=textheight(" ");
   setfillstyle(1,BLACK);
	setcolor(YELLOW);
	 bar(x-150,y-h,x+150,y+h);
	 rectangle(x-150,y-h,x+150,y+h);
	TwoColorShadowText(x-len/2,y-h/2-6,RED,BLUE,gaov);
  Waitpress();
  cleardevice();
 }

 void EndOfLevel(void){
  int x,y,x1,x2,h,len,s,c=0;
  for(s=0;s<100;s++){
   OutHero(px,py,s%8,0,0,COPY_PUT);
   if(Sound)sound(s);
  }
   OutGround(px,py);
   nosound();
  x=gwx+SXSIZE*20/2;
  y=gwy+SYSIZE*10/2;
   settextstyle(TRIPLEX_FONT,HORIZ_DIR,4);
   len=textwidth(wttnl);
   h=textheight(" ");
   x1=x-len/2+textwidth("               ");
   x2=x1+textwidth("   ");
   setfillstyle(1,BLACK);
	setcolor(YELLOW);
	 bar(x-240,y-h,x+240,y+h);
	 rectangle(x-240,y-h,x+240,y+h);
	ShadowText(x-len/2,y-h/2-6,YELLOW,wttnl);
	ShadowText(x1,y-h/2-6,RED,TextNum(Level+1));
	ShadowText(x2,y-h/2-6,RED,EndOfNum(Level+1));
  Waitpress();
  cleardevice();
 }

 int Sign(double x){
  if(x<0)return -1;
  if(x>0)return  1;
  return 0;
 }

 char* TextNum(double numb){
  int s=3,serv;
   while(s--)tmpnum[s]=' ';
   if(numb==0){
	tmpnum[2]='0';
	tmpnum[3]='\0';
	return tmpnum;
   }
   s=2;
   serv=numb;
   while(serv){
	tmpnum[s--]=48+10*(numb/10-serv/10);
	serv=serv/10;
	numb=(int)(numb/10);
   }
   tmpnum[3]=0;
   return tmpnum;
 }

 void TwoColorShadowText(int x,int y,int tc,int sc,char* text){
  int c;
   c=getcolor();
	setcolor(sc);
	outtextxy(x+2,y+1,text);
	setcolor(tc);
	outtextxy(x,y,text);
	setcolor(c);
 }

 void ShadowText(int x,int y,int color,char* text){
  if(color<8)color+=8;
  setcolor(color-8);
  outtextxy(x+3,y+1,text);
  setcolor(color);
  outtextxy(x,y,text);
 }

 char* EndOfNum(int num){
  int serv;
  serv=num%10;
   if(serv>3 || (num<=13 && num>=11))return ends[0];
	else
   return ends[serv];
 }

 void ClearKBBufer(void){
  poke(0,0x41c,peek(0,0x41a));
 }

 unsigned GetKey(void){
   unsigned rv;
   asm{
     xor ax,ax
     int 16h
     mov [rv],ax
   }
   return rv;
 }

 int IsCtrl(void){
  return ((peek(0,0x417) & 4)==4);
 }

 int IsAlt(void){
  return((peek(0,0x417) & 8)==8);
 }

 int IsRightShift(void){
  return ((peek(0,0x417) & 1)==1);
 }

 int IsLeftShift(void){
  return ((peek(0,0x417) & 2)==2);
 }
