
;FLAGS, VARIABLES AND COUNTERS, ETC.
;Flag 0  Display CMD detail as it is being processed
;        enter DEBUG to toggle ON and OFF
;Flag 1  Bear is following if ON
;Flag 2  Bottle has liquid in it if ON, is empty if OFF
;Flag 3  Cave is closed if ON, open if OFF
;Flag 4  Troll has been paid off or frighten away if ON
;Flag 5  Lantern/Lamp is ON or OFF
;Flag 6  ON if it would be dark here if Lantern/Lamp is off
;Flag 7  ON if Lantern/Lamp has new set of batteries
;Flag 8  ON if crystal bridge currently exists
;Flag 9  NOT Using bare hands in attack if ON
;        also flag to indicate axe or knife is being thrown
;        also numerous temporary other uses
;Flag 10 Dwarf is in room if ON
;Flag 11 cardassian has stolen 'orbs' if ON
;Flag 12 Hint about location of cave has been offered if ON
;Flag 13 Toggle flag for different responses to GET BIRD
;Flag 14 Toggle flag for different commands about SNAKE
;Flag 15 Has angered programmer if ON
;Flag 16 Programmer has given secret word if ON
;Flag 17 Cave is in process of closing if ON
;Flag 18 cardassian has made two appearances if ON
;Flag 19 Hint about moving in mazes has been offered if ON
;Variable 1 count of turns Lamp's batteries will last
;Variable 2 count of FEE FIE FOE FOO words
;Variable 3 countdown until cave closes & master game begins

;TOGGLE DIAGNOSTIC MODE

COMMAND DEBUG
ToggleFlag 0
DoneWithTurn
END_

;AUTOMATIC COMMANDS

;Set FLAGS based on game or room status

COMMAND ANY
FlagOFF 7 ;first turn of game only - initialize conditions
TurnFlagON 7 ;new batteries
SetVariableTo 1 350 ;set of batteries last for 350 turns
SetVariableTo 2 0 ;set FEE FIE FOE FOO count to 0
TurnFlagON 2 ;bottle is now full
END_

COMMAND ANY
TurnFlagOFF 6
RoomNeedsLight
TurnFlagON 6 ;ON if room needs light, OFF otherwise
END_

COMMAND ANY
NOT Present 222 ;dwarf
Destroy 222 ;causes dwarf not to get left in another room
END_

COMMAND ANY
TurnFlagOFF 10 ;Dwarf is not in room
Present 202 ;lamp - dwarf can only be seen in light
Present 221 ;dwarf blocking way
OR
Present 222 ;dwarf
TurnFlagON 10 ;ON if dwarf in room, OFF otherwise
END_

;Commands to deal with lamp/light status and countdown

COMMAND ANY
FlagON 5 ;lamp is ON
SubtractFromVariable 1 1 ;countdown to zero when batteries are dead
END_

COMMAND ANY
FlagON 5 ;lamp is ON
VariableEquals 1 26 ;batteries almost dead
Present 202 ;lamp
BlankLine
PrintMessage 183 ;give hint about batteries
BlankLine
END_

COMMAND ANY
FlagON 5 ;lamp is ON
VariableLT 1 26 ;batteries almost dead
VariableGT 1 0
Present 202 ;lamp
BlankLine
PrintMessage 13 ;your lamp is growing weaker
BlankLine
END_

COMMAND ANY
VariableEquals 1 0 ;countdown to zero when batteries are dead
Present 202 ;lamp
PrintMessage 184 ;your lamp has gone out
TurnFlagOFF 5 ;Lamp is now OFF
SwapLocations 202 201 ;swap for OFF lamp
PrintMessage 185 ;no lamp - let's call it a day
GoToRoom 121 ;Loser's area
DoneWithTurn
END_

COMMAND ANY
FlagOFF 5 ;lamp is off
FlagON 6 ;room needs light
PrintMessage 16 ;now dark
NOT AtLocation 11 ;XYZZY location
NOT AtLocation 33 ;PLUGH location
NOT AtLocation 31 ;TURBO location
Chance 25
PrintMessage 23 ;you fell into a pit
GoToRoom 20 ;pit
MinusScore 10 ;lose 10 points for dying
SendToRoom 201 3 ;OFF lamp to building
Destroy 202
KillPlayer ;player is now dead
DoneWithTurn
END_

;Commands to deal with random cardassian activities

COMMAND ANY
Chance 5
AtLocationGT 15
AtLocationLT 115 ;most of cave area
PrintMessage 127 ;you hear a rustling noise behind you
BlankLine
FlagON 11 ;has stolen 'orbs' already
FlagOFF 18 ;hasn't made both appearances
IsNowhere 259 ;cardassian's 'orbs'
PrintMessage 186 ;cardassian goes to hide his 'orbs'
SendToRoom 259 142 ;cardassian's den
TurnFlagON 18 ;cardassian is now done
END_

COMMAND ANY
Chance 15
FlagOFF 11 ;hasn't stolen 'orbs' yet
AtLocationGT 15
AtLocationLT 115 ;most of cave area
NOT atLocation 100 ;plover room
NOT atLocation 101 ;soft room
IsCarrying'orbs' 5 ;carrying something worth more than 4 points
PrintMessage 128 ;cardassian steals your 'orbs'
TurnFlagON 11 ;has stolen it
Send'orbs'sToRoom 142 5 ;cardassian's den
END_

;Commands to deal with random dwarf attacks on player

COMMAND ANY
Chance 25
IsNowhere 237 ;axe
AtLocationGT 15
AtLocationLT 115 ;most of cave area
Present 202 ;lamp - dwarf can only be seen in light
PrintMessage 3 ;Dwarf throws axe
PutInCurrentRoom 237
LookAtRoom
DoneWithTurn
END_

COMMAND ANY
Chance 5
FlagOFF 10 ;no dwarf currently in room
AtLocationGT 15
AtLocationLT 115 ;most of cave area
NOT AtLocation 31 ;Programmer's Den
Present 202 ;lamp - dwarf can only be seen in light
PrintMessage 4 ;Dwarf is now in room
PutInCurrentRoom 221 ;dwarf blocking way
TurnFlagON 10 ;Dwarf is now here
END_

COMMAND ANY
Chance 5
FlagOFF 10 ;no dwarf currently in room
AtLocationGT 15
AtLocationLT 115 ;most of cave area
NOT AtLocation 31 ;Programmer's Den
Present 202 ;lamp - dwarf can only be seen in light
PrintMessage 4 ;Dwarf is now in room
PutInCurrentRoom 222 ;dwarf
TurnFlagON 10 ;Dwarf is now here
END_

COMMAND ANY
VerbIsDirection ;player trying to move out of room
Present 221 ;dwarf blocking way
Present 202 ;lamp - dwarf can only be seen in light
PrintMessage 2 ;Dwarf blocks your way
DoneWithTurn
END_

COMMAND ANY
FlagON 10 ;dwarf currently in room
Chance 34
Present 202 ;lamp - dwarf can only be seen in light
TurnFlagON 9 ;a knife is being thrown
PrintMessage 5 ;Dwarf throws knife
Chance 60
PrintMessage 6 ;knife misses by inches
TurnFlagOFF 9 ;knife no longer being thrown
END_

COMMAND ANY
FlagON 9 ;knife was thrown
IsWearing 275 ;magic cloak
PrintMessage 9 ;knife bounces off cloak
TurnFlagOFF 9 ;knife no longer being thrown
END_

COMMAND ANY
FlagON 9 ;knife was thrown AND not wearing cloak
PrintMessage 7 ;knife gets you
TurnFlagOFF 9 ;knife no longer being thrown
MinusScore 10 ;lose 10 points for dying
SendToRoom 201 3 ;OFF lamp to building
Destroy 202
KillPlayer
DoneWithTurn
END_

;Commands to close cave

COMMAND ANY
ScoreGT 271 ;got all but 1 'orbs'
FlagOFF 3 ;cave still open
FlagOFF 17 ;haven't starting to close yet
SetVariableTo 3 31 ;30 turns until master game
LockIt 203 ;grate
CloseIt 203
Destroy 200 ;keys
SendToRoom 215 17 ;crystal bridge
SendToRoom 287 27 ;other crystal bridge
Destroy 216 ;phoney bridge
Destroy 245 ;phoney troll
Destroy 244 ;troll
Destroy 243 ;bridge wreck
END_

;Continuation of previous command
COMMAND ANY
ScoreGT 271 ;got all but 1 'orbs'
FlagOFF 3 ;cave still open
FlagOFF 17 ;haven't starting to close yet
TurnFlagON 17 ;now we have
SendToRoom 241 117 ;troll bridge
Destroy 246 ;bear
Destroy 247 ;bear
Destroy 248 ;bear
PlusScore 20
PrintMessage 129 ;Cave closing soon
IsNowhere 272 ;chain
SendToRoom 272 130 ;put it in Barren room
END_

COMMAND ANY
FlagON 17 ;closing
SubtractFromVariable 3 1 ;subtract 1 from closing countdown
VariableGT 3 0
VariableLT 3 29
BlankLine
PrintMessage 17 ;Cave closes in #VAR3# turns
BlankLine
END_

COMMAND ANY
FlagON 17 ;closing
VariableEquals 3 0 ;countdown has reached zero
Send'orbs'sToRoom 3 5 ;send carried 'orbs's to 'orbs' room
SendAllToRoom 0 ;destroy all other carried items
SetVariableTo 1 50 ;lamp will be one for 50 turns
BlankLine
PrintMessage 132 ;Cave is now closed
BlankLine
END_

;Continuation of previous command
COMMAND ANY
FlagON 17 ;closing
VariableEquals 3 0 ;countdown has reached zero
SendToRoom 226 115 ;empty bottle
SendToRoom 229 115 ;tiny plant
SendToRoom 219 115 ;oyster
SendToRoom 202 115 ;lamp - ON
SendToRoom 205 115 ;black rod
SendToRoom 228 115 ;mirror
END_

;Continuation of previous command
COMMAND ANY
FlagON 17 ;closing
VariableEquals 3 0 ;countdown has reached zero
SendToRoom 203 116 ;locked grate
SendToRoom 214 116 ;snake
SendToRoom 213 116 ;pillow
SendToRoom 210 116 ;bird in cage
SendToRoom 206 116 ;red rod
END_

;Continuation of previous command
COMMAND ANY
FlagON 17 ;closing
VariableEquals 3 0 ;countdown has reached zero
TurnFlagON 3 ;Cave is now closed
TurnFlagOFF 17
RemoveEverything
GoToRoom 115
PlusScore 10
DoneWithTurn
END_

;Commands to deal with other random activities

COMMAND ANY
FlagON 1 ;bear following
PutInCurrentRoom 248 ;contented bear
END_

COMMAND ANY
AtLocation 33 ;Y2 room
Chance 25
PrintMessage 8 ;you hear a voice say "PLUGH"
END_

COMMAND ANY
AtLocation 33 ;Y2 room
Chance 15
PrintMessage 139 ;you hear a voice say "PLOVER"
END_

COMMAND ANY
NOT atLocation 117 ;one side of troll bridge
NOT atLocation 122 ;other side
Destroy 244 ;troll
Destroy 245 ;phoney troll
TurnFlagOFF 4 ;troll can now appear when you try to cross bridge
END_

COMMAND ANY
NOT atLocation 17 ;one side
NOT atLocation 27 ;other side
Destroy 216 ;phoney bridge
END_

;Commands to offer and give HINTS

COMMAND ANY
FlagOFF 12 ;hint has not been offered yet
AtLocation 5 ;forest
OR
AtLocation 6 ;forest
TurnFlagON 12 ;now it has
PrintMessage 62 ;are you trying to get in cave?
PromptForYes
PrintMessage 175 ;Do you want a hint?
PromptForYes
TurnFlagON 9 ;hint has been rejected - so far
PrintMessage 143 ;The hint will cost your 5 points
PrintMessage 1 ;Is that OK?
PromptForYes
TurnFlagOFF 9 ;hint has been accepted
PrintMessage 57 ;Follow the stream
MinusScore 5
DoneWithTurn
END_

;Direction commands

;BEAR related

COMMAND ANY
VerbIsDirection
FlagON 1 ;contented bear
PrintMessage 141 ;you are being followed by the bear
END_

;CLAM/OYSTER related

COMMAND ANY
VerbIsDirection
IsCarrying 218 ;clam
FlagOFF 3 ;cave is open
PrintMessage 118 ;clam won't fit through passage
DoneWithTurn
END_

COMMAND ANY
VerbIsDirection
IsCarrying 219 ;oyster
FlagOFF 3 ;cave is open
PrintMessage 119 ;oyster won't fit through passage
DoneWithTurn
END_

;DRAGON related

COMMAND ANY
InRoom 239 ;dragon
VerbIsDirection
PrintMessage 153 ;Dragon won't let you
DoneWithTurn
END_

;Witt's End related

COMMAND ANY
AtLocation 108 ;Witt's End
VerbIsDirection
PrintMessage 126 ;back where you started
END_

COMMAND EAST
AtLocation 108 ;Witt's End
Chance 20
PrintMessage 151 ;You find your way out
GoToRoom 106 ;Anti-Room
DoneWithTurn
END_

;Bedquilt related

COMMAND NORTH
AtLocation 65 ;Bedquilt
Chance 33
GoToRoom 70
DoneWithTurn
END_

COMMAND NORTH
AtLocation 65 ;Bedquilt
Chance 50
GoToRoom 71
DoneWithTurn
END_

COMMAND NORTH
AtLocation 65 ;Bedquilt
GoToRoom 72
DoneWithTurn
END_

COMMAND UP
AtLocation 65 ;Bedquilt
PrintMessage 126 ;back where you started
DoneWithTurn
END_

;NUGGET related

COMMAND UP
AtLocation 15 ;hall of Mists
IsCarrying 254 ;nugget
PrintMessage 25 ;You can't be serious
PrintMessage 201 ;The dome is unclimbable
DoneWithTurn
END_

;CRYSTAL BRIDGE related

COMMAND WEST
AtLocation 17 ;East side of fissure
NOT InRoom 215 ;crystal bridge
PrintMessage 97 ;No way across the fissure
DoneWithTurn
END_

COMMAND EAST
AtLocation 27 ;West side of fissure
NOT InRoom 287 ;crystal bridge
PrintMessage 97 ;No way across the fissure
DoneWithTurn
END_

;SNAKE related

COMMAND NORTH
InRoom 214 ;snake
PrintMessage 20 ;That's unsafe
DoneWithTurn
END_

COMMAND WEST
InRoom 214 ;snake
PrintMessage 20 ;That's unsafe
DoneWithTurn
END_

COMMAND SOUTH
InRoom 214 ;snake
PrintMessage 20 ;That's unsafe
DoneWithTurn
END_

COMMAND DOWN
InRoom 214 ;snake
PrintMessage 20 ;That's unsafe
DoneWithTurn
END_

;PLANT related

COMMAND DOWN
InRoom 233 ;gigantic beanstalk
PrintMessage 51 ;You climb down
GoToRoom 25 ;west pit
DoneWithTurn
END_

;GRATE related

COMMAND DOWN
AtLocation 8 ;above grate
IsOpen 203 ;grate
GoToRoom 9
DoneWithTurn
END_

COMMAND ENTER
AtLocation 8 ;above grate
IsOpen 203 ;grate
GoToRoom 9
DoneWithTurn
END_

COMMAND UP
AtLocation 9 ;below grate
IsOpen 203 ;grate
GoToRoom 8
DoneWithTurn
END_

COMMAND UP
AtLocation 9 ;below grate
IsClosed 203 ;grate
PrintMessage 130 ;This exit is closed
DoneWithTurn
END_

;Programmer's Den related

COMMAND SOUTH
AtLocation 31 ;programmer's den
FlagOFF 15 ;programmer is not angry
FlagOFF 16 ;programmer has not given his secret word
TurnFlagON 16 ;give secret word
PrintMessage 212
DoneWithTurn
END_

;DOOR related

COMMAND NORTH
InRoom 211 ;closed rusty door
PrintMessage 111 ;It refuses to open
PrintMessage 113 ;hinges are too rusty
DoneWithTurn
END_

;TROLL related

COMMAND NORTHEAST
FlagOFF 17 ;Cave still open
AtLocation 117 ;one side of troll bridge
InRoom 241 ;troll bridge
FlagOFF 4 ;troll can now appear when you try to cross bridge
NOT InRoom 244 ;troll
PutInCurrentRoom 244
PrintMessage 10 ;Troll appears
DoneWithTurn
END_

COMMAND NORTHEAST
FlagOFF 17 ;Cave still open
AtLocation 117 ;one side of troll bridge
InRoom 241 ;troll bridge
InRoom 244 ;troll
PrintMessage 160 ;Troll refuses to let you cross
DoneWithTurn
END_

COMMAND NORTHEAST
FlagOFF 17 ;Cave still open
AtLocation 117 ;one side of troll bridge
InRoom 243 ;wreckage of bridge
PrintMessage 161 ;no longer any way to cross
DoneWithTurn
END_

COMMAND NORTHEAST
FlagOFF 17 ;Cave still open
Present 245 ;phony troll
AtLocation 117 ;one side of troll bridge
GoToRoom 122 ;other side
PutInCurrentRoom 245 ;phony troll
PutInCurrentRoom 241 ;troll bridge
PrintMessage 53 ;You cross
DoneWithTurn
END_

COMMAND SOUTHWEST
FlagOFF 17 ;Cave still open
Present 245 ;phony troll
AtLocation 122 ;one side of troll bridge
GoToRoom 117 ;other side
PutInCurrentRoom 245 ;phony troll
PutInCurrentRoom 241 ;troll bridge
PrintMessage 53 ;You cross
DoneWithTurn
END_

COMMAND SOUTHWEST
FlagOFF 17 ;Cave still open
AtLocation 122 ;one side of troll bridge
InRoom 241 ;troll bridge
NOT InRoom 244 ;troll
FlagOFF 4 ;troll can now appear when you try to cross bridge
PutInCurrentRoom 244
PrintMessage 10 ;Troll appears
DoneWithTurn
END_

COMMAND SOUTHWEST
FlagOFF 17 ;Cave still open
AtLocation 122 ;one side of troll bridge
InRoom 241 ;troll bridge
InRoom 244 ;troll
PrintMessage 160 ;Troll refuses to let you cross
DoneWithTurn
END_

COMMAND SOUTHWEST
InRoom 241 ;troll bridge
FlagON 1 ;bear is following you
PrintMessage 162 ;bridge buckles under weight of bear
Destroy 241 ;troll bridge
Destroy 244 ;troll
Destroy 245 ;phony troll
Destroy 248 ;bear
TurnFlagOFF 1 ;bear no longer following you
SendToRoom 243 117 ;bridge wreckage
GoToRoom 20 ;pit
MinusScore 10
SendToRoom 201 3 ;OFF lamp to building
Destroy 202
KillPlayer
DoneWithTurn
END_

;Plover Room related

COMMAND WEST
AtLocation 100 ;Plover
IsCarrying 266 ;emerald
LoadWeightEquals 13 ;only carrying emerald
PrintMessage 60 ;You squeeze into next room
GoToRoom 99 ;alcove
DoneWithTurn
END_

COMMAND WEST
AtLocation 100 ;Plover
IsCarryingNothing
GoToRoom 99 ;alcove
PrintMessage 60 ;You squeeze into next room
DoneWithTurn
END_

COMMAND WEST
AtLocation 100 ;Plover
IsCarryingSomething
PrintMessage 117 ;Something you are carrying won't fit
DoneWithTurn
END_

COMMAND EAST
AtLocation 99 ;alcove
IsCarryingNothing
GoToRoom 100 ;plover
PrintMessage 60 ;You squeeze into next room
DoneWithTurn
END_

COMMAND EAST
AtLocation 99 ;alcove
IsCarryingSomething
PrintMessage 117 ;Something you are carrying won't fit
DoneWithTurn
END_

;MAGIC words

;TURBO

COMMAND TURBO
FlagOFF 17 ;cave open
FlagON 16 ;programmer has given secret word
FlagOFF 15 ;programmer not angry
AtLocation 31 ;programmer's den
PrintMessage 61 ;transported to...
GoToRoom 3 ;Inside Building
DoneWithTurn
END_

COMMAND TURBO
FlagOFF 17 ;cave open
FlagON 16 ;programmer has given secret word
FlagOFF 15 ;programmer not angry
AtLocation 3 ;in building
GoToRoom 31 ;programmer's den
PrintMessage 61 ;transported to...
DoneWithTurn
END_

COMMAND TURBO
FlagON 15 ;programmer is angry
PrintMessage 214 ;word has been revoked
DoneWithTurn
END_

COMMAND TURBO
PrintMessage 12 ;word doesn't work here
DoneWithTurn
END_

;XYZZY

COMMAND XYZZY
FlagOFF 17 ;cave open
AtLocation 11 ;XYZZY area
PrintMessage 61 ;transported to...
GoToRoom 3 ;Inside Building
DoneWithTurn
END_

COMMAND XYZZY
FlagOFF 17 ;cave open
AtLocation 3 ;in building
PrintMessage 61 ;transported to...
GoToRoom 11 ;XYZZY area
DoneWithTurn
END_

COMMAND XYZZY
PrintMessage 12 ;word doesn't work here
DoneWithTurn
END_

;PLUGH

COMMAND PLUGH
FlagOFF 17 ;cave open
FlagOFF 15 ;programmer not angry
AtLocation 33 ;Y2 room
PrintMessage 61 ;transported to...
GoToRoom 3 ;Inside Building
DoneWithTurn
END_

COMMAND PLUGH
FlagOFF 17 ;cave open
FlagOFF 15 ;programmer not angry
AtLocation 3 ;in building
PrintMessage 61 ;transported to...
GoToRoom 33 ;Y2
DoneWithTurn
END_

COMMAND PLUGH
FlagON 15 ;programmer is angry
PrintMessage 214 ;word has been revoked
DoneWithTurn
END_

COMMAND PLUGH
PrintMessage 12 ;word doesn't work here
DoneWithTurn
END_

;PLOVER/BUILDING

COMMAND PLOVER
FlagOFF 17 ;cave open
AtLocation 100 ;Plover
NOT IsCarrying 266 ;emerald
PrintMessage 61 ;transported to...
GoToRoom 33 ;Y2
DoneWithTurn
END_

COMMAND PLOVER
FlagOFF 17 ;cave open
AtLocation 100 ;Plover
IsCarrying 266 ;emerald
DropIt 266
PrintMessage 61 ;transported to...
GoToRoom 33 ;Y2
DoneWithTurn
END_

COMMAND PLOVER
FlagOFF 17 ;cave open
AtLocation 33 ;Y2
PrintMessage 61 ;transported to...
GoToRoom 100 ;Plover room
DoneWithTurn
END_

COMMAND PLOVER
AtLocation 101
OR
AtLocation 99
GoToRoom 100 ;Plover room
DoneWithTurn
END_

COMMAND BUILDING
AtLocation 2
OR
AtLocation 4
OR
AtLocation 7
OR
AtLocation 85
PrintMessage 188
GoToRoom 141 ;In front of building
DoneWithTurn
END_

COMMAND PLOVER
PrintMessage 12 ;word doesn't work here
DoneWithTurn
END_

;FOREST

COMMAND FOREST
AtLocation 2
OR
AtLocation 4
OR
AtLocation 7
OR
AtLocation 8
OR
AtLocation 5
OR
AtLocation 141
PrintMessage 188
GoToRoom 6 ;forest
DoneWithTurn
END_

COMMAND FOREST
PrintMessage 12 ;word doesn't work here
DoneWithTurn
END_

;SLAB/STREAMBED/SLIT

COMMAND SLAB
AtLocation 23
OR
AtLocation 65
OR
AtLocation 69
OR
AtLocation 64
PrintMessage 188
GoToRoom 68 ;SLAB
DoneWithTurn
END_

COMMAND STREAMBED
AtLocation 2
OR
AtLocation 4
OR
AtLocation 141
OR
AtLocation 8
OR
AtLocation 5
PrintMessage 188
GoToRoom 7 ;STREAMBED or SLIT
DoneWithTurn
END_

COMMAND SLAB
PrintMessage 12 ;word doesn't work here
DoneWithTurn
END_

;BEDQUILT/HILL

COMMAND BEDQUILT
AtLocation 33
OR
AtLocation 36
OR
AtLocation 39
OR
AtLocation 64
OR
AtLocation 72
PrintMessage 188
GoToRoom 65 ;BEDQUILT
DoneWithTurn
END_

COMMAND HILL
AtLocation 7
OR
AtLocation 4
OR
AtLocation 141
OR
AtLocation 8
PrintMessage 188
GoToRoom 2 ;HILL
DoneWithTurn
END_

COMMAND BEDQUILT
PrintMessage 12 ;word doesn't work here
DoneWithTurn
END_

;ORIENTAL/VALLEY

COMMAND ORIENTAL
AtLocation 66
OR
AtLocation 72
OR
AtLocation 98
PrintMessage 188
GoToRoom 97 ;ORIENTAL
DoneWithTurn
END_

COMMAND VALLEY
AtLocation 2
OR
AtLocation 141
OR
AtLocation 8
OR
AtLocation 7
PrintMessage 188
GoToRoom 4 ;VALLEY
DoneWithTurn
END_

COMMAND ORIENTAL
PrintMessage 12 ;word doesn't work here
DoneWithTurn
END_

;GIANT/BARREN

COMMAND GIANT
AtLocation 88
OR
AtLocation 93
OR
AtLocation 94
OR
AtLocation 95
PrintMessage 188
GoToRoom 92 ;GIANT
DoneWithTurn
END_

COMMAND BARREN
AtLocation 122
OR
AtLocation 123
OR
AtLocation 124
OR
AtLocation 128
OR
AtLocation 129
PrintMessage 188
GoToRoom 130 ;BARREN
DoneWithTurn
END_

COMMAND GIANT
PrintMessage 12 ;word doesn't work here
DoneWithTurn
END_

;SHELL/DEPRESSION

COMMAND SHELL
AtLocation 64
OR
AtLocation 102
OR
AtLocation 104
OR
AtLocation 105
PrintMessage 188
GoToRoom 103 ;SHELL
DoneWithTurn
END_

COMMAND DEPRESSION
AtLocation 2
OR
AtLocation 141
OR
AtLocation 4
OR
AtLocation 7
PrintMessage 188
GoToRoom 8 ;DEPRESSION
DoneWithTurn
END_

COMMAND SHELL
PrintMessage 12 ;word doesn't work here
DoneWithTurn
END_

;RUB/TOUCH/PUSH

COMMAND RUB LAMP
PrintMessage 75 ;rubbing the lamp is not particularly rewarding
DoneWithTurn
END_

COMMAND TOUCH ANY
AtLocation 31 ;programmer's den
TurnFlagOFF 16 ;revoke secret words
TurnFlagON 15 ;programmer is now angry
PrintMessage 213 ;programmer takes revenge
MinusScore 25 ;That will teach you
GoToRoom 44 ;cardassian's maze - just south of cardassian's den
DoneWithTurn
END_

COMMAND RUB ANY
PrintMessage 76 ;strange - nothing happens
DoneWithTurn
END_

;FIND

COMMAND FIND KNIFE
PrintMessage 116 ;dwarf's knife vanishes
DoneWithTurn
END_

COMMAND FIND ANY
NOUNIsCarrying
PrintMessage 24 ;You already have it
DoneWithTurn
END_

COMMAND FIND ANY
FlagON 3 ;cave is closed
PrintMessage 138 ;It must be around here somewhere
DoneWithTurn
END_

COMMAND FIND DWARF
FlagON 10 ;dwarf in room
PrintMessage 94 ;It is here with you
DoneWithTurn
END_

COMMAND FIND CAVE
FlagOFF 12 ;hint has not been offered yet
TurnFlagON 12 ;now it has
PrintMessage 175 ;Do you want a hint?
PromptForYes
TurnFlagON 9 ;hint has been rejected - so far
PrintMessage 143 ;The hint will cost your 5 points
PrintMessage 1 ;Is that OK?
PromptForYes
TurnFlagOFF 9 ;hint has been accepted
PrintMessage 57 ;Follow the stream
MinusScore 5
DoneWithTurn
END_

COMMAND FIND CAVE
FlagON 9 ;hint was rejected
TurnFlagOFF 9
PrintMessage 86 ;OK, if you're so smart - do it yourself
DoneWithTurn
END_

COMMAND FIND ANY
PrintMessage 59 ;Sorry, I can't tell you where remote things are
DoneWithTurn
END_

;GET

COMMAND GET ANY
AtLocation 31 ;programmer's den
TurnFlagOFF 16 ;revoke secret words
TurnFlagON 15 ;programmer is angry
PrintMessage 213 ;programmer talks of revenge
MinusScore 25 ;That will teach you
GoToRoom 44 ;cardassian's maze - just south of cardassian's den
DoneWithTurn
END_

COMMAND GET MIRROR
PrintMessage 148 ;Too far to reach
DoneWithTurn
END_

COMMAND GET SIGN
PrintMessage 11 ;voice booms out "Leave it alone"
DoneWithTurn
END_


COMMAND GET KNIFE
FlagON 10 ;dwarf here
PrintMessage 99 ;dwarf has it
DoneWithTurn
END_

COMMAND GET KNIFE
PrintMessage 116 ;dwarf's knife vanishes
DoneWithTurn
END_

COMMAND GET PLANT
PrintMessage 115 ;the plant's roots are too deep
DoneWithTurn
END_

COMMAND GET BEAR
InRoom 248 ;contented free bear
PrintMessage 54 ;bear will follow you anywhere
TurnFlagON 1 ;bear is following
DoneWithTurn
END_

COMMAND GET BEAR
AtLocation 130 ;barren room
PrintMessage 169 ;bear is still chained to wall
DoneWithTurn
END_

COMMAND GET WATER
FlagON 2 ;bottle is already full
PrintMessage 105 ;it is already full
DoneWithTurn
END_

COMMAND GET WATER
NOT Present 226 ;empty bottle
PrintMessage 104 ;you have nothing to put it in
DoneWithTurn
END_

COMMAND GET WATER
AtLocation 3 ;inside building
OR
AtLocation 4 ;valley by stream
OR
AtLocation 38 ;bottom of pit with stream
OR
AtLocation 95 ;cavern with waterfall
OR
AtLocation 113 ;reservoir
OR
AtLocation 141 ;by building
PrintMessage 107 ;bottle is now full of water
SwapLocations 226 225 ;swap empty bottle for water-filled
TurnFlagON 2 ;bottle is now full
DoneWithTurn
END_

COMMAND GET WATER
Present 226 ;empty bottle
PrintMessage 106 ;no water here
DoneWithTurn
END_

COMMAND GET OIL
FlagON 2 ;bottle is already full
PrintMessage 105 ;it is already full
DoneWithTurn
END_

COMMAND GET OIL
NOT Present 226 ;empty bottle
PrintMessage 104 ;you have nothing to put it in
DoneWithTurn
END_

COMMAND GET OIL
AtLocation 24 ;east pit of twopit room
PrintMessage 108 ;bottle is now full of oil
SwapLocations 226 227 ;swap empty bottle for oil-filled
TurnFlagON 2 ;bottle is now full
DoneWithTurn
END_

COMMAND GET OIL
Present 226 ;empty bottle
PrintMessage 106 ;no oil here
DoneWithTurn
END_

COMMAND GET BIRD
InRoom 209 ;little bird
FlagOFF 13 ;first time tried to GET BIRD
IsCarrying 205 ;black rod
PrintMessage 26 ;bird is afraid of you
TurnFlagON 13 ;now has tried to GET BIRD once
DoneWithTurn
END_

COMMAND GET BIRD
InRoom 209 ;little bird
FlagON 13 ;second time tried to GET BIRD
IsCarrying 205 ;black rod
PrintMessage 19 ;bird is scared now - try again later
TurnFlagOFF 13 ;toggle back to first response
DoneWithTurn
END_

COMMAND GET BIRD
InRoom 209 ;little bird
NOT IsCarrying 204 ;cage
PrintMessage 27 ;you can't carry the bird
DoneWithTurn
END_

COMMAND GET BIRD
InRoom 209 ;little bird
IsCarrying 204 ;cage
PrintMessage 79 ;You put it in cage
SwapLocations 204 210 ;cage now has bird in it
Destroy 209 ;bird
DoneWithTurn
END_

COMMAND GET CAGE
Present 210 ;caged bird
GetIt 210
PrintMessage 43 ;You have the cage and the bird
DoneWithTurn
END_

COMMAND GET RUG
Present 239 ;dragon blocking way
PrintMessage 153 ;Better not try it
DoneWithTurn
END_

COMMAND GET AXE
Present 239 ;dragon blocking way
InRoom 237 ;axe
PrintMessage 153 ;Better not try it
DoneWithTurn
END_

COMMAND GET AXE
Present 246 ;ferocious bear
InRoom 237 ;axe
PrintMessage 25 ;You can't be serious
DoneWithTurn
END_

COMMAND GET VASE
InRoom 264 ;pillow rug with vase on it
GetIt 263 ;ming vase
SwapLocations 213 264 ;pillow swaps for pillow with vase on it
PrintMessage 90 ;You get it
DoneWithTurn
END_

COMMAND GET PILLOW
InRoom 264 ;pillow rug with vase on it
GetIt 213 ;pillow
Destroy 264
PutInCurrentRoom 265 ;shards
PrintMessage 91 ;vase slips and breaks
LookAtRoom
DoneWithTurn
END_

;PUT

COMMAND PUT BIRD IN CAGE
ReDirectTo GET BIRD
END_

COMMAND PUT BIRD
InRoom 209 ;little bird
PrintMessage 110 ;Don't be silly
DoneWithTurn
END_

COMMAND PUT ANY IN CAGE
PrintMessage 222 ;This is a BIRD cage!
DoneWithTurn
END_

COMMAND PUT WATER IN BOTTLE
ReDirectTo GET WATER
END_

COMMAND PUT OIL IN BOTTLE
ReDirectTo GET OIL
END_

COMMAND PUT OIL
ReDirectTo POUR OIL
END_

COMMAND PUT WATER
ReDirectTo POUR WATER
END_

COMMAND PUT COINS IN MACHINE
InRoom 250 ;vending machine
Present 258 ;rare coins
PutInCurrentRoom 251 ;fresh batteries
Destroy 258 ;rare coins
PrintMessage 82 ;batteries fall out
DoneWithTurn
END_

COMMAND PUT BATTERIES IN LAMP
Present 251 ;fresh batteries
Present 201 ;unlit lamp
OR
Present 202 ;lamp
PutInCurrentRoom 252 ;worn-out batteries
PutInCurrentRoom 202 ;lamp
Destroy 201
Destroy 251 ;fresh batteries
PrintMessage 39 ;lamp is now on
SetVariableTo 1 350 ;new life in batteries
TurnFlagON 5 ;Lamp is now ON
LookAtRoom
DoneWithTurn
END_

COMMAND PUT BATTERIES IN LAMP
NOT Present 251 ;fresh batteries
PrintMessage 37 ;sorry, but you need fresh batteries
DoneWithTurn
END_

;DROP/POUR/INSERT/CHANGE

COMMAND DROP MAGAZINE
AtLocation 108 ;Witt's end
Present 220 ;magazine
Destroy 220 ;magazine
PrintMessage 15 ;it disappears
PlusScore 1
DoneWithTurn
END_

COMMAND DROP OIL
AtLocation 25 ;room with plant
Present 227 ;bottle of oil
SwapLocations 227 226 ;swap for empty bottle
PrintMessage 112 ;plant doesn't like oil
TurnFlagOFF 2 ;bottle is now empty
DoneWithTurn
END_

COMMAND DROP OIL
InRoom 211 ;rusty door
Present 227 ;bottle of oil
SwapLocations 227 226 ;swap for empty bottle
PrintMessage 114 ;oil has freed up door - so it can open
SwapLocations 211 212 ;swap for open door
PlusScore 10
DoneWithTurn
END_

COMMAND DROP OIL
Present 227 ;bottle of oil
SwapLocations 227 226 ;swap for empty bottle
PrintMessage 77 ;bottle is empty and ground is wet
PrintMessage 70 ;your feet are now wet
TurnFlagOFF 2 ;bottle is now empty
DoneWithTurn
END_

COMMAND POUR WATER
InRoom 231 ;gigantic beanstalk
Present 225 ;bottle of water
SwapLocations 225 226 ;swap for empty bottle
PrintMessage 209 ;plant dies and disappears
TurnFlagOFF 2 ;bottle is now empty
Destroy 231 ;gigantic beanstalk
Destroy 233 ;gigantic beanstalk in room 88
MinusScore 15
DoneWithTurn
END_

COMMAND POUR WATER
InRoom 230 ;12-foot beanstalk
Present 225 ;bottle of water
SwapLocations 225 226 ;swap for empty bottle
SwapLocations 231 230 ;swap for larger plant
SendToRoom 233 88 ;plant sticking out of pit into room 88
Destroy 232 ;plant sticking out of pit into room 23
PrintMessage 208 ;plant grows explosively
TurnFlagOFF 2 ;bottle is now empty
PlusScore 4
DoneWithTurn
END_

COMMAND POUR WATER
InRoom 229 ;tiny plant
Present 225 ;bottle of water
SwapLocations 225 226 ;swap for empty bottle
SwapLocations 229 230 ;swap for larger plant
SendToRoom 232 23 ;plant sticking out of pit into room 23
PrintMessage 207 ;plant grows for a spurt
TurnFlagOFF 2 ;bottle is now empty
PlusScore 5
DoneWithTurn
END_

COMMAND POUR WATER
Present 225 ;bottle of water
SwapLocations 225 226 ;swap for empty bottle
PrintMessage 77 ;bottle is empty and ground is wet
PrintMessage 70 ;your feet are now wet
TurnFlagOFF 2 ;bottle is now empty
DoneWithTurn
END_

COMMAND DROP VASE
InRoom 213 ;pillow
Present 263 ;ming vase
SwapLocations 213 264 ;pillow swaps for pillow with vase on it
Destroy 263 ;ming vase
PrintMessage 211 ;vase drop with delicate crash
PrintMessage 44 ;but, it doesn't break
DoneWithTurn
END_

COMMAND DROP VASE
NOT InRoom 213 ;pillow
Present 263 ;ming vase
Destroy 263 ;ming vase
PutInCurrentRoom 265 ;pottery shards
PrintMessage 211 ;vase drop with delicate crash
LookAtRoom
DoneWithTurn
END_

COMMAND DROP CAGE
IsCarrying 210 ;caged bird
DropIt 210
PrintMessage 58 ;You drop the cage and the bird
DoneWithTurn
END_

COMMAND INSERT COINS
InRoom 250 ;vending machine
Present 258 ;rare coins
PutInCurrentRoom 251 ;fresh batteries
Destroy 258 ;rare coins
PrintMessage 82 ;batteries fall out
DoneWithTurn
END_

COMMAND INSERT BATTERIES
Present 251 ;fresh batteries
Present 201 ;unlit lamp
OR
Present 202 ;lamp
PutInCurrentRoom 252 ;worn-out batteries
PutInCurrentRoom 202 ;lamp
Destroy 201
Destroy 251 ;fresh batteries
PrintMessage 39 ;lamp is now on
SetVariableTo 1 350 ;new life in batteries
TurnFlagON 5 ;Lamp is now ON
LookAtRoom
DoneWithTurn
END_

COMMAND INSERT BATTERIES
NOT Present 251 ;fresh batteries
PrintMessage 37 ;sorry, but you need fresh batteries
DoneWithTurn
END_

;RELEASE/FREE

COMMAND RELEASE BEAR
InRoom 244 ;troll
Present 248 ;contented free bear
SwapLocations 244 245 ;troll is nowhere to be seen
PrintMessage 163 ;bear chases troll away
TurnFlagON 4 ;troll not there anymore
TurnFlagOFF 1 ;bear is not following you
PlusScore 10
DoneWithTurn
END_

COMMAND RELEASE BEAR
TurnFlagOFF 1 ;bear is not following you
PrintMessage 92 ;bear wanders off
END_

COMMAND RELEASE BIRD
FlagOFF 3 ;cave is open
Present 210 ;cage with bird in it
SwapLocations 204 210 ;swap for cage
PutInCurrentRoom 209 ;bird
PrintMessage 83 ;bird released
InRoom 214 ;green snake
Destroy 214 ;green snake
PrintMessage 30 ;bird attacks snake
PlusScore 10
DoneWithTurn
END_

COMMAND RELEASE BIRD
FlagON 3 ;cave is closed
Present 210 ;cage with bird in it
SwapLocations 204 210 ;swap for cage
InRoom 214 ;green snake
Destroy 209 ;bird
PrintMessage 46 ;attacking snake is dangerous
PrintMessage 101 ;snake eats bird
PrintMessage 199 ;you wake the nearest dwarf
MinusScore 10 ;lose 10 points for dying
GoToRoom 121 ;Loser's area
KillPlayer
DoneWithTurn
END_

COMMAND RELEASE BIRD
Present 210 ;cage with bird in it
SwapLocations 204 210 ;swap for cage
InRoom 239 ;green dragon
Destroy 209 ;bird
PrintMessage 154 ;dragon fries bird
DoneWithTurn
END_

COMMAND RELEASE BIRD
Present 204 ;cage
DoneWithTurn
END_

COMMAND RELEASE ANY
PrintMessage 14 ;I'm game...
DoneWithTurn
END_

;DRINK

COMMAND DRINK WATER FROM BOTTLE
Present 225 ;bottle of water
PrintMessage 72 ;It was delicious
PrintMessage 74 ;bottle is now empty
SwapLocations 226 225 ;swap empty bottle for water-filled
TurnFlagOFF 2 ;bottle is now empty
DoneWithTurn
END_

COMMAND DRINK WATER
AtLocation 3 ;inside building
OR
AtLocation 4 ;valley by stream
OR
AtLocation 38 ;bottom of pit with stream
OR
AtLocation 95 ;cavern with waterfall
OR
AtLocation 113 ;reservoir
OR
AtLocation 141 ;by building
PrintMessage 73 ;drink from stream
DoneWithTurn
END_

COMMAND DRINK WATER
Present 225 ;bottle of water
PrintMessage 72 ;It was delicious
PrintMessage 74 ;bottle is now empty
SwapLocations 226 225 ;swap empty bottle for water-filled
TurnFlagOFF 2 ;bottle is now empty
DoneWithTurn
END_

COMMAND DRINK ANY
PrintMessage 110 ;Don't be ridiculous
DoneWithTurn
END_

;OPEN

COMMAND OPEN CLAM
IsCarrying 218 ;clam
PrintMessage 120 ;put it down first
DoneWithTurn
END_

COMMAND OPEN CLAM
NOT present 262 ;trident
Present 218 ;clam
PrintMessage 122 ;don't have anything strong enough to open it
DoneWithTurn
END_

COMMAND OPEN CLAM
present 262 ;trident
InRoom 218 ;clam
PrintMessage 124 ;pearl rolls out
SwapLocations 218 219 ;clam becomes an oyster
SendToRoom 268 105 ;put pearl in cul-de-sac
DoneWithTurn
END_

COMMAND OPEN OYSTER
IsCarrying 219 ;oyster
PrintMessage 121 ;put it down first
DoneWithTurn
END_

COMMAND OPEN OYSTER
NOT present 262 ;trident
Present 219 ;oyster
PrintMessage 123 ;don't have anything strong enough to open it
DoneWithTurn
END_

COMMAND OPEN OYSTER
present 262 ;trident
InRoom 219 ;oyster
PrintMessage 125 ;it opens and then shuts
DoneWithTurn
END_

COMMAND OPEN DOOR
InRoom 212 ;it is already open
PrintMessage 84 ;it is already open
DoneWithTurn
END_

COMMAND OPEN DOOR
InRoom 211 ;rusty door
PrintMessage 111 ;too rusty to open
DoneWithTurn
END_

COMMAND OPEN CAGE
FlagOFF 3 ;cave is open
Present 210 ;cage with bird in it
PutInCurrentRoom 209 ;bird
SwapLocations 204 210 ;swap for cage
InRoom 214 ;green snake
Destroy 214 ;green snake
PrintMessage 30 ;bird attacks snake
PlusScore 10
DoneWithTurn
END_

COMMAND OPEN CAGE
FlagON 3 ;cave is closed
Present 210 ;cage with bird in it
SwapLocations 204 210 ;swap for cage
InRoom 214 ;green snake
Destroy 209 ;bird
PrintMessage 46 ;attacking snake is dangerous
PrintMessage 101 ;snake eats bird
PrintMessage 199 ;you wake the nearest dwarf
MinusScore 10 ;lose 10 points for dying
GoToRoom 121 ;Loser's area
KillPlayer
DoneWithTurn
END_

COMMAND OPEN CAGE
Present 210 ;cage with bird in it
SwapLocations 204 210 ;swap for cage
InRoom 239 ;green dragon
Destroy 209 ;bird
PrintMessage 154 ;dragon fries snake
DoneWithTurn
END_

COMMAND OPEN CAGE
Present 210 ;cage with bird in it
SwapLocations 204 210 ;swap for cage
PutInCurrentRoom 209 ;bird
PrintMessage 83 ;bird released
DoneWithTurn
END_

COMMAND OPEN CAGE
Present 204 ;cage
PrintMessage 223 ;It's already open
DoneWithTurn
END_

;CLOSE

COMMAND CLOSE CAGE
Present 204 ;cage
PrintMessage 224 ;It's broken and wont close
DoneWithTurn
END_

;WATER/OIL

COMMAND OIL
ReDirectTo POUR OIL
END_

COMMAND WATER ANY
InRoom 231 ;gigantic beanstalk
OR
InRoom 230 ;12-foot beanstalk
OR
InRoom 229 ;tiny plant
ReDirectTo POUR WATER
END_

COMMAND WATER ANY
Present 225 ;bottle of water
SwapLocations 225 226 ;swap for empty bottle
PrintMessage 77 ;bottle is empty and ground is wet
PrintMessage 70 ;your feet are now wet
TurnFlagOFF 2 ;bottle is now empty
DoneWithTurn
END_

COMMAND WATER ANY
PrintMessage 25 ;You can't be serious
DoneWithTurn
END_

;LOCK

COMMAND LOCK ANY
NOT present 200 ;iron keys
PrintMessage 31 ;you don't have any keys
DoneWithTurn
END_

COMMAND LOCK CAGE
Present 204 ;cage
OR
Present 210 ;cage with bird
PrintMessage 32 ;it has no lock
DoneWithTurn
END_

COMMAND LOCK KEYS
Present 200 ;iron keys
PrintMessage 55 ;can't lock or unlock keys
DoneWithTurn
END_

COMMAND LOCK CHAIN
NOT atLocation 130 ;barren room
PrintMessage 173 ;nothing here to lock chain to
DoneWithTurn
END_

COMMAND LOCK CHAIN
AtLocation 130 ;barren room
Present 200 ;iron keys
Present 274 ;locked chain
OR
Present 273 ;locked chain with bear attached
PrintMessage 34 ;It is already locked
DoneWithTurn
END_

COMMAND LOCK CHAIN
AtLocation 130 ;barren room
Present 200 ;iron keys
Present 272 ;free chain
Destroy 272 ;free chain
PutInCurrentRoom 274 ;chain attached to wall
PrintMessage 35 ;It is now locked
DoneWithTurn
END_

COMMAND LOCK BEAR
NOT atLocation 130 ;barren room
PrintMessage 172 ;nothing here to lock bear to
DoneWithTurn
END_

COMMAND LOCK BEAR
AtLocation 130 ;barren room
Present 200 ;iron keys
Present 273 ;locked chain with bear attached
PrintMessage 34 ;It is already locked
DoneWithTurn
END_

COMMAND LOCK BEAR
AtLocation 130 ;barren room
Present 200 ;iron keys
Present 272 ;free chain
Present 248 ;contented free bear
Destroy 272 ;free chain
Destroy 248 ;free bear
PutInCurrentRoom 273 ;chain attached to wall and to bear
PutInCurrentRoom 247 ;gentle bear
PrintMessage 171 ;bear is now locked to wall
DoneWithTurn
END_

;UNLOCK

COMMAND UNLOCK ANY
NOT present 200 ;iron keys
PrintMessage 31 ;you have no keys
DoneWithTurn
END_

COMMAND UNLOCK CAGE
Present 204 ;cage
OR
Present 210 ;caged bird
PrintMessage 32 ;it has no lock
DoneWithTurn
END_

COMMAND UNLOCK GRATE
FlagON 3 ;cave is closed
PrintMessage 130 ;cave is now closed
DoneWithTurn
END_

COMMAND UNLOCK GRATE
FlagOFF 3 ;cave is open
AtLocation 8 ;above grate
UnlockIt 203 ;grate
PrintMessage 85 ;it is now unlocked
DoneWithTurn
END_

COMMAND UNLOCK GRATE
FlagOFF 3 ;cave is open
AtLocation 9 ;below grate
PrintMessage 81 ;Sorry, the lock is out of reach
DoneWithTurn
END_

COMMAND UNLOCK ANY
InRoom 246 ;ferocious bear
PrintMessage 41 ;can't unlock because of bear
DoneWithTurn
END_

COMMAND UNLOCK BEAR
Present 248 ;unlocked bear
PrintMessage 33 ;It is already unlocked
DoneWithTurn
END_

COMMAND UNLOCK ANY
Present 200 ;iron keys
InRoom 247 ;gentle bear
SwapLocations 247 248 ;bear now free to wander
SwapLocations 273 274 ;chain no longer has bear attached
PrintMessage 170 ;bear now free to roam
DoneWithTurn
END_

COMMAND UNLOCK CHAIN
Present 272 ;unlocked chain
PrintMessage 33 ;It is already unlocked
DoneWithTurn
END_

COMMAND UNLOCK CHAIN
Present 200 ;iron keys
InRoom 274 ;chain attached to wall
SwapLocations 274 272 ;chain no longer attached to wall
PrintMessage 36 ;It is now unlocked
DoneWithTurn
END_

;SAY or GO

COMMAND SAY ANY
PrintMessage 28 ;use only one word
DoneWithTurn
END_

;LIGHT

COMMAND LIGHT LAMP
Present 202 ;lamp
PrintMessage 39 ;your lamp is now on
DoneWithTurn
END_

COMMAND LIGHT LAMP
NOT Present 201 ;unlit lamp
PrintMessage 38 ;you have no source of light
DoneWithTurn
END_

COMMAND LIGHT LAMP
Present 201 ;unlit lamp
VariableGT 1 0 ;batteries are not dead, yet
PrintMessage 39 ;your lamp is now on
TurnFlagON 5 ;Lamp is now ON
SwapLocations 202 201 ;swap for ON lamp
DoneWithTurn
END_

COMMAND LIGHT LAMP
Present 201 ;unlit lamp
VariableEquals 1 0 ;batteries are dead
PrintMessage 37 ;sorry, but your batteries are dead
DoneWithTurn
END_

;EXTINGUISH

COMMAND EXTINGUISH LAMP
Present 201 ;unlit lamp
PrintMessage 40 ;your lamp is now off
DoneWithTurn
END_

COMMAND EXTINGUISH LAMP
Present 202 ;lamp
PrintMessage 40 ;your lamp is now off
TurnFlagOFF 5 ;Lamp is now OFF
SwapLocations 202 201 ;swap for OFF lamp
DoneWithTurn
END_

;WAVE

COMMAND WAVE ROD
NOT IsCarrying 205 ;black rod
NOT IsCarrying 206 ;red rod
PrintMessage 29 ;You're not carrying it
DoneWithTurn
END_

COMMAND WAVE ROD
Present 205 ;black rod
FlagON 8 ;crystal bridge is here
AtLocation 17 ;east side of fissure
OR
AtLocation 27 ;west side of fissure
TurnFlagOFF 8 ;crystal bridge now gone
PutInCurrentRoom 216 ;open fissure
Destroy 215 ;crystal bridge
Destroy 287 ;other crystal bridge
LookAtRoom
DoneWithTurn
END_

COMMAND WAVE ROD
Present 205 ;black rod
FlagOFF 8 ;crystal bridge not here
AtLocation 17 ;east side of fissure
OR
AtLocation 27 ;west side of fissure
TurnFlagON 8 ;crystal bridge has suddenly appeared
SendToRoom 215 17 ;crystal bridge
SendToRoom 287 27 ;other crystal bridge
Destroy 216 ;open fissure
LookAtRoom
DoneWithTurn
END_

COMMAND WAVE FIGURE
InRoom 235 ;shadowy figure
OR
InRoom 236 ;shadowy figure
PrintMessage 219 ;You wave AT the figure
DoneWithTurn
END_

COMMAND WAVE ANY
PrintMessage 76 ;strange - nothing happens
DoneWithTurn
END_

;ATTACK

COMMAND ATTACK BIRD
FlagON 3 ;cave is closed
Present 209 ;bird
OR
Present 210 ;bird in cage
PrintMessage 137 ;leave the poor bird alone
DoneWithTurn
END_

COMMAND ATTACK BIRD
Present 209 ;bird
FlagOFF 3 ;cave is open
PrintMessage 45 ;bird dies and disappears
Destroy 209 ;bird
DoneWithTurn
END_

COMMAND ATTACK BIRD
Present 210 ;bird in cage
FlagOFF 3 ;cave is open
PrintMessage 45 ;bird dies and disappears
Destroy 210 ;bird in cage
PutInCurrentRoom 204 ;cage without bird
DoneWithTurn
END_

COMMAND ATTACK SNAKE
FlagON 14 ;second command about SNAKE
Present 214 ;snake
PrintMessage 21 ;give snake hint
TurnFlagOFF 14 ;toggle for real message next
DoneWithTurn
END_

COMMAND ATTACK SNAKE
FlagOFF 14 ;first command about SNAKE
TurnFlagON 14 ;toggle for hint next
Present 214 ;snake
PrintMessage 46 ;attacking the snake is very dangerous
DoneWithTurn
END_

COMMAND ATTACK ANY
NOT NOUNpresent 
PrintMessage 228 ;It's not even here!
DoneWithTurn
END_

COMMAND ATTACK ANY WITH ROD
FlagOFF 3 ;cave is open 
Present 205 ;black rod
OR 
Present 206 ;red rod
PrintMessage 225 ;It is not a good weapon
DoneWithTurn
END_

COMMAND ATTACK ANY WITH LAMP
FlagOFF 3 ;cave is open 
Present 202 ;lamp
OR 
Present 203 ;lamp
PrintMessage 225 ;It is not a good weapon
DoneWithTurn
END_

COMMAND ATTACK ANY WITH TRIDENT
FlagOFF 3 ;cave is open 
Present 262 ;trident
PrintMessage 225 ;It is not a good weapon
DoneWithTurn
END_

COMMAND ATTACK ANY WITH BOTTLE
FlagOFF 3 ;cave is open 
Present 225 ;bottle
OR 
Present 226 
OR 
Present 227 
PrintMessage 225 ;It is not a good weapon
DoneWithTurn
END_

COMMAND ATTACK TROLL WITH AXE
Present 237 ;axe
Present 244 ;troll demanding money
PrintMessage 158 ;troll catches axe and throws it back
DoneWithTurn
END_

COMMAND ATTACK TROLL
Present 244 ;troll demanding money
PrintMessage 157 ;troll fends off your blows easily
DoneWithTurn
END_

COMMAND ATTACK CLAM
Present 218 ;giant clam
PrintMessage 150 ;shell is too hard
DoneWithTurn
END_

COMMAND ATTACK OYSTER
Present 219 ;giant oyster
PrintMessage 150 ;shell is too hard
DoneWithTurn
END_

COMMAND ATTACK DWARF
FlagON 3 ;cave is closed
PrintMessage 199 ;you wake the nearest dwarf
MinusScore 10 ;lose 10 points for dying
GoToRoom 121 ;Loser's area
KillPlayer
DoneWithTurn
END_

COMMAND ATTACK DWARF WITH AXE
Present 237 ;axe
Present 221 ;dwarf blocking way
OR
Present 222 ;dwarf
PrintMessage 149 ;You kill him - he disappears
Destroy 221 ;dwarf block way
Destroy 222 ;dwarf
DoneWithTurn
END_

COMMAND ATTACK DWARF
Present 221 ;dwarf blocking way
OR
Present 222 ;dwarf
TurnFlagON 9 ;not using bare hands for attack
PrintMessage 49 ;With your bare hands???
PromptForYES ;wants to use bare hands
TurnFlagOFF 9
BlankLine
PrintMessage 48 ;he dodges out of the way
DoneWithTurn
END_

COMMAND ATTACK DWARF
FlagON 9 ;not using bare hands for attack
TurnFlagOFF 9
BlankLine
PrintMessage 47 ;you kill him
Destroy 221 ;dwarf blocking way
Destroy 222 ;dwarf
DoneWithTurn
END_

COMMAND ATTACK BEAR WITH AXE
Present 246 ;ferocious bear
Present 237 ;axe
PrintMessage 164 ;Axe misses and lands where you can't get it
PutInCurrentRoom 237 ;axe
DoneWithTurn
END_

COMMAND ATTACK BEAR
Present 246 ;ferocious bear
PrintMessage 165 ;With your bare hands against his BEAR hands?
PrintMessage 110 ;Don't be ridiculous
DoneWithTurn
END_

COMMAND ATTACK BEAR
Present 248 ;contented free bear
OR
Present 247 ;gentle bear
PrintMessage 110 ;Don't be ridiculous
PrintMessage 166 ;The bear just wants to be your friend
DoneWithTurn
END_

COMMAND ATTACK DRAGON
Present 240 ;dead dragon
PrintMessage 167 ;It is already dead
DoneWithTurn
END_

COMMAND ATTACK DRAGON WITH AXE
Present 239 ;dragon blocking way
Present 237 ;axe
PrintMessage 152 ;Axe bounces off and lands where you can't get it
PutInCurrentRoom 237 ;axe
DoneWithTurn
END_

COMMAND ATTACK DRAGON
Present 239 ;dragon blocking way
TurnFlagON 9 ;not using bare hands for attack
PrintMessage 49 ;With your bare hands???
PromptForYES ;wants to use bare hands
TurnFlagOFF 9
BlankLine
PrintMessage 210 ;Congrats You did it
SwapLocations 239 240 ;dragon blocking way - dead dragon
SwapLocations 270 ;dragon sprawled on rug - plain rug
PlusScore 10
DoneWithTurn
END_

COMMAND ATTACK DRAGON
FlagON 9 ;not using bare hands for attack
TurnFlagOFF 9
BlankLine
PrintMessage 110 ;Don't be ridiculous
PrintMessage 153 ;Better not try it
DoneWithTurn
END_

COMMAND ATTACK ANY
PrintMessage 110 ;Don't be ridiculous
DoneWithTurn
END_

;ABRACADABRA

COMMAND ABRACADABRA
PrintMessage 50 ;That is an old secret word that no longer works
DoneWithTurn
END_

;DIG/EXCAVATE

COMMAND DIG any
PrintMessage 66 ;Digging is hard without a shovel
DoneWithTurn
END_

;WAKE/CALM

COMMAND WAKE
FlagON 3 ;cave is closed
PrintMessage 199 ;you wake dwarves
MinusScore 10 ;lose 10 points for dying
GoToRoom 121 ;Loser's area
KillPlayer
DoneWithTurn
END_

COMMAND CALM ANY
PrintMessage 14 ;I'm game - tell me how
DoneWithTurn
END_

;BREAK/BLAST/DYNAMITE 

COMMAND BREAK VASE
Present 263 ;ming vase
Destroy 263 ;ming vase
PutInCurrentRoom 265 ;pottery shards
PrintMessage 211 ;vase drop with delicate crash
LookAtRoom
DoneWithTurn
END_

COMMAND BREAK MIRROR
FlagOFF 3 ;cave is open
PrintMessage 148 ;Too far to reach
DoneWithTurn
END_

COMMAND BREAK MIRROR
PrintMessage 197 ;mirror shatters
PrintMessage 136 ;which wakes up dwarves
MinusScore 10 ;lose 10 points for dying
GoToRoom 121 ;Loser's area
KillPlayer
DoneWithTurn
END_

COMMAND BREAK BOTTLE
PrintMessage 146 ;Beyond your power to do that
DoneWithTurn
END_

COMMAND BLAST ANY
FlagOFF 3 ;cave is open
PrintMessage 67 ;To $VERB$ the $NOUN$ requires dynamite
DoneWithTurn
END_

COMMAND BLAST ANY
NOT Present 206 ;red rod
AtLocation 115 ;NE end of repository
PrintMessage 134 ;Lava buries you
GoToRoom 121 ;Loser's area
PlusScore 20
KillPlayer
DoneWithTurn
END_

COMMAND BLAST ANY
Present 206 ;red rod
PrintMessage 135 ;you blow yourself up
GoToRoom 121 ;Loser's area
PlusScore 10
KillPlayer
DoneWithTurn
END_

COMMAND BLAST ANY
NOT Present 206 ;red rod
AtLocation 116 ;SW end of repository
PrintMessage 133 ;You win
GoToRoom 120 ;Cave Office
PlusScore 35
DoneWithTurn
END_

COMMAND BLAST ANY
NOT Present 206 ;red rod
PrintMessage 29 ;You don't have resources
DoneWithTurn
END_

;THROW/GIVE

COMMAND THROW BEAR
InRoom 244 ;troll
Present 248 ;contented free bear
SwapLocations 244 245 ;troll is nowhere to be seen
PrintMessage 163 ;bear chases troll away
TurnFlagON 4 ;troll not there anymore
TurnFlagOFF 1 ;bear is not following you
PlusScore 10
DoneWithTurn
END_

COMMAND THROW AXE
FlagON 3 ;cave is closed
PrintMessage 199 ;you wake the nearest dwarf
MinusScore 10 ;lose 10 points for dying
GoToRoom 121 ;Loser's area
KillPlayer
DoneWithTurn
END_

COMMAND THROW AXE
Present 237 ;axe
Present 221 ;dwarf blocking way
OR
Present 222 ;dwarf
TurnFlagON 9 ;throwing axe at dwarf
PutInCurrentRoom 237 ;axe
Chance 50
PrintMessage 149 ;You kill him - he disappears
TurnFlagOFF 9
Destroy 221 ;dwarf block way
Destroy 222 ;dwarf
DoneWithTurn
END_

COMMAND THROW AXE
FlagON 9 ;has already thrown axe at dwarf
PrintMessage 48 ;He dodges out of the way
PrintMessage 52 ;You missed
TurnFlagOFF 9
LookAtRoom
DoneWithTurn
END_

COMMAND THROW AXE
Present 244 ;troll demanding money
PrintMessage 158 ;troll catches axe and throws it back
PutInCurrentRoom 237 ;axe
LookAtRoom
DoneWithTurn
END_

COMMAND THROW AXE
Present 246 ;ferocious bear
Present 237 ;axe
PrintMessage 164 ;Axe misses and lands where you can't get it
PutInCurrentRoom 237 ;axe
DoneWithTurn
END_

COMMAND THROW AXE
Present 239 ;dragon blocking way
Present 237 ;axe
PrintMessage 152 ;Axe bounces off and lands where you can't get it
PutInCurrentRoom 237 ;axe
DoneWithTurn
END_

COMMAND THROW AXE
Present 218 ;giant clam
OR
Present 219 ;giant oyster
PrintMessage 150 ;shell is too hard
DoneWithTurn
END_

COMMAND THROW FOOD
Present 246 ;ferocious bear
Present 224 ;food
PrintMessage 168 ;Bear eats food and becomes friendly
Destroy 224 ;food
SwapLocations 246 247 ;bear becomes friendly
PlusScore 10
DoneWithTurn
END_

COMMAND THROW FOOD
Present 244 ;troll blocking way
Present 224 ;food
PrintMessage 182 ;troll wants 'orbs' - not food
DoneWithTurn
END_

COMMAND THROW FOOD
Present 224 ;food
Present 239 ;dragon
OR
Present 214 ;snake
PrintMessage 102 ;It doesn't want food - except for you
DoneWithTurn
END_

COMMAND THROW FOOD
Present 224 ;food
Present 221 ;dwarf blocking way
OR
Present 222 ;dwarf
PrintMessage 103 ;It only eats coal
DoneWithTurn
END_

COMMAND THROW FOOD
Present 209 ;little bird
Present 224 ;food
PrintMessage 100 ;It isn't hungry
DoneWithTurn
END_

COMMAND THROW ANY
Present 244 ;troll demanding 'orbs'
NOUNpointsGT 0 ;Noun is a 'orbs' - i.e., it has value
PrintMessage 159 ;troll catches 'orbs' and leaves
DestroyNOUN
SwapLocations 244 245 ;swap for phony troll
TurnFlagON 4 ;troll not there anymore
DoneWithTurn
END_

COMMAND THROW ANY
Present 244 ;troll demanding 'orbs'
PrintMessage 174 ;troll throws it back
DoneWithTurn
END_

COMMAND THROW VASE
InRoom 213 ;pillow
Present 263 ;ming vase
SwapLocations 213 264 ;pillow swaps for pillow with vase on it
Destroy 263 ;ming vase
PrintMessage 211 ;vase drop with delicate crash
PrintMessage 44 ;but, it doesn't break
DoneWithTurn
END_

COMMAND THROW VASE
NOT InRoom 213 ;pillow
Present 263 ;ming vase
Destroy 263 ;ming vase
PutInCurrentRoom 265 ;pottery shards
PrintMessage 211 ;vase drop with delicate crash
LookAtRoom
DoneWithTurn
END_

COMMAND THROW BIRD
ReDirectTo FREE BIRD
END_

;FEED

COMMAND FEED BEAR
Present 246 ;ferocious bear
Present 224 ;food
PrintMessage 168 ;Bear eats food and becomes friendly
Destroy 224 ;food
SwapLocations 246 247 ;bear becomes friendly
PlusScore 10
DoneWithTurn
END_

COMMAND FEED BEAR
NOT Present 224 ;food
PrintMessage 102 ;It doesn't want food - except for you
DoneWithTurn
END_

COMMAND FEED TROLL
Present 244 ;troll blocking way
PrintMessage 182 ;troll wants 'orbs' - not food
DoneWithTurn
END_

COMMAND FEED DRAGON
Present 239 ;dragon
PrintMessage 102 ;It doesn't want food - except for you
DoneWithTurn
END_

COMMAND FEED SNAKE
Present 214 ;snake
Present 210 ;bird in cage
PrintMessage 101 ;snake eats your bird
SwapLocations 204 210 ;swap for cage
DoneWithTurn
END_

COMMAND FEED SNAKE
Present 214 ;snake
PrintMessage 102 ;It doesn't want food - except for you
DoneWithTurn
END_

COMMAND FEED DWARF
Present 221 ;dwarf blocking way
OR
Present 222 ;dwarf
PrintMessage 103 ;It only eats coal
DoneWithTurn
END_

COMMAND FEED BIRD
Present 209 ;little bird
OR
Present 210 ;little bird in cage
PrintMessage 100 ;It isn't hungry
DoneWithTurn
END_

COMMAND FEED ANY
PrintMessage 14 ;I'm game - care to tell me how
DoneWithTurn
END_

;EAT

COMMAND EAT FOOD
Present 224 ;food
PrintMessage 72 ;It was delicious
Destroy 224 ;food
DoneWithTurn
END_

COMMAND EAT ANY
PrintMessage 71 ;I lost my appetite
DoneWithTurn
END_

;FILL

COMMAND FILL ANY
NOT NOUNIsCarrying
PrintMessage 29 ;you aren't carrying it
DoneWithTurn
END_

COMMAND FILL VASE
Present 263 ;ming vase
Destroy 263 ;ming vase
PutInCurrentRoom 265 ;pottery shards
PrintMessage 145 ;temperature breaks vase
LookAtRoom
DoneWithTurn
END_

COMMAND FILL BOTTLE
FlagON 2 ;bottle is already full
PrintMessage 105 ;it is already full
DoneWithTurn
END_

COMMAND FILL BOTTLE
NOT Present 226 ;empty bottle
PrintMessage 104 ;you have nothing to put it in
DoneWithTurn
END_

COMMAND FILL BOTTLE
AtLocation 3 ;inside building
OR
AtLocation 4 ;valley by stream
OR
AtLocation 38 ;bottom of pit with stream
OR
AtLocation 95 ;cavern with waterfall
OR
AtLocation 113 ;reservoir
OR
AtLocation 141 ;by building
PrintMessage 107 ;bottle is now full of water
SwapLocations 226 225 ;swap empty bottle for water-filled
TurnFlagON 2 ;bottle is now full
DoneWithTurn
END_

COMMAND FILL BOTTLE
AtLocation 24 ;east pit of twopit room
PrintMessage 108 ;bottle is now full of oil
SwapLocations 226 227 ;swap empty bottle for oil-filled
TurnFlagON 2 ;bottle is now full
DoneWithTurn
END_

COMMAND FILL BOTTLE
PrintMessage 106 ;nothing here to fill it with
DoneWithTurn
END_

COMMAND FILL ANY
PrintMessage 109 ;You can't fill that
DoneWithTurn
END_

;JUMP

COMMAND JUMP CHASM
InRoom 241 ;troll bridge
PrintMessage 96 ;Use bridge instead of jumping
DoneWithTurn
END_

COMMAND JUMP CHASM
IsSomewhere 215 ;crystal bridge
AtLocation 17 ;East side of fissure
OR
AtLocation 27 ;West side of fissure
PrintMessage 96 ;Use bridge instead of jumping
DoneWithTurn
END_

COMMAND JUMP ANY
IsNowhere 215 ;crystal bridge doesn't exist
AtLocation 17 ;East side of fissure
OR
AtLocation 27 ;West side of fissure
PrintMessage 18 ;Jump was unsuccessful
GoToRoom 20 ;pit
MinusScore 10
KillPlayer
DoneWithTurn
END_

COMMAND JUMP ANY
IsNowhere 241 ;troll bridge doesn't exist
AtLocation 117 ;one side of fissure
OR
AtLocation 122 ;other side of fissure
PrintMessage 18 ;Jump was unsuccessful
GoToRoom 20 ;pit
MinusScore 10
KillPlayer
DoneWithTurn
END_

COMMAND JUMP ANY
PrintMessage 110 ;Don't be ridiculous
DoneWithTurn
END_

;CLIMB/CROSS/FOLLOW

COMMAND CLIMB ANY
InRoom 231 ;gigantic beanstalk
PrintMessage 202 ;you climb up the plant
GoToRoom 88 ;long corridor
DoneWithTurn
END_

COMMAND CLIMB ANY
InRoom 233 ;gigantic beanstalk sticking into room 88
PrintMessage 51 ;You climb down
GoToRoom 25 ;west pit
DoneWithTurn
END_

COMMAND CLIMB ANY
InRoom 230 ;12-ft beanstalk
PrintMessage 206 ;you climb up the plant
GoToRoom 23 ;top of pit
DoneWithTurn
END_

COMMAND CLIMB ANY
InRoom 232 ;12-ft beanstalk sticking into room 23
PrintMessage 51 ;You climb down
GoToRoom 25 ;west pit
DoneWithTurn
END_

COMMAND CLIMB ANY
AtLocation 25 ;west pit
OR
AtLocation 24 ;east pit
PrintMessage 205 ;use UP to climb out of pit
DoneWithTurn
END_

COMMAND CROSS BRIDGE
Present 245 ;phony troll
AtLocation 117 ;one side of troll bridge
GoToRoom 122 ;other side
PutInCurrentRoom 245 ;phony troll
PutInCurrentRoom 241 ;troll bridge
PrintMessage 53 ;You cross
DoneWithTurn
END_

COMMAND CROSS BRIDGE
Present 245 ;phony troll
AtLocation 122 ;one side of troll bridge
GoToRoom 117 ;other side
PutInCurrentRoom 245 ;phony troll
PutInCurrentRoom 241 ;troll bridge
PrintMessage 53 ;You cross
DoneWithTurn
END_

COMMAND CROSS BRIDGE
NOT InRoom 244 ;troll
InRoom 241 ;troll bridge
FlagOFF 4 ;troll can appear
PutInCurrentRoom 244
PrintMessage 10 ;Troll appears
LookAtRoom
DoneWithTurn
END_

COMMAND CROSS BRIDGE
InRoom 244 ;troll
PrintMessage 160 ;Troll refuses to let you cross
DoneWithTurn
END_

COMMAND CROSS BRIDGE
InRoom 243 ;wreckage of bridge
PrintMessage 161 ;no longer any way to cross
DoneWithTurn
END_

COMMAND CROSS BRIDGE
InRoom 241 ;troll bridge
FlagON 1 ;bear is following you
PrintMessage 162 ;bridge buckles under weight of bear
Destroy 241 ;troll bridge
Destroy 244 ;troll
Destroy 245 ;phony troll
Destroy 248 ;bear
TurnFlagOFF 1 ;bear no longer following you
SendToRoom 243 117 ;bridge wreckage
GoToRoom 20 ;pit
MinusScore 10
SendToRoom 201 3 ;OFF lamp to building
Destroy 202
KillPlayer
DoneWithTurn
END_

COMMAND CROSS BRIDGE
IsNowhere 215 ;crystal bridge
AtLocation 17 ;East side of fissure
OR
AtLocation 27 ;West side of fissure
PrintMessage 97 ;No way across the fissure
DoneWithTurn
END_

COMMAND FOLLOW STREAM
AtLocation 141
PrintMessage 87 ;You $VERB$ the $NOUN for a while
GoToRoom 4
DoneWithTurn
END_

COMMAND FOLLOW STREAM
AtLocation 3 ;Inside building
PrintMessage 204 ;must use exit
DoneWithTurn
END_

COMMAND FOLLOW STREAM
AtLocation 7 ;at slit
PrintMessage 95 ;you don't fit
DoneWithTurn
END_

COMMAND FOLLOW STREAM
AtLocation 4
PrintMessage 87 ;You $VERB$ the $NOUN for a while
GoToRoom 7
DoneWithTurn
END_

COMMAND FOLLOW STREAM
AtLocation 7
PrintMessage 87 ;You $VERB$ the $NOUN for a while
GoToRoom 8
DoneWithTurn
END_

COMMAND FOLLOW ROAD
AtLocation 141
PrintMessage 87 ;You $VERB$ the $NOUN for a while
GoToRoom 2
DoneWithTurn
END_

COMMAND FOLLOW ROAD
AtLocation 2
PrintMessage 87 ;You $VERB$ the $NOUN for a while
GoToRoom 141
DoneWithTurn
END_

COMMAND FOLLOW CARDASSIAN
PrintMessage 25 ;Can't be serious
PrintMessage 216 ;The $NOUN$ is long gone
DoneWithTurn
END_

COMMAND FOLLOW PROGRAMMER
PrintMessage 25 ;Can't be serious
PrintMessage 216 ;The $NOUN$ is long gone
DoneWithTurn
END_

COMMAND FOLLOW DWARF
FlagON 10 ;in room
PrintMessage 94 ;It is already here
DoneWithTurn
END_

COMMAND FOLLOW DWARF
FlagOFF 10 ;not in room
PrintMessage 56 ;You crawl around for a while
DoneWithTurn
END_

COMMAND FOLLOW TROLL
NOT InRoom 244
PrintMessage 80 ;Tell me where to go to $VERB$ the $NOUN$
DoneWithTurn
END_

COMMAND FOLLOW TROLL
InRoom 244
PrintMessage 94 ;It is already here
DoneWithTurn
END_

COMMAND CLIMB ANY
PrintMessage 80 ;Tell me where to go to $VERB$ the $NOUN$
DoneWithTurn
END_

;TALK TO/TELL/ASK

COMMAND TALK TO PLANT
AtLocation 25 ;west pit
PrintMessage 89 ;Plant cries "water..."
DoneWithTurn
END_

COMMAND TALK TO DWARF
FlagON 10 ;dwarf in room
PrintMessage 215 ;$NOUN$ speaks in dwarvish
DoneWithTurn
END_

COMMAND TALK TO FIGURE
InRoom 235 ;shadowy figure
OR
InRoom 236 ;shadowy figure
PrintMessage 220 ;$NOUN$ speaks in dwarvish
DoneWithTurn
END_

COMMAND TALK TO CARDASSIAN
PrintMessage 216 ;The $NOUN$ is long gone
DoneWithTurn
END_

COMMAND TALK TO TROLL
InRoom 244 ;troll
PrintMessage 217 ;Troll says "give me a 'orbs'"
DoneWithTurn
END_

COMMAND TALK TO ANY
PrintMessage 218 ;Talking to yourself is sick
DoneWithTurn
END_

;LIST

COMMAND LIST ANY
FlagOFF 5 ;lamp is off
FlagON 6 ;room needs light
PrintMessage 16 ;now dark - so can't "LIST EXITS"
DoneWithTurn
END_

;READ

COMMAND READ ANY
AtLocation 31 ;programmer's den
TurnFlagOFF 16 ;revoke secret words
TurnFlagON 15 ;programmer is angry
PrintMessage 213 ;programmer talks of revenge
MinusScore 25 ;That will teach you
GoToRoom 44 ;cardassian's maze - just south of cardassian's den
DoneWithTurn
END_

COMMAND READ OYSTER
FlagOFF 3 ;cave is open
NOUNpresent
PrintMessage 190 ;It is written in dwarvish
DoneWithTurn
END_

COMMAND READ ANY
FlagON 6 ;it is dark
NOT Present 202 ;lamp
PrintMessage 22 ;You can't read in the dark
DoneWithTurn
END_

;EXAMINE

COMMAND EXAMINE ANY
AtLocation 31 ;programmer's den
TurnFlagOFF 16 ;revoke secret words
TurnFlagON 15 ;programmer is angry
PrintMessage 213 ;programmer talks of revenge
MinusScore 25 ;That will teach you
GoToRoom 44 ;cardassian's maze - just south of cardassian's den
DoneWithTurn
END_

COMMAND EXAMINE STREAM
AtLocation 3 ;Inside building
PrintMessage 204 ;It flows out through pipe
DoneWithTurn
END_

COMMAND EXAMINE STREAM
AtLocation 4 ;valley by stream
OR
AtLocation 141 ;by building
PrintMessage 88 ;describe stream
DoneWithTurn
END_

COMMAND EXAMINE STREAM
AtLocation 7 ;at slit
PrintMessage 98 ;describe stream
DoneWithTurn
END_

COMMAND EXAMINE BUILDING
AtLocation 141 ;outside building
PrintMessage 155 ;describe it
DoneWithTurn
END_

COMMAND EXAMINE TREE
NOT AtLocation 3 ;Inside building
AtLocation 141
OR
AtLocationLT 7 ;forest
PrintMessage 64 ;describe trees
DoneWithTurn
END_

COMMAND EXAMINE GRATE
AtLocation 8 ;depression
OR
AtLocation 9 ;below grate
OR
AtLocation 116 ;repository
PrintMessage 63 ;describe grate
DoneWithTurn
END_

COMMAND EXAMINE CAGE
Present 210 ;caged bird
PrintMessage 229 ;describe cage and bird
DoneWithTurn
END_

COMMAND EXAMINE CHASM
AtLocation 17
OR
AtLocation 27
OR
AtLocation 117
OR
AtLocation 122
PrintMessage 187 ;describe chasm
DoneWithTurn
END_

COMMAND EXAMINE MIST
PrintMessage 69 ;describe mist
DoneWithTurn
END_

COMMAND EXAMINE MAZE
AtLocation 107 ;vending machine maze
OR
AtLocation 112
OR
AtLocationGT 130
AtLocationLT 141
PrintMessage 156 ;Describe it
DoneWithTurn
END_

COMMAND EXAMINE MAZE
AtLocationGT 41 ;cardassian's maze
AtLocationLT 57
PrintMessage 156 ;Describe it
DoneWithTurn
END_

COMMAND EXAMINE CAVE
AtLocationGT 10 ;in cave
AtLocationLT 141
PrintMessage 226 ;Describe cave walls etc.
DoneWithTurn
END_

COMMAND EXAMINE ROAD
AtLocation 2 ;top of hill
OR 
AtLocation 141 ;end of road 
PrintMessage 227 ;Describe road
DoneWithTurn
END_

;FEE FIE FOE FOO

COMMAND FEE
AddToVariable 2 1 ;Add 1 to counter
NOT VariableEquals 2 4 ;Not to 4 yet
PrintMessage 42 ;nothing happens
DoneWithTurn
END_

COMMAND FOO
VariableEquals 2 4 ;OK - done with sequence
AtLocation 92 ;Giant room
Present 260 ;eggs
PrintMessage 42 ;nothing happens
SetVariableTo 2 0 ;Reset counter
DoneWithTurn
END_

COMMAND FOO
VariableEquals 2 4 ;OK - done with sequence
NOT AtLocation 92 ;Giant room
Present 260 ;eggs
DropIt 261 ;phony eggs
Destroy 260 ;real eggs
PrintMessage 93 ;Eggs vanish
SetVariableTo 2 0 ;Reset counter
DoneWithTurn
END_

COMMAND FOO
VariableEquals 2 4 ;OK - done with sequence
IsNowhere 260 ;eggs
Destroy 261 ;phony eggs
SendToRoom 260 92 ;real eggs go to Giant room
PrintMessage 65 ;Magic has been done
SetVariableTo 2 0 ;Reset counter
DoneWithTurn
END_

COMMAND FOO
VariableEquals 2 4 ;OK - done with sequence
PrintMessage 42 ;nothing happens
SetVariableTo 2 0 ;Reset counter
DoneWithTurn
END_

;HELP

COMMAND HELP ANY
AtLocation 100 ;plover room
OR
AtLocation 101 ;dark room
PrintMessage 178 ;are you trying to explore beyond plover room?
PromptForYes
PrintMessage 175 ;Do you want a hint?
PromptForYes
TurnFlagON 9 ;hint has been rejected - so far
PrintMessage 143 ;The hint will cost your 5 points
PrintMessage 1 ;Is that OK?
PromptForYes
TurnFlagOFF 9 ;hint has been accepted
PrintMessage 179 ;None of the objects is useful
MinusScore 5
DoneWithTurn
END_

COMMAND HELP ANY
FlagOFF 19 ;maze hint has not been given, yet
AtLocation 107 ;vending machine maze
OR
AtLocation 112
OR
AtLocationGT 130
AtLocationLT 141
PrintMessage 177 ;Drop stuff
TurnFlagON 19 ;hint has been given
DoneWithTurn
END_

COMMAND HELP ANY
FlagON 19 ;maze hint has been given
AtLocation 107 ;vending machine maze
OR
AtLocation 112
OR
AtLocationGT 130
AtLocationLT 141
PrintMessage 68 ;I'm as confused as you are
DoneWithTurn
END_

COMMAND HELP ANY
FlagOFF 19 ;maze hint has not been given, yet
AtLocationGT 41 ;cardassian's maze
AtLocationLT 57
PrintMessage 177 ;Drop stuff
TurnFlagON 19 ;hint has been given
DoneWithTurn
END_

COMMAND HELP ANY
FlagON 19 ;maze hint has been given
AtLocationGT 41 ;cardassian's maze
AtLocationLT 57
PrintMessage 68 ;I'm as confused as you are
DoneWithTurn
END_

COMMAND HELP ANY
AtLocation 108 ;Witt's End
PrintMessage 180 ;are you trying to get out of here?
PromptForYes
PrintMessage 175 ;Do you want a hint?
PromptForYes
TurnFlagON 9 ;hint has been rejected - so far
PrintMessage 143 ;The hint will cost your 5 points
PrintMessage 1 ;Is that OK?
PromptForYes
TurnFlagOFF 9 ;hint has been accepted
PrintMessage 181 ;Keep going east
MinusScore 5
DoneWithTurn
END_

COMMAND HELP ANY
FlagON 9 ;hint was rejected
TurnFlagOFF 9
PrintMessage 86 ;OK, do it yourself
DoneWithTurn
END_

;TURN

COMMAND TURN LIGHT
PrintMessage 221 ;use light & extinguish
DoneWithTurn
END_
 
