#include <stdio.h>
#include <sys/types.h>
#include <sys/timeb.h>
#include "console.h"
#include "sound.h"

unsigned Level, Peak, Bombs, dB;
int Row, Col;
unsigned Reds, Yellows;

byte Image[40][60];
int
   dR[9] = { -1, 0, +1, -1, 0, +1, -1, 0, +1 },
   dC[9] = { -1, -1, -1, 0, 0, 0, +1, +1, +1 };

void NewLevel(int dL) {
   long L;
   if (dL > 0) {
      L = Level + ((0x4000L + (0x8000L - (long)Level)*dL) >> 15);
   } else {
      L = Level - ((0x4000L + (long)Level*(-dL)) >> 15);
   }
   if (L == Level) return;
   Level = (unsigned)L, PutString(28, 32, WhiteC, "%5u", Level);
   if (Level >= Peak)
      Peak = Level, PutString(27, 32, WhiteC, "%5u", Peak);
}

void SetRobot(void) {
   struct timeb T;
   ftime(&T); srand((unsigned int)(T.time ^ T.millitm)&0xffff);
   Peak = Level = 100, Bombs = 1; dB = 0;
   ScrInit();
}

int SafeColor(int Row, int Col) {
   int I, J, R, C, R1, C1;
   if (Row < 0 || Row >= 40 || Col < 0 || Col >= 60) return BlackC;
   for (I = 0; I < 9; I++) {
      R = Row + dR[I], C = Col + dC[I];
      if (R < 0 || R >= 40 || C < 0 || C >= 60) continue;
      switch (Image[R][C]) {
         case YellowC: case RedC: return BrownC;
         case BrownC: continue;
      }
      for (J = 0; J < 9; J++) {
         R1 = R + dR[J], C1 = C + dC[J];
         if (R1 < 0 || R1 >= 40 || C1 < 0 || C1 >= 60) continue;
         switch (Image[R1][C1]) {
            case RedC: return BrownC;
         }
      }
   }
   return CyanC;
}

void Show(int Row, int Col, int Hue) {
   unsigned R = 10*(Row + 1), C = 10*(Col + 2);
   Box(R + 1, R + 8, C + 1, C + 8, Hue);
   Image[Row][Col] = Hue;
   switch (Hue) {
      case YellowC: Sound(150, 1); break;
      case RedC: Sound(300, 1); break;
      case CyanC: Sound(600, 1); break;
      case BrownC: Sound(1200, 1); break;
   }
}

void SafeKeys(void) {
   PutString(27, 70, SafeColor(Row - 1, Col - 1), "Y");
   PutString(27, 72, SafeColor(Row - 1, Col), "U");
   PutString(27, 74, SafeColor(Row - 1, Col + 1), "I");
   PutString(28, 70, SafeColor(Row, Col - 1), "H");
   PutString(28, 72, SafeColor(Row, Col), "W");
   PutString(28, 74, SafeColor(Row, Col + 1), "K");
   PutString(29, 70, SafeColor(Row + 1, Col - 1), "B");
   PutString(29, 72, SafeColor(Row + 1, Col), "N");
   PutString(29, 74, SafeColor(Row + 1, Col + 1), "M");
}

void RobotScreen(main) {
   int R, C;
   Box(10, 409, 20, 619, BlackC);
   Border(9, 410, 19, 620, BlueC);
   Border(7, 412, 17, 622, GreenC);
   Border(5, 414, 15, 624, YellowC);
   Border(3, 416, 13, 626, RedC);
   PutString(28, 5, RedC, "R");
   PutString(28, 7, YellowC, "O");
   PutString(28, 9, GreenC, "B");
   PutString(28, 11, CyanC, "O");
   PutString(28, 13, BlueC, "T");
   PutString(28, 15, PinkC, "S");
   PutString(27, 25, YellowC, "Peak:");
   PutString(28, 25, YellowC, "Level:");
   PutString(29, 25, YellowC, "Bombs:");
   PutString(27, 32, WhiteC, "%5d", Peak);
   PutString(28, 32, WhiteC, "%5d", Level);
   PutString(29, 32, WhiteC, "%5d", Bombs);
   Row = rand()%40, Col = rand()%60, Show(Row, Col, CyanC);
   PutString(28, 60, RedC, "RADAR");
   Reds = Yellows = 0;
   for (R = 0; R < 40; R++) for (C = 0; C < 60; C++) {
      unsigned L;
      if (R == Row && C == Col) continue;
      L = rand();
      if (L < Level >> 2) Show(R, C, RedC), Reds++;
      else if (L < Level) Show(R, C, YellowC), Yellows++;
      else Show(R, C, BlackC);
   }
}

main() {
   int I, Hue, dR, dC, R, C, R1, C1;
   unsigned Pitch;
   SetRobot();
RESTART:
   RobotScreen();
NEXT:
   if (Reds == 0 && Yellows == 0) { dB += Level; goto COMPLETE; }
KEY:
   SafeKeys();
   if (!KeyHit()) goto UPDATE;
   switch (Keyboard()) {
      case 3: ScrReset(); exit(1);
      case 'y': case 'Y': dR = -1, dC = -1; goto GO;
      case 'u': case 'U': case Up: dR = -1, dC = 0; goto GO;
      case 'i': case 'I': dR = -1, dC = +1; goto GO;
      case 'h': case 'H': case Left: dR = 0, dC = -1; goto GO;
      case 't':
         for (Pitch = 100; Pitch <= 1200; Pitch += 100) Sound(Pitch, 1);
         Show(Row, Col, BlackC);
         Row = rand()%40, Col = rand()%60;
         if (Image[Row][Col] != BlackC && Image[Row][Col] != CyanC) {
            Image[Row][Col] = WhiteC; goto CRASH;
         }
      goto MOVE;
      case 'k': case 'K': case Right: dR = 0, dC = +1; goto GO;
      case 'b': case 'B': dR = +1, dC = -1; goto GO;
      case 'n': case 'N': case Down: dR = +1, dC = 0; goto GO;
      case 'm': case 'M': dR = +1, dC = +1; goto GO;
      case 'a': case 'A':
         if (Bombs == 0) break;
         NewLevel(-2048);
         PutString(29, 32, WhiteC, "%5d", --Bombs);
         for (Pitch = 1000; Pitch >= 100; Pitch -= 100) Sound(Pitch, 1);
         for (R = Row - 3; R <= Row + 3; R++)
         for (C = Col - 3; C <= Col + 3; C++) {
            if (R < 0 || R >= 40 || C < 0 || C >= 60) continue;
            switch (Image[R][C]) {
               case RedC: Reds--; NewLevel(8); Show(R, C, BlackC); break;
               case YellowC: Yellows--; NewLevel(4); Show(R, C, BlackC); break;
            }
         }
      default:
      goto UPDATE;
   }
GO:
   R = Row + dR, C = Col + dC;
   if (R < 0 || R >= 40 || C < 0 || C >= 60) goto UPDATE;
   if (Image[R][C] == BrownC) {
      int R1 = R + dR, C1 = C + dC;
      if (R1 < 0 || R1 >= 40 || C1 < 0 || C1 >= 60) goto UPDATE;
      if (Image[R1][C1] != BlackC) goto UPDATE;
      Show(R1, C1, BrownC);
      Show(Row, Col, BlackC);
      Row = R, Col = C; goto MOVE;
   } else {
      Show(Row, Col, BlackC);
      switch (Image[R][C]) {
         case RedC: Reds--; NewLevel(8); Show(R, C, WhiteC); goto CRASH;
         case YellowC: Yellows--; NewLevel(4); Show(R, C, WhiteC); goto CRASH;
         case BlackC: Row = R, Col = C; goto MOVE;
      }
   }
MOVE:
   Show(Row, Col, CyanC);
UPDATE:
   for (I = 0; I < 240; I++) {
      R = rand()%40, C = rand()%60; Hue = Image[R][C];
      if (Hue == RedC || Hue == YellowC) goto FOUND;
   }
   goto NEXT;
FOUND:
   Show(R, C, BlackC);
   R1 = R + (R < Row? +1: R > Row? -1: 0);
   C1 = C + (C < Col? +1: C > Col? -1: 0);
   switch (Image[R1][C1]) {
      case CyanC: Show(R1, C1, WhiteC); goto CRASH;
      case RedC: Reds--; NewLevel(8); goto BROWN;
      case YellowC: Yellows--; NewLevel(4);
      case BrownC: BROWN:
         Show(R1, C1, BrownC);
         if (Hue == RedC) Reds--, NewLevel(8);
         else Yellows--, NewLevel(4);
      goto NEXT;
      case BlackC: R = R1, C = C1, Show(R, C, Hue); break;
   }
   if (Hue != RedC) goto NEXT;
   Show(R, C, BlackC);
   R1 = R + (R < Row? +1: R > Row? -1: 0);
   C1 = C + (C < Col? +1: C > Col? -1: 0);
   switch (Image[R1][C1]) {
      case CyanC: Show(R1, C1, WhiteC); goto CRASH;
      case RedC: Reds--; NewLevel(8); goto BROWN2;
      case YellowC: Yellows--; NewLevel(4);
      case BrownC: BROWN2:
         Show(R1, C1, BrownC); Reds--, NewLevel(8);
      goto NEXT;
      case BlackC: Show(R1, C1, Hue); break;
   }
goto NEXT;
CRASH:
   NewLevel(-8192);
   PutString(27, 55, WhiteC, "MUNCH!!!");
   dB = 0;
COMPLETE:
   PutString(29, 55, WhiteC, "ENDED");
   while (1) switch (Keyboard()) {
      case 3: case 0x1b: ScrReset(); exit(0);
      case '\r':
         if (dB > 500) {
            unsigned dd = dB/500;
            Bombs += dd, dB -= 500*dd;
            PutString(29, 32, WhiteC, "%5d", Bombs);
         }
         PutString(27, 55, BlackC, "MUNCH!!!");
         PutString(29, 55, BlackC, "ENDED");
      goto RESTART;
   }
}
