/***************************************************************************/
/* RAND1.C                                                                 */
/* Externer Zufallsgenerator fr PC-Backgammon Pro                         */
/* Programmiersprache: Turbo-C, Autor: Michael Schellong                   */
/*                                                                         */
/* Dieses Beispiel-Programm soll Ihnen demonstrieren, wie Sie in C eigene  */
/* Zufallsgeneratoren fr PC-Backgammon Pro V2.0 schreiben knnen.         */
/* Der externe Zufallsgenerator wird von PC-Backgammon Pro zur Ermittlung  */
/* der Wrfelaugen aufgerufen. Als Parameter wird dem Generator ein Zeiger */
/* auf einen 32 Byte langen Speicherbereich bergeben, den er fr seine ei-*/
/* genen Zwecke frei verwenden kann. Beispielsweise knnen hier Variablen- */
/* Inhalte gespeichert werden, die beim nchsten Aufruf wieder bentigt    */
/* werden. Beim ersten Aufruf des Generators haben smtliche Bytes des     */
/* Speicherbereichs einen Wert von 0xFF.                                   */
/* Als Programmbeendigungs-Code muss die ermittelte Zufallszahl (im Bereich*/
/* von 1 bis 6) zurckgeliefert werden.                                    */
/***************************************************************************/

#include "time.h"
#include "stdio.h"
#include "stdlib.h"

unsigned long w;

/****************************************************/
/* Ermittelt eine Zufallszahl im Bereich 0..Range-1 */
/****************************************************/
unsigned MyRand(unsigned Range)
{
    w=w*0x15a4e35L+1;
    return (unsigned) (((w&0xFFFFu)*Range)/0x10000LU);
}

/******************************************/
/* Initialisierung des Zufallsgenerators  */
/******************************************/
void InitMyRand(void)
{
    w=(unsigned) time(NULL);
}


void main(int argc, char *argv[])
{
    int Val;
    void far *BufPtr;

    if (argc<2)                      /* Anzahl der Aufrufparameter abfragen */
        exit(0);

                                        /* Den als Aufrufparameter bergebenen
                                        Zeiger einlesen */
    sscanf(argv[1],"%x:%x",(unsigned *) &BufPtr+1, &BufPtr);

    if (*(unsigned long far*) BufPtr==0xFFFFFFFFL)
        InitMyRand();               /* Beim ersten Aufruf Zufallsgenerator
                                       initialisieren */
    else
        w=*(unsigned long far*) BufPtr; /* zwischengespeicherte Variable holen */

    Val=MyRand(6)+1;                /* Zufallszahl zwischen 1 und 6 ermitteln*/

    *(unsigned long far*) BufPtr=w; /* Variable w fr nchsten Aufruf sichern */

    exit (Val);                     /* Programm wieder beenden */
}
