#include <dsis.h>
#include <math.h>
#include <float.h>

#define  TRUE  1
#define  FALSE 0



struct BODY
{
 float mass;		  /* mass of the body */
 float radius;		  /* radius of body */
 float dfp;		  /* distance from primary including all radii */
 float circ;		  /* circumference of orbit */
 float arclen;		  /* length of orbit traveled in one timeslice */
 float scale;		  /* scale factor */
 float accum;		  /* accumulator */
 int   velocity;	  /* velocity along orbit */
 short moveit;		  /* flag set when it is time to move the body */
 short grad;		  /* graphic radius */
 short x;		  /* x postion on screen */
 short y;		  /* y postion */
 short lastx;		  /* last x position */
 short lasty;		  /* last y position */
 short color;		  /* color of trail */
 short degree;		  /* which degree in graphic circle 0-1023 */
 struct BODY *next;	  /* pointer to next body */
};





struct PRIMARY
{
 float mass;		  /* mass of primary */
 float radius;		  /* radius of primary */
 short x;		  /* x position */
 short y;		  /* y position */
 short color;		  /* color of it */
};


struct PRIMARY sun =
{
 2.00E30F,
 7.00E8F,
 320,
 240,
 9
};


struct BODY mars =
{
 3.95E24F,
 4.20E6F,
 3.02E11F,
 1.90E12F,
 1.86E9F,
 6.052896E8F,
 0,
 21017,
 0,
 100,
 420,
 240,
 0,
 0,
 10,
 0,
 0
};

struct BODY earth =
{
 5.98E24F,
 6.37E6F,
 1.51E11F,
 9.49E11F,
 9.27E8F,
 8.560224E8F,
 0,
 29723,
 0,
 50,
 370,
 240,
 0,
 0,
 9,
 0,
 &mars
};



void intstuff( void )
{
 static short count = 0;

 struct BODY *ptr;

 ptr = &earth;

 if( count & 1 )
  {
   do
    {
     ptr->accum += ptr->scale;

     if( ptr->accum >= ptr->arclen )
      {
       ptr->accum -= ptr->arclen;
       ptr->moveit = TRUE;
      }
    }while( (ptr = ptr->next) );
  }

 count++;
}

void main( void )
{
 struct BODY *ptr;

 short button, xpos, ypos;


 initmemory();
 initgraphics();
 inittimer();
// initvga();

 initmouse( 640, 480 );

 addtimer( intstuff );


 while( button != M_RBUT )
  {
   vertsyncstart();
   getmousepos( &button, &xpos, &ypos );

   ptr = &earth;

   do
    {
     if( ptr->moveit == TRUE )
      {
       ptr->moveit = FALSE;

       ptr->lastx = ptr->x;
       ptr->lasty = ptr->y;

       ptr->x = fixedmult(ptr->grad, intcos(ptr->degree));
       ptr->y = fixedmult(ptr->grad, intsin(ptr->degree));

       ptr->degree++;
       if( ptr->degree > 1023 )
	{
	 ptr->degree = 0;
	}

       drawrect( ptr->x, ptr->y, 2, 2, ptr->color );
      }
    }while( (ptr = ptr->next) );

   vertsync();
  }

 dsiexit();
}
