/* Labyrinth by Russell Wallace. Info in instructions within game. Developed
   using Aztec C. Use short integer compile option. Must be linked with
   intro1, intro2, intro3, strcomp, rnd and cliwindow object files. Please
   distribute this source code along with object code.

   This is the new slightly improved version. Forget about cliwindow, put
   input.o and console.o at the end of the link list instead - both those
   require the +L compile option with Aztec C. Also printnum.o (short int.)

   9 July 1988 version 1.01 recompiled with Aztec C 3.4a. Use makefile in
   this directory to recompile.

   8 November 1988 version 2.0 compiled with Aztec C 3.4a. Use makefile to
   compile.

	24 January 1991 ported to MS-DOS with Turbo C++
*/

#define TRUE 1
#define FALSE 0
#define MAXBUF 256

#define NUMCHAR 28	/* number of computer-controlled characters */
#define NUMCOIN 300
#define NUMTYPE 8	/* number of types of weapons */
#define NUMWEAP 6	/* number of weapons of each type */
#define INLEN 256	/* maximum input length */
#define WORDLEN 10	/* length of typed-in words i.e. names */
#define MAXX 19 	/* width of play area -1 */
#define MAXY 19 	/* height of play area -1 */
#define NUMLOC 400	/* number of locations */
#define NOWHERE -999	/* this location number means nonexistent */

#define xc(pos) ((pos-1)%20)		/* x-coordinate for location number */
#define yc(pos) ((pos-1)/20)		/* y-coordinate */
#define rnd(x)  (rand () % x)

#include	<stdio.h>
#include	<stdlib.h>
#include	<dos.h>

typedef char boolean;

boolean alldead;	/* All computer controlled characters dead */
boolean taken;		/* Character taken object */
boolean global; 	/* Global narration selected */
boolean verbose;	/* Verbose mode on */
boolean dead;		/* Character dead */
boolean err;		/* Command returns error */
boolean see;		/* Describe location */
boolean fought; 	/* Character has engaged in combat for this turn */

char key;
char *command;	/* Pointer to input buffer with command typed by player */
char target[WORDLEN];	/* Name of person player wants to attack */
char inword[WORDLEN];	/* Word from command string */
char inputbuffer[MAXBUF];

short i,j;		/* General purpose loop counter variables */
short index,z;
short thing;		/* Thing (weapon or coin) referred to */
short weapon;		/* Weapon being operated on */
short tarnum;		/* Number of target character for attack */
short atstre;		/* Strength of attack */
short atweap;		/* Weapon used in attack */
short charpos[NUMCHAR+1];   /* position of each character (player is char 0) */
short strength[NUMCHAR+1];  /* current strength, reduced by combat */
				/* if drops to 0, then death */
short power[NUMCHAR+1]; 	/* maximum strength, increases if win fight */
short coinpos[NUMCOIN+1],weapos[NUMTYPE+1][NUMWEAP+1];
short score;			/* player's score accumulated for several games */
short temppos;			/* temporary for character position */

long start ();
char *getstring ();

short hitval[NUMTYPE+1]=	/* attack value of each object type */
{
	0,
	80,105,52,110,47,49,22,12
};

char *obj_desc[]=
{
	"",
	" axe",
	" sword",
	" club",
	" mace",
	" knife",
	" dagger",
	" fist",
	" coin"
};

char *loc_adj[]=
{
	"dark ",
	"dank ",
	"damp ",
	"draughty ",
	"large ",
	"stony ",
	"long ",
	"small ",
	"pokey "
};

char *loc_noun[]=
{
	"cave.\n",
	"cavern.\n",
	"dungeon.\n",
	"tunnel.\n",
	"hallway.\n",
	"room.\n",
	"corridor.\n",
	"hall.\n",
	"chamber.\n"
};

char name_initial[]=	  /* Initial letters of all the objects */
{
	0,'a','s','c','m','k','d','f','c'
};

char *person_name[]=
{
	"",
	"David Watchorn",
	"Shane Broadberry",
	"Tara Morris",
	"Paul Whelan",
	"Bob Gray",
	"Garrett Simons",
	"Ian O'Keeffe",
	"Jason O'Brien",
	"Norman Ruddock",
	"Alan Callender",
	"Allen Dunne",
	"Nigel Waterhouse",
	"Nigel Cobbe",
	"Neill Spotswood",
	"Ruth Whittaker",
	"Ruth Laycock",
	"Susan Carroll",
	"Gillian Nother",
	"Hilary Usher",
	"Tara O'Rourke",
	"Sarah Gilliland",
	"Sarah Lessen",
	"Jennifer Gilliland",
	"Jennifer Nother",
	"Penny Jackson",
	"Emma Kelly",
	"Joanna Williams",
	"Fiona McDowell"
};

char *pername[]=
{
	"",
	"david",
	"shane",
	"tara",
	"paul",
	"bob",
	"garrett",
	"ian",
	"jason",
	"norman",
	"alan",
	"allen",
	"nigel",
	"nigel",
	"neill",
	"ruth",
	"ruth",
	"susan",
	"gillian",
	"hilary",
	"tara",
	"sarah",
	"sarah",
	"jennifer",
	"jennifer",
	"penny",
	"emma",
	"joanna",
	"fiona"
};

int printx,printy;

waitinput ()
{
	fflush (stdout);
	printy = 0;
	return bioskey (0) & 0x00ff;
}

void xprintc (int c)
{
	putchar (c);
}

void xprintn (char *s,int i)
{
	while (--i >= 0)
		putchar (*s++);
}

void xprint (char *s)
{
	while (*s)
		putchar (*s++);
}

void printmore ()
{
	xprint ("MORE...");
	waitinput ();
	xprint ("\r       \r");
	printx = 0;
}

void print (char *s)
{
	int i;
	if (!s)
		return;
	do
	{
		i = 0;
		while (s[i]!=0 && s[i]!=' ' && s[i]!='\n')
			i++;
		if (printx + i >= 79)
		{
			xprintc ('\n');
			printx = 0;
			printy++;
			if (printy >= 24)
				printmore ();
		}
		xprintn (s,i);
		printx += i;
		s += i;
		while (*s == ' ' || *s == '\n')
		{
			xprintc (*s);
			printx++;
			if (*s == '\n')
			{
				printx = 0;
				printy++;
				if (printy >= 24)
					printmore ();
			}
			s++;
		}
	}
	while (*s);
}

void writechar (int c)
{
	char s[2];
	s[1] = 0;
	s[0] = c;
	print (s);
	if (c == '\n')
		printx = 0;
}

void printnum (int n)
{
	char s[12];
	sprintf (s,"%d",n);
	print (s);
}

input (char *s,int n)
{
	gets (s);
	printx = printy = 0;
	return 0;
}

boolean legal (pos) 	/* Is location enterable or solid rock? */
short pos;
{
	if ((xc (pos)<0)||(xc (pos)>MAXX)||(yc (pos)<0)||(yc (pos)>MAXY))
	return (FALSE); /* if outside play area, obviously illegal */
	if ((xc (pos)%2==0)&&(yc (pos)%2==0))
	return (FALSE); /* also if in one of grid of "pillars" */
		else
		return (TRUE);
}

short numcoin (pos) 	/* number of coins in location */
			/* remember "location" 0..-28 means carried by character */
short pos;
{
	short i;
	short nc=0;
	for (i=1;i<=NUMCOIN;i++)
	if (coinpos[i]==pos)
		nc++;
	return (nc);
}

short numweap (pos,w)   /* number of weapons of type w in location */
short pos,w;
{
	short i;
	short nw=0;
	for (i=1;i<=NUMWEAP;i++)
	if (weapos[w][i]==pos)
		nw++;
	return (nw);
}

short numpos (pos)  	/* number of possessions (weapons+coins) in loc. */
short pos;
{
	short i;
	short np=0;
	for (i=1;i<=NUMTYPE-2;i++)
	np+=numweap (pos,i);
	return (np+numcoin (pos));
}

rlook (pos) 	/* Give text for location. This might be considered even */
		/* more inelegant than the above, but repeated ifs with */
		/* only one line each are more compact than a case. */
{
	print (" a ");
	print (loc_adj[(xc (pos)^yc (pos))%9]);
	print (loc_noun[((xc (pos)+1)^(yc (pos)+2))%9]);
}

look (pos)  /* look at a location from adjoining one */
short pos;
{
	if (legal (pos)==FALSE)
	print (" solid rock.\n");
		else
		rlook (pos);
}

locdesc (pos)   /* describe stuff in location */
short pos;
{
	short i;
	for (i=1;i<=NUMTYPE-2;i++)
	{
	if (numweap (pos,i)>0)
	{
		printnum (numweap (pos,i));
		print (obj_desc[i]);
		if (numweap (pos,i)!=1)
		writechar ('s');
		writechar ('\n');
	}
	}
	if (numcoin (pos)>0)
	{
	printnum (numcoin (pos));
	print (" coin");
	if (numcoin (pos)!=1)
		writechar ('s');
	writechar ('\n');
	}
}

getword (string)	/* splits word off string, puts it in inword */
char *string;
{
	short i,j;
	do
	index++;
	while (index<INLEN && string[index]!=' ');
	i=++index;
	for (j=0;j<WORDLEN && string[i]>='a' && string[i]<='z';j++)
	inword[j]=string[i++];
	if (j<WORDLEN)
	inword[j]='\0';
}

short getname (string)  /* which object is being referred to? */
char *string;
{
	int i;
	getword (string);
	if (inword[0]=='w')
	getword (string);   /* ignore "with" */
	for (i=1;i<=8 && name_initial[i]!=inword[0];i++)
	;
	if (i==3 && inword[1]=='o')
	i=8;
	if (i==9)
	{
	print ("There's no such object in this game!\n");
	i=0;
	}
	return i;
}

thing8 (first,second)
short first,second;
{
	short i;
	if (numcoin (first)==0)
	err=TRUE;
		else
			for (i=1;i<=NUMCOIN;i++)
				if (coinpos[i]==first)
					coinpos[i]=second;
}

weaptake (first,second,thing)
short first,second,thing;
{
	short i;
	for (i=1;i<=NUMWEAP;i++)
	if (weapos[thing][i]==first)
		weapos[thing][i]=second;
}

move (first,second,thing)
short first,second,thing;
{
	err=FALSE;
	if (thing==8)
	thing8 (first,second);
	if (thing==0 || thing==7)
	err=TRUE;
	if (thing!=0 && thing<7)
	{
		if (numweap (first,thing))
			weaptake (first,second,thing);
			else
				err=TRUE;
	}
}

drop (person,thing)
short person,thing;
{
	move (-person,charpos[person],thing);
}

perdesc (p,wordcase)		/* Oh God, not again! */
short p,wordcase;
{
	if (p==0)
	{
		if (wordcase)
			print ("You");
		else
			print ("you");
		return;
	}
	print (person_name[p]);
}

narrate (offense,defense,weapon)
short offense,defense,weapon;
{
	perdesc (offense,1);
	if (offense==0)
	print (" hit ");
		else
		print (" hits ");
	perdesc (defense,0);  /* Object of sentence */
	if (weapon==1)
	print (" with an");
		else
		print (" with a");
	print (obj_desc[weapon]);
	writechar ('.');
}

attack (offense,defense,weapon)
short offense,defense,weapon;
{
	short i;
	strength[defense]-=hitval[weapon];
	if (strength[defense]<1)
	{
	for (i=1;i<=NUMTYPE-2;i++)
		drop (defense,i);   /* drop weapons of dead victim */
	drop (defense,8);   	/* drop coins */
	temppos=charpos[defense];
	charpos[defense]=NOWHERE;
	power[offense]+=power[defense]/4;
	}
	if (charpos[offense]==charpos[0])
	{
	narrate (offense,defense,weapon);
	writechar ('\n');
	}
	else
		if (global)
		{
		writechar ('(');
		narrate (offense,defense,weapon);
		print (")\n");
		}
	if (strength[0]<1 && defense==0)
	{
	print ("You have died.\n");
	dead=TRUE;
	}
	if (strength[defense]<0 && defense && (global || temppos==charpos[0]))
	{
	if (temppos!=charpos[0])
		writechar ('(');
	perdesc (defense,1);
	print (" dies.");
	if (temppos!=charpos[0])
		writechar (')');
	writechar ('\n');
	}
}

population (pos)	/* Tell who else is here */
short pos;
{
	short i;
	for (i=1;i<=NUMCHAR;i++)
	{
	if (charpos[i]==pos)
	{
		perdesc (i,1);
		print (" is here.\n");
		if (numpos (-i))
		{
		if (i<15)
			print ("He is carrying:\n");
			else
				print ("She is carrying:\n");
		locdesc (-i);
		}
		if (i<15)
		print ("His strength is ");
			else
			print ("Her strength is ");
		printnum (strength[i]);
		writechar ('\n');
	}
	}
}

take (person,thing)
short person,thing;
{
	move (charpos[person],-person,thing);
	if (person && charpos[person]==charpos[0])
	{
	perdesc (person,0);
	print (" takes the");
	print (obj_desc[thing]);
	print (".\n");
	}
}

walk (person,d)
short person,d;
{
	err=FALSE;
	if (d==0)
	d=-(MAXX+1);
	if (d==1)
	d=MAXX+1;
	if (d==2)
	d=1;
	if (d==3)
	d=-1;
	if (legal (charpos[person]+d)==FALSE)
	err=TRUE;
		else
		{
			charpos[person]+=d;
			if (person && charpos[person]==charpos[0])
			{
				perdesc (person,1);
				print (" arrives.\n");
			}
		}
}

otget (person)  /* Make character grab everything possible */
short person;	/* Purpose of order here is to make character take most */
{		/* powerful weapons first. */
	taken=TRUE;
	if (numweap (charpos[person],4)) take (person,4); else
	if (numweap (charpos[person],2)) take (person,2); else
	if (numweap (charpos[person],1)) take (person,1); else
	if (numweap (charpos[person],3)) take (person,3); else
	if (numweap (charpos[person],6)) take (person,6); else
	if (numweap (charpos[person],5)) take (person,5); else
	if (numcoin (charpos[person])) take (person,8); else
	taken=FALSE;
}

main ()
{
	struct dos_time_t T;
	dos_gettime (&T);
	srand (((T.minute/12)*6000) + T.second*100 + T.hsecond);
	verbose=TRUE;
AGAIN:
	dead=FALSE;
	print ("Welcome to Labyrinth by Russell Wallace.\n");
	print ("Do you want instructions? (Y/N) : ");
	if (yesno ())
	{
	 print ("Labyrinth was originally written in Pascal on a PDP 11-73 \
minicomputer, converted to C and ported to the Amiga, and then in this version \
ported to MS-DOS.\n\
Labyrinth is a role-playing game in which \
you wander around a series of underground caves fighting the \
computer-controlled characters and amassing treasure. The ultimate \
object of the game is to kill all the other characters having \
collected as many as possible of the 300 or so coins lying around \
the caves. The other characters will be doing the same thing, and \
will usually attack anyone they see including you. If attacked, \
use your most effective weapon (your fist if nothing else is \
available). Blows will reduce your strength; if this falls to zero \
you die. As time passes it will gradually build up again but can \
never exceed your power. Everyone starts with a power of 300 and \
if you kill somebody, a quarter of their power is added to yours, \
and you can pick up anything they might have been carrying. When \
everyone else is dead your money will be added to your score which \
will be carried over to the next game.\n\
Labyrinth is a work of fiction and no similarity to any real \
places or events is intended or implied, however most of the \
computer-controlled characters are named after people from my \
class in St. Andrews College in order to make the game more \
interesting.\n\
The following commands are available:\n\
TAKE object 		   - pick up something\n\
DROP object 		   - put down something\n\
HIT person WITH object - commit an act of violence\n\
INVENTORY   		   - list your possessions etc.\n\
VERBOSE 			   - describe surrounding locations\n\
BRIEF   			   - only describe current location\n\
NORTH,SOUTH,EAST,WEST  - move around\n\
QUIT				   - terminate game\n\
LOCAL   			   - narrate events only where you are\n\
GLOBAL  			   - narrate combat elsewhere in brackets\n\
REDESCRIBE  			 current location\n\
All commands can be abbreviated to the first letter, and the word \
WITH can be omitted entirely. Refer to people by first names only. \
Object names can also be abbreviated to one or two letters.\n\n\
Press any key to start ");
	if (waitinput ()==-1000)
	{
		exit (0);
	}
	}
	 writechar ('\n');
	do
{	/* This loop will execute as long as game not over */
	for (i=0;i<=NUMCHAR;i++)
	{
	charpos[i]=rnd (NUMLOC-1)+1;
	if (legal (charpos[i])==FALSE)
		charpos[i]++;
	power[i]=strength[i]=300;
	}
	for (i=1;i<=NUMTYPE-2;i++)
	for (j=1;j<=NUMWEAP;j++)
		weapos[i][j]=rnd (NUMLOC)+1;
	for (i=1;i<=NUMCOIN;i++)
	coinpos[i]=rnd (NUMLOC)+1;
	see=TRUE;	/* Describe location game starts in */
	do
{	/* This loop will execute until game over or won */
	if (see)
	{
	print ("You are in");
	look (charpos[0]);
	population (charpos[0]);
	if (numpos (charpos[0]))
	{
		print ("You can also see:\n");
		locdesc (charpos[0]);
	}
	if (verbose)
	{
		print ("To the north you can see");
		look (charpos[0]-(MAXX+1));
		print ("To the south you can see");
		look (charpos[0]+MAXX+1);
		print ("To the east you can see");
		look (charpos[0]+1);
		print ("To the west you can see");
		look (charpos[0]-1);
	}
	see=FALSE;
	}
	print ("What now? :");
	command=getstring ();
	for (i=0;i<INLEN;i++)
	command[i]=tolower (command[i]);
	index=0;
	if (command[0]=='l')
	global=FALSE;
	if (command[0]=='g')
	global=TRUE;
	if (command[0]=='b')
	verbose=FALSE;
	if (command[0]=='v')
	verbose=TRUE;
	if (command[0]=='i')
	{
	if (numpos (0)==0)
		print ("You are emptyhanded.\n");
		else
		{
			print ("You are carrying:\n");
			locdesc (0);
		}
	print ("Your strength is ");
	printnum (strength[0]);
	print ("\nYour power is ");
	printnum (power[0]);
	print ("\nYour score is ");
	printnum (score+numcoin (0));
	writechar ('\n');
	}
	if (command[0]=='q')
	{
	print ("OK, so long.\n");
	dead=TRUE;
	goto FINISH;
	}
	if (command[0]=='t')
	{
	thing=getname (command);
	if (thing==7)
		print ("It seems to be attached to your arm.\n");
		else
			if (thing)
			{
			take (0,thing);
			if (err)
				print ("I see none here.\n");
				else
					print ("Taken.\n");
			}
	}
	if (command[0]=='d')
	{
	thing=getname (command);
	if (thing==7)
		print ("Amputation is very unpleasant.\n");
		else
			if (thing)
			{
			drop (0,thing);
			if (err)
				print ("You have none to drop.\n");
				else
					print ("Dropped.\n");
			}
	}
	if (command[0]=='r')
	see=TRUE;
	if (command[0]=='n')
	walk (0,0);
	if (command[0]=='s')
	walk (0,1);
	if (command[0]=='e')
	walk (0,2);
	if (command[0]=='w')
	walk (0,3);
	if (command[0]=='n' || command[0]=='s' || command[0]=='e' || command[0]=='w')
	if (err)
		print ("You bang your face off the wall as you attempt this.\n");
		else
			see=TRUE;
	if (command[0]=='h')
	{
	getword (command);
	tarnum=0;
	for (i=1;i<=NUMCHAR;i++)
		if (strcmp (inword,pername[i])==0 && charpos[i]==charpos[0])
		tarnum=i;
	if (tarnum==0)
		print ("There is nobody here by that name.\n");
		else
		{
			weapon=getname (command);
			if (weapon)
			if (numweap (0,weapon)==0)
				print ("You have none to use.\n");
				else
					attack (0,tarnum,weapon);
		}
	}
	for (i=1;i<=NUMCHAR;i++)	/* Now handle computer characters */
	{
	otget (i);  	/* Grab everything in sight */
	if (taken==0) { /* If nothing to take, then fight */
	fought=FALSE;
	j=-1;
	do
	{   /* look for someone to fight */
		j++;
		if (charpos[i]==charpos[j] && i!=j && charpos[i]!=NOWHERE)
		{
		fought=TRUE;	/* found someone, now choose weapon */
		atstre=22;
		atweap=7;	/* default weapon is fist */
		for (z=1;z<=NUMTYPE-2;z++)
		{
			if (hitval[z]>atstre && numweap (-i,z))
			{
			atweap=z;
			atstre=hitval[z];
			}
		}
		}
	}
	while (fought==0 && j<NUMCHAR);
	if (fought)
		attack (i,j,atweap); }
	if (taken==0 && fought==0)
		walk (i,rnd (4));   /* if nothing else to do, wander around */
	}
	alldead=TRUE;
	for (i=0;i<=NUMCHAR;i++)
	{
	if (i && charpos[i]>NOWHERE)
		alldead=FALSE;
	strength[i]+=6; 	/* gradual recovery */
	if (strength[i]>power[i])
		strength[i]=power[i];
	}
}
	while (dead==FALSE && alldead==FALSE);
	score+=numcoin (0);
	if (alldead)
	print ("Congratulations ... you've killed everyone else in the game! A new game is now starting, with your money from the old added to your score.\n");
}
	while (dead==FALSE);
FINISH:
	score=0;
	print ("Game over. Would you like to play again? (Y/N) : ");
	if (yesno ())
	goto AGAIN;
}

char *getstring ()
{
	if (input (inputbuffer,MAXBUF)==-1000)
	{
	exit (0);
	}
	return (inputbuffer);
}

int yesno ()
{
	char c;
	do
	c=waitinput ();
	while (c!='y' && c!='Y' && c!='n' && c!='N');
	writechar (c);
	writechar ('\n');
	return (c=='y' || c=='Y');
}

