 {La Belle Lucie solitaire game (variation) in Turbo Pascal}
 program labelle(input,output,outdeck);
  uses crt;
  const brdtxt=black; msgbck=black; brdbck=white; msgtxt=white;
  {declarations}
   const pilesize=4;
   type
    {aggregate types}
     tabrec= record last,number,space,row,col:byte; end;
     cardrec= record suit,denom,prev,next:byte; end;
     tabletyp= array[1..18] of tabrec;
     odtyp= file of cardrec;
     decktyp= array[0..53] of cardrec;
   var
    blanks: string[40];
    pic: string[27];
    instring: string[6];
    {aggregate variables}
     deck: decktyp; table: tabletyp; outdeck: odtyp;
     plays,script: text; pile: array[3..6] of 0..13;
    i,j: byte; wk1:char;
    ni,nj,np,ptime: integer;
    autoplay,control,ingame: boolean;
    nshift: shortint;
    hcpile,ntop,nboard,nptop: byte;
  {internal procedures}
   procedure buzz;
    {make a raspberry}
     begin
      write(plays,'<=XX;'); np:=np+5;
       sound(50); delay(750); nosound;
     end;
   procedure unload;
    {unload a deal to disk}
     var i: byte;
     begin
      rewrite(outdeck);
       for i:=1 to 52 do write(outdeck,deck[i]);
      close(outdeck);
     end;
   procedure reload;
    {reload a saved deal from disk}
     var i: byte;
     begin
      reset(outdeck);
       for i:=1 to 52 do read(outdeck,deck[i]);
      close(outdeck);
     end;
   procedure shuffle;
    {shuffle deck of 52 cards}
    var i,j,t: byte;
    begin
     {swap card identities; don't rearrange cards}
     for i:=52 downto 3 do begin
      j := 1+random(i-1); t := deck[i].suit;
      deck[i].suit := deck[j].suit; deck[j].suit :=t;
      {swap denoms, having done suits}
       t := deck[i].denom;
       deck[i].denom := deck[j].denom;
       deck[j].denom :=t;
     end;
     unload;
    end;
   procedure create;
    {create deck of 52 cards in new deck order}
    var i: byte;
    begin
     for i:=1 to 52 do with deck[i] do begin
      suit:=3+((i-1) div 13);
      denom:=1+((i-1) mod 13);
      {pointer inits}
       prev:=i-1;
       next:=i+1;
     end;
     shuffle;
    end;
   procedure blankpile(x,y,n:byte);
    {blank a pile on the table}
     var i:byte;
     begin
      for i:=0 to 3 do begin
       textbackground(brdbck);
       gotoxy(y,x+i); write(copy(blanks,1,n));
       textbackground(brdbck);
      end;
     end;
   procedure showone(card,row,col:byte);
    {show a single card on the table}
    begin with deck[card] do begin
     if suit<=4 then
      textcolor(red)
     else
      textcolor(black);
     gotoxy(col,row); write(copy(pic,2*denom,2));
      gotoxy(col,row+1); write(' ',chr(suit));
     end end;
   procedure showtable;
    {display entire table on screen}
     var cpile,i,j,k: byte;
     begin {showtable}
      cpile:=1;
      while table[cpile].number=0 do begin
       blankpile(table[cpile].row,table[cpile].col,table[cpile].space);
       cpile:=succ(cpile);
      end;
      k:=0;
      j:=0;
      i:=deck[0].next;
      textbackground(brdbck);
      repeat with table[cpile] do begin
       showone(i,row+1,col+j);
        textcolor(brdtxt);
        {make marker}
         k:=succ(k); gotoxy(col+j,row+3);
         if k = pilesize then begin
          write(' |'); k:=0;
         end
         else write('  ');
       gotoxy(col+j,row);
       if last=i then begin
        write(cpile:2);
        blankpile(row,col+j+2,space-j-2);
        j:=0;
        if deck[i].next<>53 then begin
         cpile:=succ(cpile);
         while table[cpile].number=0 do begin
          with table[cpile] do blankpile(row,col,space);
          cpile:=succ(cpile);
         end;
        end;
       end
       else begin
        write('  '); j:=j+2;
       end;
       i:=deck[i].next;
      end until i=53;
      if table[cpile].number>0 then cpile:=succ(cpile);
      blankpile(table[cpile].row,table[cpile].col+j,table[cpile].space);
      for i:= cpile+1 to hcpile do begin
       blankpile(table[i].row,table[i].col,81-table[i].col);
       table[i].number:=0;
      end;
      hcpile:=cpile;
      textbackground(msgbck);
      textcolor(msgtxt);
     end;
   procedure shift;
    {modify table control info to effect shift}
    var cpile,i,k,rn: byte;
    begin
     nshift:=succ(nshift);
      gotoxy(31,23);
       write(nshift:2);
        for i:=1 to 2 do blankpile(5*i-1,71,10);
     k := 0; cpile := 1; table[1].col := 1;
     for i:=1 to hcpile do begin
      table[i].number:=pilesize; table[i].space:=2*pilesize+6;
     end;
     rn := 4; table[1].row := 4; i:=deck[0].next;
     repeat
      k:=succ(k);
      if k = pilesize then begin
       table[cpile].last:=i;
       k:=0;
       cpile:=succ(cpile);
       table[cpile].col := table[cpile-1].col+6+2*pilesize;
       if ((pilesize=3) and ((cpile mod 6)=1)) or
       ((pilesize=4) and ((cpile mod 5)=1)) then begin
        rn := rn+5;
        table[cpile].col := 1;
       end;
       table[cpile].row := rn;
      end;
      i:=deck[i].next
     until i=53;
     table[cpile].number:=k;
     table[cpile].space:=81-table[cpile].col;
     if table[cpile].space>24 then table[cpile].space:=24;
     if k>0 then table[cpile].last:=deck[53].prev
     else cpile:=pred(cpile);
     showtable;
    end;
   procedure piletotop(pfrom:byte);
    {play card from table to aces foundation at top}
    var ifr: byte;
    begin
     ifr:=table[pfrom].last;
     {legal move?}
      if table[pfrom].number=0 then begin
       buzz; exit
      end;
      if pile[deck[ifr].suit]+1<>deck[ifr].denom then begin
       buzz; exit
      end;
     pile[deck[ifr].suit]:=deck[ifr].denom;
     table[pfrom].number:=pred(table[pfrom].number);
     {output foundation change}
      textbackground(brdbck);
       if deck[ifr].suit<=4 then
        textcolor(red)
       else
        textcolor(black);
       gotoxy(2+4*deck[ifr].suit,2);
        write(copy(pic,2*deck[ifr].denom,2),chr(deck[ifr].suit));
       textcolor(msgtxt);
      textbackground(msgbck);
     table[pfrom].last:=deck[ifr].prev;
     deck[deck[ifr].prev].next:=deck[ifr].next;
      deck[deck[ifr].next].prev:=deck[ifr].prev;
     {update status logs}
      ntop:=succ(ntop);
       gotoxy(1,23);
        write(ntop:2);
      nboard:=pred(nboard);
       gotoxy(16,23);
        write(nboard:2);
     {must showtable for marker adjustment}
     if nboard>0 then showtable
     else blankpile(table[pfrom].row,table[pfrom].col,table[pfrom].space);
    end;
   procedure piletopile(pfrom,pto:byte);
    {play from pile to pile on table}
     var i,ih,ifr,ipos,ito: byte;
     begin {piletopile}
      ifr:=table[pfrom].last; ito:=table[pto].last;
      {is move o.k. to do?}
       if table[pfrom].number=0 then begin
        buzz; exit
       end
       else
        if deck[ifr].suit<>deck[ito].suit then begin
         buzz; exit
        end
        else
         if deck[ifr].denom+1<>deck[ito].denom then begin
          buzz; exit
         end;
       nptop:=succ(nptop); gotoxy(50,23); write(nptop:4);
      table[pfrom].last:=deck[ifr].prev;
      deck[deck[ifr].prev].next:=deck[ifr].next;
      deck[deck[ifr].next].prev:=deck[ifr].prev;
      deck[deck[ito].next].prev:=ifr;
      deck[ifr].next:=deck[ito].next;
      deck[ifr].prev:=ito;
      deck[ito].next:=ifr;
      {update layout controls to reflect move}
       table[pfrom].number:=pred(table[pfrom].number);
        table[pto].number:=succ(table[pto].number);
       if 2*table[pto].number>=table[pto].space then begin
        table[pto].space:=6+table[pto].space;
        ih:=i; i:=succ(pto);
         while table[i].row=table[pto].row do begin
          table[i].col:=table[i].col+6;
          ih:=i;
          i:=succ(i);
         end;
        {ih points to last pile of row on screen}
        if table[ih].col+2*table[ih].number>80 then begin
         i:=0; repeat i:=succ(i) until table[i].row=table[pto].row;
         table[i].space:=2*table[i].number+2; i:=succ(i);
         while table[i].row=table[pto].row do begin
          table[i].col:=table[i-1].col+table[i-1].space;
          table[i].space:=2*table[i].number+2;
          i:=succ(i);
         end;
         ipos:=table[i-1].col+2*table[i-1].number;
         blankpile(table[i-1].row,ipos,81-ipos);
        end
        else if table[ih].col+table[ih].space>80 then
        table[ih].space:=81-table[ih].col;
        blankpile(table[ih].row,table[ih].col,table[ih].space);
       end;
       table[pto].last:=ifr;
      {must showtable for marker adjustment}
      showtable;
     end;
  {main routine}
   begin
    clrscr; assign(outdeck,'labelle.dck');
     blanks:='                                        ';
      assign(plays,'labelle.ply');
    val(paramstr(1),ptime,ni);
    textcolor(msgtxt); textbackground(msgbck);
     gotoxy(1,18);write('n1 n2: moves from pile n1 to pile n2.');
     gotoxy(1,19);write('n1 t: moves from pile n1 to top:aces.');
     gotoxy(1,20);write('s: shifts to reform piles of 4.');
    gotoxy(1,22); write('num to top');
    gotoxy(16,22); write('num on board');
    gotoxy(31,22); write('num shifts done');
    gotoxy(50,22); write('num board moves done');
    control :=true;
    pic := '  A 2 3 4 5 6 7 8 910 J Q K';
    randomize;
    while control do begin
     {initialization}
      gotoxy(14,2);
       write(blanks);
        {covers previous foundation in next games}
      ntop :=0; np:=0; rewrite(plays); autoplay:=false;
       gotoxy(1,23);
        write(' 0');
      nboard :=52; gotoxy(16,23); write('52');
       nshift:=-1; gotoxy(31,23); write(' 0');
        nptop:=0; gotoxy(50,23); write('   0');
     if pilesize=4 then hcpile:=13
     else hcpile:=18;
     for i:=3 to 6 do pile[i]:=0;
     deck[0].next:=1;deck[53].prev:=52;
     {existing deal?};
      gotoxy(1,24); write('want a replay?(r/n)',blanks);
       gotoxy(40,24); readln(instring);
        gotoxy(40,24); write(blanks);
      if (instring[1]='R') or (instring[1]='r') then begin
       reload;
       gotoxy(1,24); write('any autoplay of it?(y/n)');
        gotoxy(40,24); readln(instring);
        gotoxy(40,24); write(blanks);
       if (instring[1]='y') or (instring[1]='Y') then begin
        assign(script,'labelle.ans');
        autoplay:=true; reset(script);
       end
       else autoplay:=false;
      end
      else create;
     shift; ingame:=true;
     {loop acting on instructions}
     while ingame do begin
      gotoxy(40,24);
      if autoplay then begin
       instring:=''; read(script,wk1);
       repeat
        instring:=instring+wk1;
        read(script,wk1);
       until wk1=';';
       write(instring);
       delay(ptime);
       if eoln(script) then readln(script);
       if eof(script) then autoplay:=false;
      end
      else readln(instring);
      write(plays,instring,';');
      np:=succ(np)+length(instring);
      if np>64 then begin
       np:=0; writeln(plays);
      end;
      gotoxy(40,24);
      write(blanks);
      case instring[1] of
       '0'..'9':begin
        gotoxy(1,24); write(blanks);
        case instring[2] of
         '0'..'8':begin
          val(copy(instring,1,2),ni,nj);
          delete(instring,2,1);
         end;
         else
          val(instring[1],ni,nj)
        end;
        i:=ni;
        delete(instring,1,1);
        if pos('T',instring)+pos('t',instring)>0 then begin
         piletotop(i);
         if nboard=0 then begin
          textcolor(brdtxt+blink);
          gotoxy(1,24); write('YOU WON <====',blanks);
          delay(5000); ingame:=false;
          textcolor(brdtxt);
         end;
        end
        else begin
         if instring[1]=' ' then delete(instring,1,1);
         val(instring,nj,ni);
         if ni<>0 then begin
          gotoxy(1,24); write('bad second number',blanks);
          buzz
         end;
         j:=nj; piletopile(i,j);
        end
       end;
       's','S':begin
        shift; gotoxy(1,24);
        if (pilesize=3) and (nshift>=4) then begin
         ingame := false;
          write('Game lost.',blanks); buzz; buzz; buzz;
        end
        else write(blanks);
       end;
       'q','Q':begin
        ingame:=false;
         gotoxy(1,24);
          write(blanks);
       end;
       else begin
        gotoxy(1,24);
         textcolor(msgtxt+blink);
          write('unrecognized input',blanks); buzz;
         textcolor(msgtxt);
       end;
      end;
     end;
     close(plays); textcolor(brdtxt);
     {ask if want to play again}
      textcolor(brdtxt); textbackground(brdbck);
      gotoxy(1,24); write('play again? (y/n)',blanks);
       gotoxy(40,24); readln(instring);
        gotoxy(40,24); write(blanks);
      gotoxy(1,24); write(blanks);
       if (instring[1]='N') or (instring[1]='n') then
        control := false;
    end;
   end.
