unit Misc;

interface

uses Crt,Graph,Globals;

function Exist(FileName:string):boolean;
function Lowest (a,b:integer):integer;
function DeCode (Txt:string) :string;
procedure TextSize (mx,dx,my,dy:word);
function St(num:integer):str80;
procedure Sound (Frq : integer);
procedure Delay (Ms : integer);
procedure Black (x,y,x1,y1:word);
procedure FindFile (FilName :string);

implementation

function Exist(FileName:string):boolean;
var
  fil:file;
begin
  Assign (Fil,FileName); {$I-}
  Reset (Fil);           {$I+}
  if IOresult<>0 then Exist := False
  else begin
    Close (Fil);
    Exist:=(IOResult=0);
  end;
end;

function Lowest (a,b:integer):integer;
begin
  if a<b then Lowest:=a else Lowest:=b;
end;

function DeCode (Txt:string) : string;
var Ctr:byte;
begin
  for Ctr:=1 to Length(Txt) do
    Dec (Txt[Ctr], 128);
  DeCode := Txt;
end;

procedure TextSize (mx,dx,my,dy:word);
begin
  SetUserCharSize (mx,dx,my,dy);
  SetTextStyle (SmallFont,HorizDir,UserCharSize);
end;

function St(num:integer):str80;
var strg:str80;
begin
  Str(num,strg);
  St:=strg;
end;

(*procedure Sound1 (Frq : integer);
begin
  Sound (Frq);
end;*)
procedure Sound (Frq : integer);
begin
  if Noise then Crt.Sound (Frq);
end;

(*procedure Delay1 (Ms : integer);
begin
  Delay (Ms);
end;*)
procedure Delay (Ms : integer);
begin
  Crt.Delay (Ms * ((Pause div 10)+1));
end;

procedure Black (x,y,x1,y1:word);
begin
  SetViewPort (x,y,x1,y1,ClipOn);
  ClearViewPort;
  SetViewPort (0,0,319,199,ClipOn);
end;

procedure FindFile (FilName : string);
begin
  if not Exist (FilName) then begin
    TextMode (Co80);
    Writeln ('SPACE ADVENTURE error :');
    Writeln ('The file ',FilName,' is missing !');
    Halt;
  end;
end;

end.