        cpu 8086
        org 0x100

        section .text

start:
.freeMemory:
        mov ah, 0x4a
        mov bx, 0x1000
        int 0x21
.setVector:
        xor ax, ax
        mov ds, ax
        cli
        mov ax, word [0x13*4]
        mov bx, word [0x13*4+2]
        mov word [cs:oldDiskVector], ax
        mov word [cs:oldDiskVector+2], bx
        mov word [0x13*4], newDiskVector
        mov word [0x13*4+2], cs
        sti
        mov ax, cs
        mov ds, ax
.exec:
        mov word [ep_envSeg], 0
        mov word [ep_cmdLine], commandLine
        mov word [ep_cmdLine+2], ds
        mov word [ep_fcb1], defaultFCB
        mov word [ep_fcb1+2], ds
        mov word [ep_fcb2], defaultFCB
        mov word [ep_fcb2+2], ds
        mov ax, 0x4b00
        mov dx, commandName
        mov bx, execParams
        int 0x21
.resetVector:
        xor ax, ax
        mov ds, ax
        cli
        mov ax, word [cs:oldDiskVector]
        mov bx, word [cs:oldDiskVector+2]
        mov word [0x13*4], ax
        mov word [0x13*4+2], bx
        sti
        mov ax, cs
        mov ds, ax
.quit:
        int 0x20

newDiskVector:
        cmp ax, 0x0401
        jne .chain
        cmp cx, 0x2780
        jne .chain
        cmp dx, 0x0000
        jne .chain
.fix:
        push bp
        mov bp, sp
        or word [bp+6], 1
        mov ax, 0x1000
        pop bp
        iret
.chain:
        jmp far [cs:oldDiskVector]

        section .data

commandName:
        db "ICON.EXE", 0

commandLine:
        db 0, 0x0d

defaultFCB:
        times 38 db 0

        section .bss

oldDiskVector:  resd 1

execParams:
ep_envSeg:      resw 1
ep_cmdLine:     resd 1
ep_fcb1:        resd 1
ep_fcb2:        resd 1
