;
; Patch for Tetris Classic
;
; Please note that this file works on the Unpklite'd exe file ONLY. If you
; don't run Pklite -x on TETRISC.EXE first there is no telling what damage can
; be done!
;


code          SEGMENT
              ASSUME         CS:code,DS:code
              ORG            100h

strt:
;
;Print introductory message
;
              MOV            DX,OFFSET welcome   ;offset of message
              MOV            AH,09h
              INT            21h

;
;Open TETRISC.EXE
;
              MOV            AL,1                ;Write only operation
              MOV            DX,OFFSET fname     ;move fname to DX
              MOV            AH,3Dh              ;open file
              INT            21h
              MOV            handle,AX           ;save file handle
              JNC            open_ok             ;jump if no errors
              PUSH           AX                  ;push error code onto stack
              JMP            error               ;jump to error routine

open_ok:
;
;Move the file pointer
;
              MOV            BX,handle           ;move file handle to bx
              MOV            CX,0001h            ;ms offset to move pointer
              MOV            DX,0F48Ah           ;ls offset to move pointer
              CALL           move_pointer
              JNC            write_patch         ;jump if no errors
              PUSH           AX                  ;push error code onto stack
              JMP            error               ;jump to error routine

write_patch:
;
;Write the byte patch. Here we force a conditional jump to be true by
;changing the original byte of 7403h to EB03h.
;This is a conditional jump taken after a byte is checked to see if the doc
;check has already been answered.
;
              MOV            DX,OFFSET force_jmp ;move data to DX
              MOV            CX,0001             ;number of bytes to write
              MOV            AH,40h              ;write to file
              INT            21h
              JNC            write_ok            ;jump if no errors
              PUSH           AX                  ;push error onto stack
              JMP            error               ;jump to error routine

write_ok:
;
;Close the file
;
              MOV            AH,3Eh              ;close file
              INT            21h
              JNC            exit                ;jump if no errors & exit
              PUSH           AX                  ;push error onto stack

error:
;
;Parse the error code returned from the system and display
;The appropriate error message
;
              POP            AX                  ;return error code

              CMP            AX,1
              JE             code1
              CMP            AX,2
              JE             code2
              CMP            AX,3
              JE             code3
              CMP            AX,4
              JE             code4
              CMP            AX,5
              JE             code5
              CMP            AX,6
              JE             code6


              MOV            DX,OFFSET nocode    ;no matching error code
              JMP            print_error
code1:        MOV            DX,OFFSET error1    ;invalid function
              JMP            print_error
code2:        MOV            DX,OFFSET error2    ;file not found
              JMP            print_error
code3:        MOV            DX,OFFSET error3    ;path not found
              JMP            print_error
code4:        MOV            DX,OFFSET error4    ;no handle available
              JMP            print_error
code5:        MOV            DX,OFFSET error5    ;access denied
              JMP            print_error
code6:        MOV            DX,OFFSET error6    ;handle invalid
              JMP            print_error

;
;Display error code to user
;
print_error:
              MOV            AH,09h              ;display string
              INT            21h

;
;Now we are done so let's close up shop
;
exit:
              MOV            DX,OFFSET goodbye
              MOV            AH,09h
              INT            21h

              MOV            AX,04C00h           ;terminate program
              INT            21h


move_pointer  PROC

              MOV            AL,00               ;move pointer from beginning
              MOV            AH,42h              ;move file pointer
              INT            21h
              RET
move_pointer  ENDP


;
;Data area
;
fname         DB             'TETRISC.EXE',0
welcome       DB             'Generic Patch Maker v1.0',13,10
              DB             'Designed by Jake Pickett',13,10,10
              DB             'Please wait while Tetris Classic is being '
              DB             'patched.',13,10,'$'
goodbye       DB             'Thank you for choosing INC!',13,10,'$'
nocode        DB             '<<Unkown Error Code>>',13,10,'$'
error1        DB             '<<Invalid Function>>',13,10,'$'
error2        DB             '<<File Not Found>>',13,10,'$'
error3        DB             '<<Path Not Found>>',13,10,'$'
error4        DB             '<<No Handle Available>>',13,10,'$'
error5        DB             '<<Access Denied>>',13,10,'$'
error6        DB             '<<Handle Invalid Or Not Open>>',13,10,'$'
force_jmp     DB             0EBh
handle        DW             ?

code          ENDS
              END            strt