;
;        FILE: ADVDATA2.ASM  -  SEA SEARCH
;

VERBTB   EQU $
         DB  'LOOK',1
         DB  'L   ',1
         DB  'EXAM',1
         DB  'INVE',2
         DB  'I   ',2
         DB  'G   ',3
         DB  'GET ',3
         DB  'TAKE',3
         DB  'GRAB',3
         DB  'PUT ',4
         DB  'DROP',4
         DB  'P   ',4
         DB  'NORT',5
         DB  'N   ',5
         DB  'SOUT',6
         DB  'S   ',6
         DB  'EAST',7
         DB  'E   ',7
         DB  'WEST',8
         DB  'W   ',8
         DB  'UP  ',9
         DB  'U   ',9
         DB  'DOWN',10
         DB  'D   ',10
         DB  'GO  ',11
         DB  'WALK',11
         DB  'RUN ',11
         DB  'ENTE',11
         DB  'QUIT',12
         DB  'SAVE',13
         DB  'LOAD',14
         DB  'HELP',15
         DB  'DIG ',16
         DB  'PRES',17
         DB  'PUSH',17
         DB  'GIVE',18
         DB  'FILL',19
         DB  'CLIM',20
         DB  'CLOS',21
         DB  'SHUT',21
         DB  'OPEN',22
         DB  'UNLO',23
         DB  'BREA',24
         DB  'BUST',24
         DB  'CRAC',24
         DB  'SCOR',25
         DB  'READ',26
         DB  'MOVE',27
         DB  'ROLL',27
         DB  'PULL',28
         DB  'TIE ',29
         DB  0

NOUNTB   EQU $
         DB  'NORT',1
         DB  'SOUT',2
         DB  'EAST',3
         DB  'WEST',4
         DB  'UP  ',5
         DB  'DOWN',6
         DB  'INVE',7
         DB  'META',8
         DB  'DETE',8
         DB  'MIRR',9
         DB  'SHOV',10
         DB  'SPAD',10
         DB  'TANK',11
         DB  'SILV',12
         DB  'KEY ',13
         DB  'DIAM',14
         DB  'RING',14
         DB  'BOTT',15
         DB  'CARD',17
         DB  'CRED',17
         DB  'PEAR',18
         DB  'NOTE',19
         DB  'KEG ',20
         DB  'RUM ',20
         DB  'RUBY',21
         DB  'STAT',21
         DB  'NEWS',22
         DB  'PAPE',22
         DB  'BALL',23
         DB  'WEAT',23
         DB  'ANCH',24
         DB  'ROPE',95
         DB  'CORD',96
         DB  'RIPC',96
         DB  'RIP ',96
         DB  'PIRA',98
         DB  'MATE',98
         DB  'CLER',99
         DB  'CLAM',100
         DB  'CAVE',101
         DB  'BOUL',102
         DB  'ROCK',102
         DB  'OSYT',104
         DB  'STAI',105
         DB  'STEP',105
         DB  'CHAI',106
         DB  'TABL',107
         DB  'SIGN',108
         DB  'SHAR',109
         DB  'DOOR',112
         DB  'TRAP',112
         DB  'WIND',113
         DB  'LADD',114
         DB  'COMP',115
         DB  'GAUG',116
         DB  'MERM',117
         DB  'FALL',118
         DB  'HOLE',120
         DB  'SAND',122
         DB  'BUTT',123
         DB  'ISLA',124
         DB  'SHOR',124
         DB  'DOCK',125
         DB  'WATE',126
         DB  'OCEA',126
         DB  'BOAT',127
         DB  'SHIP',127
         DB  'ALL ',128
         DB  'EVER',128
         DB  0

;
; SPECIAL ACTION TABLE. LISTS
; VERB/NOUN COMBO'S THAT HAVE
; SPECIAL PROCESSING ROUTINES.
; FORMAT IS:
;
;  # BYTES       DEXCRIPTION
;  -------   ------------------
;     1      VERB NUMBER
;     1      NOUN NUMBER
;     2      SPECIAL RTN ADDR
;

SPCRTN   EQU $
         DW  0174H,LOOK03 ;LOOK GAUGE
         DW  0170H,LOOK05 ;LOOK DOOR
         DW  016BH,LOOK07 ;LOOK TABLE
         DW  0111H,LOOK08 ;LOOK CREDIT
         DW  0171H,LOOK10 ;LOOK WINDOW
         DW  0169H,LOOK11 ;LOOK STEPS
         DW  015FH,LOOK13 ;LOOK ROPE
         DW  0160H,LOOK13 ;LOOK CORD
         DW  0176H,LOOK14 ;LOOK FALLS
         DW  0165H,LOOK16 ;LOOK CAVE
         DW  016CH,VREAD  ;LOOK SIGN
         DW  0307H,VINVE  ;TAKE INVENTORY
         DW  030AH,GETALL ;SHOVEL
         DW  0380H,GETALL
         DW  030BH,GET02  ;GET TANKS
         DW  0318H,GET03  ;GET ANCHOR
         DW  0317H,GET04  ;GET BALLOON
         DW  0B7FH,GO01   ;GO BOAT
         DW  0B7EH,GO02   ;GO WATER
         DW  0B7DH,GO03   ;GO DOCK
         DW  0B7CH,GO04   ;GO ISLAND
         DW  0B76H,GO05   ;GO FALLS
         DW  0B78H,GO06   ;GO HOLE
         DW  0B71H,GO07   ;GO WINDOW
         DW  0B70H,GO08   ;GO DOOR
         DW  0B69H,GO09   ;GO STEPS
         DW  0B65H,GO10   ;GO CAVE
         DW  0B72H,VCLIMB ;GO LADDER
         DW  117BH,PUSH01 ;PUSH BUTTON
         DW  1166H,MOVE01 ;PUSH BOULDER
         DW  1664H,OPEN01 ;OPEN CLAM
         DW  1B66H,MOVE01 ;MOVE BOULDER
         DW  1A13H,LOOKOB ;READ NOTE
         DW  1A16H,LOOKOB ;READ NEWS
         DW  0

ENTRTB   EQU $
         DB  10
         DW  ENTR10
         DB  37
         DW  UNDER2
         DB  39
         DW  UNDER2
         DB  41
         DW  UNDER2
         DB  43
         DW  UNDER2
         DB  44
         DW  UNDER2
         DB  45
         DW  UNDER2
         DB  47
         DW  UNDER2
         DB  0

EXITTB   EQU $
         DB  03
         DW  EXIT03
         DB  21
         DW  EXBOAT
         DB  23
         DW  EXBOAT
         DB  25
         DW  EXBOAT
         DB  27
         DW  EXBOAT
         DB  29
         DW  EXBOAT
         DB  31
         DW  EXBOAT
         DB  33
         DW  EXBOAT
         DB  43
         DW  EXIT43
         DB  55
         DW  EXIT55
         DB  0

INRMTB   EQU $
         DB  1
         DW  INRM01
         DB  35
         DW  UNDER1
         DB  36
         DW  UNDER1
         DB  38
         DW  UNDER1
         DB  40
         DW  UNDER1
         DB  42
         DW  UNDER1
         DB  46
         DW  UNDER1
         DB  48
         DW  UNDER1
         DB  37
         DW  UNDER2
         DB  39
         DW  UNDER2
         DB  41
         DW  UNDER2
         DB  43
         DW  UNDER2
         DB  44
         DW  UNDER2
         DB  45
         DW  UNDER2
         DB  47
         DW  UNDER2
         DB  0

; TABLES USED TO PLACE RANDOM
; FISH IN THE OCEAN ROOMS

FSHLFT   EQU $
         DB  90,30,89,0,29,0,90,89
FSHRIT   EQU $
         DB  0,27,88,91,91,27,0,88

; MESSAGE TABLE FOR GENERAL
; LOOK AT OBJECT ROUTINE
;
; FMT:         DB    OBJ#
;          MSG# IF CARRYING
;          MSG# IF IN ROOM

OBJMSG   EQU   $
         DB    008,016,010   ;METAL DETECTOR
         DB    011,021,010   ;AIR TANKS
         DB    015,037,010   ;FULL BOTTLE
         DB    016,038,010   ;EMPTY BOTTLE
         DB    019,047,010   ;NOTE
         DB    022,062,010   ;NEWSPAPER
         DB    023,063,010   ;WEATHER BALLOON
         DB    024,071,071   ;GOLDEN ANCHOR
         DB    025,071,071   ;BURIED ANCHOR
         DB    097,000,063   ;TIED WEATHER BALLOON
         DB    117,000,028   ;MERMAID
         DB    0

; DEFINE OBJECTS THAT SHOULD
; BE REFERRED TO AS "THEM"

THEMTB   EQU   $
         DB    011,1         ;AIR TANKS
         DB    012,1         ;BARS OF SILVER
         DB    098,3         ;PIRATE
         DB    099,3         ;CLERK
         DB    105,1         ;STAIRS
         DB    117,2         ;MERMAID
         DB    0

LITTAB   DB    'it.',0
         DB    'them.',0
         DB    'her.',0
         DB    'him.',0


EQUTAB   DB    15,16,0            ;BOTTLE
         DB    23,97,0            ;WEATHER BALLOON
         DB    24,25,0            ;ANCHOR
         DB    120,121,0          ;HOLE IN GROUND
         DB    112,111,110,0      ;TRAP DOOR
         DB    100,104,0          ;CLAM
         DB    104,100,0          ;OSYTER
         DB    102,103,0          ;BOULDER
         DB    0

;
; ROOM TABLE.  DEFINES THE
; LAYOUT OF THE ADVENTURE. EACH
; ENTRY HAS THE FOLLOWING
; FORMAT:
;
; # BYTES        DESCRIPTION
; -------   -------------------
;    1      ROOM # TO NORTH
;    1      ROOM # TO SOUTH
;    1      ROOM # TO EAST
;    1      ROOM # TO WEST
;    1      ROOM # UP
;    1      ROOM # DOWN
;

;ROOM 1
RMTBDF   DB  0,0,2,1,0,0
;ROOM 2
         DB  0,0,3,1,0,0
;ROOM 3
         DB  0,0,4,2,0,0
;ROOM 4
         DB  0,0,5,3,0,0
;ROOM 5
         DB  0,0,6,4,0,0
;ROOM 6
         DB  0,0,7,5,0,0
;ROOM 7
         DB  0,0,7,6,0,0
;ROOM 8
         DB  0,4,0,0,0,0
;ROOM 9
         DB  0,10,0,0,0,0
;ROOM 10
         DB  9,49,0,0,0,0
;ROOM 11
         DB  6,14,12,0,0,0
;ROOM 12
         DB  12,15,13,11,0,0
;ROOM 13
         DB  13,16,0,12,0,0
;ROOM 14
         DB  11,18,15,0,0,0
;ROOM 15
         DB  12,19,16,14,0,0
;ROOM 16
         DB  13,20,0,15,0,0
;ROOM 17
         DB  0,0,18,0,0,0
;ROOM 18
         DB  14,18,19,17,0,0
;ROOM 19
         DB  15,19,20,18,0,0
;ROOM 20
         DB  16,20,0,19,0,0
;ROOM 21
         DB  23,0,0,0,0,0
;ROOM 22
         DB  0,0,0,0,0,35
;ROOM 23
         DB  25,21,27,29,0,0
;ROOM 24
         DB  0,0,0,0,0,36
;ROOM 25
         DB  0,23,0,0,0,0
;ROOM 26
         DB  0,0,0,0,0,38
;ROOM 27
         DB  31,0,0,23,0,0
;ROOM 28
         DB  0,0,0,0,0,40
;ROOM 29
         DB  0,0,23,0,0,0
;ROOM 30
         DB  0,0,0,0,0,42
;ROOM 31
         DB  33,27,0,0,0,0
;ROOM 32
         DB  0,0,0,0,0,46
;ROOM 33
         DB  0,31,0,0,0,0
;ROOM 34
         DB  0,0,0,0,0,48
;ROOM 35
         DB  0,0,0,0,22,0
;ROOM 36
         DB  0,0,0,0,24,37
;ROOM 37
         DB  0,0,0,0,36,0
;ROOM 38
         DB  0,0,0,0,26,39
;ROOM 39
         DB  0,0,0,0,38,0
;ROOM 40
         DB  0,0,0,0,28,41
;ROOM 41
         DB  0,0,0,0,40,0
;ROOM 42
         DB  0,0,0,0,30,43
;ROOM 43
         DB  0,0,0,0,42,44
;ROOM 44
         DB  0,0,0,0,43,45
;ROOM 45
         DB  0,0,0,0,44,0
;ROOM 46
         DB  0,0,0,0,32,47
;ROOM 47
         DB  0,0,0,0,46,0
;ROOM 48
         DB  0,0,0,0,34,0
;ROOM 49
         DB  10,0,0,0,0,0
;ROOM 50
         DB  0,0,0,0,0,0
;ROOM 51
         DB  0,0,0,0,0,0
;ROOM 52
         DB  0,0,0,0,0,51
;ROOM 53
         DB  0,0,0,0,0,0
;ROOM 54
         DB  3,0,0,0,0,0
;ROOM 55
         DB  56,57,55,55,0,0
;ROOM 56
         DB  57,55,56,56,0,0
;ROOM 57
         DB  55,56,57,57,0,0
;ROOM 58
         DB  0,0,0,0,0,0

;ROOM 1
RMOBDF   DB  126,118,108,0
;ROOM 2
         DB  126,0
;ROOM 3
         DB  126,103,0
;ROOM 4
         DB  126,125,0
;ROOM 5
         DB  126,0
;ROOM 6
         DB  126,0
;ROOM 7
         DB  126,9+INV,0
;ROOM 8
         DB  126,127,0
;ROOM 9
         DB  118,12,0
;ROOM 10
         DB  10+INV,0
;ROOM 11
         DB  0
;ROOM 12
         DB  0
;ROOM 13
         DB  0
;ROOM 14
         DB  14+INV,0
;ROOM 15
         DB  0
;ROOM 16
         DB  8,0
;ROOM 17
         DB  99,11,108,115,0
;ROOM 18
         DB  0
;ROOM 19
         DB  22,0
;ROOM 20
         DB  0
;ROOM 21
         DB  126,127,125,0
;ROOM 22
         DB  126,127,125,0
;ROOM 23
         DB  126,127,0
;ROOM 24
         DB  126,127,0
;ROOM 25
         DB  126,127,0
;ROOM 26
         DB  126,127,0
;ROOM 27
         DB  126,127,0
;ROOM 28
         DB  126,127,0
;ROOM 29
         DB  126,127,0
;ROOM 30
         DB  126,127,0
;ROOM 31
         DB  126,127,0
;ROOM 32
         DB  126,127,0
;ROOM 33
         DB  126,127,124,0
;ROOM 34
         DB  126,127,124,0
;ROOM 35
         DB  0
;ROOM 36
         DB  0
;ROOM 37
         DB  0
;ROOM 38
         DB  0
;ROOM 39
         DB  117,0
;ROOM 40
         DB  0
;ROOM 41
         DB  0
;ROOM 42
         DB  0
;ROOM 43
         DB  109,0
;ROOM 44
         DB  0
;ROOM 45
         DB  25,0
;ROOM 46
         DB  0
;ROOM 47
         DB  100,18+INV,0
;ROOM 48
         DB  0
;ROOM 49
         DB  120,0
;ROOM 50
         DB  119,121,0
;ROOM 51
         DB  107,106,17+INV
         DB  114,113,0
;ROOM 52
         DB  114,112,0
;ROOM 53
         DB  110,15,0
;ROOM 54
         DB  108,20+INV,0
;ROOM 55
         DB  98,127,126,0
;ROOM 56
         DB  126,0
;ROOM 57
         DB  126,21+INV,23,0
;ROOM 58
         DB    0
         DB    10 DUP(0)
RMTBEND  DB    0

; ROOM DIRECTION TABLE USED DURING GAME PLAY
; SOURCE IS RMTBDF

ROOMTB   DB    RMOBDF - RMTBDF DUP (?)

; ROOM OBJECT TABLE USED DURING GAME PLAY
; SOURCE IS RMOBDF

RMOBT1   DB    RMTBEND - RMOBDF DUP (?)
RMOBT2   DB    0

RMTB_LEN DW    RMTBEND - RMTBDF


; TREASURE POINT TABLE
; FORMAT:         DB    TREASURE,POINTS

PNTTAB   DB  12,20                ;BARS OF SILVER
         DB  14,20                ;RING
         DB  18,20                ;PEARL
         DB  21,20                ;RUBY
         DB  24,20                ;GOLDEN ANCHOR
         DB  0

;
; GRAPHIC SCREEN INDICATOR
; TABLE (BY ROOM)
;

;ROOM 1
SCRIND   DB  1,6,1,17,16,2,3,0
;ROOM 2
         DB  1,6,1,5,4,0
;ROOM 3
         DB  1,6,1,2,3,0
;ROOM 4
         DB  1,6,1,2,5,35,0
;ROOM 5
         DB  1,6,1,2,4,5,0
;ROOM 6
         DB  1,6,1,22,2,3,4,0
;ROOM 7
         DB  1,6,1,3,0
;ROOM 8
         DB  1,51,3,4,5,0
;ROOM 9
         DB  3,18,0
;ROOM 10
         DB  3,19,0
;ROOM 11
         DB  4,7,8,9,12,13,15,0
;ROOM 12
         DB  4,7,8,10,9,11,13,0
;ROOM 13
         DB  4,7,10,9,14,15,0
;ROOM 14
         DB  4,7,8,9,11,12,13,15,0
;ROOM 15
         DB  4,7,8,10,9,15,0
;ROOM 16
         DB  4,7,10,9,12,14,0
;ROOM 17
         DB  6,42,46,52,53,54,56,57,24,0
;ROOM 18
         DB  4,7,8,10,9,13,15,0
;ROOM 19
         DB  4,7,8,10,9,14,15,0
;ROOM 20
         DB  4,7,10,9,11,12,13,0
;ROOM 21
         DB  1,2,3,4,23,36,0
;ROOM 22
         DB  1,2,3,4,64,0
;ROOM 23
         DB  1,2,3,4,23,0
;ROOM 24
         DB  1,2,3,4,64,0
;ROOM 25
         DB  1,2,3,4,23,0
;ROOM 26
         DB  1,2,3,4,64,0
;ROOM 27
         DB  1,2,3,4,23,0
;ROOM 28
         DB  1,2,3,4,64,0
;ROOM 29
         DB  1,2,3,4,23,0
;ROOM 30
         DB  1,2,3,4,64,0
;ROOM 31
         DB  1,2,3,4,23,0
;ROOM 32
         DB  1,2,3,4,64,0
;ROOM 33
         DB  1,2,3,4,23,75,0
;ROOM 34
         DB  1,2,3,4,64,75,0
;ROOM 35
         DB  2,31,0
;ROOM 36
         DB  2,0
;ROOM 37
         DB  2,31,0
;ROOM 38
         DB  2,0
;ROOM 39
         DB  2,31,25,26,86,0
;ROOM 40
         DB  2,0
;ROOM 41
         DB  2,31,0
;ROOM 42
         DB  2,0
;ROOM 43
         DB  2,0
;ROOM 44
         DB  2,0
;ROOM 45
         DB  2,31,0
;ROOM 46
         DB  2,0
;ROOM 47
         DB  2,31,65,0
;ROOM 48
         DB  2,31,0
;ROOM 49
         DB  3,20,21,0
;ROOM 50
         DB  4,13,32,33,62,0
;ROOM 51
         DB  6,46,42,45,44,43,38,37,0
;ROOM 52
         DB  5,47,48,49,50,0
;ROOM 53
         DB  3,39,46,40,0
;ROOM 54
         DB  7,0
;ROOM 55
         DB  1,6,2,4,0
;ROOM 56
         DB  1,6,2,4,5,0
;ROOM 57
         DB  1,6,2,4,5,0
;ROOM 58
         DB  1,6,5,4,73,0

;
; ANTIMATION ROUTINES BY ROOM
;
; FORMAT: ROOM #,RTN VECTOR
;

ANTTAB   EQU $
         DB  01
         DW  MOVFAL
         DB  02
         DW  MOVBCH
         DB  03
         DW  MOVBCH
         DB  05
         DW  MOVBCH
         DB  06
         DW  MOVBCH
         DB  07
         DW  MOVBCH
         DB  09
         DW  CAVFAL
         DB  22
         DW  MAKWAV
         DB  24
         DW  MAKWAV
         DB  26
         DW  MAKWAV
         DB  28
         DW  MAKWAV
         DB  30
         DW  MAKWAV
         DB  32
         DW  MAKWAV
         DB  34
         DW  MAKWAV
         DB  35
         DW  MOVFSH
         DB  36
         DW  MOVFSH
         DB  37
         DW  MOVFSH
         DB  38
         DW  MOVFSH
         DB  39
         DW  MOVWED
         DB  40
         DW  MOVFSH
         DB  41
         DW  MOVFSH
         DB  42
         DW  MOVFSH
         DB  43
         DW  MOVSRK
         DB  44
         DW  MOVFSH
         DB  45
         DW  MOVFSH
         DB  46
         DW  MOVFSH
         DB  47
         DW  MOVFSH
         DB  48
         DW  MOVFSH
         DB  56
         DW  MOVBCH
         DB  57
         DW  MOVBCH
         DB  0

;
; IF OBJECT DROPPED IN ROOM
; PUT IT IN ANOTHER ROOM TABLE
;
; FORMAT: CURR ROOM,NEW ROOM
;

PUTTAB   EQU $
         DB  22,35
         DB  24,37
         DB  36,37
         DB  26,39
         DB  38,39
         DB  28,41
         DB  40,41
         DB  30,45
         DB  42,45
         DB  43,45
         DB  44,45
         DB  32,47
         DB  46,47
         DB  34,48
         DB  0

;
; MOVABLE OBJ TABLE
;

MOVOBJ   EQU $

         DB  109,28,0             ;SHARK
         DB  43,0

         DB  110,41,0             ;OPEN TRAP DOOR
         DB  52,0

         DB  110,60,0             ;OPEN TRAP DOOR
         DB  53,0

         DB  113,34,0             ;BROKEN WINDOW
         DB  50,0

         DB  11,55,0              ;AIR TANKS
         DB  17,0

         DB  103,58,0             ;BOULDER COVERING CAVE
         DB  3,0

         DB  101,59,0             ;BOULDER REVEALING CAVE
         DB  3,0

         DB  15,61,0              ;BOTTLE
         DB  53,0

         DB  16,61,0              ;BOTTLE
         DB  53,0

         DB  98,63,0              ;PIRATE
         DB  55,0

         DB  104,66,0             ;OPEN OYSTER
         DB  47,0

         DB  18,67,0              ;PEARL
         DB  47,0

         DB  18,92,0              ;PEARL
         DB  54,0

         DB  13,68,0              ;KEY
         DB  35,37,39,41,45,47
         DB  48,11,12,13,14,15
         DB  16,18,19,20,0

         DB  8,69,0               ;METAL DETECTOR
         DB  11,12,13,14,15,16
         DB  18,19,20,0

         DB  8,70,0               ;METAL DETECTOR
         DB  2,4,5,6,7,55,56,57,0

         DB  10,71,0              ;SHOVEL
         DB  2,3,4,5,6,7,54,55,56,57,0

         DB  20,72,0              ;KEG OF RUM
         DB  2,3,4,5,6,7,54,55,56,57,0

         DB  9,78,0               ;MIRROR
         DB  7,54,0

         DB  14,79,0              ;DIAMOND RING
         DB  14,54,0

         DB  12,80,0              ;BARS OF SILVER
         DB  9,54,0

         DB  17,74,0              ;CREDIT CARD
         DB  51,54,0

         DB  21,81,0              ;A RUBY
         DB  2,3,4,5,6,7,54
         DB  55,56,57,0

         DB  25,83,0              ;ANCHOR STUCK IN MUD
         DB  45,0

         DB  24,77,0              ;GOLDEN ANCHOR
         DB  54,0

         DB  24,84,0              ;GOLDEN ANCHOR
         DB  45,47,48,41,39,37,35,0

         DB  97,76,0              ;BALLOON TIED TO ANCHOR
         DB  29,0

         DB  97,85,0              ;BALLOON TIED TO ANCHOR
         DB  45,0

         DB  22,87,0              ;NEWSPAPER
         DB  11,12,13,14,15,16
         DB  18,19,20,0

         DB  23,82,0              ;DEFLATED BALLOON
         DB  2,4,5,7,54,55,56,57,0

;
; GRAPHIC SCREEN PNTR TABLE
;

SCRTAB   EQU $
         DW  SCROCN,SCRBLU,SCRBLK
         DW  SCRLND,SCRLAD,SCRHOU
         DW  SCRCAV

SCROBJ   EQU $
         DEFOVL OVLCLF,9,101      ;001
         DEFOVL OVLCL1,27,9       ;002
         DEFOVL OVLCL2,2,13       ;003
         DEFOVL OVLCL3,27,84      ;004
         DEFOVL OVLCL4,42,48      ;005
         DEFOVL OVLSND,70,1       ;006
         DEFOVL OVLPH1,60,33      ;007
         DEFOVL OVLPH2,56,1       ;008
         DEFOVL OVLPH3,48,57      ;009
         DEFOVL OVLPH4,60,69      ;010
         DEFOVL OVLTR1,11,5       ;011
         DEFOVL OVLTR2,26,81      ;012
         DEFOVL OVLCL5,6,21       ;013
         DEFOVL OVLCL6,15,85      ;014
         DEFOVL OVLCL7,28,45      ;015
         DEFOVL OVLRVR,83,1       ;016
         DEFOVL OVLFAL,24,117     ;017
         DEFOVL OVLFA1,47,9       ;018
         DEFOVL OVLHL1,8,93       ;019
         DEFOVL OVLHL2,1,69       ;020
         DEFOVL OVLSDW,62,49      ;021
         DEFOVL OVLSTR,65,109     ;022
         DEFOVL OVLBOT,68,37      ;023
         DEFOVL OVLAC1,63,1       ;024
         DEFOVL OVLROC,62,57      ;025
         DEFOVL OVLMER,28,65      ;026
         DEFOVL OVLFS1,18,13      ;027
         DEFOVL OVLFS2,23,1       ;028
         DEFOVL OVLFS3,34,109     ;029
         DEFOVL OVLFS4,31,97      ;030
         DEFOVL OVLFLR,77,1       ;031
         DEFOVL OVLHOU,12,13      ;032
         DEFOVL OVLWN1,40,53      ;033
         DEFOVL OVLWN2,40,53      ;034
         DEFOVL OVLDK1,68,9       ;035
         DEFOVL OVLDK2,69,1       ;036
         DEFOVL OVLLAD,1,1        ;037
         DEFOVL OVLCHR,41,21      ;038
         DEFOVL OVLAT1,1,1        ;039
         DEFOVL OVLAT2,13,1       ;040
         DEFOVL OVLAT3,14,45      ;041
         DEFOVL OVLRM1,1,1        ;042
         DEFOVL OVLRM2,18,49      ;043
         DEFOVL OVLRM3,14,109     ;044
         DEFOVL OVLRM4,69,57      ;045
         DEFOVL OVLRM5,63,1       ;046
         DEFOVL OVLLA1,55,45      ;047
         DEFOVL OVLLA2,55,65      ;048
         DEFOVL OVLLA3,69,49      ;049
         DEFOVL OVLLA4,85,49      ;050
         DEFOVL OVLDK3,69,69      ;051
         DEFOVL OVLDV1,1,105      ;052
         DEFOVL OVLDV2,48,9       ;053
         DEFOVL OVLDV3,20,45      ;054
         DEFOVL OVLDV4,12,93      ;055
         DEFOVL OVLDV5,24,5       ;056
         DEFOVL OVLDV6,8,21       ;057
         DEFOVL OVLBL1,62,105     ;058
         DEFOVL OVLBL2,63,93      ;059
         DEFOVL OVLAT4,85,9       ;060
         DEFOVL OVLAT5,70,109     ;061
         DEFOVL OVLHL3,59,117     ;062
         DEFOVL OVLPIR,47,49      ;063
         DEFOVL OVLBO1,55,37      ;064
         DEFOVL OVLCM1,66,69      ;065
         DEFOVL OVLCM2,59,69      ;066
         DEFOVL OVLPR1,69,77      ;067
         DEFOVL OVLKE1,87,73      ;068
         DEFOVL OVLME1,71,89      ;069
         DEFOVL OVLME2,71,89      ;070
         DEFOVL OVLSV1,83,29      ;071
         DEFOVL OVLRUM,77,85      ;072
         DEFOVL OVLGRV,60,77      ;073
         DEFOVL OVLCC1,71,69      ;074
         DEFOVL OVLIS1,67,105     ;075
         DEFOVL OVLBL3,74,37      ;076
         DEFOVL OVLAN1,73,41      ;077
         DEFOVL OVLMIR,82,57      ;078
         DEFOVL OVLRNG,64,105     ;079
         DEFOVL OVLSV2,75,65      ;080
         DEFOVL OVLRBY,71,77      ;081
         DEFOVL OVLBL4,79,105     ;082
         DEFOVL OVLAN2,74,33      ;083
         DEFOVL OVLAN3,77,49      ;084
         DEFOVL OVLCRD,76,33      ;085
         DEFOVL MERTL1,66,73      ;086
         DEFOVL OVLNEW,72,17      ;087
         DEFOVL OVLFS5,16,45      ;088
         DEFOVL OVLFS6,32,77      ;089
         DEFOVL OVLFS7,34,89      ;090
         DEFOVL OVLFS8,21,53      ;091
         DEFOVL OVLPR2,66,53      ;092
         DEFOVL MERTL2,69,73      ;093

GENHLP   DB    13,'Tr','y'+SPC
         DB    'examinin','g'+SPC
         DB    'things.',0

         DB    13,'N','o'+SPC
         DB    'HEL','P'+SPC
         DB    'available.',0

         DB    13,'Us','e'+SPC
         DB    'SAV','E'+SPC
         DB    'often.',0

         DB    13,C$IM
         DB    'stumpe','d'+SPC
         DB    'too!',0

; DIRECTION DESCRIPTIONS TABLE

DIRECT   DB    'North',0
         DB    'South',0
         DB    'East',0
         DB    'West',0
         DB    'Up',0
         DB    'Down',0


; COMPRESSED PHRASE TABLE

TXTTAB   EQU   $
         DB    'th','e'+SPC,0
         DB    'smal','l'+SPC,0
         DB    'ar','e'+SPC,0
         DB    'se','e'+SPC,0
         DB    'can',QUOTE,'t'+SPC,0
         DB    'don',QUOTE,'t'+SPC,0
         DB    'larg','e'+SPC,0
         DB    'I',QUOTE,'m'+SPC,0
         DB    'i','n'+SPC,'a'+SPC,0
         DB    'o','n'+SPC,'a'+SPC,0
         DB    'i','s'+SPC,'a'+SPC,0
         DB    'It',QUOTE,'s'+SPC,0
         DB    'Th','e'+SPC,0
         DB    'i','s'+SPC,0
         DB    'an','d'+SPC,0
         DB    'a','n'+SPC,0
         DB    'a','t'+SPC,0
         DB    'o','f'+SPC,0
         DB    'I','t'+SPC,'says:',13,0
         DB    'yo','u'+SPC,0
         DB    't','o'+SPC,0
         DB    'm','y'+SPC,0
         DB    'i','n'+SPC,0
         DB    'o','n'+SPC,0
         DB    'Yo','u'+SPC,0
         DB    C$YYOU,C$ARE,0

; OBJECT DESCRIPTIONS TABLE

OBJTAB   EQU $

         DB  8,'a'+SPC
         DB  'meta','l'+SPC
         DB  'detector',0

         DB  9,'a'+SPC
         DB  'stainles','s'+SPC
         DB  'stee','l'+SPC
         DB  'mirror',0

         DB  10,'a'+SPC
         DB  'shovel',0

         DB  11,'ai','r'+SPC
         DB  'tanks',0

         DB  12
         DB  'bar','s'+SPC,C$OF
         DB  'silver',0

         DB  13,'a'+SPC
         DB  'key',0

         DB  14,'a'+SPC
         DB  'diamon','d'+SPC
         DB  'ring',0

         DB  15,'a'+SPC,C$SMAL
         DB  'bottle',0

         DB  16,C$AN
         DB  'empt','y'+SPC
         DB  'bottle',0

         DB  17,'a'+SPC
         DB  'credi','t'+SPC
         DB  'card',0

         DB  18,'a'+SPC
         DB  'gian','t'+SPC
         DB  'pearl',0

         DB  19,'a'+SPC
         DB  'note',0

         DB  20,'a'+SPC
         DB  'ke','g'+SPC,C$OF
         DB  'rum',0

         DB  21,'a'+SPC
         DB  'rub','y'+SPC
         DB  'statue',0

         DB  22,'a'+SPC
         DB  'scra','p'+SPC,C$OF
         DB  'newspaper',0

         DB  23,'a'+SPC
         DB  'deflate','d'+SPC
         DB  'weathe','r'+SPC
         DB  'balloon',0

         DB  24,C$AN
         DB  'anchor',0

         DB  25,0FFH,24,0

         DB  97,'a'+SPC
         DB  'weathe','r'+SPC
         DB  'balloo','n'+SPC
         DB  'tie','d'+SPC
         DB  C$TO,C$AN
         DB  'anchor',0

         DB  98,'a'+SPC
         DB  'pirate',0

         DB  99,'a'+SPC
         DB  'clerk',0

         DB  100,'a'+SPC,C$LARG
         DB  'clam',0

         DB  101,'a'+SPC,C$SMAL
         DB  'cave',0

         DB  102,'a'+SPC,C$LARG
         DB  'boulder',0

         DB  103,'a'+SPC,C$LARG
         DB  'boulder',0

         DB  104,C$AN
         DB  'ope','n'+SPC
         DB  'osyter',0

         DB  106,'a'+SPC
         DB  'chair',0

         DB  107,'a'+SPC
         DB  'table',0

         DB  108,'a'+SPC
         DB  'sign',0

         DB  109
         DB  'sharks',0

         DB  110,C$AN
         DB  'ope','n'+SPC
         DB  'tra','p'+SPC
         DB  'door',0

         DB  111,'a'+SPC
         DB  'tra','p'+SPC
         DB  'door',0

         DB  112,0FFH,111,0

         DB  113,'a'+SPC
         DB  'broke','n'+SPC
         DB  'window',0

         DB  114,'a'+SPC
         DB  'ladder',0

         DB  115,C$AN,'ai','r'+SPC
         DB  'compressor',0

         DB  117,'a'+SPC
         DB  'lovel','y'+SPC
         DB  'mermaid',0

         DB  118,'a'+SPC
         DB  'wate','r'+SPC
         DB  'falls',0

         DB  119,'a'+SPC
         DB  'beac','h'+SPC
         DB  'house',0

         DB  120,'a'+SPC
         DB  'hol','e'+SPC,C$IN,C$THE
         DB  'ceiling',0

         DB  121,'a'+SPC
         DB  'hol','e'+SPC,C$IN,C$THE
         DB  'ground',0

         DB  124,'a'+SPC,C$SMAL
         DB  'island',0

         DB  125,'a'+SPC
         DB  'woode','n'+SPC
         DB  'dock',0

         DB  126,C$THE
         DB  'ocean',0

         DB  127,'a'+SPC
         DB  'boat',0

;
; ROOM DESCRIPTIONS TABLE
;

DESCTB   EQU $
;ROOM 1
         DB  C$UARE,C$ONA
         DB  'sand','y'+SPC
         DB  'beach.',0
;ROOM 2
         DB  0FFH,1,0
;ROOM 3
         DB  0FFH,1,0
;ROOM 4
         DB  0FFH,1,0
;ROOM 5
         DB  0FFH,1,0
;ROOM 6
         DB  0FFH,1,0
;ROOM 7
         DB  0FFH,1,0
;ROOM 8
         DB  C$UARE,C$ONA
         DB  'woode','n'+SPC
         DB  'dock.',0
;ROOM 9
         DB  C$UARE,C$INA
         DB  'caver','n'+SPC
         DB  'entrance.',0
;ROOM 10
         DB  C$UARE,C$INA,C$LARG
         DB  'cavern.',0
;ROOM 11
         DB  C$UARE,C$INA
         DB  'grass','y'+SPC
         DB  'meadow.',0
;ROOM 12
         DB  0FFH,11,0
;ROOM 13
         DB  0FFH,11,0
;ROOM 14
         DB  0FFH,11,0
;ROOM 15
         DB  0FFH,11,0
;ROOM 16
         DB  0FFH,11,0
;ROOM 17
         DB  C$UARE,C$INA,C$SMAL
         DB  'SCUB','A'+SPC
         DB  'shop.',0
;ROOM 18
         DB  0FFH,11,0
;ROOM 19
         DB  0FFH,11,0
;ROOM 20
         DB  0FFH,11,0
;ROOM 21
         DB  C$UARE,C$ONA
         DB  'boat.',0
;ROOM 22
         DB  C$UARE
         DB  'treadin','g'+SPC
         DB  'wate','r'+SPC
         DB  C$ON,C$THE
         DB  'surfac','e'+SPC
         DB  C$OF,C$THE
         DB  'ocean.',0
;ROOM 23
         DB  0FFH,21,0
;ROOM 24
         DB  0FFH,22,0
;ROOM 25
         DB  0FFH,21,0
;ROOM 26
         DB  0FFH,22,0
;ROOM 27
         DB  0FFH,21,0
;ROOM 28
         DB  0FFH,22,0
;ROOM 29
         DB  0FFH,21,0
;ROOM 30
         DB  0FFH,22,0
;ROOM 31
         DB  0FFH,21,0
;ROOM 32
         DB  0FFH,22,0
;ROOM 33
         DB  0FFH,21,0
;ROOM 34
         DB  0FFH,22,0
;ROOM 35
         DB  C$UARE,C$ON,C$THE
         DB  'botto','m'+SPC
         DB  C$OF,C$THE
         DB  'ocean.',0
;ROOM 36
         DB  C$UARE
         DB  'underwater.',0
;ROOM 37
         DB  0FFH,35,0
;ROOM 38
         DB  0FFH,36,0
;ROOM 39
         DB  0FFH,35,0
;ROOM 40
         DB  0FFH,36,0
;ROOM 41
         DB  0FFH,35,0
;ROOM 42
         DB  0FFH,36,0
;ROOM 43
         DB  0FFH,36,0
;ROOM 44
         DB  0FFH,36,0
;ROOM 45
         DB  0FFH,35,0
;ROOM 46
         DB  0FFH,36,0
;ROOM 47
         DB  0FFH,35,0
;ROOM 48
         DB  0FFH,35,0
;ROOM 49
         DB  0FFH,10,0
;ROOM 50
         DB  0FFH,11,0
;ROOM 51
         DB  C$UARE,C$INA
         DB  'beac','h'+SPC
         DB  'house.',0
;ROOM 52
         DB  C$UARE,C$AT,C$THE
         DB  'to','p'+SPC
         DB  C$OF,'a'+SPC
         DB  'ladder.',0
;ROOM 53
         DB  C$UARE,C$INA
         DB  'must','y'+SPC
         DB  'attic.',0
;ROOM 54
         DB  C$UARE,C$INA,C$SMAL
         DB  'cave.',0
;ROOM 55
         DB  0FFH,1,0
;ROOM 56
         DB  0FFH,1,0
;ROOM 57
         DB  0FFH,1,0

; VERB ROUTINE JUMP VECTORS

RTNTAB   EQU $
         DW  VLOOK,VINVE,VGET,VPUT
         DW  VNORTH,VSOUTH,VEAST,VWEST
         DW  VUP,VDOWN,VGO,ENDGAM
         DW  VSAVE,VLOAD,VHELP,VDIG
         DW  BADINP,VGIVE,VFILL,VCLIMB
         DW  VCLOSE,VOPEN,VUNLOC
         DW  VBREAK,VSCORE,VREAD,BADINP
         DW  VPULL,VTIE

; ASSORTED TEXT MESSAGES

MSG000   DB  13,13,'OK',','+SPC,0

MSG001   DB  13,13
         DB  'Obviou','s'+SPC
         DB  'directions',':'+SPC
         DB  0

MSG002   DB  13,13
         DB  C$YYOU,C$SEE,8,':'+SPC,0

MSG003   DB  13
         DB  'I'+SPC
         DB  C$SEE
         DB  'n','o'+SPC
         DB  'wa','y'+SPC
         DB  C$TO,'g','o'+SPC
         DB  C$IN
         DB  'tha','t'+SPC
         DB  'direction.'
         DB  0

MSG004   DB  13
         DB  'I'+SPC,C$DONT
         DB  'understan','d'+SPC,'"'
         DB  0

MSG005   DB  13,C$UARE
         DB  'carryin','g'+SPC
         DB  C$THE
         DB  'following:',13,0

MSG006   DB  13
         DB  'nothing.',0

MSG007   DB  13,'I'+SPC,C$DONT
         DB  C$SEE,0

MSG008   DB  13
         DB  C$UARE
         DB  'carryin','g'+SPC,0

MSG009   DB  13,C$YYOU,C$CANT
         DB  'carr','y'+SPC
         DB  'anymore.',0

MSG010   DB  13
         DB  C$YYOU,C$DONT
         DB  'hav','e'+SPC,0

MSG011   DB  13
         DB  'Hey',','+SPC,'I'+SPC
         DB  'foun','d'+SPC
         DB  'something!',0

MSG012   DB  13,'I'+SPC,C$SEE
         DB  'nothin','g'+SPC
         DB  'special.',0

MSG013   DB  13,C$UARE,C$ON
         DB  'it!',0

MSG014   DB  13,C$UARE,C$IN
         DB  'it!',0

MSG015   DB  13,C$IITS
         DB  'beyon','d'+SPC,C$MY
         DB  'powe','r'+SPC
         DB  C$TO,'d','o'+SPC
         DB  'that.',0

MSG016   DB  13
         DB  'Ther','e'+SPC,C$IS,'a'+SPC
         DB  'butto','n'+SPC
         DB  C$ON,C$THE
         DB  'handle.',0

MSG017   DB  13
         DB  'Click...',0

MSG018   DB  13,C$TTHE
         DB  'detecto','r'+SPC
         DB  'buzze','s'+SPC
         DB  'loudly.',0

MSG019   DB  13
         DB  'Wit','h'+SPC,C$MY
         DB  'hands','?'+SPC
         DB  'Surel','y'+SPC,C$YOU
         DB  'jest!',0

MSG020   DB  13,13,'A','s'+SPC,C$YOU
         DB  'ente','r'+SPC,C$THE
         DB  'caver','n'+SPC,C$YOU
         DB  'stumbl','e'+SPC
         DB  'ove','r'+SPC
         DB  'something.',0

MSG021   DB  13
         DB  'Ther','e'+SPC,C$IS,C$AN
         DB  'ai','r'+SPC
         DB  'gaug','e'+SPC
         DB  'attache','d'+SPC
         DB  C$TO,C$THE
         DB  'tanks.',0

MSG022   DB  13
MSG022A  DB  '00000 '
         DB  'move(s',')'+SPC,C$OF
         DB  'ai','r'+SPC
         DB  'remain.',0

MSG023   DB  13
         DB  'Giv','e'+SPC
         DB  'i','t'+SPC,C$TO
         DB  'who?',0

MSG024   DB  13,C$TTHE
         DB  'mermai','d'+SPC
         DB  'decline','s'+SPC
         DB  'you','r'+SPC
         DB  'generou','s'+SPC
         DB  'gift.',0

MSG025   DB  13,C$TTHE
         DB  'mermai','d'+SPC
         DB  'thank','s'+SPC,C$YOU,C$AND
         DB  'place','s'+SPC
         DB  'somethin','g'+SPC,C$IN
         DB  'you','r'+SPC
         DB  'hand.',0

MSG026   DB  13,13,C$YYOU
         DB  'hav','e'+SPC
         DB  'drow','n'+SPC
         DB  C$IN,C$THE
         DB  'ocean.',0

MSG027   DB  13,'N','o'+SPC
         DB  'swimmin','g'+SPC
         DB  'allowed!',0

MSG028   DB  13,'I'+SPC
         DB  'sai','d'+SPC
         DB  'sh','e'+SPC
         DB  'wa','s'+SPC
         DB  'lovely!',0

MSG029   DB  13,C$IITS
         DB  'closed.',0

MSG030   DB  13,C$IITS
         DB  'locked.',0

MSG031   DB  13,C$IITS
         DB  'open.',0

MSG032   DB  13,C$IITS
         DB  'unlocked.',0

MSG033   DB  13,C$YYOU
         DB  'nee','d'+SPC,'a'+SPC
         DB  'key!',0

MSG034   DB  13,C$IITS
         DB  'alread','y'+SPC
         DB  'broken!',0

MSG035   DB  13
         DB  'Won',QUOTE,'t'+SPC
         DB  'budge.',0

MSG036   DB  13
         DB  'Doesn',QUOTE,'t'+SPC
         DB  'work.',0

MSG037   DB  13,C$IITS
         DB  'fille','d'+SPC
         DB  'wit','h'+SPC,'a'+SPC
         DB  'clea','r'+SPC
         DB  'liquid.',0

MSG038   DB  13,C$IITS
         DB  'empty.',0

MSG039   DB  13,C$TTHE
         DB  'wate','r'+SPC
         DB  'turn','s'+SPC
         DB  'murk','y'+SPC,'a','s'+SPC
         DB  C$THE
         DB  'shark','s'+SPC
         DB  'swi','m'+SPC
         DB  'away.',0

MSG040   DB  13,C$YYOU,C$CANT
         DB  'd','o'+SPC
         DB  'tha','t'+SPC
         DB  '..','.'+SPC
         DB  'yet!',0

MSG041   DB  13,C$TTHE
         DB  'content','s'+SPC
         DB  C$OF,C$THE
         DB  'bottl','e'+SPC
         DB  'empt','y'+SPC,C$AND,C$ARE
         DB  'los','t'+SPC
         DB  'forever.',0

MSG042   DB  13
         DB  'Welcom','e'+SPC,C$TO
         DB  'CoCo-nu','t'+SPC
         DB  'falls.',0

MSG043   DB  13
MSG043B  DB  '00000 '
         DB  C$OF
         DB  '10','0'+SPC
         DB  'point','s'+SPC
         DB  'scored',13
MSG043A  DB  '00000'
         DB  ' move','s'+SPC
         DB  'used.',0

MSG044   DB  C$ITSA
         DB  'Brin','g'+SPC
         DB  'treasure','s'+SPC
         DB  'here',','+SPC
         DB  'sa','y'+SPC
         DB  'SCORE.',0

MSG045   DB  C$ITSA
         DB  'Al','l'+SPC
         DB  'majo','r'+SPC
         DB  'credi','t'+SPC
         DB  'card','s'+SPC
         DB  'accepted.',0

MSG046   DB  13,C$TTHE
         DB  'shark','s'+SPC
         DB  'attac','k'+SPC
         DB  C$AND,C$INA
         DB  'wil','d'+SPC
         DB  'frenz','y'+SPC
         DB  'tea','r'+SPC,C$YOU,C$TO
         DB  'shreads.',0

MSG047   DB  C$ITSA
         DB  'Thank','s'+SPC
         DB  'fo','r'+SPC,C$THE
         DB  'loot',','+SPC
         DB  'matey','.'+SPC
         DB  'Bette','r'+SPC
         DB  'chec','k'+SPC
         DB  'you','r'+SPC
         DB  'score.',0

MSG048   DB  13,13
         DB  'Wit','h'+SPC
         DB  'wha','t'+SPC
         DB  '(on','e'+SPC
         DB  'word)','?'+SPC,0

MSG049   DB  13,13
         DB  'Hmmm',','+SPC
         DB  'perhap','s'+SPC
         DB  'thi','s'+SPC
         DB  'isn',QUOTE,'t'+SPC,'a'+SPC
         DB  'clam.',13,0

MSG050   DB  13,C$TTHE
         DB  'cler','k'+SPC
         DB  'won',QUOTE,'t'+SPC
         DB  'le','t'+SPC
         DB  'you!',0

MSG051   DB  13,13
         DB  'Thi','s'+SPC
         DB  'Adventur','e'+SPC
         DB  C$IS
         DB  'over.',13
MSG051B  DB  '00000 '
         DB  C$OF
         DB  '10','0'+SPC
         DB  'point','s'+SPC
         DB  'scored',13
MSG051A  DB  '00000'
         DB  ' move','s'+SPC
         DB  'wer','e'+SPC
         DB  'used.',13,13
         DB  'Pla','y'+SPC
         DB  'agai','n'+SPC
         DB  '(Y/N)','?'+SPC,0

MSG052   DB  13,C$TTHE
         DB  'boulde','r'+SPC
         DB  'roll','s'+SPC
         DB  'asid','e'+SPC,C$TO
         DB  'revea','l'+SPC,'a'+SPC
         DB  'smal','l'+SPC
         DB  'cav','e'+SPC
         DB  'entrance.',0

MSG053   DB  13,C$TTHE
         DB  'boulde','r'+SPC
         DB  'no','w'+SPC
         DB  'cover','s'+SPC,C$THE
         DB  'cav','e'+SPC
         DB  'entrance.',0

MSG054   DB  13
         DB  '378','2'+SPC
         DB  '87067','1'+SPC
         DB  '91008',13,0

MSG055   DB  13
         DB  'MICHAEL NELSON JR.',0

MSG056   DB  13
         DB  'Than','k'+SPC,C$YOU
         DB  'sir',','+SPC
         DB  'I',QUOTE,'l','l'+SPC
         DB  'pu','t'+SPC
         DB  'tha','t'+SPC,C$ON
         DB  'you','r'+SPC
         DB  'charge.',0

MSG057   DB  13
         DB  '"Di','s'+SPC
         DB  'b','e'+SPC,C$MY
         DB  'islan','d'+SPC
         DB  'mate','.'+SPC,'I'+SPC
         DB  'don',QUOTE,'t'+SPC,'b','e'+SPC
         DB  'likin','g'+SPC
         DB  'strangers"',0

MSG058   DB  13
         DB  '"Thank','s'+SPC
         DB  'mate',','+SPC
         DB  'di','s'+SPC
         DB  'hun','k'+SPC,'a'+SPC
         DB  'san','d'+SPC,'b','e'+SPC
         DB  'al','l'+SPC
         DB  'yours"',0

MSG059   DB  13
         DB  '"Nic','e'+SPC
         DB  'workmanshi','p'+SPC
         DB  'bu','t'+SPC,C$OF
         DB  'littl','e'+SPC
         DB  'valu','e'+SPC,C$TO
         DB  'me"',0

MSG060   DB  13
         DB  '"Don',QUOTE,'t'+SPC,'b','e'+SPC
         DB  'bringin','g'+SPC,'m','e'+SPC
         DB  'ol','d'+SPC
         DB  'wor','n'+SPC,'ou','t'+SPC
         DB  'treasure"',0

MSG061   DB  13,C$IITS
         DB  'stuc','k'+SPC
         DB  C$IN,C$THE
         DB  'sand.',0

MSG062   DB  13,3 DUP ('.'+SPC)
         DB  C$AND,'a','s'+SPC
         DB  'expecte','d'+SPC
         DB  'tropica','l'+SPC
         DB  'stor','m'+SPC
         DB  'Barr','y'+SPC
         DB  'resulte','d'+SPC,C$IN
         DB  'littl','e'+SPC
         DB  'mor','e'+SPC
         DB  'tha','n'+SPC,'a'+SPC
         DB  'fe','w'+SPC
         DB  'broke','n'+SPC
         DB  'windows.',0

MSG063   DB  13
         DB  'Ther','e'+SPC,C$ISA
         DB  'ripcor','d'+SPC
         DB  C$AND,'a'+SPC
         DB  'piec','e'+SPC,C$OF
         DB  'rop','e'+SPC
         DB  'attache','d'+SPC
         DB  C$TO,'it','.'+SPC
         DB  C$TTHE
         DB  'instruction','s'+SPC
         DB  'sa','y'+SPC
         DB  '"PUL','L'+SPC
         DB  'CORD','"'+SPC,C$TO
         DB  'inflate.',0

MSG064   DB  13,C$TTHE
         DB  'balloo','n'+SPC
         DB  'pull','s'+SPC,C$THE
         DB  'ancho','r'+SPC
         DB  'fre','e'+SPC,C$AND
         DB  'the','y'+SPC
         DB  'bot','h'+SPC
         DB  'ris','e'+SPC
         DB  'towar','d'+SPC,C$THE
         DB  'surface.',0

MSG065   DB  13,C$TTHE
         DB  'balloo','n'+SPC
         DB  'rapidl','y'+SPC
         DB  'inflate','s'+SPC,C$AND
         DB  'float','s'+SPC
         DB  'away.',0

MSG066   DB  13,C$TTHE
         DB  'balloo','n'+SPC
         DB  'break','s'+SPC
         DB  'fre','e'+SPC,C$AND
         DB  'float','s'+SPC
         DB  'away.',0

MSG067   DB  13,13,'T','o'+SPC
         DB  'wha','t'+SPC
         DB  '(on','e'+SPC
         DB  'word)','?'+SPC,0

MSG068   DB  13
         DB  'Don',QUOTE,'t'+SPC,'b','e'+SPC
         DB  'ridiculous.',0

MSG069   DB  13
         DB  'Congratulations',','+SPC
         DB  C$YOU
         DB  'di','d'+SPC
         DB  'it.',13,0

MSG070   DB  13
         DB  'The','y'+SPC
         DB  'loo','k'+SPC
         DB  'interestin','g'+SPC
         DB  'alright.',0

MSG071   DB  13,C$IITS
         DB  'soli','d'+SPC
         DB  'gold!',0

MSG072   DB  13,13
         DB  'Welcom','e'+SPC,C$TO
         DB  'Se','a'+SPC
         DB  'Search.',0

;
;        END FILE: ADVDATA2.ASM  -  SEA SEARCH
;
