;
;        FILE: ADVCODE2.ASM   --   SEA SEARCH
;

;        GET TANKS

GET02    PROC
         CMP   ROOM,17
         JNE   GET02_B
         TEST  TANKSW,0FFH
         JNE   GET02_B
         MOV   AL,17              ;CREDIT CARD
         CALL  LOCOBJ
         JNE   GET02_A
         JMP   DMSG050
GET02_A:
         INC   TANKSW
         MOV   BX,OFFSET MSG056
         CALL  DISPLY
GET02_B:
         JMP   VGET
GET02    ENDP


;        GET ANCHOR

GET03    PROC
         MOV   AL,25              ;ANCHOR IN MUD
         CALL  CKOBJ
         LBNE  DMSG061
         MOV   AL,97              ;TIED BALLOON
         CALL  CKOBJ
         JE    GET03_A
         SUB   AH,AH
         CALL  CHGOBJ
         CALL  CKDRAW
         MOV   BX,OFFSET MSG066
         CALL  DISPLY
GET03_A:
         JMP   VGET
GET03    ENDP

;        GET BALLOON

GET04    PROC
         MOV   AL,97              ;TIED BALLOON
         CALL  CKOBJ
         JE    GET04_A
         MOV   NOUNNO,AL
GET04_A:
         JMP   VGET
GET04    ENDP

;        GO BOAT

GO01     PROC
         MOV   AL,ROOM
         CMP   AL,8
         JNE   GO01_A
         MOV   AL,21
         JMP   SHORT GO01_C
GO01_A:
         CMP   AL,55              ;ISLAND
         JNE   GO01_B
         MOV   AL,33
         JMP   SHORT GO01_C
GO01_B:
         CMP   AL,21
         JB    GO01_D
         CMP   AL,34
         JA    GO01_D
         TEST  AL,01H
         LBNE  DMSG013            ;YOU'RE ON IT
         DEC   AL
GO01_C:
         JMP   EXITRM
GO01_D:
         JMP   NOSEE
GO01     ENDP

;        GO WATER

GO02     PROC
         MOV   AL,ROOM
         CMP   AL,8               ;ON DOCK
         LBLO  DMSG027
         JNE   GO02_A
         MOV   AL,22
         JMP   SHORT GO02_C
GO02_A:
         CMP   AL,55              ;ISLAND
         JNE   GO02_B
         MOV   AL,34
         JMP   SHORT GO02_C
GO02_B:
         CMP   AL,21
         JB    GO02_D
         CMP   AL,34
         JA    GO02_D
         TEST  AL,01H
         LBEQ  DMSG014            ;YOU'RE IN IT
         INC   AL
GO02_C:
         JMP   EXITRM
GO02_D:
         CMP   AL,35
         JB    GO02_E
         CMP   AL,48
         JA    GO02_E
         JMP   DMSG014
GO02_E:
         MOV   AL,126             ;WATER
         CALL  CKOBJ
         LBEQ  NOSEE
         JMP   DMSG040            ;NO SWIMMING ALLOWED
GO02     ENDP

;        GO DOCK

GO03     PROC
         MOV   AL,ROOM
         CMP   AL,8
         LBEQ  DMSG013
         MOV   AL,125             ;DOCK
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   AL,8
         JMP   EXITRM
GO03     ENDP

;        GO SHORE/ISLAND

GO04     PROC
         MOV   AL,ROOM
         CMP   AL,55
         JE    GO04_A
         CMP   AL,56
         JE    GO04_A
         CMP   AL,57
         JE    GO04_A
         MOV   AL,124
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   AL,55
         JMP   EXITRM
GO04_A:
         JMP   DMSG013
GO04     ENDP

;        GO FALLS

GO05     PROC
         MOV   AL,ROOM
         CMP   AL,1
         JE    GO05_A
         CMP   AL,9
         LBNE  NOSEE
GO05_A:
         XOR   AL,00001000B
         JMP   EXITRM
GO05     ENDP

;        GO HOLE

GO06     PROC
         MOV   AL,ROOM
         CMP   AL,49
         JE    GO06_A
         CMP   AL,50
         LBNE  NOSEE
GO06_A:
         XOR   AL,00000011B
         JMP   EXITRM
GO06     ENDP

;        GO WINDOW

GO07     PROC
         MOV   AL,ROOM
         CMP   AL,50
         JE    GO07_A
         CMP   AL,51
         LBNE  NOSEE
GO07_A:
         MOV   AL,113             ;BROKEN WINDOW
         CALL  CKOBJ
         LBEQ  DMSG029
         MOV   AL,ROOM
         XOR   AL,1
         JMP   EXITRM
GO07     ENDP

;        GO DOOR

GO08     PROC
         CALL  EQUOBJ
         MOV   AL,ROOM
         CMP   AL,50
         JE    GO08_A
         CMP   AL,51
         JE    GO08_A
         MOV   AL,NOUNNO          ;DOOR
         CALL  CKOBJ
         LBEQ  NOSEE
         CMP   AL,110             ;OPEN DOOR
         JNE   GO08_A
         MOV   AL,ROOM
         XOR   AL,1
         JMP   EXITRM
GO08_A:
         JMP   DMSG029
GO08     ENDP

;        GO STAIRS

GO09     PROC
         CMP   ROOM,6
         LBNE  NOSEE
         MOV   AL,11
         JMP   EXITRM
GO09     ENDP

;        GO CAVE

GO10     PROC
         CMP   ROOM,54
         LBEQ  DMSG014
         MOV   AL,101             ;CAVE ENTRANCE
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   AL,54
         JMP   EXITRM
GO10     ENDP

;        LOOK GAUGE

LOOK03   PROC
         MOV   AL,11              ;AIR TANKS
         CALL  HAVOBJ
         LBEQ  NOSEE
         MOV   BL,AIRCNT
         SUB   BH,BH
         MOV   SI,OFFSET MSG022A
         CALL  ASCLNO
         CALL  SUPRES
         JMP   DMSG022
LOOK03   ENDP

;        LOOK DOOR

LOOK05   PROC
         MOV   AL,ROOM
         CMP   AL,50
         JE    LOOK05_A
         CMP   AL,51
         JE    LOOK05_A
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CALL  CKOBJ
         JNE   LOOK05_A
         JMP   NOSEE
LOOK05_A:
         JMP   DMSG029
LOOK05   ENDP

;        LOOK TABLE

LOOK07   PROC
         MOV   AL,107             ;TABLE
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   AL,17+INV          ;CREDIT CARD
         CALL  MAKVIS
         LBEQ  DMSG012
         CALL  CKDRAW
         JMP   DMSG011
LOOK07   ENDP

;        LOOK CREDIT CARD

LOOK08   PROC
         MOV   AL,17              ;CREDIT CARD
         CALL  HAVOBJ
         LBEQ  NOHAVE
         MOV   BX,OFFSET MSG054
         CALL  DISPLY
         MOV   BX,OFFSET MSG055
LOOK08_A:
         MOV   AL,[BX]
         INC   BX
         CMP   AL,0
         JE    LOOK08_C
         CALL  CHROUT
         PUSH  BX
         MOV   BX,30
         MOV   DI,100
         CALL  SOUND
         POP   BX
         MOV   CX,300
LOOK08_B:
         LOOP  LOOK08_B
         JMP   SHORT LOOK08_A
LOOK08_C:
         JMP   REPLY
LOOK08   ENDP

;        LOOK WINDOW

LOOK10   PROC
         CMP   ROOM,50
         LBEQ  DMSG012
         JMP   LOOKOB
LOOK10   ENDP

;        LOOK STEPS

LOOK11   PROC
         CMP   ROOM,6
         LBEQ  DMSG012
         JMP   NOSEE
LOOK11   ENDP

;        LOOK ROPE.CORD

LOOK13   PROC
         MOV   NOUNNO,23
         JMP   LOOKOB
LOOK13   ENDP

;        LOOK FALLS

LOOK14   PROC
         CMP   ROOM,1
         LBNE  LOOKOB
         JMP   DMSG070
LOOK14   ENDP

;        LOOK CAVE

LOOK16   PROC
         CMP   ROOM,54
         LBEQ  DMSG012
         JMP   LOOKOB
LOOK16   ENDP

;        MOVE BOULDER

MOVE01   PROC
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CALL  CKOBJ
         LBEQ  NOSEE
         CMP   AL,103
         JNE   MOVE01_A
         MOV   AH,102
         CALL  CHGOBJ
         MOV   AL,101             ;CAVE ENTRANCE
         CALL  PUTNRM
         CALL  CKDRAW
         JMP   DMSG052
MOVE01_A:
         MOV   AH,103
         CALL  CHGOBJ
         MOV   AL,101
         SUB   AH,AH
         CALL  CHGOBJ
         CALL  CKDRAW
         JMP   DMSG053
MOVE01   ENDP

;        CLIMB VERB PROC

VCLIMB   PROC
         MOV   AL,NOUNNO
         CMP   AL,114             ;LADDER
         LBNE  BADINP
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   AL,ROOM
         XOR   AL,7
         JMP   EXITRM
VCLIMB   ENDP

;        CLOSE VERB PROC

VCLOSE   PROC
         MOV   AL,NOUNNO
         CMP   AL,112             ;TRAP DOOR
         LBNE  BADINP
         MOV   AH,ROOM
         CMP   AH,50
         JE    VCLOSE_A
         CMP   AH,51
         JE    VCLOSE_A
         CALL  CKOBJ
         JNE   VCLOSE_A
         MOV   AL,111
         CALL  CKOBJ
         JNE   VCLOSE_A
         MOV   AL,110
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   AH,111
         CALL  CHGOBJ
         CALL  CKDRAW
         JMP   REPLY
VCLOSE_A:
         JMP   DMSG029
VCLOSE   ENDP

;        OPEN VERB PROCESSOR

VOPEN    PROC
         MOV   AL,NOUNNO
         CMP   AL,112             ;DOOR
         JNE   VOPEN_A
         MOV   AH,ROOM
         CMP   AH,50
         LBEQ  VOPEN_D
         CMP   AH,51
         LBEQ  VOPEN_D
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CALL  CKOBJ
         LBEQ  NOSEE
         CMP   AL,112             ;LOCKED DOOR
         LBEQ  DMSG030
         CMP   AL,110             ;OPEN DOOR
         LBEQ  DMSG031
         MOV   AH,110             ;OPEN DOOR
         CALL  CHGOBJ
         MOV   AL,AH
         CALL  CKDRAW
         JMP   REPLY
VOPEN_A:
         CMP   AL,15              ;BOTTLE
         JNE   VOPEN_C
         MOV   AL,16              ;EMPTY BOTTLE
         CALL  HAVOBJ
         LBNE  DMSG038
         MOV   AL,15              ;FULL BOTTLE
         CALL  HAVOBJ
         LBEQ  NOHAVE
         MOV   AL,109             ;SHARK
         CALL  CKOBJ
         JE    VOPEN_B
         SUB   AH,AH
         CALL  CHGOBJ
         CALL  CKDRAW
         MOV   AL,15              ;FULL BOTTLE
         MOV   AH,16              ;EMPTY BOTTLE
         CALL  REPOBJ
         JMP   DMSG039
VOPEN_B:
         MOV   AL,15              ;FULL BOTTLE
         MOV   AH,16              ;EMPTY BOTTLE
         CALL  REPOBJ
         JMP   DMSG041
VOPEN_C:
         CMP   AL,113             ;WINDOW
         LBNE  BADINP
         MOV   AL,ROOM
         CMP   AL,50
         JE    VOPEN_D
         CMP   AL,51
         JE    VOPEN_D
         JMP   NOSEE
VOPEN_D:
         JMP   DMSG035
VOPEN    ENDP

;        OPEN CLAM

OPEN01   PROC
         MOV   AL,100             ;CLAM
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   BX,OFFSET MSG048
         CALL  DISPLY
         CALL  GETLIN
         CALL  SCNKEY
         MOV   NOUNNO,0
         MOV   BX,OFFSET NOUNTB
         MOV   DI,OFFSET NOUNNO
         MOV   SI,OFFSET VERB
         CALL  SCNTBL
         MOV   AL,NOUNNO
         CMP   AL,0
         LBEQ  BADINP
         CALL  HAVOBJ
         LBEQ  NOHAVE
         CMP   AL,10              ;SHOVEL
         LBNE  DMSG036
         MOV   AL,18+INV          ;PEARL
         CALL  MAKVIS
         MOV   AL,100             ;CLAM
         MOV   AH,104             ;OSYTER
         CALL  CHGOBJ
         MOV   AL,AH
         CALL  CKDRAW
         MOV   BX,OFFSET MSG049
         CALL  DISPLY
         JMP   DMSG011
OPEN01   ENDP

;        TIE VERB PROCESSOR

VTIE     PROC
         MOV   AL,NOUNNO
         CMP   AL,23              ;BALLOON
         JE    VTIE_A
         CMP   AL,95              ;ROPE
         LBNE  BADINP
VTIE_A:
         MOV   AL,23              ;BALLOON
         CALL  HAVOBJ
         LBEQ  NOHAVE
         MOV   BX,OFFSET MSG067
         CALL  DISPLY
         CALL  GETLIN
         CALL  SCNKEY
         MOV   NOUNNO,0
         MOV   BX,OFFSET NOUNTB
         MOV   DI,OFFSET NOUNNO
         MOV   SI,OFFSET VERB
         CALL  SCNTBL
         MOV   AL,NOUNNO
         CMP   AL,0
         LBEQ  BADINP
         CMP   AL,24              ;ANCHOR
         LBNE  DMSG068
         MOV   AL,25              ;ANCHOR IN MUD
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   AL,23              ;BALLOON
         SUB   AH,AH
         CALL  REPOBJ
         MOV   AL,97              ;TIED BALLOON
         CALL  PUTNRM
         CALL  CKDRAW
         JMP   REPLY
VTIE     ENDP

;        PULL VERB PROCESSOR

VPULL    PROC
         MOV   AL,NOUNNO
         CMP   AL,96              ;CORD
         LBNE  BADINP
         MOV   AL,23              ;BALLOON
         CALL  LOCOBJ
         JNE   VPULL_A
         MOV   AL,97              ;TIED BALLOON
         CALL  CKOBJ
         LBEQ  NOHAVE
         SUB   AH,AH
         CALL  CHGOBJ
         MOV   AL,25              ;ANCHOR IN MUD
         CALL  CHGOBJ
         DISABLE
         MOV   ROOM,29
         MOV   AL,24              ;ANCHOR
         CALL  PUTNRM
         MOV   AL,97              ;TIED BALLOON
         CALL  PUTNRM
         MOV   ROOM,45
         ENABLE
         CALL  CKDRAW
         JMP   DMSG064
VPULL_A:
         SUB   AH,AH
         CALL  REPOBJ
         CALL  CHGOBJ
         CALL  CKDRAW
         MOV   CH,ROOM
         MOV   AH,CH
         CMP   AH,57
         JE    VPULL_B
         MOV   AH,57
         JMP   SHORT VPULL_C
VPULL_B:
         MOV   AH,56
VPULL_C:
         DISABLE
         MOV   ROOM,AH
         CALL  PUTNRM
         MOV   ROOM,CH
         ENABLE
         JMP   DMSG065
VPULL    ENDP

;        UNLOCK VERB PROCESSOR

VUNLOC   PROC
         CMP   NOUNNO,112         ;DOOR
         LBNE  BADINP
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         MOV   AH,ROOM
         CMP   AH,50
         LBEQ  DMSG036
         CMP   AH,51
         LBEQ  DMSG036
         CALL  CKOBJ
         LBEQ  NOSEE
         CMP   AL,110
         LBEQ  DMSG031
         CMP   AL,111
         LBEQ  DMSG032
         MOV   AL,13              ;KEY
         CALL  HAVOBJ
         LBEQ  DMSG033
         MOV   AL,112             ;UNLOCK THE DOOR
         MOV   AH,111
         CALL  CHGOBJ
         JMP   REPLY
VUNLOC   ENDP

;        READ VERB PROCESSOR

VREAD    PROC
         CMP   NOUNNO,108         ;SIGN
         LBNE  BADINP
         MOV   AL,ROOM
         CMP   AL,1
         LBEQ  DMSG042
         CMP   AL,54
         LBEQ  DMSG044
         CMP   AL,17
         LBEQ  DMSG045
         JMP   NOSEE
VREAD    ENDP

;        BREAK VERB PROCESSOR

VBREAK   PROC
         MOV   AL,NOUNNO
         CMP   AL,113             ;WINDOW
         LBNE  BADINP
         CALL  CKOBJ
         LBNE  DMSG034
         CMP   ROOM,50
         LBNE  NOSEE
         MOV   AL,113             ;BROKEN WINDOW
         CALL  PUTNRM
         CALL  CKDRAW
;
;        PROTECTION BELOW
;
         MOV   AL,VALIDSW
         CMP   AL,PROTSW
         JE    VBREAK_A
         MOV   AL,17+INV          ;REMOVE CREDIT CARD FROM GAME
         SUB   AH,AH
         CALL  XCHGOB
;
;        PROTECTION ABOVE
;
VBREAK_A:
         JMP   REPLY
VBREAK   ENDP

;        GIVE VERB PROCESSOR

VGIVE    PROC
         MOV   AL,NOUNNO
         CMP   AL,0
         LBEQ  BADINP
         CALL  HAVOBJ
         LBEQ  NOHAVE
         MOV   AL,117             ;MERMAID
         CALL  CKOBJ
         JE    VGIVE_A
         MOV   AL,NOUNNO
         CMP   AL,9               ;MIRROR
         LBNE  DMSG024
         MOV   AH,13              ;KEY
         CALL  REPOBJ
         MOV   BX,OFFSET MSG025
         CALL  DELAY
         JMP   DMSG011
VGIVE_A:
         MOV   AL,98              ;PIRATE
         CALL  CKOBJ
         LBEQ  DMSG023
         MOV   AL,NOUNNO
         CMP   AL,20              ;KEG OF RUM
         JNE   VGIVE_C
VGIVE_B:
         SUB   AH,AH
         CALL  REPOBJ
         MOV   AL,98              ;PIRATE
         CALL  CHGOBJ
         CALL  CKDRAW
         JMP   DMSG058
VGIVE_C:
         MOV   BX,OFFSET PNTTAB
VGIVE_D:
         CMP   BYTE PTR [BX],0
         LBEQ  DMSG059
         INC   BX
         INC   BX
         CMP   AL,[BX-2]
         JNE   VGIVE_D
         CMP   BYTE PTR [BX-1],0
         LBEQ  DMSG060
         JMP   SHORT VGIVE_B
VGIVE    ENDP

;        FILL VERB PROCESSOR

VFILL    PROC
         MOV   AL,NOUNNO
         CMP   AL,11              ;TANKS
         LBNE  BADINP
         CALL  HAVOBJ
         LBEQ  NOHAVE
         MOV   AL,115             ;COMPRESSOR
         CALL  CKOBJ
         LBEQ  DMSG040
         MOV   AL,17              ;CREDIT CARD
         CALL  HAVOBJ
         LBEQ  DMSG050
         MOV   AIRCNT,20
         MOV   BX,OFFSET MSG056
         CALL  DISPLY
;
;        PROTECTION BELOW
;
         MOV   AL,PROTSW
         CMP   AL,VALIDSW
         JE    VFILL_A
         MOV   AIRCNT,5
;
;        PROTECTION ABOVE
;
VFILL_A:
         JMP   REPLY
VFILL    ENDP

;        SPECIAL GET ALL COMMAND

GETALL   PROC
         MOV   AL,ROOM
         CMP   AL,10
         JNE   GETALL_A
         MOV   AL,10+INV          ;SHOVEL
         CALL  MAKVIS
         JMP   SHORT GETALL_B
GETALL_A:
         CMP   AL,17
         JNE   GETALL_B
         TEST  TANKSW,0FFH
         JNE   GETALL_B
         CMP   NOUNNO,128         ;GET ALL
         JNE   GETALL_B
         MOV   AL,17              ;CREDIT CARD
         CALL  LOCOBJ
         LBEQ  DMSG050
         INC   TANKSW
         MOV   BX,OFFSET MSG056
         CALL  DISPLY
GETALL_B:
         JMP   VGET
GETALL   ENDP

;        PUSH BUTTON

PUSH01   PROC
         MOV   AL,8               ;METAL DETECTOR
         CALL  HAVOBJ
         LBEQ  NOHAVE
         MOV   AL,9+INV           ;MIRROR
         CALL  CKOBJ
         JNE   PUSH01_A
         MOV   AL,14+INV          ;DIAMOND RING
         CALL  CKOBJ
         LBEQ  DMSG017
PUSH01_A:
         INC   DIGSW
         JMP   DMSG018
PUSH01   ENDP

;        DIG VERB PROCESSOR

VDIG     PROC
         MOV   AL,NOUNNO
         CMP   AL,0
         JE    VDIG_C
         CMP   AL,122             ;SAND
         JNE   VDIG_D
VDIG_A:
         MOV   AL,10              ;SHOVEL
         CALL  HAVOBJ
         LBEQ  DMSG019
         MOV   AL,20+INV          ;KEG OF RUM
         CALL  CKOBJ
         JE    VDIG_F
VDIG_E:
         CALL  MAKVIS
         CALL  CKDRAW
         JMP   DMSG011
VDIG_F:
         MOV   AL,21+INV          ;RUBY
         CALL  CKOBJ
         JNE   VDIG_E
         TEST  DIGSW,0FFH
         LBEQ  REPLY
         MOV   DIGSW,0
         MOV   AL,9+INV           ;MIRROR
         CALL  MAKVIS
         CALL  CKDRAW
         MOV   AL,14+INV          ;RING
         CALL  MAKVIS
         CALL  CKDRAW
         JMP   DMSG011
VDIG_C:
         CMP   NOUN,' '
         JE    VDIG_A
VDIG_D:
         JMP   BADINP
VDIG     ENDP

INDARK   PROC
         MOV   AL,1
         TEST  AL,0FFH
         RET
INDARK   ENDP

ECHMOV   PROC
         RET
ECHMOV   ENDP

CHKPA    PROC
         TEST  AL,0FFH
         RET
CHKPA    ENDP

CHKGA    PROC
         CMP   AL,25              ;ANCHOR STUCK IN MUD?
         JNE   CHKGA_A
         SUB   AL,AL
CHKGA_A:
         TEST  AL,0FFH
         RET
CHKGA    ENDP

CKFISH   PROC
         MOV   AL,ROOM
         CMP   AL,35
         JB    CKFISH_B
         CMP   AL,48
         JA    CKFISH_B
         CMP   AL,43
         JE    CKFISH_B
         CMP   AL,39
         JE    CKFISH_B
         MOV   BX,OFFSET FSHRIT
         CALL  PICKFISH
         MOV   BX,OFFSET FSHLFT
         MOV   AL,RANDOM
         ADD   AL,ROOM
         MOV   RANDOM,AL
         CALL  PICKFISH
CKFISH_B:
         RET
CKFISH   ENDP

PICKFISH PROC
         MOV   AL,RANDOM
         AND   AL,7
         SUB   AH,AH
         ADD   BX,AX
         MOV   AL,[BX]
         CMP   AL,0
         JE    PICKFISH_A
         CALL  SHOOVL
PICKFISH_A:
         RET
PICKFISH ENDP

;        SPECIAL ROOM ENTRY ROUTINES

ENTR10   PROC
         PUSH  AX
         PUSH  BX
         MOV   AL,10+INV          ;SHOVEL
         CALL  CKOBJ
         JE    ENTR10_A
         MOV   BX,OFFSET MSG020
         CALL  DISPLY
ENTR10_A:
         POP   BX
         POP   AX
         RET
ENTR10   ENDP

;        SPECIAL IN ROOM ROUTINES

INRM01   PROC
         PUSH  AX
         PUSH  BX
         TEST  FIRST1,0FFH
         JNE   INRM01_A
         MOV   BX,OFFSET MSG072
         CALL  DISPLY
         INC   FIRST1
;
;        PROTECTION BELOW
;
         MOV   AH,PROTSW
         CMP   AH,VALIDSW
         JE    INRM01_A
         MOV   AL,20+INV          ;REMOVE KEG OF RUM
         SUB   AH,AH
         CALL  XCHGOB
;
;        PROTECTION ABOVE
;
INRM01_A:
         POP   BX
         POP   AX
         RET
INRM01   ENDP

UNDER1   PROC
         PUSH  AX
         MOV   AL,11              ;TANKS
         CALL  HAVOBJ
         JE    UNDER1_A
         TEST  AIRCNT,0FFH
         JE    UNDER1_A
         DEC   AIRCNT
         JNE   UNDER1_B
UNDER1_A:
         MOV   AL,RMMOVE
         CMP   AL,3
         JB    UNDER1_B
UNDERX:
         MOV   BX,OFFSET MSG026
         JMP   DEAD1
UNDER1_B:
         POP   AX
         RET
UNDER1   ENDP

UNDER2   PROC
         PUSH  AX
         MOV   AL,11              ;TANKS
         CALL  HAVOBJ
         JE    UNDER2_A
         TEST  AIRCNT,0FFH
         JE    UNDER2_A
         DEC   AIRCNT
         JNE   UNDER2_B
UNDER2_A:
         JMP   SHORT UNDERX
UNDER2_B:
         POP   AX
         RET
UNDER2   ENDP

;        SPECIAL EXIT ROOM ROUTINES

EXIT03   PROC
         PUSH  AX
         PUSH  BX
         CMP   AH,54              ;GOING TO ROOM 54?
         JE    EXIT03_C           ;  YES
         MOV   AL,101             ;SEE IF CAVE OPEN
         CALL  CKOBJ
         JE    EXIT03_C
         MOV   AL,RANDOM
         AND   AL,07FH
         CMP   AL,70
         JA    EXIT03_C
         TEST  POINTS,0FFH
         JE    EXIT03_C
         CALL  EXIT03_D
         JE    EXIT03_C
         MOV   POINTS,0
         DISABLE
         MOV   ROOM,54
         MOV   BX,OFFSET PNTTAB
         SUB   AH,AH
EXIT03_A:
         MOV   AL,[BX]
         INC   BX
         INC   BX
         CMP   AL,0
         JE    EXIT03_B
         CALL  CHGOBJ
         JMP   SHORT EXIT03_A
EXIT03_B:
         TEST  NOTESW,0FFH
         JNE   EXIT03_C
         MOV   AL,19              ;NOTE
         CALL  PUTNRM
         INC   NOTESW
         MOV   ROOM,3
         ENABLE
EXIT03_C:
         POP   BX
         POP   AX
         RET
EXIT03_D:
         DISABLE
         MOV   ROOM,54
         MOV   BX,OFFSET PNTTAB
EXIT03_E:
         TEST  BYTE PTR [BX],0FFH
         JE    EXIT03_F
         MOV   AL,[BX]
         INC   BX
         INC   BX
         CALL  CKOBJ
         JNE   EXIT03_F
         JMP   SHORT EXIT03_E
EXIT03_F:
         RET
EXIT03   ENDP

EXBOAT   PROC
         PUSH  AX
         MOV   AL,NOUNNO
         CMP   AL,4               ;NORTH/SOUTH/EAST/WEST
         JA    EXBOAT_E
         PUSH  AX
         MOV   AL,97              ;BALLOON ON ANCHOR
         CALL  CKOBJ
         JE    EXBOAT_F
         SUB   AH,AH
         CALL  CHGOBJ
         MOV   AL,24              ;ANCHOR
         CALL  CHGOBJ
         DISABLE
         INC   ROOM
         CALL  PUTNRM
         DEC   ROOM
         ENABLE
EXBOAT_F:
         POP   AX
         MOV   AL,ROOM
         CALL  XFROBJ
EXBOAT_E:
         POP   AX
         RET
EXBOAT   ENDP

EXIT43   PROC
         PUSH  AX
         CMP   NOUNNO,6           ;DOWN
         JNE   EXIT43_A
         MOV   AL,109             ;SHARK
         CALL  CKOBJ
         JE    EXIT43_A
         MOV   BX,OFFSET MSG046
         JMP   DEAD1
EXIT43_A:
         POP   AX
         RET
EXIT43   ENDP

EXIT55   PROC
         PUSH  AX
         CMP   AH,56              ;GOING TO ROOM 56?
         JE    EXIT55_A           ;  YES
         CMP   AH,57              ;GOING TO ROOM 57?
         JNE   EXIT55_B           ;  NO
EXIT55_A:
         MOV   AL,98              ;PIRATE
         CALL  CKOBJ
         LBNE  DMSG057
EXIT55_B:
         POP   AX
         RET
EXIT55   ENDP

;        ANTIMATION ROUTINES

;        MOVE WAVES ON OCEAN SURFACE

MAKWAV   PROC
         INC   FLIPCT
         CMP   FLIPCT,9
         JB    MAKWAV_D
         MOV   FLIPCT,0
         CALCX 73,1
         CALCD 73,1,90,128
         INC   OCNCNT
         CMP   OCNCNT,6
         JB    MAKWAV_A
         CALL  SCRLFT
         CMP   OCNCNT,10
         JB    MAKWAV_D
         MOV   OCNCNT,0
         JMP   SHORT MAKWAV_D
MAKWAV_A:
         CALL  SCRRIT
MAKWAV_D:
         RET
MAKWAV   ENDP

MOVBCH   PROC
         INC   FLIPCT
         CMP   FLIPCT,7
         JB    MOVBCH_A
         MOV   FLIPCT,0
         CALCX 73,1
         CALCD 73,1,74,56
         CALL  SCRRIT
         CALCX 75,1
         CALCD 75,1,76,36
         CALL  SCRRIT
MOVBCH_A:
         RET
MOVBCH   ENDP

;        MOVE FALLS ON BEACH

MOVFAL   PROC
         INC   OCNSW
         CMP   OCNSW,1
         JB    MOVFAL_A
         MOV   OCNSW,0
         CALCX 39,117
         CALCD 39,117,82,124
         CALL  SCRDN
         CALCX 85,1
         CALCD 85,1,86,28
         CALL  SCRLFT
         CALCX 84,29
         CALCD 84,29,86,64
         CALL  SCRLFT
         CALCX 83,65
         CALCD 83,65,86,120
         CALL  SCRLFT
MOVFAL_A:
         JMP   SHORT MOVBCH
MOVFAL   ENDP

;        MOVE FALLS FROM INSIDE CAVERN

CAVFAL   PROC
         INC   OCNSW
         CMP   OCNSW,1
         JB    CAVFAL_A
         MOV   OCNSW,0
         CALCX 49,9
         CALCD 49,9,69,20
         CALL  SCRDN
CAVFAL_A:
         RET
CAVFAL   ENDP

;        MOVE MERMAIDS TAIL

MOVWED   PROC
         INC   FLIPCT
         CMP   FLIPCT,13
         JB    MOVWED_B
         MOV   FLIPCT,0
         XOR   FLIPSW,1
         JE    MOVWED_C
         MOV   AL,93              ;MERMAID TAIL OVERLAY #2
         JMP   SHORT MOVWED_D
MOVWED_C:
         MOV   AL,86              ;MERMAID TAIL OVERLAY #1
MOVWED_D:
         CALL  SHOOVL
MOVWED_B:
         RET
MOVWED   ENDP

;        MOVE WATER FOR FISH TO MOVE (A FISHY MOVE???)

MOVFSH   PROC
         INC   OCNCNT
         CMP   OCNCNT,2
         JB    MOVFSH_A
         MOV   OCNCNT,0
         CALCX 16,1
         CALCD 16,1,29,128
         CALL  SCRRIT
         CALCX 30,1
         CALCD 30,1,44,128
         CALL  SCRLFT
MOVFSH_A:
         RET
MOVFSH   ENDP

;        MOVE THE SHARK

MOVSRK   PROC
         INC   OCNCNT
         CMP   OCNCNT,2
         JB    MOVSRK_A
         MOV   OCNCNT,0
         CALCX 23,1
         CALCD 23,1,47,128
         CALL  SCRRIT
MOVSRK_A:
         RET
MOVSRK   ENDP

;
;        END FILE: ADVCODE2.ASM   --   SEA SEARCH
;
