
;        FILE = ADVMACRO/ASM       LAST MODIFIED: 09/01/84


;
;    DEFOVL  -  MARCO TO DEFINE AN ENTRY IN THE OVERLAY TABLE
;
;               FORMAT OF TABLE ENTRY IS:
;                 DW   OFFSET ADDRESS OF OVERLAY CODE
;                 DW   OFFSET ADDRESS OF UPPER LEFT ON SCREEN
;                      (WILL BE > 1FFFH IF ODD SCAN LINE START)
;

DEFOVL   MACRO OVL_NAME,COCO_ROW,COCO_COL
WORKVAR  =     (COCO_ROW-1)/2*80+(COCO_COL-1)/4*2+88
         IF    (COCO_ROW-1) AND 01H
WORKVAR  =     WORKVAR + 2000H
         ENDIF
         DW    OVL_NAME
         DW    WORKVAR
         ENDM

;
;    CALCX   -  CALC UPPER LEFT CORNER OF SCREEN FOR AN OVERLAY
;               AND PLACE RESULT IN THE 'BX' REGISTER
;

CALCX    MACRO ROW1,COL1
WORKVAR  =     (ROW1-1)/2*80+(COL1-1)/4*2+88
         IF    (ROW1-1) AND 01H
WORKVAR  =     WORKVAR + 2000H
         ENDIF
         MOV   BX,WORKVAR
         ENDM

;
;    CALCD   -  CALC LINE LENGTH AND # OF LINES FOR AN OVERLAY
;

CALCD    MACRO ROW1,COL1,ROW2,COL2
WORKVAR  =     (COL2/4)-((COL1-1)/4)
WORKVAR1 =     ROW2-ROW1+1
         MOV   AX,WORKVAR1*256+WORKVAR
         ENDM

;
;    DISABLE -  MARCO TO DISABLE THE ANTIMATION INTERRUPT ROUTINE
;

DISABLE  MACRO
         MOV   ANTIMSW,0
         ENDM

;
;    ENABLE -  MARCO TO ENABLE THE ANTIMATION INTERRUPT ROUTINE
;

ENABLE   MACRO
         MOV   ANTIMSW,1
         ENDM

;
;    LBEQ   -  MARCO TO DEFINE LONG BRANCH ON EQUAL (ZERO)
;

LBEQ     MACRO TARG_LAB
         LOCAL TEMPLAB
         JNE   TEMPLAB
         JMP   TARG_LAB
TEMPLAB: NOP
         ENDM

;
;    LBNE   -  MARCO TO DEFINE LONG BRANCH ON NOT EQUAL (NOT ZERO)
;

LBNE     MACRO TARG_LAB
         LOCAL TEMPLAB
         JE    TEMPLAB
         JMP   TARG_LAB
TEMPLAB: NOP
         ENDM

;
;    LBHS   -  MARCO TO DEFINE LONG BRANCH HIGH OR SAME
;

LBHS     MACRO TARG_LAB
         LOCAL TEMPLAB
         JB    TEMPLAB
         JMP   TARG_LAB
TEMPLAB: NOP
         ENDM

;
;    LBLO   -  MARCO TO DEFINE LONG BRANCH LOW
;

LBLO     MACRO TARG_LAB
         LOCAL TEMPLAB
         JAE   TEMPLAB
         JMP   TARG_LAB
TEMPLAB: NOP
         ENDM

;
;    LBHI   -  MARCO TO DEFINE LONG BRANCH HIGH
;

LBHI     MACRO TARG_LAB
         LOCAL TEMPLAB
         JBE   TEMPLAB
         JMP   TARG_LAB
TEMPLAB: NOP
         ENDM

;
;    DISCHR -  MARCO TO DEFINE CALL TO DISPLAY CHAR INTERRUPT
;

DISCHR   MACRO PARM
         PUSH  AX
         PUSH  BX
         PUSH  CX
         MOV   CX,1
         MOV   AL,PARM
         MOV   AH,9
         MOV   BL,(BLACK XOR WHITE)+80H
         INT   10H
         POP   CX
         POP   BX
         POP   AX
         ENDM

;
;    SCANKEY - MACRO TO DEFINE CALL TO SCAN KEYBOARD INPUT
;

SCANKEY  MACRO
         MOV   AH,1
         INT   16H
         ENDM

;
;    GETKEY -  MACRO TO DEFINE CALL TO READ KEYBOARD INTERRUPT
;

GETKEY   MACRO
         MOV   AH,0
         INT   16H
         ENDM

;
;    SETCUR -  MARCO TO DEFINE CALL TO SET CURSOR INTERRUPT
;

SETCUR   MACRO
         PUSH  AX
         PUSH  BX
         PUSH  DX
         MOV   AH,2
         MOV   DH,ROW
         MOV   DL,COL
         MOV   BH,0
         INT   10H
         POP   DX
         POP   BX
         POP   AX
         ENDM

;
;    SCROLL_TXT - SCROLL TEXT AREA UP ONE TEXT LINE
;

SCROLL_TXT MACRO
         PUSH  AX
         PUSH  BX
         PUSH  CX
         PUSH  DX
         MOV   AH,6               ;SCROLL UP FUNCTION
         MOV   AL,1               ;SCANLINES TO SCROLL
         MOV   CH,12              ;UPPER LEFT SCAN ROW
         MOV   CL,0               ;UPPER LEFT SCAN COL
         MOV   DH,24              ;LOWER RIGHT SCAN ROW
         MOV   DL,39              ;LOWER RIGHT SCAN COL
         MOV   BH,WHITE@B         ;COLOR TO BLANK WITH
         INT   10H
         POP   DX
         POP   CX
         POP   BX
         POP   AX
         ENDM

;
;    INIT_VIDEO - INITIALIZE THE VIDEO PARAMETERS
;

INIT_VIDEO MACRO
         MOV   AH,0               ;SET VIDEO MOODE FUNCTION
         MOV   AL,ZVIDMODE        ;320 X 200 COLOR MODE
         INT   10H
         MOV   AH,11              ;SET COLOR PALETTE FUNCTION
         MOV   BH,0               ;SET BACKGROUND COLOR
         MOV   BL,BLACK           ;SET BACKGROUND TO BLACK
         INT   10H
         MOV   AH,11              ;SET COLOR PALETTE FUNCTION
         MOV   BH,1               ;SET COLOR SET
         MOV   BL,ZPALETTE        ;CYAN/MAGENTA/WHITE
         INT   10H
         ENDM

;        DIRECT READ OF A SECTOR USING BIOS ROUTINE

READSEC  MACRO DRIVE,TRACK,SECTOR
         PUSH  ES
         MOV   AX,DS
         MOV   ES,AX
         MOV   AH,2
         MOV   AL,1
         MOV   DH,0
         MOV   DL,DRIVE
         MOV   CH,TRACK
         MOV   CL,SECTOR
         MOV   BX,OFFSET SECBUF
         INT   13H
         POP   ES
         ENDM

;        RESET THE DISKETTE DRIVE

RESETDISK MACRO
         MOV   AH,0
         INT   13H
         ENDM

;        F$OPEN   - MS-DOS SYSTEM CALL TO OPEN EXISTING FILE

F$OPEN   MACRO FCB
         MOV   DX,OFFSET FCB
         MOV   AH,0FH
         INT   21H
         MOV   RECSIZ,128
         MOV   CURR_REC,0
         TEST  AL,0FFH
         ENDM

;        F$CLOSE  - MS-DOS SYSTEM CALL TO CLOSE FILE

F$CLOSE  MACRO FCB
         MOV   DX,OFFSET FCB
         MOV   AH,10H
         INT   21H
         TEST  AL,0FFH
         ENDM

;        F$READ   - MS-DOS SYSTEM CALL TO READ FILE

F$READ   MACRO FCB
         MOV   DX,OFFSET FCB
         MOV   AH,14H
         INT   21H
         TEST  AL,0FFH
         ENDM

;        F$WRITE  - MS-DOS SYSTEM CALL TO WRITE FILE

F$WRITE  MACRO FCB
         MOV   DX,OFFSET FCB
         MOV   AH,15H
         INT   21H
         TEST  AL,0FFH
         ENDM

;        F$CREATE - MS-DOS SYSTEM CALL TO CREATE NEW FILE

F$CREATE MACRO FCB
         MOV   DX,OFFSET FCB
         MOV   AH,16H
         INT   21H
         MOV   RECSIZ,128
         MOV   CURR_REC,0
         TEST  AL,0FFH
         ENDM

;        F$SETDTA - MS-DOS SYSTEM CALL TO SET DATA TRANSFER ADDR

F$SETDTA MACRO
         MOV   DX,OFFSET DTABUF
         MOV   AH,1AH
         INT   21H
         ENDM

;        END FILE = ADVMACRO.ASM
