;
;        FILE: ADVDATA2.ASM
;

;        VERB TABLE

VERBTB   DB    'LOOK',1
         DB    'L   ',1
         DB    'EXAM',1
         DB    'INVE',2
         DB    'I   ',2
         DB    'G   ',3
         DB    'GET ',3
         DB    'TAKE',3
         DB    'GRAB',3
         DB    'PUT ',4
         DB    'DROP',4
         DB    'P   ',4
         DB    'NORT',5
         DB    'N   ',5
         DB    'SOUT',6
         DB    'S   ',6
         DB    'EAST',7
         DB    'E   ',7
         DB    'WEST',8
         DB    'W   ',8
         DB    'UP  ',9
         DB    'U   ',9
         DB    'DOWN',10
         DB    'D   ',10
         DB    'GO  ',11
         DB    'WALK',11
         DB    'RUN ',11
         DB    'ENTE',11
         DB    'SAVE',13
         DB    'LOAD',14
         DB    'HELP',15
         DB    'SCOR',16
         DB    'OPEN',17
         DB    'LIFT',18
         DB    'READ',19
         DB    'FEED',20
         DB    'JUMP',21
         DB    'ACTI',22
         DB    'PRES',23
         DB    'TURN',23
         DB    'FLIP',23
         DB    'PUSH',23
         DB    'TRAD',24
         DB    'FOLL',25
         DB    'CUT ',26
         DB    'CHOP',26
         DB    'CLEA',26
         DB    'CLIM',27
         DB    'UNLO',28
         DB    'LIST',29
         DB    'HEAR',29
         DB    'INFL',30
         DB    'PUMP',30
         DB    'DEFL',31
         DB    'KILL',32
         DB    'ATTA',32
         DB    'FIGH',32
         DB    'LIGH',33
         DB    'UNLI',34
         DB    'ROW ',35
         DB    'PADD',35
         DB    'BAIL',36
         DB    'SIT ',37
         DB    'LAUN',37
         DB    'RELE',38
         DB    'REMO',38
         DB    'GIVE',39
         DB    'DIG ',40
         DB    'WEAR',41
         DB    'QUIT',42
         DB    0

;        NOUN TABLE

NOUNTB   DB    'NORT',1
         DB    'SOUT',2
         DB    'EAST',3
         DB    'WEST',4
         DB    'UP  ',5
         DB    'DOWN',6
         DB    'INVE',7
         DB    'FLAS',8
         DB    'LIGH',8
         DB    'RUG ',10
         DB    'SPEC',11
         DB    'INST',12
         DB    'MANU',12
         DB    'JEWE',13
         DB    'COST',13
         DB    'TIRE',14
         DB    'PUMP',14
         DB    'BUCK',15
         DB    'TRAP',16
         DB    'MOUS',16
         DB    'BOOT',17
         DB    'MESS',18
         DB    'PADD',19
         DB    'SHOV',20
         DB    'SPAD',20
         DB    'BOAT',21
         DB    'KEYS',23
         DB    'KEY ',23
         DB    'MACH',24
         DB    'MICE',26
         DB    'MICR',27
         DB    'FILM',27
         DB    'CROW',28
         DB    'POTT',29
         DB    'CHES',30
         DB    'AIR ',90
         DB    'JUNG',91
         DB    'FOLI',91
         DB    'GROW',91
         DB    'HILL',92
         DB    'ENER',93
         DB    'BUTT',94
         DB    'SWIT',94
         DB    'SEAT',95
         DB    'CELL',97
         DB    'CLEA',98
         DB    'FIEL',99
         DB    'MARS',99
         DB    'LAB ',100
         DB    'LABO',100
         DB    'OCEA',101
         DB    'WATE',101
         DB    'NATI',102
         DB    'IDOL',103
         DB    'TOMB',104
         DB    'SHOR',105
         DB    'BEAC',106
         DB    'SAND',108
         DB    'SHAC',109
         DB    'GRAS',109
         DB    'JACK',110
         DB    'TRAD',110
         DB    'SHED',111
         DB    'SNAK',112
         DB    'CREV',114
         DB    'PATH',115
         DB    'PASS',116
         DB    'SPEA',117
         DB    'PANE',118
         DB    'LADD',119
         DB    'DOOR',120
         DB    'TABL',121
         DB    'DEVI',122
         DB    'TELE',122
         DB    'CABI',124
         DB    'SIGN',125
         DB    'DESK',126
         DB    'STAI',127
         DB    'STEP',127
         DB    'ALL ',128
         DB    'EVER',128
         DB    0

; SPECIAL ACTION TABLE. LISTS
; VERB/NOUN COMBO'S THAT HAVE
; SPECIAL PROCESSING ROUTINES.
; FORMAT IS:
;
;  # BYTES       DEXCRIPTION
;  -------   ------------------
;     1      VERB NUMBER
;     1      NOUN NUMBER
;     2      SPECIAL RTN ADDR

SPCRTN   DW    017EH,LOOK01 ;LOOK DESK
         DW    0179H,LOOK02 ;LOOK TABLE
         DW    010AH,LOOK03 ;LOOK RUG
         DW    0178H,LOOK04 ;LOOK DOOR
         DW    011EH,LOOK05 ;LOOK CHEST
         DW    017CH,LOOK06 ;LOOK CABINET
         DW    0177H,LOOK07 ;LOOK LADDER
         DW    010CH,LOOK08 ;LOOK MANUAL
         DW    015EH,LOOK09 ;LOOK SWITCH
         DW    017AH,LOOK10 ;LOOK DEVICE
         DW    0174H,LOOK11 ;LOOK PASSAGE
         DW    0173H,LOOK14 ;LOOK PATH
         DW    011BH,LOOK15 ;LOOK FILM
         DW    015DH,LOOK16 ;LOOK ENER
         DW    015CH,LOOK17 ;LOOK HILL
         DW    0163H,LOOK18 ;LOOK FIELD
         DW    0164H,LOOK19 ;LOOK LAB
         DW    016DH,LOOK20 ;LOOK SHACK
         DW    016FH,LOOK21 ;LOOK SHED
         DW    015AH,DMSG012 ;LOOK AIR
         DW    017DH,VREAD  ;LOOK SIGN
         DW    0307H,VINVE  ;TAKE INVENTORY
         DW    030AH,GET01  ;GET RUG
         DW    037EH,GET02  ;GET DESK
         DW    0379H,GET02  ;GET TABLE
         DW    030BH,GET03  ;GET SPECS
         DW    030CH,GET03  ;GET MANUAL
         DW    031AH,GET04  ;GET MICE
         DW    0315H,GET05  ;GET BOAT
         DW    0313H,GET06  ;GET PADDLES
         DW    035AH,DMSG026 ;GET AIR
         DW    041AH,PUT01  ;PUT MICE
         DW    040DH,PUT04  ;PUT JEWELS
         DW    045AH,DMSG026 ;PUT AIR
         DW    0B7FH,GO01   ;GO STAIRS
         DW    0B77H,GO02   ;GO LADDER
         DW    0B61H,GO02   ;GO CELLAR
         DW    0B74H,GO03   ;GO PASSAGE
         DW    0B7AH,GO04   ;GO DEVICE
         DW    0B5FH,GO04   ;GO SEAT
         DW    0B63H,GO05   ;GO FIELD
         DW    0B73H,GO06   ;GO PATH
         DW    0B64H,GO07   ;GO LAB
         DW    0B6FH,GO08   ;GO SHED
         DW    0B6DH,GO09   ;GO SHACK
         DW    0B5CH,GO10   ;GO HILL
         DW    0B5BH,GO11   ;GO JUNGLE
         DW    0B72H,GO12   ;GO CREVICE
         DW    0B69H,GO13   ;GO SHORE
         DW    0B6AH,GO13   ;GO BEACH
         DW    0B15H,GO14   ;GO BOAT
         DW    0B62H,GO15   ;GO CLEARING
         DW    0B78H,GO16   ;GO DOOR
         DW    2515H,GO14   ;SIT BOAT
         DW    111EH,OPEN01 ;OPEN CHEST
         DW    117EH,OPEN02 ;OPEN DESK
         DW    110AH,GET01  ;GET RUG
         DW    120AH,GET01  ;LIFT RUG
         DW    1312H,LOOKOB ;READ MESSAGE
         DW    131BH,LOOK15 ;READ FILM
         DW    1368H,LOOKOB ;READ TOMB
         DW    1973H,GO06   ;FOLLOW PATH
         DW    1B77H,GO02   ;CLIMB LADDER
         DW    1B5CH,GO10   ;CLIMB HILL
         DW    1B7FH,GO01   ;CLIMB STAIRS
         DW    265AH,VDEFL  ;RELEASE AIR
         DW    2911H,GETSHA ;WEAR BOOTS
         DW    290BH,GET03  ;WEAR SPECS
         DW    0

; SPECIAL ACTION ON ENTRY TO A
; ROOM TABLE.  FORMAT IS:
;      ROOM#,RTNADDR

ENTRTB   DB    3
         DW    ENTR03
         DB    4
         DW    ENTR03
         DB    6
         DW    ENTR06
         DB    7
         DW    ENTR06
         DB    11
         DW    ENTR03
         DB    12
         DW    ENTR03
         DB    13
         DW    ENTR03
         DB    14
         DW    ENTR03
         DB    15
         DW    ENTR15
         DB    19
         DW    ENTR19
         DB    23
         DW    ENTR23
         DB    24
         DW    ENTR24
         DB    25
         DW    ENTR24
         DB    0

; SPECIAL ACTION ON EXIT FROM
; A ROOM TABLE.

EXITTB   DB    3
         DW    EXIT03
         DB    4
         DW    EXIT03
         DB    6
         DW    EXIT06
         DB    7
         DW    EXIT06
         DB    11
         DW    EXIT03
         DB    12
         DW    EXIT03
         DB    13
         DW    EXIT03
         DB    14
         DW    EXIT03
         DB    19
         DW    EXIT19
         DB    20
         DW    EXBOAT
         DB    21
         DW    EXBOAT
         DB    22
         DW    EXIT22
         DB    24
         DW    EXIT24
         DB    25
         DW    EXIT24
         DB    0

; SPECIAL ACTION FOR COMMANDS
; GIVEN WHILE IN A ROOM TABLE

INRMTB   DB    1
         DW    INRM01
         DB    6
         DW    INRM06
         DB    7
         DW    INRM06
         DB    24
         DW    INRM24
         DB    25
         DW    INRM24
         DB    0

; MESSAGE TABLE FOR GENERAL
; LOOK AT OBJECT ROUTINE
;
; FMT:         DB    OBJ#
;          MSG# IF CARRYING
;          MSG# IF IN ROOM

OBJMSG   DB    16,43,43      ;MOUSETRAP
         DB    18,41,10      ;MESSAGE
         DB    11,40,10      ;SPECS
         DB    118,49,49     ;PANEL
         DB    117,49,49     ;SPEAKER
         DB    17,46,46      ;BOOTS
         DB    21,77,77      ;DEFLATED BOAT
         DB    93,0,75       ;INFLATED BOAT
         DB    104,93,93     ;TOMBSTONE
         DB    103,94,94     ;IDOL
         DB    29,95,95      ;POTTERY
         DB    28,100,100    ;CROWN
         DB    0

; DEFINE OBJECTS THAT SHOULD
; BE REFERRED TO AS "THEM"

THEMTB   EQU   $
         DB    11,1          ;SPECS
         DB    17,1          ;BOOTS
         DB    19,1          ;PADDLES
         DB    23,1          ;KEYS
         DB    26,1          ;MICE
         DB    127,1         ;STAIRS
         DB    102,1         ;NATIVES
         DB    0

LITTAB   DB    'it.',0
         DB    'them.',0
         DB    'her.',0
         DB    'him.',0

;ROOM 1
RMTBDF   DB    0,0,0,0,0,0
;ROOM 2
         DB    0,0,0,0,0,1
;ROOM 3
         DB    0,0,0,0,1,0
;ROOM 4
         DB    3,5,0,0,0,0
;ROOM 5
         DB    0,0,0,0,0,0
;ROOM 6
         DB    0,0,0,0,0,0
;ROOM 7
         DB    0,0,0,0,0,0
;ROOM 8
         DB    0,0,0,9,0,0
;ROOM 9
         DB    0,0,8,0,0,0
;ROOM 10
         DB    9,0,0,0,0,0
;ROOM 11
         DB    0,12,12,12,0,0
;ROOM 12
         DB    11,12,13,12,0,0
;ROOM 13
         DB    13,14,13,12,0,0
;ROOM 14
         DB    13,0,0,0,0,0
;ROOM 15
         DB    0,0,0,0,16,8
;ROOM 16
         DB    15,0,0,0,0,0
;ROOM 17
         DB    0,0,0,16,0,0
;ROOM 18
         DB    0,0,0,0,16,0
;ROOM 19
         DB    0,0,18,0,0,0
;ROOM 20
         DB    0,0,0,0,0,0
;ROOM 21
         DB    0,0,0,0,0,0
;ROOM 22
         DB    0,0,0,0,0,0
;ROOM 23
         DB    0,0,22,0,0,0
;ROOM 24
         DB    0,0,0,0,0,0
;ROOM 25
         DB    0,0,0,0,0,0
;ROOM 26
         DB    0,0,0,0,0,0

;ROOM 1
RMOBDF   DB    126,32,121,120+INV,18+INV
         DB    127,27+INV,119+INV,0
;ROOM 2
         DB    8,30,13,127,0
;ROOM 3
         DB    14,15,16+INV,124,0
;ROOM 4
         DB    125,0
;ROOM 5
         DB    122,116,17,0
;ROOM 6
         DB    118,117,100,0
;ROOM 7
         DB    118,117,99,0
;ROOM 8
         DB    122,0
;ROOM 9
         DB    115,0
;ROOM 10
         DB    114,0
;ROOM 11
         DB    113,0
;ROOM 12
         DB    0
;ROOM 13
         DB    0
;ROOM 14
         DB    112,19,0
;ROOM 15
         DB    0
;ROOM 16
         DB    111,0
;ROOM 17
         DB    20,21,26,0
;ROOM 18
         DB    109,108,101,0
;ROOM 19
         DB    110,23,24,0
;ROOM 20
         DB    101,106,0
;ROOM 21
         DB    101,105,0
;ROOM 22
         DB    98,102,101,93,0
;ROOM 23
         DB    104,103,29+INV,28+INV,0
;ROOM 24
         DB    101,0
;ROOM 25
         DB    101,0
;ROOM 26
         DB    0
         DB    10 DUP(0)
RMTBEND  DB    0

; ROOM DIRECTION TABLE USED DURING GAME PLAY
; SOURCE IS RMTBDF

ROOMTB   DB    RMOBDF - RMTBDF DUP (?)

; ROOM OBJECT TABLE USED DURING GAME PLAY
; SOURCE IS RMOBDF

RMOBT1   DB    RMTBEND - RMOBDF DUP (?)
RMOBT2   DB    0

RMTB_LEN DW    RMTBEND - RMTBDF


; TREASURE POINT TABLE
; FORMAT:         DB    TREASURE,POINTS

PNTTAB   DB    28,1
         DB    0

; GRAPHIC SCREEN INDICATOR
; TABLE (BY ROOM)

;ROOM 1
SCRIND   DB    1,11,5,6,31,1,2,4,93,0
;ROOM 2
         DB    2,11,13,14,12,0
;ROOM 3
         DB    4,30,27,28,23,24,25,0
;ROOM 4
         DB    4,59,60,63,99,0
;ROOM 5
         DB    1,11,5,6,31,41,42,32,45,0
;ROOM 6
         DB    2,49,47,48,50,109,110,111,112,0
;ROOM 7
         DB    2,49,51,52,53,113,114,115,116,0
;ROOM 8
         DB    1,33,67,34,36,0
;ROOM 9
         DB    1,36,33,55,75,73,0
;ROOM 10
         DB    1,33,75,74,69,70,71,72,0
;ROOM 11
         DB    4,59,60,63,64,65,66,61,0
;ROOM 12
         DB    4,59,60,63,64,65,61,62,0
;ROOM 13
         DB    4,59,60,63,64,65,61,62,0
;ROOM 14
         DB    4,64,65,63,56,57,58,0
;ROOM 15
         DB    1,36,34,68,0
;ROOM 16
         DB    1,36,33,54,55,80,79,78,77,0
;ROOM 17
         DB    5,33,83,0
;ROOM 18
         DB    1,36,81,82,84,85,86,87,0
;ROOM 19
         DB    6,43,91,96,0
;ROOM 20
         DB    1,35,36,37,117,0
;ROOM 21
         DB    1,35,36,37,38,39,0
;ROOM 22
         DB    1,36,81,82,0
;ROOM 23
         DB    1,33,36,67,104,107,108,0
;ROOM 24
         DB    1,36,35,0
;ROOM 25
         DB    1,36,35,0
;ROOM 26
         DB    1,33,36,67,107,108,0

EQUTAB   DB    8,9,0              ;FLASHLIGHT
         DB    10,32,0            ;ORIENTAL RUG
         DB    21,93,0            ;RUBBER BOAT
         DB    30,31,0            ;OLD WOODEN CHEST
         DB    126,94,0           ;ROLLTOP DESK
         DB    124,123,0          ;STORAGE CABINET
         DB    115,107,0          ;PATH IN JUNGLE
         DB    0

; ANTIMATION ROUTINES BY ROOM
; FORMAT: ROOM #,RTN VECTOR

ANTTAB   DB    1
         DW    MOVCLK
         DB    5
         DW    MOVLSR
         DB    6
         DW    MOVLIT
         DB    7
         DW    MOVLIT
         DB    8
         DW    MOVCLO
         DB    9
         DW    MOVCLO
         DB    14
         DW    MOVSNK
         DB    15
         DW    MOVCLO
         DB    16
         DW    MOVCLO
         DB    18
         DW    MOVCLO
         DB    20
         DW    MOVCLO
         DB    21
         DW    MOVCLO
         DB    22
         DW    MOVCLO
         DB    23
         DW    MOVCLO
         DB    24
         DW    MOVCLO
         DB    25
         DW    MOVCLO
         DB    26
         DW    MOVCLO
         DB    0

; IF OBJECT DROPPED IN ROOM
; PUT IT IN ANOTHER ROOM TABLE
; FORMAT: CURR ROOM,NEW ROOM

PUTTAB   DB    0

; MOVABLE OBJ TABLE

MOVOBJ   EQU   $
         DB    28,105,0           ;JEWELLED CROWN
         DB    23,0

         DB    29,106,0           ;MAYAN POTTERY
         DB    23,0

         DB    110,90,0           ;TRADER JACK
         DB    19,0

         DB    125,92,0           ;SIGN
         DB    19,0

         DB    112,94,0           ;SNAKE
         DB    14,0

         DB    10,118,0           ;ROLLED UP RUG
         DB    1,5,8,9,16,17,18
         DB    19,0

         DB    16,119,0           ;MOUSETRAP
         DB    3,0

         DB    17,95,0            ;BOOTS
         DB    5,8,16,17,18,0

         DB    26,100,0           ;MICE
         DB    17,0

         DB    102,101,0          ;NATIVES
         DB    22,0

         DB    93,102,0           ;INFLATED BOAT
         DB    18,22,0

         DB    19,103,0           ;PADDLES
         DB    14,0

         DB    20,88,0            ;SHOVEL
         DB    17,0

         DB    21,89,0            ;DEFLATED BOAT
         DB    16,17,18,22,0

         DB    23,97,0            ;KEYS
         DB    19,0

         DB    24,98,0            ;MACHETE
         DB    19,0

         DB    107,76,0           ;CUT PATH IN JUNGLE
         DB    9,0

         DB    101,37,0           ;OCEAN
         DB    24,25,0

         DB    122,32,0           ;DEVICE
         DB    8,0

         DB    32,7,0             ;RUG OVER TRAP DOOR
         DB    1,0

         DB    18,10,0            ;MESSAGE
         DB    1,0

         DB    120,3,0            ;TRAP DOOR
         DB    1,0

         DB    119,8,0            ;LADDER
         DB    1,0

         DB    8,17,0             ;UNLIT FLASHLIGHT
         DB    2,8,16,18,0

         DB    9,17,0             ;LIT FLASHLIGHT
         DB    2,8,16,18,0

         DB    30,15,0            ;CLOSED CHEST
         DB    2,0

         DB    31,18,0            ;OPEN CHEST
         DB    2,8,18,19,0

         DB    13,16,0            ;JEWELRY
         DB    2,0

         DB    11,19,0            ;SPECS
         DB    2,3,5,8,16,17,18
         DB    22,0

         DB    12,20,0            ;MANUAL
         DB    2,3,5,8,16,17,18
         DB    22,0

         DB    14,21,0            ;TIRE PUMP
         DB    3,16,18,0

         DB    15,22,0            ;BUCKET
         DB    3,8,16,17,18,22,0

         DB    123,26,0           ;CABINET
         DB    3,0

         DB    124,29,0           ;CABINET
         DB    3,0

         DB    94,9,0            ;DESK
         DB    1,0

         DB    0

; GRAPHIC SCREEN PNTR TABLE

SCRTAB   DW    SCRBLU,SCRBLK,SCRWHT
         DW    SCRRED,SCRSHD,SCRSHA

; GRAPHIC OBJECT PNTR TABLE

SCROBJ   EQU   $
         DEFOVL OVTAB1,65,1       ;001
         DEFOVL OVDSK1,42,69      ;002
         DEFOVL OVDOR1,83,45      ;003
         DEFOVL OVSTA1,23,113     ;004
         DEFOVL OVSTD1,1,25       ;005
         DEFOVL OVSTD2,1,101      ;006
         DEFOVL OVRUG1,80,37      ;007
         DEFOVL OVDOR2,63,49      ;008
         DEFOVL OVDSK2,47,73      ;009
         DEFOVL OVMSG1,68,13      ;010
         DEFOVL OVFLR1,66,1       ;011
         DEFOVL OVSTA2,77,1       ;012
         DEFOVL OVATC1,1,105      ;013
         DEFOVL OVATC2,67,105     ;014
         DEFOVL OVCHT1,70,69      ;015
         DEFOVL OVJEW1,71,37      ;016
         DEFOVL OVLIT1,68,97      ;017
         DEFOVL OVCHT2,63,69      ;018
         DEFOVL OVSPC1,75,57      ;019
         DEFOVL OVMAN1,74,89      ;020
         DEFOVL OVPMP1,68,13      ;021
         DEFOVL OVBKT1,77,101     ;022
         DEFOVL OVBAS1,1,49       ;023
         DEFOVL OVBAS2,1,61       ;024
         DEFOVL OVBAS3,9,53       ;025
         DEFOVL OVBAS4,20,65      ;026
         DEFOVL OVBAS5,1,101      ;027
         DEFOVL OVBAS6,66,105     ;028
         DEFOVL OVBAS7,20,85      ;029
         DEFOVL OVBAS8,66,1       ;030
         DEFOVL OVSTD3,66,105     ;031
         DEFOVL OVDEV1,27,1       ;032
         DEFOVL OVFLD1,66,1       ;033
         DEFOVL OVHIL1,32,105     ;034
         DEFOVL OVWAT1,66,1       ;035
         DEFOVL OVCLO1,9,1        ;036
         DEFOVL OVBOT1,70,41      ;037
         DEFOVL OVISL1,62,101     ;038
         DEFOVL OVTRE1,40,109     ;039
         DEFOVL OVBOT2,77,49      ;040
         DEFOVL OVLAB1,34,113     ;041
         DEFOVL OVLAB2,42,53      ;042
         DEFOVL OVBCH3,65,1       ;043
         DEFOVL OVLAB4,42,89      ;044
         DEFOVL OVLAB5,76,25      ;045
         DEFOVL OVLAB6,42,89      ;046
         DEFOVL OVDVC1,25,25      ;047
         DEFOVL OVDVC2,25,65      ;048
         DEFOVL OVDVC3,51,29      ;049
         DEFOVL OVDVC4,38,1       ;050
         DEFOVL OVDVC5,25,25      ;051
         DEFOVL OVDVC6,25,65      ;052
         DEFOVL OVDVC7,38,1       ;053
         DEFOVL OVHIL3,33,1       ;054
         DEFOVL OVHIL2,66,33      ;055
         DEFOVL OVCHA1,49,33      ;056
         DEFOVL OVCHA2,1,29       ;057
         DEFOVL OVCHA3,1,97       ;058
         DEFOVL OVPAS1,1,29       ;059
         DEFOVL OVPAS2,31,61      ;060
         DEFOVL OVPAS3,40,21      ;061
         DEFOVL OVPAS4,40,97      ;062
         DEFOVL OVPAS5,49,17      ;063
         DEFOVL OVPAS6,39,1       ;064
         DEFOVL OVPAS7,39,73      ;065
         DEFOVL OVPAS8,46,97      ;066
         DEFOVL OVFLD2,59,1       ;067
         DEFOVL OVSID1,58,93      ;068
         DEFOVL OVJUN1,18,109     ;069
         DEFOVL OVJUN2,18,113     ;070
         DEFOVL OVJUN3,60,93      ;071
         DEFOVL OVJUN4,63,101     ;072
         DEFOVL OVJUN5,66,65      ;073
         DEFOVL OVJUN6,23,105     ;074
         DEFOVL OVJUN7,23,1       ;075
         DEFOVL OVJUN8,48,69      ;076
         DEFOVL OVSHD1,37,21      ;077
         DEFOVL OVSHD2,34,33      ;078
         DEFOVL OVSHD3,23,13      ;079
         DEFOVL OVSHD4,34,13      ;080
         DEFOVL OVBCH1,50,1       ;081
         DEFOVL OVBCH2,50,41      ;082
         DEFOVL OVSHD5,1,1        ;083
         DEFOVL OVSHA1,27,9       ;084
         DEFOVL OVSHA3,37,13      ;085
         DEFOVL OVSHA4,44,13      ;086
         DEFOVL OVSHA5,40,21      ;087
         DEFOVL OVSVL1,16,37      ;088
         DEFOVL OVBOT3,62,117     ;089
         DEFOVL OVSHA6,30,81      ;090
         DEFOVL OVSHA2,1,121      ;091
         DEFOVL OVSHAA,42,97      ;092
         DEFOVL OVCLK1,9,41       ;093
         DEFOVL OVSNK1,68,49      ;094
         DEFOVL OVBTS1,79,81      ;095
         DEFOVL OVSHA7,49,73      ;096
         DEFOVL OVSHA8,27,37      ;097
         DEFOVL OVSHA9,20,57      ;098
         DEFOVL OVPAS9,16,25      ;099
         DEFOVL OVMIC1,61,69      ;100
         DEFOVL OVNAT1,26,1       ;101
         DEFOVL OVBOT4,55,109     ;102
         DEFOVL OVOAR1,52,77      ;103
         DEFOVL OVIDL1,31,73      ;104
         DEFOVL OVCRN1,72,89      ;105
         DEFOVL OVPOT1,69,61      ;106
         DEFOVL OVTMB1,52,45      ;107
         DEFOVL OVTMB2,69,29      ;108
         DEFOVL OVDVC8,25,29      ;109
         DEFOVL OVDVC9,25,69      ;110
         DEFOVL OVDVCA,52,1       ;111
         DEFOVL OVDVCB,36,5       ;112
         DEFOVL OVDVCC,25,29      ;113
         DEFOVL OVDVCD,25,69      ;114
         DEFOVL OVDVCE,43,1       ;115
         DEFOVL OVDVCF,36,5       ;116
         DEFOVL OVBCH4,62,1       ;117
         DEFOVL OVRUG2,82,17      ;118
         DEFOVL OVTRP1,72,97      ;119
         DEFOVL OVCLK2,30,41      ;120
         DEFOVL OVCLK3,30,41      ;121
         DEFOVL OVCLK4,30,41      ;122
         DEFOVL OVSNK2,74,49      ;123
         DEFOVL OVSNK3,74,49      ;124

GENHLP   DB    13,'Tr','y'+80H
         DB    'examinin','g'+80H
         DB    'things.',0

         DB    13,'N','o'+80H
         DB    'HEL','P'+80H
         DB    'available.',0

         DB    13,'Us','e'+80H
         DB    'SAV','E'+80H
         DB    'often.',0

         DB    13,C$IM
         DB    'stumpe','d'+80H
         DB    'too!',0

; DIRECTION DESCRIPTIONS TABLE

DIRECT   DB    'North',0
         DB    'South',0
         DB    'East',0
         DB    'West',0
         DB    'Up',0
         DB    'Down',0

; OBJECT DESCRIPTIONS TABLE

OBJTAB   EQU   $
         DB    8,C$AN
         DB    'unli','t'+80H
         DB    'flashlight',0

         DB    9,'a'+80H
         DB    'li','t'+80H
         DB    'flashlight',0

         DB    10,C$AN
         DB    'orienta','l'+80H
         DB    'rug',0

         DB    11,'a'+80H
         DB    'pai','r'+80H,C$OF
         DB    'spectacles',0

         DB    12,C$AN
         DB    'instructio','n'+80H
         DB    'manual',0

         DB    13,'a'+80H
         DB    'bo','x'+80H,C$OF
         DB    'costum','e'+80H
         DB    'jewelry',0

         DB    14,'a'+80H
         DB    'tir','e'+80H
         DB    'pump',0

         DB    15,'a'+80H
         DB    'bucket',0

         DB    16,'a'+80H
         DB    'mous','e'+80H
         DB    'trap',0

         DB    17,'a'+80H
         DB    'pai','r'+80H,C$OF
         DB    'hikin','g'+80H
         DB    'boots',0

         DB    18,'a'+80H
         DB    'handwritte','n'+80H
         DB    'message',0

         DB    19
         DB    'ancien','t'+80H
         DB    'cano','e'+80H
         DB    'paddles',0

         DB    20,'a'+80H
         DB    'shovel',0

         DB    21,'a'+80H
         DB    'deflate','d'+80H
         DB    'rubbe','r'+80H
         DB    'boat',0

         DB    23
         DB    'som','e'+80H
         DB    'key','s'+80H,C$ONA
         DB    'chain',0

         DB    24,'a'+80H
         DB    'machete',0

         DB    26
         DB    'mice',0

         DB    27
         DB    'microfilm',0

         DB    28
         DB    '*Montezuma',QUOTE,'s'+80H
         DB    'jewelle','d'+80H
         DB    'crown*',0

         DB    29,C$AN
         DB    'ancien','t'+80H
         DB    'Maya','n'+80H
         DB    'pottery',0

         DB    30,C$AN
         DB    'ol','d'+80H
         DB    'woode','n'+80H
         DB    'chest',0

         DB    31,0FFH,30,0

         DB    32,0FFH,10,0

         DB    93,'a'+80H
         DB    'bi','g'+80H
         DB    'rubbe','r'+80H
         DB    'boat',0

         DB    94,'a'+80H
         DB    'rol','l'+80H
         DB    'to','p'+80H
         DB    'desk',0

         DB    98,'a'+80H
         DB    'clearin','g'+80H
         DB    C$IN,C$THE
         DB    'jungle',0

         DB    99,'a'+80H
         DB    'marsh','y'+80H
         DB    'field',0

         DB    100,C$THE
         DB    'Professor',QUOTE,'s'+80H
         DB    'laboratory',0

         DB    101,'a'+80H
         DB    'lo','t'+80H,C$OF
         DB    'ocean',0

         DB    102
         DB    'unfriendl','y'+80H
         DB    'natives',0

         DB    103,'a'+80H
         DB    'paga','n'+80H
         DB    'idol',0

         DB    104,'a'+80H
         DB    'tombstone',0

         DB    105,C$THE
         DB    'sand','y'+80H
         DB    'shor','e'+80H,C$OF
         DB    'Calixto',0

         DB    106,'a'+80H
         DB    'war','m'+80H
         DB    'tropica','l'+80H
         DB    'beach',0

         DB    107,'a'+80H
         DB    'freshl','y'+80H
         DB    'cu','t'+80H
         DB    'path',0

         DB    108
         DB    'sand',0

         DB    109,'a'+80H
         DB    'gras','s'+80H
         DB    'shack',0

         DB    110
         DB    'Trade','r'+80H
         DB    'Jac','k'+80H,C$THE
         DB    'beachcomber',0

         DB    111,'a'+80H
         DB    'storag','e'+80H
         DB    'shed',0

         DB    112,'a'+80H
         DB    'hungr','y'+80H
         DB    'lookin','g'+80H
         DB    'snake',0

         DB    113,'a'+80H
         DB    'narro','w'+80H
         DB    'crevic','e'+80H
         DB    C$IN,C$THE
         DB    'wall',0

         DB    114,'a'+80H
         DB    'crevic','e'+80H
         DB    'betwee','n'+80H
         DB    'tw','o'+80H
         DB    'stones',0

         DB    115,'a'+80H
         DB    'pat','h'+80H
         DB    'barel','y'+80H
         DB    'visibl','e'+80H
         DB    'throug','h'+80H
         DB    'dens','e'+80H
         DB    'jungl','e'+80H
         DB    'foliage',0

         DB    116,'a'+80H
         DB    'passageway',0

         DB    117,'a'+80H
         DB    'smal','l'+80H
         DB    'speaker',0

         DB    118,'a'+80H
         DB    'pane','l'+80H,C$OF
         DB    'pulsin','g'+80H
         DB    'lights',0

         DB    119,'a'+80H
         DB    'ladde','r'+80H
         DB    'leadin','g'+80H
         DB    C$TO,'a'+80H
         DB    'cellar',0

         DB    120,'a'+80H
         DB    'tra','p'+80H
         DB    'doo','r'+80H
         DB    C$IN,C$THE
         DB    'floor',0

         DB    121,C$AN
         DB    'antiqu','e'+80H
         DB    'table',0

         DB    122,C$AN
         DB    'unusua','l'+80H
         DB    'lookin','g'+80H
         DB    'device',0

         DB    123,'a'+80H
         DB    'storag','e'+80H
         DB    'cabine','t'+80H
         DB    'wit','h'+80H,'a'+80H
         DB    'secre','t'+80H
         DB    'passag','e'+80H
         DB    'behin','d'+80H
         DB    'it',0

         DB    124,'a'+80H
         DB    'storag','e'+80H
         DB    'cabinet',0

         DB    125,'a'+80H
         DB    'sign',0

         DB    126,0FFH,94,0

         DB    127,'a'+80H
         DB    'fligh','t'+80H,C$OF
         DB    'stairs',0

; ROOM DESCRIPTIONS TABLE

DESCTB   EQU   $
;ROOM 1
         DB    C$IM,C$IN
         DB    'Professo','r'+80H
         DB    'Lagarto',QUOTE,'s'+80H
         DB    'comfortabl','e'+80H
         DB    'study.',0
;ROOM 2
         DB    C$IM,C$INA
         DB    'diml','y'+80H
         DB    'li','t'+80H
         DB    'attic.',0
;ROOM 3
         DB    C$IM,C$INA
         DB    'must','y'+80H
         DB    'storag','e'+80H
         DB    'cellar.',0
;ROOM 4
         DB    C$IM,C$INA
         DB    'lon','g'+80H
         DB    'narro','w'+80H
         DB    'passageway.',0
;ROOM 5
         DB    C$IM,C$IN,C$THE
         DB    'Professor',QUOTE,'s'+80H
         DB    'secre','t'+80H
         DB    'laborator','y'+80H
         DB    'fille','d'+80H
         DB    'wit','h'+80H
         DB    'comple','x'+80H
         DB    'machiner','y'+80H,C$AND
         DB    'tes','t'+80H
         DB    'equipment.',0
;ROOM 6
         DB    C$IM
         DB    'seate','d'+80H
         DB    'insid','e'+80H,C$AN
         DB    'unusua','l'+80H
         DB    'device.',0
;ROOM 7
         DB    0FFH,6,0
;ROOM 8
         DB    C$IM,C$INA
         DB    'marsh','y'+80H
         DB    'fiel','d'+80H,C$AT,C$THE
         DB    'bas','e'+80H
         DB    C$OF,'a'+80H
         DB    'stee','p'+80H
         DB    'rock','y'+80H
         DB    'hill.',0
;ROOM 9
         DB    C$IM,C$INA
         DB    'tropica','l'+80H
         DB    'jungle.',0
;ROOM 10
         DB    C$IM,C$AT,C$THE
         DB    'remain','s'+80H
         DB    C$OF,C$AN
         DB    'ancien','t'+80H
         DB    'Maya','n'+80H
         DB    'pyramid.',0
;ROOM 11
         DB    C$IM,C$INA
         DB    'Maya','n'+80H
         DB    'pyramid','.'+80H
         DB    'Strang','e'+80H
         DB    'design','s'+80H
         DB    'cove','r'+80H,C$THE
         DB    'walls.',0
;ROOM 12
         DB    0FFH,11,0
;ROOM 13
         DB    0FFH,11,0
;ROOM 14
         DB    C$IM,C$INA
         DB    'larg','e'+80H
         DB    'roo','m'+80H
         DB    'decorate','d'+80H
         DB    'wit','h'+80H
         DB    'Maya','n'+80H
         DB    'artwork.',0
;ROOM 15
         DB    C$IM,C$ON,C$THE
         DB    'sid','e'+80H
         DB    C$OF,'a'+80H
         DB    'stee','p'+80H
         DB    'rock','y'+80H
         DB    'hill.',0
;ROOM 16
         DB    C$IM,C$ONA
         DB    'hilltop','.'+80H
         DB    'A'+80H
         DB    'pat','h'+80H
         DB    'slope','s'+80H
         DB    C$TO,'a'+80H
         DB    'beac','h'+80H
         DB    'below.',0
;ROOM 17
         DB    C$IM,C$IN,C$AN
         DB    'ol','d'+80H
         DB    'storag','e'+80H
         DB    'shed.',0
;ROOM 18
         DB    C$IM,C$ONA
         DB    'war','m'+80H
         DB    'tropica','l'+80H
         DB    'beach.',0
;ROOM 19
         DB    C$IM,C$INA
         DB    'smal','l'+80H
         DB    'gras','s'+80H
         DB    'shack.',0
;ROOM 20
         DB    C$IM,C$INA
         DB    'rubbe','r'+80H
         DB    'boat.',0
;ROOM 21
         DB    0FFH,20,0
;ROOM 22
         DB    C$IM,C$ON,C$THE
         DB    'shor','e'+80H,C$OF
         DB    'Calixto.',0
;ROOM 23
         DB    C$IM,C$INA
         DB    'nativ','e'+80H
         DB    'ceremonia','l'+80H
         DB    'area.',0
;ROOM 24
         DB    0FFH,20,0
;ROOM 25
         DB    0FFH,20,0

; COMPRESSED PHRASE TABLE

TXTTAB   EQU   $
         DB    'th','e'+80H,0
         DB    'yo','u'+80H,0
         DB    'ar','e'+80H,0
         DB    'se','e'+80H,0
         DB    'can',QUOTE,'t'+80H,0
         DB    'don',QUOTE,'t'+80H,0
         DB    'Yo','u'+80H,0
         DB    'I',QUOTE,'m'+80H,0
         DB    'i','n'+80H,'a'+80H,0
         DB    'o','n'+80H,'a'+80H,0
         DB    'i','s'+80H,'a'+80H,0
         DB    'It',QUOTE,'s'+80H,0
         DB    'Th','e'+80H,0
         DB    'i','s'+80H,0
         DB    'an','d'+80H,0
         DB    'a','n'+80H,0
         DB    'a','t'+80H,0
         DB    'o','f'+80H,0
         DB    'I','t'+80H,'says:',13,0
         DB    0
         DB    't','o'+80H,0
         DB    'm','y'+80H,0
         DB    'i','n'+80H,0
         DB    'o','n'+80H,0

; VERB ROUTINE JUMP VECTORS

RTNTAB   EQU   $
         DW    VLOOK,VINVE,GETSHA,VPUT
         DW    VNORTH,VSOUTH,VEAST,VWEST
         DW    VUP,VDOWN,VGO,VGO
         DW    VSAVE,VLOAD,VHELP,VSCORE
         DW    VOPEN,BADINP,VREAD
         DW    VFEED,DMSG104,VACTIV
         DW    VPRESS,VTRADE,BADINP
         DW    VCUT,BADINP,VUNLOK
         DW    DMSG070,VINFL,VDEFL,VKILL
         DW    VLIGHT,VUNLIT,VROW,VBAIL
         DW    BADINP,VPUT,VGIVE,VDIG
         DW    BADINP,ENDGAM

; ASSORTED TEXT MESSAGES

MSG000   DB    13,13,'OK',','+80H,0

MSG001   DB    13,13
         DB    'Obviou','s'+80H
         DB    'directions',':'+80H
         DB    0

MSG002   DB    13,13
         DB    'I'+80H,C$SEE,8,':'+80H,0

MSG003   DB    13
         DB    'I'+80H
         DB    C$SEE
         DB    'n','o'+80H
         DB    'wa','y'+80H
         DB    C$TO,'g','o'+80H
         DB    C$IN
         DB    'tha','t'+80H
         DB    'direction.'
         DB    0

MSG004   DB    13
         DB    'I'+80H,C$DONT
         DB    'understan','d'+80H,'"'
         DB    0

MSG005   DB    13,C$IM
         DB    'carryin','g'+80H
         DB    C$THE
         DB    'following:',13,0

MSG006   DB    13
         DB    'nothing.',0

MSG007   DB    13,'I'+80H,C$DONT
         DB    C$SEE,0

MSG008   DB    13
         DB    C$IM
         DB    'carryin','g'+80H,0

MSG009   DB    13,'I'+80H,C$CANT
         DB    'carr','y'+80H
         DB    'anymore.',0

MSG010   DB    13
         DB    'I'+80H,C$DONT
         DB    'hav','e'+80H,0

MSG011   DB    13
         DB    'Hey',','+80H,'I'+80H
         DB    'foun','d'+80H
         DB    'something!',0

MSG012   DB    13,'I'+80H,C$SEE
         DB    'nothin','g'+80H
         DB    'special.',0

MSG013   DB    13,C$IM,C$ON
         DB    'it!',0

MSG014   DB    13,C$IM,C$IN
         DB    'it!',0

MSG015   DB    13,C$IITS
         DB    'beyon','d'+80H,C$MY
         DB    'powe','r'+80H
         DB    C$TO,'d','o'+80H
         DB    'that.',0

MSG016   DB    13,C$IITS
         DB    'closed.',0

MSG017   DB    13,C$IITS
         DB    'locked.',0

MSG018   DB    13,C$IITS
         DB    'open.',0

MSG019   DB    13,C$IITS
         DB    'unlocked.',0

MSG020   DB    13
         DB    'Won',QUOTE,'t'+80H
         DB    'budge.',0

MSG021   DB    13
         DB    'Doesn',QUOTE,'t'+80H
         DB    'work.',0

MSG022   DB    13,C$IITS
         DB    'empty.',0

MSG023   DB    13,'I'+80H,C$CANT
         DB    'd','o'+80H
         DB    'tha','t'+80H
         DB    '..','.'+80H
         DB    'yet!',0

MSG024   DB    13
MSG024B  DB    '00000'
         DB    ' ',C$OF,'1'+80H
         DB    'treasur','e'+80H
         DB    'scored',13
MSG024A  DB    '00000'
         DB    ' move','s'+80H
         DB    'used.',0

MSG025   DB    13,13
         DB    'Thi','s'+80H
         DB    'Adventur','e'+80H
         DB    C$IS
         DB    'over.',13
MSG025B  DB    '00000'
         DB    ' ',C$OF,'1'+80H
         DB    'treasur','e'+80H
         DB    'scored',13
MSG025A  DB    '00000'
         DB    ' move','s'+80H
         DB    'wer','e'+80H
         DB    'used.',13,13
         DB    'Pla','y'+80H
         DB    'agai','n'+80H
         DB    '(Y/N)','?'+80H,0

MSG026   DB    13
         DB    'Don',QUOTE,'t'+80H,'b','e'+80H
         DB    'ridiculous.',0

MSG027   DB    13
         DB    'Congratulations',','+80H
         DB    C$YOU
         DB    'di','d'+80H
         DB    'it.',13,0

MSG028   DB    13
         DB    'Sorry',','+80H,'I'+80H
         DB    C$CANT,'d','o'+80H
         DB    'tha','t'+80H,'-'+80H,0

MSG029   DB    13
         DB    'Mayb','e'+80H,'I'+80H
         DB    'shoul','d'+80H
         DB    'ope','n'+80H
         DB    'it.',0

MSG030   DB    13
         DB    'Hey',','+80H
         DB    'there',QUOTE,'s'+80H,'a'+80H
         DB    'messag','e'+80H
         DB    'here!',0

MSG031   DB    13,'I','t'+80H
         DB    'look','s'+80H
         DB    'interestin','g'+80H
         DB    'alright!',0

MSG032   DB    13,'I'+80H
         DB    'hav','e'+80H,'n','o'+80H
         DB    'wa','y'+80H
         DB    C$TO,'d','o'+80H
         DB    'that.',0

MSG033   DB    13
         DB    'There',QUOTE,'s'+80H,'a'+80H
         DB    'tra','p'+80H
         DB    'doo','r'+80H
         DB    'unde','r'+80H
         DB    'it!',0

MSG034   DB    13,C$IITS
         DB    'to','o'+80H
         DB    'bi','g'+80H,C$AND
         DB    'heavy.',0

MSG035   DB    13,'I'+80H
         DB    'foun','d'+80H,'a'+80H
         DB    'pai','r'+80H,C$OF
         DB    'spectacles.',0

MSG036   DB    13
         DB    'There',QUOTE,'s'+80H,C$AN
         DB    'instructio','n'+80H
         DB    'manua','l'+80H,C$IN
         DB    'here.',0

MSG037   DB    13
         DB    'There',QUOTE,'s'+80H,'a'+80H
         DB    'mous','e'+80H
         DB    'tra','p'+80H
         DB    C$IN,'it.',0

MSG038   DB    13,C$IITS,'a'+80H
         DB    'conceale','d'+80H
         DB    'switch.',0

MSG039   DB    13,'I'+80H
         DB    'hear','d'+80H,'a'+80H
         DB    'strang','e'+80H
         DB    'sound.',0

MSG040   DB    13
         DB    'They',QUOTE,'r','e'+80H
         DB    'wir','e'+80H
         DB    'frame','d'+80H
         DB    'readin','g'+80H
         DB    'glasses.',0

MSG041   DB    13,C$TTHE
         DB    'messag','e'+80H
         DB    'reads...',13
         DB    '-'+80H,C$TTHE
         DB    'Professor',QUOTE,'s'+80H
         DB    'note','s'+80H
         DB    'shoul','d'+80H
         DB    'giv','e'+80H
         DB    'som','e'+80H
         DB    'clue','s'+80H,'-',0

MSG042   DB    13
         DB    'Mayb','e'+80H,'I'+80H
         DB    'shoul','d'+80H
         DB    'rea','d'+80H
         DB    'it!',0

MSG043   DB    13,C$IITS
         DB    'jus','t'+80H,'a'+80H
         DB    'regula','r'+80H
         DB    'mousetrap.',0

MSG044   DB    13,C$IITS
         DB    'quit','e'+80H
         DB    'large','.'+80H,'I'+80H
         DB    C$SEE,C$AN
         DB    'instrumen','t'+80H
         DB    'pane','l'+80H,C$AND,'a'+80H
         DB    'reclinin','g'+80H
         DB    'seat.',0

MSG045   DB    13
         DB    'I'+80H,C$DONT,C$SEE
         DB    'the','m'+80H
         DB    'here.',0

MSG046   DB    13
         DB    'They',QUOTE,'r','e'+80H
         DB    'mad','e'+80H,C$OF
         DB    'heav','y'+80H
         DB    'leathe','r'+80H
         DB    'wit','h'+80H
         DB    'rubbe','r'+80H
         DB    'cleats.',0

MSG047   DB    13,'I','t'+80H
         DB    'says...',13
         DB    '-T','o'+80H
         DB    'ligh','t'+80H,C$IS
         DB    'good',13
         DB    '-T','o'+80H
         DB    'unligh','t'+80H,C$IS
         DB    'wise',0

MSG048   DB    13,C$TTHE
         DB    'titl','e'+80H,C$IS,':',13
         DB    '-'+80H
         DB    'Teleporte','r'+80H
         DB    'Operatin','g'+80H
         DB    'Manual',13
         DB    C$TTHE
         DB    'introductio','n'+80H
         DB    'say','s'+80H,':',13
         DB    '-'+80H,'T','o'+80H,'b','e'+80H
         DB    'use','d'+80H,'i','f'+80H
         DB    'problem','s'+80H
         DB    'arise',0

MSG049   DB    13,C$IM
         DB    'no','t'+80H
         DB    'sur','e'+80H,'I'+80H
         DB    'understan','d'+80H
         DB    'thes','e'+80H
         DB    'comple','x'+80H
         DB    'things.',0

MSG050   DB    13,C$TTHE
         DB    'jungl','e'+80H
         DB    'growt','h'+80H,C$IS
         DB    'ver','y'+80H
         DB    'dense.',0

MSG051   DB    13,C$TTHE
         DB    'flashligh','t'+80H,C$IS
         DB    'lit.',0

MSG052   DB    13,C$IITS
         DB    'off!',0

MSG053   DB    13,C$TTHE
         DB    'manua','l'+80H
         DB    'says...',13
         DB    '1','.'+80H
         DB    'Activat','e'+80H,C$THE
         DB    'energizer',13
         DB    '2','.'+80H
         DB    'Pres','s'+80H,C$THE
         DB    'telepor','t'+80H
         DB    'button',0

MSG054   DB    13,C$TTHE
         DB    'teleporte','r'+80H
         DB    'vibrate','s'+80H
         DB    'slightl','y'+80H,C$AND
         DB    'emit','s'+80H,'a'+80H
         DB    'lo','w'+80H
         DB    'hum.',0

MSG055   DB    13
         DB    'Nothin','g'+80H
         DB    'happens!',0

MSG056   DB    13,13,'A'+80H
         DB    'mechanica','l'+80H
         DB    'soundin','g'+80H
         DB    'voic','e'+80H
         DB    'fro','m'+80H,C$THE
         DB    'speake','r'+80H
         DB    'says...',13
         DB    '-Pleas','e'+80H
         DB    'rea','d'+80H
         DB    'you','r'+80H
         DB    'manua','l'+80H
         DB    'befor','e'+80H
         DB    'operatin','g'+80H,C$THE
         DB    'teleporter-',0

MSG057   DB    13,13
         DB    'Welcom','e'+80H
         DB    C$TO,C$THE
         DB    'Calixt','o'+80H
         DB    'Islan','d'+80H
         DB    'Adventure.',0

MSG058   DB    13,13
         DB    'Trade','r'+80H
         DB    'Jac','k'+80H
         DB    'say','s'+80H,'-'+80H
         DB    'H','i'+80H
         DB    'Bub','!'+80H
         DB    'Go','t'+80H
         DB    'somethin',QUOTE+80H,C$TO
         DB    'trade?',0

MSG059   DB    13
         DB    'Jac','k'+80H
         DB    'won',QUOTE,'t'+80H
         DB    'le','t'+80H,'me','.'+80H
         DB    'H','e'+80H,'says:',13
         DB    '-'+80H
         DB    'That',QUOTE,'s'+80H
         DB    'stealin',QUOTE+80H
         DB    'no','t'+80H
         DB    'tradin',QUOTE+80H,'-',0

MSG060   DB    13
         DB    'Jac','k'+80H
         DB    'says:',13,'-'+80H
         DB    'That',QUOTE,'s'+80H
         DB    'cheatin',QUOTE+80H
         DB    'Bu','b'+80H,'-',0

MSG061   DB    13
         DB    'Jac','k'+80H
         DB    'says:',13,'-'+80H
         DB    'N','o'+80H
         DB    'dea','l'+80H
         DB    'Bub','!'+80H,'-',0

MSG062   DB    13,C$IM
         DB    'needin',QUOTE+80H
         DB    'somethin',QUOTE+80H,C$TO
         DB    'cove','r'+80H,C$MY
         DB    'dir','t'+80H
         DB    'floor.',0

MSG063   DB    13,C$IM
         DB    'needin',QUOTE+80H
         DB    'somethin',QUOTE+80H,C$TO
         DB    'stor','e'+80H,C$MY
         DB    'jun','k'+80H
         DB    'in.',0

MSG064   DB    13
         DB    'Jac','k'+80H
         DB    'say','s'+80H,'-'+80H
         DB    C$IITS,'a'+80H
         DB    'dea','l'+80H
         DB    'Bub','!'+80H,'-'+80H
         DB    'Tak','e'+80H
         DB    'wha','t'+80H
         DB    'ye','r'+80H
         DB    'needin',QUOTE+80H,'-',0

MSG065   DB    13
         DB    'Boy',','+80H
         DB    'tha','t'+80H
         DB    'wa','s'+80H
         DB    'har','d'+80H
         DB    'work.',0

MSG066   DB    13,'I'+80H
         DB    'hav','e'+80H,'n','o'+80H
         DB    'trap.',0

MSG067   DB    13,'I'+80H
         DB    'hav','e'+80H,'n','o'+80H
         DB    'key.',0

MSG068   DB    13,C$TTHE
         DB    'prin','t'+80H,C$IS
         DB    'to','o'+80H
         DB    'small.',0

MSG069   DB    13,C$ITSA
         DB    'I','t'+80H
         DB    'mus','t'+80H,'b','e'+80H
         DB    'burie','d'+80H
         DB    C$AT,C$THE
         DB    'paga','n'+80H
         DB    'ido','l'+80H,C$ON
         DB    'Calixt','o'+80H
         DB    'Island','.'+80H
         DB    'I','f'+80H,C$YOU
         DB    'fin','d'+80H
         DB    'it',','+80H
         DB    'pu','t'+80H,'i','t'+80H
         DB    C$IN,C$MY
         DB    'study.',0

MSG070   DB    13,'I'+80H,C$DONT
         DB    'hea','r'+80H
         DB    'anythin','g'+80H
         DB    'now.',0

MSG071   DB    13,'I'+80H,C$DONT
         DB    'hav','e'+80H
         DB    'them.',0

MSG072   DB    13,C$IM
         DB    'carryin','g'+80H
         DB    'them!',0

MSG073   DB    13
         DB    'No','t'+80H
         DB    'whil','e'+80H,C$IM
         DB    'carryin','g'+80H
         DB    'it.',0

MSG074   DB    13,'I'+80H
         DB    'hav','e'+80H,'n','o'+80H
         DB    'pump.',0

MSG075   DB    13,C$IITS
         DB    'ful','l'+80H,C$OF
         DB    'air.',0

MSG076   DB    13,C$IITS
         DB    'to','o'+80H
         DB    'bi','g'+80H,C$AND
         DB    'bulky.',0

MSG077   DB    13,'I','t'+80H
         DB    'need','s'+80H
         DB    'air.',0

MSG078   DB    13,C$IITS
         DB    'alread','y'+80H
         DB    'deflated.',0

MSG079   DB    13
         DB    'That',QUOTE,'s'+80H
         DB    'no','t'+80H
         DB    'ver','y'+80H
         DB    'nice.',0

MSG080   DB    13,'N','o'+80H
         DB    'way',','+80H,'I'+80H
         DB    'won',QUOTE,'t'+80H,'g','o'+80H
         DB    'nea','r'+80H
         DB    'it!',0

MSG081   DB    13
         DB    'No','t'+80H
         DB    'wit','h'+80H
         DB    'tha','t'+80H
         DB    'snak','e'+80H
         DB    'there!',0

MSG082   DB    13,C$TTHE
         DB    'snak','e'+80H
         DB    'grab','s'+80H,'a'+80H
         DB    'mous','e'+80H,C$AND
         DB    'slither','s'+80H
         DB    'away.',0

MSG083   DB    13,'I'+80H
         DB    'los','t'+80H,C$MY
         DB    'footin','g'+80H,C$AND
         DB    'fel','l'+80H
         DB    C$ON,C$THE
         DB    'rock','s'+80H
         DB    'below','.'+80H,C$IM
         DB    'dead!',0

MSG084   DB    13,C$IITS
         DB    'pitc','h'+80H
         DB    'black','.'+80H
         DB    'I'+80H,C$CANT,C$SEE
         DB    'anything!',13,0

MSG085   DB    13,C$IITS
         DB    'lit.',0

MSG086   DB    13,C$IITS
         DB    'off.',0

MSG087   DB    13,13
         DB    'Ligh','t'+80H
         DB    'run','s'+80H
         DB    'ou','t'+80H,C$IN
MSG087A  DB    '00'
         DB    ' move(s).',0

MSG088   DB    13,'I'+80H
         DB    'thin','k'+80H,'w','e'+80H
         DB    'nee','d'+80H
         DB    'som','e'+80H
         DB    'water!',0

MSG089   DB    13
         DB    'Perhap','s'+80H,'I'+80H
         DB    'shoul','d'+80H
         DB    'si','t'+80H
         DB    C$IN,C$THE
         DB    'boat.',0

MSG090   DB    13,'I'+80H
         DB    'hav','e'+80H,'n','o'+80H
         DB    'paddles.',0

MSG091   DB    13,13,C$TTHE
         DB    'boa','t'+80H,C$IS
         DB    'leaking',','+80H
         DB    'mayb','e'+80H,'I'+80H
         DB    'shoul','d'+80H
         DB    '"BAI','L'+80H
         DB    'WATER".',0

MSG092   DB    13,13,C$TTHE
         DB    'boa','t'+80H
         DB    'san','k'+80H,C$AND,'I'+80H
         DB    'hav','e'+80H
         DB    'drown.',0

MSG093   DB    13,C$TTHE
         DB    'epitap','h'+80H
         DB    'says...',13
         DB    'Professo','r'+80H
         DB    'Lagart','o'+80H
         DB    'didn',QUOTE,'t'+80H
         DB    'mak','e'+80H
         DB    'it.',0

MSG094   DB    13,C$IITS
         DB    'jus','t'+80H,'a'+80H
         DB    'commo','n'+80H
         DB    'paga','n'+80H
         DB    'idol.',0

MSG095   DB    13,C$IITS
         DB    'brightl','y'+80H
         DB    'decorated.',0

MSG096   DB    13,'I'+80H
         DB    'hav','e'+80H,'n','o'+80H
         DB    'shovel.',0

MSG097   DB    13,C$TTHE
         DB    'native','s'+80H
         DB    'gra','b'+80H,C$THE
         DB    'jewelr','y'+80H,C$AND
         DB    'wande','r'+80H
         DB    'happil','y'+80H
         DB    'away.',0

MSG098   DB    13,13,C$TTHE
         DB    'native','s'+80H
         DB    'won',QUOTE,'t'+80H
         DB    'le','t'+80H
         DB    'me.',0

MSG099   DB    13,'I'+80H,C$SEE
         DB    'n','o'+80H
         DB    'on','e'+80H,C$TO
         DB    'giv','e'+80H
         DB    'the','m'+80H
         DB    'to.',0

MSG100   DB    13,C$IITS
         DB    'mad','e'+80H,C$OF
         DB    'gol','d'+80H,C$AND
         DB    'preciou','s'+80H
         DB    'rubies.',0

MSG101   DB    13,'I','t'+80H
         DB    'says...',13
         DB    'Close','d'+80H
         DB    'fo','r'+80H,C$THE
         DB    'summer.',0

MSG102   DB    13,C$IITS
         DB    'dangerou','s'+80H
         DB    C$TO
         DB    'mov','e'+80H
         DB    'aroun','d'+80H
         DB    C$IN,C$THE
         DB    'dark!',0

MSG103   DB    13
         DB    'Ooh','!'+80H
         DB    'ouch!','!'+80H
         DB    '..','.'+80H,'I'+80H
         DB    'fel','l'+80H
         DB    'dow','n'+80H,C$AND
         DB    'cracke','d'+80H,C$MY
         DB    'head','.'+80H,C$IM
         DB    'dead!',0

MSG104   DB    13
         DB    'Wheeeee...',0

;
;        END FILE: ADVDATA2.ASM
;
