
;            FILE = ADVDATA1.ASM  LAST MODIFIED: 10/11/85

MAXOBJ0  EQU   4                  ;MAX OBJECTS ALLOWED TO CARRY
NORMS0   EQU   26                 ;NUMBER OF ROOMS IN ADVENTURE
TRESRM0  EQU   1                  ;ROOM TO STORE TREASURE IN
MAXPNT0  EQU   1                  ;TOTAL POINTS REQUIRED TO WIN
DEADRM0  EQU   26                 ;DEFAULT ROOM TO DIE IN
ADVNUM0  EQU   03                 ;ADVENTURE NUMBER FOR SAVE GAME

ABS0     SEGMENT AT 0000H

         ORG   0070H
TIMER_INT DD   ?                  ;TIMER TICK INTERRUPT VECTOR

         ORG   0410H
EQUIP_FLAG DW  ?                  ;EQUIPMENT INSTALLED FLAG

         ORG   046CH
TIMER_LOW1 DB  ?
TIMER_LOW2 DB  ?                  ;LOW ORDER BYTE OF TIMER_LOW

ABS0     ENDS

VIDEO    SEGMENT AT 0B800H

         ORG   0
GSCRN1@W LABEL WORD
GSCRN1   DB    92/2*80 DUP(?)     ;EVEN SCAN LINES GRAPHIC SCREEN
TSCRN1@W LABEL WORD
TSCRN1   DB    108/2*80 DUP(?)    ;EVEN SCAN LINES TEXT SCREEN
         ORG   2000H
GSCRN2@W LABEL WORD
GSCRN2   DB    92/2*80 DUP(?)     ;ODD SCAN LINES GRAPHIC SCREEN
TSCRN2@W LABEL WORD
TSCRN2   DB    108/2*80 DUP(?)    ;ODD SCAN LINES TEXT SCREEN

VIDEO    ENDS

STKSEG   SEGMENT STACK
         DW    256 DUP(0)
STKTOP   EQU   $
STKSEG   ENDS

DATA     SEGMENT PUBLIC

         EXTRN   PROTSW:BYTE, VALIDSW:BYTE

         PUBLIC  COLOR1,      COLOR2,      ANTTAB,      ROWCOL
         PUBLIC  ROW,         COL,         MOVOBJ,      ROOM
         PUBLIC  ANTIMSW,     SCROBJ,      SCRPOS,      LINELEN
         PUBLIC  ADVNUM,      CURCHR,      KEYBUF,      TXTTAB
         PUBLIC  MSGLNS,      GPC_TAB,     MODE,        COUNT
         PUBLIC  CUR_BYT1,    CUR_BYT2,    CUR_BYTE@W,  REFRCT
         PUBLIC  NLNSCT,      MSGMOR,      LIT160,      RANDOM
         PUBLIC  TIMER_LOW1,  TIMER_LOW2,  RMTB_LEN
         PUBLIC  EIGHTY,      GAMSAV,      STARTVAR,    SAVNO
         PUBLIC  RECSIZ,      CURR_REC,    SAVEKEY1,    SAVEKEY2

         PUBLIC  RMOBT1,      RMOBT2,      PUTTAB,      PNTTAB
         PUBLIC  POINTS,      OBJECT,      OBJCNT,      EQUTAB
         PUBLIC  NOUNNO,      VERBNO,      SCRIND,      VERB
         PUBLIC  NOUN,        MOVOBJ,      VERBTB,      NOUNTB
         PUBLIC  ASCSAV,      TENTBL,      SCRTAB,      ROOMTB
         PUBLIC  MAXOBJ1,     NORMS1,      TRESRM1

;        GENERAL ADVENTURE KERNEL VARIABLES

STARTVAR EQU   $

SAVEKEY1 DB    0                  ;ADVENTURE SAVE FILE MARKER
SAVEKEY2 DB    0                  ;ADVENTURE SAVE FILE ADV NUMBER
ROOM     DB    0
RANDOM   DB    ?
NEWRM    DB    ?
VERB_NOUN LABEL WORD
NOUNNO   DB    ?
VERBNO   DB    ?
VERB     DB    MAXWRD DUP(?)
NOUN     DB    MAXWRD DUP(?)
MSGLNS   DB    ?
ANTIMSW  DB    0                  ;IF ZERO NO ANTIMATION ROUTINE
ROWCOL   LABEL WORD
ROW      DB    ?
COL      DB    ?
COLOR1   DB    ?
COLOR2   DB    ?
FLIPSW   DB    ?
FLIPCT   DW    ?
FLP2SW   DB    ?
FLP2CT   DW    ?
LITESW   DB    ?
LITECT   DB    ?
RMMOVE   DB    ?
POINTS   DB    ?
SCORE    DW    ?
OBJCNT   DB    ?
OBJECT   DB    MAXOBJ0 DUP(?)

;        ADVENTURE UNIQUE VARIABLES
BAILSW   DB    ?
POTTSW   DB    ?
ENERSW   DB    ?
FIRST1   DB    ?
TRADSW   DB    ?
CHSTSW   DB    ?
DESKSW   DB    ?
CLRSW    DB    ?

ENDVAR   EQU   $

;        ADVENTURE CONSTANTS

ADVNUM   DB    ADVNUM0
MAXOBJ1  DB    MAXOBJ0
NORMS1   DB    NORMS0
TRESRM1  DB    TRESRM0
MAXPNT1  DB    MAXPNT0
DEADRM1  DB    DEADRM0
EIGHTY   DB    80
LIT160   DB    160
TENTBL   DW    10000,1000,100,10,1,0

ASCSAV   DW    0
MSGMOR   DB    '- (MORE) - ',0
VERSN    DB    ' V2.2',0
MDPCRE   DB    ' Mar','k'+80H,'Dat','a'+80H
         DB    'Products',13,13
         DB    7 DUP(' '+80H)
         DB    'presents',0
CREDIT   DB    9 DUP(' '+80H)
         DB    'By:',13,13
         DB    2 DUP(' '+80H)
         DB    ' Bo','b'+80H,'Wither','s'+80H,C$AND
         DB    'Stephe','n'+80H,'O',27H,'Dea',13,13,13
         DB    2 DUP(' '+80H)
         DB    'Copyrigh','t'+80H,'(c',')'+80H,'1981',','+80H
         DB    '1983',','+80H,'1984',13
         DB    5 DUP(' '+80H)
         DB    'Mar','k'+80h,'Dat','a'+80h,'Products',13
         DB    5 DUP(' '+80H)
         DB    'Al','l'+80H,'Right','s'+80H,'Reserved',0
ENDMSG   DB    13,'Inser','t'+80H,'a'+80H,'DO','S'+80H
         DB    'diskett','e'+80H,'i','n'+80H,'driv','e'+80H
         DB    'A'+80H,C$AND,'pres','s'+80H,'CTRL-ALT-DEL.',0

MON_MSG  DB    13,13
         DB    'Pleas','e'+SPC
         DB    'selec','t'+SPC,C$THE
         DB    'typ','e'+SPC,C$OF
         DB    'monito','r'+SPC
         DB    'yo','u'+SPC,C$ARE
         DB    'using:',13,13
         DB    ' '+SPC
         DB    '1','.'+SPC,'RG','B'+SPC,'monitor',13
         DB    ' '+SPC
         DB    '2','.'+SPC,'B&','W'+SPC,'Composit','e'+SPC,'monitor',13
         DB    ' '+SPC
         DB    '3','.'+SPC,'Colo','r'+SPC,'Composit','e'+SPC,'monitor',13
         DB    0

;
;        DATA USED BY DISPLAY OVERLAY ROUTINES
;
CUR_BYTE@W LABEL WORD
CUR_BYT1 DB    ?
CUR_BYT2 DB    ?
MODE     DB    ?
REFRCT   DB    ?
NLNSCT   DB    ?
COUNT    DB    ?
LINELEN  DB    ?
SCRPOS   DW    ?
CURCHR   DB    BLUE@B

;        KEYBOARD BUFFER STORAGE

KEYBUF   DB    MAXLINE+1 DUP(?)

;        GRAPHIC PIXEL CONVERSION TABLE

GPC_TAB  DW    256 DUP(?)

GAMSAV   DB    1                  ;DISK DRIVE A
         DB    'CALIXTO '         ;FILENAME
         DB    'SV'               ;EXT
SAVNO    DB    '0'                ;SAVE GAME NUMBER
         DW    0                  ;CURRENT BLOCK
RECSIZ   DW    128                ;RECORD SIZE
         DW    0,0                ;FILE SIZE
         DW    0                  ;DATE OF LAST WRITE
         DW    0                  ;TIME OF LAST WRITE
         DW    0,0,0,0            ;RESERVED FOR MS-DOS
CURR_REC DB    0                  ;CURRENT RECORD
         DW    0,0                ;RELATIVE RECORD

;
;        FILE: ADVDATA1.ASM
;
