;
;        FILE: ADVCODE2.ASM   --   CALIXTO ISLAND
;

;        LOOK DESK

LOOK01   PROC
         MOV   AL,NOUNNO
         CALL  CKOBJ
         JNE   LOOK01_A
         MOV   AL,94              ;OPEN DESK
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   AL,27+INV          ;MICROFILM
         CALL  MAKVIS
         LBEQ  DMSG012
         CALL  CKDRAW
         JMP   DMSG011
LOOK01_A:
         TEST  DESKSW,0FFH
         LBNE  DMSG029
         MOV   BX,OFFSET MSG028
         CALL  DISPLY
         JMP   DMSG017
LOOK01   ENDP

;        LOOK TABLE

LOOK02   PROC
         MOV   AL,121             ;TABLE
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   AL,18+INV          ;MESSAGE
         CALL  MAKVIS
         LBEQ  DMSG012
         CALL  CKDRAW
         JMP   DMSG030
LOOK02   ENDP

;        LOOK RUG

LOOK03   PROC
         MOV   AL,10              ;RUG
         CALL  LOCOBJ
         LBNE  DMSG012
         MOV   AL,119             ;LADDER TO CELLAR
         CALL  CKOBJ
         LBNE  DMSG012
         JMP   DMSG031
LOOK03   ENDP

;        LOOK DOOR

LOOK04   PROC
         MOV   AL,ROOM
         CMP   AL,5
         JB    LOOK04_B
         CMP   AL,8
         JA    LOOK04_B
         JNE   LOOK04_A
         MOV   AL,122             ;DEVICE
         CALL  CKOBJ
         LBEQ  NOSEE
LOOK04_A:
         JMP   DMSG012
LOOK04_B:
         MOV   AL,NOUNNO
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   AL,119             ;LADDER
         CALL  CKOBJ
         LBNE  DMSG012
         MOV   BX,OFFSET MSG031
         CALL  DISPLY
         JMP   DMSG029
LOOK04   ENDP

;        LOOK CHEST

LOOK05   PROC
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CALL  LOCOBJ
         LBEQ  NOSEE
         MOV   AL,CHSTSW
         CMP   AL,0
         LBEQ  DMSG016
         CMP   AL,1
         LBEQ  DMSG035
         CMP   AL,2
         LBEQ  DMSG036
         JMP   DMSG022
LOOK05   ENDP

;        LOOK CABINET

LOOK06   PROC
         CMP   ROOM,3
         LBNE  NOSEE
         MOV   AL,16+INV          ;MOUSETRAP
         CALL  MAKVIS
         JE    LOOK06_A
         CALL  CKDRAW
         JMP   DMSG037
LOOK06_A:
         MOV   BX,OFFSET MSG011
         CALL  DISPLY
         JMP   DMSG038
LOOK06   ENDP

;        LOOK LADDER

LOOK07   PROC
         CMP   ROOM,3
         LBEQ  DMSG012
         JMP   LOOKOB
LOOK07   ENDP

;        LOOK MANUAL

LOOK08   PROC
         MOV   AL,NOUNNO
         CALL  HAVOBJ
         LBEQ  NOHAVE
         MOV   BX,OFFSET MSG031
         CALL  DISPLY
         JMP   DMSG042
LOOK08   ENDP

;        LOOK SWITCH

LOOK09   PROC
         MOV   AL,ROOM
         CMP   AL,3
         JE    LOOK09_A
         CMP   AL,6
         JE    LOOK09_A
         CMP   AL,7
         LBNE  LOOKOB
LOOK09_A:
         JMP   DMSG012
LOOK09   ENDP

;        LOOK DEVICE

LOOK10   PROC
         MOV   AL,117             ;SPEAKER
         CALL  CKOBJ
         LBNE  DMSG014
         MOV   AL,122             ;DEVICE
         CALL  CKOBJ
         LBEQ  NOSEE
         JMP   DMSG044
LOOK10   ENDP

;        LOOK PASSAGE

LOOK11   PROC
         CMP   ROOM,4
         JE    LOOK11_A
         MOV   AL,123             ;STORAGE CABINET W/PASSAGE
         CALL  CKOBJ
         LBEQ  LOOKOB
LOOK11_A:
         JMP   DMSG012
LOOK11   ENDP

;        LOOK PATH

LOOK14   PROC
         MOV   AL,ROOM
         CMP   AL,16
         JE    LOOK14_A
         CMP   AL,9
         LBNE  NOSEE
LOOK14_A:
         JMP   DMSG012
LOOK14   ENDP

;        LOOK MICROFILM

LOOK15   PROC
         MOV   AL,NOUNNO
         CALL  HAVOBJ
         LBEQ  NOHAVE
         MOV   AL,11              ;SPECS
         CALL  HAVOBJ
         LBEQ  DMSG068
         JMP   DMSG069
LOOK15   ENDP

;        LOOK ENERGIZER

LOOK16   PROC
         MOV   AL,ROOM
         CMP   AL,6
         JE    LOOK16_A
         CMP   AL,7
         LBNE  NOSEE
LOOK16_A:
         JMP   DMSG012
LOOK16   ENDP

;        LOOK HILL

LOOK17   PROC
         MOV   AL,ROOM
         CMP   AL,8
         JE    LOOK17_A
         CMP   AL,15
         JE    LOOK17_A
         CMP   AL,16
         LBNE  NOSEE
LOOK17_A:
         JMP   DMSG012
LOOK17   ENDP

;        LOOK FIELD

LOOK18   PROC
         CMP   ROOM,8
         LBEQ  DMSG012
         JMP   LOOKOB
LOOK18   ENDP

;        LOOK LAB

LOOK19   PROC
         CMP   ROOM,5
         LBEQ  DMSG012
         JMP   LOOKOB
LOOK19   ENDP

;        LOOK SHACK

LOOK20   PROC
         CMP   ROOM,19
         LBEQ  DMSG012
         JMP   LOOKOB
LOOK20   ENDP

;        LOOK SHED

LOOK21   PROC
         CMP   ROOM,17
         LBEQ  DMSG012
         JMP   LOOKOB
LOOK21   ENDP

;        GET RUG

GET01    PROC
         MOV   AL,32              ;RUG OVER DOOR
         CALL  CKOBJ
         JE    GET01_A
         MOV   AL,OBJCNT
         CMP   AL,MAXOBJ1
         JAE   GET01_A
         MOV   AL,32              ;RUG OVER DOOR
         MOV   AH,10              ;ROLLED UP RUG
         CALL  CHGOBJ
         MOV   AL,120+INV         ;TRAP DOOR
         CALL  MAKVIS
         MOV   BX,OFFSET MSG033
         CALL  DISPLY
GET01_A:
         JMP   GETSHA
GET01    ENDP

;        GET DESK OR TABLE

GET02    PROC
         MOV   AL,NOUNNO
         CALL  CKOBJ
         LBEQ  NOSEE
         JMP   DMSG034
GET02    ENDP

;        GET MANUAL/SPECS

GET03    PROC
         MOV   AL,30              ;CLOSED CHEST
         CALL  LOCOBJ
         JNE   GET03_A
         MOV   AL,31              ;OPEN CHEST
         CALL  LOCOBJ
         JNE   GET03_A
         JMP   SHORT GET03_D
GET03_A:
         MOV   AL,NOUNNO
         CMP   AL,11              ;SPECS
         JNE   GET03_B
         CMP   CHSTSW,1
         JNE   GET03_D
         MOV   AL,11              ;SPECS
         JMP   SHORT GET03_C
GET03_B:
         CMP   CHSTSW,2
         JNE   GET03_D
         MOV   AL,12
GET03_C:
         MOV   AH,OBJCNT
         CMP   AH,MAXOBJ1
         JAE   GET03_D
         CALL  PUTOBJ
         INC   CHSTSW
GET03_D:
         JMP   GETSHA
GET03    ENDP

;        GET MICE

GET04    PROC
         MOV   AL,NOUNNO
         CALL  CKOBJ
         JE    GET04_A
         MOV   AL,16              ;MOUSETRAP
         CALL  HAVOBJ
         LBEQ  DMSG066
GET04_A:
         JMP   GETSHA
GET04    ENDP

;        GET BOAT

GET05    PROC
         CALL  EQUOBJ
         CMP   NOUNNO,93          ;INFLATED BOAT
         LBEQ  DMSG076
         JMP   GETSHA
GET05    ENDP

;        GET PADDLES

GET06    PROC
         MOV   AL,112             ;SNAKE
         CALL  CKOBJ
         LBEQ  GETSHA
         JMP   DMSG081
GET06    ENDP

;        PUT MICE

PUT01    PROC
         MOV   AL,NOUNNO
         CALL  HAVOBJ
         LBEQ  NOHAVE
         MOV   AL,112             ;SNAKE
         CALL  CKOBJ
         LBEQ  VPUT
         SUB   AH,AH
         CALL  CHGOBJ
         CALL  CKDRAW
         MOV   BX,OFFSET MSG082
         CALL  DISPLY
         MOV   AL,NOUNNO
         SUB   AH,AH
         CALL  REPOBJ
         JMP   REPLY
PUT01    ENDP

;        PUT JEWELS

PUT04    PROC
         MOV   AL,13              ;JEWELS
         CALL  HAVOBJ
         JE    PUT04_A
         MOV   AL,102             ;NATIVES
         CALL  CKOBJ
         JE    PUT04_A
         MOV   AL,13              ;JEWELS
         SUB   AH,AH
         CALL  REPOBJ
         MOV   AL,102             ;NATIVES
         CALL  CHGOBJ
         CALL  CKDRAW
         JMP   DMSG097
PUT04_A:
         JMP   VPUT
PUT04    ENDP

;        GO STAIRS

GO01     PROC
         MOV   AL,ROOM
         CMP   AL,2
         LBHI  NOSEE
         XOR   AL,3
         JMP   EXITRM
GO01     ENDP

;        GO LADDER/DOOR/CELLAR

GO02     PROC
         CMP   ROOM,3
         JNE   GO02_A
         MOV   AL,1
         JMP   SHORT GO02_C
GO02_A:
         MOV   AL,119             ;LADDER
         CALL  CKOBJ
         JNE   GO02_B
         MOV   AL,NOUNNO
         CMP   AL,97              ;CELLAR
         LBEQ  DMSG032
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   BX,OFFSET MSG016
         CALL  DISPLY
         JMP   DMSG029
GO02_B:
         MOV   AL,3
GO02_C:
         JMP   EXITRM
GO02     ENDP

;        GO PASSAGE

GO03     PROC
         MOV   AL,ROOM
         CMP   AL,3
         JE    GO03_B
         CMP   AL,5
         JE    GO03_C
         CMP   AL,4
         LBEQ  DMSG014
GO03_A:
         JMP   NOSEE
GO03_B:
         MOV   AL,123             ;CABINET W/PASSAGE
         CALL  CKOBJ
         JE    GO03_A
GO03_C:
         MOV   AL,4
         JMP   EXITRM
GO03     ENDP

;        GO DEVICE

GO04     PROC
         MOV   AL,117             ;SPEAKER
         CALL  CKOBJ
         LBNE  DMSG014
         MOV   AL,122             ;DEVICE
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   AL,ROOM
         CMP   AL,5
         JA    GO04_A
         INC   AL
         INC   AL
GO04_A:
         DEC   AL
         JMP   EXITRM
GO04     ENDP

;        GO FIELD

GO05     PROC
         MOV   AL,ROOM
         CMP   AL,8
         LBEQ  DMSG014
         CMP   AL,7
         LBNE  NOSEE
         INC   AL
         JMP   EXITRM
GO05     ENDP

;        GO PATH

GO06     PROC
         MOV   AL,ROOM
         CMP   AL,16
         JNE   GO06_A
         MOV   AL,18
         JMP   SHORT GO06_B
GO06_A:
         MOV   AL,115             ;BLOCKED PATH
         CALL  CKOBJ
         JNE   GO06_C
         MOV   AL,107             ;CLEAR PATH
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   AL,10
GO06_B:
         JMP   EXITRM
GO06_C:
         MOV   BX,OFFSET MSG028
         CALL  DISPLY
         JMP   DMSG050
GO06     ENDP

;        GO LAB

GO07     PROC
         MOV   AL,ROOM
         CMP   AL,5
         LBEQ  DMSG014
         CMP   AL,6
         LBNE  NOSEE
         DEC   AL
         JMP   EXITRM
GO07     ENDP

;        GO SHED

GO08     PROC
         MOV   AL,ROOM
         CMP   AL,17
         LBEQ  DMSG014
         CMP   AL,16
         LBNE  NOSEE
         INC   AL
         JMP   EXITRM
GO08     ENDP

;        GO SHACK

GO09     PROC
         MOV   AL,ROOM
         CMP   AL,19
         LBEQ  DMSG014
         CMP   AL,18
         LBNE  NOSEE
         INC   AL
         JMP   EXITRM
GO09     ENDP

;        GO HILL

GO10     PROC
         MOV   AL,ROOM
         CMP   AL,15
         JE    GO10_A
         CMP   AL,16
         JNE   GO10_B
GO10_A:
         JMP   DMSG013
GO10_B:
         CMP   AL,8
         LBNE  NOSEE
         MOV   AL,15
         JMP   EXITRM
GO10     ENDP

;        GO JUNGLE

GO11     PROC
         CMP   ROOM,9
         LBNE  NOSEE
         JMP   GO06
GO11     ENDP

;        GO CREVICE

GO12     PROC
;
;        PROTECTION BELOW
;
         MOV   AL,VALIDSW         ;CHECK FOR LEGAL COPY OF GAME
         CMP   AL,PROTSW          ;  AND DISALLOW ENTRY TO
         LBNE  DMSG023            ;  PASSAGE IF NOT VALID
;
;        PROTECTION ABOVE
;
         MOV   AL,ROOM
         CMP   AL,10
         JE    GO12_A
         CMP   AL,11
         LBNE  NOSEE
GO12_A:
         XOR   AL,1
         JMP   EXITRM
GO12     ENDP

;        GO SHORE/BEACH

GO13     PROC
         MOV   AL,ROOM
         CMP   AL,18
         JE    GO13_A
         CMP   AL,22
         JNE   GO13_B
GO13_A:
         JMP   DMSG013
GO13_B:
         CMP   AL,20
         JNE   GO13_D
         MOV   AL,18
GO13_C:
         JMP   EXITRM
GO13_D:
         CMP   AL,21
         LBNE  NOSEE
         INC   AL
         JMP   SHORT GO13_C
GO13     ENDP

;        GO BOAT

GO14     PROC
         MOV   AL,21              ;DEFLATED BOAT
         CALL  LOCOBJ
         LBNE  DMSG077
         MOV   AL,ROOM
         CMP   AL,20
         JE    GO14_C
         CMP   AL,21
         JE    GO14_C
         CMP   AL,24
         JE    GO14_C
         CMP   AL,25
         JE    GO14_C
         MOV   AL,93              ;INFLATED BOAT
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   AL,ROOM
         CMP   AL,18
         JE    GO14_A
         CMP   AL,22
         LBNE  DMSG088
         MOV   AL,21
         JMP   SHORT GO14_B
GO14_A:
         MOV   AL,20
GO14_B:
         JMP   EXITRM
GO14_C:
         JMP   DMSG014
GO14     ENDP

;        GO CLEARING

GO15     PROC
         MOV   AL,98              ;CLEARING
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   AL,23
         JMP   EXITRM
GO15     ENDP

;        GO DOOR

GO16     PROC
         MOV   AL,ROOM
         CMP   AL,5
         JNE   GO16_A
         INC   AL
         JMP   SHORT GO16_E
GO16_A:
         CMP   AL,6
         JNE   GO16_B
         DEC   AL
         JMP   SHORT GO16_E
GO16_B:
         CMP   AL,7
         JNE   GO16_C
         INC   AL
         JMP   SHORT GO16_E
GO16_C:
         CMP   AL,8
         JNE   GO16_D
         MOV   AL,122             ;DEVICE
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   AL,7
         JMP   SHORT GO16_E
GO16_D:
         JMP   GO02
GO16_E:
         JMP   EXITRM
GO16     ENDP

;        FEED VERB PROCESSOR

VFEED    PROC
         MOV   AL,NOUNNO
         CMP   AL,26              ;MICE
         JNE   VFEED_B
         CALL  HAVOBJ
         LBEQ  NOHAVE
         MOV   AL,112             ;SNAKE
         CALL  CKOBJ
         JE    VFEED_C
VFEED_A:
         MOV   NOUNNO,26          ;MICE
         JMP   PUT01
VFEED_B:
         CMP   AL,112             ;SNAKE
         LBNE  BADINP
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   AL,26              ;MICE
         CALL  HAVOBJ
         JNE   VFEED_A
VFEED_C:
         JMP   DMSG032
VFEED    ENDP

;        CUT VERB PROCESSOR

VCUT     PROC
         MOV   AL,NOUNNO
         CMP   AL,115             ;PATH
         JE    VCUT_A
         CMP   AL,91              ;JUNGLE
         LBNE  BADINP
VCUT_A:
         MOV   AL,107             ;CUT PATH
         CALL  CKOBJ
         JNE   VCUT_B
         MOV   AL,115             ;BLOCKED PATH
         CALL  CKOBJ
         LBEQ  DMSG023
         MOV   AL,24              ;MACHETE
         CALL  HAVOBJ
         LBEQ  DMSG032
         MOV   AL,115             ;BLOCKED PATH
         MOV   AH,107             ;CLEAR PATH
         CALL  CHGOBJ
         MOV   AL,76              ;PATH OVERLAY
         CALL  SHOOVL
VCUT_B:
         JMP   DMSG065
VCUT     ENDP

;        KILL VERB PROCESSOR

VKILL    PROC
         MOV   AL,NOUNNO
         CMP   AL,112             ;SNAKE
         JE    VKILL_A
         CMP   AL,110             ;TRADER JACK
         JE    VKILL_C
         CMP   AL,102             ;NATIVES
         LBNE  BADINP
         CALL  CKOBJ
         JE    VKILL_B
VKILL_C:
         JMP   DMSG079
VKILL_A:
         CALL  CKOBJ
         JE    VKILL_B
         JMP   DMSG080
VKILL_B:
         JMP   NOSEE
VKILL    ENDP

;        INFLATE VERB PROCESSOR

VINFL    PROC
         MOV   AL,NOUNNO
         CMP   AL,21              ;BOAT
         JE    VINFL_A
         CMP   AL,90              ;AIR
         LBNE  BADINP
VINFL_A:
         MOV   AL,21              ;DEFLATED BOAT
         CALL  HAVOBJ
         LBNE  DMSG073
         MOV   AL,NOUNNO
         CALL  CKOBJ
         JE    VINFL_B
         MOV   AL,14              ;PUMP
         CALL  HAVOBJ
         LBEQ  DMSG074
         MOV   AL,21              ;BOAT
         MOV   AH,93              ;INFLATED BOAT
         CALL  CHGOBJ
         CALL  CKDRAW
         JMP   REPLY
VINFL_B:
         MOV   AL,93              ;INFLATED BOAT
         CALL  CKOBJ
         LBEQ  NOSEE
         JMP   DMSG075
VINFL    ENDP

;        DEFLATE VERB PROCESSOR

VDEFL    PROC
         MOV   AL,NOUNNO
         CMP   AL,21              ;BOAT
         JE    VDEFL_A
         CMP   AL,90              ;AIR
         LBNE  BADINP
VDEFL_A:
         MOV   AL,21              ;DEFLATED BOAT
         CALL  LOCOBJ
         LBNE  DMSG078
         MOV   AL,93              ;INFLATED BOAT
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   AH,21              ;DEFLATED BOAT
         CALL  CHGOBJ
         MOV   AL,AH
         CALL  CKDRAW
         JMP   REPLY
VDEFL    ENDP

;        ACTIVATE VERB PROCESSOR

VACTIV   PROC
         MOV   AL,NOUNNO
         CMP   AL,93              ;ENERGIZER
         LBNE  BADINP
         MOV   AL,ROOM
         CMP   AL,6
         JE    VACTIV_A
         CMP   AL,7
         LBNE  DMSG023
VACTIV_A:
         INC   ENERSW
         JMP   DMSG054
VACTIV   ENDP

;        PRESS VERB PROCESSOR

VPRESS   PROC
         MOV   AL,NOUNNO
         CMP   AL,94              ;BUTTON
         LBNE  BADINP
         MOV   AL,ROOM
         CMP   AL,6
         JE    VPRESS_C
         CMP   AL,7
         JE    VPRESS_C
         CMP   AL,3
         LBNE  NOSEE
;
;        PROTECTION BELOW
;
         MOV   AL,PROTSW          ;CHECK FOR LEGAL COPY OF GAME
         CMP   AL,VALIDSW         ;  AND DISALLOW ENTRY TO
         LBNE  DMSG055            ;  PASSAGE IF NOT VALID
;
;        PROTECTION ABOVE
;
         MOV   AL,123             ;CABINET
         CALL  CKOBJ
         JE    VPRESS_A
         MOV   AH,124
         JMP   SHORT VPRESS_B
VPRESS_A:
         MOV   AL,124
         MOV   AH,123
VPRESS_B:
         CALL  CHGOBJ
         CALL  CKDRAW
         JMP   DMSG039
VPRESS_C:
         TEST  ENERSW,0FFH
         LBEQ  DMSG055
         DISABLE
         MOV   AH,4
VPRESS_D:
         MOV   AL,6
VPRESS_E:
         MOV   BX,OFFSET SCRTAB
         MOV   CH,0
         MOV   CL,AL
         ADD   BX,CX
         MOV   SI,WORD PTR [BX]
         CALL  SHOSCR
         DEC   AL
         DEC   AL
         JNS   VPRESS_E
         DEC   AH
         JNE   VPRESS_D
         ENABLE
         MOV   AL,ROOM
         XOR   AL,1
         JMP   EXITRM
VPRESS   ENDP

;        UNLIGHT VERB PROCESSOR

VUNLIT   PROC
         MOV   AL,NOUNNO
         CMP   AL,8               ;FLASHLIGHT
         LBNE  BADINP
         CALL  LOCOBJ
         JNE   VUNLIT_A
         MOV   AL,9               ;LIT FLASHLIGHT
         CALL  HAVOBJ
         LBEQ  NOHAVE
         MOV   AH,8
         CALL  REPOBJ
         MOV   LITESW,0
         CALL  INDARK
VUNLIT_A:
         JMP   DMSG086
VUNLIT   ENDP

;        LIGHT VERB PROCESSOR

VLIGHT   PROC
         MOV   AL,NOUNNO
         CMP   AL,8               ;FLASHLIGHT
         LBNE  BADINP
         MOV   AL,9               ;LIT FLASHLIGHT
         CALL  LOCOBJ
         JNE   VLIGHT_A
         MOV   AL,8               ;UNLIT FLASHLIGHT
         CALL  HAVOBJ
         LBEQ  NOHAVE
         TEST  LITECT,0FFH
         LBEQ  DMSG021
         CALL  INDARK
         PUSHF
         MOV   AL,8               ;UNLIT FLASHLIGHT
         MOV   AH,9               ;LIT FLASHLIGHT
         CALL  REPOBJ
         INC   LITESW
         POPF
         JNE   VLIGHT_A
         CALL  DRAWSC
VLIGHT_A:
         JMP   DMSG085
VLIGHT   ENDP

;        READ VERB PROCESSOR

VREAD    PROC
         MOV   AL,NOUNNO
         CMP   AL,125             ;SIGN
         JNE   VREAD_A
         MOV   AL,ROOM
         CMP   AL,4
         JNE   VREAD_B
         JMP   DMSG047
VREAD_A:
         CMP   AL,12              ;MANUAL
         LBNE  BADINP
         CALL  HAVOBJ
         LBEQ  NOHAVE
         MOV   AL,117             ;SPEAKER
         CALL  CKOBJ
         LBEQ  DMSG048
         JMP   DMSG053
VREAD_B:
         CMP   AL,19              ;IN SHACK
         JNE   VREAD_C
         MOV   AL,125             ;SIGN
         CALL  CKOBJ
         JE    VREAD_C
         JMP   DMSG101
VREAD_C:
         JMP   NOSEE
VREAD    ENDP

;        UNLOCK VERB PROCESSOR

VUNLOK   PROC
         MOV   AL,NOUNNO
         CMP   AL,126             ;DESK
         LBNE  BADINP
         CMP   ROOM,1
         LBNE  NOSEE
         TEST  DESKSW,0FFH
         JNE   VUNLOK_A
         MOV   AL,23              ;KEY
         CALL  HAVOBJ
         LBEQ  DMSG067
         INC   DESKSW
VUNLOK_A:
         JMP   DMSG019
VUNLOK   ENDP

;        TRADE VERB PROCESSOR

VTRADE   PROC
         TEST  NOUNNO,0FFH
         LBEQ  BADINP
         CALL  EQUOBJ
         CMP   ROOM,19
         LBNE  DMSG023
         MOV   AL,125             ;SIGN
         CALL  CKOBJ
         LBNE  DMSG032
         MOV   AL,NOUNNO
         CALL  HAVOBJ
         LBEQ  NOHAVE
         CMP   AL,10              ;RUG
         JE    VTRADE_A
         MOV   AL,10              ;RUG
         CALL  CKOBJ
         JE    VTRADE_B
         MOV   AL,NOUNNO
         CMP   AL,30              ;CLOSED CHEST
         JE    VTRADE_G
         CMP   AL,31              ;OPEN CHEST
         JE    VTRADE_G
VTRADE_B:
         MOV   BX,OFFSET MSG061
         CALL  DISPLY
         MOV   AL,10              ;RUG
         CALL  CKOBJ
         LBEQ  DMSG062
         MOV   AL,30              ;CLOSED CHEST
         CALL  CKOBJ
         JNE   VTRADE_E
         MOV   AL,31              ;OPEN CHEST
         CALL  CKOBJ
         LBEQ  DMSG063
VTRADE_E:
         JMP   REPLY
VTRADE_A:
         MOV   BX,OFFSET MSG064
         CALL  DISPLY
         INC   TRADSW
         JMP   VPUT
VTRADE_G:
         TEST  POTTSW,0FFH
         JNE   VTRADE_A
         DISABLE                  ;REMOVE DEVICE
         MOV   ROOM,8
         MOV   AL,122
         SUB   AH,AH
         CALL  CHGOBJ
         MOV   ROOM,19
         ENABLE
         JMP   SHORT VTRADE_A
VTRADE   ENDP

;        BAIL VERB PROCESSOR

VBAIL    PROC
         MOV   AL,ROOM
         CMP   AL,24
         JE    VBAIL_A
         CMP   AL,25
         LBNE  DMSG026
VBAIL_A:
         MOV   AL,15              ;BUCKET
         CALL  LOCOBJ
         LBEQ  DMSG032
         INC   BAILSW
         MOV   AL,101
         CALL  CKDRAW
         JMP   DMSG065
VBAIL    ENDP

;        ROW VERB PROCESSOR

VROW     PROC
         MOV   AL,19              ;PADDLES
         CALL  HAVOBJ
         LBEQ  DMSG090
         MOV   AL,ROOM
         CMP   AL,20
         JE    VROW_A
         CMP   AL,21
         JE    VROW_B
         CMP   AL,24
         JE    VROW_C
         CMP   AL,25
         JE    VROW_D
         JMP   DMSG089
VROW_A:
         MOV   AL,24
         JMP   SHORT VROW_E
VROW_B:
         MOV   AL,25
         JMP   SHORT VROW_E
VROW_C:
         MOV   AL,21
         JMP   SHORT VROW_E
VROW_D:
         MOV   AL,20
VROW_E:
         JMP   EXITRM
VROW     ENDP

;        DIG VERB PROCESSOR

VDIG     PROC
         MOV   AL,20              ;SHOVEL
         CALL  HAVOBJ
         LBEQ  DMSG096
         MOV   AL,29+INV          ;POTTERY
         CALL  MAKVIS
         JNE   VDIG_B
         MOV   AL,28+INV          ;CROWN
         CALL  MAKVIS
         LBEQ  REPLY
         CALL  CKDRAW
VDIG_A:
         JMP   DMSG011
VDIG_B:
         CALL  CKDRAW
         DISABLE                  ;RESTORE DEVICE
         MOV   ROOM,8
         MOV   AL,122
         SUB   AH,AH
         CALL  CHGOBJ
         CALL  PUTNRM
         MOV   ROOM,23
         ENABLE
         INC   POTTSW
         JMP   SHORT VDIG_A
VDIG     ENDP

;        GIVE VERB PROCESSOR

VGIVE    PROC
         CMP   NOUNNO,13          ;JEWELS
         LBNE  BADINP
         MOV   AL,102             ;NATIVES
         CALL  CKOBJ
         LBEQ  DMSG099
         JMP   PUT04
VGIVE    ENDP

;        OPEN VERB PROCESSOR

VOPEN    PROC
         MOV   AL,NOUNNO
         CMP   AL,120             ;TRAP DOOR
         LBNE  BADINP
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   AL,119             ;LADDER
         CALL  CKOBJ
         JE    VOPEN_A
         MOV   BX,OFFSET MSG028
         CALL  DISPLY
         JMP   DMSG018
VOPEN_A:
         MOV   AL,119+INV         ;LADDER
         CALL  MAKVIS
         CALL  CKDRAW
         JMP   DMSG011
VOPEN    ENDP

;        OPEN CHEST

OPEN01   PROC
         MOV   AL,31              ;OPEN CHEST
         CALL  LOCOBJ
         JE    OPEN01_B
         MOV   BX,OFFSET MSG028
         CALL  DISPLY
OPEN01_A:
         JMP   DMSG018
OPEN01_B:
         MOV   AL,30              ;CLOSED CHEST
         CALL  HAVOBJ
         JE    OPEN01_C
         MOV   AH,31              ;OPEN CHEST
         CALL  REPOBJ
         JMP   SHORT OPEN01_D
OPEN01_C:
         MOV   AL,30
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   AH,31
         CALL  CHGOBJ
         CALL  CKDRAW
OPEN01_D:
         INC   CHSTSW
         JMP   SHORT OPEN01_A
OPEN01   ENDP

;        OPEN DESK

OPEN02   PROC
         MOV   AL,94              ;OPEN DESK
         CALL  CKOBJ
         JNE   OPEN02_A
         MOV   AL,126             ;CLOSED DESK
         CALL  CKOBJ
         LBEQ  NOSEE
         TEST  DESKSW,0FFH
         LBEQ  DMSG017
         MOV   AL,126
         MOV   AH,94
         CALL  CHGOBJ
         MOV   AL,AH
         CALL  CKDRAW
OPEN02_A:
         JMP   DMSG018
OPEN02   ENDP

;        SPECIAL GET ROUTINE FOR IN SHACK

GETSHA   PROC
         CMP   ROOM,19
         JNE   GETSHA_C
         MOV   AL,125             ;SIGN
         CALL  CKOBJ
         JNE   GETSHA_C
         CALL  EQUOBJ
         TEST  TRADSW,0FFH
         JNE   GETSHA_B
         MOV   AL,NOUNNO
         CMP   AL,128             ;IS IT GET ALL?
         JE    GETSHA_A
         CALL  HAVOBJ
         JNE   GETSHA_C
         MOV   AL,NOUNNO
         CALL  CKOBJ
         JE    GETSHA_C
GETSHA_A:
         JMP   DMSG059
GETSHA_B:
         MOV   AL,NOUNNO
         CMP   AL,128             ;IS IT GET ALL?
         LBEQ  DMSG060
         CALL  HAVOBJ
         JNE   GETSHA_C
         MOV   AL,NOUNNO
         CALL  CKOBJ
         JE    GETSHA_C
         MOV   TRADSW,0
GETSHA_C:
         JMP   VGET
GETSHA   ENDP

;        CHECK FOR IN DARK AREA

INDARK   PROC
         PUSH  BX
         MOV   AL,ROOM
         CMP   AL,3
         JE    INDARK_A
         CMP   AL,4
         JE    INDARK_A
         CMP   AL,11
         JB    INDARK_B
         CMP   AL,14
         JA    INDARK_B
INDARK_A:
         MOV   AL,9               ;LIT FLASHLIGHT
         CALL  LOCOBJ
         JNE   INDARK_B
         MOV   SI,OFFSET SCRBLK
         CALL  SHOSCR
         CALL  CLSTXT
         MOV   BX,OFFSET MSG084
         CALL  DISPLY
         MOV   AL,0
         JMP   SHORT INDARK_C
INDARK_B:
         MOV   AL,1
INDARK_C:
         POP   BX
         TEST  AL,0FFH
         RET
INDARK   ENDP

;        CHECK EACH ITEM OF A PUT ALL

CHKPA    PROC
         TEST  AL,0FFH
         RET
CHKPA    ENDP

;        CHECK EACH ITEM OF A GET ALL

CHKGA    PROC
         PUSH  AX
         CMP   AL,26              ;MICE
         JNE   CHKGA_A
         MOV   AL,16              ;MOUSETRAP
         CALL  HAVOBJ
         JE    CHKGA_X
         JMP   SHORT CHKGA_Y
CHKGA_A:
         CMP   AL,32              ;RUG OVER TRAP DOOR
         JE    CHKGA_X
         CMP   AL,19              ;PADDLES
         JNE   CHKGA_Y
         MOV   AL,112             ;SNAKE
         CALL  CKOBJ
         JE    CHKGA_Y
CHKGA_X:
         POP   AX
         MOV   AL,0
         JMP   SHORT CHKGA_Z
CHKGA_Y:
         POP   AX
CHKGA_Z:
         TEST  AL,0FFH
         RET
CHKGA    ENDP

;        ROUTINE PERFORMED AFTER EACH MOVE

ECHMOV   PROC
         PUSH  AX
         PUSH  BX
         PUSH  SI
         TEST  LITECT,0FFH
         JE    ECHMOV_D
         TEST  LITESW,0FFH
         JE    ECHMOV_D
         MOV   AL,LITECT
         CMP   AL,19
         JA    ECHMOV_C
         SUB   AH,AH
         MOV   BX,AX
         MOV   SI,OFFSET MSG025B
         CALL  ASCLNO
         CALL  SUPRES
         MOV   AX,WORD PTR MSG025B+3
         MOV   WORD PTR MSG087A,AX
         MOV   BX,OFFSET MSG087
         CALL  DISPLY
ECHMOV_C:
         DEC   LITECT
         JNE   ECHMOV_D
         MOV   AL,9               ;LIT FLASHLIGHT
         MOV   AH,8               ;UNLITFLASH
         CALL  XCHGOB
         MOV   LITESW,0
         CALL  INDARK
ECHMOV_D:
         POP   SI
         POP   BX
         POP   AX
         RET
ECHMOV   ENDP

;        IN ROOM ROUTINES

INRM01   PROC
         PUSH  BX
         TEST  FIRST1,0FFH
         JNE   INRM01_A
         INC   FIRST1
         MOV   BX,OFFSET MSG057
         CALL  DISPLY
INRM01_A:
         POP   BX
         RET
INRM01   ENDP

;        ROOM 06

INRM06   PROC
         PUSH  AX
         PUSH  BX
         MOV   AL,RANDOM
         AND   AL,07FH
         CMP   AL,35
         JA    INRM06_A
         MOV   BX,OFFSET MSG056
         CALL  DISPLY
INRM06_A:
         POP   BX
         POP   AX
         RET
INRM06   ENDP

;        ROOM 24

INRM24   PROC
         TEST  BAILSW,0FFH
         JNE   INRM24_A
         MOV   BX,OFFSET MSG092
         JMP   DEAD1
INRM24_A:
         RET
INRM24   ENDP

;        ENTER ROOM ROUTINES

;        ROOM 03

ENTR03   PROC
         PUSH  AX
         PUSH  BX
         MOV   AL,9               ;LIT FLASHLIGHT
         CALL  LOCOBJ
         JNE   ENTR03_A
         MOV   AL,RANDOM
         AND   AL,07FH
         CMP   AL,50
         JA    ENTR03_A
         MOV   BX,OFFSET MSG102
         CALL  DISPLY
ENTR03_A:
         POP   BX
         POP   AX
         RET
ENTR03   ENDP

;        ROOM 06

ENTR06   PROC
         MOV   ENERSW,0
         JMP   SHORT INRM06
ENTR06   ENDP

;        ROOM 15

ENTR15   PROC
         PUSH  AX
         MOV   AL,17              ;BOOTS
         CALL  HAVOBJ
         JNE   ENTR15_A
         MOV   BX,OFFSET MSG083
         JMP   DEAD1
ENTR15_A:
         POP   AX
         RET
ENTR15   ENDP

;        ROOM 19

ENTR19   PROC
         PUSH  AX
         PUSH  BX
         MOV   TRADSW,0
         MOV   AL,125             ;SIGN
         CALL  CKOBJ
         JNE   ENTR19_A
         MOV   BX,OFFSET MSG058
         CALL  DISPLY
ENTR19_A:
         POP   BX
         POP   AX
         RET
ENTR19   ENDP

;        ROOM 23

ENTR23   PROC
         PUSH  AX
         DISABLE
         MOV   ROOM,22
         MOV   AL,102             ;NATIVES
         CALL  PUTNRM
         MOV   AL,93              ;INFLATED BOAT
         CALL  CKOBJ
         JE    ENTR23_Z
         MOV   AL,93
         MOV   AH,21
         CALL  CHGOBJ
         MOV   AL,21
         MOV   AH,22
         CALL  CPYOBJ
ENTR23_Z:
         MOV   ROOM,23
         ENABLE
         POP   AX
         RET
ENTR23   ENDP

;        ROOM 24

ENTR24   PROC
         PUSH  AX
         PUSH  BX
         MOV   BAILSW,0
         DISABLE
         MOV   AL,40
         CALL  SHOOVL
         ENABLE
         MOV   BX,OFFSET MSG091
         CALL  DISPLY
         POP   BX
         POP   AX
         RET
ENTR24   ENDP

;        EXIT ROOM ROUTINES

;        ROOM 03

EXIT03   PROC
         PUSH  AX
         MOV   AL,9               ;LIT FLASHLIGHT
         CALL  LOCOBJ
         JNE   EXIT03_A
         MOV   AL,RANDOM
         AND   AL,07FH
         CMP   AL,40
         JA    EXIT03_A
         MOV   BX,OFFSET MSG103
         JMP   DEAD1
EXIT03_A:
         POP   AX
         RET
EXIT03   ENDP

;        ROOM 06

EXIT06   PROC
         PUSH  AX
         CMP   AH,6
         JB    EXIT06_A
         CMP   AH,7
         JA    EXIT06_A
         MOV   AL,ROOM
         CALL  XFROBJ
EXIT06_A:
         POP   AX
         RET
EXIT06   ENDP

;        ROOM 19

EXIT19   PROC
         PUSH  AX
         MOV   AL,125             ;SIGN
         CALL  CKOBJ
         JNE   EXIT19_A
         MOV   AL,23              ;KEYS
         CALL  CKOBJ
         JNE   EXIT19_A
         MOV   AL,24              ;MACHETE
         CALL  CKOBJ
         JNE   EXIT19_A
         MOV   AL,ROOM
         CALL  CLROBJ
         MOV   AL,110             ;TRADER JACK
         MOV   AH,125             ;SIGN
         CALL  CHGOBJ
EXIT19_A:
         POP   AX
         RET
EXIT19   ENDP

;        ROOM 22

EXIT22   PROC
         PUSH  AX
         CMP   AH,23
         JNE   EXIT22_A
         MOV   AL,102             ;NATIVES
         CALL  CKOBJ
         JE    EXIT22_A
         JMP   DMSG098
EXIT22_A:
         POP   AX
         RET
EXIT22   ENDP

;        ROOM 24

EXIT24   PROC
         TEST  BAILSW,0FFH
         JNE   EXBOAT
         MOV   BX,OFFSET MSG092
         JMP   DEAD1
EXIT24   ENDP

;        EXIT FROM BOAT

EXBOAT   PROC
         PUSH  AX
         CMP   AH,18
         JE    EXBOAT_A
         CMP   AH,22
         JE    EXBOAT_A
         MOV   AL,ROOM
         CALL  XFROBJ
EXBOAT_A:
         POP   AX
         RET
EXBOAT   ENDP

;        ANIMATION ROUTINES

;        MOVE CLOUDS IN SKY

MOVCLO   PROC
         INC   FLIPCT
         CMP   FLIPCT,2
         JB    MOVCLO_A
         MOV   FLIPCT,0
         CALCX 9,1
         CALCD 9,1,21,128
         CALL  SCRLFT
MOVCLO_A:
         RET
MOVCLO   ENDP

;        MOVE LASER IN LAB

MOVLSR   PROC
         INC   FLIPCT
         CMP   FLIPCT,2
         JB    MOVLSR_A
         MOV   FLIPCT,0
         CALCX 46,57
         CALCD 46,57,47,80
         CALL  SCRRIT
         INC   CLRSW
         CMP   CLRSW,4
         JB    MOVLSR_A
         MOV   CLRSW,0
         MOV   AL,44              ;SPRING UP OVERLAY
         XOR   FLIPSW,1
         JE    MOVLSR_B
         MOV   AL,46              ;SPRING DOWN OVERLAY
MOVLSR_B:
         CALL  SHOOVL
MOVLSR_A:
         RET
MOVLSR   ENDP

;        BLINK LIGHTS IN DEVICE

MOVLIT   PROC
         INC   FLIPCT
         CMP   FLIPCT,10
         JB    MOVLIT_A
         MOV   FLIPCT,0
         MOV   AL,RANDOM
         PUSH  AX
         AND   AL,3
         MOV   COLOR1,AL
         POP   AX
         MOV   CL,3
         SHR   AL,CL
         AND   AL,3
         CMP   AL,COLOR1
         JNE   MOVLIT_B
         INC   AL
         AND   AL,3
MOVLIT_B:
         MOV   COLOR2,AL
         CALCX 53,33
         CALCD 53,33,54,92
         CALL  FLPCLR
MOVLIT_A:
         RET
MOVLIT   ENDP

;        MOVE SNAKES TAIL

MOVSNK   PROC
         MOV   AL,9               ;LIT FLASHLIGHT
         CALL  LOCOBJ
         JE    MOVSNK_C
         MOV   AL,112             ;SNAKE
         CALL  CKOBJ
         JE    MOVSNK_C
         INC   FLIPCT
         CMP   FLIPCT,3
         JB    MOVSNK_C
         MOV   FLIPCT,0
         XOR   FLIPSW,1
         JE    MOVSNK_A
         MOV   AL,123             ;LEFT SNAKES TAIL
         JMP   SHORT MOVSNK_B
MOVSNK_A:
         MOV   AL,124             ;RIGHT SNAKES TAIL
MOVSNK_B:
         CALL  SHOOVL
MOVSNK_C:
         RET
MOVSNK   ENDP

;        MOVE CLOCK IN STUDY

MOVCLK   PROC
         INC   FLIPCT
         CMP   FLIPSW,0
         JE    MOVCLK_F
         CMP   FLIPSW,2
         JE    MOVCLK_F
         CMP   FLIPCT,7
         JB    MOVCLK_D
MOVCLK_G:
         MOV   FLIPCT,0
         INC   FLIPSW
         CMP   FLIPSW,1
         JNE   MOVCLK_A
         MOV   AL,122
         JMP   SHORT MOVCLK_C
MOVCLK_A:
         CMP   FLIPSW,3
         JNE   MOVCLK_B
         MOV   AL,121
         JMP   SHORT MOVCLK_C
MOVCLK_B:
         CMP   FLIPSW,2
         JE    MOVCLK_E
         MOV   FLIPSW,0
MOVCLK_E:
         MOV   AL,120
MOVCLK_C:
         CALL  SHOOVL
MOVCLK_D:
         RET
MOVCLK_F:
         CMP   FLIPCT,4
         JB    MOVCLK_D
         JMP   SHORT MOVCLK_G
MOVCLK   ENDP

;
;        END FILE: ADVCODE2.ASM   --   CALIXTO ISLAND
;
