
;              FILE = ADVEQU.ASM  LAST MODIFIED: 11/03/84

;
;                EQUATES TO DEFINE PIXEL COLORS
;
BLACK    EQU  00B
BLUE     EQU  01B
RED      EQU  10B
WHITE    EQU  11B

BLACK@B  EQU  BLACK*64+BLACK*16+BLACK*4+BLACK
BLUE@B   EQU  BLUE*64+BLUE*16+BLUE*4+BLUE
RED@B    EQU  RED*64+RED*16+RED*4+RED
WHITE@B  EQU  WHITE*64+WHITE*16+WHITE*4+WHITE

BLACK@W  EQU  BLACK@B*256+BLACK@B
BLUE@W   EQU  BLUE@B*256+BLUE@B
RED@W    EQU  RED@B*256+RED@B
WHITE@W  EQU  WHITE@B*256+WHITE@B

;        GENERAL GAME CONTROL EQUATES

MAXWRD   EQU  4                   ;VERB/NOUN COMPARE LENGTH
MVOBMX   EQU  2                   ;MAX # OF MOVABLE OVERLAYS PER OBJECT
RMSIZE   EQU  6                   ;SIZE OF A ROOM TABLE ENTRY
INV      EQU  80H                 ;OBJECT INVISABLE ATTRIBUTE
SPC      EQU  80H                 ;SPACE AFTER CHARACTER ATTRIBUTE
MAXLINE  EQU  40-1                ;MAX CHARACTERS ON A DISPLAY LINE
R$PNTS   EQU  0                   ;SET TO 1 TO ENABLE TREASURE POINTS
ADVMARK  EQU  0A5H                ;MARKER USED FOR SAVE FILES
QUOTE    EQU  27H                 ;SINGLE QUOTE HEX CODE

;        DEFINE COMPRESSED PHRASE CODES

C$THE    EQU  080H
C$SMAL   EQU  081H
C$ARE    EQU  082H
C$SEE    EQU  083H
C$CANT   EQU  084H
C$DONT   EQU  085H
C$LARG   EQU  086H
C$IM     EQU  087H
C$INA    EQU  088H
C$ONA    EQU  089H
C$ISA    EQU  08AH
C$IITS   EQU  08BH
C$TTHE   EQU  08CH
C$IS     EQU  08DH
C$AND    EQU  08EH
C$AN     EQU  08FH
C$AT     EQU  090H
C$OF     EQU  091H
C$ITSA   EQU  092H
C$TREK   EQU  093H
C$TO     EQU  094H
C$MY     EQU  095H
C$IN     EQU  096H

;              END FILE = ADVEQU.ASM
